# generated by datamodel-codegen:
#   filename:  image-layout-schema.json
#   timestamp: 2024-12-04T11:33:36+00:00

from __future__ import annotations

from enum import Enum
from pathlib import Path

from pydantic import BaseModel, Field


class ImageLayoutVersion(Enum):
    field_1_0_0 = '1.0.0'


class OCIImageLayout(BaseModel):
    imageLayoutVersion: ImageLayoutVersion = Field(
        ..., description='version of the OCI Image Layout (in the oci-layout file)'
    )

    class Config:
        use_enum_values = True

def verify_ocilayout(ocilayout: Path):
    with open(ocilayout / "oci-layout", "r") as f:
        m = OCIImageLayout.model_validate_json(f.read())
        if not m.imageLayoutVersion == ImageLayoutVersion.field_1_0_0.value:
            raise ValueError(f"Unexpected ocilayout in {ocilayout}")
        else:
            return True

def create_ocilayout() -> OCIImageLayout:
    return OCIImageLayout(imageLayoutVersion=ImageLayoutVersion.field_1_0_0)