# generated by datamodel-codegen using https://github.com/modelpack/model-spec/blob/8f6beb752394e5c6653cfcb3d2cd21950296dfac/schema/config-schema.json
#   filename:  config-schema.json
#   timestamp: 2025-07-04T09:20:40+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field


class ModelDescriptor(BaseModel):
    model_config = ConfigDict(extra='forbid')

    createdAt: Optional[datetime] = None
    authors: Optional[List[str]] = None
    family: Optional[str] = None
    name: Optional[str] = Field(None, min_length=1)
    docURL: Optional[str] = None
    sourceURL: Optional[str] = None
    version: Optional[str] = None
    revision: Optional[str] = None
    vendor: Optional[str] = None
    licenses: Optional[List[str]] = None
    title: Optional[str] = None
    description: Optional[str] = None


class Type(Enum):
    layers = 'layers'


class ModelFS(BaseModel):
    model_config = ConfigDict(extra='forbid')

    type: Type
    diffIds: List[str] = Field(..., min_length=1)


class Modality(Enum):
    text = 'text'
    image = 'image'
    audio = 'audio'
    video = 'video'
    embedding = 'embedding'
    other = 'other'


class ModelCapabilities(BaseModel):
    inputTypes: Optional[List[Modality]] = None
    outputTypes: Optional[List[Modality]] = None
    knowledgeCutoff: Optional[datetime] = None
    reasoning: Optional[bool] = None
    toolUsage: Optional[bool] = None


class ModelConfig(BaseModel):
    model_config = ConfigDict(extra='forbid')

    architecture: Optional[str] = None
    format: Optional[str] = None
    paramSize: Optional[str] = None
    precision: Optional[str] = None
    quantization: Optional[str] = None
    capabilities: Optional[ModelCapabilities] = None


class Model(BaseModel):
    model_config = ConfigDict(extra='forbid')

    descriptor: ModelDescriptor
    modelfs: ModelFS
    config: ModelConfig
