This package contains functions to calculate Economic Complexity indicators.  
The functions handle the data through `pandas.DataFrame` objects.

<p>
<a href="https://github.com/Datawheel/py-economic-complexity"><img src="https://flat.badgen.net/github/release/Datawheel/py-economic-complexity" /></a>
<a href="https://github.com/Datawheel/py-economic-complexity/blob/master/LICENSE"><img src="https://flat.badgen.net/github/license/Datawheel/py-economic-complexity" /></a>
<a href="https://github.com/Datawheel/py-economic-complexity/"><img src="https://flat.badgen.net/github/checks/Datawheel/py-economic-complexity" /></a>
<a href="https://github.com/Datawheel/py-economic-complexity/issues"><img src="https://flat.badgen.net/github/issues/Datawheel/py-economic-complexity" /></a>
</p>

## Installation

We recommend the use of `poetry`, to resolve the best version of the dependencies that works with your current project.

```bash
$ poetry add economic-complexity
```

## Tutorial

We have [a brief Tutorial](https://github.com/Datawheel/py-economic-complexity/blob/main/docs/TUTORIAL.ipynb), using data from the Observatory of Economic Complexity, to get started on how to use the basic functions of this package.  
More complex functions use the resulting dataframes of the basic functions as arguments.

## References

* Hidalgo, César A. (2021). Economic complexity theory and applications. _Nature Reviews Physics, 3_(2), 92–113. https://doi.org/10.1038/s42254-020-00275-1

* Catalán, P., Navarrete, C., & Figueroa, F. (2020). The scientific and technological cross-space: Is technological diversification driven by scientific endogenous capacity? _Research Policy, 104016_, 104016. https://doi.org/10.1016/j.respol.2020.104016

* Hidalgo, César A., & Hausmann, R. (2009). The building blocks of economic complexity. _Proceedings of the National Academy of Sciences of the United States of America, 106_(26), 10570–10575. https://doi.org/10.1073/pnas.0900943106

* Hidalgo, C. A., Klinger, B., Barabási, A.-L., & Hausmann, R. (2007). The product space conditions the development of nations. _Science (New York, N.Y.), 317_(5837), 482–487. https://doi.org/10.1126/science.1144581

* Hartmann, D., Guevara, M. R., Jara-Figueroa, C., Aristarán, M., & Hidalgo, C. A. (2017). Linking Economic Complexity, Institutions, and Income Inequality. _World Development_, 93, 75–93. https://doi.org/10.1016/j.worlddev.2016.12.020

* Romero, J. P., & Gramkow, C. (2021). Economic complexity and greenhouse gas emissions. _World Development_, 139, 105317. https://doi.org/10.1016/j.worlddev.2020.105317

* Bahar, D., Hausmann, R., Hidalgo, C. A. (2014). Neighbors and the evolution of the comparative advantage of nations: Evidence of international knowledge diffusion?. _Journal of International Economics_, 92, 111-123. http://dx.doi.org/10.1016/j.jinteco.2013.11.001

---
&copy; 2022 [Datawheel, LLC.](https://www.datawheel.us/)  
This project is licensed under [MIT](./LICENSE).
