"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustBoundaryType = exports.TrustBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class TrustBoundary extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.tags = props.tags;
        this.technicalAssetsInside = new Set();
        this.trustBoundariesNested = new Set();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
    }
    addTechnicalAssets(...assets) {
        assets.forEach((a) => {
            this.technicalAssetsInside.add(a.uuid);
        });
    }
    addTrustBoundary(boundary) {
        this.trustBoundariesNested.add(boundary.uuid);
    }
    isWithinCloud() {
        return [
            TrustBoundaryType.NETWORK_CLOUD_PROVIDER,
            TrustBoundaryType.NETWORK_CLOUD_SECURITY_GROUP,
        ].includes(this.type);
    }
    isNetworkBoundary() {
        return [
            TrustBoundaryType.NETWORK_ON_PREM,
            TrustBoundaryType.NETWORK_DEDICATED_HOSTER,
            TrustBoundaryType.NETWORK_VIRTUAL_LAN,
            TrustBoundaryType.NETWORK_CLOUD_PROVIDER,
            TrustBoundaryType.NETWORK_CLOUD_SECURITY_GROUP,
            TrustBoundaryType.NETWORK_POLICY_NAMESPACE_ISOLATION,
        ].includes(this.type);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                tags: Array.from(new Set(this.tags)),
                technical_assets_inside: Array.from(this.technicalAssetsInside),
                trust_boundaries_nested: Array.from(this.trustBoundariesNested),
            },
        };
    }
}
exports.TrustBoundary = TrustBoundary;
_a = JSII_RTTI_SYMBOL_1;
TrustBoundary[_a] = { fqn: "cdktg.TrustBoundary", version: "0.0.29" };
var TrustBoundaryType;
(function (TrustBoundaryType) {
    TrustBoundaryType["NETWORK_ON_PREM"] = "network-on-prem";
    TrustBoundaryType["NETWORK_DEDICATED_HOSTER"] = "network-dedicated-hoster";
    TrustBoundaryType["NETWORK_VIRTUAL_LAN"] = "network-virtual-lan";
    TrustBoundaryType["NETWORK_CLOUD_PROVIDER"] = "network-cloud-provider";
    TrustBoundaryType["NETWORK_CLOUD_SECURITY_GROUP"] = "network-cloud-security-group";
    TrustBoundaryType["NETWORK_POLICY_NAMESPACE_ISOLATION"] = "network-policy-namespace-isolation";
    TrustBoundaryType["EXECUTION_ENVIRONMENT"] = "execution-environment";
})(TrustBoundaryType = exports.TrustBoundaryType || (exports.TrustBoundaryType = {}));
//# sourceMappingURL=data:application/json;base64,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