"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? scope_1.Scope.inScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.customDevelopedParts = props.customDevelopedParts ?? false;
        this.dataFormatsAccepted = props.dataFormatsAccepted;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    processes(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    stores(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    isWebApplication() {
        return [
            Technology.WEB_SERVER,
            Technology.WEB_APPLICATION,
            Technology.APPLICATION_SERVER,
            Technology.ERP,
            Technology.CMS,
            Technology.IDENTITIY_PROVIDER,
            Technology.REPORT_ENGINE,
        ].includes(this.technology);
    }
    isWebService() {
        return [Technology.WEB_SERVICE_REST, Technology.WEB_SERVICE_SOAP].includes(this.technology);
    }
    communicatesWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            caller: this,
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                custom_developed_parts: this.customDevelopedParts,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
                data_formats_accepted: this.dataFormatsAccepted,
            },
        };
        threagile[this.node.id].communication_links = this.communications.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.29" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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