/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */
/**
 * Agile Threat Modeling
 */
export interface Threagile {
    /**
     * Version of the Threagile toolkit
     */
    threagile_version: string;
    /**
     * Title of the model
     */
    title: string;
    /**
     * Date of the model
     */
    date?: string | null;
    /**
     * Author of the model
     */
    author: {
        /**
         * Author name
         */
        name: string | null;
        /**
         * Author homepage
         */
        homepage?: string | null;
        [k: string]: unknown;
    };
    /**
     * Individual management summary for the report
     */
    management_summary_comment?: string | null;
    /**
     * Business criticality of the target
     */
    business_criticality: "archive" | "operational" | "important" | "critical" | "mission-critical";
    /**
     * Individual business overview for the report
     */
    business_overview?: {
        /**
         * Individual business overview for the report
         */
        description?: string | null;
        /**
         * Custom images for the report
         */
        images?: unknown[] | null;
        [k: string]: unknown;
    };
    /**
     * Individual technical overview for the report
     */
    technical_overview?: {
        /**
         * Individual technical overview for the report
         */
        description?: string | null;
        /**
         * Custom images for the report
         */
        images?: unknown[] | null;
        [k: string]: unknown;
    };
    /**
     * Custom questions for the report
     */
    questions?: {
        [k: string]: unknown;
    } | null;
    /**
     * Custom abuse cases for the report
     */
    abuse_cases?: {
        [k: string]: unknown;
    } | null;
    /**
     * Custom security requirements for the report
     */
    security_requirements?: {
        [k: string]: unknown;
    } | null;
    /**
     * Tags available
     */
    tags_available: string[] | null;
    /**
     * Data assets
     */
    data_assets: {
        [k: string]: {
            /**
             * ID
             */
            id: string;
            /**
             * Description
             */
            description: string | null;
            /**
             * Usage
             */
            usage: "business" | "devops";
            /**
             * Tags
             */
            tags?: string[] | null;
            /**
             * Origin
             */
            origin?: string | null;
            /**
             * Owner
             */
            owner?: string | null;
            /**
             * Quantity
             */
            quantity: "very-few" | "few" | "many" | "very-many";
            /**
             * Confidentiality
             */
            confidentiality: "public" | "internal" | "restricted" | "confidential" | "strictly-confidential";
            /**
             * Integrity
             */
            integrity: "archive" | "operational" | "important" | "critical" | "mission-critical";
            /**
             * Availability
             */
            availability: "archive" | "operational" | "important" | "critical" | "mission-critical";
            /**
             * Justification of the rating
             */
            justification_cia_rating?: string | null;
            [k: string]: unknown;
        };
    };
    /**
     * Technical assets
     */
    technical_assets: {
        [k: string]: {
            /**
             * ID
             */
            id?: string;
            /**
             * Description
             */
            description?: string | null;
            /**
             * Type
             */
            type?: "external-entity" | "process" | "datastore";
            /**
             * Usage
             */
            usage?: "business" | "devops";
            /**
             * Used as client by human
             */
            used_as_client_by_human?: boolean;
            /**
             * Out of scope
             */
            out_of_scope?: boolean;
            /**
             * Justification of out of scope
             */
            justification_out_of_scope?: string | null;
            /**
             * Size
             */
            size?: "system" | "service" | "application" | "component";
            /**
             * Technology
             */
            technology?: "unknown-technology" | "client-system" | "browser" | "desktop" | "mobile-app" | "devops-client" | "web-server" | "web-application" | "application-server" | "database" | "file-server" | "local-file-system" | "erp" | "cms" | "web-service-rest" | "web-service-soap" | "ejb" | "search-index" | "search-engine" | "service-registry" | "reverse-proxy" | "load-balancer" | "build-pipeline" | "sourcecode-repository" | "artifact-registry" | "code-inspection-platform" | "monitoring" | "ldap-server" | "container-platform" | "batch-processing" | "event-listener" | "identity-provider" | "identity-store-ldap" | "identity-store-database" | "tool" | "cli" | "task" | "function" | "gateway" | "iot-device" | "message-queue" | "stream-processing" | "service-mesh" | "data-lake" | "report-engine" | "ai" | "mail-server" | "vault" | "hsm" | "waf" | "ids" | "ips" | "scheduler" | "mainframe" | "block-storage" | "library";
            /**
             * Tags
             */
            tags?: string[] | null;
            /**
             * Internet
             */
            internet?: boolean;
            /**
             * Machine
             */
            machine?: "physical" | "virtual" | "container" | "serverless";
            /**
             * Encryption
             */
            encryption?: "none" | "transparent" | "data-with-symmetric-shared-key" | "data-with-asymmetric-shared-key" | "data-with-enduser-individual-key";
            /**
             * Owner
             */
            owner?: string | null;
            /**
             * Confidentiality
             */
            confidentiality?: "public" | "internal" | "restricted" | "confidential" | "strictly-confidential";
            /**
             * Integrity
             */
            integrity?: "archive" | "operational" | "important" | "critical" | "mission-critical";
            /**
             * Availability
             */
            availability?: "archive" | "operational" | "important" | "critical" | "mission-critical";
            /**
             * Justification of the rating
             */
            justification_cia_rating?: string | null;
            /**
             * Multi tenant
             */
            multi_tenant?: boolean;
            /**
             * Redundant
             */
            redundant?: boolean;
            /**
             * Custom developed parts
             */
            custom_developed_parts?: boolean;
            /**
             * Data assets processed
             */
            data_assets_processed?: string[] | null;
            /**
             * Data assets stored
             */
            data_assets_stored?: string[] | null;
            /**
             * Data formats accepted
             */
            data_formats_accepted?: ("json" | "xml" | "serialization" | "file" | "csv")[] | null;
            /**
             * diagram tweak order (affects left to right positioning)
             */
            diagram_tweak_order?: number;
            /**
             * Communication links
             */
            communication_links?: {
                [k: string]: {
                    /**
                     * Target
                     */
                    target: string;
                    /**
                     * Description
                     */
                    description: string | null;
                    /**
                     * Protocol
                     */
                    protocol: "unknown-protocol" | "http" | "https" | "ws" | "wss" | "reverse-proxy-web-protocol" | "reverse-proxy-web-protocol-encrypted" | "mqtt" | "jdbc" | "jdbc-encrypted" | "odbc" | "odbc-encrypted" | "sql-access-protocol" | "sql-access-protocol-encrypted" | "nosql-access-protocol" | "nosql-access-protocol-encrypted" | "binary" | "binary-encrypted" | "text" | "text-encrypted" | "ssh" | "ssh-tunnel" | "smtp" | "smtp-encrypted" | "pop3" | "pop3-encrypted" | "imap" | "imap-encrypted" | "ftp" | "ftps" | "sftp" | "scp" | "ldap" | "ldaps" | "jms" | "nfs" | "smb" | "smb-encrypted" | "local-file-access" | "nrpe" | "xmpp" | "iiop" | "iiop-encrypted" | "jrmp" | "jrmp-encrypted" | "in-process-library-call" | "container-spawning";
                    /**
                     * Authentication
                     */
                    authentication: "none" | "credentials" | "session-id" | "token" | "client-certificate" | "two-factor" | "externalized";
                    /**
                     * Authorization
                     */
                    authorization: "none" | "technical-user" | "enduser-identity-propagation";
                    /**
                     * Tags
                     */
                    tags?: string[] | null;
                    /**
                     * VPN
                     */
                    vpn: boolean;
                    /**
                     * IP filtered
                     */
                    ip_filtered: boolean;
                    /**
                     * readonly
                     */
                    readonly: boolean;
                    /**
                     * Usage
                     */
                    usage: "business" | "devops";
                    /**
                     * Data assets sent
                     */
                    data_assets_sent: string[] | null;
                    /**
                     * Data assets received
                     */
                    data_assets_received: string[] | null;
                    /**
                     * diagram tweak weight
                     */
                    diagram_tweak_weight?: number;
                    /**
                     * diagram tweak constraint
                     */
                    diagram_tweak_constraint?: boolean;
                    [k: string]: unknown;
                };
            } | null;
            required?: ["id", "description", "type", "usage", "used_as_client_by_human", "out_of_scope", "size", "technology", "internet", "machine", "encryption", "owner", "confidentiality", "integrity", "availability", "multi_tenant", "redundant", "custom_developed_parts", "data_assets_processed", "data_assets_stored", "data_formats_accepted", "communication_links"];
            [k: string]: unknown;
        };
    };
    /**
     * Trust boundaries
     */
    trust_boundaries?: {
        [k: string]: {
            /**
             * ID
             */
            id: string;
            /**
             * Description
             */
            description: string | null;
            /**
             * Type
             */
            type: "network-on-prem" | "network-dedicated-hoster" | "network-virtual-lan" | "network-cloud-provider" | "network-cloud-security-group" | "network-policy-namespace-isolation" | "execution-environment";
            /**
             * Tags
             */
            tags?: string[] | null;
            /**
             * Technical assets inside
             */
            technical_assets_inside: string[] | null;
            /**
             * Trust boundaries nested
             */
            trust_boundaries_nested: string[] | null;
            [k: string]: unknown;
        };
    };
    /**
     * Shared runtimes
     */
    shared_runtimes: {
        [k: string]: {
            /**
             * ID
             */
            id: string;
            /**
             * Description
             */
            description: string | null;
            /**
             * Tags
             */
            tags?: string[] | null;
            /**
             * Technical assets running
             */
            technical_assets_running: string[] | null;
            [k: string]: unknown;
        };
    };
    /**
     * Individual risk categories
     */
    individual_risk_categories?: {
        [k: string]: {
            /**
             * ID
             */
            id: string;
            /**
             * Description
             */
            description: string | null;
            /**
             * Impact
             */
            impact: string;
            /**
             * ASVS
             */
            asvs: string;
            /**
             * Cheat sheet
             */
            cheat_sheet: string;
            /**
             * Action
             */
            action: string;
            /**
             * Mitigation
             */
            mitigation: string;
            /**
             * Check
             */
            check: string;
            /**
             * Function
             */
            function: "business-side" | "architecture" | "development" | "operations";
            /**
             * STRIDE
             */
            stride: "spoofing" | "tampering" | "repudiation" | "information-disclosure" | "denial-of-service" | "elevation-of-privilege";
            /**
             * Detection logic
             */
            detection_logic: string;
            /**
             * Risk assessment
             */
            risk_assessment: string;
            /**
             * False positives
             */
            false_positives: string;
            /**
             * Model failure possible reason
             */
            model_failure_possible_reason: boolean;
            /**
             * CWE
             */
            cwe: number;
            /**
             * Risks identified
             */
            risks_identified: {
                [k: string]: {
                    /**
                     * Severity
                     */
                    severity?: "low" | "medium" | "elevated" | "high" | "critical";
                    /**
                     * Exploitation likelihood
                     */
                    exploitation_likelihood?: "unlikely" | "likely" | "very-likely" | "frequent";
                    /**
                     * Exploitation impact
                     */
                    exploitation_impact?: "low" | "medium" | "high" | "very-high";
                    /**
                     * Data breach probability
                     */
                    data_breach_probability?: "improbable" | "possible" | "probable";
                    /**
                     * Data breach technical assets
                     */
                    data_breach_technical_assets?: string[] | null;
                    /**
                     * Most relevant data asset
                     */
                    most_relevant_data_asset?: string | null;
                    /**
                     * Most relevant technical asset
                     */
                    most_relevant_technical_asset?: string | null;
                    /**
                     * Most relevant communication link
                     */
                    most_relevant_communication_link?: string | null;
                    /**
                     * Most relevant trust boundary
                     */
                    most_relevant_trust_boundary?: string | null;
                    /**
                     * Most relevant shared runtime
                     */
                    most_relevant_shared_runtime?: string | null;
                    [k: string]: unknown;
                };
            };
            [k: string]: unknown;
        };
    } | null;
    /**
     * Risk tracking
     */
    risk_tracking?: {
        [k: string]: {
            /**
             * Status
             */
            status: "unchecked" | "in-discussion" | "accepted" | "in-progress" | "mitigated" | "false-positive";
            /**
             * Justification
             */
            justification: string | null;
            /**
             * Ticket
             */
            ticket: string | null;
            /**
             * Date
             */
            date: string | null;
            /**
             * Checked by
             */
            checked_by: string | null;
            [k: string]: unknown;
        };
    } | null;
    /**
     * Diagram tweak suppress edge labels
     */
    diagram_tweak_suppress_edge_labels?: boolean | null;
    /**
     * Diagram tweak layout left to right
     */
    diagram_tweak_layout_left_to_right?: boolean | null;
    /**
     * Diagram tweak edge layout
     */
    diagram_tweak_edge_layout?: ("" | "ortho" | "spline" | "polyline" | "false" | "curved") | null;
    /**
     * Diagram tweak nodesep
     */
    diagram_tweak_nodesep?: number | null;
    /**
     * Diagram tweak ranksep
     */
    diagram_tweak_ranksep?: number | null;
    /**
     * Diagram tweak invisible connections between assets
     */
    diagram_tweak_invisible_connections_between_assets?: string[] | null;
    /**
     * Diagram tweak same rank assets
     */
    diagram_tweak_same_rank_assets?: string[] | null;
    [k: string]: unknown;
}
