"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.kebabCase = void 0;
function kebabCase(str) {
    if (!str)
        return "";
    return String(str)
        .replace(/^[^A-Za-z0-9]*|[^A-Za-z0-9]*$/g, "")
        .replace(/([a-z0-9])([A-Z])/g, (_m, a, b) => a + "_" + b.toLowerCase())
        .replace(/[^A-Za-z0-9]+|_+/g, "-")
        .toLowerCase();
}
exports.kebabCase = kebabCase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9wcml2YXRlL3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsU0FBZ0IsU0FBUyxDQUFDLEdBQVc7SUFDbkMsSUFBSSxDQUFDLEdBQUc7UUFBRSxPQUFPLEVBQUUsQ0FBQztJQUVwQixPQUFPLE1BQU0sQ0FBQyxHQUFHLENBQUM7U0FDZixPQUFPLENBQUMsZ0NBQWdDLEVBQUUsRUFBRSxDQUFDO1NBQzdDLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztTQUN0RSxPQUFPLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDO1NBQ2pDLFdBQVcsRUFBRSxDQUFDO0FBQ25CLENBQUM7QUFSRCw4QkFRQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBmdW5jdGlvbiBrZWJhYkNhc2Uoc3RyOiBzdHJpbmcpOiBzdHJpbmcge1xuICBpZiAoIXN0cikgcmV0dXJuIFwiXCI7XG5cbiAgcmV0dXJuIFN0cmluZyhzdHIpXG4gICAgLnJlcGxhY2UoL15bXkEtWmEtejAtOV0qfFteQS1aYS16MC05XSokL2csIFwiXCIpXG4gICAgLnJlcGxhY2UoLyhbYS16MC05XSkoW0EtWl0pL2csIChfbSwgYSwgYikgPT4gYSArIFwiX1wiICsgYi50b0xvd2VyQ2FzZSgpKVxuICAgIC5yZXBsYWNlKC9bXkEtWmEtejAtOV0rfF8rL2csIFwiLVwiKVxuICAgIC50b0xvd2VyQ2FzZSgpO1xufVxuIl19