"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const risk_category_1 = require("./risk-category");
const risk_tracking_1 = require("./risk-tracking");
const shared_runtime_1 = require("./shared-runtime");
const synthesizer_1 = require("./synthesizer");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const MODEL_SYMBOL = Symbol.for("cdktg/Model");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        Object.defineProperty(this, MODEL_SYMBOL, { value: true });
        this.synthesizer = new synthesizer_1.ModelSynthesizer(this, false);
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date
            ? new Date(props.date).toISOString().split("T")[0]
            : undefined;
        this.author = props.author;
        this.managementSummary = props.managementSummary;
        this.businessCriticality = props.businessCriticality;
        this.businessOverview = props.businessOverview;
        if (this.businessOverview &&
            this.businessOverview.images &&
            this.businessOverview.images.length > 0) {
            this.businessOverview.images.forEach((i) => i._bind(this));
        }
        this.technicalOverview = props.technicalOverview;
        this.questions = new Map();
        props.questions?.forEach((q) => {
            this.addQuestion(q.text, q.answer);
        });
        this.abuseCases = new Map();
        if (props.abuseCases && props.abuseCases.length > 0) {
            this.addAbuseCases(...props.abuseCases);
        }
        this.securityRequirements = new Map();
        if (props.securityRequirements && props.securityRequirements.length > 0) {
            this.addSecurityRequirements(...props.securityRequirements);
        }
        this.tags = new Set();
        this.riskTracking = new Map();
        this.rawOverrides = {};
    }
    static isModel(x) {
        return x !== null && typeof x === "object" && MODEL_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (Model.isModel(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No model could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    addTag(tag) {
        this.addTags(tag);
    }
    addTags(...tags) {
        tags.forEach((tag) => {
            this.tags.add(tag);
        });
    }
    addQuestion(text, answer = "") {
        // "" as answer signals "unanswered"
        if (this.questions.has(text)) {
            throw new Error(`Duplicated question "${text}"`);
        }
        this.questions.set(text, answer);
    }
    addAbuseCases(...cases) {
        cases.forEach((c) => {
            if (this.abuseCases.has(c.name)) {
                throw new Error(`Duplicated abuse case "${c.name}"`);
            }
            this.abuseCases.set(c.name, c.description);
        });
    }
    addSecurityRequirements(...requirements) {
        requirements.forEach((r) => {
            if (this.abuseCases.has(r.name)) {
                throw new Error(`Duplicated security requirement "${r.name}"`);
            }
            this.securityRequirements.set(r.name, r.description);
        });
    }
    trackRisk(id, options = {}) {
        if (this.riskTracking.has(id)) {
            throw new Error(`Duplicated risk tracking "${id}"`);
        }
        this.riskTracking.set(id, new risk_tracking_1.RiskTracking(id, options));
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        const sharedRuntimes = new Array();
        const individualRiskCategories = new Array();
        this.node.findAll().map((n) => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
            else if (n instanceof shared_runtime_1.SharedRuntime) {
                sharedRuntimes.push(n);
            }
            else if (n instanceof risk_category_1.RiskCategory) {
                individualRiskCategories.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date,
            author: this.author._toThreagile(),
            management_summary_comment: this.managementSummary,
            business_overview: this.businessOverview?._toThreagile(),
            technical_overview: this.technicalOverview?._toThreagile(),
            business_criticality: this.businessCriticality,
            questions: Object.fromEntries(this.questions),
            abuse_cases: Object.fromEntries(this.abuseCases),
            security_requirements: Object.fromEntries(this.securityRequirements),
            tags_available: Array.from(this.tags),
        };
        threagile.data_assets = dataAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.technical_assets = technicalAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.trust_boundaries = trustBoundaries.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.shared_runtimes = sharedRuntimes.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.individual_risk_categories = individualRiskCategories.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        if (this.riskTracking.size > 0) {
            threagile.risk_tracking = Array.from(this.riskTracking.values()).reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        }
        return {
            ...threagile,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.29" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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