"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyzeCommand = void 0;
const path = require("path");
const AdmZip = require("adm-zip");
const fs = require("fs-extra");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class AnalyzeCommand {
    constructor() {
        this.command = "analyze";
        this.describe = "analyze the models";
        this.builder = (args) => {
            args.option("url", {
                type: "string",
                alias: "u",
                describe: "URL of the threagile rest api",
            });
            args.option("output", {
                type: "string",
                alias: "o",
                describe: "",
                default: "dist",
            });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            fs.mkdirSync(args.output, { recursive: true });
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(".cdktg.out");
            for (const k in manifest.models) {
                try {
                    const modelManifest = manifest.models[k];
                    const resp = await api.analyze(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                    if (resp.status === 400) {
                        console.log(`❌  Errors for model "${k}":`);
                        console.log(resp.data.error);
                        continue;
                    }
                    const zip = new AdmZip(resp.data);
                    zip.extractAllTo(path.join(args.output, modelManifest.sanitizedName));
                }
                catch (e) {
                    console.log(`❌  ${e.message}`);
                }
            }
        };
    }
}
exports.AnalyzeCommand = AnalyzeCommand;
//# sourceMappingURL=data:application/json;base64,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