# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/expanding.ipynb (unless otherwise specified).

__all__ = ['expanding_mean', 'expanding_std', 'expanding_max', 'expanding_min']

# Cell
from math import sqrt
from typing import Callable, Optional

import numpy as np
import pandas as pd
from numba import njit

from .rolling import _lt, _gt

# Cell
@njit
def expanding_mean(x: np.ndarray) -> np.ndarray:
    n_samples = x.size
    out = np.empty(n_samples, dtype=np.float32)
    accum = 0.
    for i in range(n_samples):
        accum += x[i]
        out[i] = accum / (i+1)
    return out

# Cell
@njit
def expanding_std(x: np.ndarray) -> np.ndarray:
    n_samples = x.size
    out = np.empty(n_samples, dtype=np.float32)
    out[0] = np.nan
    accum_x = x[0]
    accum_xsq = x[0]**2
    for i in range(1, n_samples):
        accum_x += x[i]
        accum_xsq += x[i]**2
        out[i] = sqrt((accum_xsq - accum_x**2 / (i+1)) / i)
    return out

# Internal Cell
@njit
def _expanding_comp(comp: Callable, x: np.ndarray) -> np.ndarray:
    n_samples = x.size
    out = np.empty(n_samples, dtype=np.float32)
    pivot = x[0]
    out[0] = pivot
    for i in range(1, n_samples):
        if comp(x[i], pivot):
            pivot = x[i]
        out[i] = pivot
    return out

# Cell
def expanding_max(x: np.ndarray) -> np.ndarray:
    return _expanding_comp(_gt, x)

# Cell
def expanding_min(x: np.ndarray) -> np.ndarray:
    return _expanding_comp(_lt, x)