[![PyPi](https://img.shields.io/pypi/v/dronesploit.svg)](https://pypi.python.org/pypi/dronesploit/)
[![Read The Docs](https://readthedocs.org/projects/dronesploit/badge/?version=latest)](https://dronesploit.readthedocs.io/en/latest/?badge=latest)
[![Known Vulnerabilities](https://snyk.io/test/github/dhondta/dronesploit/badge.svg?targetFile=requirements.txt)](https://snyk.io/test/github/dhondta/dronesploit?targetFile=requirements.txt)
[![Requirements Status](https://requires.io/github/dhondta/dronesploit/requirements.svg?branch=master)](https://requires.io/github/dhondta/dronesploit/requirements/?branch=master)
[![Python Versions](https://img.shields.io/pypi/pyversions/dronesploit.svg)](https://pypi.python.org/pypi/dronesploit/)
[![Black Hat Arsenal Europe 2019](https://img.shields.io/badge/Black%20Hat%20Arsenal-EU%202019-blue.svg)](https://www.blackhat.com/eu-19/arsenal/schedule/index.html#drone-hacking-with-dronesploit-18217)
[![License](https://img.shields.io/badge/license-AGPL%20v3-lightgrey.svg)](https://github.com/dhondta/dronesploit/blob/master/LICENSE)


## Introduction

This CLI framework is based on [`sploitkit`](https://github.com/dhondta/python-sploitkit/) and is an attempt to gather hacking techniques and exploits especially focused on **drone hacking**. For the ease of use, the interface has a layout that looks like Metasploit.

[Black Hat Europe Arsenal 2019 presentation](https://dhondta.github.io/dronesploit/docs/blackhat-eu19-arsenal.pdf)

Also see articles:

- [*Black Hat Europe: New tool offers Metasploit-like framework for hacking into drones*, The Daily Swig](https://portswigger.net/daily-swig/black-hat-europe-new-tool-offers-metasploit-like-framework-for-hacking-into-drones)
- [*Dronesploit, a pentesting console framework dedicated to drones*, Hakin9](https://hakin9.org/dronesploit-a-pentesting-console-framework-dedicated-to-drones/)

## Setup

This project is available on [PyPi](https://pypi.python.org/pypi/dronesploit/) and can be simply installed using Pip:

```sh
pip3 install dronesploit
```

## Basics

### Interface

<p align="center"><img src="https://github.com/dhondta/dronesploit/raw/master/docs/img/dronesploit.png"></p>
<p align="center"><img src="https://github.com/dhondta/dronesploit/raw/master/docs/img/dronesploit-commands.png"></p>

### Modules

This example shows an example of module for DroneSploit aimed to change the password or the SSID of a particular model of drone.

<p align="center"><img src="https://github.com/dhondta/dronesploit/raw/master/docs/img/dronesploit-module.png"></p>
