# Docker services

Services in Docker swarm

Don't use the constructor directly. Instead use 
```python
from pydock import docker

my_docker_service = docker.service.inspect("my-service")

my_docker_service = docker.service.create("busybox", ["ping", "www.google.com"])

```
For type hints, use this

```python
from pydock import Service

def print_creation_time(some_service: Service):
    print(some_service.created_at)
```


## Attributes

It attributes are the same that you get with the command line:
`docker service inspect ...`

To get a complete description of those attributes, you 
can take a look at the [daemon api reference page](https://docs.docker.com/engine/api/v1.40/#operation/ServiceInspect) 
and click on "200 No error".

An example is worth many lines of descriptions.

```
In [1]: from pydock import docker

In [2]: docker.swarm.init()

In [3]: my_service = docker.service.create("busybox", ["ping", "www.google.com"])

In [4]: def super_print(obj):
   ...:     print(f"type = {type(obj)}, value = {obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
