class Config():
    def __init__(self):
        pass

    half_space = '\u200c'

    # ضمیر مالکیت: کتابشان
    prop_postfix_all = ["یم", "یت", "یش", "ش", "م", "ت",
                        "یتان", "یشان", "یمان",
                        "مان", "تان", "شان", "ان",
                        "مون", "تون", "شون", "یشون", "یتون", "یمون",
                        "یمو", "یتو", "یشو", "شو", "مو", "تو",
                        "یتانو", "یشانو", "یمانو", "انو",
                        "مانو", "تانو", "شانو",
                        "مونو", "تونو", "شونو", "یشونو", "یتونو", "یمونو", ]

    # ضمیر جمع: کتابها
    plural_postfix_all = ["ها", "ات", "های",
                          "ان", "هایی", "ین"]

    # چسبیده: کتابت، جداشده: کتاب شان
    postfix_joint = ["یم", "یت", "یش", "ش", "م", "ت", "یمو", "یتو", "یشو", "شو", "مو", "تو"] + ["ان", "ین", "ات"]

    # پسوند بدون قاعده: ستارگان، زهرآگین
    irregular_postfix_all = ["نده", "گانه", "دان", "ستان", "چی", "زار", "گار", "ناک", "گین", "انه", "یار", "مند", "کده",
                             "گر", "باره", "آگین", "سان", "گون", "الو", "واره", "گی", "یی", "ای", "تر", "ترین", "لاخ",
                             "فام", "سرا", "دانن", "گون", "الو", "واره", "گی", "یی", "ای", "تر", "ترین", "لاخ", "فام",
                             "سرا", "دان", "آمیز",
                             ]
    # چسبیده و جدا
    irregular_postfix_joint = []

    #  پیشوند رایج کلمات : پیشدرآمد، پیشگفتار
    prefix_all = ["نا", "پاد", "باز", "وا", "فرا", "فرو", "پیش", "بی", "پر", "کلان", "هر"]
    prefix_joint = []

    # افعال پیشوندی: فرو رفت
    verb_prefix = ['در', 'بر', 'پر', 'باز',
                   'ور', 'فرو', 'فرا', 'وا']
    # افعال پیشوندی چسبیده
    verb_prefix_joint = []

    # دیکشنری کلمات چسبیده رایج
    dictionary_mapping = {'\ufeffبیخبر': 'بی\u200cخبر', 'بیتوجهی': 'بی توجهی', 'بیطرفانه': 'بی\u200cطرفانه',

                          'آنها': 'آن\u200cها',
                          'میباشد': 'می\u200cباشد',
                           'میدادند': 'می\u200cدادند', 'مینویسد': 'می\u200cنویسد',
                          'میبخشد': 'می\u200cبخشد',
                          'بیقاعده': 'بی\u200cقاعده', 'میباشند': 'می\u200cباشند',
                           'پایینترین': 'پایین\u200cترین',

                          'برونگرا': 'برون\u200cگرا', 'میدهد': 'می\u200cدهد',

                           'کمکرسانی': 'کمک\u200cرسانی',
                          'کلانشهر': 'کلان\u200cشهر',
                          'سپردهگذار': 'سپرده\u200cگذار', 'بنیانگذار': 'بنیان\u200cگذار', 'رضایتبخش': 'رضایت\u200cبخش',
                          'اصلاحطلبان': 'اصلاح\u200cطلبان', 'استخوانبندی': 'استخوان\u200cبندی',
                          'درونگرا': 'درون\u200cگرا',
                          'میگردد': 'می\u200cگردد', 'اصلاحطلب': 'اصلاح\u200cطلب', 'میتوان': 'می\u200cتوان',
                          'عملکرد': 'عمل\u200cکرد',
                          'میروم': 'می\u200cروم', 'بزرگنمایی': 'بزرگ\u200cنمایی', 'همجنس': 'هم\u200cجنس',
                          'همانطور': 'همان\u200cطور',
                          'بیشترین': 'بیش\u200cترین', 'انسانگرایی': 'انسان\u200cگرایی', 'نمیباشند': 'نمی\u200cباشند',
                          'جانبداری': 'جانب\u200cداری', 'نمیتوانی': 'نمی\u200cتوانی', 'قانونگذار': 'قانون\u200cگذار',
                          'میشدند': 'می\u200cشدند', 'تفاهمنامه': 'تفاهم\u200cنامه', 'آسیبپذیر': 'آسیب\u200cپذیر',
                          'برونگرایی': 'برون\u200cگرایی', 'جفتگیری': 'جفت\u200cگیری', 'گرانبها': 'گران\u200cبها',
                          'میشوند': 'می\u200cشوند',
                          'کلاهبرداری': 'کلاه\u200cبرداری', 'جهتیابی': 'جهت\u200cیابی', 'چشمپوشی': 'چشم\u200cپوشی',
                          'بنیانگذاران': 'بنیان\u200cگذاران', 'میکند': 'می\u200cکند', 'الهامبخش': 'الهام\u200cبخش',
                          'وقتگیر': 'وقت\u200cگیر',
                          'پسلرزه': 'پس\u200cلرزه', 'میکنند': 'می\u200cکنند', 'میتواند': 'می\u200cتواند',
                          'آرامبخش': 'آرام\u200cبخش',
                          'بینام': 'بی\u200cنام', 'غربزدگی': 'غرب\u200cزدگی', 'بیتفاوت': 'بی\u200cتفاوت',
                          'بیثباتی': 'بی\u200c\u200cثباتی',
                          'پاسخگویی': 'پاسخ\u200cگویی', 'میگیرد': 'می\u200cگیرد', 'جمعبندی': 'جمع\u200cبندی',
                          'میشود': 'می\u200cشود',
                          'میکنیم': 'می\u200cکنیم', 'نو آوری\u200cمان': 'نو\u200cآوری\u200cمان',
                          'نو آوری مان': 'نو\u200cآوری\u200cمان',
                          'نو آوریمان': 'نو\u200cآوری\u200cمان', ' ا م ': '\u200cام ', ' م ': '\u200cام ',
                          'کنندهای': 'کننده\u200cای',
                          'ارائهای': 'ارائه\u200cای', 'ایدهای': 'ایده\u200cای', 'ماسهای': 'ماسه\u200cای',
                          'خامنهای': 'خامنه\u200cای',
                          'قلهای': 'قله\u200cای', 'سیارهای': 'سیاره\u200cای', 'کیسهای': 'کیسه\u200cای',
                          'شانهای': 'شانه\u200cای',
                          'غریبهای': 'غریبه\u200cای', 'برنامهای': 'برنامه\u200cای', 'سختگیرانهای': 'سختگیرانه\u200cای',
                          'بهانهای': 'بهانه\u200cای', 'زیرروالهای': 'زیر روالهای', 'درهای': 'دره\u200cای',
                          'آمادهای': 'آماده\u200cای',
                          'سادهای': 'ساده\u200cای', 'سرمایهگذارهای': 'سرمایه گذارهای',
                          'فوقالعادهای': 'فوق\u200cالعاده\u200cای',
                          'حادثهای': 'حادثه\u200cای', 'نویسندههای': 'نویسنده\u200cهای', 'علاقهای': 'علاقه\u200cای',
                          'برجستهای': 'برجسته\u200cای', 'جلگهای': 'جلگه\u200cای', 'زندهای': 'زنده\u200cای',
                          'فنآوریهای': 'فناوری\u200cهای',
                          'سایهروشنهای': 'سایه روشن\u200cهای', 'بیسابقهای': 'بی سابقه\u200cای',
                          'فرضیهای': 'فرضیه\u200cای',
                          'راهاندازهای': 'راه اندازهای', 'بیشهای': 'بیشه\u200cای', 'مقالهای': 'مقاله\u200cای',
                          'دیگهای': 'دیگه\u200cای',
                          'ماههاست': 'ماه هاست', 'نرمافزارهای': 'نرم\u200cافزارهای',
                          'کتابسوزانهای': 'کتاب سوزان\u200cهای',
                          'سیستمعاملهای': 'سیستم عامل\u200cهای', 'اسلحهای': 'اسلحه\u200cای', 'وقفهای': 'وقفه\u200cای',
                          'زمینهای': 'زمینه\u200cای', 'حرامزادههای': 'حرامزاده\u200cهای', 'هزینهای': 'هزینه\u200cای',
                          'انداختهای': 'انداخته\u200cای', 'جسورانهای': 'جسورانه\u200cای', 'فاجعهای': 'فاجعه\u200cای',
                          'جامعهای': 'جامعه\u200cای', 'پدیدهای': 'پدیده\u200cای', 'اغواگرانهای': 'اغواگرانه\u200cای',
                          'تکانهای': 'تکانه\u200cای', 'لولهای': 'لوله\u200cای', 'نشانهای': 'نشانه\u200cای',
                          'وسیلهای': 'وسیله\u200cای',
                          'آیندهای': 'آینده\u200cای', 'بردهای': 'برده\u200cای', 'سابقهای': 'سابقه\u200cای',
                          'ناحیهای': 'ناحیه\u200cای',
                          'تکاندهندهای': 'تکان دهنده\u200cای', 'بودجهای': 'بودجه\u200cای', 'روزانهای': 'روزانه\u200cای',
                          'چارهای': 'چاره\u200cای', 'انگیزهای': 'انگیزه\u200cای', 'دادهای': 'داده\u200cای',
                          'عدهای': 'عده\u200cای',
                          'هفتهای': 'هفته\u200cای', 'منطقهای': 'منطقه\u200cای', 'استارتآپهای': 'استارتاپ\u200cهای',
                          'سازهای': 'سازه\u200cای',
                          'مجموعهای': 'مجموعه\u200cای', 'فلسفهای': 'فلسفه\u200cای', 'تذکردهندهای': 'تذکر دهنده\u200cای',
                          'مصاحبهای': 'مصابحه\u200cای', 'نمونهای': 'نمونه\u200cای', 'قلمموهای': 'قلم مو\u200cهای',
                          'شبزندهداری': 'شب زنده\u200cداری', 'خوردهباشد': 'خورده باشد', 'داشتهباشید': 'داشته باشید',
                          'فزایندهای': 'فزاینده\u200cای', 'عمدهای': 'عمده\u200cای', 'بدیهایی': 'بدی\u200cهای',
                          'نوشت\u200cهایم': 'نوشته\u200cایم', 'بنتالهدی': 'بنت الهدی', 'نوشتهام': 'نوشته\u200cام',
                          'سرمایهگذاران': 'سرمایه گذاران', 'خانهی': 'خانه\u200cی', 'گستاخانهی': 'گستاخانه\u200cی',
                          'گرفتهباشیم': 'گرفته باشیم', 'خونهی': 'خونه\u200cی', 'داشتهام': 'داشته\u200cام',
                          'رشتهام': 'رشته\u200cام',
                          'سرمایهگذارانشان': 'سرمایه گذارانشان', 'ریشهکنی': 'ریشه\u200cکنی',
                          'مودبانهتری': 'مودبانه\u200cتری',
                          'برگردانشدهاند': 'برگردان شده\u200cاند', 'قرمهسبزی': 'قرمه\u200cسبزی', 'راهجویی': 'راه جویی',
                          'اماهیچوقت': 'اما هیچوقت', 'آبوهوای': 'آب و هوای', 'بقیهاش': 'بقیه\u200cاش',
                          'طبقهبندی': 'طبقه\u200cبندی',
                          'مردههان': 'مرده هان', 'آمادهاند': 'آماده\u200cاند', 'نشدهاید': 'نشده\u200cاید',
                          'آگاهیرسانی': 'آگاهی رسانی',
                          'نداشتهاند': 'نداشته\u200cاند', 'شکنانهترین': 'شکنانه\u200cترین',
                          'اقدامهایی': 'اقدام\u200cهایی',
                          'راهآهن': 'راه آهن', 'شدهاند': 'شده\u200cاند', 'تازهترین': 'تازه\u200cترین',
                          'روبهروی': 'رو به روی',
                          'منحصربهفرد': 'منحصر به فرد', 'سیزدهبدر': 'سیزده بدر', 'برندهی': 'برنده\u200cی',
                          'خانهاشتراکی': 'خانه اشتراکی',
                          'دادههایی': 'داده\u200cهایی', 'استفادهتر': 'استفاده\u200cتر',
                          'گذرنامهتان': 'گذرنامه\u200cتان',
                          'کهنترین': 'کهنه\u200cترین', 'فرهنگسرا': 'فرهنگ\u200cسرا', 'آمادهاید': 'آماده\u200cاید',
                          'ویژهی': 'ویژه\u200cی',
                          'غریزهات': 'غریزه\u200cات', 'مادرشوهری': 'مادر شوهری', 'نبودهام': 'نبوده\u200cام',
                          'بودهاند': 'بوده\u200cاند',
                          'وتنها': 'و تنها', 'بداههکاری': 'بداهه\u200cکاری', 'سرمایهگذار': 'سرمایه گذار',
                          'برنامهنویس': 'برنامه نویس',
                          'مهنازخانم': 'مهناز خانم', 'مواجهاند': 'مواجه\u200cاند', 'توسعهاش': 'توسعه\u200cاش',
                          'سینهام': 'سینه\u200cام',
                          'سین\u200cهام': 'سینه\u200cام', 'نمیخواهند': 'نمیخواهند', 'فنآوری\u200cها': 'فناوری\u200cها',
                          'دنبالهرو': 'دنباله\u200cرو', 'لبهی': 'لبه\u200cی', 'اللهیار': 'الله یار',
                          'ارزندهتر': 'ارزنده\u200cتر',
                          'برههای': 'بره\u200cای', 'پیادهسازی': 'پیاده\u200cسازی', 'دهسالگی': 'ده سالگی',
                          'رسانهای': 'رسانه\u200cای',
                          'ریشسفیدها': 'ریش سفید\u200cها', 'چهجوری': 'چه جوری', 'ویژگیهایی': 'ویژگی\u200cهایی',
                          'می\u200cفهمی\u200cم': 'میفهمیم', 'وبهم': 'و بهم', 'قطرهای': 'قطره\u200cای',
                          'ازتنهایی': 'از تنهایی',
                          'لطیفهای': 'لطیفه\u200cای', 'باشهاومدم': 'باشه اومدم',
                          'منحصربهفردترین': 'منحصر به فرد\u200cترین',
                          'کردهاند': 'کرده\u200cاند', 'اندازهای': 'اندازه\u200cای', 'بهرهبرداری': 'بهره برداری',
                          'اماشوهرجان': 'اما شوهر جان', 'خانوادهاش': 'خانواده\u200cاش', 'نشدهاند': 'نشده\u200cاند',
                          'نکردهایم': 'نکرده\u200cایم', 'تخممرغ\u200cهایش': 'تخم مرغ\u200cهایش',
                          'وظیفهش': 'وظیفه\u200cاش',
                          'مشگینشهر': 'مشگی شهر', 'توسعهدهندگانش': 'توسعه دهندگانش', 'امینابراهیم': 'امین ابراهیم',
                          'دربارهاش': 'درباره\u200cاش', 'میانافزارها': 'میان\u200cافزارها', 'دیدهاند': 'دیده\u200cاند',
                          'خانوادهام': 'خانواده\u200cام', 'مایهی': 'مایه\u200cی', 'نوشتهشدن': 'نوشته شدن',
                          'راهحل\u200cهایشان': 'راه حل\u200cهایشان', 'میهماننواز': 'میهمان نواز',
                          'زیبندهی': 'زیرنده\u200cی',
                          'راههایی': 'راه\u200cهایی', 'جربزهی': 'جربزه\u200cی', 'بهجا': ' به جا',
                          'بطورهمزمان': 'به طور همزمان',
                          'فهمیدهبود': 'فهمیده بود', 'دوربرگردان\u200cها': 'دور برگردان\u200cها',
                          'شالودهی': 'شالوده\u200cی',
                          'راهکاریی': 'راه\u200cکاری', 'مخالفتهایی': 'مخالفت\u200cهایی', 'چیزهاازشون': 'چیزها ازشون',
                          'سکونتگاه\u200cهای': 'سکونت گاه\u200cهای', 'سالهابود': 'سال\u200cها بود',
                          'نمونهی': 'نمونه\u200cی',
                          'سرمایهگذاری': 'سرمایه گذاری', 'شبکهای': 'شبکه\u200cای', 'خواهرشوهر': 'خواهر شوهر',
                          'سرگیجهآور': 'سرگیجه آور',
                          'آستانهی': 'آستانه\u200cی', 'دادهاست': 'داده است', 'مجسمهسازی': 'مجسمه سازی',
                          'ماهرانهترین': 'ماهرانه\u200cترین',
                          'پنجشنبههایی': 'پنجشنبه شب\u200cهایی', 'نرفنهام': 'نرفته\u200cام', 'قورمهسبزی': 'قورمه سبزی',
                          'گذارهای': 'گذاره\u200cای', 'بندهخدا': 'بنده خدا', 'روزنامهنگاران': 'روزنامه نگاران',
                          'نقشهی': 'نقشه\u200cی',
                          'حملهی': 'حمله\u200cی', 'تکنیکهاست': 'تکنیک هاست', 'نرمافزارهایمان': 'نرم\u200cافرارهایمان',
                          'مادرشوهرم': 'مادر شوهرم', 'ماهگیمون': 'ماه گیمون', 'مادرشوهرمحترم': 'مادر شوهر محترم',
                          'شوهرداری': 'شوهر داری',
                          'سرمایهگذارها': 'سرمایه گذارها', 'بهرهمند': 'بهره\u200cمند', 'درمانهایی': 'درمان\u200cهایی',
                          'عامدانهتر': 'عامدانه\u200cتر', 'تازهوارد': 'تازه وارد', 'مونتهویدئو': 'مونته ویدئو',
                          'ذائق\u200cهاش': 'ذائقه\u200cاش', 'گوشهگیرتر': 'گوشه\u200cگیرتر',
                          'دنبالهدار': 'دنباله\u200cدار',
                          'بیخانمان\u200cها': 'بی\u200cخانمان\u200cها', 'سرمایهدارها': 'سرمایه\u200cدارها',
                          'مادرشوهریم': 'مادر شوهریم',
                          'صبحان\u200cهاش': 'صبحانه\u200cاش', 'جنازهست': 'جنازه است', 'شمارهات': 'شماره\u200cای',
                          'بهقدری': 'به قدری',
                          'کیسهی': 'کیسه\u200cی', 'کوششهایی': 'کوشش\u200cهایی', 'مادرشوهر': 'مادر شوهر',
                          'رابطهی': 'رابطه\u200cی',
                          'نوشتهاند': 'نوشته\u200cاند', 'کنجکاوانهی': 'کنجکاوانه\u200cی', 'غیرمتعهد': 'غیر متعهد',
                          'کردهای': 'کرده\u200cای',
                          'وهمکارانم': 'و همکارانم', 'گردهمآیی': 'گردهمایی', 'اللهوردی': 'الله وردی',
                          'صرفهجویی': 'صرفه جویی',
                          'ماندهاند': 'مانده\u200cاند', 'برنامهنویسی': 'برنامه\u200cنویسی', 'امینمهدی': 'امین مهدی',
                          'سهامدارنی': 'سهام دارانی', 'مسابقهی': 'مسابقه\u200cی', 'ستارهشناسم': 'ستار شناسم',
                          'گرفتهاند': 'گرفته\u200cاند',
                          'جامعهشان': 'جامعه\u200cشان', 'بچهی': 'بچه\u200cی', 'شیوهی': 'شیوه\u200cی', 'بهکار': 'به کار',
                          'بهتراست': 'بهتر است', 'سروکلهشون': 'سر و کلهشون', 'رسیدهمسرش': 'رسید همسرش',
                          'پسراهل': 'پسر اهل',
                          'پروژههای': 'پروژه\u200cهای', 'عاقلان\u200cهام': 'عاقلانه\u200cام',
                          'گذاشتهاند': 'گذاشته\u200cاند',
                          'کردهام': 'کرده\u200cام', 'اندازهگیری': 'اندازه گیری', 'یاوهگویی': 'یاوه گویی',
                          'سازمانهایی': 'سازمان\u200cهایی',
                          'نمودهاند': 'نموده\u200cاند', 'تنهاییآور': 'تنهایی آور', 'قراردهیم': 'قرار دهیم',
                          'ازشوهرجان': 'از شوهر جان',
                          'کرهجنوبی': 'کره جنوبی', 'توهینآمیز': 'توهین آمیز', 'فنآوریهایی': 'فناوری\u200cهایی',
                          'داشتهاید': 'داشته\u200cاید',
                          'شدهایم': 'شده\u200cایم', 'نمیفهمم': 'نمیفهمم', 'مثالهایی': 'مثال\u200cهایی',
                          'رییسجمهور': 'رییس جمهور',
                          'مجموعهی': 'مجموعه\u200cی', 'درندهاند': 'درنده\u200cاند', 'امابهش': 'اما بهش',
                          'بازخواهند': 'باز خواهند',
                          'برنامههایی': 'برنامه\u200cهایی', 'یهجا': 'یه جا', 'زگیلهایی': 'زگیل\u200cهایی',
                          'وسیلهی': 'وسیله\u200cی',
                          'بهمنیار': 'بهمن یار', 'دادهام': 'داده\u200cام', 'بههنگام': 'به هنگام', 'بهدروغ': 'به دروغ',
                          'دورافتادهترین': 'دور افتاده\u200cترین', 'نامهایی': 'نامه\u200cایی', 'سهقسمتی': 'سه قسمتی',
                          'توجهازچیدن': 'توجه از چیدن', 'پیامرسان\u200cها': 'پیام رسان\u200cها', 'بهمنزاد': 'بهمن زاد',
                          'نشانههایی': 'نشانه\u200cهایی', 'راهحل\u200cهای': 'راه حل\u200cهای',
                          'راهحلهایی': 'راه حل\u200cهایی',
                          'راهحلهای': 'راه حل\u200cهای', 'نظرخواهی\u200cها': 'نظر خواهی\u200cها',
                          'نظرخواهیها': 'نظر خواهی\u200cها',
                          'کندهی': 'کنده\u200cی', 'حرامزاده\u200cهای': 'حرام زاده\u200cهای',
                          'شبیهسازیهایی': 'شبیه سازی\u200cهایی',
                          'مهارتهایی': 'مهارت\u200cهایی', 'روبهرویشان': 'رو به رویشان',
                          'برجستهترین': 'برجسته\u200cترین',
                          'نمیفهمیدم': 'نمیفهمیدم', 'دستگاههایی': 'دستگاه\u200cهایی', 'برادرشوهر': 'برادر شوهر',
                          'گرسن\u200cهام': 'گرسته\u200cام', 'گرسنههام': 'گرسته\u200cام', 'قهوهخوری': 'قهوه خوری',
                          'دادهاید': 'داده\u200cاید',
                          'بهآرامی': 'به آرمانی', 'دانستنیهاست': 'دانستنی\u200cهاست', 'بهراحتی': 'به راحتی',
                          'ایدهپردازی': 'ایده\u200cپردازی', 'ریشسفیدهای': 'ریش سفید\u200cهای', 'خفهمون': 'خفه مون',
                          'بهجای': 'به جای',
                          'ریزخشونت\u200cها': 'ریز خشونت\u200cها', 'ریزخشونتها': 'ریز خشونت\u200cها',
                          'حساسیتهایی': 'حساسیت\u200cهایی',
                          'پشتصحنهی': 'پشت صحنه\u200cی', 'کلهی': 'کله\u200cی', 'تاشوهرم': 'تا شوهرم',
                          'آیندهاش': 'آینده\u200cاش',
                          'پروانههایی': 'پروانه\u200cهایی', 'خوبیهایی': 'خوبی\u200cهایی',
                          'نرمافزارها': 'نرم\u200cافزارها',
                          'رساندهاند': 'رسانده\u200cاند', 'سرمایهگذارنی': 'سرمایه گذارانی', 'تکهچسبانی': 'تکه چسبانی',
                          'جاهطلبی': 'جاه طلبی',
                          'پرغلغلهتان': 'پر غلغله\u200cتان', 'خمینیشهر': 'خمینی شهر', 'رشتهتوییت': 'رشته توییت',
                          'موهبتهایی': 'موهبت\u200cهایی', 'برنامهی': 'برنامه\u200cی', 'مادرشوهردارم': 'مادر شوهر داردم',
                          'سیاهپوستان': 'سیاه پوستان', 'شرکتهایی': 'شرکت\u200cهایی', 'نیاوردهاند': 'نیاورده\u200cاند',
                          'آنهم': 'آن هم',
                          'شوهرداریم': 'شوهر داریم', 'یکچهارم': 'یک چهارم', 'پروندههاست': 'پرونده هاست',
                          'برنامهت': 'برنامه\u200cات',
                          'چروکیدهمان': 'چروکیده\u200cمان', 'زمینهسازی': 'زمینه سازی', 'زدهاند': 'زده\u200cاند',
                          'اظهارنظرپرداختن': 'اظهار نظر پرداختن', 'صلحطلبانهترین': 'صلح طلبانه\u200cترین',
                          'بهغلط': 'به غلط',
                          'ایدهآلم': 'ایده آلم', 'سیاهکاران': 'سیاه کاران', 'امیرابراهیم': 'امیر ابراهیم',
                          'توسعهدهندگان': 'توسعه دهندگان',
                          'لحظهی': 'لحظه\u200cی', 'امینطاها': 'امین طاها', 'بینالنهرین': 'بین النهرین',
                          'نیمهوقت': 'نیمه وقت',
                          'پیادهروی': 'پیاده روی', 'آلودهاند': 'آلوده\u200cاند', 'گریهکرد': 'گره کرد',
                          'نعمتهایی': 'نعمت\u200cهایی',
                          'مادرشوهرشماهم': 'مادر شوهر شما هم', 'آشپزخونهاس': 'آشپزخونه\u200cاس',
                          'مسابقهها': 'مسابقه\u200cها',
                          'مسابقهای': 'مسابقه\u200cهای', 'برنامهریزی': 'برنامه\u200cریزی', 'بازخواهید': 'باز خواهید',
                          'جوییما': 'جویی ما',
                          'آماده ایم': 'آماده\u200cایم', 'مدلسازی': 'مدل\u200cسازی', 'درصورتیکه': 'در صورتیکه',
                          'آمریکاییات': 'آمریکایی\u200cات', 'مادریاش': 'مادری\u200cاش', 'غافلگیرکننده': 'غافلگیر کننده',
                          'پیکرتراشی': 'پیکر تراشی', 'اذیتوآزار': 'اذیت و آزار', 'امتیازاورترین': 'امتیاز آور',
                          'جیکجیک': 'جیک جیک',
                          'تاشب': 'تا شب', 'کپیرایت': 'کپی رایت', 'آنتیبادی': 'آنتی بادی', 'عجیبتر': 'عجیب\u200cتر',
                          'استانداردسازی': 'استاندارد سازی', 'هشتادوهشت': 'هشتاد و هشت', 'متنوعتر': 'متنوع\u200cتر',
                          'منظورانجام': 'منظور انجام', 'نگرانکننده\u200cترین': 'نگران کننده\u200cترین',
                          'شگفتانگیز': 'شگفت انگیز',
                          'رنگینپوست': 'رنگین پوست', 'فارغ التحصیلان': 'فارغ\u200cالتحصیلان',
                          'ترسناکتر': 'ترسناک\u200cتر',
                          'لا رامبلا': 'لارامبلا', 'پرجمعیتترین': 'پرجمعیت\u200cترین', 'درمیآیند': 'درمی\u200cآیند',
                          'باشمالکی': 'باشم الکی',
                          'وسیعتر': 'وسیع\u200cتر', 'فاحشهخانه': 'فاحشه خانه', 'بااحتیاط': 'با احتیاط',
                          'قانعکننده': 'قانع\u200cکننده',
                          'انعطافپذیری': 'انعطاف\u200cپذیری', 'بیتالمقدس': 'بیت\u200cالمقدس',
                          'اوپناستریتمپ': 'اوپن استریت مپ',
                          'روزابارونی': 'روزا بارونی', 'محافظهکارانه': 'محافظه کارانه', 'فوتبالدستی': 'فوتبال دستی',
                          'توسعهدهنده': 'توسعه دهنده', 'قانونگزاران': 'قانون گزاران', 'العسریسرا': 'العسر یسرا',
                          'خارقالعاده': 'خارق\u200cالعاده', 'بیماریمزمن': 'بیماری مزمن', 'بادوستانتان': 'با دوستانتان',
                          'برابربیشتر': 'برابر بیشتر', 'ارائهدهنده': 'ارائه دهنده', 'طوفانزدگان': 'طوفان زندگان',
                          'امینمحمد': 'امین محمد',
                          'محیطزیست': 'محیط زیست', 'شقیترینشان': 'شقی\u200cترینشان', 'بودواقعا': 'بود واقعا',
                          'نیویورکتایمز': 'نیویورک تایمز', 'ریودوژانیرو': 'ریو دو ژانیرو',
                          'مشترکالمنافع': 'مشترک\u200cالمنافع',
                          'اسلایدسازم': 'اسلاید سازم', 'نمیآوریدش': 'نمی\u200cآوریدش', 'بینالملل': 'بین\u200cالملل',
                          'مصرفکنندگان': 'مصرف کنندگان', 'امینالدین': 'امین الدین', 'امریکااینقدر': 'امریکا اینقدر',
                          'بعضیاوقات': 'بعضی اوقات', 'خاطربچه': 'خاطر بچه', 'ایناکیلویی': 'اینا کیلویی',
                          'ویکیپدیا': 'ویکی\u200cپدیا',
                          'مافکرمیکنیم': 'ما فکر میکنیم', 'انگلیسیزبان': 'انگلیسی زبان', 'کلهشون': 'کله\u200cشون',
                          'آدمبزرگی': 'آرم بزرگی',
                          'مر آت مر آه': 'مر\u200cآت مر\u200cآت', 'آسیبزد': 'آسیب زد', 'آیآرسی': 'آی آرسی',
                          'آسیااقیانوسیه': 'آسیا اقیانوسیه', 'آیای': 'آیا', 'میانجنسی': 'میان جنسی',
                          'میاننسلی': 'میان نسلی',
                          'میان\u200cافزار\u200cها': 'میان افزارها', 'آییننامه': 'آیین\u200cنامه',
                          'ارائهشده': 'ارائه\u200cشده',
                          'اشپزخونه': 'آشپزخونه', 'اماعلتشونمیپرسه': 'اما علتشو نمیپرسه',
                          'امیدوارکننده': 'امیدوار کننده',
                          'ایالاتمتحده': 'ایالات متحده', 'بااینکه': 'با اینکه', 'بلندپروازانه': 'بلند پروازانه',
                          'بهترازاینه': 'بهتر از اینه', 'بهدست\u200cآمده': 'به دست\u200cآمده', 'بهوسیله': 'به وسیله',
                          'بیادبانه': 'بی ادبانه', 'بیاندازه': 'بی اندازه', 'بیصبرانه': 'بی صبرانه',
                          'بیفایده': 'بی فایده',
                          'بیمهره': 'بی مهره', 'بینظیره': 'بی نظیره', 'تاریخزده': 'تاریخ زده', 'تهرانزده': 'تهران زده',
                          'تولیدشده': 'تولید شده', 'تولیدکننده': 'تولید کننده', 'تکمیلشده': 'تکمیل شده',
                          'جاافتاده': 'جا افتاده',
                          'جمع\u200cآوریکننده': 'جمع\u200c آوری کننده', 'جورآدمیه': 'جور آدمیه',
                          'حقالزحمه': 'حق الزحمه',
                          'دخترونهتره': 'دخترونه تره', 'دوپنجره': 'دو پنجره', 'ذاتالریه': 'ذات\u200cالریه',
                          'راسالخیمه': 'راس\u200cالخیمه',
                          'رنگماده': 'رنگ ماده', 'سوئاستفاده': 'سو استفاده', 'سواستفاده': 'سو استفاده',
                          'شبهجزیره': 'شبه جزیره',
                          'صادرکننده': 'صادر کننده', 'ضررداره': 'ضرر داره', 'عابرپیاده': 'عابر پیاده',
                          'فوقالعاده': 'فوق\u200cالعاده',
                          'قابلتوجه': 'قابل توجه', 'قانع\u200cکننده': 'قانع\u200c کننده', 'مادربیچاره': 'مادر بیچاره',
                          'مشخصشده': 'مشخص شده',
                          'مصرفکننده': 'مصرف کننده', 'مصیبتزده': 'مصیب تزده', 'ناامیدکننده': 'ناامید کننده',
                          'نیمفاصله': 'نیم\u200cفاصله',
                          'هماهنگکننده': 'هماهنگ کننده', 'همهجانبه': 'همه جانبه', 'واردکننده': 'وارد کننده',
                          'وخوابگاه': 'و خوابگاه',
                          'ودستگاه': 'و دستگاه', 'وزردچوبه': 'و زردچوبه', 'وپروانه': 'و پروانه',
                          'پدرخوانده': 'پدر خوانده',
                          'چاپشده': 'چاپ شده', 'کردته': 'کرد ته', 'کردندکه': 'کردند که', 'یکطرفه': 'یک طرفه',
                          'پایینتره': 'پایین\u200cتره',
                          'اشتراکگذاری': 'اشتراک گذاری', 'انحصارگراناند': 'انحصار گران\u200cاند',
                          'خوشحالییییی': 'خوشحالی',
                          'همتیمی\u200cهایشان': 'هم تیمی\u200cهایشان',
                          'پایدار\u200cام\u200cباید': 'پایدار\u200cام \u200cباید',
                          'پرجنبوجوش\u200cتر': 'پر جنب و جوش\u200cتر', 'آبمروارید': 'آب مروارید', 'آتشسوزی': 'آتش سوزی',
                          'آتشنشانی': 'آتش\u200cنشانی', 'آتشنشان': 'آتش\u200cنشان', 'آرامشبخش': 'آرامش بخش',
                          'آشناداشتن': 'آشنا داشتن',
                          'آقاچیزی': 'آقا چیزی', 'آموخت\u200cهام': 'آموخته\u200cام', 'آموزششان': 'آموزش\u200cشان',
                          'ازآنجا': 'از آنجا',
                          'ازالان': 'از الان', 'ازاینجا': 'از اینجا', 'ازجیبش': 'از جیبش', 'ازدستش': 'از دستش',
                          'ازدیوار': 'از دیوار',
                          'ازشغلشون': 'از شغلشون', 'ازوقتی': 'از وقتی', 'ازکسانی': 'از کسانی',
                          'اسباببازی': 'اسباب بازی',
                          'اسبسوار': 'اسب سوار', 'اصیلزاده': 'اصیل زاده', 'افتادهاید': 'افتاده\u200cاید',
                          'ال\u200cهام': 'الهام',
                          'امااصلا': 'اما اصلا', 'امااصلابه': 'اما اصلا به', 'امااین': 'اما این', 'امابعد': 'اما بعد',
                          'امابعدیکی': 'اما بعد یکی', 'اماجاذبه': 'اما جاذبه', 'امرارمعاش': 'امرار معاش',
                          'امکانپذیر': 'امکان پذیر',
                          'انت\u200cهای': 'انتهای', 'انت\u200cهایی': 'انتهایی', 'ایزدبانوی': 'ایزد بانوی',
                          'بااینحال': 'با اینحال',
                          'باحتمال': 'به احتمال', 'باحجاب': 'با حجاب', 'باخنده': 'با خنده', 'بادوستاش': 'با دوستاش',
                          'بارمان': 'بار مان',
                          'باز\u200cتر': 'باز \u200cتر', 'باطعنه': 'با طعنه', 'بافریاد': 'با فریاد',
                          'بارگزاری': 'بارگذاری',
                          'بالامنم': 'بالا منم', 'بگیرمامان': 'بگیر مامان', 'بیاحترامی': 'بی احترامی',
                          'بیادبی': 'بی ادبی',
                          'بیاعتنا': 'بی اعتنا', 'بیدارباش': 'بیدار باش', 'بیشازحد': 'بیش از حد',
                          'بیمسئولیت': 'بی مسئولیت',
                          'تاسفبار': 'تاسف بار', 'تامشکلمون': 'تا مشکلمون', 'تانقشه': 'تا نقشه',
                          'تصمیمگیری': 'تصمیم گیری',
                          'تقسیمبندی': 'تقسیم بندی', 'تقصیرارو': 'تقصیرا رو', 'جدیدابرای': 'جدیدا برای',
                          'جعبهابزار': 'جعبه ابزار',
                          'جلوتونو': 'جلو تو نو', 'حاضردر': 'حاضر در', 'حاضرنیست': 'حاضر نیست',
                          'دستنخورده': 'دست نخورده',
                          'دوامتیاز': 'دو امتیاز', 'دوروزتمام': 'دو روز تمام', 'شخصیسازی': 'شخصی\u200cسازی',
                          'شدواجناس': 'شد و اجناس',
                          'شوهردارم': 'شوهر دارم', 'شوهرشماهم': 'شوهر شما هم', 'شوهرمحترم': 'شوهر محترم',
                          'شکلگیری': 'شکل گیری',
                          'صخرهنوردی': 'صخره\u200cنوردی', 'صدوبیست': 'صد و بیست', 'عقبنشینی': 'عقب نشینی',
                          'عکسالعمل': 'عکس\u200cالعمل',
                          'غرغرمیکنم': 'غرغر میکنم', 'هزاربار': 'هزار بار', 'هزارتومان': 'هزار تومان',
                          'هزارجور': 'هزار جور',
                          'هزاروسیصد': 'هزار و سیصد', 'هممیهنان': 'هم میهنان', 'هممیهنانش': 'هم میهنانش',
                          'همنسلانش': 'هم نسلانش',
                          'همهگیری': 'همه گیری', 'هییییچ': 'هیچ', 'وقتاخیلی': 'وقتا خیلی', 'وقتابه': 'وقتا به',
                          'وقتگذرانی': 'وقت گذرانی',
                          'ومحکوم': 'و محکوم', 'ومحیط\u200cها': 'و محیط\u200cها', 'وکشورتان': 'و کشورتان',
                          'ویکیمدیا': 'ویکی\u200cمدیا',
                          'یهوگفت': 'یهو گفت', 'اینجااز': 'اینجا از', '\ufeffمهماننوازی': 'مهمان\u200cنوازی',
                          'صلیالله': 'صلی\u200cالله',
                          'موافقتنامه': 'موافقت\u200cنامه', 'اعتراضآمیز': 'اعتراض\u200cآمیز',
                          'رییسجمهور': 'رییس\u200cجمهور',
                          'چشمپوشی': 'چشم\u200cپوشی', 'هیئتعلمی': 'هیئت\u200cعلمی\u200c', 'الزامآور': 'الزام\u200cآور',
                          'بیمهنامه': 'بیمه\u200cنامه', 'آییننامه': 'آیین\u200cنامه', 'بتنریزی': 'بتن\u200cریزی',
                          'تشییعجنازه': 'تشییع\u200cجنازه', 'تامینکنندگان': 'تامین\u200cکنندگان',
                          'پرسشنامه': 'پرسش\u200cنامه',
                          'تحتالشعاع': 'تحت\u200cالشعاع', 'شگفتانگیز': 'شگفت\u200cانگیز',
                          'بزرگنمایی': 'بزرگ\u200cنمایی',
                          'نیمههادی': 'نیمه\u200cهادی', 'قابلکنترل': 'قابل\u200cکنترل', 'روانپزشکی': 'روان\u200cپزشکی',
                          'ضربالمثل': 'ضرب\u200cالمثل', 'اضافهکاری': 'اضافه\u200cکاری', 'اختلافنظر': 'اختلاف\u200cنظر',
                          'بینالملل': 'بین\u200cالملل', 'یکطرفه': 'یک\u200cطرفه', 'موجشکن': 'موج\u200cشکن',
                          'عزتنفس': 'عزت\u200cنفس',
                          'بیسیم': 'بی\u200cسیم', 'شیبدار': 'شیب\u200cدار', 'دستیابی': 'دست\u200cیابی',
                          'روانشناختی': 'روان\u200cشناختی',
                          'عقبنشینی': 'عقب\u200cنشینی', 'بهطور': 'به\u200cطور', 'خطچین': 'خط\u200cچین',
                          'ادراکشده': 'ادراک\u200cشده',
                          'خزانهداری': 'خزانه\u200cداری', 'شیمیدرمانی': 'شیمی\u200cدرمانی',
                          'آنسوی': '\u200cآن\u200cسوی',
                          'نقطهچین': 'نقطه\u200cچین', 'منحصربهفرد': 'منحصربه\u200cفرد',
                          'درحالتوسعه': 'درحال\u200cتوسعه',
                          'رضایتبخش': 'رضایت\u200cبخش', 'قرضالحسنه': 'قرض\u200cالحسنه', 'هرجومرج': 'هرج\u200cومرج',
                          'سیبزمینی': 'سیب\u200cزمینی', 'میلیگرم': 'میلی\u200cگرم', 'نخستوزیر': 'نخست\u200cوزیر',
                          'تعیینکنندهای': 'تعیین\u200cکننده\u200cای', 'طاقتفرسا': 'طاقت\u200cفرسا',
                          'قابلمشاهده': 'قابل\u200cمشاهده',
                          'بهوسیله': 'به\u200cوسیله', 'قابلدستیابی': 'قابل\u200cدستیابی', 'الهامبخش': 'الهام\u200cبخش',
                          'پیدرپی': 'پی\u200cدرپی', 'سرمایهداری': 'سرمایه\u200cداری', 'لذتبخش': 'لذت\u200cبخش',
                          'تخمگذار': 'تخم\u200cگذار',
                          'گرمکن': 'گرم\u200cکن', 'قابلتوجهی': 'قابل\u200cتوجهی', 'فیلمبرداری': 'فیلم\u200cبرداری',
                          'خدمتدهی': 'خدمت\u200cدهی', 'معنیدار': 'معنی\u200cدار', 'کلانشهری': 'کلان\u200cشهری',
                          'گواهینامه': 'گواهی\u200cنامه', 'همجنس': 'هم\u200cجنس', 'همانطور': 'همان\u200cطور',
                          'سیستمعامل': 'سیستم\u200cعامل',
                          'حملونقل': 'حمل\u200cونقل', 'تفاهمنامه': 'تفاهم\u200cنامه', 'بینالمللی': 'بین\u200cالمللی',
                          'کلاهبرداری': 'کلاه\u200cبرداری', 'نرمافزار': 'نرم\u200cافزار', 'مضافالیه': 'مضاف\u200cالیه',
                          'قطعنامهای': 'قطعنامه\u200cای', 'پاسخگویی': 'پاسخ\u200cگویی', 'عکسبرداری': 'عکس\u200cبرداری',
                          'پسلرزه': 'پس\u200cلرزه', 'خردهفروشی': 'خرده\u200cفروشی', 'حقوقبشر': 'حقوق\u200cبشر',
                          'تحلیلگران': 'تحلیل\u200cگران', 'اینگونه': 'این\u200cگونه', 'صرفهجویی': 'صرفه\u200cجویی',
                          'علیالخصوص': 'علی\u200cالخصوص', 'کلانشهرها': 'کلان\u200cشهرها', 'حاصلضرب': 'حاصل\u200cضرب',
                          'اطلاعرسانی': 'اطلاع\u200cرسانی', 'دندانپزشکی': 'دندان\u200cپزشکی', 'پیشبرد': 'پیش\u200cبرد',
                          'ایدهال': 'ایده\u200cال', 'هیچگاه': 'هیچ\u200cگاه', 'صنایعدستی': 'صنایع\u200cدستی',
                          'سانتیمتر': 'سانتی\u200cمتر',
                          'پیشبینی': 'پیش\u200cبینی', 'خلیجفارس': 'خلیج\u200cفارس', 'تاریخنگاری': 'تاریخ\u200cنگاری',
                          'هیچگونه': 'هیچ\u200cگونه', 'راهاندازی': 'راه\u200cاندازی', 'جستوجوی': 'جست\u200cوجوی',
                          'حاشیهنشینی': 'حاشیه\u200cنشینی', 'رنگآمیزی': 'رنگ\u200cآمیزی',
                          'جمعآوری': 'جمع\u200c\u200cآوری',
                          'وقتگیر': 'وقت\u200cگیر', 'آرامبخش': 'آرام\u200cبخش', 'غربزدگی': 'غرب\u200cزدگی',
                          'کلانشهر': 'کلان\u200cشهر',
                          'نرمافزاری': 'نرم\u200cافزاری', 'بدینوسیله': 'بدین\u200cوسیله', 'جمعبندی': 'جمع\u200cبندی',
                          'گفتوگو': 'گفت\u200cوگو', 'آیتالله': 'آیت\u200cالله', 'حجتالاسلام': 'حجت\u200cالاسلام',
                          'حجتالاسلاموالمسلمین': 'حجت\u200cالاسلام\u200cوالمسلمین',
                          'آیتاللهالعظمی': 'آیت\u200cالله\u200cالعظمی'}
