TITLE Mod file for component: Component(id=syn0 type=impulseSynapse)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.5.4
         org.neuroml.model   v1.5.4
         jLEMS               v0.9.9.1

ENDCOMMENT

NEURON {
    POINT_PROCESS syn0
    RANGE PAMPERE                           : parameter
    RANGE TSMALL                            : parameter
    
    RANGE i                                 : exposure
    
    
    NONSPECIFIC_CURRENT i 
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    PAMPERE = 0.001 (nA)
    TSMALL = 0.0025 (ms)
}

ASSIGNED {
    ? Standard Assigned variables with baseSynapse
    v (mV)
    celsius (degC)
    temperature (K)
    
    i (nA)                                 : derived variable
    rate_impulse (/ms)
    rate_tlast (ms/ms)
    
}

STATE {
    impulse  
    tlast (ms) 
    
}

INITIAL {
    temperature = celsius + 273.15
    
    rates()
    rates() ? To ensure correct initialisation.
    
    impulse = 0
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    
    if (t >   tlast  +  TSMALL) {
        impulse = 0 ? standard OnCondition
    }
    
    
}

NET_RECEIVE(weight) {
    
    : paramMappings . : {syn0={impulse=impulse, tlast=tlast, PAMPERE=PAMPERE, TSMALL=TSMALL, i=i}}
    : state_discontinuity(impulse, weight) : From syn0
    impulse = weight : From syn0
    
    : paramMappings . : {syn0={impulse=impulse, tlast=tlast, PAMPERE=PAMPERE, TSMALL=TSMALL, i=i}}
    : state_discontinuity(tlast, t) : From syn0
    tlast = t : From syn0
    
}

DERIVATIVE states {
    rates()
    impulse' = rate_impulse 
    tlast' = rate_tlast 
    
}

PROCEDURE rates() {
    
    i = -1 * PAMPERE  *  impulse ? evaluable
    rate_impulse = 0 ? Note units of all quantities used here need to be consistent!
    rate_tlast = 0 ? Note units of all quantities used here need to be consistent!
    
     
    
}

