'''
NETPYNE simulator compliant export for:

Components:
    null (Type: notes)
    i_clamp (Type: pulseGenerator:  delay=0.2 (SI time) duration=0.6 (SI time) amplitude=9.9E-10 (SI current))
    testcell (Type: IF_cond_alpha:  e_rev_E=0.0 (dimensionless) e_rev_I=-70.0 (dimensionless) tau_refrac=5.0 (dimensionless) v_thresh=-50.0 (dimensionless) tau_m=20.0 (dimensionless) v_rest=-65.0 (dimensionless) v_reset=-65.0 (dimensionless) cm=1.0 (dimensionless) i_offset=0.1 (dimensionless) tau_syn_E=0.3 (dimensionless) tau_syn_I=0.5 (dimensionless) v_init=-65.0 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NFARAD=1.0E-9 (SI capacitance))
    testcell2 (Type: IF_cond_alpha:  e_rev_E=-10.0 (dimensionless) e_rev_I=-80.0 (dimensionless) tau_refrac=5.0 (dimensionless) v_thresh=-50.0 (dimensionless) tau_m=20.0 (dimensionless) v_rest=-65.0 (dimensionless) v_reset=-65.0 (dimensionless) cm=1.0 (dimensionless) i_offset=-0.1 (dimensionless) tau_syn_E=2.0 (dimensionless) tau_syn_I=10.0 (dimensionless) v_init=-65.0 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NFARAD=1.0E-9 (SI capacitance))
    ampaSyn (Type: alphaCondSynapse:  e_rev=-10.0 (dimensionless) tau_syn=2.0 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NAMP=1.0E-9 (SI current))
    gabaSyn (Type: alphaCondSynapse:  e_rev=-80.0 (dimensionless) tau_syn=10.0 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NAMP=1.0E-9 (SI current))
    Example4_PyNN (Type: network)
    SimExample4 (Type: Simulation:  length=1.0 (SI time) step=1.0E-5 (SI time))


    This NETPYNE file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.0
         org.neuroml.model   v1.8.0
         jLEMS               v0.10.5

'''
# Main NetPyNE script for: Example4_PyNN

# See https://github.com/Neurosim-lab/netpyne

from netpyne import specs  # import netpyne specs module
from netpyne import sim    # import netpyne sim module
from netpyne import __version__ as version

from neuron import h

import sys
import time
import datetime

class NetPyNESimulation():

    def __init__(self, tstop, dt, seed=123456789, save_json=False):

        self.setup_start = time.time()
        
        self.report_file = open('report.SimExample4.txt','w')
        self.report_file.write('# Report of running simulation with NetPyNE v%s\n'%version)
        self.report_file.write('Simulator=NetPyNE\n')
        self.report_file.write('SimulatorVersion=%s\n'%version)
        self.report_file.write('SimulationFile=%s\n'%__file__)
        self.report_file.write('PythonVersion=%s\n'%sys.version.replace('\n',' '))
        self.report_file.write('NeuronVersion=%s\n'%h.nrnversion())
        self.report_file.write('NeuroMLExportVersion=1.8.0\n')
        

        ###############################################################################
        # NETWORK PARAMETERS
        ###############################################################################

        self.nml2_file_name = 'Example4_PyNN.net.nml'

        ###############################################################################
        # SIMULATION PARAMETERS
        ###############################################################################

        self.simConfig = specs.SimConfig()   # object of class SimConfig to store the simulation configuration

        # Simulation parameters
        self.simConfig.duration = self.simConfig.tstop = tstop # Duration of the simulation, in ms
        self.simConfig.dt = dt # Internal integration timestep to use

        # Seeds for randomizers (connectivity, input stimulation and cell locations)
        # Note: locations and connections should be fully specified by the structure of the NeuroML,
        # so seeds for conn & loc shouldn't affect networks structure/behaviour
        self.simConfig.seeds = {'conn': 0, 'stim': 5678, 'loc': 0} 

        self.simConfig.createNEURONObj = 1  # create HOC objects when instantiating network
        self.simConfig.createPyStruct = 1  # create Python structure (simulator-independent) when instantiating network
        self.simConfig.verbose = False  # show detailed messages 
        
        # Recording 
        self.simConfig.recordCells = ['all']  
        self.simConfig.recordTraces = {}
        self.simConfig.saveCellSecs=False
        self.simConfig.saveCellConns=False
        self.simConfig.gatherOnlySimData=True 

                # For saving to file: SimExample4.pop0.v.dat (ref: SimExample4_pop0_v_dat)
                                
        # Column: pop0_0_testcell_v: Pop: pop0; cell: 0; segment id: $oc.segment_id; segment name: soma; Neuron loc: soma(0.5); value: v (v)
        self.simConfig.recordTraces['SimExample4_pop0_v_dat_pop0_0_soma_v'] = {'sec':'soma','loc':0.5,'var':'v','conds':{'pop':'pop0','cellLabel':0}}
                                
        # Column: pop0_1_testcell_v: Pop: pop0; cell: 1; segment id: $oc.segment_id; segment name: soma; Neuron loc: soma(0.5); value: v (v)
        self.simConfig.recordTraces['SimExample4_pop0_v_dat_pop0_1_soma_v'] = {'sec':'soma','loc':0.5,'var':'v','conds':{'pop':'pop0','cellLabel':1}}
                        
                # For saving to file: SimExample4.pop1.v.dat (ref: SimExample4_pop1_v_dat)
                                
        # Column: pop1_0_testcell2_v: Pop: pop1; cell: 0; segment id: $oc.segment_id; segment name: soma; Neuron loc: soma(0.5); value: v (v)
        self.simConfig.recordTraces['SimExample4_pop1_v_dat_pop1_0_soma_v'] = {'sec':'soma','loc':0.5,'var':'v','conds':{'pop':'pop1','cellLabel':0}}
                                
        # Column: pop1_1_testcell2_v: Pop: pop1; cell: 1; segment id: $oc.segment_id; segment name: soma; Neuron loc: soma(0.5); value: v (v)
        self.simConfig.recordTraces['SimExample4_pop1_v_dat_pop1_1_soma_v'] = {'sec':'soma','loc':0.5,'var':'v','conds':{'pop':'pop1','cellLabel':1}}
                        
                # For saving to file: SimExample4.pop2.v.dat (ref: SimExample4_pop2_v_dat)
                                
        # Column: pop2_0_testcell2_v: Pop: pop2; cell: 0; segment id: $oc.segment_id; segment name: soma; Neuron loc: soma(0.5); value: v (v)
        self.simConfig.recordTraces['SimExample4_pop2_v_dat_pop2_0_soma_v'] = {'sec':'soma','loc':0.5,'var':'v','conds':{'pop':'pop2','cellLabel':0}}
                        
        
        self.simConfig.plotCells = ['all']

        self.simConfig.recordStim = True  # record spikes of cell stims
        self.simConfig.recordStep = self.simConfig.dt # Step size in ms to save data (eg. V traces, LFP, etc)

        # Analysis and plotting, see http://neurosimlab.org/netpyne/reference.html#analysis-related-functions
        self.simConfig.analysis['plotRaster'] = False  # Plot raster
        self.simConfig.analysis['plot2Dnet'] = False  # Plot 2D net cells and connections
        self.simConfig.analysis['plotSpikeHist'] = False # plot spike histogram
        self.simConfig.analysis['plotConn'] = False # plot network connectivity
        self.simConfig.analysis['plotSpikePSD'] = False # plot 3d architecture

        # Saving
        self.simConfig.filename = 'Example4_PyNN.txt'  # Set file output name
        self.simConfig.saveFileStep = self.simConfig.dt # step size in ms to save data to disk
        # self.simConfig.saveDat = True # save to dat file
        self.simConfig.saveJson = save_json # save to json file


    def run(self):

        ###############################################################################
        # IMPORT & RUN
        ###############################################################################

        print("Running a NetPyNE based simulation for %sms (dt: %sms) at %s degC"%(self.simConfig.duration, self.simConfig.dt, self.simConfig.hParams['celsius']))

        self.setup_sim_start = time.time()
        self.gids = sim.importNeuroML2SimulateAnalyze(self.nml2_file_name,self.simConfig)

        self.sim_end = time.time()
        self.setup_sim_time = self.sim_end - self.setup_sim_start
        print("Finished NetPyNE simulation in %f seconds (%f mins)..."%(self.setup_sim_time, self.setup_sim_time/60.0))

        try:
            self.save_results()
        except Exception as e:
            print("Exception saving results of NetPyNE simulation: %s" % (e))
            return


    def save_results(self):

        ###############################################################################
        #   Saving data (this ensures the data gets saved in the format/files 
        #   as specified in the LEMS <Simulation> element)
        ###############################################################################

        if sim.rank==0: 
        
            print("Saving traces to file: SimExample4.pop0.v.dat (ref: SimExample4_pop0_v_dat)")

                
            # Column: t
            col_SimExample4_pop0_v_dat_t = [i*self.simConfig.dt for i in range(int(self.simConfig.duration/self.simConfig.dt))]
                        
            # Column: pop0_0_testcell_v: Pop: pop0; cell: 0; segment id: $oc.segment_id; segment name: soma; value: v
            col_SimExample4_pop0_v_dat_pop0_0_testcell_v = sim.allSimData['SimExample4_pop0_v_dat_pop0_0_soma_v']['cell_%s'%self.gids['pop0'][0]]
                        
            # Column: pop0_1_testcell_v: Pop: pop0; cell: 1; segment id: $oc.segment_id; segment name: soma; value: v
            col_SimExample4_pop0_v_dat_pop0_1_testcell_v = sim.allSimData['SimExample4_pop0_v_dat_pop0_1_soma_v']['cell_%s'%self.gids['pop0'][1]]
                
            dat_file_SimExample4_pop0_v_dat = open('SimExample4.pop0.v.dat', 'w')
            for i in range(len(col_SimExample4_pop0_v_dat_t)):
                dat_file_SimExample4_pop0_v_dat.write( '%s\t'%(col_SimExample4_pop0_v_dat_t[i]/1000.0) +  '%s\t'%(col_SimExample4_pop0_v_dat_pop0_0_testcell_v[i]/1000.0) +  '%s\t'%(col_SimExample4_pop0_v_dat_pop0_1_testcell_v[i]/1000.0) +  '\n')
            dat_file_SimExample4_pop0_v_dat.close()

        
            print("Saving traces to file: SimExample4.pop1.v.dat (ref: SimExample4_pop1_v_dat)")

                
            # Column: t
            col_SimExample4_pop1_v_dat_t = [i*self.simConfig.dt for i in range(int(self.simConfig.duration/self.simConfig.dt))]
                        
            # Column: pop1_0_testcell2_v: Pop: pop1; cell: 0; segment id: $oc.segment_id; segment name: soma; value: v
            col_SimExample4_pop1_v_dat_pop1_0_testcell2_v = sim.allSimData['SimExample4_pop1_v_dat_pop1_0_soma_v']['cell_%s'%self.gids['pop1'][0]]
                        
            # Column: pop1_1_testcell2_v: Pop: pop1; cell: 1; segment id: $oc.segment_id; segment name: soma; value: v
            col_SimExample4_pop1_v_dat_pop1_1_testcell2_v = sim.allSimData['SimExample4_pop1_v_dat_pop1_1_soma_v']['cell_%s'%self.gids['pop1'][1]]
                
            dat_file_SimExample4_pop1_v_dat = open('SimExample4.pop1.v.dat', 'w')
            for i in range(len(col_SimExample4_pop1_v_dat_t)):
                dat_file_SimExample4_pop1_v_dat.write( '%s\t'%(col_SimExample4_pop1_v_dat_t[i]/1000.0) +  '%s\t'%(col_SimExample4_pop1_v_dat_pop1_0_testcell2_v[i]/1000.0) +  '%s\t'%(col_SimExample4_pop1_v_dat_pop1_1_testcell2_v[i]/1000.0) +  '\n')
            dat_file_SimExample4_pop1_v_dat.close()

        
            print("Saving traces to file: SimExample4.pop2.v.dat (ref: SimExample4_pop2_v_dat)")

                
            # Column: t
            col_SimExample4_pop2_v_dat_t = [i*self.simConfig.dt for i in range(int(self.simConfig.duration/self.simConfig.dt))]
                        
            # Column: pop2_0_testcell2_v: Pop: pop2; cell: 0; segment id: $oc.segment_id; segment name: soma; value: v
            col_SimExample4_pop2_v_dat_pop2_0_testcell2_v = sim.allSimData['SimExample4_pop2_v_dat_pop2_0_soma_v']['cell_%s'%self.gids['pop2'][0]]
                
            dat_file_SimExample4_pop2_v_dat = open('SimExample4.pop2.v.dat', 'w')
            for i in range(len(col_SimExample4_pop2_v_dat_t)):
                dat_file_SimExample4_pop2_v_dat.write( '%s\t'%(col_SimExample4_pop2_v_dat_t[i]/1000.0) +  '%s\t'%(col_SimExample4_pop2_v_dat_pop2_0_testcell2_v[i]/1000.0) +  '\n')
            dat_file_SimExample4_pop2_v_dat.close()

        
        
            print("Saving spikes to file: SimExample4.pop0.spikes (ref: SimExample4_pop0_spikes)")
            to_record = {}
        
            # 0: Pop: pop0; cell: 0; segment id: $oc.segment_id; segment name: soma; value: spike
        
            to_record[self.gids['pop0'][0]] = 0
        
            # 1: Pop: pop0; cell: 1; segment id: $oc.segment_id; segment name: soma; value: spike
        
            to_record[self.gids['pop0'][1]] = 1
        
            spike_file_SimExample4_pop0_spikes = open('SimExample4.pop0.spikes', 'w')
            to_record_keys = to_record.keys()
            for t, id in zip(sim.allSimData['spkt'],sim.allSimData['spkid']):
                if id in to_record_keys:
        
                    spike_file_SimExample4_pop0_spikes.write('%i\t%s\n'%(to_record[id],t/1000.))   # format: ID_TIME
        
            spike_file_SimExample4_pop0_spikes.close()

        
            save_end = time.time()
            save_time = save_end - self.sim_end
            print("Finished saving results in %f seconds"%(save_time))


           
            self.report_file.write('StartTime=%s\n'%datetime.datetime.fromtimestamp(self.setup_start).strftime('%Y-%m-%d %H:%M:%S'))
            self.report_file.write('RealSetupAndSimulationTime=%s\n'%self.setup_sim_time)
            self.report_file.write('SimulationSaveTime=%s\n'%save_time)
            self.report_file.close()
            print("Saving report of simulation to %s"%('report.SimExample4.txt'))
        
if __name__ == '__main__':

    save_json = '-json' in sys.argv

    ns = NetPyNESimulation(tstop=1000.0, dt=0.01, seed=5678, save_json=save_json)

    ns.run()

    if '-nogui' in sys.argv:
        quit()
