import unittest

import numpy as np
from numpy import testing

from labanotation import calculate_labanotation
from labanotation.labanotation_utils import laban2vec
from labanotation.labanotation_utils import segmentation_from_labanotations


class TestLabanotationUtils(unittest.TestCase):

    def test_calculate_labanotation(self):
        _, _, _, _, elbow_r, elbow_l, wrist_r, wrist_l = \
            calculate_labanotation(
                spine_position=(0, 0, 0),
                shoulder_r_position=(0, -1, 1), shoulder_l_position=(0, 1, 1),
                elbow_r_position=(0, -2, 1), elbow_l_position=(0, 2, 1),
                wrist_r_position=(0, -3, 1), wrist_l_position=(0, 3, 1))

        self.assertEqual(elbow_r[0], 'Right')
        self.assertEqual(elbow_r[1], 'Middle')
        self.assertEqual(elbow_l[0], 'Left')
        self.assertEqual(elbow_l[1], 'Middle')
        self.assertEqual(wrist_r[0], 'Right')
        self.assertEqual(wrist_r[1], 'Middle')
        self.assertEqual(wrist_l[0], 'Left')
        self.assertEqual(wrist_l[1], 'Middle')

        _, _, _, _, elbow_r, elbow_l, wrist_r, wrist_l = \
            calculate_labanotation(
                (0, 0, 0),
                (0, -1, 1), (0, 1, 1),
                (1, -1, 1), (0, 2, 1),
                (2, -1, 1), (0, 3, 1))

        self.assertEqual(elbow_r[0], 'Forward')
        self.assertEqual(elbow_r[1], 'Middle')
        self.assertEqual(elbow_l[0], 'Left')
        self.assertEqual(elbow_l[1], 'Middle')
        self.assertEqual(wrist_r[0], 'Forward')
        self.assertEqual(wrist_r[1], 'Middle')
        self.assertEqual(wrist_l[0], 'Left')
        self.assertEqual(wrist_l[1], 'Middle')

        _, _, _, _, elbow_r, elbow_l, wrist_r, wrist_l = \
            calculate_labanotation(
                spine_position=(0, 0, 0),
                shoulder_r_position=(0, -1, 1), shoulder_l_position=(0, 1, 1),
                elbow_r_position=(0, -2, 1), elbow_l_position=(0, 2, 1),
                wrist_r_position=(0, -3, 1), wrist_l_position=(0, 3, 1),
                base_rotation=np.eye(3))

    def test_segmentation_from_labanotations(self):
        labans = [['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Low'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Normal'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right Forward', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Right Backward', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low'],
                  ['Place', 'Low']]
        sections = [[0, 151], [152, 187], [188, 217],
                    [218, 224], [225, 254], [255, 352],
                    [353, 361], [362, 371], [372, 384],
                    [385, 451]]
        self.assertEqual(
            segmentation_from_labanotations(labans),
            sections)

    def test_laban2vec(self):
        limb = 'right elbow'
        laban = ['start time:1', 'duration:0', 'head:forward:normal', 'right elbow:place:low', 'right wrist:forward:low', 'left elbow:place:low', 'left wrist:forward:low', 'Rotation:ToLeft:0.0']  # NOQA
        vec = laban2vec(laban, limb)
        testing.assert_almost_equal(
            vec, (0.0, -4.980973467754132, 0.4357789732529257),
            decimal=4)
