/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  root["Bokeh"] = factory();
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);e(2),_.__exportStar(e(109),t)},
function _(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
Object.defineProperty(n,"__esModule",{value:!0});var r=function(t,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)};function o(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function a(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function i(t){return this instanceof i?(this.v=t,this):new i(t)}n.__extends=function(t,e){function n(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var u=t.length-1;u>=0;u--)(o=t[u])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{c(r.next(t))}catch(t){a(t)}}function u(t){try{c(r.throw(t))}catch(t){a(t)}}function c(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,u)}c((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:u(0),throw:u(1),return:u(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function u(a){return function(u){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,u])}}},n.__exportStar=function(t,e){for(var n in t)e.hasOwnProperty(n)||(e[n]=t[n])},n.__values=o,n.__read=a,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(a(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,u=a.length;i<u;i++,o++)r[o]=a[i];return r},n.__await=i,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},u("next"),u("throw"),u("return"),r[Symbol.asyncIterator]=function(){return this},r;function u(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof i?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:i(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=o(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),e(3),e(12),e(15),e(22),e(52),e(55),e(58),e(94),e(101),e(107),"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(e){for(var t=0;t<this.length;t++)this[t]=e[t]})},
function _(e,n,a){e(4)()||Object.defineProperty(Object,"assign",{value:e(5),configurable:!0,enumerable:!1,writable:!0})},
function _(r,t,o){t.exports=function(){var r,t=Object.assign;return"function"==typeof t&&(t(r={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),r.foo+r.bar+r.trzy==="razdwatrzy")}},
function _(t,r,n){var o=t(6),c=t(11),a=Math.max;r.exports=function(t,r){var n,f,h,i=a(arguments.length,2);for(t=Object(c(t)),h=function(o){try{t[o]=r[o]}catch(t){n||(n=t)}},f=1;f<i;++f)r=arguments[f],o(r).forEach(h);if(void 0!==n)throw n;return t}},
function _(e,t,c){t.exports=e(7)()?Object.keys:e(8)},
function _(t,r,e){r.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},
function _(t,e,n){var c=t(9),r=Object.keys;e.exports=function(t){return r(c(t)?Object(t):t)}},
function _(n,r,t){var u=n(10)();r.exports=function(n){return n!==u&&null!==n}},
function _(n,o,t){o.exports=function(){}},
function _(n,r,e){var o=n(9);r.exports=function(n){if(!o(n))throw new TypeError("Cannot use null or undefined");return n}},
function _(e,r,n){e(13)()||Object.defineProperty(Number,"isInteger",{value:e(14),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,e){t.exports=function(){var n=Number.isInteger;return"function"==typeof n&&(!n("23")&&n(34)&&!n(32.34))}},
function _(n,t,e){t.exports=function(n){return"number"==typeof n&&n%1==0}},
function _(e,r,t){e(16)()||Object.defineProperty(String.prototype,"repeat",{value:e(17),configurable:!0,enumerable:!1,writable:!0})},
function _(o,f,t){f.exports=function(){return"function"==typeof"foo".repeat&&"foofoo"==="foo".repeat(2)}},
function _(r,n,t){var o=r(11),e=r(18);n.exports=function(r){var n,t=String(o(this));if((r=e(r))<0)throw new RangeError("Count must be >= 0");if(!isFinite(r))throw new RangeError("Count must be < ∞");for(n="";r;)r%2&&(n+=t),r>1&&(t+=t),r>>=1;return n}},
function _(t,i,n){var r=t(19),a=Math.abs,o=Math.floor;i.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?r(t)*o(a(t)):t}},
function _(n,t,i){t.exports=n(20)()?Math.sign:n(21)},
function _(n,t,o){t.exports=function(){var n=Math.sign;return"function"==typeof n&&(1===n(10)&&-1===n(-20))}},
function _(n,r,t){r.exports=function(n){return n=Number(n),isNaN(n)||0===n?n:n>0?1:-1}},
function _(e,r,a){e(23)()||Object.defineProperty(Array,"from",{value:e(24),configurable:!0,enumerable:!1,writable:!0})},
function _(n,o,r){o.exports=function(){var n,o,r=Array.from;return"function"==typeof r&&(o=r(n=["raz","dwa"]),Boolean(o&&o!==n&&"dwa"===o[1]))}},
function _(e,l,r){var n=e(25).iterator,t=e(47),a=e(48),i=e(49),u=e(50),o=e(11),f=e(9),c=e(51),v=Array.isArray,h=Function.prototype.call,y={configurable:!0,enumerable:!0,writable:!0,value:null},s=Object.defineProperty;l.exports=function(e){var l,r,A,g,p,w,b,d,x,j,O=arguments[1],m=arguments[2];if(e=Object(o(e)),f(O)&&u(O),this&&this!==Array&&a(this))l=this;else{if(!O){if(t(e))return 1!==(p=e.length)?Array.apply(null,e):((g=new Array(1))[0]=e[0],g);if(v(e)){for(g=new Array(p=e.length),r=0;r<p;++r)g[r]=e[r];return g}}g=[]}if(!v(e))if(void 0!==(x=e[n])){for(b=u(x).call(e),l&&(g=new l),d=b.next(),r=0;!d.done;)j=O?h.call(O,m,d.value,r):d.value,l?(y.value=j,s(g,r,y)):g[r]=j,d=b.next(),++r;p=r}else if(c(e)){for(p=e.length,l&&(g=new l),r=0,A=0;r<p;++r)j=e[r],r+1<p&&(w=j.charCodeAt(0))>=55296&&w<=56319&&(j+=e[++r]),j=O?h.call(O,m,j,A):j,l?(y.value=j,s(g,A,y)):g[A]=j,++A;p=A}if(void 0===p)for(p=i(e.length),l&&(g=new l(p)),r=0;r<p;++r)j=O?h.call(O,m,e[r],r):e[r],l?(y.value=j,s(g,r,y)):g[r]=j;return l&&(y.value=null,g.length=p),g}},
function _(o,n,t){n.exports=o(26)()?o(27).Symbol:o(30)},
function _(t,o,r){var e=t(27),n={object:!0,symbol:!0};o.exports=function(){var t,o=e.Symbol;if("function"!=typeof o)return!1;t=o("test symbol");try{String(t)}catch(t){return!1}return!!n[typeof o.iterator]&&(!!n[typeof o.toPrimitive]&&!!n[typeof o.toStringTag])}},
function _(o,i,l){i.exports=o(28)()?globalThis:o(29)},
function _(o,r,l){r.exports=function(){return"object"==typeof globalThis&&(!!globalThis&&globalThis.Array===Array)}},
function _(t,e,o){var r=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()},
function _(t,o,r){var n,e,i,c=t(31),p=t(42),y=t(27).Symbol,s=t(44),u=t(45),f=t(46),_=Object.create,a=Object.defineProperties,S=Object.defineProperty;if("function"==typeof y)try{String(y()),i=!0}catch(t){}else y=null;e=function(t){if(this instanceof e)throw new TypeError("Symbol is not a constructor");return n(t)},o.exports=n=function t(o){var r;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return i?y(o):(r=_(e.prototype),o=void 0===o?"":String(o),a(r,{__description__:c("",o),__name__:c("",s(o))}))},u(n),f(n),a(e.prototype,{constructor:c(n),toString:c("",(function(){return this.__name__}))}),a(n.prototype,{toString:c((function(){return"Symbol ("+p(this).__description__+")"})),valueOf:c((function(){return p(this)}))}),S(n.prototype,n.toPrimitive,c("",(function(){var t=p(this);return"symbol"==typeof t?t:t.toString()}))),S(n.prototype,n.toStringTag,c("c","Symbol")),S(e.prototype,n.toStringTag,c("c",n.prototype[n.toStringTag])),S(e.prototype,n.toPrimitive,c("c",n.prototype[n.toPrimitive]))},
function _(l,e,n){var r=l(32),a=l(33),t=l(37),c=l(38),i=l(39);(e.exports=function(l,e){var n,a,o,u,v;return arguments.length<2||"string"!=typeof l?(u=e,e=l,l=null):u=arguments[2],r(l)?(n=i.call(l,"c"),a=i.call(l,"e"),o=i.call(l,"w")):(n=o=!0,a=!1),v={value:e,configurable:n,enumerable:a,writable:o},u?t(c(u),v):v}).gs=function(l,e,n){var o,u,v,f;return"string"!=typeof l?(v=n,n=e,e=l,l=null):v=arguments[3],r(e)?a(e)?r(n)?a(n)||(v=n,n=void 0):n=void 0:(v=e,e=n=void 0):e=void 0,r(l)?(o=i.call(l,"c"),u=i.call(l,"e")):(o=!0,u=!1),f={get:e,set:n,configurable:o,enumerable:u},v?t(c(v),f):f}},
function _(n,t,u){t.exports=function(n){return null!=n}},
function _(t,n,o){var r=t(34),s=/^\s*class[\s{/}]/,c=Function.prototype.toString;n.exports=function(t){return!!r(t)&&!s.test(c.call(t))}},
function _(t,n,r){var e=t(35);n.exports=function(t){if("function"!=typeof t)return!1;if(!hasOwnProperty.call(t,"length"))return!1;try{if("number"!=typeof t.length)return!1;if("function"!=typeof t.call)return!1;if("function"!=typeof t.apply)return!1}catch(t){return!1}return!e(t)}},
function _(r,t,n){var o=r(36);t.exports=function(r){if(!o(r))return!1;try{return!!r.constructor&&r.constructor.prototype===r}catch(r){return!1}}},
function _(n,t,e){var o=n(32),r={object:!0,function:!0,undefined:!0};t.exports=function(n){return!!o(n)&&hasOwnProperty.call(r,typeof n)}},
function _(n,s,t){s.exports=n(4)()?Object.assign:n(5)},
function _(r,n,t){var c=r(9),o=Array.prototype.forEach,a=Object.create,e=function(r,n){var t;for(t in r)n[t]=r[t]};n.exports=function(r){var n=a(null);return o.call(arguments,(function(r){c(r)&&e(Object(r),n)})),n}},
function _(t,n,o){n.exports=t(40)()?String.prototype.contains:t(41)},
function _(n,o,t){var a="razdwatrzy";o.exports=function(){return"function"==typeof a.contains&&(!0===a.contains("dwa")&&!1===a.contains("foo"))}},
function _(t,n,r){var i=String.prototype.indexOf;n.exports=function(t){return i.call(this,t,arguments[1])>-1}},
function _(r,n,o){var t=r(43);n.exports=function(r){if(!t(r))throw new TypeError(r+" is not a symbol");return r}},
function _(o,t,n){t.exports=function(o){return!!o&&("symbol"==typeof o||!!o.constructor&&("Symbol"===o.constructor.name&&"Symbol"===o[o.constructor.toStringTag]))}},
function _(t,e,n){var r=t(31),o=Object.create,c=Object.defineProperty,u=Object.prototype,f=o(null);e.exports=function(t){for(var e,n,o=0;f[t+(o||"")];)++o;return f[t+=o||""]=!0,c(u,e="@@"+t,r.gs(null,(function(t){n||(n=!0,c(this,e,r(t)),n=!1)}))),e}},
function _(e,t,a){var s=e(31),i=e(27).Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:s("",i&&i.hasInstance||e("hasInstance")),isConcatSpreadable:s("",i&&i.isConcatSpreadable||e("isConcatSpreadable")),iterator:s("",i&&i.iterator||e("iterator")),match:s("",i&&i.match||e("match")),replace:s("",i&&i.replace||e("replace")),search:s("",i&&i.search||e("search")),species:s("",i&&i.species||e("species")),split:s("",i&&i.split||e("split")),toPrimitive:s("",i&&i.toPrimitive||e("toPrimitive")),toStringTag:s("",i&&i.toStringTag||e("toStringTag")),unscopables:s("",i&&i.unscopables||e("unscopables"))})}},
function _(r,n,e){var t=r(31),i=r(42),o=Object.create(null);n.exports=function(r){return Object.defineProperties(r,{for:t((function(n){return o[n]?o[n]:o[n]=r(String(n))})),keyFor:t((function(r){var n;for(n in i(r),o)if(o[n]===r)return n}))})}},
function _(t,n,r){var o=Object.prototype.toString,c=o.call(function(){return arguments}());n.exports=function(t){return o.call(t)===c}},
function _(t,o,n){var e=Object.prototype.toString,c=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);o.exports=function(t){return"function"==typeof t&&c(e.call(t))}},
function _(n,t,r){var a=n(18),o=Math.max;t.exports=function(n){return o(0,a(n))}},
function _(n,o,t){o.exports=function(n){if("function"!=typeof n)throw new TypeError(n+" is not a function");return n}},
function _(t,n,o){var e=Object.prototype.toString,r=e.call("");n.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||e.call(t)===r)||!1}},
function _(e,a,l){e(53)()||Object.defineProperty(Math,"log10",{value:e(54),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o){t.exports=function(){var n=Math.log10;return"function"==typeof n&&.3010299956639812===n(2)}},
function _(t,a,n){var r=Math.log,N=Math.LOG10E;a.exports=function(t){return isNaN(t)||(t=Number(t))<0?NaN:0===t?-1/0:1===t?0:t===1/0?1/0:r(t)*N}},
function _(e,a,l){e(56)()||Object.defineProperty(Math,"log1p",{value:e(57),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o){t.exports=function(){var n=Math.log1p;return"function"==typeof n&&.6931471805599453===n(1)}},
function _(e,n,r){var t=Math.log;n.exports=function(e){return isNaN(e)||(e=Number(e))<-1?NaN:-1===e?-1/0:0===e?e:e===1/0?1/0:e>-1e-8&&e<1e-8?e-e*e/2:t(1+e)}},
function _(e,n,r){e(59)()||Object.defineProperty(e(60),"Set",{value:e(61),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;return"function"==typeof Set&&(t=new Set(["raz","dwa","trzy"]),"[object Set]"===String(t)&&(3===t.size&&("function"==typeof t.add&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.values&&(!1===(e=t.values().next()).done&&"raz"===e.value)))))))))))}},
function _(t,e,o){var r=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;if("object"==typeof globalThis&&globalThis)return globalThis;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()},
function _(t,e,n){var r,i,s,o=t(62),a=t(63),_=t(67),c=t(50),u=t(31),h=t(72),l=t(25),f=t(73),p=t(75),y=t(92),v=t(93),d=Function.prototype.call,D=Object.defineProperty,g=Object.getPrototypeOf;v&&(s=Set),e.exports=r=function(){var t,e=arguments[0];if(!(this instanceof r))throw new TypeError("Constructor requires 'new'");return t=v&&_?_(new s,g(this)):this,null!=e&&f(e),D(t,"__setData__",u("c",[])),e?(p(e,(function(t){-1===a.call(this,t)&&this.push(t)}),t.__setData__),t):t},v&&(_&&_(r,s),r.prototype=Object.create(s.prototype,{constructor:u(r)})),h(Object.defineProperties(r.prototype,{add:u((function(t){return this.has(t)||this.emit("_add",this.__setData__.push(t)-1,t),this})),clear:u((function(){this.__setData__.length&&(o.call(this.__setData__),this.emit("_clear"))})),delete:u((function(t){var e=a.call(this.__setData__,t);return-1!==e&&(this.__setData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:u((function(){return new y(this,"key+value")})),forEach:u((function(t){var e,n,r,i=arguments[1];for(c(t),n=(e=this.values())._next();void 0!==n;)r=e._resolve(n),d.call(t,i,r,r,this),n=e._next()})),has:u((function(t){return-1!==a.call(this.__setData__,t)})),keys:u(i=function(){return this.values()}),size:u.gs((function(){return this.__setData__.length})),values:u((function(){return new y(this)})),toString:u((function(){return"[object Set]"}))})),D(r.prototype,l.iterator,u(i)),D(r.prototype,l.toStringTag,u("c","Set"))},
function _(t,n,i){var r=t(11);n.exports=function(){return r(this).length=0,this}},
function _(t,r,e){var i=t(64),n=t(49),o=t(11),a=Array.prototype.indexOf,h=Object.prototype.hasOwnProperty,s=Math.abs,p=Math.floor;r.exports=function(t){var r,e,f,l;if(!i(t))return a.apply(this,arguments);for(e=n(o(this).length),f=arguments[1],r=f=isNaN(f)?0:f>=0?p(f):n(this.length)-p(s(f));r<e;++r)if(h.call(this,r)&&(l=this[r],i(l)))return r;return-1}},
function _(N,e,i){e.exports=N(65)()?Number.isNaN:N(66)},
function _(n,t,o){t.exports=function(){var n=Number.isNaN;return"function"==typeof n&&(!n({})&&n(NaN)&&!n(34))}},
function _(n,t,o){t.exports=function(n){return n!=n}},
function _(t,e,o){e.exports=t(68)()?Object.setPrototypeOf:t(69)},
function _(t,e,o){var n=Object.create,r=Object.getPrototypeOf,c={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||n;return"function"==typeof t&&r(t(e(null),c))===c}},
function _(e,t,l){var r,o=e(70),n=e(11),u=Object.prototype.isPrototypeOf,_=Object.defineProperty,c={configurable:!0,enumerable:!1,writable:!0,value:void 0};r=function(e,t){if(n(e),null===t||o(t))return e;throw new TypeError("Prototype must be null or an object")},t.exports=function(e){var t,l;return e?(2===e.level?e.set?(l=e.set,t=function(e,t){return l.call(r(e,t),t),e}):t=function(e,t){return r(e,t).__proto__=t,e}:t=function e(t,l){var o;return r(t,l),(o=u.call(e.nullPolyfill,t))&&delete e.nullPolyfill.__proto__,null===l&&(l=e.nullPolyfill),t.__proto__=l,o&&_(e.nullPolyfill,"__proto__",c),t},Object.defineProperty(t,"level",{configurable:!1,enumerable:!1,writable:!1,value:e.level})):null}(function(){var e,t=Object.create(null),l={},r=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(r){try{(e=r.set).call(t,l)}catch(e){}if(Object.getPrototypeOf(t)===l)return{set:e,level:2}}return t.__proto__=l,Object.getPrototypeOf(t)===l?{level:2}:((t={}).__proto__=l,Object.getPrototypeOf(t)===l&&{level:1})}()),e(71)},
function _(n,t,o){var c=n(9),e={function:!0,object:!0};t.exports=function(n){return c(n)&&e[typeof n]||!1}},
function _(e,r,l){var t,n,o,a,i=Object.create;e(68)()||(t=e(69)),r.exports=t?1!==t.level?i:(n={},o={},a={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach((function(e){o[e]="__proto__"!==e?a:{configurable:!0,enumerable:!1,writable:!0,value:void 0}})),Object.defineProperties(n,o),Object.defineProperty(t,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:n}),function(e,r){return i(null===e?n:e,r)}):i},
function _(e,t,n){var i,l,r,c,_,o,s,a=e(31),h=e(50),f=Function.prototype.apply,u=Function.prototype.call,p=Object.create,b=Object.defineProperty,y=Object.defineProperties,O=Object.prototype.hasOwnProperty,j={configurable:!0,enumerable:!1,writable:!0};l=function(e,t){var n,l;return h(t),l=this,i.call(this,e,n=function(){r.call(l,e,n),f.call(t,this,arguments)}),n.__eeOnceListener__=t,this},_={on:i=function(e,t){var n;return h(t),O.call(this,"__ee__")?n=this.__ee__:(n=j.value=p(null),b(this,"__ee__",j),j.value=null),n[e]?"object"==typeof n[e]?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},once:l,off:r=function(e,t){var n,i,l,r;if(h(t),!O.call(this,"__ee__"))return this;if(!(n=this.__ee__)[e])return this;if("object"==typeof(i=n[e]))for(r=0;l=i[r];++r)l!==t&&l.__eeOnceListener__!==t||(2===i.length?n[e]=i[r?0:1]:i.splice(r,1));else i!==t&&i.__eeOnceListener__!==t||delete n[e];return this},emit:c=function(e){var t,n,i,l,r;if(O.call(this,"__ee__")&&(l=this.__ee__[e]))if("object"==typeof l){for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];for(l=l.slice(),t=0;i=l[t];++t)f.call(i,this,r)}else switch(arguments.length){case 1:u.call(l,this);break;case 2:u.call(l,this,arguments[1]);break;case 3:u.call(l,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];f.call(l,this,r)}}},o={on:a(i),once:a(l),off:a(r),emit:a(c)},s=y({},o),t.exports=n=function(e){return null==e?p(s):y(Object(e),o)},n.methods=_},
function _(r,n,t){var e=r(74);n.exports=function(r){if(!e(r))throw new TypeError(r+" is not iterable");return r}},
function _(r,t,n){var o=r(47),i=r(9),a=r(51),e=r(25).iterator,f=Array.isArray;t.exports=function(r){return!!i(r)&&(!!f(r)||(!!a(r)||(!!o(r)||"function"==typeof r[e])))}},
function _(r,n,t){var a=r(47),e=r(50),o=r(51),l=r(76),c=Array.isArray,i=Function.prototype.call,f=Array.prototype.some;n.exports=function(r,n){var t,u,s,y,p,A,g,v,x=arguments[2];if(c(r)||a(r)?t="array":o(r)?t="string":r=l(r),e(n),s=function(){y=!0},"array"!==t)if("string"!==t)for(u=r.next();!u.done;){if(i.call(n,x,u.value,s),y)return;u=r.next()}else for(A=r.length,p=0;p<A&&(g=r[p],p+1<A&&(v=g.charCodeAt(0))>=55296&&v<=56319&&(g+=r[++p]),i.call(n,x,g,s),!y);++p);else f.call(r,(function(r){return i.call(n,x,r,s),y}))}},
function _(n,t,e){var o=n(47),r=n(51),f=n(77),i=n(91),u=n(73),c=n(25).iterator;t.exports=function(n){return"function"==typeof u(n)[c]?n[c]():o(n)?new f(n):r(n)?new i(n):new f(n)}},
function _(t,e,r){var o,_=t(67),i=t(39),n=t(31),l=t(25),a=t(78),s=Object.defineProperty;o=e.exports=function(t,e){if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");a.call(this,t),e=e?i.call(e,"key+value")?"key+value":i.call(e,"key")?"key":"value":"value",s(this,"__kind__",n("",e))},_&&_(o,a),delete o.prototype.constructor,o.prototype=Object.create(a.prototype,{_resolve:n((function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t}))}),s(o.prototype,l.toStringTag,n("c","Array Iterator"))},
function _(_,t,e){var n,i=_(62),o=_(37),s=_(50),r=_(11),h=_(31),d=_(79),c=_(25),u=Object.defineProperty,l=Object.defineProperties;t.exports=n=function(_,t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");l(this,{__list__:h("w",r(_)),__context__:h("w",t),__nextIndex__:h("w",0)}),t&&(s(t.on),t.on("_add",this._onAdd),t.on("_delete",this._onDelete),t.on("_clear",this._onClear))},delete n.prototype.constructor,l(n.prototype,o({_next:h((function(){var _;if(this.__list__)return this.__redo__&&void 0!==(_=this.__redo__.shift())?_:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()})),next:h((function(){return this._createResult(this._next())})),_createResult:h((function(_){return void 0===_?{done:!0,value:void 0}:{done:!1,value:this._resolve(_)}})),_resolve:h((function(_){return this.__list__[_]})),_unBind:h((function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)})),toString:h((function(){return"[object "+(this[c.toStringTag]||"Object")+"]"}))},d({_onAdd:h((function(_){_>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach((function(t,e){t>=_&&(this.__redo__[e]=++t)}),this),this.__redo__.push(_)):u(this,"__redo__",h("c",[_])))})),_onDelete:h((function(_){var t;_>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(_))&&this.__redo__.splice(t,1),this.__redo__.forEach((function(t,e){t>_&&(this.__redo__[e]=--t)}),this)))})),_onClear:h((function(){this.__redo__&&i.call(this.__redo__),this.__nextIndex__=0}))}))),u(n.prototype,c.iterator,h((function(){return this})))},
function _(e,t,n){var r,o=e(32),i=e(80),l=e(85),u=e(86),s=e(38),v=e(88),a=Function.prototype.bind,c=Object.defineProperty,f=Object.prototype.hasOwnProperty;r=function(e,t,n){var r,o=i(t)&&l(t.value);return delete(r=u(t)).writable,delete r.value,r.get=function(){return!n.overwriteDefinition&&f.call(this,e)?o:(t.value=a.call(o,n.resolveContext?n.resolveContext(this):this),c(this,e,t),this[e])},r},t.exports=function(e){var t=s(arguments[1]);return o(t.resolveContext)&&l(t.resolveContext),v(e,(function(e,n){return r(n,e,t)}))}},
function _(n,t,o){var r=n(81),u=n(32);t.exports=function(n){return u(n)?n:r(n,"Cannot use %v",arguments[1])}},
function _(r,e,n){var t=r(32),i=r(36),o=r(82),f=r(83),u=function(r,e){return r.replace("%v",f(e))};e.exports=function(r,e,n){if(!i(n))throw new TypeError(u(e,r));if(!t(r)){if("default"in n)return n.default;if(n.isOptional)return null}var f=o(n.errorMessage);throw t(f)||(f=e),new TypeError(u(f,r))}},
function _(t,n,r){var u=t(32),e=t(36),i=Object.prototype.toString;n.exports=function(t){if(!u(t))return null;if(e(t)){var n=t.toString;if("function"!=typeof n)return null;if(n===i)return null}try{return""+t}catch(t){return null}}},
function _(r,e,n){var t=r(84),u=/[\n\r\u2028\u2029]/g;e.exports=function(r){var e=t(r);return null===e?"<Non-coercible to string value>":(e.length>100&&(e=e.slice(0,99)+"…"),e=e.replace(u,(function(r){switch(r){case"\n":return"\\n";case"\r":return"\\r";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";default:throw new Error("Unexpected character")}})))}},
function _(t,r,n){r.exports=function(t){try{return t.toString()}catch(r){try{return String(t)}catch(t){return null}}}},
function _(n,t,i){var o=n(81),r=n(33);t.exports=function(n){return r(n)?n:o(n,"%v is not a plain function",arguments[1])}},
function _(n,r,t){var e=n(87),u=n(37),c=n(11);r.exports=function(n){var r=Object(c(n)),t=arguments[1],i=Object(arguments[2]);if(r!==n&&!t)return r;var f={};return t?e(t,(function(r){(i.ensure||r in n)&&(f[r]=n[r])})):u(f,n),f}},
function _(r,o,f){o.exports=r(23)()?Array.from:r(24)},
function _(n,t,o){var c=n(50),r=n(89),u=Function.prototype.call;t.exports=function(n,t){var o={},a=arguments[2];return c(t),r(n,(function(n,c,r,i){o[c]=u.call(t,a,n,c,r,i)})),o}},
function _(o,c,f){c.exports=o(90)("forEach")},
function _(t,n,o){var c=t(50),e=t(11),r=Function.prototype.bind,u=Function.prototype.call,l=Object.keys,p=Object.prototype.propertyIsEnumerable;n.exports=function(t,n){return function(o,i){var a,f=arguments[2],y=arguments[3];return o=Object(e(o)),c(i),a=l(o),y&&a.sort("function"==typeof y?r.call(y,o):void 0),"function"!=typeof t&&(t=a[t]),u.call(t,a,(function(t,c){return p.call(o,t)?u.call(i,f,o[t],t,o,c):n}))}}},
function _(t,_,e){var n,r=t(67),i=t(31),o=t(25),s=t(78),h=Object.defineProperty;n=_.exports=function(t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");t=String(t),s.call(this,t),h(this,"__length__",i("",t.length))},r&&r(n,s),delete n.prototype.constructor,n.prototype=Object.create(s.prototype,{_next:i((function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()})),_resolve:i((function(t){var _,e=this.__list__[t];return this.__nextIndex__===this.__length__?e:(_=e.charCodeAt(0))>=55296&&_<=56319?e+this.__list__[this.__nextIndex__++]:e}))}),h(n.prototype,o.toStringTag,i("c","String Iterator"))},
function _(t,e,_){var r,i=t(67),o=t(39),n=t(31),s=t(78),a=t(25).toStringTag,c=Object.defineProperty;r=e.exports=function(t,e){if(!(this instanceof r))return new r(t,e);s.call(this,t.__setData__,t),e=e&&o.call(e,"key+value")?"key+value":"value",c(this,"__kind__",n("",e))},i&&i(r,s),r.prototype=Object.create(s.prototype,{constructor:n(r),_resolve:n((function(t){return"value"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__list__[t]]})),toString:n((function(){return"[object Set Iterator]"}))}),c(r.prototype,a,n("c","Set Iterator"))},
function _(t,e,o){e.exports="undefined"!=typeof Set&&"[object Set]"===Object.prototype.toString.call(Set.prototype)},
function _(e,a,n){e(95)()||Object.defineProperty(e(60),"Map",{value:e(96),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&(3===t.size&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.get&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.set&&("function"==typeof t.values&&(!1===(e=t.entries().next()).done&&(!!e.value&&("raz"===e.value[0]&&"one"===e.value[1])))))))))))))}},
function _(t,e,a){var _,n=t(62),i=t(63),r=t(67),s=t(50),o=t(11),p=t(31),c=t(72),u=t(25),l=t(73),h=t(75),f=t(97),y=t(100),m=Function.prototype.call,D=Object.defineProperties,v=Object.getPrototypeOf;e.exports=_=function(){var t,e,a,n=arguments[0];if(!(this instanceof _))throw new TypeError("Constructor requires 'new'");return a=y&&r&&Map!==_?r(new Map,v(this)):this,null!=n&&l(n),D(a,{__mapKeysData__:p("c",t=[]),__mapValuesData__:p("c",e=[])}),n?(h(n,(function(a){var _=o(a)[0];a=a[1],-1===i.call(t,_)&&(t.push(_),e.push(a))}),a),a):a},y&&(r&&r(_,Map),_.prototype=Object.create(Map.prototype,{constructor:p(_)})),c(D(_.prototype,{clear:p((function(){this.__mapKeysData__.length&&(n.call(this.__mapKeysData__),n.call(this.__mapValuesData__),this.emit("_clear"))})),delete:p((function(t){var e=i.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:p((function(){return new f(this,"key+value")})),forEach:p((function(t){var e,a,_=arguments[1];for(s(t),a=(e=this.entries())._next();void 0!==a;)m.call(t,_,this.__mapValuesData__[a],this.__mapKeysData__[a],this),a=e._next()})),get:p((function(t){var e=i.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]})),has:p((function(t){return-1!==i.call(this.__mapKeysData__,t)})),keys:p((function(){return new f(this,"key")})),set:p((function(t,e){var a,_=i.call(this.__mapKeysData__,t);return-1===_&&(_=this.__mapKeysData__.push(t)-1,a=!0),this.__mapValuesData__[_]=e,a&&this.emit("_add",_,t),this})),size:p.gs((function(){return this.__mapKeysData__.length})),values:p((function(){return new f(this,"value")})),toString:p((function(){return"[object Map]"}))})),Object.defineProperty(_.prototype,u.iterator,p((function(){return this.entries()}))),Object.defineProperty(_.prototype,u.toStringTag,p("c","Map"))},
function _(t,_,e){var i,n=t(67),r=t(31),o=t(78),s=t(25).toStringTag,a=t(98),u=Object.defineProperties,c=o.prototype._unBind;i=_.exports=function(t,_){if(!(this instanceof i))return new i(t,_);o.call(this,t.__mapKeysData__,t),_&&a[_]||(_="key+value"),u(this,{__kind__:r("",_),__values__:r("w",t.__mapValuesData__)})},n&&n(i,o),i.prototype=Object.create(o.prototype,{constructor:r(i),_resolve:r((function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]})),_unBind:r((function(){this.__values__=null,c.call(this)})),toString:r((function(){return"[object Map Iterator]"}))}),Object.defineProperty(i.prototype,s,r("c","Map Iterator"))},
function _(e,u,a){u.exports=e(99)("key","value","key+value")},
function _(r,t,n){var c=Array.prototype.forEach,o=Object.create;t.exports=function(r){var t=o(null);return c.call(arguments,(function(r){t[r]=!0})),t}},
function _(t,e,o){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},
function _(e,a,n){e(102)()||Object.defineProperty(e(60),"WeakMap",{value:e(103),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&("function"==typeof t.set&&(t.set({},1)===t&&("function"==typeof t.delete&&("function"==typeof t.has&&"one"===t.get(e)))))}},
function _(t,e,a){var r,n=t(9),o=t(67),p=t(104),_=t(11),i=t(105),c=t(31),s=t(76),u=t(75),f=t(25).toStringTag,k=t(106),M=Array.isArray,h=Object.defineProperty,w=Object.prototype.hasOwnProperty,y=Object.getPrototypeOf;e.exports=r=function(){var t,e=arguments[0];if(!(this instanceof r))throw new TypeError("Constructor requires 'new'");return t=k&&o&&WeakMap!==r?o(new WeakMap,y(this)):this,n(e)&&(M(e)||(e=s(e))),h(t,"__weakMapData__",c("c","$weakMap$"+i())),e?(u(e,(function(e){_(e),t.set(e[0],e[1])})),t):t},k&&(o&&o(r,WeakMap),r.prototype=Object.create(WeakMap.prototype,{constructor:c(r)})),Object.defineProperties(r.prototype,{delete:c((function(t){return!!w.call(p(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)})),get:c((function(t){if(w.call(p(t),this.__weakMapData__))return t[this.__weakMapData__]})),has:c((function(t){return w.call(p(t),this.__weakMapData__)})),set:c((function(t,e){return h(p(t),this.__weakMapData__,c("c",e)),this})),toString:c((function(){return"[object WeakMap]"}))}),h(r.prototype,f,c("c","WeakMap"))},
function _(n,r,t){var o=n(70);r.exports=function(n){if(!o(n))throw new TypeError(n+" is not an Object");return n}},
function _(t,n,r){var e=Object.create(null),o=Math.random;n.exports=function(){var t;do{t=o().toString(36).slice(2)}while(e[t]);return t}},
function _(t,e,o){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},
function _(l,o,f){o.exports=l(108).polyfill()},
function _(t,e,n){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
!function(t,r){"object"==typeof n&&void 0!==e?e.exports=r():"function"==typeof define&&define.amd?define(r):t.ES6Promise=r()}(this,(function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},r=0,o=void 0,i=void 0,s=function(t,e){v[r]=t,v[r+1]=e,2===(r+=2)&&(i?i(p):b())};var u="undefined"!=typeof window?window:void 0,c=u||{},a=c.MutationObserver||c.WebKitMutationObserver,f="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),l="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function h(){var t=setTimeout;return function(){return t(p,1)}}var v=new Array(1e3);function p(){for(var t=0;t<r;t+=2){(0,v[t])(v[t+1]),v[t]=void 0,v[t+1]=void 0}r=0}var d,_,y,m,b=void 0;function w(t,e){var n=this,r=new this.constructor(j);void 0===r[A]&&Y(r);var o=n._state;if(o){var i=arguments[o-1];s((function(){return x(o,r,i,n._result)}))}else C(n,r,t,e);return r}function g(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(j);return E(e,t),e}f?b=function(){return process.nextTick(p)}:a?(_=0,y=new a(p),m=document.createTextNode(""),y.observe(m,{characterData:!0}),b=function(){m.data=_=++_%2}):l?((d=new MessageChannel).port1.onmessage=p,b=function(){return d.port2.postMessage(0)}):b=void 0===u&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(o=t.runOnLoop||t.runOnContext)?function(){o(p)}:h()}catch(t){return h()}}():h();var A=Math.random().toString(36).substring(2);function j(){}function S(t,n,r){n.constructor===t.constructor&&r===w&&n.constructor.resolve===g?function(t,e){1===e._state?M(t,e._result):2===e._state?P(t,e._result):C(e,void 0,(function(e){return E(t,e)}),(function(e){return P(t,e)}))}(t,n):void 0===r?M(t,n):e(r)?function(t,e,n){s((function(t){var r=!1,o=function(t,e,n,r){try{t.call(e,n,r)}catch(t){return t}}(n,e,(function(n){r||(r=!0,e!==n?E(t,n):M(t,n))}),(function(e){r||(r=!0,P(t,e))}),t._label);!r&&o&&(r=!0,P(t,o))}),t)}(t,n,r):M(t,n)}function E(t,e){if(t===e)P(t,new TypeError("You cannot resolve a promise with itself"));else if(o=typeof(r=e),null===r||"object"!==o&&"function"!==o)M(t,e);else{var n=void 0;try{n=e.then}catch(e){return void P(t,e)}S(t,e,n)}var r,o}function T(t){t._onerror&&t._onerror(t._result),O(t)}function M(t,e){void 0===t._state&&(t._result=e,t._state=1,0!==t._subscribers.length&&s(O,t))}function P(t,e){void 0===t._state&&(t._state=2,t._result=e,s(T,t))}function C(t,e,n,r){var o=t._subscribers,i=o.length;t._onerror=null,o[i]=e,o[i+1]=n,o[i+2]=r,0===i&&t._state&&s(O,t)}function O(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var r=void 0,o=void 0,i=t._result,s=0;s<e.length;s+=3)r=e[s],o=e[s+n],r?x(n,r,o,i):o(i);t._subscribers.length=0}}function x(t,n,r,o){var i=e(r),s=void 0,u=void 0,c=!0;if(i){try{s=r(o)}catch(t){c=!1,u=t}if(n===s)return void P(n,new TypeError("A promises callback cannot return that same promise."))}else s=o;void 0!==n._state||(i&&c?E(n,s):!1===c?P(n,u):1===t?M(n,s):2===t&&P(n,s))}var F=0;function Y(t){t[A]=F++,t._state=void 0,t._result=void 0,t._subscribers=[]}var k=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(j),this.promise[A]||Y(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?M(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&M(this.promise,this._result))):P(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;void 0===this._state&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,r=n.resolve;if(r===g){var o=void 0,i=void 0,s=!1;try{o=t.then}catch(t){s=!0,i=t}if(o===w&&void 0!==t._state)this._settledAt(t._state,e,t._result);else if("function"!=typeof o)this._remaining--,this._result[e]=t;else if(n===q){var u=new n(j);s?P(u,i):S(u,t,o),this._willSettleAt(u,e)}else this._willSettleAt(new n((function(e){return e(t)})),e)}else this._willSettleAt(r(t),e)},t.prototype._settledAt=function(t,e,n){var r=this.promise;void 0===r._state&&(this._remaining--,2===t?P(r,n):this._result[e]=n),0===this._remaining&&M(r,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;C(t,void 0,(function(t){return n._settledAt(1,e,t)}),(function(t){return n._settledAt(2,e,t)}))},t}();var q=function(){function t(e){this[A]=F++,this._result=this._state=void 0,this._subscribers=[],j!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e((function(e){E(t,e)}),(function(e){P(t,e)}))}catch(e){P(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)},t}();return q.prototype.then=w,q.all=function(t){return new k(this,t).promise},q.race=function(t){var e=this;return n(t)?new e((function(n,r){for(var o=t.length,i=0;i<o;i++)e.resolve(t[i]).then(n,r)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},q.resolve=g,q.reject=function(t){var e=new this(j);return P(e,t),e},q._setScheduler=function(t){i=t},q._setAsap=function(t){s=t},q._asap=s,q.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=q},q.Promise=q,q}))},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0}),e(1).__exportStar(e(110),_)},
function _(e,r,t){var l=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var r={};if(null!=e)for(var t in e)Object.hasOwnProperty.call(e,t)&&(r[t]=e[t]);return r.default=e,r};Object.defineProperty(t,"__esModule",{value:!0});var o=e(111);t.version=o.version;var s=e(112);t.index=s.index,t.embed=l(e(112)),t.protocol=l(e(462)),t._testing=l(e(463));var n=e(178);t.logger=n.logger,t.set_log_level=n.set_log_level;var a=e(134);t.settings=a.settings;var i=e(115);t.Models=i.Models;var v=e(113);t.documents=v.documents;var _=e(464);t.safely=_.safely},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0}),o.version="2.0.1"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(1),o=e(113),s=e(178),d=e(133),i=e(116),u=e(125),a=e(453),_=e(455),c=e(454),l=e(453);t.add_document_standalone=l.add_document_standalone,t.index=l.index;var m=e(455);t.add_document_from_session=m.add_document_from_session;var f=e(460);t.embed_items_notebook=f.embed_items_notebook,t.kernels=f.kernels;var h=e(454);function g(e,r,t,u){return n.__awaiter(this,void 0,void 0,(function(){var l,m,f,h,g,v,b,p,w,O,k,B,E,y,x;return n.__generator(this,(function(n){switch(n.label){case 0:for(m in i.isString(e)&&(e=JSON.parse(d.unescape(e))),l={},e)f=e[m],l[m]=o.Document.from_json(f);h=[],g=0,v=r,n.label=1;case 1:return g<v.length?(b=v[g],p=c._resolve_element(b),w=c._resolve_root_elements(b),null==b.docid?[3,3]:(k=(O=h).push,[4,a.add_document_standalone(l[b.docid],p,w,b.use_for_title)])):[3,10];case 2:return k.apply(O,[n.sent()]),[3,9];case 3:if(null==b.token)return[3,8];B=_._get_ws_url(t,u),s.logger.debug("embed: computed ws url: "+B),n.label=4;case 4:return n.trys.push([4,6,,7]),y=(E=h).push,[4,_.add_document_from_session(B,b.token,p,w,b.use_for_title)];case 5:return y.apply(E,[n.sent()]),console.log("Bokeh items were rendered successfully"),[3,7];case 6:return x=n.sent(),console.log("Error rendering Bokeh items:",x),[3,7];case 7:return[3,9];case 8:throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");case 9:return g++,[3,1];case 10:return[2,h]}}))}))}t.BOKEH_ROOT=h.BOKEH_ROOT,t.embed_item=function(e,r){return n.__awaiter(this,void 0,void 0,(function(){var t,o,s,i,a;return n.__generator(this,(function(n){switch(n.label){case 0:return t={},o=d.uuid4(),t[o]=e.doc,null==r&&(r=e.target_id),null!=(s=document.getElementById(r))&&s.classList.add(c.BOKEH_ROOT),(a={})[e.root_id]=r,i={roots:a,root_ids:[e.root_id],docid:o},[4,u.defer((function(){return g(t,[i])}))];case 1:return[2,n.sent()[0]]}}))}))},t.embed_items=function(e,r,t,o){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(n){switch(n.label){case 0:return[4,u.defer((function(){return g(e,r,t,o)}))];case 1:return[2,n.sent()]}}))}))}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(114),t),_.__exportStar(e(211),t)},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(115),r=e(111),i=e(178),s=e(389),a=e(121),_=e(122),l=e(132),c=e(208),d=e(123),u=e(117),h=e(131),f=e(124),v=e(116),m=e(352),p=e(181),g=e(177),y=e(211),b=function(){function e(e){this.document=e,this.session=null,this.subscribed_models=new Set}return e.prototype.send_event=function(e){var t=new y.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)},e.prototype.trigger=function(e){for(var t=0,n=this.subscribed_models;t<n.length;t++){var o=n[t];if(null==e.origin||e.origin.id===o){var r=this.document._all_models[o];null!=r&&r instanceof g.Model&&r._process_event(e)}}},e}();n.EventManager=b,b.__name__="EventManager",n.documents=[],n.DEFAULT_TITLE="Bokeh Application";var w=function(){function e(){n.documents.push(this),this._init_timestamp=Date.now(),this._title=n.DEFAULT_TITLE,this._roots=[],this._all_models={},this._all_models_by_name=new d.MultiDict,this._all_models_freeze_count=0,this._callbacks=[],this._message_callbacks=new Map,this.event_manager=new b(this),this.idle=new _.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(e.prototype,"layoutables",{get:function(){return this._roots.filter((function(e){return e instanceof m.LayoutDOM}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){for(var e=0,t=this.layoutables;e<t.length;e++){var n=t[e];if(!this._idle_roots.has(n))return!1}return!0},enumerable:!0,configurable:!0}),e.prototype.notify_idle=function(e){this._idle_roots.set(e,!0),this.is_idle&&(i.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.idle.emit())},e.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},e.prototype.interactive_start=function(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new s.LODStart)),this._interactive_timestamp=Date.now()},e.prototype.interactive_stop=function(e){null!=this._interactive_plot&&this._interactive_plot.id===e.id&&this._interactive_plot.trigger_event(new s.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null},e.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},e.prototype.destructively_move=function(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();var t=u.copy(this._roots);this.clear();for(var n=0,o=t;n<o.length;n++){if(null!=(s=o[n]).document)throw new Error("Somehow we didn't detach "+s)}if(0!==Object.keys(this._all_models).length)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(var r=0,i=t;r<i.length;r++){var s=i[r];e.add_root(s)}e.set_title(this._title)},e.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},e.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._invalidate_all_models=function(){i.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._recompute_all_models=function(){for(var e=new d.Set,t=0,n=this._roots;t<n.length;t++){var o=n[t];e=e.union(o.references())}for(var r=new d.Set(h.values(this._all_models)),i=r.diff(e),s=e.diff(r),a={},_=0,l=e.values;_<l.length;_++){var c=l[_];a[c.id]=c}for(var u=0,f=i.values;u<f.length;u++){var v=f[u];v.detach_document(),v instanceof g.Model&&null!=v.name&&this._all_models_by_name.remove_value(v.name,v)}for(var m=0,p=s.values;m<p.length;m++){var y=p[m];y.attach_document(this),y instanceof g.Model&&null!=y.name&&this._all_models_by_name.add_value(y.name,y)}this._all_models=a},e.prototype.roots=function(){return this._roots},e.prototype.add_root=function(e,t){if(i.logger.debug("Adding root: "+e),!u.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new y.RootAddedEvent(this,e,t))}},e.prototype.remove_root=function(e,t){var n=this._roots.indexOf(e);if(!(n<0)){this._push_all_models_freeze();try{this._roots.splice(n,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new y.RootRemovedEvent(this,e,t))}},e.prototype.title=function(){return this._title},e.prototype.set_title=function(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new y.TitleChangedEvent(this,e,t)))},e.prototype.get_model_by_id=function(e){return e in this._all_models?this._all_models[e]:null},e.prototype.get_model_by_name=function(e){return this._all_models_by_name.get_one(e,"Multiple models are named '"+e+"'")},e.prototype.on_message=function(e,t){var n=this._message_callbacks.get(e);null==n?this._message_callbacks.set(e,new Set([t])):n.add(t)},e.prototype.remove_on_message=function(e,t){var n;null===(n=this._message_callbacks.get(e))||void 0===n||n.delete(t)},e.prototype._trigger_on_message=function(e,t){var n=this._message_callbacks.get(e);if(null!=n)for(var o=0,r=n;o<r.length;o++){(0,r[o])(t)}},e.prototype.on_change=function(e){u.includes(this._callbacks,e)||this._callbacks.push(e)},e.prototype.remove_on_change=function(e){var t=this._callbacks.indexOf(e);t>=0&&this._callbacks.splice(t,1)},e.prototype._trigger_on_change=function(e){for(var t=0,n=this._callbacks;t<n.length;t++){(0,n[t])(e)}},e.prototype._notify_change=function(e,t,n,o,r){"name"===t&&(this._all_models_by_name.remove_value(n,e),null!=o&&this._all_models_by_name.add_value(o,e));var i=null!=r?r.setter_id:void 0,s=null!=r?r.hint:void 0;this._trigger_on_change(new y.ModelChangedEvent(this,e,t,n,o,i,s))},e._references_json=function(e,t){void 0===t&&(t=!0);for(var n=[],o=0,r=e;o<r.length;o++){var i=r[o],s=i.struct();s.attributes=i.attributes_as_json(t),delete s.attributes.id,n.push(s)}return n},e._instantiate_object=function(e,t,n){var r=Object.assign(Object.assign({},n),{id:e,__deferred__:!0});return new(o.Models(t))(r)},e._instantiate_references_json=function(t,n){for(var o={},r=0,i=t;r<i.length;r++){var s=i[r],a=s.id,_=s.type,l=s.attributes||{},c=void 0;a in n?c=n[a]:(c=e._instantiate_object(a,_,l),null!=s.subtype&&c.set_subtype(s.subtype)),o[c.id]=c}return o},e._resolve_refs=function(e,t,n){function o(e){if(l.is_ref(e)){if(e.id in t)return t[e.id];if(e.id in n)return n[e.id];throw new Error("reference "+JSON.stringify(e)+" isn't known (not in Document?)")}return v.isArray(e)?function(e){for(var t=[],n=0,r=e;n<r.length;n++){var i=r[n];t.push(o(i))}return t}(e):v.isPlainObject(e)?function(e){var t={};for(var n in e){var r=e[n];t[n]=o(r)}return t}(e):e}return o(e)},e._initialize_references_json=function(t,n,o){for(var r={},i=0,s=t;i<s.length;i++){var _=s[i],l=_.id,c=_.attributes,d=!(l in n),u=d?o[l]:n[l],h=e._resolve_refs(c,n,o);r[u.id]=[u,h,d]}function f(e,t){var n={};function o(r){if(r instanceof a.HasProps){if(!(r.id in n)&&r.id in e){n[r.id]=!0;var i=e[r.id],s=i[1],_=i[2];for(var l in s){o(s[l])}t(r,s,_)}}else if(v.isArray(r))for(var c=0,d=r;c<d.length;c++){o(d[c])}else if(v.isPlainObject(r))for(var u in r){o(r[u])}}for(var r in e){o(e[r][0])}}f(r,(function(e,t,n){n&&e.setv(t,{silent:!0})})),f(r,(function(e,t,n){n&&e.finalize()}))},e._event_for_attribute_change=function(e,t,n,o,r){if(o.get_model_by_id(e.id).attribute_is_serializable(t)){var i={kind:"ModelChanged",model:{id:e.id},attr:t,new:n};return a.HasProps._json_record_references(o,n,r,!0),i}return null},e._events_to_sync_objects=function(t,n,o,r){for(var s=Object.keys(t.attributes),a=Object.keys(n.attributes),_=u.difference(s,a),l=u.difference(a,s),c=u.intersection(s,a),d=[],h=0,v=_;h<v.length;h++){var m=v[h];i.logger.warn("Server sent key "+m+" but we don't seem to have it in our JSON")}for(var p=0,g=l;p<g.length;p++){m=g[p];var y=n.attributes[m];d.push(e._event_for_attribute_change(t,m,y,o,r))}for(var b=0,w=c;b<w.length;b++){m=w[b];var j=t.attributes[m];y=n.attributes[m];null==j&&null==y||(null==j||null==y?d.push(e._event_for_attribute_change(t,m,y,o,r)):f.isEqual(j,y)||d.push(e._event_for_attribute_change(t,m,y,o,r)))}return d.filter((function(e){return null!=e}))},e._compute_patch_since_json=function(t,n){var o=n.to_json(!1);function r(e){for(var t={},n=0,o=e.roots.references;n<o.length;n++){var r=o[n];t[r.id]=r}return t}for(var i=r(t),s={},a=[],_=0,l=t.roots.root_ids;_<l.length;_++){s[p=l[_]]=i[p],a.push(p)}for(var c=r(o),d={},f=[],v=0,m=o.roots.root_ids;v<m.length;v++){var p;d[p=m[v]]=c[p],f.push(p)}if(a.sort(),f.sort(),u.difference(a,f).length>0||u.difference(f,a).length>0)throw new Error("Not implemented: computing add/remove of document roots");var g={},y=[];for(var b in n._all_models)if(b in i){var w=e._events_to_sync_objects(i[b],c[b],n,g);y=y.concat(w)}return{references:e._references_json(h.values(g),!1),events:y}},e.prototype.to_json_string=function(e){return void 0===e&&(e=!0),JSON.stringify(this.to_json(e))},e.prototype.to_json=function(t){void 0===t&&(t=!0);var n=this._roots.map((function(e){return e.id})),o=h.values(this._all_models);return{version:r.version,title:this._title,roots:{root_ids:n,references:e._references_json(o,t)}}},e.from_json_string=function(t){var n=JSON.parse(t);return e.from_json(n)},e.from_json=function(t){i.logger.debug("Creating Document from JSON");var n=t.version,o=-1!==n.indexOf("+")||-1!==n.indexOf("-"),s="Library versions: JS ("+r.version+") / Python ("+n+")";o||r.version.replace(/-(dev|rc)\./,"$1")==n?i.logger.debug(s):(i.logger.warn("JS/Python version mismatch"),i.logger.warn(s));var a=t.roots,_=a.root_ids,l=a.references,c=e._instantiate_references_json(l,{});e._initialize_references_json(l,{},c);for(var d=new e,u=0,h=_;u<h.length;u++){var f=h[u];d.add_root(c[f])}return d.set_title(t.title),d},e.prototype.replace_with_json=function(t){e.from_json(t).destructively_move(this)},e.prototype.create_json_patch_string=function(e){return JSON.stringify(this.create_json_patch(e))},e.prototype.create_json_patch=function(t){for(var n={},o=[],r=0,s=t;r<s.length;r++){var a=s[r];if(a.document!==this)throw i.logger.warn("Cannot create a patch using events from a different document, event had ",a.document," we are ",this),new Error("Cannot create a patch using events from a different document");o.push(a.json(n))}return{events:o,references:e._references_json(h.values(n))}},e.prototype.apply_json_patch=function(t,n,o){var r;void 0===n&&(n=[]);for(var s=t.references,a=t.events,_=e._instantiate_references_json(s,this._all_models),l=0,d=a;l<d.length;l++){switch((b=d[l]).kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var u=b.model.id;if(u in this._all_models)_[u]=this._all_models[u];else if(!(u in _))throw i.logger.warn("Got an event for unknown model ",b.model),new Error("event model wasn't known")}}var h={},f={};for(var v in _){var m=_[v];v in this._all_models?h[v]=m:f[v]=m}e._initialize_references_json(s,h,f);for(var g=0,y=a;g<y.length;g++){var b;switch((b=y[g]).kind){case"MessageSent":var w=b.msg_type,j=b.msg_data,k=void 0;if(void 0===j){if(1!=n.length)throw new Error("expected exactly one buffer");k=n[0][1]}else k=e._resolve_refs(j,h,f);this._trigger_on_message(w,k);break;case"ModelChanged":var E=b.model.id;if(!(E in this._all_models))throw new Error("Cannot apply patch to "+E+" which is not in the document");var S=this._all_models[E],C=b.attr;if("data"===C&&"ColumnDataSource"===S.type){var O=c.decode_column_data(b.new,n),D=(k=O[0],O[1]);S.setv({_shapes:D,data:k},{setter_id:o})}else{m=e._resolve_refs(b.new,h,f);S.setv(((r={})[C]=m,r),{setter_id:o})}break;case"ColumnDataChanged":if(!((J=b.column_source.id)in this._all_models))throw new Error("Cannot stream to "+J+" which is not in the document");var z=this._all_models[J],M=c.decode_column_data(b.new,n);k=M[0],D=M[1];if(null!=b.cols){for(var A in z.data)A in k||(k[A]=z.data[A]);for(var A in z._shapes)A in D||(D[A]=z._shapes[A])}z.setv({_shapes:D,data:k},{setter_id:o,check_eq:!1});break;case"ColumnsStreamed":if(!((J=b.column_source.id)in this._all_models))throw new Error("Cannot stream to "+J+" which is not in the document");if(!((z=this._all_models[J])instanceof p.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");k=b.data;var P=b.rollover;z.stream(k,P,o);break;case"ColumnsPatched":var J;if(!((J=b.column_source.id)in this._all_models))throw new Error("Cannot patch "+J+" which is not in the document");if(!((z=this._all_models[J])instanceof p.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var R=b.patches;z.patch(R,o);break;case"RootAdded":var L=_[b.model.id];this.add_root(L,o);break;case"RootRemoved":L=_[b.model.id];this.remove_root(L,o);break;case"TitleChanged":this.set_title(b.title,o);break;default:throw new Error("Unknown patch event "+JSON.stringify(b))}}},e}();n.Document=w,w.__name__="Document"},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var s=e(1),t=e(116),i=e(121);o.overrides={};var d=new Map;o.Models=function(e){var r=o.overrides[e]||d.get(e);if(null==r)throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.");return r},o.Models.register=function(e,r){o.overrides[e]=r},o.Models.unregister=function(e){delete o.overrides[e]},o.Models.register_models=function(e,r,o){var s;if(void 0===r&&(r=!1),null!=e)for(var n in e){var l=e[n];if(s=l,t.isObject(s)&&s.prototype instanceof i.HasProps){var a=l.__qualified__;r||!d.has(a)?d.set(a,l):null!=o?o(a):console.warn("Model '"+a+"' was already registered")}}},o.register_models=o.Models.register_models,o.Models.registered_names=function(){return Array.from(d.keys())};var n=s.__importStar(e(135));o.register_models(n)},
function _(r,n,t){Object.defineProperty(t,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var e=r(117),i=Object.prototype.toString;function o(r){return"[object Number]"===i.call(r)}function u(r){var n=typeof r;return"function"===n||"object"===n&&!!r}t.isBoolean=function(r){return!0===r||!1===r||"[object Boolean]"===i.call(r)},t.isNumber=o,t.isInteger=function(r){return o(r)&&isFinite(r)&&Math.floor(r)===r},t.isString=function(r){return"[object String]"===i.call(r)},t.isStrictNaN=function(r){return o(r)&&r!==+r},t.isFunction=function(r){return"[object Function]"===i.call(r)},t.isArray=function(r){return Array.isArray(r)},t.isArrayOf=function(r,n){return e.every(r,n)},t.isArrayableOf=function(r,n){for(var t=0,e=r.length;t<e;t++)if(!n(r[t]))return!1;return!0},t.isTypedArray=function(r){return null!=r&&r.buffer instanceof ArrayBuffer},t.isObject=u,t.isPlainObject=function(r){return u(r)&&(null==r.constructor||r.constructor===Object)}},
function _(n,r,e){Object.defineProperty(e,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var t=n(118),u=n(119),i=n(120);e.map=i.map,e.reduce=i.reduce,e.min=i.min,e.min_by=i.min_by,e.max=i.max,e.max_by=i.max_by,e.sum=i.sum,e.cumsum=i.cumsum,e.every=i.every,e.some=i.some,e.find=i.find,e.find_last=i.find_last,e.find_index=i.find_index,e.find_last_index=i.find_last_index,e.sorted_index=i.sorted_index;var a=Array.prototype.slice;function o(n){return a.call(n)}function f(n){return[].concat.apply([],n)}function c(n,r){return-1!==n.indexOf(r)}function l(n,r,e){void 0===e&&(e=1),u.assert(e>0,"'step' must be a positive number"),null==r&&(r=n,n=0);for(var t=n<=r?e:-e,i=(0,Math.max)((0,Math.ceil)((0,Math.abs)(r-n)/e),0),a=Array(i),o=0;o<i;o++,n+=t)a[o]=n;return a}function v(n){for(var r=[],e=0,t=n;e<t.length;e++){var u=t[e];c(r,u)||r.push(u)}return r}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=o,e.concat=f,e.includes=c,e.contains=c,e.nth=function(n,r){return n[r>=0?r:n.length+r]},e.zip=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];if(0==n.length)return[];for(var e=i.min(n.map((function(n){return n.length}))),t=n.length,u=new Array(e),a=0;a<e;a++){u[a]=new Array(t);for(var o=0;o<t;o++)u[a][o]=n[o][a]}return u},e.unzip=function(n){for(var r=n.length,e=i.min(n.map((function(n){return n.length}))),t=Array(e),u=0;u<e;u++)t[u]=new Array(r);for(var a=0;a<r;a++)for(u=0;u<e;u++)t[u][a]=n[a][u];return t},e.range=l,e.linspace=function(n,r,e){void 0===e&&(e=100);for(var t=(r-n)/(e-1),u=new Array(e),i=0;i<e;i++)u[i]=n+t*i;return u},e.transpose=function(n){for(var r=n.length,e=n[0].length,t=[],u=0;u<e;u++){t[u]=[];for(var i=0;i<r;i++)t[u][i]=n[i][u]}return t},e.argmin=function(n){return i.min_by(l(n.length),(function(r){return n[r]}))},e.argmax=function(n){return i.max_by(l(n.length),(function(r){return n[r]}))},e.sort_by=function(n,r){var e=n.map((function(n,e){return{value:n,index:e,key:r(n)}}));return e.sort((function(n,r){var e=n.key,t=r.key;if(e!==t){if(e>t||void 0===e)return 1;if(e<t||void 0===t)return-1}return n.index-r.index})),e.map((function(n){return n.value}))},e.uniq=v,e.uniq_by=function(n,r){for(var e=[],t=[],u=0,i=n;u<i.length;u++){var a=i[u],o=r(a);c(t,o)||(t.push(o),e.push(a))}return e},e.union=function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return v(f(n))},e.intersection=function(n){for(var r=[],e=1;e<arguments.length;e++)r[e-1]=arguments[e];var t=[];n:for(var u=0,i=n;u<i.length;u++){var a=i[u];if(!c(t,a)){for(var o=0,f=r;o<f.length;o++){var l=f[o];if(!c(l,a))continue n}t.push(a)}}return t},e.difference=function(n){for(var r=[],e=1;e<arguments.length;e++)r[e-1]=arguments[e];var t=f(r);return n.filter((function(n){return!c(t,n)}))},e.remove_at=function(n,r){var e=o(n);return e.splice(r,1),e},e.remove_by=function(n,r){for(var e=0;e<n.length;)r(n[e])?n.splice(e,1):e++},e.shuffle=function(n){for(var r=n.length,e=new Array(r),u=0;u<r;u++){var i=t.randomIn(0,u);i!==u&&(e[u]=e[i]),e[i]=n[u]}return e},e.pairwise=function(n,r){for(var e=n.length,t=new Array(e-1),u=0;u<e-1;u++)t[u]=r(n[u],n[u+1]);return t},e.reversed=function(n){for(var r=n.length,e=new Array(r),t=0;t<r;t++)e[r-t-1]=n[t];return e},e.repeat=function(n,r){for(var e=new Array(r),t=0;t<r;t++)e[t]=n;return e}},
function _(n,r,t){function a(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function e(n,r){return a(n-r)}function o(){return Math.random()}Object.defineProperty(t,"__esModule",{value:!0}),t.angle_norm=a,t.angle_dist=e,t.angle_between=function(n,r,t,o){var u=e(r,t);if(0==u)return!1;if(u==2*Math.PI)return!0;var f=a(n),i=e(r,f)<=u&&e(f,t)<=u;return 0==o?i:!i},t.random=o,t.randomIn=function(n,r){return null==r&&(r=n,n=0),n+Math.floor(Math.random()*(r-n+1))},t.atan2=function(n,r){return Math.atan2(r[1]-n[1],r[0]-n[0])},t.rnorm=function(n,r){for(var t,a;t=o(),a=(2*(a=o())-1)*Math.sqrt(1/Math.E*2),!(-4*t*t*Math.log(t)>=a*a););var e=a/t;return e=n+r*e},t.clamp=function(n,r,t){return n>t?t:n<r?r:n}},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=r(1),o=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return t.__extends(e,r),e}(Error);n.AssertionError=o,o.__name__="AssertionError",n.assert=function(r,e){if(!(!0===r||!1!==r&&r()))throw new o(null!=e?e:"Assertion failed")},n.unreachable=function(){throw new Error("unreachable code")}},
function _(n,r,t){function e(n,r,t){for(var e=[],o=3;o<arguments.length;o++)e[o-3]=arguments[o];var u=n.length;r<0&&(r+=u),r<0?r=0:r>u&&(r=u),null==t||t>u-r?t=u-r:t<0&&(t=0);for(var i=u-t+e.length,f=new n.constructor(i),a=0;a<r;a++)f[a]=n[a];for(var c=0,l=e;c<l.length;c++){var v=l[c];f[a++]=v}for(var h=r+t;h<u;h++)f[a++]=n[h];return f}function o(n,r){return e(n,r,n.length-r)}function u(n,r,t){var e,o,u=n.length;if(void 0===t&&0==u)throw new Error("can't reduce an empty array without an initial value");for(void 0===t?(e=n[0],o=1):(e=t,o=0);o<u;o++)e=r(e,n[o],o,n);return e}function i(n){return function(r,t){for(var e=r.length,o=n>0?0:e-1;o>=0&&o<e;o+=n)if(t(r[o]))return o;return-1}}Object.defineProperty(t,"__esModule",{value:!0}),t.splice=e,t.head=o,t.insert=function(n,r,t){return e(n,t,0,r)},t.append=function(n,r){return e(n,n.length,0,r)},t.prepend=function(n,r){return e(n,0,0,r)},t.indexOf=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.map=function(n,r){for(var t=n.length,e=new n.constructor(t),o=0;o<t;o++)e[o]=r(n[o],o,n);return e},t.filter=function(n,r){for(var t=n.length,e=new n.constructor(t),u=0,i=0;i<t;i++){var f=n[i];r(f,i,n)&&(e[u++]=f)}return o(e,u)},t.reduce=u,t.min=function(n){for(var r,t=1/0,e=0,o=n.length;e<o;e++)(r=n[e])<t&&(t=r);return t},t.min_by=function(n,r){if(0==n.length)throw new Error("min_by() called with an empty array");for(var t=n[0],e=r(t),o=1,u=n.length;o<u;o++){var i=n[o],f=r(i);f<e&&(t=i,e=f)}return t},t.max=function(n){for(var r,t=-1/0,e=0,o=n.length;e<o;e++)(r=n[e])>t&&(t=r);return t},t.max_by=function(n,r){if(0==n.length)throw new Error("max_by() called with an empty array");for(var t=n[0],e=r(t),o=1,u=n.length;o<u;o++){var i=n[o],f=r(i);f>e&&(t=i,e=f)}return t},t.sum=function(n){for(var r=0,t=0,e=n.length;t<e;t++)r+=n[t];return r},t.cumsum=function(n){var r=new n.constructor(n.length);return u(n,(function(n,t,e){return r[e]=n+t}),0),r},t.every=function(n,r){for(var t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.some=function(n,r){for(var t=0,e=n.length;t<e;t++)if(r(n[t]))return!0;return!1},t.index_of=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.find_index=i(1),t.find_last_index=i(-1),t.find=function(n,r){var e=t.find_index(n,r);return-1==e?void 0:n[e]},t.find_last=function(n,r){var e=t.find_last_index(n,r);return-1==e?void 0:n[e]},t.sorted_index=function(n,r){for(var t=0,e=n.length;t<e;){var o=Math.floor((t+e)/2);n[o]<r?t=o+1:e=o}return t}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(122),o=i.__importStar(e(126)),s=e(132),a=i.__importStar(e(127)),p=e(133),u=e(117),f=e(131),_=e(116),c=e(124),l=function(e){function t(t){void 0===t&&(t={});var r=e.call(this)||this;for(var i in r._subtype=void 0,r.document=null,r.destroyed=new n.Signal0(r,"destroyed"),r.change=new n.Signal0(r,"change"),r.transformchange=new n.Signal0(r,"transformchange"),r.attributes={},r.properties={},r._set_after_defaults={},r._pending=!1,r._changing=!1,r.props){var o=r.props[i],s=o.type,a=o.default_value;if(null==s)throw new Error("undefined property type for "+r.type+"."+i);r.properties[i]=new s(r,i,a)}null==t.id&&r.setv({id:p.uniqueId()},{silent:!0});var u=t.__deferred__||!1;return u&&delete(t=f.clone(t)).__deferred__,r.setv(t,{silent:!0}),u||r.finalize(),r}return i.__extends(t,e),Object.defineProperty(t.prototype,"type",{get:function(){return this.constructor.__qualified__},set:function(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e},enumerable:!0,configurable:!0}),Object.defineProperty(t,"__qualified__",{get:function(){var e=this.__module__,t=this.__name__;return null!=e?e+"."+t:t},enumerable:!0,configurable:!0}),t.init_HasProps=function(){this.prototype.props={},this.prototype.mixins=[],this.define({id:[a.Any]})},t._fix_default=function(e,t){return void 0===e?void 0:_.isFunction(e)?e:_.isObject(e)?_.isArray(e)?function(){return u.copy(e)}:function(){return f.clone(e)}:function(){return e}},t.define=function(e){var t=function(t){var i=e[t];if(null!=r.prototype.props[t])throw new Error("attempted to redefine property '"+r.prototype.type+"."+t+"'");if(null!=r.prototype[t])throw new Error("attempted to redefine attribute '"+r.prototype.type+"."+t+"'");Object.defineProperty(r.prototype,t,{get:function(){return this.getv(t)},set:function(e){var r;return this.setv(((r={})[t]=e,r)),this},configurable:!1,enumerable:!0});var n=i[0],o=i[1],s=i[2],a={type:n,default_value:r._fix_default(o,t),internal:s||!1},p=f.clone(r.prototype.props);p[t]=a,r.prototype.props=p},r=this;for(var i in e)t(i)},t.internal=function(e){var t={};for(var r in e){var i=e[r],n=i[0],o=i[1];t[r]=[n,o,!0]}this.define(t)},t.mixin=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.define(o.create(e));var r=this.prototype.mixins.concat(e);this.prototype.mixins=r},t.mixins=function(e){this.mixin.apply(this,e)},t.override=function(e){for(var t in e){var r=this._fix_default(e[t],t),i=this.prototype.props[t];if(null==i)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+t+"'");var n=f.clone(this.prototype.props);n[t]=Object.assign(Object.assign({},i),{default_value:r}),this.prototype.props=n}},t.prototype.toString=function(){return this.type+"("+this.id+")"},t.prototype.finalize=function(){var e=this;for(var t in this.properties){var r=this.properties[t];r.update(),null!=r.spec.transform&&this.connect(r.spec.transform.change,(function(){return e.transformchange.emit()}))}this.initialize(),this.connect_signals()},t.prototype.initialize=function(){},t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){n.Signal.disconnectReceiver(this)},t.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},t.prototype.clone=function(){return new this.constructor(this.attributes)},t.prototype._setv=function(e,t){var r=t.check_eq,i=t.silent,n=[],o=this._changing;this._changing=!0;var s=this.attributes;for(var a in e){var p=e[a];!1!==r&&c.isEqual(s[a],p)||n.push(a),s[a]=p}if(!i){n.length>0&&(this._pending=!0);for(var u=0;u<n.length;u++)this.properties[n[u]].change.emit()}if(!o){if(!i&&!t.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},t.prototype.setv=function(e,t){for(var r in void 0===t&&(t={}),e)if(e.hasOwnProperty(r)){var i=r;if(null==this.props[i])throw new Error("property "+this.type+"."+i+" wasn't declared");null!=t&&t.defaults||(this._set_after_defaults[r]=!0)}if(!f.isEmpty(e)){var n={};for(var r in e)n[r]=this.getv(r);this._setv(e,t);var o=t.silent;if(null==o||!o)for(var r in e)this._tell_document_about_change(r,n[r],this.getv(r),t)}},t.prototype.getv=function(e){if(null==this.props[e])throw new Error("property "+this.type+"."+e+" wasn't declared");return this.attributes[e]},t.prototype.ref=function(){return{id:this.id}},t.prototype.struct=function(){var e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e},t.prototype.set_subtype=function(e){this._subtype=e},t.prototype.attribute_is_serializable=function(e){var t=this.props[e];if(null==t)throw new Error(this.type+".attribute_is_serializable('"+e+"'): "+e+" wasn't declared");return!t.internal},t.prototype.serializable_attributes=function(){var e={};for(var t in this.attributes){var r=this.attributes[t];this.attribute_is_serializable(t)&&(e[t]=r)}return e},t._value_to_json=function(e,r,i){if(r instanceof t)return r.ref();if(_.isArray(r)){for(var n=[],o=0;o<r.length;o++){var s=r[o];n.push(t._value_to_json(o.toString(),s,r))}return n}if(_.isPlainObject(r)){var a={};for(var p in r)r.hasOwnProperty(p)&&(a[p]=t._value_to_json(p,r[p],r));return a}return r},t.prototype.attributes_as_json=function(e,r){void 0===e&&(e=!0),void 0===r&&(r=t._value_to_json);var i=this.serializable_attributes(),n={};for(var o in i)if(i.hasOwnProperty(o)){var s=i[o];(e||o in this._set_after_defaults)&&(n[o]=s)}return r("attributes",n,this)},t._json_record_references=function(e,r,i,n){if(null==r);else if(s.is_ref(r)){if(!(r.id in i)){var o=e.get_model_by_id(r.id);t._value_record_references(o,i,n)}}else if(_.isArray(r))for(var a=0,p=r;a<p.length;a++){var u=p[a];t._json_record_references(e,u,i,n)}else if(_.isPlainObject(r))for(var f in r)if(r.hasOwnProperty(f)){u=r[f];t._json_record_references(e,u,i,n)}},t._value_record_references=function(e,r,i){if(null==e);else if(e instanceof t){if(!(e.id in r)&&(r[e.id]=e,i))for(var n=0,o=e._immediate_references();n<o.length;n++){var s=o[n];t._value_record_references(s,r,!0)}}else if(e.buffer instanceof ArrayBuffer);else if(_.isArray(e))for(var a=0,p=e;a<p.length;a++){var u=p[a];t._value_record_references(u,r,i)}else if(_.isPlainObject(e))for(var f in e)if(e.hasOwnProperty(f)){u=e[f];t._value_record_references(u,r,i)}},t.prototype._immediate_references=function(){var e={},r=this.serializable_attributes();for(var i in r){var n=r[i];t._value_record_references(n,e,!1)}return f.values(e)},t.prototype.references=function(){var e={};return t._value_record_references(this,e,!0),f.values(e)},t.prototype._doc_attached=function(){},t.prototype.attach_document=function(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()},t.prototype.detach_document=function(){this.document=null},t.prototype._tell_document_about_change=function(e,r,i,n){if(this.attribute_is_serializable(e)&&null!=this.document){var o={};t._value_record_references(i,o,!1);var s={};t._value_record_references(r,s,!1);var a=!1;for(var p in o)if(!(p in s)){a=!0;break}if(!a)for(var u in s)if(!(u in o)){a=!0;break}a&&this.document._invalidate_all_models(),this.document._notify_change(this,e,r,i,n)}},t.prototype.materialize_dataspecs=function(e){var t={};for(var r in this.properties){var i=this.properties[r];if(i instanceof a.VectorSpec&&(!i.optional||null!=i.spec.value||r in this._set_after_defaults)){var n=i.array(e);t["_"+r]=n,null!=i.spec.field&&i.spec.field in e._shapes&&(t["_"+r+"_shape"]=e._shapes[i.spec.field]),i instanceof a.DistanceSpec&&(t["max_"+r]=u.max(n))}}return t},t}(n.Signalable());r.HasProps=l,l.init_HasProps()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});var r=n(1),l=n(123),i=n(125),o=n(117),u=function(){function n(n,t){this.sender=n,this.name=t}return n.prototype.connect=function(n,t){void 0===t&&(t=null),s.has(this.sender)||s.set(this.sender,[]);var e=s.get(this.sender);if(null!=f(e,this,n,t))return!1;var r=t||n;c.has(r)||c.set(r,[]);var l=c.get(r),i={signal:this,slot:n,context:t};return e.push(i),l.push(i),!0},n.prototype.disconnect=function(n,t){void 0===t&&(t=null);var e=s.get(this.sender);if(null==e||0===e.length)return!1;var r=f(e,this,n,t);if(null==r)return!1;var l=t||n,i=c.get(l);return r.signal=null,h(e),h(i),!0},n.prototype.emit=function(n){for(var t=0,e=s.get(this.sender)||[];t<e.length;t++){var r=e[t],l=r.signal,i=r.slot,o=r.context;l===this&&i.call(o,n,this.sender)}},n}();e.Signal=u,u.__name__="Signal";var a=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.emit=function(){n.prototype.emit.call(this,void 0)},t}(u);e.Signal0=a,a.__name__="Signal0",function(n){n.disconnectBetween=function(n,t){var e=s.get(n);if(null!=e&&0!==e.length){var r=c.get(t);if(null!=r&&0!==r.length){for(var l=0,i=r;l<i.length;l++){var o=i[l];if(null==o.signal)return;o.signal.sender===n&&(o.signal=null)}h(e),h(r)}}},n.disconnectSender=function(n){var t=s.get(n);if(null!=t&&0!==t.length){for(var e=0,r=t;e<r.length;e++){var l=r[e];if(null==l.signal)return;var i=l.context||l.slot;l.signal=null,h(c.get(i))}h(t)}},n.disconnectReceiver=function(n){var t=c.get(n);if(null!=t&&0!==t.length){for(var e=0,r=t;e<r.length;e++){var l=r[e];if(null==l.signal)return;var i=l.signal.sender;l.signal=null,h(s.get(i))}h(t)}},n.disconnectAll=function(n){var t=s.get(n);if(null!=t&&0!==t.length){for(var e=0,r=t;e<r.length;e++){r[e].signal=null}h(t)}var l=c.get(n);if(null!=l&&0!==l.length){for(var i=0,o=l;i<o.length;i++){o[i].signal=null}h(l)}}}(u||(e.Signal=u={})),e.Signalable=function(){return function(){function n(){}return n.prototype.connect=function(n,t){return n.connect(t,this)},n.prototype.disconnect=function(n,t){return n.disconnect(t,this)},n}()};var s=new WeakMap,c=new WeakMap;function f(n,t,e,r){return o.find(n,(function(n){return n.signal===t&&n.slot===e&&n.context===r}))}var g=new l.Set;function h(n){0===g.size&&i.defer(v),g.add(n)}function v(){g.forEach((function(n){o.remove_by(n,(function(n){return null==n.signal}))})),g.clear()}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(117),i=t(124),o=t(116),s=function(){function t(){this._dict={}}return t.prototype._existing=function(t){return t in this._dict?this._dict[t]:null},t.prototype.add_value=function(t,e){var n=this._existing(t);null==n?this._dict[t]=e:o.isArray(n)?n.push(e):this._dict[t]=[n,e]},t.prototype.remove_value=function(t,e){var n=this._existing(t);if(o.isArray(n)){var s=r.difference(n,[e]);s.length>0?this._dict[t]=s:delete this._dict[t]}else i.isEqual(n,e)&&delete this._dict[t]},t.prototype.get_one=function(t,e){var n=this._existing(t);if(o.isArray(n)){if(1===n.length)return n[0];throw new Error(e)}return n},t}();n.MultiDict=s,s.__name__="MultiDict";var u=function(){function t(e){if(null==e)this._values=[];else if(e instanceof t)this._values=r.copy(e._values);else{this._values=[];for(var n=0,i=e;n<i.length;n++){var o=i[n];this.add(o)}}}return Object.defineProperty(t.prototype,"values",{get:function(){return r.copy(this._values).sort()},enumerable:!0,configurable:!0}),t.prototype.toString=function(){return"Set(["+this.values.join(",")+"])"},Object.defineProperty(t.prototype,"size",{get:function(){return this._values.length},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return-1!==this._values.indexOf(t)},t.prototype.add=function(t){this.has(t)||this._values.push(t)},t.prototype.remove=function(t){var e=this._values.indexOf(t);-1!==e&&this._values.splice(e,1)},t.prototype.toggle=function(t){var e=this._values.indexOf(t);-1===e?this._values.push(t):this._values.splice(e,1)},t.prototype.clear=function(){this._values=[]},t.prototype.union=function(e){return e=new t(e),new t(this._values.concat(e._values))},t.prototype.intersect=function(e){e=new t(e);for(var n=new t,r=0,i=e._values;r<i.length;r++){var o=i[r];this.has(o)&&e.has(o)&&n.add(o)}return n},t.prototype.diff=function(e){e=new t(e);for(var n=new t,r=0,i=this._values;r<i.length;r++){var o=i[r];e.has(o)||n.add(o)}return n},t.prototype.forEach=function(t,e){for(var n=0,r=this._values;n<r.length;n++){var i=r[n];t.call(e||this,i,i,this)}},t}();n.Set=u,u.__name__="Set";var a=function(){function t(t,e,n){this.nrows=t,this.ncols=e,this._matrix=new Array(t);for(var r=0;r<t;r++){this._matrix[r]=new Array(e);for(var i=0;i<e;i++)this._matrix[r][i]=n(r,i)}}return t.prototype.at=function(t,e){return this._matrix[t][e]},t.prototype.map=function(e){var n=this;return new t(this.nrows,this.ncols,(function(t,r){return e(n.at(t,r),t,r)}))},t.prototype.apply=function(e){var n=this,r=t.from(e),i=this.nrows,o=this.ncols;if(i==r.nrows&&o==r.ncols)return new t(i,o,(function(t,e){return r.at(t,e)(n.at(t,e),t,e)}));throw new Error("dimensions don't match")},t.prototype.to_sparse=function(){for(var t=[],e=0;e<this.nrows;e++)for(var n=0;n<this.ncols;n++){var r=this._matrix[e][n];t.push([r,e,n])}return t},t.from=function(e){return e instanceof t?e:new t(e.length,r.min(e.map((function(t){return t.length}))),(function(t,n){return e[t][n]}))},t}();n.Matrix=a,a.__name__="Matrix"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var n=t(116),o=Object.prototype.toString;r.isEqual=function(t,e){return function t(e,r,c,u){if(e===r)return 0!==e||1/e==1/r;if(null==e||null==r)return e===r;var i=o.call(e);if(i!==o.call(r))return!1;switch(i){case"[object RegExp]":case"[object String]":return""+e==""+r;case"[object Number]":return+e!=+e?+r!=+r:0==+e?1/+e==1/r:+e==+r;case"[object Date]":case"[object Boolean]":return+e==+r}var f="[object Array]"===i;if(!f){if("object"!=typeof e||"object"!=typeof r)return!1;var s=e.constructor,a=r.constructor;if(s!==a&&!(n.isFunction(s)&&s instanceof s&&n.isFunction(a)&&a instanceof a)&&"constructor"in e&&"constructor"in r)return!1}u=u||[];for(var l=(c=c||[]).length;l--;)if(c[l]===e)return u[l]===r;if(c.push(e),u.push(r),f){if((l=e.length)!==r.length)return!1;for(;l--;)if(!t(e[l],r[l],c,u))return!1}else{var b=Object.keys(e),p=void 0;if(l=b.length,Object.keys(r).length!==l)return!1;for(;l--;)if(p=b[l],!r.hasOwnProperty(p)||!t(e[p],r[p],c,u))return!1}return c.pop(),u.pop(),!0}(t,e)}},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.delay=
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
function(n,e){return setTimeout(n,e)};var r="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;t.defer=function(n){return new Promise((function(e){r((function(){return e(n())}))}))},t.throttle=function(n,e,t){var r,u,i;void 0===t&&(t={});var o=null,a=0,l=function(){a=!1===t.leading?0:Date.now(),o=null,i=n.apply(r,u),o||(r=u=null)};return function(){var c=Date.now();a||!1!==t.leading||(a=c);var f=e-(c-a);return r=this,u=arguments,f<=0||f>e?(o&&(clearTimeout(o),o=null),a=c,i=n.apply(r,u),o||(r=u=null)):o||!1===t.trailing||(o=setTimeout(l,f)),i}},t.once=function(n){var e,t=!1;return function(){return t||(t=!0,e=n()),e}}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1).__importStar(e(127)),a=e(131);function l(e,t){var r={};for(var n in e){var a=e[n];r[t+n]=a}return r}var i={line_color:[n.ColorSpec,"black"],line_width:[n.NumberSpec,1],line_alpha:[n.NumberSpec,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[n.Array,[]],line_dash_offset:[n.Number,0]};r.line=function(e){return void 0===e&&(e=""),l(i,e)};var o={fill_color:[n.ColorSpec,"gray"],fill_alpha:[n.NumberSpec,1]};r.fill=function(e){return void 0===e&&(e=""),l(o,e)};var c={hatch_color:[n.ColorSpec,"black"],hatch_alpha:[n.NumberSpec,1],hatch_scale:[n.NumberSpec,12],hatch_pattern:[n.StringSpec,null],hatch_weight:[n.NumberSpec,1],hatch_extra:[n.Any,{}]};r.hatch=function(e){return void 0===e&&(e=""),l(c,e)};var h={text_font:[n.Font,"helvetica"],text_font_size:[n.FontSizeSpec,"12pt"],text_font_style:[n.FontStyle,"normal"],text_color:[n.ColorSpec,"#444444"],text_alpha:[n.NumberSpec,1],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[n.Number,1.2]};r.text=function(e){return void 0===e&&(e=""),l(h,e)},r.create=function(e){for(var t={},n=0,l=e;n<l.length;n++){var i=l[n].split(":"),o=i[0],c=i[1],h=void 0;switch(o){case"line":h=r.line;break;case"fill":h=r.fill;break;case"hatch":h=r.hatch;break;case"text":h=r.text;break;default:throw new Error("Unknown property mixin kind '"+o+"'")}a.extend(t,h(c))}return t}},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),r=t(122),o=i.__importStar(t(128)),u=t(117),a=t(120),s=t(129),l=t(116);function c(t){try{return JSON.stringify(t)}catch(n){return t.toString()}}function p(t){return l.isPlainObject(t)&&(void 0===t.value?0:1)+(void 0===t.field?0:1)+(void 0===t.expr?0:1)==1}r.Signal,e.isSpec=p;var _=function(t){function n(n,e,i){var o=t.call(this)||this;return o.obj=n,o.attr=e,o.default_value=i,o.optional=!1,o.change=new r.Signal0(o.obj,"change"),o._init(),o.connect(o.change,(function(){return o._init()})),o}return i.__extends(n,t),n.prototype.update=function(){this._init()},n.prototype.init=function(){},n.prototype.transform=function(t){return t},n.prototype.validate=function(t){if(!this.valid(t))throw new Error(this.obj.type+"."+this.attr+" given invalid value: "+c(t))},n.prototype.valid=function(t){return!0},n.prototype.value=function(t){if(void 0===t&&(t=!0),void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");var n=this.transform([this.spec.value])[0];return null!=this.spec.transform&&t&&(n=this.spec.transform.compute(n)),n},n.prototype._init=function(){var t,n=this.obj,e=this.attr,i=n.getv(e);if(void 0===i){var r=this.default_value;i=void 0!==r?r(n):null,n.setv(((t={})[e]=i,t),{silent:!0,defaults:!0})}l.isArray(i)?this.spec={value:i}:p(i)?this.spec=i:this.spec={value:i},null!=this.spec.value&&this.validate(this.spec.value),this.init()},n.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+c(this.spec)+")"},n}(r.Signalable());e.Property=_,_.__name__="Property";var f=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(_);e.Any=f,f.__name__="Any";var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isArray(t)||t instanceof Float64Array},n}(_);e.Array=h,h.__name__="Array";var d=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isBoolean(t)},n}(_);e.Boolean=d,d.__name__="Boolean";var y=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isString(t)&&s.is_color(t)},n}(_);e.Color=y,y.__name__="Color";var v=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(_);e.Instance=v,v.__name__="Instance";var m=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isNumber(t)},n}(_);e.Number=m,m.__name__="Number";var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isNumber(t)&&(0|t)==t},n}(m);e.Int=S,S.__name__="Int";var g=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(m);e.Angle=g,g.__name__="Angle";var x=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isNumber(t)&&0<=t&&t<=1},n}(m);e.Percent=x,x.__name__="Percent";var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isString(t)},n}(_);e.String=b,b.__name__="String";var P=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(b);e.FontSize=P,P.__name__="FontSize";var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(b);e.Font=L,L.__name__="Font";var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.valid=function(t){return l.isString(t)&&u.includes(this.enum_values,t)},n}(_);function A(t){return function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return i.__extends(e,n),Object.defineProperty(e.prototype,"enum_values",{get:function(){return t},enumerable:!0,configurable:!0}),e}(T)}e.EnumProperty=T,T.__name__="EnumProperty",e.Enum=A;var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),Object.defineProperty(n.prototype,"enum_values",{get:function(){return o.Direction},enumerable:!0,configurable:!0}),n.prototype.transform=function(t){for(var n=new Uint8Array(t.length),e=0;e<t.length;e++)switch(t[e]){case"clock":n[e]=0;break;case"anticlock":n[e]=1}return n},n}(T);e.Direction=O,O.__name__="Direction",e.Anchor=A(o.Anchor),e.AngleUnits=A(o.AngleUnits),e.BoxOrigin=A(o.BoxOrigin),e.ButtonType=A(o.ButtonType),e.CalendarPosition=A(o.CalendarPosition),e.Dimension=A(o.Dimension),e.Dimensions=A(o.Dimensions),e.Distribution=A(o.Distribution),e.FontStyle=A(o.FontStyle),e.HatchPatternType=A(o.HatchPatternType),e.HTTPMethod=A(o.HTTPMethod),e.HexTileOrientation=A(o.HexTileOrientation),e.HoverMode=A(o.HoverMode),e.LatLon=A(o.LatLon),e.LegendClickPolicy=A(o.LegendClickPolicy),e.LegendLocation=A(o.LegendLocation),e.LineCap=A(o.LineCap),e.LineJoin=A(o.LineJoin),e.LinePolicy=A(o.LinePolicy),e.Location=A(o.Location),e.Logo=A(o.Logo),e.MarkerType=A(o.MarkerType),e.Orientation=A(o.Orientation),e.OutputBackend=A(o.OutputBackend),e.PaddingUnits=A(o.PaddingUnits),e.Place=A(o.Place),e.PointPolicy=A(o.PointPolicy),e.RadiusDimension=A(o.RadiusDimension),e.RenderLevel=A(o.RenderLevel),e.RenderMode=A(o.RenderMode),e.ResetPolicy=A(o.ResetPolicy),e.RoundingFunction=A(o.RoundingFunction),e.Side=A(o.Side),e.SizingMode=A(o.SizingMode),e.Sort=A(o.Sort),e.SpatialUnits=A(o.SpatialUnits),e.StartEnd=A(o.StartEnd),e.StepMode=A(o.StepMode),e.TapBehavior=A(o.TapBehavior),e.TextAlign=A(o.TextAlign),e.TextBaseline=A(o.TextBaseline),e.TextureRepetition=A(o.TextureRepetition),e.TickLabelOrientation=A(o.TickLabelOrientation),e.TooltipAttachment=A(o.TooltipAttachment),e.UpdateMode=A(o.UpdateMode),e.VerticalAlign=A(o.VerticalAlign);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(_);e.ScalarSpec=M,M.__name__="ScalarSpec";var j=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.array=function(t){var n;if(null!=this.spec.field){if(null==(n=this.transform(t.get_column(this.spec.field))))throw new Error("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'")}else if(null!=this.spec.expr)n=this.transform(this.spec.expr.v_compute(t));else{var e=t.get_length();null==e&&(e=1);var i=this.value(!1);n=u.repeat(i,e)}return null!=this.spec.transform&&(n=this.spec.transform.v_compute(n)),n},n}(_);e.VectorSpec=j,j.__name__="VectorSpec";var B=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(j);e.DataSpec=B,B.__name__="DataSpec";var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.init=function(){null==this.spec.units&&(this.spec.units=this.default_units);var t=this.spec.units;if(!u.includes(this.valid_units,t))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+t)},Object.defineProperty(n.prototype,"units",{get:function(){return this.spec.units},set:function(t){this.spec.units=t},enumerable:!0,configurable:!0}),n}(j);e.UnitsSpec=D,D.__name__="UnitsSpec";var C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),Object.defineProperty(n.prototype,"default_units",{get:function(){return"rad"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return o.AngleUnits},enumerable:!0,configurable:!0}),n.prototype.transform=function(n){return"deg"==this.spec.units&&(n=a.map(n,(function(t){return t*Math.PI/180}))),n=a.map(n,(function(t){return-t})),t.prototype.transform.call(this,n)},n}(D);e.AngleSpec=C,C.__name__="AngleSpec";var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.BooleanSpec=k,k.__name__="BooleanSpec";var U=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.ColorSpec=U,U.__name__="ColorSpec";var w=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.CoordinateSpec=w,w.__name__="CoordinateSpec";var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.CoordinateSeqSpec=R,R.__name__="CoordinateSeqSpec";var F=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),Object.defineProperty(n.prototype,"default_units",{get:function(){return"data"},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return o.SpatialUnits},enumerable:!0,configurable:!0}),n}(D);e.DistanceSpec=F,F.__name__="DistanceSpec";var N=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.FontSizeSpec=N,N.__name__="FontSizeSpec";var E=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.MarkerSpec=E,E.__name__="MarkerSpec";var H=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.NumberSpec=H,H.__name__="NumberSpec";var z=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.StringSpec=z,z.__name__="StringSpec";var I=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n}(B);e.NullStringSpec=I,I.__name__="NullStringSpec"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.Align=["start","center","end"],n.Anchor=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],n.AngleUnits=["deg","rad"],n.BoxOrigin=["corner","center"],n.ButtonType=["default","primary","success","warning","danger"],n.CalendarPosition=["auto","above","below"],n.Dimension=["width","height"],n.Dimensions=["width","height","both"],n.Direction=["clock","anticlock"],n.Distribution=["uniform","normal"],n.FontStyle=["normal","italic","bold","bold italic"],n.HatchPatternType=["blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"],n.HTTPMethod=["POST","GET"],n.HexTileOrientation=["pointytop","flattop"],n.HoverMode=["mouse","hline","vline"],n.LatLon=["lat","lon"],n.LegendClickPolicy=["none","hide","mute"],n.LegendLocation=n.Anchor,n.LineCap=["butt","round","square"],n.LineJoin=["miter","round","bevel"],n.LinePolicy=["prev","next","nearest","interp","none"],n.Location=["above","below","left","right"],n.Logo=["normal","grey"],n.MarkerType=["asterisk","circle","circle_cross","circle_x","cross","dash","diamond","diamond_cross","hex","inverted_triangle","square","square_cross","square_x","triangle","x"],n.Orientation=["vertical","horizontal"],n.OutputBackend=["canvas","svg","webgl"],n.PaddingUnits=["percent","absolute"],n.Place=["above","below","left","right","center"],n.PointPolicy=["snap_to_data","follow_mouse","none"],n.RadiusDimension=["x","y","max","min"],n.RenderLevel=["image","underlay","glyph","annotation","overlay"],n.RenderMode=["canvas","css"],n.ResetPolicy=["standard","event_only"],n.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],n.Side=["above","below","left","right"],n.SizingMode=["stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"],n.Sort=["ascending","descending"],n.SpatialUnits=["screen","data"],n.StartEnd=["start","end"],n.StepMode=["after","before","center"],n.TapBehavior=["select","inspect"],n.TextAlign=["left","right","center"],n.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],n.TextureRepetition=["repeat","repeat_x","repeat_y","no_repeat"],n.TickLabelOrientation=["vertical","horizontal","parallel","normal"],n.TooltipAttachment=["horizontal","vertical","left","right","above","below"],n.UpdateMode=["replace","append"],n.VerticalAlign=["top","middle","bottom"]},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=r(130),a=r(117);function o(r){var e=Number(r).toString(16);return 1==e.length?"0"+e:e}function l(r){if(0==(r+="").indexOf("#"))return r;if(n.is_svg_color(r))return n.svg_colors[r];if(0==r.indexOf("rgb")){var e=r.replace(/^rgba?\(|\s+|\)$/g,"").split(","),t=e.slice(0,3).map(o).join("");return 4==e.length&&(t+=o(Math.floor(255*parseFloat(e[3])))),"#"+t.slice(0,8)}return r}function i(r){var e;switch(r.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(r))throw new Error("color expects integers for rgb in rgb/rgba tuple, received "+r);var t=r.replace(e.start,"").replace(")","").split(",").map(parseFloat);if(t.length!=e.len)throw new Error("color expects rgba "+e.len+"-tuple, received "+r);if(e.alpha&&!(0<=t[3]&&t[3]<=1))throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");if(a.includes(t.slice(0,3).map((function(r){return 0<=r&&r<=255})),!1))throw new Error("color expects rgb to have value between 0 and 255");return!0}t.is_color=function(r){return n.is_svg_color(r.toLowerCase())||"#"==r.substring(0,1)||i(r)},t.rgb2hex=function(r,e,t){return"#"+o(255&r)+o(255&e)+o(255&t)},t.color2hex=l,t.color2rgba=function(r,e){if(void 0===e&&(e=1),!r)return[0,0,0,0];var t=l(r);(t=t.replace(/ |#/g,"")).length<=4&&(t=t.replace(/(.)/g,"$1$1"));for(var n=t.match(/../g).map((function(r){return parseInt(r,16)/255}));n.length<3;)n.push(0);return n.length<4&&n.push(e),n.slice(0,4)},t.valid_rgb=i},
function _(e,F,r){Object.defineProperty(r,"__esModule",{value:!0}),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(e){return e in r.svg_colors}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(117);function c(e){return Object.keys(e).length}n.keys=Object.keys,n.extend=Object.assign,n.values=void 0!==Object.values?Object.values:function(e){for(var t=Object.keys(e),n=t.length,r=new Array(n),c=0;c<n;c++)r[c]=e[t[c]];return r},n.clone=function(e){return Object.assign({},e)},n.merge=function(e,t){for(var n=Object.create(Object.prototype),c=0,o=r.concat([Object.keys(e),Object.keys(t)]);c<o.length;c++){var s=o[c],u=e.hasOwnProperty(s)?e[s]:[],a=t.hasOwnProperty(s)?t[s]:[];n[s]=r.union(u,a)}return n},n.size=c,n.isEmpty=function(e){return 0===c(e)}},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(116),t=e(131);r.is_ref=function(e){if(i.isPlainObject(e)){var n=t.keys(e);return 1==n.length&&"id"==n[0]}return!1}},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=r(134);function u(){for(var r=new Array(32),t=0;t<32;t++)r[t]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return r[12]="4",r[16]="0123456789ABCDEF".substr(3&r[16].charCodeAt(0)|8,1),r.join("")}e.startsWith=function(r,t,e){return void 0===e&&(e=0),r.substr(e,t.length)==t},e.uuid4=u;var a=1e3;e.uniqueId=function(r){var t=n.settings.dev?"j"+a++:u();return null!=r?r+"-"+t:t},e.escape=function(r){return r.replace(/(?:[&<>"'`])/g,(function(r){switch(r){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return r}}))},e.unescape=function(r){return r.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(function(r,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},e.use_strict=function(r){return"'use strict';\n"+r}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=function(){function e(){this._dev=!1}return Object.defineProperty(e.prototype,"dev",{get:function(){return this._dev},set:function(e){this._dev=e},enumerable:!0,configurable:!0}),e}();n.Settings=i,i.__name__="Settings",n.settings=new i},
function _(r,t,_){Object.defineProperty(_,"__esModule",{value:!0});var e=r(1);e.__exportStar(r(136),_),e.__exportStar(r(255),_),e.__exportStar(r(282),_),e.__exportStar(r(286),_),e.__exportStar(r(301),_),e.__exportStar(r(305),_),e.__exportStar(r(311),_),e.__exportStar(r(315),_),e.__exportStar(r(345),_),e.__exportStar(r(348),_),e.__exportStar(r(350),_),e.__exportStar(r(363),_),e.__exportStar(r(230),_),e.__exportStar(r(369),_),e.__exportStar(r(373),_),e.__exportStar(r(396),_),e.__exportStar(r(397),_),e.__exportStar(r(398),_),e.__exportStar(r(399),_),e.__exportStar(r(400),_),e.__exportStar(r(405),_),e.__exportStar(r(407),_),e.__exportStar(r(417),_),e.__exportStar(r(421),_)},
function _(a,e,o){Object.defineProperty(o,"__esModule",{value:!0});var r=a(137);o.Annotation=r.Annotation;var n=a(179);o.Arrow=n.Arrow;var t=a(180);o.ArrowHead=t.ArrowHead;var v=a(180);o.OpenHead=v.OpenHead;var l=a(180);o.NormalHead=l.NormalHead;var d=a(180);o.TeeHead=d.TeeHead;var i=a(180);o.VeeHead=i.VeeHead;var A=a(212);o.Band=A.Band;var H=a(213);o.BoxAnnotation=H.BoxAnnotation;var T=a(215);o.ColorBar=T.ColorBar;var p=a(240);o.Label=p.Label;var L=a(242);o.LabelSet=L.LabelSet;var b=a(243);o.Legend=b.Legend;var B=a(244);o.LegendItem=B.LegendItem;var S=a(246);o.PolyAnnotation=S.PolyAnnotation;var P=a(247);o.Slope=P.Slope;var g=a(248);o.Span=g.Span;var m=a(241);o.TextAnnotation=m.TextAnnotation;var w=a(249);o.Title=w.Title;var x=a(250);o.ToolbarPanel=x.ToolbarPanel;var s=a(251);o.Tooltip=s.Tooltip;var u=a(254);o.Whisker=u.Whisker},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),o=i.__importStar(t(138)),r=t(131),s=t(171),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,n=t.height;return{width:Math.round(e),height:Math.round(n)}}return{width:0,height:0}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.visible,(function(){return e.plot_view.request_layout()}))},e.prototype._get_size=function(){throw new Error("not implemented")},Object.defineProperty(e.prototype,"ctx",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),e.prototype.set_data=function(t){var e,n,i=this.model.materialize_dataspecs(t);if(r.extend(this,i),this.plot_model.use_map){null!=this._x&&(e=o.project_xy(this._x,this._y),this._x=e[0],this._y=e[1]),null!=this._xs&&(n=o.project_xsys(this._xs,this._ys),this._xs=n[0],this._ys=n[1])}},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!0,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:Object.assign(Object.assign({},e),{bbox:this.layout.bbox.box})},e}(s.RendererView);n.AnnotationView=a,a.__name__="AnnotationView";var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Annotation=function(){this.override({level:"annotation"})},e}(s.Renderer);n.Annotation=l,l.__name__="Annotation",l.init_Annotation()},
function _(r,t,n){Object.defineProperty(n,"__esModule",{value:!0});var e=r(1),a=e.__importDefault(r(139)),o=e.__importDefault(r(140)),u=new o.default("GOOGLE"),l=new o.default("WGS84");n.wgs84_mercator=a.default(l,u);var f={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},i={lon:[-180,180],lat:[-85.06,85.06]};function _(r,t){for(var e=Math.min(r.length,t.length),a=new Array(e),o=new Array(e),u=0;u<e;u++){var l=n.wgs84_mercator.forward([r[u],t[u]]),f=l[0],i=l[1];a[u]=f,o[u]=i}return[a,o]}n.clip_mercator=function(r,t,n){var e=f[n],a=e[0],o=e[1];return[Math.max(r,a),Math.min(t,o)]},n.in_bounds=function(r,t){var n=i[t],e=n[0],a=n[1];return e<r&&r<a},n.project_xy=_,n.project_xsys=function(r,t){for(var n=Math.min(r.length,t.length),e=new Array(n),a=new Array(n),o=0;o<n;o++){var u=_(r[o],t[o]),l=u[0],f=u[1];e[o]=l,a[o]=f}return[e,a]}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),o=r.__importDefault(e(140)),a=r.__importDefault(e(165)),i=o.default("WGS84");function u(e,n,t){var r,o,i;return Array.isArray(t)?(r=a.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=a.default(e,n,t),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function c(e){return e instanceof o.default?e:e.oProj?e.oProj:o.default(e)}t.default=function(e,n,t){e=c(e);var r,o=!1;return void 0===n?(n=e,e=i,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=i,o=!0),n=c(n),t?u(e,n,t):(r={forward:function(t){return u(e,n,t)},inverse:function(t){return u(n,e,t)}},o&&(r.oProj=n),r)}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var s=e(1),i=s.__importDefault(e(141)),u=s.__importDefault(e(152)),l=s.__importDefault(e(153)),r=e(161),o=s.__importDefault(e(163)),f=s.__importDefault(e(164)),d=s.__importDefault(e(148));function p(e,t){if(!(this instanceof p))return new p(e);t=t||function(e){if(e)throw e};var a=i.default(e);if("object"==typeof a){var s=p.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var l=d.default(o.default,a.datumCode);l&&(a.datum_params=l.towgs84?l.towgs84.split(","):null,a.ellps=l.ellipse,a.datumName=l.datumName?l.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var m=r.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),n=r.eccentricity(m.a,m.b,m.rf,a.R_A),h=a.datum||f.default(a.datumCode,a.datum_params,m.a,m.b,n.es,n.ep2);u.default(this,a),u.default(this,s),this.a=m.a,this.b=m.b,this.rf=m.rf,this.sphere=m.sphere,this.es=n.es,this.e=n.e,this.ep2=n.ep2,this.datum=h,this.init(),t(null,this)}else t(e)}else t(e)}p.projections=l.default,p.projections.start(),a.default=p},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var u=t(1),n=u.__importDefault(t(142)),f=u.__importDefault(t(149)),i=u.__importDefault(t(144)),a=u.__importDefault(t(148));var o=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var l=["3857","900913","3785","102113"];r.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in n.default}(t))return n.default[t];if(function(t){return o.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=f.default(t);if(function(t){var e=a.default(t,"authority");if(e){var r=a.default(e,"epsg");return r&&l.indexOf(r)>-1}}(e))return n.default["EPSG:3857"];var r=function(t){var e=a.default(t,"extension");if(e)return a.default(e,"proj4")}(e);return r?i.default(r):e}return function(t){return"+"===t[0]}(t)?i.default(t):void 0}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=i.__importDefault(e(143)),a=i.__importDefault(e(144)),f=i.__importDefault(e(149));function l(e){var t=this;if(2===arguments.length){var r=arguments[1];"string"==typeof r?"+"===r.charAt(0)?l[e]=a.default(arguments[1]):l[e]=f.default(arguments[1]):l[e]=r}else if(1===arguments.length){if(Array.isArray(e))return e.map((function(e){Array.isArray(e)?l.apply(t,e):l(e)}));if("string"==typeof e){if(e in l)return l[e]}else"EPSG"in e?l["EPSG:"+e.EPSG]=e:"ESRI"in e?l["ESRI:"+e.ESRI]=e:"IAU2000"in e?l["IAU2000:"+e.IAU2000]=e:console.log(e);return}}n.default(l),r.default=l},
function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.default=function(e){e("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),e("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),e("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),e.WGS84=e["EPSG:4326"],e["EPSG:3785"]=e["EPSG:3857"],e.GOOGLE=e["EPSG:3857"],e["EPSG:900913"]=e["EPSG:3857"],e["EPSG:102113"]=e["EPSG:3857"]}},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});var e=t(1),a=t(145),u=e.__importDefault(t(146)),r=e.__importDefault(t(147)),i=e.__importDefault(t(148));o.default=function(t){var n,o,e,f={},l=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){f.rf=parseFloat(t)},lat_0:function(t){f.lat0=t*a.D2R},lat_1:function(t){f.lat1=t*a.D2R},lat_2:function(t){f.lat2=t*a.D2R},lat_ts:function(t){f.lat_ts=t*a.D2R},lon_0:function(t){f.long0=t*a.D2R},lon_1:function(t){f.long1=t*a.D2R},lon_2:function(t){f.long2=t*a.D2R},alpha:function(t){f.alpha=parseFloat(t)*a.D2R},lonc:function(t){f.longc=t*a.D2R},x_0:function(t){f.x0=parseFloat(t)},y_0:function(t){f.y0=parseFloat(t)},k_0:function(t){f.k0=parseFloat(t)},k:function(t){f.k0=parseFloat(t)},a:function(t){f.a=parseFloat(t)},b:function(t){f.b=parseFloat(t)},r_a:function(){f.R_A=!0},zone:function(t){f.zone=parseInt(t,10)},south:function(){f.utmSouth=!0},towgs84:function(t){f.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){f.to_meter=parseFloat(t)},units:function(t){f.units=t;var n=i.default(r.default,t);n&&(f.to_meter=n.to_meter)},from_greenwich:function(t){f.from_greenwich=t*a.D2R},pm:function(t){var n=i.default(u.default,t);f.from_greenwich=(n||parseFloat(t))*a.D2R},nadgrids:function(t){"@null"===t?f.datumCode="none":f.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(f.axis=t)}};for(n in l)o=l[n],n in c?"function"==typeof(e=c[n])?e(o):f[e]=o:f[n]=o;return"string"==typeof f.datumCode&&"WGS84"!==f.datumCode&&(f.datumCode=f.datumCode.toLowerCase()),f}},
function _(P,_,e){Object.defineProperty(e,"__esModule",{value:!0}),e.PJD_3PARAM=1,e.PJD_7PARAM=2,e.PJD_WGS84=4,e.PJD_NODATUM=5,e.SEC_TO_RAD=484813681109536e-20,e.HALF_PI=Math.PI/2,e.SIXTH=.16666666666666666,e.RA4=.04722222222222222,e.RA6=.022156084656084655,e.EPSLN=1e-10,e.D2R=.017453292519943295,e.R2D=57.29577951308232,e.FORTPI=Math.PI/4,e.TWO_PI=2*Math.PI,e.SPI=3.14159265359},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});var a={};r.default=a,a.greenwich=0,a.lisbon=-9.131906111111,a.paris=2.337229166667,a.bogota=-74.080916666667,a.madrid=-3.687938888889,a.rome=12.452333333333,a.bern=7.439583333333,a.jakarta=106.807719444444,a.ferro=-17.666666666667,a.brussels=4.367975,a.stockholm=18.058277777778,a.athens=23.7163375,a.oslo=10.722916666667},
function _(e,t,f){Object.defineProperty(f,"__esModule",{value:!0}),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),d=o.__importDefault(e(150)),r=e(151);function n(e){return.017453292519943295*e}t.default=function(e){var a=d.default(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var l={};return r.sExpr(a,l),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var d=e.AXIS[t][0].toLowerCase();-1!==d.indexOf("north")?a+="n":-1!==d.indexOf("south")?a+="s":-1!==d.indexOf("east")?a+="e":-1!==d.indexOf("west")&&(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",n],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",n],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",n],["lat0","latitude_of_origin",n],["lat0","standard_parallel_1",n],["lat1","standard_parallel_1",n],["lat2","standard_parallel_2",n],["azimuth","Azimuth"],["alpha","azimuth",n],["srsCode","name"]].forEach((function(a){return t=e,d=(o=a)[0],r=o[1],void(!(d in t)&&r in t&&(t[d]=t[r],3===o.length&&(t[d]=o[2](t[d]))));var t,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=n(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(l),l}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(t){return new a(t).output()};var i=/\s/,s=/[A-Za-z]/,h=/[A-Za-z84]/,o=/[,\]]/,n=/[\d\.E\-\+]/;function a(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}a.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;i.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},a.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(o.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},a.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},a.prototype.number=function(t){if(!n.test(t)){if(o.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},a.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},a.prototype.keyword=function(t){if(h.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!o.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},a.prototype.neutral=function(t){if(s.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(n.test(t))return this.word=t,void(this.state=3);if(!o.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},a.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,r,a){function s(e,r,a){Array.isArray(r)&&(a.unshift(r),r=null);var s=r?{}:e,n=a.reduce((function(e,r){return c(r,e),e}),s);r&&(e[r]=n)}function c(e,r){if(Array.isArray(e)){var a=e.shift();if("PARAMETER"===a&&(a=e.shift()),1===e.length)return Array.isArray(e[0])?(r[a]={},void c(e[0],r[a])):void(r[a]=e[0]);if(e.length)if("TOWGS84"!==a){if("AXIS"===a)return a in r||(r[a]=[]),void r[a].push(e);var n;switch(Array.isArray(a)||(r[a]={}),a){case"UNIT":case"PRIMEM":case"VERT_DATUM":return r[a]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&c(e[2],r[a]));case"SPHEROID":case"ELLIPSOID":return r[a]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&c(e[3],r[a]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void s(r,a,e);default:for(n=-1;++n<e.length;)if(!Array.isArray(e[n]))return c(e,r[a]);return s(r,a,e)}}else r[a]=e;else r[a]=!0}else r[e]=!0}Object.defineProperty(a,"__esModule",{value:!0}),a.sExpr=c},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(e,n){var r,t;if(e=e||{},!n)return e;for(t in n)void 0!==(r=n[t])&&(e[t]=r);return e}},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var a=t(1),r=a.__importDefault(t(154)),n=a.__importDefault(t(160)),u=[r.default,n.default],f={},i=[];function d(t,e){var o=i.length;return t.names?(i[o]=t,t.names.forEach((function(t){f[t.toLowerCase()]=o})),this):(console.log(e),!0)}function l(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==f[e]&&i[f[e]]?i[f[e]]:void 0}function c(){u.forEach(d)}o.add=d,o.get=l,o.start=c,o.default={start:c,add:d,get:l}},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});var h=t(1),a=h.__importDefault(t(155)),e=h.__importDefault(t(156)),r=h.__importDefault(t(158)),n=h.__importDefault(t(159)),l=t(145);function u(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=a.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function o(t){var i,s,h=t.x,a=t.y;if(a*l.R2D>90&&a*l.R2D<-90&&h*l.R2D>180&&h*l.R2D<-180)return null;if(Math.abs(Math.abs(a)-l.HALF_PI)<=l.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(l.FORTPI+.5*a));else{var n=Math.sin(a),u=r.default(this.e,a,n);i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(u)}return t.x=i,t.y=s,t}function f(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=l.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var r=Math.exp(-a/(this.a*this.k0));if(-9999===(s=n.default(this.e,r)))return null}return i=e.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=u,s.forward=o,s.inverse=f,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:u,forward:o,inverse:f,names:s.names}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){var r=e*t;return n/Math.sqrt(1-r*r)}},
function _(e,t,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(1),f=e(145),n=a.__importDefault(e(157));u.default=function(e){return Math.abs(e)<=f.SPI?e:e-n.default(e)*f.TWO_PI}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return e<0?-1:1}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var n=e(145);a.default=function(e,t,a){var r=e*a,u=.5*e;return r=Math.pow((1-r)/(1+r),u),Math.tan(.5*(n.HALF_PI-t))/r}},
function _(a,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=a(145);e.default=function(a,t){for(var e,r,u=.5*a,f=n.HALF_PI-2*Math.atan(t),o=0;o<=15;o++)if(e=a*Math.sin(f),f+=r=n.HALF_PI-2*Math.atan(t*Math.pow((1-e)/(1+e),u))-f,Math.abs(r)<=1e-10)return f;return-9999}},
function _(e,n,i){function t(){}function r(e){return e}Object.defineProperty(i,"__esModule",{value:!0}),i.init=t,i.forward=r,i.inverse=r,i.names=["longlat","identity"],i.default={init:t,forward:r,inverse:r,names:i.names}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var a=e(1),f=e(145),n=a.__importStar(e(162)),u=a.__importDefault(e(148));t.eccentricity=function(e,r,t,a){var n=e*e,u=r*r,i=(n-u)/n,c=0;return a?(n=(e*=1-i*(f.SIXTH+i*(f.RA4+i*f.RA6)))*e,i=0):c=Math.sqrt(i),{es:i,e:c,ep2:(n-u)/u}},t.sphere=function(e,r,t,a,i){if(!e){var c=u.default(n.default,a);c||(c=n.WGS84),e=c.a,r=c.b,t=c.rf}return t&&!r&&(r=(1-1/t)*e),(0===t||Math.abs(e-r)<f.EPSLN)&&(i=!0,r=e),{a:e,b:r,rf:t,sphere:i}}},
function _(e,a,l){Object.defineProperty(l,"__esModule",{value:!0});var s={};l.default=s,s.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},s.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},s.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},s.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},s.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},s.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},s.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},s.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},s.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},s.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},s.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},s.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},s.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},s.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},s.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},s.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},s.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},s.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},s.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},s.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},s.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},s.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},s.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},s.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},s.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},s.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},s.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},s.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},s.hough={a:6378270,rf:297,ellipseName:"Hough"},s.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},s.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},s.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},s.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},s.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},s.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},s.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},s.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},s.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},s.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},s.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},s.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=s.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},s.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s){Object.defineProperty(s,"__esModule",{value:!0});var t={};s.default=t,t.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},t.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},t.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},t.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},t.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},t.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},t.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},t.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},t.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},t.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},t.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},t.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},t.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},t.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},t.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},t.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},t.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_){Object.defineProperty(_,"__esModule",{value:!0});var t=a(145);_.default=function(a,m,_,u,d,p){var r={};return r.datum_type=void 0===a||"none"===a?t.PJD_NODATUM:t.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=t.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=t.PJD_7PARAM,r.datum_params[3]*=t.SEC_TO_RAD,r.datum_params[4]*=t.SEC_TO_RAD,r.datum_params[5]*=t.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=u,r.es=d,r.ep2=p,r}},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});var r=t(1),u=t(145),m=r.__importDefault(t(166)),_=r.__importDefault(t(168)),o=r.__importDefault(t(140)),d=r.__importDefault(t(169)),f=r.__importDefault(t(170));a.default=function t(e,a,r){var n;return Array.isArray(r)&&(r=d.default(r)),f.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===u.PJD_3PARAM||t.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===u.PJD_3PARAM||e.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,n=new o.default("WGS84"),r),e=n),"enu"!==e.axis&&(r=_.default(e,!1,r)),"longlat"===e.projName?r={x:r.x*u.D2R,y:r.y*u.D2R,z:r.z||0}:(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),r=e.inverse(r)),e.from_greenwich&&(r.x+=e.from_greenwich),r=m.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*u.R2D,y:r.y*u.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?_.default(a,!0,r):r}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var u=e(145),_=e(167);function o(e){return e===u.PJD_3PARAM||e===u.PJD_7PARAM}a.default=function(e,t,a){return _.compareDatums(e,t)||e.datum_type===u.PJD_NODATUM||t.datum_type===u.PJD_NODATUM?a:e.es!==t.es||e.a!==t.a||o(e.datum_type)||o(t.datum_type)?(a=_.geodeticToGeocentric(a,e.es,e.a),o(e.datum_type)&&(a=_.geocentricToWgs84(a,e.datum_type,e.datum_params)),o(t.datum_type)&&(a=_.geocentricFromWgs84(a,t.datum_type,t.datum_params)),_.geocentricToGeodetic(a,t.es,t.a,t.b)):a}},
function _(a,t,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(145);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===e.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==e.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,_,s,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-e.HALF_PI&&d>-1.001*e.HALF_PI)d=-e.HALF_PI;else if(d>e.HALF_PI&&d<1.001*e.HALF_PI)d=e.HALF_PI;else{if(d<-e.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>e.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),s=Math.cos(d),_=u*u,{x:((m=r/Math.sqrt(1-t*_))+i)*s*Math.cos(n),y:(m+i)*s*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,_,s,n,d,i,p,P,y,M,o,z,A,c,x,f=a.x,h=a.y,I=a.z?a.z:0;if(u=Math.sqrt(f*f+h*h),_=Math.sqrt(f*f+h*h+I*I),u/r<1e-12){if(c=0,_/r<1e-12)return e.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(h,f);s=I/_,P=(n=u/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=s*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=u*P+I*y-p*(1-t*y*y))),z=(o=s*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(M=n*(1-i)*d)*y,P=M,y=o}while(z*z>1e-24&&A<30);return{x:c,y:Math.atan(o/Math.abs(M)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],s=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-s*a.z)+u,z:i*(-n*a.x+s*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],s=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+s*y,z:n*p-s*P+y}}}},
function _(e,a,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(e,a,r){var c,s,u,i=r.x,n=r.y,t=r.z||0,d={};for(u=0;u<3;u++)if(!a||2!==u||void 0!==r.z)switch(0===u?(c=i,s="x"):1===u?(c=n,s="y"):(c=t,s="z"),e.axis[u]){case"e":d[s]=c;break;case"w":d[s]=-c;break;case"n":d[s]=c;break;case"s":d[s]=-c;break;case"u":void 0!==r[s]&&(d.z=c);break;case"d":void 0!==r[s]&&(d.z=-c);break;default:return null}return d}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var n={x:e[0],y:e[1]};return e.length>2&&(n.z=e[2]),e.length>3&&(n.m=e[3]),n}},
function _(e,i,n){function t(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e){t(e.x),t(e.y)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(172),o=r.__importStar(e(176)),_=r.__importStar(e(127)),l=e(177),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new o.Visuals(this.model),this._has_finished=!0},Object.defineProperty(t.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),t.prototype.request_render=function(){this.plot_view.request_render()},t.prototype.map_to_screen=function(e,t){return this.plot_view.map_to_screen(e,t,this.model.x_range_name,this.model.y_range_name)},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!0,configurable:!0}),t.prototype.notify_finished=function(){this.plot_view.notify_finished()},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return!1},enumerable:!0,configurable:!0}),t}(i.DOMView);n.RendererView=u,u.__name__="RendererView";var p=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Renderer=function(){this.define({level:[_.RenderLevel],visible:[_.Boolean,!0]})},t}(l.Model);n.Renderer=p,p.__name__="Renderer",p.init_Renderer()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(173),o=r.__importStar(e(174)),s=e(175),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._has_finished=!1,this.el=this._createElement()},t.prototype.remove=function(){o.removeElement(this.el),e.prototype.remove.call(this)},t.prototype.css_classes=function(){return[]},t.prototype.cursor=function(e,t){return null},t.prototype.render=function(){},t.prototype.renderTo=function(e){e.appendChild(this.el),this.render()},t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"_root_element",{get:function(){return o.parent(this.el,"."+s.bk_root)||document.body},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!0,configurable:!0}),t.prototype._createElement=function(){return o.createElement(this.tagName,{class:this.css_classes()})},t}(i.View);n.DOMView=p,p.__name__="DOMView",p.prototype.tagName="div"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),r=t(122),i=t(116),c=t(133),s=function(){function t(t){if(this.removed=new r.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),null==t.model)throw new Error("model of a view wasn't configured");this.model=t.model,this._parent=t.parent,this.id=t.id||c.uniqueId()}return Object.defineProperty(t.prototype,"ready",{get:function(){return this._ready},enumerable:!0,configurable:!0}),t.prototype.connect=function(t,e){var n=this;return t.connect((function(t,o){var r=Promise.resolve(e.call(n,t,o));n._ready=n._ready.then((function(){return r}))}),this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t.prototype.initialize=function(){},t.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){return[2]}))}))},t.prototype.remove=function(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.id+")"},t.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(t.prototype,"parent",{get:function(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_root",{get:function(){return null===this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"root",{get:function(){return this.is_root?this:this.parent.root},enumerable:!0,configurable:!0}),t.prototype.assert_root=function(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")},t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},t.prototype.on_change=function(t,e){for(var n=0,o=i.isArray(t)?t:[t];n<o.length;n++){var r=o[n];this.connect(r.change,e)}},t}();n.View=s,s.__name__="View"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),r=t(116),o=function(t){return function(e){void 0===e&&(e={});for(var n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];var o=document.createElement(t);for(var l in o.classList.add("bk"),e){var a=e[l];if(null!=a&&(!r.isBoolean(a)||a))if("class"===l&&(r.isString(a)&&(a=a.split(/\s+/)),r.isArray(a)))for(var s=0,h=a;s<h.length;s++){var c=h[s];null!=c&&o.classList.add(c)}else if("style"===l&&r.isPlainObject(a))for(var p in a)o.style[p]=a[p];else if("data"===l&&r.isPlainObject(a))for(var d in a)o.dataset[d]=a[d];else o.setAttribute(l,a)}function u(t){if(t instanceof HTMLElement)o.appendChild(t);else if(r.isString(t))o.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error("expected an HTMLElement, string, false or null, got "+JSON.stringify(t))}for(var f=0,g=n;f<g.length;f++){var y=g[f];if(r.isArray(y))for(var v=0,m=y;v<m.length;v++){var b=m[v];u(b)}else u(y)}return o}};function l(t){var e=t.parentNode;null!=e&&e.removeChild(t)}function a(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];for(var i=t.firstChild,r=0,o=e;r<o.length;r++){var l=o[r];t.insertBefore(l,i)}}function s(t,e){var n=Element.prototype;return(n.matches||n.webkitMatchesSelector||n.mozMatchesSelector||n.msMatchesSelector).call(t,e)}function h(t){return parseFloat(t)||0}function c(t){var e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function p(t){var e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e){for(var n=[],r=2;r<arguments.length;r++)n[r-2]=arguments[r];return o(t).apply(void 0,i.__spreadArrays([e],n))},n.div=o("div"),n.span=o("span"),n.canvas=o("canvas"),n.link=o("link"),n.style=o("style"),n.a=o("a"),n.p=o("p"),n.i=o("i"),n.pre=o("pre"),n.button=o("button"),n.label=o("label"),n.input=o("input"),n.select=o("select"),n.option=o("option"),n.optgroup=o("optgroup"),n.textarea=o("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.append=function(t){for(var e=[],n=1;n<arguments.length;n++)e[n-1]=arguments[n];for(var i=0,r=e;i<r.length;i++){var o=r[i];t.appendChild(o)}},n.remove=l,n.removeElement=l,n.replaceWith=function(t,e){var n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=a,n.empty=function(t){for(var e;e=t.firstChild;)t.removeChild(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=s,n.parent=function(t,e){for(var n=t;n=n.parentElement;)if(s(n,e))return n;return null},n.extents=c,n.size=p,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){var e=c(t).margin,n=e.left,i=e.right,r=e.top,o=e.bottom,l=p(t),a=l.width,s=l.height;return{width:Math.ceil(a+n+i),height:Math.ceil(s+r+o)}},n.content_size=function(t){for(var e=t.getBoundingClientRect(),n=e.left,i=e.top,r=c(t).padding,o=0,l=0,a=0,s=t.children;a<s.length;a++){var h=s[a].getBoundingClientRect();o=Math.max(o,Math.ceil(h.left-n-r.left+h.width)),l=Math.max(l,Math.ceil(h.top-i-r.top+h.height))}return{width:o,height:l}},n.position=function(t,e,n){var i=t.style;if(i.left=e.x+"px",i.top=e.y+"px",i.width=e.width+"px",i.height=e.height+"px",null==n)i.margin="";else{var r=n.top,o=n.right,l=n.bottom,a=n.left;i.margin=r+"px "+o+"px "+l+"px "+a+"px"}},n.children=function(t){return Array.from(t.children)};var d,u=function(){function t(t){this.el=t,this.classList=t.classList}return Object.defineProperty(t.prototype,"values",{get:function(){for(var t=[],e=0;e<this.classList.length;e++){var n=this.classList.item(e);null!=n&&t.push(n)}return t},enumerable:!0,configurable:!0}),t.prototype.has=function(t){return this.classList.contains(t)},t.prototype.add=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var n=0,i=t;n<i.length;n++){var r=i[n];this.classList.add(r)}return this},t.prototype.remove=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var n=0,i=t;n<i.length;n++){var r=i[n];this.classList.remove(r)}return this},t.prototype.clear=function(){for(var t=0,e=this.values;t<e.length;t++){var n=e[t];"bk"!=n&&this.classList.remove(n)}return this},t.prototype.toggle=function(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this},t}();function f(t,e,n){var i=t.style,r=i.width,o=i.height,l=i.position,a=i.display;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return n()}finally{t.style.position=l,t.style.display=a,t.style.width=r,t.style.height=o}}n.ClassList=u,u.__name__="ClassList",n.classes=function(t){return new u(t)},(d=n.Keys||(n.Keys={}))[d.Backspace=8]="Backspace",d[d.Tab=9]="Tab",d[d.Enter=13]="Enter",d[d.Esc=27]="Esc",d[d.PageUp=33]="PageUp",d[d.PageDown=34]="PageDown",d[d.Left=37]="Left",d[d.Up=38]="Up",d[d.Right=39]="Right",d[d.Down=40]="Down",d[d.Delete=46]="Delete",n.undisplayed=function(t,e){var n=t.style.display;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return f(t,{},e)},n.sized=f;var g=function(){function t(){this.style=n.style({type:"text/css"}),a(document.head,this.style)}return t.prototype.append=function(t){this.style.appendChild(document.createTextNode(t))},t}();n.StyleSheet=g,g.__name__="StyleSheet",n.styles=new g},
function _(n,o,e){Object.defineProperty(e,"__esModule",{value:!0}),n(1).__importStar(n(174)).styles.append(".bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 10pt;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"),e.bk_root="bk-root"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var i=e(1),l=i.__importStar(e(126)),c=e(129);function o(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function s(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function h(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}function r(e,t,a,i){var l=a,c=l/2,r=c/2,n=function(e){var t=document.createElement("canvas");return t.width=e,t.height=e,t}(a),_=n.getContext("2d");switch(_.strokeStyle=t,_.lineCap="square",_.fillStyle=t,_.lineWidth=i,e){case" ":case"blank":break;case".":case"dot":_.arc(c,c,c/2,0,2*Math.PI,!0),_.fill();break;case"o":case"ring":_.arc(c,c,c/2,0,2*Math.PI,!0),_.stroke();break;case"-":case"horizontal_line":o(_,l,c);break;case"|":case"vertical_line":s(_,l,c);break;case"+":case"cross":o(_,l,c),s(_,l,c);break;case'"':case"horizontal_dash":o(_,c,c);break;case":":case"vertical_dash":s(_,c,c);break;case"@":case"spiral":var p=l/30;_.moveTo(c,c);for(var u=0;u<360;u++){var f=.1*u,v=c+p*f*Math.cos(f),y=c+p*f*Math.sin(f);_.lineTo(v,y)}_.stroke();break;case"/":case"right_diagonal_line":_.moveTo(.5-r,l),_.lineTo(r+.5,0),_.stroke(),_.moveTo(r+.5,l),_.lineTo(3*r+.5,0),_.stroke(),_.moveTo(3*r+.5,l),_.lineTo(5*r+.5,0),_.stroke(),_.stroke();break;case"\\":case"left_diagonal_line":_.moveTo(r+.5,l),_.lineTo(.5-r,0),_.stroke(),_.moveTo(3*r+.5,l),_.lineTo(r+.5,0),_.stroke(),_.moveTo(5*r+.5,l),_.lineTo(3*r+.5,0),_.stroke(),_.stroke();break;case"x":case"diagonal_cross":h(_,l);break;case",":case"right_diagonal_dash":_.moveTo(r+.5,3*r+.5),_.lineTo(3*r+.5,r+.5),_.stroke();break;case"`":case"left_diagonal_dash":_.moveTo(r+.5,r+.5),_.lineTo(3*r+.5,3*r+.5),_.stroke();break;case"v":case"horizontal_wave":_.moveTo(0,r),_.lineTo(c,3*r),_.lineTo(l,r),_.stroke();break;case">":case"vertical_wave":_.moveTo(r,0),_.lineTo(3*r,c),_.lineTo(r,l),_.stroke();break;case"*":case"criss_cross":h(_,l),o(_,l,c),s(_,l,c)}return n}var n=function(){function e(e,t){void 0===t&&(t=""),this.obj=e,this.prefix=t,this.cache={};for(var a=0,i=this.attrs;a<i.length;a++){var l=i[a];this[l]=e.properties[t+l]}}return e.prototype.warm_cache=function(e){for(var t=0,a=this.attrs;t<a.length;t++){var i=a[t],l=this.obj.properties[this.prefix+i];if(void 0!==l.spec.value)this.cache[i]=l.spec.value;else{if(null==e)throw new Error("source is required with a vectorized visual property");this.cache[i+"_array"]=l.array(e)}}},e.prototype.cache_select=function(e,t){var a,i=this.obj.properties[this.prefix+e];return void 0!==i.spec.value?this.cache[e]=a=i.spec.value:this.cache[e]=a=this.cache[e+"_array"][t],a},e.prototype.set_vectorize=function(e,t){null!=this.all_indices?this._set_vectorize(e,this.all_indices[t]):this._set_vectorize(e,t)},e}();a.ContextProperties=n,n.__name__="ContextProperties";var _=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.set_value=function(e){e.strokeStyle=this.line_color.value(),e.globalAlpha=this.line_alpha.value(),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.setLineDash(this.line_dash.value()),e.setLineDashOffset(this.line_dash_offset.value())},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){this.cache_select("line_color",t),e.strokeStyle!==this.cache.line_color&&(e.strokeStyle=this.cache.line_color),this.cache_select("line_alpha",t),e.globalAlpha!==this.cache.line_alpha&&(e.globalAlpha=this.cache.line_alpha),this.cache_select("line_width",t),e.lineWidth!==this.cache.line_width&&(e.lineWidth=this.cache.line_width),this.cache_select("line_join",t),e.lineJoin!==this.cache.line_join&&(e.lineJoin=this.cache.line_join),this.cache_select("line_cap",t),e.lineCap!==this.cache.line_cap&&(e.lineCap=this.cache.line_cap),this.cache_select("line_dash",t),e.getLineDash()!==this.cache.line_dash&&e.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",t),e.getLineDashOffset()!==this.cache.line_dash_offset&&e.setLineDashOffset(this.cache.line_dash_offset)},t.prototype.color_value=function(){var e=c.color2rgba(this.line_color.value(),this.line_alpha.value());return"rgba("+255*e[0]+","+255*e[1]+","+255*e[2]+","+e[3]+")"},t}(n);a.Line=_,_.__name__="Line",_.prototype.attrs=Object.keys(l.line());var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.set_value=function(e){e.fillStyle=this.fill_color.value(),e.globalAlpha=this.fill_alpha.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){this.cache_select("fill_color",t),e.fillStyle!==this.cache.fill_color&&(e.fillStyle=this.cache.fill_color),this.cache_select("fill_alpha",t),e.globalAlpha!==this.cache.fill_alpha&&(e.globalAlpha=this.cache.fill_alpha)},t.prototype.color_value=function(){var e=c.color2rgba(this.fill_color.value(),this.fill_alpha.value());return"rgba("+255*e[0]+","+255*e[1]+","+255*e[2]+","+e[3]+")"},t}(n);a.Fill=p,p.__name__="Fill",p.prototype.attrs=Object.keys(l.fill());var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.cache_select=function(t,a){var i;if("pattern"==t){this.cache_select("hatch_color",a),this.cache_select("hatch_scale",a),this.cache_select("hatch_pattern",a),this.cache_select("hatch_weight",a);var l=this.cache,c=l.hatch_color,o=l.hatch_scale,s=l.hatch_pattern,h=l.hatch_weight,n=l.hatch_extra;if(null!=n&&n.hasOwnProperty(s)){var _=n[s];this.cache.pattern=_.get_pattern(c,o,h)}else this.cache.pattern=function(e){var t=r(s,c,o,h);return e.createPattern(t,"repeat")}}else i=e.prototype.cache_select.call(this,t,a);return i},t.prototype._try_defer=function(e){var t=this.cache,a=t.hatch_pattern,i=t.hatch_extra;null!=i&&i.hasOwnProperty(a)&&i[a].onload(e)},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)},enumerable:!0,configurable:!0}),t.prototype.doit2=function(e,t,a,i){this.doit&&(this.cache_select("pattern",t),null==this.cache.pattern(e)?this._try_defer(i):(this.set_vectorize(e,t),a()))},t.prototype._set_vectorize=function(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e),this.cache_select("hatch_alpha",t),e.globalAlpha!==this.cache.hatch_alpha&&(e.globalAlpha=this.cache.hatch_alpha)},t.prototype.color_value=function(){var e=c.color2rgba(this.hatch_color.value(),this.hatch_alpha.value());return"rgba("+255*e[0]+","+255*e[1]+","+255*e[2]+","+e[3]+")"},t}(n);a.Hatch=u,u.__name__="Hatch",u.prototype.attrs=Object.keys(l.hatch());var f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.cache_select=function(t,a){var i;if("font"==t){e.prototype.cache_select.call(this,"text_font_style",a),e.prototype.cache_select.call(this,"text_font_size",a),e.prototype.cache_select.call(this,"text_font",a);var l=this.cache,c=l.text_font_style,o=l.text_font_size,s=l.text_font;this.cache.font=i=c+" "+o+" "+s}else i=e.prototype.cache_select.call(this,t,a);return i},t.prototype.font_value=function(){var e=this.text_font.value(),t=this.text_font_size.value();return this.text_font_style.value()+" "+t+" "+e},t.prototype.color_value=function(){var e=c.color2rgba(this.text_color.value(),this.text_alpha.value());return"rgba("+255*e[0]+","+255*e[1]+","+255*e[2]+","+e[3]+")"},t.prototype.set_value=function(e){e.font=this.font_value(),e.fillStyle=this.text_color.value(),e.globalAlpha=this.text_alpha.value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()},Object.defineProperty(t.prototype,"doit",{get:function(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)},enumerable:!0,configurable:!0}),t.prototype._set_vectorize=function(e,t){this.cache_select("font",t),e.font!==this.cache.font&&(e.font=this.cache.font),this.cache_select("text_color",t),e.fillStyle!==this.cache.text_color&&(e.fillStyle=this.cache.text_color),this.cache_select("text_alpha",t),e.globalAlpha!==this.cache.text_alpha&&(e.globalAlpha=this.cache.text_alpha),this.cache_select("text_align",t),e.textAlign!==this.cache.text_align&&(e.textAlign=this.cache.text_align),this.cache_select("text_baseline",t),e.textBaseline!==this.cache.text_baseline&&(e.textBaseline=this.cache.text_baseline)},t}(n);a.Text=f,f.__name__="Text",f.prototype.attrs=Object.keys(l.text());var v=function(){function e(e){for(var t=0,a=e.mixins;t<a.length;t++){var i=a[t].split(":"),l=i[0],c=i[1],o=void 0===c?"":c,s=void 0;switch(l){case"line":s=_;break;case"fill":s=p;break;case"hatch":s=u;break;case"text":s=f;break;default:throw new Error("unknown visual: "+l)}this[o+l]=new s(e,o)}}return e.prototype.warm_cache=function(e){for(var t in this)if(this.hasOwnProperty(t)){var a=this[t];a instanceof n&&a.warm_cache(e)}},e.prototype.set_all_indices=function(e){for(var t in this)if(this.hasOwnProperty(t)){var a=this[t];a instanceof n&&(a.all_indices=e)}},e}();a.Visuals=v,v.__name__="Visuals"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),s=t(121),c=r.__importStar(t(127)),i=t(116),o=t(131),a=t(178),l=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Model=function(){this.define({tags:[c.Array,[]],name:[c.String],js_property_callbacks:[c.Any,{}],js_event_callbacks:[c.Any,{}],subscribed_events:[c.Array,[]]})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(function(){return e._update_property_callbacks()})),this.connect(this.properties.js_event_callbacks.change,(function(){return e._update_event_callbacks()})),this.connect(this.properties.subscribed_events.change,(function(){return e._update_event_callbacks()}))},e.prototype._process_event=function(t){for(var e=0,n=this.js_event_callbacks[t.event_name]||[];e<n.length;e++){n[e].execute(t)}null!=this.document&&this.subscribed_events.some((function(e){return e==t.event_name}))&&this.document.event_manager.send_event(t)},e.prototype.trigger_event=function(t){null!=this.document&&(t.origin=this,this.document.event_manager.trigger(t))},e.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this.id):a.logger.warn("WARNING: Document not defined for updating event callbacks")},e.prototype._update_property_callbacks=function(){var t=this,e=function(e){var n=e.split(":"),r=n[0],s=n[1],c=void 0===s?null:s;return null!=c?t.properties[c][r]:t[r]};for(var n in this._js_callbacks)for(var r=this._js_callbacks[n],s=e(n),c=0,i=r;c<i.length;c++){var o=i[c];this.disconnect(s,o)}for(var n in this._js_callbacks={},this.js_property_callbacks){var a=(r=this.js_property_callbacks[n]).map((function(e){return function(){return e.execute(t)}}));this._js_callbacks[n]=a;s=e(n);for(var l=0,_=a;l<_.length;l++){o=_[l];this.connect(s,o)}}},e.prototype._doc_attached=function(){o.isEmpty(this.js_event_callbacks)&&o.isEmpty(this.subscribed_events)||this._update_event_callbacks()},e.prototype.select=function(t){if(i.isString(t))return this.references().filter((function(n){return n instanceof e&&n.name===t}));if(t.prototype instanceof s.HasProps)return this.references().filter((function(e){return e instanceof t}));throw new Error("invalid selector")},e.prototype.select_one=function(t){var e=this.select(t);switch(e.length){case 0:return null;case 1:return e[0];default:throw new Error("found more than one object matching given selector")}},e}(s.HasProps);n.Model=l,l.__name__="Model",l.init_Model()},
function _(e,l,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(116),t={},r=function(e,l){this.name=e,this.level=l};o.LogLevel=r,r.__name__="LogLevel";var g=function(){function e(l,o){void 0===o&&(o=e.INFO),this._name=l,this.set_level(o)}return Object.defineProperty(e,"levels",{get:function(){return Object.keys(e.log_levels)},enumerable:!0,configurable:!0}),e.get=function(l,o){if(void 0===o&&(o=e.INFO),l.length>0){var n=t[l];return null==n&&(t[l]=n=new e(l,o)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(e.prototype,"level",{get:function(){return this.get_level()},enumerable:!0,configurable:!0}),e.prototype.get_level=function(){return this._log_level},e.prototype.set_level=function(l){if(l instanceof r)this._log_level=l;else{if(!n.isString(l)||null==e.log_levels[l])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=e.log_levels[l]}var o="["+this._name+"]";for(var t in e.log_levels){e.log_levels[t].level<this._log_level.level||this._log_level.level===e.OFF.level?this[t]=function(){}:this[t]=i(t,o)}},e.prototype.trace=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.debug=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.info=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.warn=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.error=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e}();function i(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function v(e){var l=o.logger.level;return n.isString(e)&&null==g.log_levels[e]?(console.log("[bokeh] unrecognized logging level '"+e+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+g.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+(n.isString(e)?e:e.level)+"'"),o.logger.set_level(e)),l}o.Logger=g,g.__name__="Logger",g.TRACE=new r("trace",0),g.DEBUG=new r("debug",1),g.INFO=new r("info",2),g.WARN=new r("warn",6),g.ERROR=new r("error",7),g.FATAL=new r("fatal",8),g.OFF=new r("off",9),g.log_levels={trace:g.TRACE,debug:g.DEBUG,info:g.INFO,warn:g.WARN,error:g.ERROR,fatal:g.FATAL,off:g.OFF},o.logger=g.get("bokeh"),o.set_log_level=v,o.with_log_level=function(e,l){var o=v(e);try{l()}finally{v(o)}}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(137),s=t(180),a=t(181),o=n.__importStar(t(127)),_=t(118),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.model.source&&(this.model.source=new a.ColumnDataSource),this.set_data(this.model.source)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.streaming,(function(){return e.set_data(e.model.source)})),this.connect(this.model.source.patching,(function(){return e.set_data(e.model.source)}))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e),this.plot_view.request_render()},e.prototype._map_data=function(){var t,e,i,n,r=this.plot_view.frame;return"data"==this.model.start_units?(t=r.xscales[this.model.x_range_name].v_compute(this._x_start),e=r.yscales[this.model.y_range_name].v_compute(this._y_start)):(t=r.xview.v_compute(this._x_start),e=r.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=r.xscales[this.model.x_range_name].v_compute(this._x_end),n=r.yscales[this.model.y_range_name].v_compute(this._y_end)):(i=r.xview.v_compute(this._x_end),n=r.yview.v_compute(this._y_end)),[[t,e],[i,n]]},e.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save();var e=this._map_data(),i=e[0],n=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,n,i),t.beginPath();var r=this.plot_view.frame.bbox,s=r.x,a=r.y,o=r.width,_=r.height;t.rect(s,a,o,_),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,n,i),t.closePath(),t.clip(),this._arrow_body(t,i,n),t.restore()}},e.prototype._arrow_head=function(t,e,i,n,r){for(var s=0,a=this._x_start.length;s<a;s++){var o=Math.PI/2+_.atan2([n[0][s],n[1][s]],[r[0][s],r[1][s]]);t.save(),t.translate(r[0][s],r[1][s]),t.rotate(o),"render"==e?i.render(t,s):"clip"==e&&i.clip(t,s),t.restore()}},e.prototype._arrow_body=function(t,e,i){if(this.visuals.line.doit)for(var n=0,r=this._x_start.length;n<r;n++)this.visuals.line.set_vectorize(t,n),t.beginPath(),t.moveTo(e[0][n],e[1][n]),t.lineTo(i[0][n],i[1][n]),t.stroke()},e}(r.AnnotationView);i.ArrowView=l,l.__name__="ArrowView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Arrow=function(){this.prototype.default_view=l,this.mixins(["line"]),this.define({x_start:[o.NumberSpec],y_start:[o.NumberSpec],start_units:[o.SpatialUnits,"data"],start:[o.Instance,null],x_end:[o.NumberSpec],y_end:[o.NumberSpec],end_units:[o.SpatialUnits,"data"],end:[o.Instance,function(){return new s.OpenHead({})}],source:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]})},e}(r.Annotation);i.Arrow=h,h.__name__="Arrow",h.init_Arrow()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var s=i(1),n=i(137),o=i(176),l=s.__importStar(i(127)),h=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_ArrowHead=function(){this.define({size:[l.Number,25]})},e.prototype.initialize=function(){i.prototype.initialize.call(this),this.visuals=new o.Visuals(this)},e}(n.Annotation);t.ArrowHead=h,h.__name__="ArrowHead",h.init_ArrowHead();var r=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_OpenHead=function(){this.mixins(["line"])},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())},e}(h);t.OpenHead=r,r.__name__="OpenHead",r.init_OpenHead();var a=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_NormalHead=function(){this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())},e.prototype._normal=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()},e}(h);t.NormalHead=a,a.__name__="NormalHead",a.init_NormalHead();var _=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_VeeHead=function(){this.mixins(["line","fill"]),this.override({fill_color:"black"})},e.prototype.clip=function(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)},e.prototype.render=function(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())},e.prototype._vee=function(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()},e}(h);t.VeeHead=_,_.__name__="VeeHead",_.init_VeeHead();var u=function(i){function e(e){return i.call(this,e)||this}return s.__extends(e,i),e.init_TeeHead=function(){this.mixins(["line"])},e.prototype.render=function(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())},e.prototype.clip=function(i,e){},e}(h);t.TeeHead=u,u.__name__="TeeHead",u.init_TeeHead()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var a=t(1),r=t(182),i=t(121),o=a.__importStar(t(127)),s=t(123),u=t(208),l=t(116),c=a.__importStar(t(210)),h=t(131),_=t(211);function d(t,n,e){if(l.isArray(t)){var a=t.concat(n);return null!=e&&a.length>e?a.slice(-e):a}if(l.isTypedArray(t)){var r=t.length+n.length;if(null!=e&&r>e){var i=r-e,o=t.length;a=void 0;t.length<e?(a=new t.constructor(e)).set(t,0):a=t;for(var s=i,u=o;s<u;s++)a[s-i]=a[s];for(s=0,u=n.length;s<u;s++)a[s+(o-i)]=n[s];return a}var h=new t.constructor(n);return c.concat(t,h)}throw new Error("unsupported array types")}function v(t,n){var e,a,r;return l.isNumber(t)?(e=t,r=t+1,a=1):(e=null!=t.start?t.start:0,r=null!=t.stop?t.stop:n,a=null!=t.step?t.step:1),[e,r,a]}function f(t,n,e){for(var a=new s.Set,r=!1,i=0,o=n;i<o.length;i++){var u=o[i],c=u[0],h=u[1],_=void 0,d=void 0,f=void 0,m=void 0;if(l.isArray(c)){var p=c[0];a.add(p),d=e[p],_=t[p],m=h,2===c.length?(d=[1,d[0]],f=[c[0],0,c[1]]):f=c}else l.isNumber(c)?(m=[h],a.add(c)):(m=h,r=!0),f=[0,0,c],d=[1,t.length],_=t;var y=0,g=v(f[1],d[0]),S=g[0],b=g[1],w=g[2],C=v(f[2],d[1]),j=C[0],D=C[1],A=C[2];for(p=S;p<b;p+=w)for(var P=j;P<D;P+=A)r&&a.add(P),_[p*d[1]+P]=m[y],y++}return a}e.stream_to_column=d,e.slice=v,e.patch_to_column=f;var m=function(t){function n(n){return t.call(this,n)||this}return a.__extends(n,t),n.init_ColumnDataSource=function(){this.define({data:[o.Any,{}]})},n.prototype.initialize=function(){var n;t.prototype.initialize.call(this),n=u.decode_column_data(this.data),this.data=n[0],this._shapes=n[1]},n.prototype.attributes_as_json=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=n._value_to_json);for(var a={},r=this.serializable_attributes(),i=0,o=h.keys(r);i<o.length;i++){var s=o[i],l=r[s];"data"===s&&(l=u.encode_column_data(l,this._shapes)),(t||s in this._set_after_defaults)&&(a[s]=l)}return e("attributes",a,this)},n._value_to_json=function(t,n,e){return l.isPlainObject(n)&&"data"===t?u.encode_column_data(n,e._shapes):i.HasProps._value_to_json(t,n,e)},n.prototype.stream=function(t,n,e){var a=this.data;for(var r in t)a[r]=d(a[r],t[r],n);if(this.setv({data:a},{silent:!0}),this.streaming.emit(),null!=this.document){var i=new _.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:i})}},n.prototype.patch=function(t,n){var e=this.data,a=new s.Set;for(var r in t){var i=t[r];a=a.union(f(e[r],i,this._shapes[r]))}if(this.setv({data:e},{silent:!0}),this.patching.emit(a.values),null!=this.document){var o=new _.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:o})}},n}(r.ColumnarDataSource);e.ColumnDataSource=m,m.__name__="ColumnDataSource",m.init_ColumnDataSource()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),i=t(183),a=t(122),o=t(178),s=t(185),u=r.__importStar(t(127)),c=t(116),l=t(117),h=t(131),p=t(184),g=t(207),f=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.prototype.get_array=function(t){var n=this.data[t];return null==n?this.data[t]=n=[]:c.isArray(n)||(this.data[t]=n=Array.from(n)),n},n.init_ColumnarDataSource=function(){this.define({selection_policy:[u.Instance,function(){return new g.UnionRenderers}]}),this.internal({selection_manager:[u.Instance,function(t){return new s.SelectionManager({source:t})}],inspected:[u.Instance,function(){return new p.Selection}],_shapes:[u.Any,{}]})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new a.Signal0(this,"select"),this.inspect=new a.Signal(this,"inspect"),this.streaming=new a.Signal0(this,"streaming"),this.patching=new a.Signal(this,"patching")},n.prototype.get_column=function(t){var n=this.data[t];return null!=n?n:null},n.prototype.columns=function(){return h.keys(this.data)},n.prototype.get_length=function(t){void 0===t&&(t=!0);var n=l.uniq(h.values(this.data).map((function(t){return t.length})));switch(n.length){case 0:return null;case 1:return n[0];default:var e="data source has columns of inconsistent lengths";if(t)return o.logger.warn(e),n.sort()[0];throw new Error(e)}},n.prototype.get_indices=function(){var t=this.get_length();return l.range(0,null!=t?t:1)},n.prototype.clear=function(){for(var t={},n=0,e=this.columns();n<e.length;n++){var r=e[n];t[r]=new this.data[r].constructor(0)}this.data=t},n}(i.DataSource);e.ColumnarDataSource=f,f.__name__="ColumnarDataSource",f.init_ColumnarDataSource()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(177),a=e(184),c=i.__importStar(e(127)),o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_DataSource=function(){this.define({selected:[c.Instance,function(){return new a.Selection}]})},t}(r.Model);n.DataSource=o,o.__name__="DataSource",o.init_DataSource()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=i(1),s=i(177),l=n.__importStar(i(127)),c=i(117),_=i(131),h=function(i){function e(e){return i.call(this,e)||this}return n.__extends(e,i),e.init_Selection=function(){this.define({indices:[l.Array,[]],line_indices:[l.Array,[]],multiline_indices:[l.Any,{}]}),this.internal({final:[l.Boolean],selected_glyphs:[l.Array,[]],get_view:[l.Any],image_indices:[l.Array,[]]})},e.prototype.initialize=function(){i.prototype.initialize.call(this),this.get_view=function(){return null}},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!0,configurable:!0}),e.prototype.add_to_selected_glyphs=function(i){this.selected_glyphs.push(i)},e.prototype.update=function(i,e,t){this.final=e,t?this.update_through_union(i):(this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.get_view=i.get_view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices)},e.prototype.clear=function(){this.final=!0,this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=function(){return null},this.selected_glyphs=[]},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(i){this.indices=c.union(i.indices,this.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=_.merge(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(i){this.indices=c.intersection(i.indices,this.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=_.merge(i.multiline_indices,this.multiline_indices)},e}(s.Model);t.Selection=h,h.__name__="Selection",h.init_Selection()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),o=e(121),r=e(184),s=e(186),c=e(205),l=n.__importStar(e(127)),p=function(e){function t(t){var i=e.call(this,t)||this;return i.inspectors={},i}return n.__extends(t,e),t.init_SelectionManager=function(){this.internal({source:[l.Any]})},t.prototype.select=function(e,t,i,n){void 0===n&&(n=!1);for(var o=[],r=[],l=0,p=e;l<p.length;l++){(h=p[l])instanceof s.GlyphRendererView?o.push(h):h instanceof c.GraphRendererView&&r.push(h)}for(var _=!1,a=0,u=r;a<u.length;a++){var h,d=(h=u[a]).model.selection_policy.hit_test(t,h);_=_||h.model.selection_policy.do_selection(d,h.model,i,n)}if(o.length>0){d=this.source.selection_policy.hit_test(t,o);_=_||this.source.selection_policy.do_selection(d,this.source,i,n)}return _},t.prototype.inspect=function(e,t){var i=!1;if(e instanceof s.GlyphRendererView){if(null!=(o=e.hit_test(t))){i=!o.is_empty();var n=this.get_or_create_inspector(e.model);n.update(o,!0,!1),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e,{geometry:t}])}}else if(e instanceof c.GraphRendererView){var o=e.model.inspection_policy.hit_test(t,e);i=i||e.model.inspection_policy.do_inspection(o,t,e,!1,!1)}return i},t.prototype.clear=function(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()},t.prototype.get_or_create_inspector=function(e){return null==this.inspectors[e.id]&&(this.inspectors[e.id]=new r.Selection),this.inspectors[e.id]},t}(o.HasProps);i.SelectionManager=p,p.__name__="SelectionManager",p.init_SelectionManager()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),s=e(187),l=e(188),h=e(199),r=e(200),o=e(202),a=e(203),c=e(178),_=n.__importStar(e(127)),d=e(120),u=e(117),p=e(131),g=e(204),y=e(196),m={fill:{},line:{}},v={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},f={fill:{fill_alpha:.2},line:{}},w=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){function t(e){var t=p.clone(h);return s&&p.extend(t,e.fill),l&&p.extend(t,e.line),new i.constructor(t)}var i,s,l,h,r,o,a,c,_,d,g,y,w,b,x;return n.__generator(this,(function(n){switch(n.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return n.sent(),i=this.model.glyph,s=u.includes(i.mixins,"fill"),l=u.includes(i.mixins,"line"),delete(h=p.clone(i.attributes)).id,r=this,[4,this.build_glyph_view(i)];case 2:return r.glyph=n.sent(),null==(o=this.model.selection_glyph)?o=t({fill:{},line:{}}):"auto"===o&&(o=t(m)),a=this,[4,this.build_glyph_view(o)];case 3:return a.selection_glyph=n.sent(),null==(c=this.model.nonselection_glyph)?c=t({fill:{},line:{}}):"auto"===c&&(c=t(f)),_=this,[4,this.build_glyph_view(c)];case 4:return _.nonselection_glyph=n.sent(),null==(d=this.model.hover_glyph)?[3,6]:(g=this,[4,this.build_glyph_view(d)]);case 5:g.hover_glyph=n.sent(),n.label=6;case 6:return null==(y=this.model.muted_glyph)?[3,8]:(w=this,[4,this.build_glyph_view(y)]);case 7:w.muted_glyph=n.sent(),n.label=8;case 8:return b=t(v),x=this,[4,this.build_glyph_view(b)];case 9:return x.decimated_glyph=n.sent(),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1),[2]}}))}))},t.prototype.build_glyph_view=function(e){return n.__awaiter(this,void 0,void 0,(function(){return n.__generator(this,(function(t){return[2,g.build_view(e,{parent:this})]}))}))},t.prototype.remove=function(){var t,i;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(t=this.hover_glyph)||void 0===t||t.remove(),null===(i=this.muted_glyph)||void 0===i||i.remove(),this.decimated_glyph.remove(),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.glyph.change,(function(){return t.set_data()})),this.connect(this.model.data_source.change,(function(){return t.set_data()})),this.connect(this.model.data_source.streaming,(function(){return t.set_data()})),this.connect(this.model.data_source.patching,(function(e){return t.set_data(!0,e)})),this.connect(this.model.data_source.selected.change,(function(){return t.request_render()})),this.connect(this.model.data_source._select,(function(){return t.request_render()})),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(function(){return t.request_render()})),this.connect(this.model.properties.view.change,(function(){return t.set_data()})),this.connect(this.model.view.change,(function(){return t.set_data()})),this.connect(this.model.properties.visible.change,(function(){return t.plot_view.update_dataranges()}));var i=this.plot_view.frame,n=i.x_ranges,s=i.y_ranges;for(var l in n){(h=n[l])instanceof y.FactorRange&&this.connect(h.change,(function(){return t.set_data()}))}for(var l in s){var h;(h=s[l])instanceof y.FactorRange&&this.connect(h.change,(function(){return t.set_data()}))}this.connect(this.model.glyph.transformchange,(function(){return t.set_data()}))},t.prototype.have_selection_glyphs=function(){return null!=this.selection_glyph&&null!=this.nonselection_glyph},t.prototype.set_data=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=null);var i=Date.now(),n=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(n,this.all_indices,t),this.glyph.set_visuals(n),this.decimated_glyph.set_visuals(n),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(n),this.nonselection_glyph.set_visuals(n)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(n),null!=this.muted_glyph&&this.muted_glyph.set_visuals(n);var s=this.plot_model.lod_factor;this.decimated=[];for(var l=0,h=Math.floor(this.all_indices.length/s);l<h;l++)this.decimated.push(l*s);var r=Date.now()-i;c.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): set_data finished in "+r+"ms"),this.set_data_timestamp=Date.now(),e&&this.request_render()},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return this.glyph.has_webgl},enumerable:!0,configurable:!0}),t.prototype.render=function(){var e=this;if(this.model.visible){var t=Date.now(),i=this.has_webgl;this.glyph.map_data();var n=Date.now()-t,s=Date.now(),a=this.glyph.mask_data(this.all_indices);a.length===this.all_indices.length&&(a=u.range(0,this.all_indices.length));var _=Date.now()-s,p=this.plot_view.canvas_view.ctx;p.save();var g,y=this.model.data_source.selected;g=!y||y.is_empty()?[]:this.glyph instanceof l.LineView&&y.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(a):y.indices;var m,v,f,w=this.model.data_source.inspected,b=new Set(!w||w.is_empty()?[]:w.selected_glyph?e.model.view.convert_indices_from_subset(a):w.indices.length>0?w.indices:d.map(Object.keys(w.multiline_indices),(function(e){return parseInt(e)}))),x=d.filter(a,(function(t){return b.has(e.all_indices[t])})),D=this.plot_model.lod_threshold;null!=this.model.document&&this.model.document.interactive_duration()>0&&!i&&null!=D&&this.all_indices.length>D?(a=this.decimated,m=this.decimated_glyph,v=this.decimated_glyph,f=this.selection_glyph):(m=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,v=this.nonselection_glyph,f=this.selection_glyph),null!=this.hover_glyph&&x.length&&(a=u.difference(a,x));var R,V=null;if(g.length&&this.have_selection_glyphs()){for(var G=Date.now(),z={},A=0,I=g;A<I.length;A++){z[S=I[A]]=!0}var q=new Array,k=new Array;if(this.glyph instanceof l.LineView)for(var L=0,O=this.all_indices;L<O.length;L++){null!=z[S=O[L]]?q.push(S):k.push(S)}else for(var j=0,P=a;j<P.length;j++){var S=P[j];null!=z[this.all_indices[S]]?q.push(S):k.push(S)}V=Date.now()-G,R=Date.now(),v.render(p,k,this.glyph),f.render(p,q,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof l.LineView?this.hover_glyph.render(p,this.model.view.convert_indices_from_subset(x),this.glyph):this.hover_glyph.render(p,x,this.glyph))}else if(R=Date.now(),this.glyph instanceof l.LineView)this.hover_glyph&&x.length?this.hover_glyph.render(p,this.model.view.convert_indices_from_subset(x),this.glyph):m.render(p,this.all_indices,this.glyph);else if(this.glyph instanceof h.PatchView||this.glyph instanceof r.HAreaView||this.glyph instanceof o.VAreaView)if(0==w.selected_glyphs.length||null==this.hover_glyph)m.render(p,this.all_indices,this.glyph);else for(var F=0,M=w.selected_glyphs;F<M.length;F++){M[F].id==this.glyph.model.id&&this.hover_glyph.render(p,this.all_indices,this.glyph)}else m.render(p,a,this.glyph),this.hover_glyph&&x.length&&this.hover_glyph.render(p,x,this.glyph);var B=Date.now()-R;this.last_dtrender=B;var C=Date.now()-t;c.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): render finished in "+C+"ms"),c.logger.trace(" - map_data finished in       : "+n+"ms"),c.logger.trace(" - mask_data finished in      : "+_+"ms"),null!=V&&c.logger.trace(" - selection mask finished in : "+V+"ms"),c.logger.trace(" - glyph renders finished in  : "+B+"ms"),p.restore()}},t.prototype.draw_legend=function(e,t,i,n,s,l,h,r){null==r&&(r=this.model.get_reference_point(l,h)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:n,y1:s},r)},t.prototype.hit_test=function(e){if(!this.model.visible)return null;var t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)},t}(s.DataRendererView);i.GlyphRendererView=w,w.__name__="GlyphRendererView";var b=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_GlyphRenderer=function(){this.prototype.default_view=w,this.define({data_source:[_.Instance],view:[_.Instance,function(){return new a.CDSView}],glyph:[_.Instance],hover_glyph:[_.Instance],nonselection_glyph:[_.Any,"auto"],selection_glyph:[_.Any,"auto"],muted_glyph:[_.Instance],muted:[_.Boolean,!1]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(e,t){var i=0;if(null!=e){var n=this.data_source.get_column(e);if(null!=n){var s=d.indexOf(n,t);-1!=s&&(i=s)}}return i},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(s.DataRenderer);i.GlyphRenderer=b,b.__name__="GlyphRenderer",b.init_GlyphRenderer()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),a=e(171),i=t.__importStar(e(127)),_=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return t.__extends(n,e),n}(a.RendererView);r.DataRendererView=_,_.__name__="DataRendererView";var d=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DataRenderer=function(){this.define({x_range_name:[i.String,"default"],y_range_name:[i.String,"default"]}),this.override({level:"glyph"})},n}(a.Renderer);r.DataRenderer=d,d.__name__="DataRenderer",d.init_DataRenderer()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(189),r=t(198),_=n.__importStar(t(195)),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n=i.sx,s=i.sy,r=!1,_=null;this.visuals.line.set_value(t);for(var o=0,l=e;o<l.length;o++){var h=l[o];if(r){if(!isFinite(n[h]+s[h])){t.stroke(),t.beginPath(),r=!1,_=h;continue}null!=_&&h-_>1&&(t.stroke(),r=!1)}r?t.lineTo(n[h],s[h]):(t.beginPath(),t.moveTo(n[h],s[h]),r=!0),_=h}r&&t.stroke()},e.prototype._hit_point=function(t){for(var e=this,i=_.create_empty_hit_test_result(),n={x:t.sx,y:t.sy},s=9999,r=Math.max(2,this.visuals.line.line_width.value()/2),o=0,l=this.sx.length-1;o<l;o++){var h={x:this.sx[o],y:this.sy[o]},u={x:this.sx[o+1],y:this.sy[o+1]},a=_.dist_to_segment(n,h,u);a<r&&a<s&&(s=a,i.add_to_selected_glyphs(this.model),i.get_view=function(){return e},i.line_indices=[o])}return i},e.prototype._hit_span=function(t){var e,i,n=this,s=t.sx,r=t.sy,o=_.create_empty_hit_test_result();"v"==t.direction?(e=this.renderer.yscale.invert(r),i=this._y):(e=this.renderer.xscale.invert(s),i=this._x);for(var l=0,h=i.length-1;l<h;l++)(i[l]<=e&&e<=i[l+1]||i[l+1]<=e&&e<=i[l])&&(o.add_to_selected_glyphs(this.model),o.get_view=function(){return n},o.line_indices.push(l));return o},e.prototype.get_interpolation_hit=function(t,e){var i=[this._x[t],this._y[t],this._x[t+1],this._y[t+1]],n=i[0],s=i[1],_=i[2],o=i[3];return r.line_interpolation(this.renderer,e,n,s,_,o)},e.prototype.draw_legend_for_index=function(t,e,i){r.generic_line_legend(this.visuals,t,e,i)},e}(s.XYGlyphView);i.LineView=o,o.__name__="LineView";var l=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Line=function(){this.prototype.default_view=o,this.mixins(["line"])},e}(s.XYGlyph);i.Line=l,l.__name__="Line",l.init_Line()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),r=t(190),_=t(194),s=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype._index_data=function(){for(var t=[],n=0,e=this._x.length;n<e;n++){var i=this._x[n],_=this._y[n];!isNaN(i+_)&&isFinite(i+_)&&t.push({x0:i,y0:_,x1:i,y1:_,i:n})}return new r.SpatialIndex(t)},n.prototype.scenterx=function(t){return this.sx[t]},n.prototype.scentery=function(t){return this.sy[t]},n}(_.GlyphView);e.XYGlyphView=s,s.__name__="XYGlyphView";var h=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_XYGlyph=function(){this.coords([["x","y"]])},n}(_.Glyph);e.XYGlyph=h,h.__name__="XYGlyph",h.init_XYGlyph()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});var i=n(1).__importDefault(n(191)),r=n(193),o=function(){function n(n){if(this.points=n,this.index=null,n.length>0){this.index=new i.default(n.length);for(var t=0,e=n;t<e.length;t++){var r=e[t],o=r.x0,a=r.y0,u=r.x1,x=r.y1;this.index.add(o,a,u,x)}this.index.finish()}}return n.prototype._normalize=function(n){var t,e,i=n.x0,r=n.y0,o=n.x1,a=n.y1;return i>o&&(i=(t=[o,i])[0],o=t[1]),r>a&&(r=(e=[a,r])[0],a=e[1]),{x0:i,y0:r,x1:o,y1:a}},Object.defineProperty(n.prototype,"bbox",{get:function(){if(null==this.index)return r.empty();var n=this.index;return{x0:n.minX,y0:n.minY,x1:n.maxX,y1:n.maxY}},enumerable:!0,configurable:!0}),n.prototype.search=function(n){var t=this;if(null==this.index)return[];var e=this._normalize(n),i=e.x0,r=e.y0,o=e.x1,a=e.y1;return this.index.search(i,r,o,a).map((function(n){return t.points[n]}))},n.prototype.indices=function(n){return this.search(n).map((function(n){return n.i}))},n}();e.SpatialIndex=o,o.__name__="SpatialIndex"},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});var e=t(1).__importDefault(t(192)),r=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],h=function(){function t(t,i,s,h){if(void 0===i&&(i=16),void 0===s&&(s=Float64Array),void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535);var n=t,o=n;this._levelBounds=[4*n];do{o+=n=Math.ceil(n/this.nodeSize),this._levelBounds.push(4*o)}while(1!==n);this.ArrayType=s||Float64Array,this.IndexArrayType=o<16384?Uint16Array:Uint32Array;var a=r.indexOf(this.ArrayType),_=4*o*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+s+".");h&&h instanceof ArrayBuffer?(this.data=h,this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+_,o),this._pos=4*o,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+o*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+_,o),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new e.default}return t.from=function(i){if(!(i instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var s=new Uint8Array(i,0,2),e=s[0],h=s[1];if(251!==e)throw new Error("Data does not appear to be in a Flatbush format.");if(h>>4!=3)throw new Error("Got v"+(h>>4)+" data when expected v3.");var n=new Uint16Array(i,2,1)[0];return new t(new Uint32Array(i,4,1)[0],n,r[15&h],i)},t.prototype.add=function(t,i,s,e){var r=this._pos>>2;return this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=i,this._boxes[this._pos++]=s,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),r},t.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");for(var t=this.maxX-this.minX,i=this.maxY-this.minY,s=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var r=4*e,h=this._boxes[r++],n=this._boxes[r++],o=this._boxes[r++],d=this._boxes[r++],u=Math.floor(65535*((h+o)/2-this.minX)/t),p=Math.floor(65535*((n+d)/2-this.minY)/i);s[e]=_(u,p)}!function t(i,s,e,r,h){if(r>=h)return;var n=i[r+h>>1],o=r-1,_=h+1;for(;;){do{o++}while(i[o]<n);do{_--}while(i[_]>n);if(o>=_)break;a(i,s,e,o,_)}t(i,s,e,r,_),t(i,s,e,_+1,h)}(s,this._boxes,this._indices,0,this.numItems-1);for(e=0,r=0;e<this._levelBounds.length-1;e++)for(var f=this._levelBounds[e];r<f;){for(var x=1/0,m=1/0,y=-1/0,l=-1/0,v=r,b=0;b<this.nodeSize&&r<f;b++){(h=this._boxes[r++])<x&&(x=h),(n=this._boxes[r++])<m&&(m=n),(o=this._boxes[r++])>y&&(y=o),(d=this._boxes[r++])>l&&(l=d)}this._indices[this._pos>>2]=v,this._boxes[this._pos++]=x,this._boxes[this._pos++]=m,this._boxes[this._pos++]=y,this._boxes[this._pos++]=l}},t.prototype.search=function(t,i,s,e,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,n=this._levelBounds.length-1,o=[],a=[];void 0!==h;){for(var _=Math.min(h+4*this.nodeSize,this._levelBounds[n]),d=h;d<_;d+=4){var u=0|this._indices[d>>2];s<this._boxes[d]||(e<this._boxes[d+1]||t>this._boxes[d+2]||i>this._boxes[d+3]||(h<4*this.numItems?(void 0===r||r(u))&&a.push(u):(o.push(u),o.push(n-1))))}n=o.pop(),h=o.pop()}return a},t.prototype.neighbors=function(t,i,s,e,r){if(void 0===s&&(s=1/0),void 0===e&&(e=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,a=this._queue,_=[],d=e*e;void 0!==h;){for(var u=Math.min(h+4*this.nodeSize,o(h,this._levelBounds)),p=h;p<u;p+=4){var f=0|this._indices[p>>2],x=n(t,this._boxes[p],this._boxes[p+2]),m=n(i,this._boxes[p+1],this._boxes[p+3]),y=x*x+m*m;h<4*this.numItems?(void 0===r||r(f))&&a.push(-f-1,y):a.push(f,y)}for(;a.length&&a.peek()<0;){if((y=a.peekValue())>d)return a.clear(),_;if(_.push(-a.pop()-1),_.length===s)return a.clear(),_}h=a.pop()}return a.clear(),_},t}();function n(t,i,s){return t<i?i-t:t<=s?0:t-s}function o(t,i){for(var s=0,e=i.length-1;s<e;){var r=s+e>>1;i[r]>t?e=r:s=r+1}return i[s]}function a(t,i,s,e,r){var h=t[e];t[e]=t[r],t[r]=h;var n=4*e,o=4*r,a=i[n],_=i[n+1],d=i[n+2],u=i[n+3];i[n]=i[o],i[n+1]=i[o+1],i[n+2]=i[o+2],i[n+3]=i[o+3],i[o]=a,i[o+1]=_,i[o+2]=d,i[o+3]=u;var p=s[e];s[e]=s[r],s[r]=p}function _(t,i){var s=t^i,e=65535^s,r=65535^(t|i),h=t&(65535^i),n=s|e>>1,o=s>>1^s,a=r>>1^e&h>>1^r,_=s&r>>1^h>>1^h;o=(s=n)&(e=o)>>2^e&(s^e)>>2,a^=s&(r=a)>>2^e&(h=_)>>2,_^=e&r>>2^(s^e)&h>>2,o=(s=n=s&s>>2^e&e>>2)&(e=o)>>4^e&(s^e)>>4,a^=s&(r=a)>>4^e&(h=_)>>4,_^=e&r>>4^(s^e)&h>>4,a^=(s=n=s&s>>4^e&e>>4)&(r=a)>>8^(e=o)&(h=_)>>8;var d=t^i,u=(e=(_^=e&r>>8^(s^e)&h>>8)^_>>1)|65535^(d|(s=a^a>>1));return((u=1431655765&((u=858993459&((u=252645135&((u=16711935&(u|u<<8))|u<<4))|u<<2))|u<<1))<<1|(d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1)))>>>0}s.default=h},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});var e=function(){function t(){this.ids=[],this.values=[],this.length=0}return t.prototype.clear=function(){this.length=0},t.prototype.push=function(t,s){var i=this.length++;for(this.ids[i]=t,this.values[i]=s;i>0;){var e=i-1>>1,h=this.values[e];if(s>=h)break;this.ids[i]=this.ids[e],this.values[i]=h,i=e}this.ids[i]=t,this.values[i]=s},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var s=this.ids[0]=this.ids[this.length],i=this.values[0]=this.values[this.length],e=this.length>>1,h=0;h<e;){var n=1+(h<<1),u=n+1,l=this.ids[n],r=this.values[n],a=this.values[u];if(u<this.length&&a<r&&(n=u,l=this.ids[u],r=a),r>=i)break;this.ids[h]=l,this.values[h]=r,h=n}this.ids[h]=s,this.values[h]=i}return t}},t.prototype.peek=function(){return this.ids[0]},t.prototype.peekValue=function(){return this.values[0]},t}();i.default=e},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=Math.min,n=Math.max;r.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},r.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},r.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},r.union=function(t,e){return{x0:i(t.x0,e.x0),x1:n(t.x1,e.x1),y0:i(t.y0,e.y0),y1:n(t.y1,e.y1)}};var o=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t.x0,r=t.y0,i=t.x1,n=t.y1;if(!(e<=i&&r<=n))throw new Error("invalid bbox {x0: "+e+", y0: "+r+", x1: "+i+", y1: "+n+"}");this.x0=e,this.y0=r,this.x1=i,this.y1=n}else if("x"in t){var o=t.x,h=t.y,u=t.width,y=t.height;if(!(u>=0&&y>=0))throw new Error("invalid bbox {x: "+o+", y: "+h+", width: "+u+", height: "+y+"}");this.x0=o,this.y0=h,this.x1=o+u,this.y1=h+y}else{var f=void 0,s=void 0,c=void 0,p=void 0;if("width"in t)if("left"in t)s=(f=t.left)+t.width;else if("right"in t)f=(s=t.right)-t.width;else{var b=t.width/2;f=t.hcenter-b,s=t.hcenter+b}else f=t.left,s=t.right;if("height"in t)if("top"in t)p=(c=t.top)+t.height;else if("bottom"in t)c=(p=t.bottom)-t.height;else{var l=t.height/2;c=t.vcenter-l,p=t.vcenter+l}else c=t.top,p=t.bottom;if(!(f<=s&&c<=p))throw new Error("invalid bbox {left: "+f+", top: "+c+", right: "+s+", bottom: "+p+"}");this.x0=f,this.y0=c,this.x1=s,this.y1=p}}return t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!0,configurable:!0}),t.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.union=function(e){return new t({x0:i(this.x0,e.x0),y0:i(this.y0,e.y0),x1:n(this.x1,e.x1),y1:n(this.y1,e.y1)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var r=new Float64Array(e.length),i=t.left,n=0;n<e.length;n++)r[n]=i+e[n];return r}}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var r=new Float64Array(e.length),i=t.bottom,n=0;n<e.length;n++)r[n]=i-e[n];return r}}},enumerable:!0,configurable:!0}),t}();r.BBox=o,o.__name__="BBox"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=n.__importStar(t(195)),s=n.__importStar(t(127)),a=n.__importStar(t(193)),o=n.__importStar(t(138)),_=n.__importStar(t(176)),h=t(173),l=t(177),p=t(178),u=t(120),c=t(131),y=t(116),d=t(188),f=t(196),g=function(e){function i(){var t=e.apply(this,arguments)||this;return t._nohit_warned=new Set,t}return n.__extends(i,e),Object.defineProperty(i.prototype,"renderer",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"has_webgl",{get:function(){return null!=this.glglyph},enumerable:!0,configurable:!0}),i.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new _.Visuals(this.model)},i.prototype.lazy_initialize=function(){return n.__awaiter(this,void 0,void 0,(function(){var i,r,s,a;return n.__generator(this,(function(o){switch(o.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:if(o.sent(),null==(i=this.renderer.plot_view.canvas_view.webgl))return[3,6];r=null,o.label=2;case 2:return o.trys.push([2,4,,5]),[4,Promise.resolve().then((function(){return n.__importStar(t(466))}))];case 3:return r=o.sent(),[3,5];case 4:if("MODULE_NOT_FOUND"!==(s=o.sent()).code)throw s;return p.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering."),[3,5];case 5:null!=r&&null!=(a=r[this.model.type+"GLGlyph"])&&(this.glglyph=new a(i.gl,this)),o.label=6;case 6:return[2]}}))}))},i.prototype.set_visuals=function(t){this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()},i.prototype.render=function(t,e,i){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,i)||this._render(t,e,i)},i.prototype.has_finished=function(){return!0},i.prototype.notify_finished=function(){this.renderer.notify_finished()},i.prototype._bounds=function(t){return t},i.prototype.bounds=function(){return this._bounds(this.index.bbox)},i.prototype.log_bounds=function(){for(var t=a.empty(),e=0,i=this.index.search(a.positive_x());e<i.length;e++){var n=i[e];n.x0<t.x0&&(t.x0=n.x0),n.x1>t.x1&&(t.x1=n.x1)}for(var r=0,s=this.index.search(a.positive_y());r<s.length;r++){var o=s[r];o.y0<t.y0&&(t.y0=o.y0),o.y1>t.y1&&(t.y1=o.y1)}return this._bounds(t)},i.prototype.get_anchor_point=function(t,e,i){var n=i[0],r=i[1];switch(t){case"center":return{x:this.scenterx(e,n,r),y:this.scentery(e,n,r)};default:return null}},i.prototype.sdist=function(t,e,i,n,r){var s,a;void 0===n&&(n="edge"),void 0===r&&(r=!1);var o=e.length;if("center"==n){var _=u.map(i,(function(t){return t/2}));s=new Float64Array(o);for(var h=0;h<o;h++)s[h]=e[h]-_[h];a=new Float64Array(o);for(h=0;h<o;h++)a[h]=e[h]+_[h]}else{s=e,a=new Float64Array(o);for(h=0;h<o;h++)a[h]=s[h]+i[h]}var l=t.v_compute(s),p=t.v_compute(a);return r?u.map(l,(function(t,e){return Math.ceil(Math.abs(p[e]-l[e]))})):u.map(l,(function(t,e){return Math.abs(p[e]-l[e])}))},i.prototype.draw_legend_for_index=function(t,e,i){},i.prototype.hit_test=function(t){switch(t.type){case"point":if(null!=this._hit_point)return this._hit_point(t);break;case"span":if(null!=this._hit_span)return this._hit_span(t);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(t);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(t)}return this._nohit_warned.has(t.type)||(p.logger.debug("'"+t.type+"' selection not available for "+this.model.type),this._nohit_warned.add(t.type)),null},i.prototype._hit_rect_against_index=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,s=t.sy1,a=this.renderer.xscale.r_invert(e,i),o=a[0],_=a[1],h=this.renderer.yscale.r_invert(n,s),l=h[0],p=h[1],u=r.create_empty_hit_test_result();return u.indices=this.index.indices({x0:o,x1:_,y0:l,y1:p}),u},i.prototype.set_data=function(t,e,i){var n,r,s,a,_=this.model.materialize_dataspecs(t);if(this.visuals.set_all_indices(e),e&&!(this instanceof d.LineView)){var h={},l=function(t){var i=_[t];"_"===t.charAt(0)?h[t]=e.map((function(t){return i[t]})):h[t]=i};for(var p in _)l(p);_=h}if(c.extend(this,_),this.renderer.plot_view.model.use_map&&(null!=this._x&&(n=o.project_xy(this._x,this._y),this._x=n[0],this._y=n[1]),null!=this._xs&&(r=o.project_xsys(this._xs,this._ys),this._xs=r[0],this._ys=r[1]),null!=this._x0&&(s=o.project_xy(this._x0,this._y0),this._x0=s[0],this._y0=s[1]),null!=this._x1&&(a=o.project_xy(this._x1,this._y1),this._x1=a[0],this._y1=a[1])),null!=this.renderer.plot_view.frame.x_ranges)for(var y=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],g=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name],v=0,m=this.model._coords;v<m.length;v++){var x=m[v],w=x[0],b=x[1];w="_"+w,b="_"+b,null!=this._xs?(y instanceof f.FactorRange&&(this[w]=u.map(this[w],(function(t){return y.v_synthetic(t)}))),g instanceof f.FactorRange&&(this[b]=u.map(this[b],(function(t){return g.v_synthetic(t)})))):(y instanceof f.FactorRange&&(this[w]=y.v_synthetic(this[w])),g instanceof f.FactorRange&&(this[b]=g.v_synthetic(this[b])))}null!=this.glglyph&&this.glglyph.set_data_changed(this._x.length),this._set_data(i),this.index_data()},i.prototype._set_data=function(t){},i.prototype.index_data=function(){this.index=this._index_data()},i.prototype.mask_data=function(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()},i.prototype.map_data=function(){for(var t,e=0,i=this.model._coords;e<i.length;e++){var n=i[e],r=n[0],s=n[1],a="s"+r,o="s"+s;if(s="_"+s,null!=this[r="_"+r]&&(y.isArray(this[r][0])||y.isTypedArray(this[r][0]))){var _=this[r].length;this[a]=new Array(_),this[o]=new Array(_);for(var h=0;h<_;h++){var l=this.map_to_screen(this[r][h],this[s][h]),p=l[0],u=l[1];this[a][h]=p,this[o][h]=u}}else t=this.map_to_screen(this[r],this[s]),this[a]=t[0],this[o]=t[1]}this._map_data()},i.prototype._map_data=function(){},i.prototype.map_to_screen=function(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},i}(h.View);i.GlyphView=g,g.__name__="GlyphView";var v=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Glyph=function(){this.prototype._coords=[],this.internal({x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]})},e.coords=function(t){var e=this.prototype._coords.concat(t);this.prototype._coords=e;for(var i={},n=0,r=t;n<r.length;n++){var a=r[n],o=a[0],_=a[1];i[o]=[s.CoordinateSpec],i[_]=[s.CoordinateSpec]}this.define(i)},e}(l.Model);i.Glyph=v,v.__name__="Glyph",v.init_Glyph()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(117),i=t(184);function o(t){return t*t}function u(t,n){return o(t.x-n.x)+o(t.y-n.y)}function a(t,n,e){var r=u(n,e);if(0==r)return u(t,n);var i=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/r;return u(t,i<0?n:i>1?e:{x:n.x+i*(e.x-n.x),y:n.y+i*(e.y-n.y)})}e.point_in_poly=function(t,n,e,r){for(var i=!1,o=e[e.length-1],u=r[r.length-1],a=0;a<e.length;a++){var _=e[a],s=r[a];u<n!=s<n&&o+(n-u)/(s-u)*(_-o)<t&&(i=!i),o=_,u=s}return i},e.point_in_ellipse=function(t,n,e,r,i,o,u){var a=Math.pow(Math.cos(e)/i,2)+Math.pow(Math.sin(e)/r,2),_=2*Math.cos(e)*Math.sin(e)*(Math.pow(1/i,2)-Math.pow(1/r,2)),s=Math.pow(Math.cos(e)/r,2)+Math.pow(Math.sin(e)/i,2);return a*Math.pow(t-o,2)+_*(t-o)*(n-u)+s*Math.pow(n-u,2)<=1},e.create_empty_hit_test_result=function(){return new i.Selection},e.create_hit_test_result_from_hits=function(t){var n=new i.Selection;return n.indices=r.sort_by(t,(function(t){t[0];return t[1]})).map((function(t){var n=t[0];t[1];return n})),n},e.dist_2_pts=u,e.dist_to_segment_squared=a,e.dist_to_segment=function(t,n,e){return Math.sqrt(a(t,n,e))},e.check_2_segments_intersect=function(t,n,e,r,i,o,u,a){var _=(a-o)*(e-t)-(u-i)*(r-n);if(0==_)return{hit:!1,x:null,y:null};var s=n-o,c=t-i,h=(u-i)*s-(a-o)*c;return c=((e-t)*s-(r-n)*c)/_,{hit:(s=h/_)>0&&s<1&&c>0&&c<1,x:t+s*(e-t),y:n+s*(r-n)}}},
function _(t,n,r){Object.defineProperty(r,"__esModule",{value:!0});var e=t(1),i=t(197),a=e.__importStar(t(127)),s=t(120),o=t(117),p=t(116),u=t(119);function h(t,n,r){void 0===r&&(r=0);for(var e={},i=0;i<t.length;i++){var a=t[i];if(a in e)throw new Error("duplicate factor or subfactor: "+a);e[a]={value:.5+i*(1+n)+r}}return[e,(t.length-1)*n]}function g(t,n,r,e){void 0===e&&(e=0);for(var i={},a={},s=[],p=0,u=t;p<u.length;p++){var g=u[p],c=g[0],f=g[1];c in a||(a[c]=[],s.push(c)),a[c].push(f)}for(var l=e,d=0,_=function(t){var e=a[t].length,s=h(a[t],r,l),p=s[0],u=s[1];d+=u;var g=o.sum(a[t].map((function(t){return p[t].value})));i[t]={value:g/e,mapping:p},l+=e+n+u},v=0,m=s;v<m.length;v++){_(c=m[v])}return[i,s,(s.length-1)*n+d]}function c(t,n,r,e,i){void 0===i&&(i=0);for(var a={},s={},p=[],u=0,h=t;u<h.length;u++){var c=h[u],f=c[0],l=c[1],d=c[2];f in s||(s[f]=[],p.push(f)),s[f].push([l,d])}for(var _=[],v=i,m=0,y=function(t){for(var i=s[t].length,p=g(s[t],r,e,v),u=p[0],h=p[1],c=p[2],f=0,l=h;f<l.length;f++){var d=l[f];_.push([t,d])}m+=c;var y=o.sum(s[t].map((function(t){var n=t[0];return u[n].value})));a[t]={value:y/i,mapping:u},v+=i+n+c},b=0,N=p;b<N.length;b++){y(f=N[b])}return[a,p,_,(p.length-1)*n+m]}r.map_one_level=h,r.map_two_levels=g,r.map_three_levels=c;var f=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_FactorRange=function(){this.define({factors:[a.Array,[]],factor_padding:[a.Number,0],subgroup_padding:[a.Number,.8],group_padding:[a.Number,1.4],range_padding:[a.Number,0],range_padding_units:[a.PaddingUnits,"percent"],start:[a.Number],end:[a.Number]}),this.internal({levels:[a.Number],mids:[a.Array],tops:[a.Array],tops_groups:[a.Array]})},Object.defineProperty(n.prototype,"min",{get:function(){return this.start},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"max",{get:function(){return this.end},enumerable:!0,configurable:!0}),n.prototype.initialize=function(){t.prototype.initialize.call(this),this._init(!0)},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,(function(){return n.reset()})),this.connect(this.properties.factor_padding.change,(function(){return n.reset()})),this.connect(this.properties.group_padding.change,(function(){return n.reset()})),this.connect(this.properties.subgroup_padding.change,(function(){return n.reset()})),this.connect(this.properties.range_padding.change,(function(){return n.reset()})),this.connect(this.properties.range_padding_units.change,(function(){return n.reset()}))},n.prototype.reset=function(){this._init(!1),this.change.emit()},n.prototype._lookup=function(t){var n;return 1==t.length?(n=this._mapping).hasOwnProperty(t[0])?n[t[0]].value:NaN:2==t.length?(n=this._mapping).hasOwnProperty(t[0])&&n[t[0]].mapping.hasOwnProperty(t[1])?n[t[0]].mapping[t[1]].value:NaN:3==t.length?(n=this._mapping).hasOwnProperty(t[0])&&n[t[0]].mapping.hasOwnProperty(t[1])&&n[t[0]].mapping[t[1]].mapping.hasOwnProperty(t[2])?n[t[0]].mapping[t[1]].mapping[t[2]].value:NaN:void u.unreachable()},n.prototype.synthetic=function(t){if(p.isNumber(t))return t;if(p.isString(t))return this._lookup([t]);var n=0,r=t[t.length-1];return p.isNumber(r)&&(n=r,t=t.slice(0,-1)),this._lookup(t)+n},n.prototype.v_synthetic=function(t){var n=this;return s.map(t,(function(t){return n.synthetic(t)}))},n.prototype._init=function(t){var n,r,e,i,a;if(o.every(this.factors,p.isString))i=1,n=h(this.factors,this.factor_padding),this._mapping=n[0],a=n[1];else if(o.every(this.factors,(function(t){return p.isArray(t)&&2==t.length&&p.isString(t[0])&&p.isString(t[1])})))i=2,r=g(this.factors,this.group_padding,this.factor_padding),this._mapping=r[0],this.tops=r[1],a=r[2];else{if(!o.every(this.factors,(function(t){return p.isArray(t)&&3==t.length&&p.isString(t[0])&&p.isString(t[1])&&p.isString(t[2])})))throw new Error("???");i=3,e=c(this.factors,this.group_padding,this.subgroup_padding,this.factor_padding),this._mapping=e[0],this.tops=e[1],this.mids=e[2],a=e[3]}var s=0,u=this.factors.length+a;if("percent"==this.range_padding_units){var f=(u-s)*this.range_padding/2;s-=f,u+=f}else s-=this.range_padding,u+=this.range_padding;this.setv({start:s,end:u,levels:i},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[s,u]},{silent:!0})},n}(i.Range);r.FactorRange=f,f.__name__="FactorRange",f.init_FactorRange()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),r=e(177),a=i.__importStar(e(127)),_=function(e){function n(n){var t=e.call(this,n)||this;return t.have_updated_interactively=!1,t}return i.__extends(n,e),n.init_Range=function(){this.define({bounds:[a.Any],min_interval:[a.Any],max_interval:[a.Any]}),this.internal({plots:[a.Array,[]]})},Object.defineProperty(n.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!0,configurable:!0}),n}(r.Model);t.Range=_,_.__name__="Range",_.init_Range()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1).__importStar(e(195));i.generic_line_legend=function(e,t,i,n){var r=i.x0,a=i.x1,l=i.y0,c=i.y1;t.save(),t.beginPath(),t.moveTo(r,(l+c)/2),t.lineTo(a,(l+c)/2),e.line.doit&&(e.line.set_vectorize(t,n),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,i,n){var r=i.x0,a=i.x1,l=i.y0,c=i.y1,o=.1*Math.abs(a-r),_=.1*Math.abs(c-l),s=r+o,v=a-o,h=l+_,x=c-_;e.fill.doit&&(e.fill.set_vectorize(t,n),t.fillRect(s,h,v-s,x-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,n),t.fillRect(s,h,v-s,x-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,v-s,x-h),e.line.set_vectorize(t,n),t.stroke())},i.line_interpolation=function(e,t,i,r,a,l){var c,o,_,s,v,h,x,y,d,f,u=t.sx,g=t.sy;"point"==t.type?(d=(c=e.yscale.r_invert(g-1,g+1))[0],f=c[1],x=(o=e.xscale.r_invert(u-1,u+1))[0],y=o[1]):"v"==t.direction?(d=(_=e.yscale.r_invert(g,g))[0],f=_[1],x=(s=[Math.min(i-1,a-1),Math.max(i+1,a+1)])[0],y=s[1]):(x=(v=e.xscale.r_invert(u,u))[0],y=v[1],d=(h=[Math.min(r-1,l-1),Math.max(r+1,l+1)])[0],f=h[1]);var m=n.check_2_segments_intersect(x,d,y,f,i,r,a,l);return[m.x,m.y]}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(189),r=t(198),o=n.__importStar(t(195)),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._inner_loop=function(t,e,i,n,s){for(var r=0,o=e;r<o.length;r++){var l=o[r];0!=l?isNaN(i[l]+n[l])?(t.closePath(),s.apply(t),t.beginPath()):t.lineTo(i[l],n[l]):(t.beginPath(),t.moveTo(i[l],n[l]))}t.closePath(),s.call(t)},e.prototype._render=function(t,e,i){var n=this,s=i.sx,r=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner_loop(t,e,s,r,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner_loop(t,e,s,r,t.fill)}),(function(){return n.renderer.request_render()})),this.visuals.line.doit&&(this.visuals.line.set_value(t),this._inner_loop(t,e,s,r,t.stroke))},e.prototype.draw_legend_for_index=function(t,e,i){r.generic_area_legend(this.visuals,t,e,i)},e.prototype._hit_point=function(t){var e=this,i=o.create_empty_hit_test_result();return o.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.get_view=function(){return e}),i},e}(s.XYGlyphView);i.PatchView=l,l.__name__="PatchView";var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Patch=function(){this.prototype.default_view=l,this.mixins(["line","fill","hatch"])},e}(s.XYGlyph);i.Patch=_,_.__name__="Patch",_.init_Patch()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(201),s=t(190),o=n.__importStar(t(195)),a=n.__importStar(t(127)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x1.length;e<i;e++){var n=this._x1[e],r=this._x2[e],o=this._y[e];!isNaN(n+r+o)&&isFinite(n+r+o)&&t.push({x0:Math.min(n,r),y0:o,x1:Math.max(n,r),y1:o,i:e})}return new s.SpatialIndex(t)},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var s=0,o=e.length;s<o;s++)t.lineTo(e[s],n[s]);for(s=i.length-1;s>=0;s--)t.lineTo(i[s],n[s]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx1,s=i.sx2,o=i.sy;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner(t,r,s,o,t.fill)}),(function(){return n.renderer.request_render()}))},e.prototype._hit_point=function(t){for(var e=this,i=o.create_empty_hit_test_result(),n=this.sy.length,r=new Float64Array(2*n),s=new Float64Array(2*n),a=0,_=n;a<_;a++)r[a]=this.sx1[a],s[a]=this.sy[a],r[n+a]=this.sx2[n-a-1],s[n+a]=this.sy[n-a-1];return o.point_in_poly(t.sx,t.sy,r,s)&&(i.add_to_selected_glyphs(this.model),i.get_view=function(){return e}),i},e.prototype.scenterx=function(t){return(this.sx1[t]+this.sx2[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(r.AreaView);i.HAreaView=_,_.__name__="HAreaView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_HArea=function(){this.prototype.default_view=_,this.define({x1:[a.CoordinateSpec],x2:[a.CoordinateSpec],y:[a.CoordinateSpec]})},e}(r.Area);i.HArea=h,h.__name__="HArea",h.init_HArea()},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0});var t=e(1),r=e(194),_=e(198),a=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return t.__extends(n,e),n.prototype.draw_legend_for_index=function(e,n,i){_.generic_area_legend(this.visuals,e,n,i)},n}(r.GlyphView);i.AreaView=a,a.__name__="AreaView";var u=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_Area=function(){this.mixins(["fill","hatch"])},n}(r.Glyph);i.Area=u,u.__name__="Area",u.init_Area()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(201),s=t(190),o=n.__importStar(t(195)),a=n.__importStar(t(127)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._x[e],r=this._y1[e],o=this._y2[e];!isNaN(n+r+o)&&isFinite(n+r+o)&&t.push({x0:n,y0:Math.min(r,o),x1:n,y1:Math.max(r,o),i:e})}return new s.SpatialIndex(t)},e.prototype._inner=function(t,e,i,n,r){t.beginPath();for(var s=0,o=i.length;s<o;s++)t.lineTo(e[s],i[s]);for(s=n.length-1;s>=0;s--)t.lineTo(e[s],n[s]);t.closePath(),r.call(t)},e.prototype._render=function(t,e,i){var n=this,r=i.sx,s=i.sy1,o=i.sy2;this.visuals.fill.doit&&(this.visuals.fill.set_value(t),this._inner(t,r,s,o,t.fill)),this.visuals.hatch.doit2(t,0,(function(){return n._inner(t,r,s,o,t.fill)}),(function(){return n.renderer.request_render()}))},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.sy1[t]+this.sy2[t])/2},e.prototype._hit_point=function(t){for(var e=this,i=o.create_empty_hit_test_result(),n=this.sx.length,r=new Float64Array(2*n),s=new Float64Array(2*n),a=0,_=n;a<_;a++)r[a]=this.sx[a],s[a]=this.sy1[a],r[n+a]=this.sx[n-a-1],s[n+a]=this.sy2[n-a-1];return o.point_in_poly(t.sx,t.sy,r,s)&&(i.add_to_selected_glyphs(this.model),i.get_view=function(){return e}),i},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(r.AreaView);i.VAreaView=_,_.__name__="VAreaView";var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_VArea=function(){this.prototype.default_view=_,this.define({x:[a.CoordinateSpec],y1:[a.CoordinateSpec],y2:[a.CoordinateSpec]})},e}(r.Area);i.VArea=h,h.__name__="VArea",h.init_VArea()},
function _(i,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=i(1),c=i(177),s=t.__importStar(i(127)),o=i(184),r=i(117),u=i(182),a=function(i){function n(n){return i.call(this,n)||this}return t.__extends(n,i),n.init_CDSView=function(){this.define({filters:[s.Array,[]],source:[s.Instance]}),this.internal({indices:[s.Array,[]],indices_map:[s.Any,{}]})},n.prototype.initialize=function(){i.prototype.initialize.call(this),this.compute_indices()},n.prototype.connect_signals=function(){var n=this;i.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,(function(){n.compute_indices(),n.change.emit()}));var e=function(){var i=function(){return n.compute_indices()};null!=n.source&&(n.connect(n.source.change,i),n.source instanceof u.ColumnarDataSource&&(n.connect(n.source.streaming,i),n.connect(n.source.patching,i)))},t=null!=this.source;t?e():this.connect(this.properties.source.change,(function(){t||(e(),t=!0)}))},n.prototype.compute_indices=function(){var i=this,n=this.filters.map((function(n){return n.compute_indices(i.source)})).filter((function(i){return null!=i}));n.length>0?this.indices=r.intersection.apply(this,n):this.source instanceof u.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()},n.prototype.indices_map_to_subset=function(){this.indices_map={};for(var i=0;i<this.indices.length;i++)this.indices_map[this.indices[i]]=i},n.prototype.convert_selection_from_subset=function(i){var n=this,e=new o.Selection;e.update_through_union(i);var t=i.indices.map((function(i){return n.indices[i]}));return e.indices=t,e.image_indices=i.image_indices,e},n.prototype.convert_selection_to_subset=function(i){var n=this,e=new o.Selection;e.update_through_union(i);var t=i.indices.map((function(i){return n.indices_map[i]}));return e.indices=t,e.image_indices=i.image_indices,e},n.prototype.convert_indices_from_subset=function(i){var n=this;return i.map((function(i){return n.indices[i]}))},n}(c.Model);e.CDSView=a,a.__name__="CDSView",a.init_CDSView()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),r=e(117);function u(e,n,t){return i.__awaiter(this,void 0,void 0,(function(){var r;return i.__generator(this,(function(i){switch(i.label){case 0:return(r=new e(Object.assign(Object.assign({},t),{model:n}))).initialize(),[4,r.lazy_initialize()];case 1:return i.sent(),[2,r]}}))}))}t.build_view=function(e,n,t){return void 0===n&&(n={parent:null}),void 0===t&&(t=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var r;return i.__generator(this,(function(i){switch(i.label){case 0:return[4,u(t(e),e,n)];case 1:return(r=i.sent()).connect_signals(),[2,r]}}))}))},t.build_views=function(e,n,t,a){return void 0===t&&(t={parent:null}),void 0===a&&(a=function(e){return e.default_view}),i.__awaiter(this,void 0,void 0,(function(){var o,c,l,s,f,v,d,_,h,w,b,g;return i.__generator(this,(function(i){switch(i.label){case 0:for(o=r.difference(Object.keys(e),n.map((function(e){return e.id}))),c=0,l=o;c<l.length;c++)s=l[c],e[s].remove(),delete e[s];f=[],v=n.filter((function(n){return null==e[n.id]})),d=0,_=v,i.label=1;case 1:return d<_.length?(h=_[d],[4,u(a(h),h,t)]):[3,4];case 2:g=i.sent(),e[h.id]=g,f.push(g),i.label=3;case 3:return d++,[3,1];case 4:for(w=0,b=f;w<b.length;w++)(g=b[w]).connect_signals();return[2,f]}}))}))},t.remove_views=function(e){for(var n in e)e[n].remove(),delete e[n]}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(187),a=e(206),o=r.__importStar(e(127)),s=e(204),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views={}},t.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){var e;return r.__generator(this,(function(t){switch(t.label){case 0:return[4,s.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],{parent:this.parent})];case 1:return e=t.sent(),this.node_view=e[0],this.edge_view=e[1],this.set_data(),[2]}}))}))},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,(function(){return t.set_data()})),this.connect(this.model.node_renderer.data_source._select,(function(){return t.set_data()})),this.connect(this.model.node_renderer.data_source.inspect,(function(){return t.set_data()})),this.connect(this.model.node_renderer.data_source.change,(function(){return t.set_data()})),this.connect(this.model.edge_renderer.data_source._select,(function(){return t.set_data()})),this.connect(this.model.edge_renderer.data_source.inspect,(function(){return t.set_data()})),this.connect(this.model.edge_renderer.data_source.change,(function(){return t.set_data()}));var n=this.plot_view.frame,r=n.x_ranges,i=n.y_ranges;for(var a in r){var o=r[a];this.connect(o.change,(function(){return t.set_data()}))}for(var a in i){o=i[a];this.connect(o.change,(function(){return t.set_data()}))}},t.prototype.set_data=function(e){var t,n;void 0===e&&(e=!0),this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});var r=this.node_view.glyph;t=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source),r._x=t[0],r._y=t[1];var i=this.edge_view.glyph;n=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),i._xs=n[0],i._ys=n[1],r.index_data(),i.index_data(),e&&this.request_render()},t.prototype.render=function(){this.edge_view.render(),this.node_view.render()},t}(i.DataRendererView);n.GraphRendererView=_,_.__name__="GraphRendererView";var d=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_GraphRenderer=function(){this.prototype.default_view=_,this.define({layout_provider:[o.Instance],node_renderer:[o.Instance],edge_renderer:[o.Instance],selection_policy:[o.Instance,function(){return new a.NodesOnly}],inspection_policy:[o.Instance,function(){return new a.NodesOnly}]})},t.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},t}(i.DataRenderer);n.GraphRenderer=d,d.__name__="GraphRenderer",d.init_GraphRenderer()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),d=e(177),o=e(120),i=e(117),_=e(195),s=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype._hit_test_nodes=function(e,t){if(!t.model.visible)return null;var n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)},t.prototype._hit_test_edges=function(e,t){if(!t.model.visible)return null;var n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)},t}(d.Model);n.GraphHitTestPolicy=s,s.__name__="GraphHitTestPolicy";var a=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;return d.update(e,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()},t}(s);n.NodesOnly=a,a.__name__="NodesOnly";var c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_nodes(e,t)},t.prototype.get_linked_edges=function(e,t,n){var r=[];"selection"==n?r=e.selected.indices.map((function(t){return e.data.index[t]})):"inspection"==n&&(r=e.inspected.indices.map((function(t){return e.data.index[t]})));for(var d=[],o=0;o<t.data.start.length;o++)(i.contains(r,t.data.start[o])||i.contains(r,t.data.end[o]))&&d.push(o);for(var s=_.create_empty_hit_test_result(),a=0,c=d;a<c.length;a++){o=c[a];s.multiline_indices[o]=[0]}return s.indices=d,s},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;d.update(e,n,r);var o=t.edge_renderer.data_source.selected,i=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),_=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.edge_view.model.data_source.setv({inspected:i},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()},t}(s);n.NodesAndLinkedEdges=c,c.__name__="NodesAndLinkedEdges";var u=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){return this._hit_test_edges(e,t)},t.prototype.get_linked_nodes=function(e,t,n){var r=[];"selection"==n?r=t.selected.indices:"inspection"==n&&(r=t.inspected.indices);for(var d=[],s=0,a=r;s<a.length;s++){var c=a[s];d.push(t.data.start[c]),d.push(t.data.end[c])}var u=i.uniq(d).map((function(t){return o.indexOf(e.data.index,t)})),l=_.create_empty_hit_test_result();return l.indices=u,l},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.edge_renderer.data_source.selected;d.update(e,n,r);var o=t.node_renderer.data_source.selected,i=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.edge_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,r,d),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),_=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.node_view.model.data_source.setv({inspected:i},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:t}]),!o.is_empty()},t}(s);n.EdgesAndLinkedNodes=u,u.__name__="EdgesAndLinkedNodes"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.do_selection=function(e,t,n,r){return null!==e&&(t.selected.update(e,n,r),t._select.emit(),!t.selected.is_empty())},t}(e(177).Model);n.SelectionPolicy=u,u.__name__="SelectionPolicy";var l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){for(var n=[],r=0,u=t;r<u.length;r++){var l=u[r].hit_test(e);null!==l&&n.push(l)}if(n.length>0){for(var i=n[0],o=0,_=n;o<_.length;o++){var s=_[o];i.update_through_intersection(s)}return i}return null},t}(u);n.IntersectRenderers=l,l.__name__="IntersectRenderers";var i=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.hit_test=function(e,t){for(var n=[],r=0,u=t;r<u.length;r++){var l=u[r].hit_test(e);null!==l&&n.push(l)}if(n.length>0){for(var i=n[0],o=0,_=n;o<_.length;o++){var s=_[o];i.update_through_union(s)}return i}return null},t}(u);n.UnionRenderers=i,i.__name__="UnionRenderers"},
function _(r,n,t){Object.defineProperty(t,"__esModule",{value:!0});var a=r(116),e=r(209);function i(r){for(var n=new Uint8Array(r.buffer,r.byteOffset,2*r.length),t=0,a=n.length;t<a;t+=2){var e=n[t];n[t]=n[t+1],n[t+1]=e}}function o(r){for(var n=new Uint8Array(r.buffer,r.byteOffset,4*r.length),t=0,a=n.length;t<a;t+=4){var e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}function f(r){for(var n=new Uint8Array(r.buffer,r.byteOffset,8*r.length),t=0,a=n.length;t<a;t+=8){var e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}function u(r,n){for(var a=r.order!==t.BYTE_ORDER,e=r.shape,u=null,y=0,s=n;y<s.length;y++){var A=s[y];if(JSON.parse(A[0]).id===r.__buffer__){u=A[1];break}}var c=new t.ARRAY_TYPES[r.dtype](u);return a&&(2===c.BYTES_PER_ELEMENT?i(c):4===c.BYTES_PER_ELEMENT?o(c):8===c.BYTES_PER_ELEMENT&&f(c)),[c,e]}function y(r,n){return a.isObject(r)&&"__ndarray__"in r?c(r):a.isObject(r)&&"__buffer__"in r?u(r,n):a.isArray(r)||a.isTypedArray(r)?[r,[]]:void 0}function s(r){var n=new Uint8Array(r),t=Array.from(n).map((function(r){return String.fromCharCode(r)}));return btoa(t.join(""))}function A(r){for(var n=atob(r),t=n.length,a=new Uint8Array(t),e=0,i=t;e<i;e++)a[e]=n.charCodeAt(e);return a.buffer}function c(r){var n=A(r.__ndarray__),a=r.dtype,e=r.shape;if(!(a in t.ARRAY_TYPES))throw new Error("unknown dtype: "+a);return[new t.ARRAY_TYPES[a](n),e]}function _(r,n){var a=s(r.buffer),e=function(r){if("name"in r.constructor)return r.constructor.name;switch(!0){case r instanceof Uint8Array:return"Uint8Array";case r instanceof Int8Array:return"Int8Array";case r instanceof Uint16Array:return"Uint16Array";case r instanceof Int16Array:return"Int16Array";case r instanceof Uint32Array:return"Uint32Array";case r instanceof Int32Array:return"Int32Array";case r instanceof Float32Array:return"Float32Array";case r instanceof Float64Array:return"Float64Array";default:throw new Error("unsupported typed array")}}(r);if(!(e in t.DTYPES))throw new Error("unknown array type: "+e);return{__ndarray__:a,shape:n,dtype:t.DTYPES[e]}}function l(r,n){if(0==r.length||!a.isObject(r[0])&&!a.isArray(r[0]))return[r,[]];for(var t=[],e=[],i=0,o=r;i<o.length;i++){var f=o[i],u=a.isArray(f)?l(f,n):y(f,n),s=u[0],A=u[1];t.push(s),e.push(A)}return[t,e.map((function(r){return r.filter((function(r){return 0!=r.length}))}))]}function d(r,n){for(var t=[],e=0,i=r.length;e<i;e++){var o=r[e];if(a.isTypedArray(o)){var f=n[e]?n[e]:void 0;t.push(_(o,f))}else a.isArray(o)?t.push(d(o,n?n[e]:[])):t.push(o)}return t}t.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},t.DTYPES={Uint8Array:"uint8",Int8Array:"int8",Uint16Array:"uint16",Int16Array:"int16",Uint32Array:"uint32",Int32Array:"int32",Float32Array:"float32",Float64Array:"float64"},t.BYTE_ORDER=e.is_little_endian?"little":"big",t.swap16=i,t.swap32=o,t.swap64=f,t.process_buffer=u,t.process_array=y,t.arrayBufferToBase64=s,t.base64ToArrayBuffer=A,t.decode_base64=c,t.encode_base64=_,t.decode_column_data=function(r,n){void 0===n&&(n=[]);var t={},e={};for(var i in r){var o=r[i];if(a.isArray(o)){if(0==o.length||!a.isObject(o[0])&&!a.isArray(o[0])){t[i]=o;continue}var f=l(o,n),u=f[0],s=f[1];t[i]=u,e[i]=s}else{var A=y(o,n),c=A[0],_=A[1];t[i]=c,e[i]=_}}return[t,e]},t.encode_column_data=function(r,n){var t={};for(var e in r){var i=r[e],o=null!=n?n[e]:void 0,f=void 0;f=a.isTypedArray(i)?_(i,o):a.isArray(i)?d(i,o||[]):i,t[e]=f}return t}},
function _(n,e,i){var r;Object.defineProperty(i,"__esModule",{value:!0}),i.is_ie=(r="undefined"!=typeof navigator?navigator.userAgent:"").indexOf("MSIE")>=0||r.indexOf("Trident")>0||r.indexOf("Edge")>0,i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=function(){var n=new ArrayBuffer(4),e=new Uint8Array(n);new Uint32Array(n)[1]=168496141;var i=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(i=!1),i}()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concat=function(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];for(var r=e.length,o=0,l=t;o<l.length;o++){r+=(f=l[o]).length}var a=new e.constructor(r);a.set(e,0);for(var c=e.length,g=0,h=t;g<h.length;g++){var f=h[g];a.set(f,c),c+=f.length}return a}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(1),r=e(121),s=function(e){this.document=e};n.DocumentChangedEvent=s,s.__name__="DocumentChangedEvent";var i=function(e){function t(t,n,o){var r=e.call(this,t)||this;return r.msg_type=n,r.msg_data=o,r}return o.__extends(t,e),t.prototype.json=function(e){var t=this.msg_data,n=r.HasProps._value_to_json("",t,null);return r.HasProps._value_record_references(t,{},!0),{kind:"MessageSent",msg_type:this.msg_type,msg_data:n}},t}(s);n.MessageSentEvent=i,i.__name__="MessageSentEvent";var a=function(e){function t(t,n,o,r,s,i,a){var d=e.call(this,t)||this;return d.model=n,d.attr=o,d.old=r,d.new_=s,d.setter_id=i,d.hint=a,d}return o.__extends(t,e),t.prototype.json=function(e){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);var t=this.new_,n=r.HasProps._value_to_json(this.attr,t,this.model),o={};for(var s in r.HasProps._value_record_references(t,o,!0),this.model.id in o&&this.model!==t&&delete o[this.model.id],o)e[s]=o[s];return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:n}},t}(s);n.ModelChangedEvent=a,a.__name__="ModelChangedEvent";var d=function(e){function t(t,n,o){var r=e.call(this,t)||this;return r.column_source=n,r.patches=o,r}return o.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},t}(s);n.ColumnsPatchedEvent=d,d.__name__="ColumnsPatchedEvent";var _=function(e){function t(t,n,o,r){var s=e.call(this,t)||this;return s.column_source=n,s.data=o,s.rollover=r,s}return o.__extends(t,e),t.prototype.json=function(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},t}(s);n.ColumnsStreamedEvent=_,_.__name__="ColumnsStreamedEvent";var u=function(e){function t(t,n,o){var r=e.call(this,t)||this;return r.title=n,r.setter_id=o,r}return o.__extends(t,e),t.prototype.json=function(e){return{kind:"TitleChanged",title:this.title}},t}(s);n.TitleChangedEvent=u,u.__name__="TitleChangedEvent";var l=function(e){function t(t,n,o){var r=e.call(this,t)||this;return r.model=n,r.setter_id=o,r}return o.__extends(t,e),t.prototype.json=function(e){return r.HasProps._value_record_references(this.model,e,!0),{kind:"RootAdded",model:this.model.ref()}},t}(s);n.RootAddedEvent=l,l.__name__="RootAddedEvent";var c=function(e){function t(t,n,o){var r=e.call(this,t)||this;return r.model=n,r.setter_id=o,r}return o.__extends(t,e),t.prototype.json=function(e){return{kind:"RootRemoved",model:this.model.ref()}},t}(s);n.RootRemovedEvent=c,c.__name__="RootRemovedEvent"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),o=e(137),n=e(181),_=s.__importStar(e(127)),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.set_data(this.model.source)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.patching,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.change,(function(){return t.set_data(t.model.source)}))},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var e,t,i,s=this.plot_view.frame,o=this.model.dimension,n=s.xscales[this.model.x_range_name],_=s.yscales[this.model.y_range_name],r="height"==o?_:n,a="height"==o?n:_,l="height"==o?s.yview:s.xview,h="height"==o?s.xview:s.yview;e="data"==this.model.properties.lower.units?r.v_compute(this._lower):l.v_compute(this._lower),t="data"==this.model.properties.upper.units?r.v_compute(this._upper):l.v_compute(this._upper),i="data"==this.model.properties.base.units?a.v_compute(this._base):h.v_compute(this._base);var p="height"==o?[1,0]:[0,1],u=p[0],c=p[1],d=[e,i],m=[t,i];this._lower_sx=d[u],this._lower_sy=d[c],this._upper_sx=m[u],this._upper_sy=m[c]},t.prototype.render=function(){if(this.model.visible){this._map_data();var e=this.plot_view.canvas_view.ctx;e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var t=0,i=this._lower_sx.length;t<i;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);for(t=this._upper_sx.length-1;t>=0;t--)e.lineTo(this._upper_sx[t],this._upper_sy[t]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(t=0,i=this._lower_sx.length;t<i;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(t=0,i=this._upper_sx.length;t<i;t++)e.lineTo(this._upper_sx[t],this._upper_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())}},t}(o.AnnotationView);i.BandView=r,r.__name__="BandView";var a=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Band=function(){this.prototype.default_view=r,this.mixins(["line","fill"]),this.define({lower:[_.DistanceSpec],upper:[_.DistanceSpec],base:[_.DistanceSpec],dimension:[_.Dimension,"height"],source:[_.Instance,function(){return new n.ColumnDataSource}],x_range_name:[_.String,"default"],y_range_name:[_.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},t}(o.Annotation);i.Band=a,a.__name__="Band",a.init_Band()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),o=t(137),n=t(122),l=t(174),r=s.__importStar(t(127)),a=t(193),h=t(214);i.EDGE_TOLERANCE=2.5;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_view.add_overlay(this.el),this.el.classList.add(h.bk_shading),l.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,(function(){return e.render()})),this.connect(this.model.data_update,(function(){return e.render()}))):(this.connect(this.model.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.data_update,(function(){return e.plot_view.request_render()})))},e.prototype.render=function(){var t=this;if(this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),this.model.visible)if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var e=this.plot_view.frame,i=e.xscales[this.model.x_range_name],s=e.yscales[this.model.y_range_name],o=function(e,i,s,o,n){return null!=e?t.model.screen?e:"data"==i?s.compute(e):o.compute(e):n};this.sleft=o(this.model.left,this.model.left_units,i,e.xview,e._left.value),this.sright=o(this.model.right,this.model.right_units,i,e.xview,e._right.value),this.stop=o(this.model.top,this.model.top_units,s,e.yview,e._top.value),this.sbottom=o(this.model.bottom,this.model.bottom_units,s,e.yview,e._bottom.value),("css"==this.model.render_mode?this._css_box.bind(this):this._canvas_box.bind(this))(this.sleft,this.sright,this.sbottom,this.stop)}else l.undisplay(this.el)},e.prototype._css_box=function(t,e,i,s){var o=this.model.properties.line_width.value(),n=Math.floor(e-t)-o,r=Math.floor(i-s)-o;this.el.style.left=t+"px",this.el.style.width=n+"px",this.el.style.top=s+"px",this.el.style.height=r+"px",this.el.style.borderWidth=o+"px",this.el.style.borderColor=this.model.properties.line_color.value(),this.el.style.backgroundColor=this.model.properties.fill_color.value(),this.el.style.opacity=this.model.properties.fill_alpha.value();var a=this.model.properties.line_dash.value().length<2?"solid":"dashed";this.el.style.borderStyle=a,l.display(this.el)},e.prototype._canvas_box=function(t,e,i,s){var o=this.plot_view.canvas_view.ctx;o.save(),o.beginPath(),o.rect(t,s,e-t,i-s),this.visuals.fill.set_value(o),o.fill(),this.visuals.line.set_value(o),o.stroke(),o.restore()},e.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+i.EDGE_TOLERANCE;return new a.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},e.prototype.interactive_hit=function(t,e){return null!=this.model.in_cursor&&this.interactive_bbox().contains(t,e)},e.prototype.cursor=function(t,e){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(e-this.sbottom)<3||Math.abs(e-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&e>this.stop&&e<this.sbottom?this.model.in_cursor:null},e}(o.AnnotationView);i.BoxAnnotationView=u,u.__name__="BoxAnnotationView";var d=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_BoxAnnotation=function(){this.prototype.default_view=u,this.mixins(["line","fill"]),this.define({render_mode:[r.RenderMode,"canvas"],x_range_name:[r.String,"default"],y_range_name:[r.String,"default"],top:[r.Number,null],top_units:[r.SpatialUnits,"data"],bottom:[r.Number,null],bottom_units:[r.SpatialUnits,"data"],left:[r.Number,null],left_units:[r.SpatialUnits,"data"],right:[r.Number,null],right_units:[r.SpatialUnits,"data"]}),this.internal({screen:[r.Boolean,!1],ew_cursor:[r.String,null],ns_cursor:[r.String,null],in_cursor:[r.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new n.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.left,i=t.right,s=t.top,o=t.bottom;this.setv({left:e,right:i,top:s,bottom:o,screen:!0},{silent:!0}),this.data_update.emit()},e}(o.Annotation);i.BoxAnnotation=d,d.__name__="BoxAnnotation",d.init_BoxAnnotation()},
function _(n,o,a){Object.defineProperty(a,"__esModule",{value:!0});var t=n(1);n(175),t.__importStar(n(174)).styles.append(".bk-root .bk-shading {\n  position: absolute;\n  display: block;\n  border: 1px dashed green;\n}\n"),a.bk_annotation="bk-annotation",a.bk_shading="bk-shading",a.bk_annotation_child="bk-annotation-child"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),r=t(137),a=t(216),n=t(220),l=t(222),s=t(227),_=t(237),h=t(238),m=o.__importStar(t(127)),d=o.__importStar(t(239)),c=t(117),u=t(120),p=t(131),f=t(116),g=t(119),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_canvas_image()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.visible.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.ticker.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.formatter.change,(function(){return e.plot_view.request_render()})),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,(function(){e._set_canvas_image(),e.plot_view.request_render()}))},e.prototype._get_size=function(){if(null==this.model.color_mapper)return{width:0,height:0};var t=this.compute_legend_dimensions();return{width:t.width,height:t.height}},e.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var i,o,r=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(r=c.reversed(r)),this.model.orientation){case"vertical":i=(t=[1,r.length])[0],o=t[1];break;case"horizontal":i=(e=[r.length,1])[0],o=e[1]}var a=document.createElement("canvas");a.width=i,a.height=o;var n=a.getContext("2d"),s=n.getImageData(0,0,i,o),_=new l.LinearColorMapper({palette:r}).rgba_mapper.v_compute(c.range(0,r.length));s.data.set(_),n.putImageData(s,0,0),this.image=a}},e.prototype.compute_legend_dimensions=function(){var t,e,i=this._computed_image_dimensions(),o=[i.height,i.width],r=o[0],a=o[1],n=this._get_label_extent(),l=this._title_extent(),s=this._tick_extent(),_=this.model.padding;switch(this.model.orientation){case"vertical":t=r+l+2*_,e=a+s+n+2*_;break;case"horizontal":t=r+l+s+n+2*_,e=a+2*_}return{width:e,height:t}},e.prototype.compute_legend_location=function(){var t,e,i=this.compute_legend_dimensions(),o=[i.height,i.width],r=o[0],a=o[1],n=this.model.margin,l=null!=this.panel?this.panel:this.plot_view.frame,s=l.bbox.ranges,_=s[0],h=s[1],m=this.model.location;if(f.isString(m))switch(m){case"top_left":t=_.start+n,e=h.start+n;break;case"top_center":t=(_.end+_.start)/2-a/2,e=h.start+n;break;case"top_right":t=_.end-n-a,e=h.start+n;break;case"bottom_right":t=_.end-n-a,e=h.end-n-r;break;case"bottom_center":t=(_.end+_.start)/2-a/2,e=h.end-n-r;break;case"bottom_left":t=_.start+n,e=h.end-n-r;break;case"center_left":t=_.start+n,e=(h.end+h.start)/2-r/2;break;case"center":t=(_.end+_.start)/2-a/2,e=(h.end+h.start)/2-r/2;break;case"center_right":t=_.end-n-a,e=(h.end+h.start)/2-r/2}else if(f.isArray(m)&&2==m.length){var d=m[0],c=m[1];t=l.xview.compute(d),e=l.yview.compute(c)-r}else g.unreachable();return{sx:t,sy:e}},e.prototype.render=function(){if(this.model.visible&&null!=this.model.color_mapper){var t=this.plot_view.canvas_view.ctx;t.save();var e=this.compute_legend_location(),i=e.sx,o=e.sy;t.translate(i,o),this._draw_bbox(t);var r=this._get_image_offset();if(t.translate(r.x,r.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){var a=this.tick_info();this._draw_major_ticks(t,a),this._draw_minor_ticks(t,a),this._draw_major_labels(t,a)}this.model.title&&this._draw_title(t),t.restore()}},e.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_image=function(t){var e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},e.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var i=this._normals(),o=i[0],r=i[1],a=this._computed_image_dimensions(),n=[a.width*o,a.height*r],l=n[0],s=n[1],_=e.coords.major,h=_[0],m=_[1],d=this.model.major_tick_in,c=this.model.major_tick_out;t.save(),t.translate(l,s),this.visuals.major_tick_line.set_value(t);for(var u=0,p=h.length;u<p;u++)t.beginPath(),t.moveTo(Math.round(h[u]+o*c),Math.round(m[u]+r*c)),t.lineTo(Math.round(h[u]-o*d),Math.round(m[u]-r*d)),t.stroke();t.restore()}},e.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var i=this._normals(),o=i[0],r=i[1],a=this._computed_image_dimensions(),n=[a.width*o,a.height*r],l=n[0],s=n[1],_=e.coords.minor,h=_[0],m=_[1],d=this.model.minor_tick_in,c=this.model.minor_tick_out;t.save(),t.translate(l,s),this.visuals.minor_tick_line.set_value(t);for(var u=0,p=h.length;u<p;u++)t.beginPath(),t.moveTo(Math.round(h[u]+o*c),Math.round(m[u]+r*c)),t.lineTo(Math.round(h[u]-o*d),Math.round(m[u]-r*d)),t.stroke();t.restore()}},e.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var i=this._normals(),o=i[0],r=i[1],a=this._computed_image_dimensions(),n=[a.width*o,a.height*r],l=n[0],s=n[1],_=this.model.label_standoff+this._tick_extent(),h=[_*o,_*r],m=h[0],d=h[1],c=e.coords.major,u=c[0],p=c[1],f=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(l+m,s+d);for(var g=0,v=u.length;g<v;g++)t.fillText(f[g],Math.round(u[g]+o*this.model.label_standoff),Math.round(p[g]+r*this.model.label_standoff));t.restore()}},e.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},e.prototype._get_label_extent=function(){var t,e=this.tick_info().labels.major;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||p.isEmpty(e))t=0;else{var i=this.plot_view.canvas_view.ctx;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":t=c.max(e.map((function(t){return i.measureText(t.toString()).width})));break;case"horizontal":t=d.measure_font(this.visuals.major_label_text.font_value()).height}t+=this.model.label_standoff,i.restore()}return t},e.prototype._get_image_offset=function(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}},e.prototype._normals=function(){return"vertical"==this.model.orientation?[1,0]:[0,1]},e.prototype._title_extent=function(){var t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?d.measure_font(t).height+this.model.title_standoff:0},e.prototype._tick_extent=function(){return null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high?c.max([this.model.major_tick_out,this.model.minor_tick_out]):0},e.prototype._computed_image_dimensions=function(){var t,e,i=this.plot_view.frame._height.value,o=this.plot_view.frame._width.value,r=this._title_extent();switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?t=i-2*this.model.padding-r:(t=c.max([25*this.model.color_mapper.palette.length,.3*i]),t=c.min([t,.8*i-2*this.model.padding-r])):t=this.model.height,e="auto"==this.model.width?25:this.model.width;break;case"horizontal":t="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?e=o-2*this.model.padding:(e=c.max([25*this.model.color_mapper.palette.length,.3*o]),e=c.min([e,.8*o-2*this.model.padding])):e=this.model.width}return{width:e,height:t}},e.prototype._tick_coordinate_scale=function(t){var e={source_range:new h.Range1d({start:this.model.color_mapper.low,end:this.model.color_mapper.high}),target_range:new h.Range1d({start:0,end:t})};switch(this.model.color_mapper.type){case"LinearColorMapper":return new s.LinearScale(e);case"LogColorMapper":return new _.LogScale(e);default:g.unreachable()}},e.prototype._format_major_labels=function(t,e){for(var i=this.model.formatter.doFormat(t,null),o=0,r=e.length;o<r;o++)e[o]in this.model.major_label_overrides&&(i[o]=this.model.major_label_overrides[e[o]]);return i},e.prototype.tick_info=function(){var t,e=this._computed_image_dimensions();switch(this.model.orientation){case"vertical":t=e.height;break;case"horizontal":t=e.width}for(var i=this._tick_coordinate_scale(t),o=this._normals(),r=o[0],a=o[1],n=[this.model.color_mapper.low,this.model.color_mapper.high],l=n[0],s=n[1],_=this.model.ticker.get_ticks(l,s,null,null,this.model.ticker.desired_num_ticks),h=_.major,m=_.minor,d=[[],[]],c=[[],[]],p=0,f=h.length;p<f;p++)h[p]<l||h[p]>s||(d[r].push(h[p]),d[a].push(0));for(p=0,f=m.length;p<f;p++)m[p]<l||m[p]>s||(c[r].push(m[p]),c[a].push(0));var g={major:this._format_major_labels(d[r],h)},v={major:[[],[]],minor:[[],[]]};return v.major[r]=i.v_compute(d[r]),v.minor[r]=i.v_compute(c[r]),v.major[a]=d[a],v.minor[a]=c[a],"vertical"==this.model.orientation&&(v.major[r]=u.map(v.major[r],(function(e){return t-e})),v.minor[r]=u.map(v.minor[r],(function(e){return t-e}))),{coords:v,labels:g}},e}(r.AnnotationView);i.ColorBarView=v,v.__name__="ColorBarView";var b=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ColorBar=function(){this.prototype.default_view=v,this.mixins(["text:major_label_","text:title_","line:major_tick_","line:minor_tick_","line:border_","line:bar_","fill:background_"]),this.define({location:[m.Any,"top_right"],orientation:[m.Orientation,"vertical"],title:[m.String],title_standoff:[m.Number,2],width:[m.Any,"auto"],height:[m.Any,"auto"],scale_alpha:[m.Number,1],ticker:[m.Instance,function(){return new a.BasicTicker}],formatter:[m.Instance,function(){return new n.BasicTickFormatter}],major_label_overrides:[m.Any,{}],color_mapper:[m.Instance],label_standoff:[m.Number,5],margin:[m.Number,30],padding:[m.Number,10],major_tick_in:[m.Number,5],major_tick_out:[m.Number,0],minor_tick_in:[m.Number,0],minor_tick_out:[m.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"8pt",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"10pt",title_text_font_style:"italic"})},e}(r.Annotation);i.ColorBar=b,b.__name__="ColorBar",b.init_ColorBar()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),c=function(e){function i(i){return e.call(this,i)||this}return t.__extends(i,e),i}(e(217).AdaptiveTicker);n.BasicTicker=c,c.__name__="BasicTicker"},
function _(t,i,a){Object.defineProperty(a,"__esModule",{value:!0});var e=t(1),n=t(218),s=t(117),r=e.__importStar(t(127));var _=function(t){function i(i){return t.call(this,i)||this}return e.__extends(i,t),i.init_AdaptiveTicker=function(){this.define({base:[r.Number,10],mantissas:[r.Array,[1,2,5]],min_interval:[r.Number,0],max_interval:[r.Number]})},i.prototype.initialize=function(){t.prototype.initialize.call(this);var i=s.nth(this.mantissas,-1)/this.base,a=s.nth(this.mantissas,0)*this.base;this.extended_mantissas=e.__spreadArrays([i],this.mantissas,[a]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},i.prototype.get_interval=function(t,i,a){var e,n,r=i-t,_=this.get_ideal_interval(t,i,a),h=Math.floor((e=_/this.base_factor,void 0===(n=this.base)&&(n=Math.E),Math.log(e)/Math.log(n))),o=Math.pow(this.base,h)*this.base_factor,m=this.extended_mantissas,l=m.map((function(t){return Math.abs(a-r/(t*o))}));return function(t,i,a){return Math.max(i,Math.min(a,t))}(m[s.argmin(l)]*o,this.get_min_interval(),this.get_max_interval())},i}(n.ContinuousTicker);a.AdaptiveTicker=_,_.__name__="AdaptiveTicker",_.init_AdaptiveTicker()},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(1),r=t(219),o=e.__importStar(t(127)),u=t(117),_=t(116),a=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_ContinuousTicker=function(){this.define({num_minor_ticks:[o.Number,5],desired_num_ticks:[o.Number,6]})},n.prototype.get_ticks=function(t,n,i,e,r){return this.get_ticks_no_defaults(t,n,e,this.desired_num_ticks)},n.prototype.get_ticks_no_defaults=function(t,n,i,e){var r=this.get_interval(t,n,e),o=Math.floor(t/r),a=Math.ceil(n/r),s=(_.isStrictNaN(o)||_.isStrictNaN(a)?[]:u.range(o,a+1)).map((function(t){return t*r})).filter((function(i){return t<=i&&i<=n})),c=this.num_minor_ticks,l=[];if(c>0&&s.length>0){for(var f=r/c,m=u.range(0,c).map((function(t){return t*f})),h=0,p=m.slice(1);h<p.length;h++){var v=p[h],g=s[0]-v;t<=g&&g<=n&&l.push(g)}for(var k=0,d=s;k<d.length;k++)for(var y=d[k],N=0,T=m;N<T.length;N++){v=T[N];t<=(g=y+v)&&g<=n&&l.push(g)}}return{major:s,minor:l}},n.prototype.get_min_interval=function(){return this.min_interval},n.prototype.get_max_interval=function(){return null!=this.max_interval?this.max_interval:1/0},n.prototype.get_ideal_interval=function(t,n,i){return(n-t)/i},n}(r.Ticker);i.ContinuousTicker=a,a.__name__="ContinuousTicker",a.init_ContinuousTicker()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e(1),_=function(e){function n(n){return e.call(this,n)||this}return r.__extends(n,e),n}(e(177).Model);t.Ticker=_,_.__name__="Ticker"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(1),n=i(221),o=r.__importStar(i(127)),c=function(i){function t(t){var e=i.call(this,t)||this;return e.last_precision=3,e}return r.__extends(t,i),t.init_BasicTickFormatter=function(){this.define({precision:[o.Any,"auto"],use_scientific:[o.Boolean,!0],power_limit_high:[o.Number,5],power_limit_low:[o.Number,-3]})},Object.defineProperty(t.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!0,configurable:!0}),t.prototype._need_sci=function(i){if(!this.use_scientific)return!1;for(var t=this.scientific_limit_high,e=this.scientific_limit_low,r=i.length<2?0:Math.abs(i[1]-i[0])/1e4,n=0,o=i;n<o.length;n++){var c=o[n],a=Math.abs(c);if(!(a<=r)&&(a>=t||a<=e))return!0}return!1},t.prototype._format_with_precision=function(i,t,e){var r=new Array(i.length);if(t)for(var n=0,o=i.length;n<o;n++)r[n]=i[n].toExponential(e);else for(n=0,o=i.length;n<o;n++)r[n]=i[n].toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");return r},t.prototype._auto_precision=function(i,t){var e=new Array(i.length),r=this.last_precision<=15;i:for(var n=this.last_precision;r?n<=15:n>=1;r?n++:n--){if(t){e[0]=i[0].toExponential(n);for(var o=1;o<i.length;o++)if(e[o]==e[o-1])continue i;this.last_precision=n;break}e[0]=i[0].toFixed(n).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");for(o=1;o<i.length;o++)if(e[o]=i[o].toFixed(n).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),e[o]==e[o-1])continue i;this.last_precision=n;break}return this.last_precision},t.prototype.doFormat=function(i,t){if(0==i.length)return[];var e=this._need_sci(i),r="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,r)},t}(n.TickFormatter);e.BasicTickFormatter=c,c.__name__="BasicTickFormatter",c.init_BasicTickFormatter()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),_=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t}(e(177).Model);n.TickFormatter=_,_.__name__="TickFormatter"},
function _(o,l,n){Object.defineProperty(n,"__esModule",{value:!0});var e=o(1),r=o(223),t=o(120),i=function(o){function l(l){return o.call(this,l)||this}return e.__extends(l,o),l.prototype._v_compute=function(o,l,n,e){for(var r=e.nan_color,i=e.low_color,a=e.high_color,h=null!=this.low?this.low:t.min(o),u=null!=this.high?this.high:t.max(o),_=n.length-1,s=1/(u-h),c=1/n.length,p=0,f=o.length;p<f;p++){var g=o[p];if(isNaN(g))l[p]=r;else if(g!=u){var v=(g-h)*s,M=Math.floor(v/c);l[p]=M<0?null!=i?i:n[0]:M>_?null!=a?a:n[_]:n[M]}else l[p]=n[_]}},l}(r.ContinuousColorMapper);n.LinearColorMapper=i,i.__name__="LinearColorMapper"},
function _(o,r,i){Object.defineProperty(i,"__esModule",{value:!0});var t=o(1),l=o(224),n=t.__importStar(o(127)),e=function(o){function r(r){return o.call(this,r)||this}return t.__extends(r,o),r.init_ContinuousColorMapper=function(){this.define({high:[n.Number],low:[n.Number],high_color:[n.Color],low_color:[n.Color]})},r.prototype._colors=function(r){return Object.assign(Object.assign({},o.prototype._colors.call(this,r)),{low_color:null!=this.low_color?r(this.low_color):void 0,high_color:null!=this.high_color?r(this.high_color):void 0})},r}(l.ColorMapper);i.ContinuousColorMapper=e,e.__name__="ContinuousColorMapper",e.init_ContinuousColorMapper()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(225),i=n.__importStar(t(127)),a=t(116),_=t(129),u=t(209);function l(t){return a.isNumber(t)?t:("#"!=t[0]&&(t=_.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function c(t){for(var r=new Uint32Array(t.length),e=0,n=t.length;e<n;e++)r[e]=l(t[e]);return r}function p(t){if(u.is_little_endian)for(var r=new DataView(t.buffer),e=0,n=t.length;e<n;e++)r.setUint32(4*e,t[e]);return new Uint8Array(t.buffer)}e._convert_color=l,e._convert_palette=c,e._uint32_to_rgba=p;var f=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_ColorMapper=function(){this.define({palette:[i.Any],nan_color:[i.Color,"gray"]})},r.prototype.v_compute=function(t){var r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors((function(t){return t}))),r},Object.defineProperty(r.prototype,"rgba_mapper",{get:function(){var t=this,r=c(this.palette),e=this._colors(l);return{v_compute:function(n){var o=new Uint32Array(n.length);return t._v_compute(n,o,r,e),p(o)}}},enumerable:!0,configurable:!0}),r.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},r}(o.Mapper);e.ColorMapper=f,f.__name__="ColorMapper",f.init_ColorMapper()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),o=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.prototype.compute=function(e){throw new Error("mapping single values is not supported")},n}(e(226).Transform);r.Mapper=o,o.__name__="Mapper"},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(1),_=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n}(e(177).Model);r.Transform=_,_.__name__="Transform"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),i=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.compute=function(t){return this._linear_compute(t)},e.prototype.v_compute=function(t){return this._linear_v_compute(t)},e.prototype.invert=function(t){return this._linear_invert(t)},e.prototype.v_invert=function(t){return this._linear_v_invert(t)},e}(t(228).ContinuousScale);n.LinearScale=i,i.__name__="LinearScale"},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var u=e(1),o=function(e){function n(n){return e.call(this,n)||this}return u.__extends(n,e),n}(e(229).Scale);t.ContinuousScale=o,o.__name__="ContinuousScale"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),i=t(230),_=n.__importStar(t(127)),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Scale=function(){this.internal({source_range:[_.Any],target_range:[_.Any]})},e.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},e.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},e.prototype._linear_compute=function(t){var e=this._linear_compute_state();return e[0]*t+e[1]},e.prototype._linear_v_compute=function(t){for(var e=this._linear_compute_state(),r=e[0],n=e[1],i=new Float64Array(t.length),_=0;_<t.length;_++)i[_]=r*t[_]+n;return i},e.prototype._linear_invert=function(t){var e=this._linear_compute_state(),r=e[0];return(t-e[1])/r},e.prototype._linear_v_invert=function(t){for(var e=this._linear_compute_state(),r=e[0],n=e[1],i=new Float64Array(t.length),_=0;_<t.length;_++)i[_]=(t[_]-n)/r;return i},e.prototype._linear_compute_state=function(){var t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]},e}(i.Transform);r.Scale=a,a.__name__="Scale",a.init_Scale()},
function _(r,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(231);t.CustomJSTransform=e.CustomJSTransform;var a=r(232);t.Dodge=a.Dodge;var n=r(233);t.Interpolator=n.Interpolator;var p=r(234);t.Jitter=p.Jitter;var l=r(235);t.LinearInterpolator=l.LinearInterpolator;var v=r(236);t.StepInterpolator=v.StepInterpolator;var s=r(226);t.Transform=s.Transform},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(226),s=n.__importStar(t(127)),a=t(131),i=t(133),u=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_CustomJSTransform=function(){this.define({args:[s.Any,{}],func:[s.String,""],v_func:[s.String,""]})},Object.defineProperty(r.prototype,"names",{get:function(){return a.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return a.values(this.args)},enumerable:!0,configurable:!0}),r.prototype._make_transform=function(t,r){return new(Function.bind.apply(Function,n.__spreadArrays([void 0],this.names,[t,i.use_strict(r)])))},Object.defineProperty(r.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!0,configurable:!0}),r.prototype.compute=function(t){return this.scalar_transform.apply(this,n.__spreadArrays(this.values,[t]))},r.prototype.v_compute=function(t){return this.vector_transform.apply(this,n.__spreadArrays(this.values,[t]))},r}(o.Transform);e.CustomJSTransform=u,u.__name__="CustomJSTransform",u.init_CustomJSTransform()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),o=e(226),i=e(196),u=r.__importStar(e(127)),a=e(116),c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_Dodge=function(){this.define({value:[u.Number,0],range:[u.Instance]})},t.prototype.v_compute=function(e){var t;if(this.range instanceof i.FactorRange)t=this.range.v_synthetic(e);else{if(!a.isArrayableOf(e,a.isNumber))throw new Error("unexpected");t=e}for(var n=new Float64Array(t.length),r=0;r<t.length;r++){var o=t[r];n[r]=this._compute(o)}return n},t.prototype.compute=function(e){if(this.range instanceof i.FactorRange)return this._compute(this.range.synthetic(e));if(a.isNumber(e))return this._compute(e);throw new Error("unexpected")},t.prototype._compute=function(e){return e+this.value},t}(o.Transform);n.Dodge=c,c.__name__="Dodge",c.init_Dodge()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),o=t(226),i=n.__importStar(t(127)),s=t(117),a=t(116),h=function(t){function r(r){var e=t.call(this,r)||this;return e._sorted_dirty=!0,e}return n.__extends(r,t),r.init_Interpolator=function(){this.define({x:[i.Any],y:[i.Any],data:[i.Any],clip:[i.Boolean,!0]})},r.prototype.connect_signals=function(){var r=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return r._sorted_dirty=!0}))},r.prototype.v_compute=function(t){for(var r=new Float64Array(t.length),e=0;e<t.length;e++){var n=t[e];r[e]=this.compute(n)}return r},r.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var r,e;if(a.isString(this.x)&&a.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!s.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!s.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!a.isArray(this.x)||!a.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");var o=[];for(var i in r)o.push({x:r[i],y:e[i]});t?o.sort((function(t,r){return t.x>r.x?-1:t.x==r.x?0:1})):o.sort((function(t,r){return t.x<r.x?-1:t.x==r.x?0:1})),this._x_sorted=[],this._y_sorted=[];for(var h=0,d=o;h<d.length;h++){var l=d[h],u=l.x,_=l.y;this._x_sorted.push(u),this._y_sorted.push(_)}this._sorted_dirty=!1}},r}(o.Transform);e.Interpolator=h,h.__name__="Interpolator",h.init_Interpolator()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=t(226),s=t(196),o=t(116),u=i.__importStar(t(127)),a=i.__importStar(t(118)),h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Jitter=function(){this.define({mean:[u.Number,0],width:[u.Number,1],distribution:[u.Distribution,"uniform"],range:[u.Instance]}),this.internal({previous_values:[u.Array]})},e.prototype.v_compute=function(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;var e;if(this.range instanceof s.FactorRange)e=this.range.v_synthetic(t);else{if(!o.isArrayableOf(t,o.isNumber))throw new Error("unexpected");e=t}for(var r=new Float64Array(e.length),i=0;i<e.length;i++){var n=e[i];r[i]=this._compute(n)}return this.previous_values=r,r},e.prototype.compute=function(t){if(this.range instanceof s.FactorRange)return this._compute(this.range.synthetic(t));if(o.isNumber(t))return this._compute(t);throw new Error("unexpected")},e.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}},e}(n.Transform);r.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var _=t(1),s=t(117),i=function(t){function e(e){return t.call(this,e)||this}return _.__extends(e,t),e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var e=s.find_last_index(this._x_sorted,(function(e){return e<t})),r=this._x_sorted[e],_=this._x_sorted[e+1],i=this._y_sorted[e],o=this._y_sorted[e+1];return i+(t-r)/(_-r)*(o-i)},e}(t(233).Interpolator);r.LinearInterpolator=i,i.__name__="LinearInterpolator"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=t(1),i=t(233),o=n.__importStar(t(127)),s=t(117),_=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_StepInterpolator=function(){this.define({mode:[o.StepMode,"after"]})},e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=s.find_last_index(this._x_sorted,(function(e){return t>=e}));break;case"before":e=s.find_index(this._x_sorted,(function(e){return t<=e}));break;case"center":var r=this._x_sorted.map((function(e){return Math.abs(e-t)})),n=s.min(r);e=s.find_index(r,(function(t){return n===t}));break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(i.Interpolator);r.StepInterpolator=_,_.__name__="StepInterpolator",_.init_StepInterpolator()},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});var o=t(1),r=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.prototype.compute=function(t){var e,a=this._compute_state(),o=a[0],r=a[1],n=a[2],i=a[3];if(0==n)e=0;else{var h=(Math.log(t)-i)/n;e=isFinite(h)?h*o+r:NaN}return e},e.prototype.v_compute=function(t){var e=this._compute_state(),a=e[0],o=e[1],r=e[2],n=e[3],i=new Float64Array(t.length);if(0==r)for(var h=0;h<t.length;h++)i[h]=0;else for(h=0;h<t.length;h++){var _=(Math.log(t[h])-n)/r,l=void 0;l=isFinite(_)?_*a+o:NaN,i[h]=l}return i},e.prototype.invert=function(t){var e=this._compute_state(),a=e[0],o=e[1],r=e[2],n=e[3],i=(t-o)/a;return Math.exp(r*i+n)},e.prototype.v_invert=function(t){for(var e=this._compute_state(),a=e[0],o=e[1],r=e[2],n=e[3],i=new Float64Array(t.length),h=0;h<t.length;h++){var _=(t[h]-o)/a;i[h]=Math.exp(r*_+n)}return i},e.prototype._get_safe_factor=function(t,e){var a,o=t<0?0:t,r=e<0?0:e;if(o==r)if(0==o)o=(a=[1,10])[0],r=a[1];else{var n=Math.log(o)/Math.log(10);o=Math.pow(10,Math.floor(n)),r=Math.ceil(n)!=Math.floor(n)?Math.pow(10,Math.ceil(n)):Math.pow(10,Math.ceil(n)+1)}return[o,r]},e.prototype._compute_state=function(){var t,e,a=this.source_range.start,o=this.source_range.end,r=this.target_range.start,n=this.target_range.end-r,i=this._get_safe_factor(a,o),h=i[0],_=i[1];return 0==h?(t=Math.log(_),e=0):(t=Math.log(_)-Math.log(h),e=Math.log(h)),[n,r,t,e]},e}(t(228).ContinuousScale);a.LogScale=r,r.__name__="LogScale"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var n=t(1),i=t(197),r=n.__importStar(t(127)),a=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Range1d=function(){this.define({start:[r.Number,0],end:[r.Number,1],reset_start:[r.Number],reset_end:[r.Number]})},e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()},e}(i.Range);s.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(174),l={};i.measure_font=function(e){if(null!=l[e])return l[e];var t=n.span({style:{font:e}},"Hg"),i=n.div({style:{display:"inline-block",width:"1px",height:"0px"}}),o=n.div({},t,i);document.body.appendChild(o);try{i.style.verticalAlign="baseline";var r=n.offset(i).top-n.offset(t).top;i.style.verticalAlign="bottom";var d=n.offset(i).top-n.offset(t).top,a={height:d,ascent:r,descent:d-r};return l[e]=a,a}finally{document.body.removeChild(o)}};var o={};i.measure_text=function(e,t){var i=o[t];if(null!=i){var l=i[e];if(null!=l)return l}else o[t]={};var r=n.div({style:{display:"inline-block","white-space":"nowrap",font:t}},e);document.body.appendChild(r);try{var d=r.getBoundingClientRect(),a=d.width,f=d.height;return o[t][e]={width:a,height:f},{width:a,height:f}}finally{document.body.removeChild(r)}}},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),s=e(241),a=e(174),l=n.__importStar(e(127)),o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals.warm_cache()},t.prototype._get_size=function(){var e=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(e);var t=e.measureText(this.model.text);return{width:t.width,height:t.ascent}},t.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||a.undisplay(this.el),this.model.visible){var e;switch(this.model.angle_units){case"rad":e=-this.model.angle;break;case"deg":e=-this.model.angle*Math.PI/180}var t=null!=this.panel?this.panel:this.plot_view.frame,i=this.plot_view.frame.xscales[this.model.x_range_name],n=this.plot_view.frame.yscales[this.model.y_range_name],s="data"==this.model.x_units?i.compute(this.model.x):t.xview.compute(this.model.x),l="data"==this.model.y_units?n.compute(this.model.y):t.yview.compute(this.model.y);s+=this.model.x_offset,l-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.plot_view.canvas_view.ctx,this.model.text,s,l,e)}},t}(s.TextAnnotationView);i.LabelView=o,o.__name__="LabelView";var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Label=function(){this.prototype.default_view=o,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[l.Number],x_units:[l.SpatialUnits,"data"],y:[l.Number],y_units:[l.SpatialUnits,"data"],text:[l.String],angle:[l.Angle,0],angle_units:[l.AngleUnits,"rad"],x_offset:[l.Number,0],y_offset:[l.Number,0],x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},t}(s.TextAnnotation);i.Label=_,_.__name__="Label",_.init_Label()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),n=t(137),l=t(174),a=s.__importStar(t(127)),o=t(239),r=t(214),u=t(119),_=function(t){function e(){var e=t.apply(this,arguments)||this;return e.rotate=!0,e}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el.classList.add(r.bk_annotation),this.plot_view.canvas_view.add_overlay(this.el))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,(function(){return e.render()})):this.connect(this.model.change,(function(){return e.plot_view.request_render()}))},e.prototype._calculate_text_dimensions=function(t,e){return[t.measureText(e).width,o.measure_font(this.visuals.text.font_value()).height]},e.prototype._calculate_bounding_box_dimensions=function(t,e){var i,s,n=this._calculate_text_dimensions(t,e),l=n[0],a=n[1];switch(t.textAlign){case"left":i=0;break;case"center":i=-l/2;break;case"right":i=-l;break;default:u.unreachable()}switch(t.textBaseline){case"top":s=0;break;case"middle":s=-.5*a;break;case"bottom":s=-1*a;break;case"alphabetic":s=-.8*a;break;case"hanging":s=-.17*a;break;case"ideographic":s=-.83*a;break;default:u.unreachable()}return[i,s,l,a]},e.prototype._canvas_text=function(t,e,i,s,n){this.visuals.text.set_value(t);var l=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(i,s),n&&t.rotate(n),t.rect(l[0],l[1],l[2],l[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},e.prototype._css_text=function(t,e,i,s,n){l.undisplay(this.el),this.visuals.text.set_value(t);var a=this._calculate_bounding_box_dimensions(t,e),o=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),this.el.style.position="absolute",this.el.style.left=i+a[0]+"px",this.el.style.top=s+a[1]+"px",this.el.style.color=""+this.visuals.text.text_color.value(),this.el.style.opacity=""+this.visuals.text.text_alpha.value(),this.el.style.font=""+this.visuals.text.font_value(),this.el.style.lineHeight="normal",n&&(this.el.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(this.el.style.borderStyle=""+o,this.el.style.borderWidth=this.visuals.border_line.line_width.value()+"px",this.el.style.borderColor=""+this.visuals.border_line.color_value()),this.el.textContent=e,l.display(this.el)},e}(n.AnnotationView);i.TextAnnotationView=_,_.__name__="TextAnnotationView";var h=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_TextAnnotation=function(){this.define({render_mode:[a.RenderMode,"canvas"]})},e}(n.Annotation);i.TextAnnotation=h,h.__name__="TextAnnotation",h.init_TextAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),o=t(241),n=t(181),l=t(174),a=s.__importStar(t(127)),r=t(214),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){if(t.prototype.initialize.call(this),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this._text.length;e<i;e++){var s=l.div({class:r.bk_annotation_child,style:{display:"none"}});this.el.appendChild(s)}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.render()}))):(this.connect(this.model.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.streaming,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.patching,(function(){e.set_data(e.model.source),e.plot_view.request_render()})),this.connect(this.model.source.change,(function(){e.set_data(e.model.source),e.plot_view.request_render()})))},e.prototype.set_data=function(e){t.prototype.set_data.call(this,e),this.visuals.warm_cache(e)},e.prototype._map_data=function(){var t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],i=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):i.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):i.yview.v_compute(this._y)]},e.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),this.model.visible)for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.plot_view.canvas_view.ctx,i=this._map_data(),s=i[0],o=i[1],n=0,a=this._text.length;n<a;n++)t(e,n,this._text[n],s[n]+this._x_offset[n],o[n]-this._y_offset[n],this._angle[n])},e.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;this.visuals.text.set_value(t);var e=t.measureText(this._text[0]);return{width:e.width,height:e.ascent}},e.prototype._v_canvas_text=function(t,e,i,s,o,n){this.visuals.text.set_vectorize(t,e);var l=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(s,o),t.rotate(n),t.rect(l[0],l[1],l[2],l[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},e.prototype._v_css_text=function(t,e,i,s,o,n){var a=this.el.children[e];a.textContent=i,this.visuals.text.set_vectorize(t,e);var r=this._calculate_bounding_box_dimensions(t,i),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=s+r[0]+"px",a.style.top=o+r[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",n&&(a.style.transform="rotate("+n+"rad)"),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+_,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),l.display(a)},e}(o.TextAnnotationView);i.LabelSetView=_,_.__name__="LabelSetView";var c=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_LabelSet=function(){this.prototype.default_view=_,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[a.NumberSpec],y:[a.NumberSpec],x_units:[a.SpatialUnits,"data"],y_units:[a.SpatialUnits,"data"],text:[a.StringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,{value:0}],y_offset:[a.NumberSpec,{value:0}],source:[a.Instance,function(){return new n.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},e}(o.TextAnnotation);i.LabelSet=c,c.__name__="LabelSet",c.init_LabelSet()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var l=t(1),n=t(137),r=l.__importStar(t(127)),a=t(122),s=t(239),h=t(193),o=t(117),_=t(131),d=t(116),c=t(119),g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.cursor=function(t,e){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(e.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.item_change,(function(){return e.plot_view.request_render()}))},e.prototype.compute_legend_bbox=function(){var t=this.model.get_legend_names(),e=this.model,i=e.glyph_height,l=e.glyph_width,n=this.model,r=n.label_height,a=n.label_width;this.max_label_height=o.max([s.measure_font(this.visuals.label_text.font_value()).height,r,i]);var g=this.plot_view.canvas_view.ctx;g.save(),this.visuals.label_text.set_value(g),this.text_widths={};for(var u=0,m=t;u<m.length;u++){var p=m[u];this.text_widths[p]=o.max([g.measureText(p).width,a])}this.visuals.title_text.set_value(g),this.title_height=this.model.title?s.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?g.measureText(this.model.title).width:0,g.restore();var f,v,b=Math.max(o.max(_.values(this.text_widths)),0),x=this.model.margin,w=this.legend_padding,y=this.model.spacing,k=this.model.label_standoff;if("vertical"==this.model.orientation)f=t.length*this.max_label_height+Math.max(t.length-1,0)*y+2*w+this.title_height,v=o.max([b+l+k+2*w,this.title_width+2*w]);else{var N=2*w+Math.max(t.length-1,0)*y;for(var p in this.text_widths){var A=this.text_widths[p];N+=o.max([A,a])+l+k}v=o.max([this.title_width+2*w,N]),f=this.max_label_height+this.title_height+2*w}var L,z,B=null!=this.panel?this.panel:this.plot_view.frame,M=B.bbox.ranges,P=M[0],S=M[1],T=this.model.location;if(d.isString(T))switch(T){case"top_left":L=P.start+x,z=S.start+x;break;case"top_center":L=(P.end+P.start)/2-v/2,z=S.start+x;break;case"top_right":L=P.end-x-v,z=S.start+x;break;case"bottom_right":L=P.end-x-v,z=S.end-x-f;break;case"bottom_center":L=(P.end+P.start)/2-v/2,z=S.end-x-f;break;case"bottom_left":L=P.start+x,z=S.end-x-f;break;case"center_left":L=P.start+x,z=(S.end+S.start)/2-f/2;break;case"center":L=(P.end+P.start)/2-v/2,z=(S.end+S.start)/2-f/2;break;case"center_right":L=P.end-x-v,z=(S.end+S.start)/2-f/2}else if(d.isArray(T)&&2==T.length){var O=T[0],V=T[1];L=B.xview.compute(O),z=B.yview.compute(V)-f}else c.unreachable();return new h.BBox({left:L,top:z,width:v,height:f})},e.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},e.prototype.interactive_hit=function(t,e){return this.interactive_bbox().contains(t,e)},e.prototype.on_hit=function(t,e){for(var i,l,n,r=this.model.glyph_width,a=this.legend_padding,s=this.model.spacing,o=this.model.label_standoff,_=n=a,d=this.compute_legend_bbox(),c="vertical"==this.model.orientation,g=0,u=this.model.items;g<u.length;g++)for(var m=u[g],p=0,f=m.get_labels_list_from_label_prop();p<f.length;p++){var v=f[p],b=d.x+_,x=d.y+n+this.title_height,w=void 0,y=void 0;if(c?(w=(i=[d.width-2*a,this.max_label_height])[0],y=i[1]):(w=(l=[this.text_widths[v]+r+o,this.max_label_height])[0],y=l[1]),new h.BBox({left:b,top:x,width:w,height:y}).contains(t,e)){switch(this.model.click_policy){case"hide":for(var k=0,N=m.renderers;k<N.length;k++){(z=N[k]).visible=!z.visible}break;case"mute":for(var A=0,L=m.renderers;A<L.length;A++){var z;(z=L[A]).muted=!z.muted}}return!0}c?n+=this.max_label_height+s:_+=this.text_widths[v]+r+o+s}return!1},e.prototype.render=function(){if(this.model.visible&&0!=this.model.items.length){for(var t=0,e=this.model.items;t<e.length;t++){e[t].legend=this.model}var i=this.plot_view.canvas_view.ctx,l=this.compute_legend_bbox();i.save(),this._draw_legend_box(i,l),this._draw_legend_items(i,l),this.model.title&&this._draw_title(i,l),i.restore()}},e.prototype._draw_legend_box=function(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())},e.prototype._draw_legend_items=function(t,e){for(var i=this,l=this.model,n=l.glyph_width,r=l.glyph_height,a=this.legend_padding,s=this.model.spacing,h=this.model.label_standoff,_=a,d=a,c="vertical"==this.model.orientation,g=function(l){var g,m,p=l.get_labels_list_from_label_prop(),f=l.get_field_from_label_prop();if(0==p.length)return"continue";for(var v=function(){switch(i.model.click_policy){case"none":return!0;case"hide":return o.every(l.renderers,(function(t){return t.visible}));case"mute":return o.every(l.renderers,(function(t){return!t.muted}))}}(),b=0,x=p;b<x.length;b++){var w=x[b],y=e.x+_,k=e.y+d+u.title_height,N=y+n,A=k+r;c?d+=u.max_label_height+s:_+=u.text_widths[w]+n+h+s,u.visuals.label_text.set_value(t),t.fillText(w,N+h,k+u.max_label_height/2);for(var L=0,z=l.renderers;L<z.length;L++){var B=z[L];u.plot_view.renderer_views[B.id].draw_legend(t,y,N,k,A,f,w,l.index)}if(!v){var M=void 0,P=void 0;c?(M=(g=[e.width-2*a,u.max_label_height])[0],P=g[1]):(M=(m=[u.text_widths[w]+n+h,u.max_label_height])[0],P=m[1]),t.beginPath(),t.rect(y,k,M,P),u.visuals.inactive_fill.set_value(t),t.fill()}}},u=this,m=0,p=this.model.items;m<p.length;m++){g(p[m])}},e.prototype._draw_title=function(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())},e.prototype._get_size=function(){var t=this.compute_legend_bbox(),e=t.width,i=t.height;return{width:e+2*this.model.margin,height:i+2*this.model.margin}},e}(n.AnnotationView);i.LegendView=g,g.__name__="LegendView";var u=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.item_change=new a.Signal0(this,"item_change")},e.init_Legend=function(){this.prototype.default_view=g,this.mixins(["text:label_","text:title_","fill:inactive_","line:border_","fill:background_"]),this.define({orientation:[r.Orientation,"vertical"],location:[r.Any,"top_right"],title:[r.String],title_standoff:[r.Number,5],label_standoff:[r.Number,5],glyph_height:[r.Number,20],glyph_width:[r.Number,20],label_height:[r.Number,20],label_width:[r.Number,20],margin:[r.Number,10],padding:[r.Number,10],spacing:[r.Number,3],items:[r.Array,[]],click_policy:[r.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"10pt",label_text_baseline:"middle",title_text_font_size:"10pt",title_text_font_style:"italic"})},e.prototype.get_legend_names=function(){for(var t=[],e=0,i=this.items;e<i.length;e++){var l=i[e].get_labels_list_from_label_prop();t.push.apply(t,l)}return t},e}(n.Annotation);i.Legend=u,u.__name__="Legend",u.init_Legend()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(1),l=e(177),i=e(182),o=e(245),a=t.__importStar(e(127)),_=e(178),s=e(117),u=function(e){function r(r){return e.call(this,r)||this}return t.__extends(r,e),r.init_LegendItem=function(){this.define({label:[a.StringSpec,null],renderers:[a.Array,[]],index:[a.Number,null]})},r.prototype._check_data_sources_on_renderers=function(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e)for(var r=0,n=this.renderers;r<n.length;r++){if(n[r].data_source!=e)return!1}}return!0},r.prototype._check_field_label_on_data_source=function(){var e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;var r=this.renderers[0].data_source;if(null!=r&&!s.includes(r.columns(),e))return!1}return!0},r.prototype.initialize=function(){var r=this;e.prototype.initialize.call(this),this.legend=null,this.connect(this.change,(function(){null!=r.legend&&r.legend.item_change.emit()})),this._check_data_sources_on_renderers()||_.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||_.logger.error("Bad column name on label: "+this.label)},r.prototype.get_field_from_label_prop=function(){var e=this.label;return o.isField(e)?e.field:null},r.prototype.get_labels_list_from_label_prop=function(){if(o.isValue(this.label)){var e=this.label.value;return null!=e?[e]:[]}var r=this.get_field_from_label_prop();if(null!=r){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof i.ColumnarDataSource){var t=n.get_column(r);return null!=t?s.uniq(Array.from(t)):["Invalid field"]}}return[]},r}(l.Model);n.LegendItem=u,u.__name__="LegendItem",u.init_LegendItem()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var t=e(116);n.isValue=function(e){return t.isPlainObject(e)&&"value"in e},n.isField=function(e){return t.isPlainObject(e)&&"field"in e}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(137),s=t(122),l=n.__importStar(t(127)),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.plot_view.request_render()})),this.connect(this.model.data_update,(function(){return e.plot_view.request_render()}))},e.prototype.render=function(){if(this.model.visible){var t=this.model,e=t.xs,i=t.ys;if(e.length==i.length&&!(e.length<3||i.length<3)){for(var n=this.plot_view.frame,o=this.plot_view.canvas_view.ctx,s=0,l=e.length;s<l;s++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?e[s]:n.xview.compute(e[s]);var r=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");r=this.model.screen?i[s]:n.yview.compute(i[s]),0==s?(o.beginPath(),o.moveTo(a,r)):o.lineTo(a,r)}o.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(o),o.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(o),o.fill())}}},e}(o.AnnotationView);i.PolyAnnotationView=a,a.__name__="PolyAnnotationView";var r=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_PolyAnnotation=function(){this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({xs:[l.Array,[]],xs_units:[l.SpatialUnits,"data"],ys:[l.Array,[]],ys_units:[l.SpatialUnits,"data"],x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]}),this.internal({screen:[l.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data_update=new s.Signal0(this,"data_update")},e.prototype.update=function(t){var e=t.xs,i=t.ys;this.setv({xs:e,ys:i,screen:!0},{silent:!0}),this.data_update.emit()},e}(o.Annotation);i.PolyAnnotation=r,r.__name__="PolyAnnotation",r.init_PolyAnnotation()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),o=e(137),l=i.__importStar(e(127)),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_render()}))},t.prototype.render=function(){this.model.visible&&this._draw_slope()},t.prototype._draw_slope=function(){var e=this.model.gradient,t=this.model.y_intercept;if(null!=e&&null!=t){var n=this.plot_view.frame,i=n.xscales[this.model.x_range_name],o=n.yscales[this.model.y_range_name],l=n._top.value,r=l+n._height.value,a=(o.invert(l)-t)/e,s=(o.invert(r)-t)/e,_=i.compute(a),u=i.compute(s),p=this.plot_view.canvas_view.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(_,l),p.lineTo(u,r),p.stroke(),p.restore()}},t}(o.AnnotationView);n.SlopeView=r,r.__name__="SlopeView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Slope=function(){this.prototype.default_view=r,this.mixins(["line"]),this.define({gradient:[l.Number,null],y_intercept:[l.Number,null],x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]}),this.override({line_color:"black"})},t}(o.Annotation);n.Slope=a,a.__name__="Slope",a.init_Slope()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),o=e(137),l=e(174),s=n.__importStar(e(127)),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.plot_view.canvas_view.add_overlay(this.el),this.el.style.position="absolute",l.undisplay(this.el)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.model.for_hover?this.connect(this.model.properties.computed_location.change,(function(){return t._draw_span()})):"canvas"==this.model.render_mode?(this.connect(this.model.change,(function(){return t.plot_view.request_render()})),this.connect(this.model.properties.location.change,(function(){return t.plot_view.request_render()}))):(this.connect(this.model.change,(function(){return t.render()})),this.connect(this.model.properties.location.change,(function(){return t._draw_span()})))},t.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),this.model.visible&&this._draw_span()},t.prototype._draw_span=function(){var e=this,t=this.model.for_hover?this.model.computed_location:this.model.location;if(null!=t){var i,n,o,s,a=this.plot_view.frame,r=a.xscales[this.model.x_range_name],h=a.yscales[this.model.y_range_name],d=function(i,n){return e.model.for_hover?e.model.computed_location:"data"==e.model.location_units?i.compute(t):n.compute(t)};if("width"==this.model.dimension?(o=d(h,a.yview),n=a._left.value,s=a._width.value,i=this.model.properties.line_width.value()):(o=a._top.value,n=d(r,a.xview),s=this.model.properties.line_width.value(),i=a._height.value),"css"==this.model.render_mode)this.el.style.top=o+"px",this.el.style.left=n+"px",this.el.style.width=s+"px",this.el.style.height=i+"px",this.el.style.backgroundColor=this.model.properties.line_color.value(),this.el.style.opacity=this.model.properties.line_alpha.value(),l.display(this.el);else if("canvas"==this.model.render_mode){var _=this.plot_view.canvas_view.ctx;_.save(),_.beginPath(),this.visuals.line.set_value(_),_.moveTo(n,o),"width"==this.model.dimension?_.lineTo(n+s,o):_.lineTo(n,o+i),_.stroke(),_.restore()}}else l.undisplay(this.el)},t}(o.AnnotationView);i.SpanView=a,a.__name__="SpanView";var r=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Span=function(){this.prototype.default_view=a,this.mixins(["line"]),this.define({render_mode:[s.RenderMode,"canvas"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],location:[s.Number,null],location_units:[s.SpatialUnits,"data"],dimension:[s.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[s.Boolean,!1],computed_location:[s.Number,null]})},t}(o.Annotation);i.Span=r,r.__name__="Span",r.init_Span()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var l=e(1),a=e(241),n=e(174),s=e(176),o=l.__importStar(e(127)),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals.text=new s.Text(this.model)},t.prototype._get_location=function(){var e,t,i=this.panel,l=this.model.offset;switch(i.side){case"above":case"below":switch(this.model.vertical_align){case"top":t=i._top.value+5;break;case"middle":t=i._vcenter.value;break;case"bottom":t=i._bottom.value-5}switch(this.model.align){case"left":e=i._left.value+l;break;case"center":e=i._hcenter.value;break;case"right":e=i._right.value-l}break;case"left":switch(this.model.vertical_align){case"top":e=i._left.value-5;break;case"middle":e=i._hcenter.value;break;case"bottom":e=i._right.value+5}switch(this.model.align){case"left":t=i._bottom.value-l;break;case"center":t=i._vcenter.value;break;case"right":t=i._top.value+l}break;case"right":switch(this.model.vertical_align){case"top":e=i._right.value-5;break;case"middle":e=i._hcenter.value;break;case"bottom":e=i._left.value+5}switch(this.model.align){case"left":t=i._top.value+l;break;case"center":t=i._vcenter.value;break;case"right":t=i._bottom.value-l}}return[e,t]},t.prototype.render=function(){if(this.model.visible){var e=this.model.text;if(null!=e&&0!=e.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var t=this._get_location(),i=t[0],l=t[1],a=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.plot_view.canvas_view.ctx,e,i,l,a)}}else"css"==this.model.render_mode&&n.undisplay(this.el)},t.prototype._get_size=function(){var e=this.model.text;if(null==e||0==e.length)return{width:0,height:0};this.visuals.text.set_value(this.ctx);var t=this.ctx.measureText(e);return{width:t.width,height:t.ascent*this.visuals.text.text_line_height.value()+10}},t}(a.TextAnnotationView);i.TitleView=r,r.__name__="TitleView";var _=function(e){function t(t){return e.call(this,t)||this}return l.__extends(t,e),t.init_Title=function(){this.prototype.default_view=r,this.mixins(["line:border_","fill:background_"]),this.define({text:[o.String],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeSpec,"10pt"],text_font_style:[o.FontStyle,"bold"],text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_line_height:[o.Number,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[o.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]})},t}(a.TextAnnotation);i.Title=_,_.__name__="Title",_.init_Title()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),n=t(137),l=t(204),r=t(174),a=o.__importStar(t(127)),s=function(t){function e(){var e=t.apply(this,arguments)||this;return e.rotate=!0,e}return o.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_view.add_event(this.el)},e.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){var t,e=this;return o.__generator(this,(function(i){switch(i.label){case 0:return t=this,[4,l.build_view(this.model.toolbar,{parent:this})];case 1:return t._toolbar_view=i.sent(),this.plot_view.visibility_callbacks.push((function(t){return e._toolbar_view.set_visibility(t)})),[2]}}))}))},e.prototype.remove=function(){this._toolbar_view.remove(),t.prototype.remove.call(this)},e.prototype.render=function(){t.prototype.render.call(this),this.model.visible?(this.el.style.position="absolute",this.el.style.overflow="hidden",r.position(this.el,this.panel.bbox),this._toolbar_view.render(),r.empty(this.el),this.el.appendChild(this._toolbar_view.el),r.display(this.el)):r.undisplay(this.el)},e.prototype._get_size=function(){var t=this.model.toolbar,e=t.tools,i=t.logo;return{width:30*e.length+(null!=i?25:0),height:30}},e}(n.AnnotationView);i.ToolbarPanelView=s,s.__name__="ToolbarPanelView";var _=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ToolbarPanel=function(){this.prototype.default_view=s,this.define({toolbar:[a.Instance]})},e}(n.Annotation);i.ToolbarPanel=_,_.__name__="ToolbarPanel",_.init_ToolbarPanel()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),o=t(137),l=t(174),a=s.__importStar(t(127)),n=t(252),h=t(253);function r(t,e,i,s,o){switch(t){case"horizontal":return e<s?"right":"left";case"vertical":return i<o?"below":"above";default:return t}}i.compute_side=r;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.plot_view.canvas_view.add_overlay(this.el),l.undisplay(this.el)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,(function(){return e._draw_tips()}))},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(n.bk_tooltip)},e.prototype.render=function(){this.model.visible&&this._draw_tips()},e.prototype._draw_tips=function(){var t=this.model.data;if(l.empty(this.el),l.undisplay(this.el),this.model.custom?this.el.classList.add(n.bk_tooltip_custom):this.el.classList.remove(n.bk_tooltip_custom),0!=t.length){for(var e=this.plot_view.frame,i=0,s=t;i<s.length;i++){var o=s[i],a=o[0],c=o[1],d=o[2];if(!this.model.inner_only||e.bbox.contains(a,c)){var p=l.div({},d);this.el.appendChild(p)}}var _=t[t.length-1],u=_[0],f=_[1],v=r(this.model.attachment,u,f,e._hcenter.value,e._vcenter.value);this.el.classList.remove(h.bk_right),this.el.classList.remove(h.bk_left),this.el.classList.remove(h.bk_above),this.el.classList.remove(h.bk_below);var b;l.display(this.el);var y=0,m=0;switch(v){case"right":this.el.classList.add(h.bk_left),y=u+(this.el.offsetWidth-this.el.clientWidth)+10,b=f-this.el.offsetHeight/2;break;case"left":this.el.classList.add(h.bk_right),m=this.plot_view.layout.bbox.width-u+10,b=f-this.el.offsetHeight/2;break;case"below":this.el.classList.add(h.bk_above),b=f+(this.el.offsetHeight-this.el.clientHeight)+10,y=Math.round(u-this.el.offsetWidth/2);break;case"above":this.el.classList.add(h.bk_below),b=f-this.el.offsetHeight-10,y=Math.round(u-this.el.offsetWidth/2)}this.model.show_arrow&&this.el.classList.add(n.bk_tooltip_arrow),this.el.childNodes.length>0?(this.el.style.top=b+"px",this.el.style.left=y?y+"px":"auto",this.el.style.right=m?m+"px":"auto"):l.undisplay(this.el)}},e}(o.AnnotationView);i.TooltipView=c,c.__name__="TooltipView";var d=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Tooltip=function(){this.prototype.default_view=c,this.define({attachment:[a.TooltipAttachment,"horizontal"],inner_only:[a.Boolean,!0],show_arrow:[a.Boolean,!0]}),this.override({level:"overlay"}),this.internal({data:[a.Any,[]],custom:[a.Any]})},e.prototype.clear=function(){this.data=[]},e.prototype.add=function(t,e,i){this.data=this.data.concat([[t,e,i]])},e}(o.Annotation);i.Tooltip=d,d.__name__="Tooltip",d.init_Tooltip()},
function _(o,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=o(1);o(175),r.__importStar(o(174)).styles.append('.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'),n.bk_tooltip="bk-tooltip",n.bk_tooltip_arrow="bk-tooltip-arrow",n.bk_tooltip_custom="bk-tooltip-custom",n.bk_tooltip_row_label="bk-tooltip-row-label",n.bk_tooltip_row_value="bk-tooltip-row-value",n.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(e,b,t){Object.defineProperty(t,"__esModule",{value:!0}),e(1).__importStar(e(174)).styles.append(""),t.bk_active="bk-active",t.bk_inline="bk-inline",t.bk_left="bk-left",t.bk_right="bk-right",t.bk_above="bk-above",t.bk_below="bk-below",t.bk_up="bk-up",t.bk_down="bk-down",t.bk_side=function(e){switch(e){case"above":return t.bk_above;case"below":return t.bk_below;case"left":return t.bk_left;case"right":return t.bk_right}}},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),n=e(137),r=e(181),o=e(180),a=s.__importStar(e(127)),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.set_data(this.model.source)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.patching,(function(){return t.set_data(t.model.source)})),this.connect(this.model.source.change,(function(){return t.set_data(t.model.source)}))},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var e,t,i,s=this.plot_view.frame,n=this.model.dimension,r=s.xscales[this.model.x_range_name],o=s.yscales[this.model.y_range_name],a="height"==n?o:r,h="height"==n?r:o,_="height"==n?s.yview:s.xview,l="height"==n?s.xview:s.yview;e="data"==this.model.properties.lower.units?a.v_compute(this._lower):_.v_compute(this._lower),t="data"==this.model.properties.upper.units?a.v_compute(this._upper):_.v_compute(this._upper),i="data"==this.model.properties.base.units?h.v_compute(this._base):l.v_compute(this._base);var u="height"==n?[1,0]:[0,1],p=u[0],c=u[1],d=[e,i],m=[t,i];this._lower_sx=d[p],this._lower_sy=d[c],this._upper_sx=m[p],this._upper_sy=m[c]},t.prototype.render=function(){if(this.model.visible){this._map_data();var e=this.plot_view.canvas_view.ctx;if(this.visuals.line.doit)for(var t=0,i=this._lower_sx.length;t<i;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();var s="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(t=0,i=this._lower_sx.length;t<i;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(s+Math.PI),this.model.lower_head.render(e,t),e.restore();if(null!=this.model.upper_head)for(t=0,i=this._upper_sx.length;t<i;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(s),this.model.upper_head.render(e,t),e.restore()}},t}(n.AnnotationView);i.WhiskerView=h,h.__name__="WhiskerView";var _=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Whisker=function(){this.prototype.default_view=h,this.mixins(["line"]),this.define({lower:[a.DistanceSpec],lower_head:[a.Instance,function(){return new o.TeeHead({level:"underlay",size:10})}],upper:[a.DistanceSpec],upper_head:[a.Instance,function(){return new o.TeeHead({level:"underlay",size:10})}],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,function(){return new r.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({level:"underlay"})},t}(n.Annotation);i.Whisker=_,_.__name__="Whisker",_.init_Whisker()},
function _(i,a,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(256);e.Axis=r.Axis;var s=i(258);e.CategoricalAxis=s.CategoricalAxis;var x=i(261);e.ContinuousAxis=x.ContinuousAxis;var A=i(262);e.DatetimeAxis=A.DatetimeAxis;var o=i(263);e.LinearAxis=o.LinearAxis;var t=i(276);e.LogAxis=t.LogAxis;var n=i(279);e.MercatorAxis=n.MercatorAxis},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),r=e(257),n=a.__importStar(e(127)),o=e(117),s=e(116),l=e(196),_=Math.abs,h=Math.min,u=Math.max,c=function(e){function t(){var t=e.apply(this,arguments)||this;return t.rotate=!0,t}return a.__extends(t,e),Object.defineProperty(t.prototype,"panel",{get:function(){return this.layout},enumerable:!0,configurable:!0}),t.prototype.render=function(){if(this.model.visible){var e={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},t=this.tick_coords,i=this.plot_view.canvas_view.ctx;i.save(),this._draw_rule(i,e),this._draw_major_ticks(i,e,t),this._draw_minor_ticks(i,e,t),this._draw_major_labels(i,e,t),this._draw_axis_label(i,e,t),null!=this._render&&this._render(i,e,t),i.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_paint()}));var i=this.model.properties;this.on_change(i.visible,(function(){return t.plot_view.request_layout()}))},t.prototype.get_size=function(){if(this.model.visible&&null==this.model.fixed_location){var e=this._get_size();return{width:0,height:Math.round(e)}}return{width:0,height:0}},t.prototype._get_size=function(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!0,configurable:!0}),t.prototype._draw_rule=function(e,t){if(this.visuals.axis_line.doit){var i=this.rule_coords,a=i[0],r=i[1],n=this.plot_view.map_to_screen(a,r,this.model.x_range_name,this.model.y_range_name),o=n[0],s=n[1],l=this.normals,_=l[0],h=l[1],u=this.offsets,c=u[0],d=u[1];this.visuals.axis_line.set_value(e),e.beginPath(),e.moveTo(Math.round(o[0]+_*c),Math.round(s[0]+h*d));for(var m=1;m<o.length;m++){var p=Math.round(o[m]+_*c),b=Math.round(s[m]+h*d);e.lineTo(p,b)}e.stroke()}},t.prototype._draw_major_ticks=function(e,t,i){var a=this.model.major_tick_in,r=this.model.major_tick_out,n=this.visuals.major_tick_line;this._draw_ticks(e,i.major,a,r,n)},t.prototype._draw_minor_ticks=function(e,t,i){var a=this.model.minor_tick_in,r=this.model.minor_tick_out,n=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,a,r,n)},t.prototype._draw_major_labels=function(e,t,i){var a=i.major,r=this.compute_labels(a[this.dimension]),n=this.model.major_label_orientation,o=t.tick+this.model.major_label_standoff,s=this.visuals.major_label_text;this._draw_oriented_labels(e,r,a,n,this.panel.side,o,s)},t.prototype._draw_axis_label=function(e,t,i){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var a,r;switch(this.panel.side){case"above":a=this.panel._hcenter.value,r=this.panel._bottom.value;break;case"below":a=this.panel._hcenter.value,r=this.panel._top.value;break;case"left":a=this.panel._right.value,r=this.panel._vcenter.value;break;case"right":a=this.panel._left.value,r=this.panel._vcenter.value;break;default:throw new Error("unknown side: "+this.panel.side)}var n=[[a],[r]],s=t.tick+o.sum(t.tick_label)+this.model.axis_label_standoff,l=this.visuals.axis_label_text;this._draw_oriented_labels(e,[this.model.axis_label],n,"parallel",this.panel.side,s,l,"screen")}},t.prototype._draw_ticks=function(e,t,i,a,r){if(r.doit){var n=t[0],o=t[1],s=this.plot_view.map_to_screen(n,o,this.model.x_range_name,this.model.y_range_name),l=s[0],_=s[1],h=this.normals,u=h[0],c=h[1],d=this.offsets,m=d[0],p=d[1],b=[u*(m-i),c*(p-i)],f=b[0],v=b[1],x=[u*(m+a),c*(p+a)],g=x[0],y=x[1];r.set_value(e);for(var k=0;k<l.length;k++){var w=Math.round(l[k]+g),j=Math.round(_[k]+y),M=Math.round(l[k]+f),A=Math.round(_[k]+v);e.beginPath(),e.moveTo(w,j),e.lineTo(M,A),e.stroke()}}},t.prototype._draw_oriented_labels=function(e,t,i,a,r,n,o,l){var _,h,u;if(void 0===l&&(l="data"),o.doit&&0!=t.length){var c,d,m,p;if("screen"==l)c=i[0],d=i[1],m=(_=[0,0])[0],p=_[1];else{var b=i[0],f=i[1];c=(h=this.plot_view.map_to_screen(b,f,this.model.x_range_name,this.model.y_range_name))[0],d=h[1],m=(u=this.offsets)[0],p=u[1]}var v,x=this.normals,g=x[0]*(m+n),y=x[1]*(p+n);o.set_value(e),this.panel.apply_label_text_heuristics(e,a),v=s.isString(a)?this.panel.get_label_angle_heuristic(a):-a;for(var k=0;k<c.length;k++){var w=Math.round(c[k]+g),j=Math.round(d[k]+y);e.translate(w,j),e.rotate(v),e.fillText(t[k],0,0),e.rotate(-v),e.translate(-w,-j)}}},t.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var e=this.model.axis_label_standoff,t=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,e,t)},t.prototype._tick_extent=function(){return this.model.major_tick_out},t.prototype._tick_label_extent=function(){return o.sum(this._tick_label_extents())},t.prototype._tick_label_extents=function(){var e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,a=this.model.major_label_standoff,r=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,this.panel.side,a,r)]},t.prototype._oriented_labels_extent=function(e,t,i,a,r){if(0==e.length)return 0;var n,o,l=this.plot_view.canvas_view.ctx;r.set_value(l),s.isString(t)?(n=1,o=this.panel.get_label_angle_heuristic(t)):(n=2,o=-t),o=Math.abs(o);for(var _=Math.cos(o),h=Math.sin(o),u=0,c=0;c<e.length;c++){var d=1.1*l.measureText(e[c]).width,m=.9*l.measureText(e[c]).ascent,p=void 0;(p="above"==i||"below"==i?d*h+m/n*_:d*_+m/n*h)>u&&(u=p)}return u>0&&(u+=a),u},Object.defineProperty(t.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!0,configurable:!0}),t.prototype.compute_labels=function(e){for(var t=this.model.formatter.doFormat(e,this),i=0;i<e.length;i++)e[i]in this.model.major_label_overrides&&(t[i]=this.model.major_label_overrides[e[i]]);return t},Object.defineProperty(t.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var e=this.plot_view.frame,t=[0,0],i=t[0],a=t[1];switch(this.panel.side){case"below":a=_(this.panel._top.value-e._bottom.value);break;case"above":a=_(this.panel._bottom.value-e._top.value);break;case"right":i=_(this.panel._left.value-e._right.value);break;case"left":i=_(this.panel._right.value-e._left.value)}return[i,a]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){var e=this.dimension,t=(e+1)%2,i=this.plot_view.frame,a=[i.x_ranges[this.model.x_range_name],i.y_ranges[this.model.y_range_name]];return[a[e],a[t]]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_bounds",{get:function(){var e=this.ranges[0],t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];if(s.isArray(t)){var a=void 0,r=void 0,n=t[0],o=t[1],l=i[0],c=i[1];return _(n-o)>_(l-c)?(a=u(h(n,o),l),r=h(u(n,o),c)):(a=h(n,o),r=u(n,o)),[a,r]}throw new Error("user bounds '"+t+"' not understood")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rule_coords",{get:function(){var e=this.dimension,t=(e+1)%2,i=this.ranges[0],a=this.computed_bounds,r=a[0],n=a[1],o=[new Array(2),new Array(2)];return o[e][0]=Math.max(r,i.min),o[e][1]=Math.min(n,i.max),o[e][0]>o[e][1]&&(o[e][0]=o[e][1]=NaN),o[t][0]=this.loc,o[t][1]=this.loc,o},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tick_coords",{get:function(){for(var e=this.dimension,t=(e+1)%2,i=this.ranges[0],a=this.computed_bounds,r=a[0],n=a[1],o=this.model.ticker.get_ticks(r,n,i,this.loc,{}),s=o.major,l=o.minor,_=[[],[]],h=[[],[]],u=[i.min,i.max],c=u[0],d=u[1],m=0;m<s.length;m++)s[m]<c||s[m]>d||(_[e].push(s[m]),_[t].push(this.loc));for(m=0;m<l.length;m++)l[m]<c||l[m]>d||(h[e].push(l[m]),h[t].push(this.loc));return{major:_,minor:h}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"loc",{get:function(){var e=this.model.fixed_location;if(null!=e){if(s.isNumber(e))return e;var t=this.ranges[1];if(t instanceof l.FactorRange)return t.synthetic(e);throw new Error("unexpected")}var i=this.ranges[1];switch(this.panel.side){case"left":case"below":return i.start;case"right":case"above":return i.end}},enumerable:!0,configurable:!0}),t.prototype.serializable_state=function(){return Object.assign(Object.assign({},e.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box})},t}(r.GuideRendererView);i.AxisView=c,c.__name__="AxisView";var d=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Axis=function(){this.prototype.default_view=c,this.mixins(["line:axis_","line:major_tick_","line:minor_tick_","text:major_label_","text:axis_label_"]),this.define({bounds:[n.Any,"auto"],ticker:[n.Instance],formatter:[n.Instance],x_range_name:[n.String,"default"],y_range_name:[n.String,"default"],axis_label:[n.String,""],axis_label_standoff:[n.Int,5],major_label_standoff:[n.Int,5],major_label_orientation:[n.Any,"horizontal"],major_label_overrides:[n.Any,{}],major_tick_in:[n.Number,2],major_tick_out:[n.Number,6],minor_tick_in:[n.Number,0],minor_tick_out:[n.Number,4],fixed_location:[n.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"8pt",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"10pt",axis_label_text_font_style:"italic"})},t}(r.GuideRenderer);i.Axis=d,d.__name__="Axis",d.init_Axis()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),t=e(171),d=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n}(t.RendererView);r.GuideRendererView=d,d.__name__="GuideRendererView";var u=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_GuideRenderer=function(){this.override({level:"overlay"})},n}(t.Renderer);r.GuideRenderer=u,u.__name__="GuideRenderer",u.init_GuideRenderer()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),r=t(256),s=t(259),a=t(260),n=i.__importStar(t(127)),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._render=function(t,e,o){this._draw_group_separators(t,e,o)},e.prototype._draw_group_separators=function(t,e,o){var i,r=this.ranges[0],s=this.computed_bounds,a=s[0],n=s[1];if(r.tops&&!(r.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,_=(l+1)%2,u=[[],[]],p=0,h=0;h<r.tops.length-1;h++){for(var c=void 0,m=void 0,d=p;d<r.factors.length;d++)if(r.factors[d][0]==r.tops[h+1]){c=(i=[r.factors[d-1],r.factors[d]])[0],m=i[1],p=d;break}var f=(r.synthetic(c)+r.synthetic(m))/2;f>a&&f<n&&(u[l].push(f),u[_].push(this.loc))}var g=this._tick_label_extent();this._draw_ticks(t,u,-3,g-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,o){for(var i=this._get_factor_info(),r=e.tick+this.model.major_label_standoff,s=0;s<i.length;s++){var a=i[s],n=a[0],l=a[1],_=a[2],u=a[3];this._draw_oriented_labels(t,n,l,_,this.panel.side,r,u),r+=e.tick_label[s]}},e.prototype._tick_label_extents=function(){for(var t=[],e=0,o=this._get_factor_info();e<o.length;e++){var i=o[e],r=i[0],s=i[2],a=i[3],n=this._oriented_labels_extent(r,s,this.panel.side,this.model.major_label_standoff,a);t.push(n)}return t},e.prototype._get_factor_info=function(){var t=this.ranges[0],e=this.computed_bounds,o=e[0],i=e[1],r=this.loc,s=this.model.ticker.get_ticks(o,i,t,r,{}),a=this.tick_coords,n=[];if(1==t.levels){var l=s.major,_=this.model.formatter.doFormat(l,this);n.push([_,a.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){l=s.major.map((function(t){return t[1]})),_=this.model.formatter.doFormat(l,this);n.push([_,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),n.push([s.tops,a.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){l=s.major.map((function(t){return t[2]})),_=this.model.formatter.doFormat(l,this);var u=s.mids.map((function(t){return t[1]}));n.push([_,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),n.push([u,a.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),n.push([s.tops,a.tops,this.model.group_label_orientation,this.visuals.group_text])}return n},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,o=(e+1)%2,i=this.ranges[0],r=this.computed_bounds,s=r[0],a=r[1],n=this.model.ticker.get_ticks(s,a,i,this.loc,{}),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=n.major,l.major[o]=n.major.map((function(e){return t.loc})),3==i.levels&&(l.mids[e]=n.mids,l.mids[o]=n.mids.map((function(e){return t.loc}))),i.levels>1&&(l.tops[e]=n.tops,l.tops[o]=n.tops.map((function(e){return t.loc}))),l},enumerable:!0,configurable:!0}),e}(r.AxisView);o.CategoricalAxisView=l,l.__name__="CategoricalAxisView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_CategoricalAxis=function(){this.prototype.default_view=l,this.mixins(["line:separator_","text:group_","text:subgroup_"]),this.define({group_label_orientation:[n.Any,"parallel"],subgroup_label_orientation:[n.Any,"parallel"]}),this.override({ticker:function(){return new s.CategoricalTicker},formatter:function(){return new a.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"8pt",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"8pt"})},e}(r.Axis);o.CategoricalAxis=_,_.__name__="CategoricalAxis",_.init_CategoricalAxis()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var c=t(1),o=function(t){function e(e){return t.call(this,e)||this}return c.__extends(e,t),e.prototype.get_ticks=function(t,e,r,c,o){return{major:this._collect(r.factors,r,t,e),minor:[],tops:this._collect(r.tops||[],r,t,e),mids:this._collect(r.mids||[],r,t,e)}},e.prototype._collect=function(t,e,r,c){for(var o=[],i=0,n=t;i<n.length;i++){var l=n[i],s=e.synthetic(l);s>r&&s<c&&o.push(l)}return o},e}(t(219).Ticker);r.CategoricalTicker=o,o.__name__="CategoricalTicker"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=t(1),n=t(221),a=t(117),c=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.prototype.doFormat=function(t,e){return a.copy(t)},e}(n.TickFormatter);r.CategoricalTickFormatter=c,c.__name__="CategoricalTickFormatter"},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=n(1),u=function(n){function e(e){return n.call(this,e)||this}return i.__extends(e,n),e}(n(256).Axis);t.ContinuousAxis=u,u.__name__="ContinuousAxis"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(263),a=e(264),u=e(269),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t}(r.LinearAxisView);i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_DatetimeAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new u.DatetimeTicker},formatter:function(){return new a.DatetimeTickFormatter}})},t}(r.LinearAxis);i.DatetimeAxis=s,s.__name__="DatetimeAxis",s.init_DatetimeAxis()},
function _(i,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=i(1),r=i(256),s=i(261),u=i(220),a=i(216),_=function(i){function n(){return null!==i&&i.apply(this,arguments)||this}return t.__extends(n,i),n}(r.AxisView);e.LinearAxisView=_,_.__name__="LinearAxisView";var o=function(i){function n(n){return i.call(this,n)||this}return t.__extends(n,i),n.init_LinearAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new a.BasicTicker},formatter:function(){return new u.BasicTickFormatter}})},n}(s.ContinuousAxis);e.LinearAxis=o,o.__name__="LinearAxis",o.init_LinearAxis()},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),s=i.__importDefault(t(265)),n=t(221),o=t(178),a=i.__importStar(t(127)),u=t(266),c=t(117),m=t(116);function h(t){return s.default(t,"%Y %m %d %H %M %S").split(/\s+/).map((function(t){return parseInt(t,10)}))}function d(t,r){if(m.isFunction(r))return r(t);var e=u.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(r=r.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?r:s.default(t,r)}var f=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],l=function(t){function r(r){var e=t.call(this,r)||this;return e.strip_leading_zeros=!0,e}return i.__extends(r,t),r.init_DatetimeTickFormatter=function(){this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})},r.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},r.prototype._update_width_formats=function(){var t=+s.default(new Date),r=function(r){var e=r.map((function(r){return d(t,r).length})),i=c.sort_by(c.zip(e,r),(function(t){return t[0]}));return c.unzip(i)};this._width_formats={microseconds:r(this.microseconds),milliseconds:r(this.milliseconds),seconds:r(this.seconds),minsec:r(this.minsec),minutes:r(this.minutes),hourmin:r(this.hourmin),hours:r(this.hours),days:r(this.days),months:r(this.months),years:r(this.years)}},r.prototype._get_resolution_str=function(t,r){var e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return r>=60?"minsec":"seconds";case!(e<3600):return r>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}},r.prototype.doFormat=function(t,r){if(0==t.length)return[];for(var e=Math.abs(t[t.length-1]-t[0])/1e3,i=e/(t.length-1),s=this._get_resolution_str(i,e),n=this._width_formats[s][1][0],a=[],u=f.indexOf(s),c={},m=0,l=f;m<l.length;m++){c[l[m]]=0}c.seconds=5,c.minsec=4,c.minutes=4,c.hourmin=3,c.hours=3;for(var _=0,p=t;_<p.length;_++){var y=p[_],g=void 0,v=void 0;try{v=h(y),g=d(y,n)}catch(t){o.logger.warn("unable to format tick for timestamp value "+y),o.logger.warn(" - "+t),a.push("ERR");continue}for(var w=!1,A=u;0==v[c[f[A]]];){if((A+=1)==f.length)break;if(("minsec"==s||"hourmin"==s)&&!w){if("minsec"==s&&0==v[4]&&0!=v[5]||"hourmin"==s&&0==v[3]&&0!=v[4]){g=d(y,this._width_formats[f[u-1]][1][0]);break}w=!0}g=d(y,this._width_formats[f[A]][1][0])}if(this.strip_leading_zeros){var M=g.replace(/^0+/g,"");M!=g&&isNaN(parseInt(M))&&(M="0"+M),a.push(M)}else a.push(g)}return a},r}(n.TickFormatter);e.DatetimeTickFormatter=l,l.__name__="DatetimeTickFormatter",l.init_DatetimeTickFormatter()},
function _(e,t,n){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});var t=r(1),u=t.__importStar(r(267)),i=r(268),a=t.__importDefault(r(265)),f=r(133),o=r(116);function l(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];return i.sprintf.apply(void 0,t.__spreadArrays([r],n))}function c(r,n,e){return o.isNumber(r)?l(function(){switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}}(),r):""+r}function s(r,n,t){if(null==n)return c;if(null!=t&&r in t){var u=t[r];if(o.isString(u)){if(u in e.DEFAULT_FORMATTERS)return e.DEFAULT_FORMATTERS[u];throw new Error("Unknown tooltip field formatter type '"+u+"'")}return function(r,n,e){return u.format(r,n,e)}}return e.DEFAULT_FORMATTERS.numeral}function p(r,n,e,t){return"$"==r[0]?function(r,n){if(r in n)return n[r];throw new Error("Unknown special variable '$"+r+"'")}(r.substring(1),t):function(r,n,e){var t=n.get_column(r);if(null==t)return null;if(o.isNumber(e))return t[e];var u=t[e.index];return o.isTypedArray(u)||o.isArray(u)?o.isArray(u[0])?u[e.dim2][e.dim1]:u[e.flat_index]:u}(r.substring(1).replace(/[{}]/g,""),n,e)}e.DEFAULT_FORMATTERS={numeral:function(r,n,e){return u.format(r,n)},datetime:function(r,n,e){return a.default(r,n)},printf:function(r,n,e){return l(n,r)}},e.sprintf=l,e.basic_formatter=c,e.get_formatter=s,e.get_value=p,e.replace_placeholders=function(r,n,e,t,u){return void 0===u&&(u={}),r=(r=r.replace(/@\$name/g,(function(r){return"@{"+u.name+"}"}))).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(function(r,i,a){var o=p(i,n,e,u);if(null==o)return""+f.escape("???");if("safe"==a)return""+o;var l=s(i,a,t);return""+f.escape(l(o,a,u))}))}},
function _(e,n,t){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var r,i={},a=i,o="en-US",l=null,u="0,0";void 0!==n&&n.exports;function c(e){this._value=e}function s(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function f(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+s(i-r.length),n>0&&(a+="."+s(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function d(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,a,l=n,u=l.indexOf("$"),c=l.indexOf("("),s=l.indexOf("+"),f=l.indexOf("-"),d="",p="";-1===l.indexOf("$")?"infix"===i[o].currency.position?(p=i[o].currency.symbol,i[o].currency.spaceSeparated&&(p=" "+p+" ")):i[o].currency.spaceSeparated&&(d=" "):l.indexOf(" $")>-1?(d=" ",l=l.replace(" $","")):l.indexOf("$ ")>-1?(d=" ",l=l.replace("$ ","")):l=l.replace("$","");if(a=h(e,l,t,p),-1===n.indexOf("$"))switch(i[o].currency.position){case"postfix":a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;break;case"infix":break;case"prefix":a.indexOf("(")>-1||a.indexOf("-")>-1?(a=a.split(""),r=Math.max(c,f)+1,a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else u<=1?a.indexOf("(")>-1||a.indexOf("+")>-1||a.indexOf("-")>-1?(a=a.split(""),r=1,(u<c||u<s||u<f)&&(r=0),a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a:a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;return a}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=h(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):h(e,n,t)}function h(e,n,t,r){var a,u,c,s,d,h,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==l)return l;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(d=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(h=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,d)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===h?0:3*~~(h/3)-h)<0?M+3:M,a=0;a<M;a++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=i[o].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=i[o].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=i[o].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=i[o].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(u=Math.pow(1024,s),c=Math.pow(1024,s+1),e>=u&&e<c){C+=K[s],u>0&&(e/=u);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(u=Math.pow(1e3,s),c=Math.pow(1e3,s+1),e>=u&&e<c){C+=G[s],u>0&&(e/=u);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),i[o].ordinal&&(L+=i[o].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?f(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?f(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):f(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:i[o].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=f(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+i[o].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function p(e,n){i[e]=n}function m(e){o=e;var n=i[e].defaults;n&&n.format&&r.defaultFormat(n.format),n&&n.currencyFormat&&r.defaultCurrencyFormat(n.currencyFormat)}(r=function(e){return r.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=r.fn.unformat(e)),new c(Number(e))}).version="1.6.2",r.isNumbro=function(e){return e instanceof c},r.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;a[t]||(Object.keys(a).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),m(t)},r.setCulture=function(e,n){var t=e,r=e.split("-")[1],a=null;i[t]||(r&&Object.keys(i).forEach((function(e){a||e.split("-")[1]!==r||(a=e)})),t=a||n||"en-US"),m(t)},r.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return o;if(e&&!n){if(!a[e])throw new Error("Unknown language : "+e);m(e)}return!n&&a[e]||p(e,n),r},r.culture=function(e,n){if(!e)return o;if(e&&!n){if(!i[e])throw new Error("Unknown culture : "+e);m(e)}return!n&&i[e]||p(e,n),r},r.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return a[o];if(!a[e])throw new Error("Unknown language : "+e);return a[e]},r.cultureData=function(e){if(!e)return i[o];if(!i[e])throw new Error("Unknown culture : "+e);return i[e]},r.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),r.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),a},r.cultures=function(){return i},r.zeroFormat=function(e){l="string"==typeof e?e:null},r.defaultFormat=function(e){u="string"==typeof e?e:"0.0"},r.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},r.validate=function(e,n){var t,i,a,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=r.cultureData(n)}catch(e){c=r.cultureData(r.culture())}return a=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,i="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===a))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(i+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,i){return null!=t&&t!==r.culture()&&r.setCulture(t),d(Number(e),null!=n?n:u,null==i?Math.round:i)}}},
function _(e,n,t){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0});var t=e(1),r=e(117),a=e(217),s=e(270),_=e(271),c=e(274),m=e(275),k=e(273),o=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DatetimeTicker=function(){this.override({num_minor_ticks:0,tickers:function(){return[new a.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*k.ONE_MILLI,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:k.ONE_SECOND,max_interval:30*k.ONE_MINUTE,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:k.ONE_HOUR,max_interval:12*k.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:r.range(1,32)}),new _.DaysTicker({days:r.range(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new c.MonthsTicker({months:r.range(0,12,1)}),new c.MonthsTicker({months:r.range(0,12,2)}),new c.MonthsTicker({months:r.range(0,12,4)}),new c.MonthsTicker({months:r.range(0,12,6)}),new m.YearsTicker({})]}})},n}(s.CompositeTicker);i.DatetimeTicker=o,o.__name__="DatetimeTicker",o.init_DatetimeTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(218),o=r.__importStar(t(127)),s=t(117),a=t(131),_=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_CompositeTicker=function(){this.define({tickers:[o.Array,[]]})},Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map((function(t){return t.get_min_interval()}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map((function(t){return t.get_max_interval()}))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"min_interval",{get:function(){return this.min_intervals[0]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max_interval",{get:function(){return this.max_intervals[0]},enumerable:!0,configurable:!0}),e.prototype.get_best_ticker=function(t,e,i){var r,n=e-t,o=this.get_ideal_interval(t,e,i),_=[s.sorted_index(this.min_intervals,o)-1,s.sorted_index(this.max_intervals,o)],u=[this.min_intervals[_[0]],this.max_intervals[_[1]]].map((function(t){return Math.abs(i-n/t)}));if(a.isEmpty(u.filter((function(t){return!isNaN(t)}))))r=this.tickers[0];else{var c=_[s.argmin(u)];r=this.tickers[c]}return r},e.prototype.get_interval=function(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)},e.prototype.get_ticks_no_defaults=function(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)},e}(n.ContinuousTicker);i.CompositeTicker=_,_.__name__="CompositeTicker",_.init_CompositeTicker()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),r=t(272),a=t(273),o=i.__importStar(t(127)),_=t(117);var s=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_DaysTicker=function(){this.define({days:[o.Array,[]]}),this.override({num_minor_ticks:0})},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.days;n.length>1?this.interval=(n[1]-n[0])*a.ONE_DAY:this.interval=31*a.ONE_DAY},n.prototype.get_ticks_no_defaults=function(t,n,e,i){var r=function(t,n){var e=a.last_month_no_later_than(new Date(t)),i=a.last_month_no_later_than(new Date(n));i.setUTCMonth(i.getUTCMonth()+1);for(var r=[],o=e;r.push(a.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(o>i););return r}(t,n),o=this.days,s=this.interval;return{major:_.concat(r.map((function(t){return function(t,n){for(var e=t.getUTCMonth(),i=[],r=0,_=o;r<_.length;r++){var s=_[r],c=a.copy_date(t);c.setUTCDate(s),new Date(c.getTime()+n/2).getUTCMonth()==e&&i.push(c)}return i}(t,s)}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(r.SingleIntervalTicker);e.DaysTicker=s,s.__name__="DaysTicker",s.init_DaysTicker()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(218),l=r.__importStar(e(127)),o=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_SingleIntervalTicker=function(){this.define({interval:[l.Number]})},t.prototype.get_interval=function(e,t,n){return this.interval},Object.defineProperty(t.prototype,"min_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),t}(i.ContinuousTicker);n.SingleIntervalTicker=o,o.__name__="SingleIntervalTicker",o.init_SingleIntervalTicker()},
function _(e,t,_){function n(e){return new Date(e.getTime())}function O(e){var t=n(e);return t.setUTCDate(1),t.setUTCHours(0),t.setUTCMinutes(0),t.setUTCSeconds(0),t.setUTCMilliseconds(0),t}Object.defineProperty(_,"__esModule",{value:!0}),_.ONE_MILLI=1,_.ONE_SECOND=1e3,_.ONE_MINUTE=60*_.ONE_SECOND,_.ONE_HOUR=60*_.ONE_MINUTE,_.ONE_DAY=24*_.ONE_HOUR,_.ONE_MONTH=30*_.ONE_DAY,_.ONE_YEAR=365*_.ONE_DAY,_.copy_date=n,_.last_month_no_later_than=O,_.last_year_no_later_than=function(e){var t=O(e);return t.setUTCMonth(0),t}},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),i=t(272),a=t(273),o=r.__importStar(t(127)),_=t(117);var l=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_MonthsTicker=function(){this.define({months:[o.Array,[]]})},n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.months;n.length>1?this.interval=(n[1]-n[0])*a.ONE_MONTH:this.interval=12*a.ONE_MONTH},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var i=function(t,n){var e=a.last_year_no_later_than(new Date(t)),r=a.last_year_no_later_than(new Date(n));r.setUTCFullYear(r.getUTCFullYear()+1);for(var i=[],o=e;i.push(a.copy_date(o)),o.setUTCFullYear(o.getUTCFullYear()+1),!(o>r););return i}(t,n),o=this.months;return{major:_.concat(i.map((function(t){return o.map((function(n){var e=a.copy_date(t);return e.setUTCMonth(n),e}))}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(i.SingleIntervalTicker);e.MonthsTicker=l,l.__name__="MonthsTicker",l.init_MonthsTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(216),a=t(272),_=t(273),o=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=_.ONE_YEAR,this.basic_ticker=new r.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=_.last_year_no_later_than(new Date(t)).getUTCFullYear(),a=_.last_year_no_later_than(new Date(e)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,a,i,n).major.map((function(t){return Date.UTC(t,0,1)})).filter((function(i){return t<=i&&i<=e})),minor:[]}},e}(a.SingleIntervalTicker);i.YearsTicker=o,o.__name__="YearsTicker"},
function _(i,t,n){Object.defineProperty(n,"__esModule",{value:!0});var e=i(1),o=i(256),r=i(261),u=i(277),s=i(278),_=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return e.__extends(t,i),t}(o.AxisView);n.LogAxisView=_,_.__name__="LogAxisView";var c=function(i){function t(t){return i.call(this,t)||this}return e.__extends(t,i),t.init_LogAxis=function(){this.prototype.default_view=_,this.override({ticker:function(){return new s.LogTicker},formatter:function(){return new u.LogTickFormatter}})},t}(r.ContinuousAxis);n.LogAxis=c,c.__name__="LogAxis",c.init_LogAxis()},
function _(t,i,r){Object.defineProperty(r,"__esModule",{value:!0});var e=t(1),o=t(221),n=t(220),a=e.__importStar(t(127)),c=function(t){function i(i){return t.call(this,i)||this}return e.__extends(i,t),i.init_LogTickFormatter=function(){this.define({ticker:[a.Instance,null]})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new n.BasicTickFormatter},i.prototype.doFormat=function(t,i){if(0==t.length)return[];for(var r=null!=this.ticker?this.ticker.base:10,e=!1,o=new Array(t.length),n=0,a=t.length;n<a;n++)if(o[n]=r+"^"+Math.round(Math.log(t[n])/Math.log(r)),n>0&&o[n]==o[n-1]){e=!0;break}return e?this.basic_formatter.doFormat(t,i):o},i}(o.TickFormatter);r.LogTickFormatter=c,c.__name__="LogTickFormatter",c.init_LogTickFormatter()},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});var e=t(1),i=t(217),o=t(117),a=function(t){function r(r){return t.call(this,r)||this}return e.__extends(r,t),r.init_LogTicker=function(){this.override({mantissas:[1,5]})},r.prototype.get_ticks_no_defaults=function(t,r,n,e){var i,a=this.num_minor_ticks,u=[],f=this.base,h=Math.log(t)/Math.log(f),l=Math.log(r)/Math.log(f),c=l-h;if(isFinite(c))if(c<2){var s=this.get_interval(t,r,e),g=Math.floor(t/s),_=Math.ceil(r/s);if(i=o.range(g,_+1).filter((function(t){return 0!=t})).map((function(t){return t*s})).filter((function(n){return t<=n&&n<=r})),a>0&&i.length>0){for(var p=s/a,v=0,M=(x=o.range(0,a).map((function(t){return t*p}))).slice(1);v<M.length;v++){var m=M[v];u.push(i[0]-m)}for(var k=0,d=i;k<d.length;k++)for(var T=d[k],L=0,b=x;L<b.length;L++){m=b[L];u.push(T+m)}}}else{var j=Math.ceil(.999999*h),w=Math.floor(1.000001*l),y=Math.ceil((w-j)/9);if(i=o.range(j-1,w+1,y).map((function(t){return Math.pow(f,t)})),a>0&&i.length>0){for(var x,A=Math.pow(f,y)/a,F=0,O=x=o.range(1,a+1).map((function(t){return t*A}));F<O.length;F++){m=O[F];u.push(i[0]/m)}u.push(i[0]);for(var P=0,q=i;P<q.length;P++){T=q[P];for(var z=0,B=x;z<B.length;z++){m=B[z];u.push(T*m)}}}}else i=[];return{major:i.filter((function(n){return t<=n&&n<=r})),minor:u.filter((function(n){return t<=n&&n<=r}))}},r}(i.AdaptiveTicker);n.LogTicker=a,a.__name__="LogTicker",a.init_LogTicker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(256),o=e(263),a=e(280),c=e(281),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t}(n.AxisView);r.MercatorAxisView=s,s.__name__="MercatorAxisView";var u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_MercatorAxis=function(){this.prototype.default_view=s,this.override({ticker:function(){return new c.MercatorTicker({dimension:"lat"})},formatter:function(){return new a.MercatorTickFormatter({dimension:"lat"})}})},t}(o.LinearAxis);r.MercatorAxis=u,u.__name__="MercatorAxis",u.init_MercatorAxis()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});var o=r(1),i=r(220),n=o.__importStar(r(127)),a=r(138),c=function(r){function t(t){return r.call(this,t)||this}return o.__extends(t,r),t.init_MercatorTickFormatter=function(){this.define({dimension:[n.LatLon]})},t.prototype.doFormat=function(t,e){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var o=t.length,i=new Array(o);if("lon"==this.dimension)for(var n=0;n<o;n++){var c=a.wgs84_mercator.inverse([t[n],e.loc])[0];i[n]=c}else for(n=0;n<o;n++){var s=a.wgs84_mercator.inverse([e.loc,t[n]])[1];i[n]=s}return r.prototype.doFormat.call(this,i,e)},t}(i.BasicTickFormatter);e.MercatorTickFormatter=c,c.__name__="MercatorTickFormatter",c.init_MercatorTickFormatter()},
function _(r,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=r(1),i=r(216),t=o.__importStar(r(127)),a=r(138),s=function(r){function e(e){return r.call(this,e)||this}return o.__extends(e,r),e.init_MercatorTicker=function(){this.define({dimension:[t.LatLon]})},e.prototype.get_ticks_no_defaults=function(e,n,o,i){var t,s,c,_,f,m,l,u;if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");e=(t=a.clip_mercator(e,n,this.dimension))[0],n=t[1],"lon"===this.dimension?(m=(s=a.wgs84_mercator.inverse([e,o]))[0],u=s[1],l=(c=a.wgs84_mercator.inverse([n,o]))[0],u=c[1]):(u=(_=a.wgs84_mercator.inverse([o,e]))[0],m=_[1],u=(f=a.wgs84_mercator.inverse([o,n]))[0],l=f[1]);var d=r.prototype.get_ticks_no_defaults.call(this,m,l,o,i),h=[],g=[];if("lon"===this.dimension){for(var v=0,w=d.major;v<w.length;v++){var p=w[v];if(a.in_bounds(p,"lon")){var k=a.wgs84_mercator.forward([p,u])[0];h.push(k)}}for(var M=0,T=d.minor;M<T.length;M++){p=T[M];if(a.in_bounds(p,"lon")){k=a.wgs84_mercator.forward([p,u])[0];g.push(k)}}}else{for(var b=0,j=d.major;b<j.length;b++){p=j[b];if(a.in_bounds(p,"lat")){var y=a.wgs84_mercator.forward([u,p])[1];h.push(y)}}for(var L=0,x=d.minor;L<x.length;L++){p=x[L];if(a.in_bounds(p,"lat")){y=a.wgs84_mercator.forward([u,p])[1];g.push(y)}}}return{major:h,minor:g}},e}(i.BasicTicker);n.MercatorTicker=s,s.__name__="MercatorTicker",s.init_MercatorTicker()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(283);o.CustomJS=t.CustomJS;var u=e(285);o.OpenURL=u.OpenURL},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(284),o=r.__importStar(e(127)),u=e(131),a=e(133),c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_CustomJS=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(t.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=a.use_strict(this.code);return new(Function.bind.apply(Function,r.__spreadArrays([void 0],this.names,["cb_obj","cb_data",e])))},enumerable:!0,configurable:!0}),t.prototype.execute=function(e,t){return void 0===t&&(t={}),this.func.apply(e,this.values.concat(e,t))},t}(i.Callback);n.CustomJS=c,c.__name__="CustomJS",c.init_CustomJS()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(1),_=function(e){function n(n){return e.call(this,n)||this}return l.__extends(n,e),n}(e(177).Model);t.Callback=_,_.__name__="Callback"},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),o=e(284),r=e(266),a=i.__importStar(e(127)),c=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_OpenURL=function(){this.define({url:[a.String,"http://"],same_tab:[a.Boolean,!1]})},n.prototype.execute=function(e,n){for(var t=this,i=n.source,o=function(e){var n=r.replace_placeholders(t.url,i,e);t.same_tab?window.location.href=n:window.open(n)},a=i.selected,c=0,l=a.indices;c<l.length;c++){o(l[c])}for(var _=0,u=a.line_indices;_<u.length;_++){o(u[_])}},n}(o.Callback);t.OpenURL=c,c.__name__="OpenURL",c.init_OpenURL()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=a(287);r.Canvas=n.Canvas;var s=a(291);r.CartesianFrame=s.CartesianFrame},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var n,i,s=e(1),l=e(121),o=e(172),r=e(178),c=s.__importStar(e(127)),d=e(174),h=e(193),v=e(288),_=e(289),p=(n=document.createElement("canvas"),null!=(i=n.getContext("webgl",{premultipliedAlpha:!0}))?{canvas:n,gl:i}:void r.logger.trace("WebGL is not supported")),u=s.__importDefault(e(290)),g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),Object.defineProperty(t.prototype,"ctx",{get:function(){return this._ctx},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this);var t={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};switch(this.model.output_backend){case"webgl":this.webgl=p;case"canvas":if(this.canvas_el=d.canvas({class:_.bk_canvas,style:t}),null==(a=this.canvas_el.getContext("2d")))throw new Error("unable to obtain 2D rendering context");this._ctx=a;break;case"svg":var a=new u.default;this._ctx=a,this.canvas_el=a.getSvg()}this.underlays_el=d.div({class:_.bk_canvas_underlays,style:t}),this.overlays_el=d.div({class:_.bk_canvas_overlays,style:t}),this.events_el=d.div({class:_.bk_canvas_events,style:t}),d.append(this.el,this.underlays_el,this.canvas_el,this.overlays_el,this.events_el),v.fixup_ctx(this._ctx),r.logger.debug("CanvasView initialized")},t.prototype.add_underlay=function(e){this.underlays_el.appendChild(e)},t.prototype.add_overlay=function(e){this.overlays_el.appendChild(e)},t.prototype.add_event=function(e){this.events_el.appendChild(e)},t.prototype.prepare_canvas=function(e,t){this.bbox=new h.BBox({left:0,top:0,width:e,height:t}),this.el.style.width=e+"px",this.el.style.height=t+"px";var a=this.model,n=a.use_hidpi,i=a.output_backend,s=n&&"svg"!=i?devicePixelRatio:1;this.model.pixel_ratio=s,this.canvas_el.style.width=e+"px",this.canvas_el.style.height=t+"px",this.canvas_el.setAttribute("width",""+e*s),this.canvas_el.setAttribute("height",""+t*s),r.logger.debug("Rendering CanvasView with width: "+e+", height: "+t+", pixel ratio: "+s)},t.prototype.save=function(e){if(this.canvas_el instanceof HTMLCanvasElement){var t=this.canvas_el;if(null!=t.msToBlob){var a=t.msToBlob();window.navigator.msSaveBlob(a,e)}else{var n=document.createElement("a");n.href=t.toDataURL("image/png"),n.download=e+".png",n.target="_blank",n.dispatchEvent(new MouseEvent("click"))}}else{var i=this._ctx.getSerializedSvg(!0),s=new Blob([i],{type:"text/plain"}),l=document.createElement("a");l.download=e+".svg",l.innerHTML="Download svg",l.href=window.URL.createObjectURL(s),l.onclick=function(e){return document.body.removeChild(e.target)},l.style.display="none",document.body.appendChild(l),l.click()}},t}(o.DOMView);a.CanvasView=g,g.__name__="CanvasView";var y=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Canvas=function(){this.prototype.default_view=g,this.internal({use_hidpi:[c.Boolean,!0],pixel_ratio:[c.Number,1],output_backend:[c.OutputBackend,"canvas"]})},t}(l.HasProps);a.Canvas=y,y.__name__="Canvas",y.init_Canvas()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fixup_ctx=function(e){!function(e){e.setLineDash||(e.setLineDash=function(t){e.mozDash=t,e.webkitLineDash=t}),e.getLineDash||(e.getLineDash=function(){return e.mozDash})}(e),function(e){e.setLineDashOffset=function(t){e.lineDashOffset=t,e.mozDashOffset=t,e.webkitLineDashOffset=t},e.getLineDashOffset=function(){return e.mozDashOffset}}(e),function(e){e.setImageSmoothingEnabled=function(t){e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=function(){var t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=function(t){var n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,a,o,i,s,u,r){void 0===r&&(r=!1);var m=.551784;e.translate(t,n),e.rotate(i);var f=a,h=o;r&&(f=-a,h=-o),e.moveTo(-f,0),e.bezierCurveTo(-f,h*m,-f*m,h,0,h),e.bezierCurveTo(f*m,h,f,h*m,f,0),e.bezierCurveTo(f,-h*m,f*m,-h,0,-h),e.bezierCurveTo(-f*m,-h,-f,-h*m,-f,0),e.rotate(-i),e.translate(-t,-n)})}(e)}},
function _(a,e,n){Object.defineProperty(n,"__esModule",{value:!0}),a(175),n.bk_canvas="bk-canvas",n.bk_canvas_underlays="bk-canvas-underlays",n.bk_canvas_overlays="bk-canvas-overlays",n.bk_canvas_events="bk-canvas-events"},
function _(t,e,r){var i,n,s,a,o;function h(t,e){var r,i=Object.keys(e);for(r=0;r<i.length;r++)t=t.replace(new RegExp("\\{"+i[r]+"\\}","gi"),e[i[r]]);return t}function l(t){var e,r,i;if(!t)throw new Error("cannot create a random attribute name for an undefined object");e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",r="";do{for(r="",i=0;i<12;i++)r+=e[Math.floor(Math.random()*e.length)]}while(t[r]);return r}function c(t){var e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}
/*!!
     *  Canvas 2 Svg v1.0.21
     *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
     *
     *  Licensed under the MIT license:
     *  http://www.opensource.org/licenses/mit-license.php
     *
     *  Author:
     *  Kerry Liu
     *
     *  Copyright (c) 2014 Gliffy Inc.
     */
Object.defineProperty(r,"__esModule",{value:!0}),o=function(t,e){var r,i,n,s={};for(t=t.split(","),e=e||10,r=0;r<t.length;r+=2)i="&"+t[r+1]+";",n=parseInt(t[r],e),s[i]="&#"+n+";";return s["\\xa0"]="&#160;",s}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),i={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},(s=function(t,e){this.__root=t,this.__ctx=e}).prototype.addColorStop=function(t,e){var r,i=this.__ctx.__createElement("stop");i.setAttribute("offset",t),-1!==e.indexOf("rgba")?(r=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),i.setAttribute("stop-color",h("rgb({r},{g},{b})",{r:r[1],g:r[2],b:r[3]})),i.setAttribute("stop-opacity",r[4])):i.setAttribute("stop-color",e),this.__root.appendChild(i)},a=function(t,e){this.__root=t,this.__ctx=e},(n=function(t){var e,r={width:500,height:500,enableMirroring:!1};if(arguments.length>1?((e=r).width=arguments[0],e.height=arguments[1]):e=t||r,!(this instanceof n))return new n(e);this.width=e.width||r.width,this.height=e.height||r.height,this.enableMirroring=void 0!==e.enableMirroring?e.enableMirroring:r.enableMirroring,this.canvas=this,this.__document=e.document||document,e.ctx?this.__ctx=e.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version",1.1),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.__root.setAttribute("width",this.width),this.__root.setAttribute("height",this.height),this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}).prototype.__createElement=function(t,e,r){void 0===e&&(e={});var i,n,s=this.__document.createElementNS("http://www.w3.org/2000/svg",t),a=Object.keys(e);for(r&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none")),i=0;i<a.length;i++)n=a[i],s.setAttribute(n,e[n]);return s},n.prototype.__setDefaultStyles=function(){var t,e,r=Object.keys(i);for(t=0;t<r.length;t++)this[e=r[t]]=i[e].canvas},n.prototype.__applyStyleState=function(t){var e,r,i=Object.keys(t);for(e=0;e<i.length;e++)this[r=i[e]]=t[r]},n.prototype.__getStyleState=function(){var t,e,r={},n=Object.keys(i);for(t=0;t<n.length;t++)r[e=n[t]]=this[e];return r},n.prototype.__applyStyleToCurrentElement=function(t){var e=this.__currentElement,r=this.__currentElementsToStyle;r&&(e.setAttribute(t,""),e=r.element,r.children.forEach((function(e){e.setAttribute(t,"")})));var n,o,l,c,p,_=Object.keys(i);for(n=0;n<_.length;n++)if(o=i[_[n]],l=this[_[n]],o.apply)if(l instanceof a){if(l.__ctx)for(;l.__ctx.__defs.childNodes.length;)c=l.__ctx.__defs.childNodes[0].getAttribute("id"),this.__ids[c]=c,this.__defs.appendChild(l.__ctx.__defs.childNodes[0]);e.setAttribute(o.apply,h("url(#{id})",{id:l.__root.getAttribute("id")}))}else if(l instanceof s)e.setAttribute(o.apply,h("url(#{id})",{id:l.__root.getAttribute("id")}));else if(-1!==o.apply.indexOf(t)&&o.svg!==l)if("stroke"!==o.svgAttr&&"fill"!==o.svgAttr||-1===l.indexOf("rgba")){var u=o.svgAttr;if("globalAlpha"===_[n]&&(u=t+"-"+o.svgAttr,e.getAttribute(u)))continue;e.setAttribute(u,l)}else{p=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(l),e.setAttribute(o.svgAttr,h("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var d=p[4],g=this.globalAlpha;null!=g&&(d*=g),e.setAttribute(o.svgAttr+"-opacity",d)}},n.prototype.__closestGroupOrSvg=function(t){return"g"===(t=t||this.__currentElement).nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)},n.prototype.getSerializedSvg=function(t){var e,r,i,n,s,a=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(a)&&(a=a.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(e=Object.keys(o),r=0;r<e.length;r++)i=e[r],n=o[i],(s=new RegExp(i,"gi")).test(a)&&(a=a.replace(s,n));return a},n.prototype.getSvg=function(){return this.__root},n.prototype.save=function(){var t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())},n.prototype.restore=function(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=this.__root.childNodes[1]);var t=this.__stack.pop();this.__applyStyleState(t)},n.prototype.__addTransform=function(t){var e=this.__closestGroupOrSvg();if(e.childNodes.length>0){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());var r=this.__createElement("g");e.appendChild(r),this.__currentElement=r}var i=this.__currentElement.getAttribute("transform");i?i+=" ":i="",i+=t,this.__currentElement.setAttribute("transform",i)},n.prototype.scale=function(t,e){void 0===e&&(e=t),this.__addTransform(h("scale({x},{y})",{x:t,y:e}))},n.prototype.rotate=function(t){var e=180*t/Math.PI;this.__addTransform(h("rotate({angle},{cx},{cy})",{angle:e,cx:0,cy:0}))},n.prototype.translate=function(t,e){this.__addTransform(h("translate({x},{y})",{x:t,y:e}))},n.prototype.transform=function(t,e,r,i,n,s){this.__addTransform(h("matrix({a},{b},{c},{d},{e},{f})",{a:t,b:e,c:r,d:i,e:n,f:s}))},n.prototype.beginPath=function(){var t;this.__currentDefaultPath="",this.__currentPosition={},t=this.__createElement("path",{},!0),this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t},n.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},n.prototype.__addPathCommand=function(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t},n.prototype.moveTo=function(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(h("M {x} {y}",{x:t,y:e}))},n.prototype.closePath=function(){this.__currentDefaultPath&&this.__addPathCommand("Z")},n.prototype.lineTo=function(t,e){this.__currentPosition={x:t,y:e},this.__currentDefaultPath.indexOf("M")>-1?this.__addPathCommand(h("L {x} {y}",{x:t,y:e})):this.__addPathCommand(h("M {x} {y}",{x:t,y:e}))},n.prototype.bezierCurveTo=function(t,e,r,i,n,s){this.__currentPosition={x:n,y:s},this.__addPathCommand(h("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:t,cp1y:e,cp2x:r,cp2y:i,x:n,y:s}))},n.prototype.quadraticCurveTo=function(t,e,r,i){this.__currentPosition={x:r,y:i},this.__addPathCommand(h("Q {cpx} {cpy} {x} {y}",{cpx:t,cpy:e,x:r,y:i}))};var p=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]);return[t[0]/e,t[1]/e]};n.prototype.arcTo=function(t,e,r,i,n){var s=this.__currentPosition&&this.__currentPosition.x,a=this.__currentPosition&&this.__currentPosition.y;if(void 0!==s&&void 0!==a){if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(s===t&&a===e||t===r&&e===i||0===n)this.lineTo(t,e);else{var o=p([s-t,a-e]),h=p([r-t,i-e]);if(o[0]*h[1]!=o[1]*h[0]){var l=o[0]*h[0]+o[1]*h[1],c=Math.acos(Math.abs(l)),_=p([o[0]+h[0],o[1]+h[1]]),u=n/Math.sin(c/2),d=t+u*_[0],g=e+u*_[1],m=[-o[1],o[0]],f=[h[1],-h[0]],y=function(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)},v=y(m),b=y(f);this.lineTo(d+m[0]*n,g+m[1]*n),this.arc(d,g,n,v,b)}else this.lineTo(t,e)}}},n.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")},n.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")},n.prototype.rect=function(t,e,r,i){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e),this.closePath()},n.prototype.fillRect=function(t,e,r,i){var n;n=this.__createElement("rect",{x:t,y:e,width:r,height:i},!0),this.__closestGroupOrSvg().appendChild(n),this.__currentElement=n,this.__applyStyleToCurrentElement("fill")},n.prototype.strokeRect=function(t,e,r,i){var n;n=this.__createElement("rect",{x:t,y:e,width:r,height:i},!0),this.__closestGroupOrSvg().appendChild(n),this.__currentElement=n,this.__applyStyleToCurrentElement("stroke")},n.prototype.__clearCanvas=function(){for(var t=this.__closestGroupOrSvg().getAttribute("transform"),e=this.__root.childNodes[1],r=e.childNodes,i=r.length-1;i>=0;i--)r[i]&&e.removeChild(r[i]);this.__currentElement=e,this.__groupStack=[],t&&this.__addTransform(t)},n.prototype.clearRect=function(t,e,r,i){if(0!==t||0!==e||r!==this.width||i!==this.height){var n,s=this.__closestGroupOrSvg();n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0),s.appendChild(n)}else this.__clearCanvas()},n.prototype.createLinearGradient=function(t,e,r,i){var n=this.__createElement("linearGradient",{id:l(this.__ids),x1:t+"px",x2:r+"px",y1:e+"px",y2:i+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(n),new s(n,this)},n.prototype.createRadialGradient=function(t,e,r,i,n,a){var o=this.__createElement("radialGradient",{id:l(this.__ids),cx:i+"px",cy:n+"px",r:a+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(o),new s(o,this)},n.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal",href:null};return"underline"===this.__fontUnderline&&(e.decoration="underline"),this.__fontHref&&(e.href=this.__fontHref),e},n.prototype.__wrapTextLink=function(t,e){if(t.href){var r=this.__createElement("a");return r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),r.appendChild(e),r}return e},n.prototype.__applyText=function(t,e,r,i){var n,s,a=this.__parseFont(),o=this.__closestGroupOrSvg(),h=this.__createElement("text",{"font-family":a.family,"font-size":a.size,"font-style":a.style,"font-weight":a.weight,"text-decoration":a.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,s={left:"start",right:"end",center:"middle",start:"start",end:"end"},s[n]||s.start),"dominant-baseline":c(this.textBaseline)},!0);h.appendChild(this.__document.createTextNode(t)),this.__currentElement=h,this.__applyStyleToCurrentElement(i),o.appendChild(this.__wrapTextLink(a,h))},n.prototype.fillText=function(t,e,r){this.__applyText(t,e,r,"fill")},n.prototype.strokeText=function(t,e,r){this.__applyText(t,e,r,"stroke")},n.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},n.prototype.arc=function(t,e,r,i,n,s){if(i!==n){(i%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(s?-1:1))%(2*Math.PI));var a=t+r*Math.cos(n),o=e+r*Math.sin(n),l=t+r*Math.cos(i),c=e+r*Math.sin(i),p=s?0:1,_=0,u=n-i;u<0&&(u+=2*Math.PI),_=s?u>Math.PI?0:1:u>Math.PI?1:0,this.lineTo(l,c),this.__addPathCommand(h("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:r,ry:r,xAxisRotation:0,largeArcFlag:_,sweepFlag:p,endX:a,endY:o})),this.__currentPosition={x:a,y:o}}},n.prototype.clip=function(){var t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),r=l(this.__ids),i=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",r),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",h("url(#{id})",{id:r})),t.appendChild(i),this.__currentElement=i},n.prototype.drawImage=function(){var t,e,r,i,s,a,o,h,l,c,p,_,u,d,g=Array.prototype.slice.call(arguments),m=g[0],f=0,y=0;if(3===g.length)t=g[1],e=g[2],r=s=m.width,i=a=m.height;else if(5===g.length)t=g[1],e=g[2],r=g[3],i=g[4],s=m.width,a=m.height;else{if(9!==g.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);f=g[1],y=g[2],s=g[3],a=g[4],t=g[5],e=g[6],r=g[7],i=g[8]}o=this.__closestGroupOrSvg(),this.__currentElement;var v="translate("+t+", "+e+")";if(m instanceof n){if((h=m.getSvg().cloneNode(!0)).childNodes&&h.childNodes.length>1){for(l=h.childNodes[0];l.childNodes.length;)d=l.childNodes[0].getAttribute("id"),this.__ids[d]=d,this.__defs.appendChild(l.childNodes[0]);if(c=h.childNodes[1]){var b,x=c.getAttribute("transform");b=x?x+" "+v:v,c.setAttribute("transform",b),o.appendChild(c)}}}else"IMG"===m.nodeName?((p=this.__createElement("image")).setAttribute("width",r),p.setAttribute("height",i),p.setAttribute("preserveAspectRatio","none"),(f||y||s!==m.width||a!==m.height)&&((_=this.__document.createElement("canvas")).width=r,_.height=i,(u=_.getContext("2d")).drawImage(m,f,y,s,a,0,0,r,i),m=_),p.setAttribute("transform",v),p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===m.nodeName?m.toDataURL():m.getAttribute("src")),o.appendChild(p)):"CANVAS"===m.nodeName&&((p=this.__createElement("image")).setAttribute("width",r),p.setAttribute("height",i),p.setAttribute("preserveAspectRatio","none"),(_=this.__document.createElement("canvas")).width=r,_.height=i,(u=_.getContext("2d")).imageSmoothingEnabled=!1,u.mozImageSmoothingEnabled=!1,u.oImageSmoothingEnabled=!1,u.webkitImageSmoothingEnabled=!1,u.drawImage(m,f,y,s,a,0,0,r,i),m=_,p.setAttribute("transform",v),p.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.toDataURL()),o.appendChild(p))},n.prototype.createPattern=function(t,e){var r,i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=l(this.__ids);return i.setAttribute("id",s),i.setAttribute("width",t.width),i.setAttribute("height",t.height),"CANVAS"===t.nodeName||"IMG"===t.nodeName?((r=this.__document.createElementNS("http://www.w3.org/2000/svg","image")).setAttribute("width",t.width),r.setAttribute("height",t.height),r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===t.nodeName?t.toDataURL():t.getAttribute("src")),i.appendChild(r),this.__defs.appendChild(i)):t instanceof n&&(i.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(i)),new a(i,this)},n.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},n.prototype.drawFocusRing=function(){},n.prototype.createImageData=function(){},n.prototype.getImageData=function(){},n.prototype.putImageData=function(){},n.prototype.globalCompositeOperation=function(){},n.prototype.setTransform=function(){},r.default=n},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var s=e(1),r=e(292),n=e(228),_=e(237),i=e(238),o=e(293),c=e(196),g=function(e){function t(t,a,s,r,n,_){void 0===n&&(n={}),void 0===_&&(_={});var i=e.call(this)||this;return i.x_scale=t,i.y_scale=a,i.x_range=s,i.y_range=r,i.extra_x_ranges=n,i.extra_y_ranges=_,i._configure_scales(),i}return s.__extends(t,e),t.prototype.map_to_screen=function(e,t,a,s){return void 0===a&&(a="default"),void 0===s&&(s="default"),[this.xscales[a].v_compute(e),this.yscales[s].v_compute(t)]},t.prototype._get_ranges=function(e,t){return Object.assign(Object.assign({},t),{default:e})},t.prototype._get_scales=function(e,t,a){var s={};for(var g in t){var l=t[g];if((l instanceof o.DataRange1d||l instanceof i.Range1d)&&!(e instanceof n.ContinuousScale))throw new Error("Range "+l.type+" is incompatible is Scale "+e.type);if(l instanceof c.FactorRange&&!(e instanceof r.CategoricalScale))throw new Error("Range "+l.type+" is incompatible is Scale "+e.type);e instanceof _.LogScale&&l instanceof o.DataRange1d&&(l.scale_hint="log");var u=e.clone();u.setv({source_range:l,target_range:a}),s[g]=u}return s},t.prototype._configure_frame_ranges=function(){this._h_target=new i.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new i.Range1d({start:this._bottom.value,end:this._top.value})},t.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)},t.prototype._update_scales=function(){for(var e in this._configure_frame_ranges(),this._xscales){this._xscales[e].target_range=this._h_target}for(var e in this._yscales){this._yscales[e].target_range=this._v_target}},t.prototype._set_geometry=function(t,a){e.prototype._set_geometry.call(this,t,a),this._update_scales()},Object.defineProperty(t.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"xscales",{get:function(){return this._xscales},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yscales",{get:function(){return this._yscales},enumerable:!0,configurable:!0}),t}(e(295).LayoutItem);a.CartesianFrame=g,g.__name__="CartesianFrame"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),o=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.compute=function(e){return t.prototype._linear_compute.call(this,this.source_range.synthetic(e))},e.prototype.v_compute=function(e){return t.prototype._linear_v_compute.call(this,this.source_range.v_synthetic(e))},e.prototype.invert=function(t){return this._linear_invert(t)},e.prototype.v_invert=function(t){return this._linear_v_invert(t)},e}(t(229).Scale);n.CategoricalScale=o,o.__name__="CategoricalScale"},
function _(t,i,n){Object.defineProperty(n,"__esModule",{value:!0});var e=t(1),a=t(294),r=t(186),s=t(178),l=e.__importStar(t(127)),o=e.__importStar(t(193)),_=t(117),d=function(t){function i(i){var n=t.call(this,i)||this;return n._plot_bounds={},n.have_updated_interactively=!1,n}return e.__extends(i,t),i.init_DataRange1d=function(){this.define({start:[l.Number],end:[l.Number],range_padding:[l.Number,.1],range_padding_units:[l.PaddingUnits,"percent"],flipped:[l.Boolean,!1],follow:[l.StartEnd],follow_interval:[l.Number],default_span:[l.Number,2],only_visible:[l.Boolean,!1]}),this.internal({scale_hint:[l.String,"auto"]})},i.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span},Object.defineProperty(i.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),i.prototype.computed_renderers=function(){var t=this.names,i=this.renderers;if(0==i.length)for(var n=0,e=this.plots;n<e.length;n++){var a=e[n].renderers.filter((function(t){return t instanceof r.GlyphRenderer}));i=i.concat(a)}t.length>0&&(i=i.filter((function(i){return _.includes(t,i.name)}))),s.logger.debug("computed "+i.length+" renderers for DataRange1d "+this.id);for(var l=0,o=i;l<o.length;l++){var d=o[l];s.logger.trace(" - "+d.type+" "+d.id)}return i},i.prototype._compute_plot_bounds=function(t,i){for(var n=o.empty(),e=0,a=t;e<a.length;e++){var r=a[e];null==i[r.id]||!r.visible&&this.only_visible||(n=o.union(n,i[r.id]))}return n},i.prototype.adjust_bounds_for_aspect=function(t,i){var n=o.empty(),e=t.x1-t.x0;e<=0&&(e=1);var a=t.y1-t.y0;a<=0&&(a=1);var r=.5*(t.x1+t.x0),s=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=r+.5*e,n.x0=r-.5*e,n.y1=s+.5*a,n.y0=s-.5*a,n},i.prototype._compute_min_max=function(t,i){var n,e,a,r,s=o.empty();for(var l in t){var _=t[l];s=o.union(s,_)}return 0==i?(a=(n=[s.x0,s.x1])[0],r=n[1]):(a=(e=[s.y0,s.y1])[0],r=e[1]),[a,r]},i.prototype._compute_range=function(t,i){var n,e,a,r=this.range_padding;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,s.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,s.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i));var l=void 0,o=void 0;if(i==t)o=this.default_span+.001,l=Math.log(t)/Math.log(10);else{var _=void 0,d=void 0;"percent"==this.range_padding_units?(_=Math.log(t)/Math.log(10),o=((d=Math.log(i)/Math.log(10))-_)*(1+r)):(_=Math.log(t-r)/Math.log(10),o=(d=Math.log(i+r)/Math.log(10))-_),l=(_+d)/2}e=Math.pow(10,l-o/2),a=Math.pow(10,l+o/2)}else{o=void 0;e=(l=(i+t)/2)-(o=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+r):i-t+2*r)/2,a=l+o/2}var h=1;this.flipped&&(e=(n=[a,e])[0],a=n[1],h=-1);var u=this.follow_interval;return null!=u&&Math.abs(e-a)>u&&("start"==this.follow?a=e+h*u:"end"==this.follow&&(e=a-h*u)),[e,a]},i.prototype.update=function(t,i,n,e){if(!this.have_updated_interactively){var a=this.computed_renderers(),r=this._compute_plot_bounds(a,t);null!=e&&(r=this.adjust_bounds_for_aspect(r,e)),this._plot_bounds[n]=r;var s=this._compute_min_max(this._plot_bounds,i),l=s[0],o=s[1],_=this._compute_range(l,o),d=_[0],h=_[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(d=this._initial_start):d=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);var u=[this.start,this.end],p=u[0],g=u[1];if(d!=p||h!=g){var f={};d!=p&&(f.start=d),h!=g&&(f.end=h),this.setv(f)}"auto"==this.bounds&&this.setv({bounds:[d,h]},{silent:!0}),this.change.emit()}},i.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},i}(a.DataRange);n.DataRange1d=d,d.__name__="DataRange1d",d.init_DataRange1d()},
function _(e,n,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(1),r=e(197),i=t.__importStar(e(127)),_=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_DataRange=function(){this.define({names:[i.Array,[]],renderers:[i.Array,[]]})},n}(r.Range);a.DataRange=_,_.__name__="DataRange",_.init_DataRange()},
function _(a,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=a(296);t.Sizeable=e.Sizeable;var r=a(297);t.Layoutable=r.Layoutable,t.LayoutItem=r.LayoutItem;var n=a(298);t.HStack=n.HStack,t.VStack=n.VStack,t.AnchorLayout=n.AnchorLayout;var u=a(299);t.Grid=u.Grid,t.Row=u.Row,t.Column=u.Column;var c=a(300);t.ContentBox=c.ContentBox,t.VariadicBox=c.VariadicBox},
function _(t,h,i){Object.defineProperty(i,"__esModule",{value:!0});var e=Math.min,n=Math.max,o=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(h){var i=h.width,e=h.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=e?e:this.height})},t.prototype.expanded_to=function(h){var i=h.width,e=h.height;return new t({width:i!=1/0?n(this.width,i):this.width,height:e!=1/0?n(this.height,e):this.height})},t.prototype.expand_to=function(t){var h=t.width,i=t.height;this.width=n(this.width,h),this.height=n(this.height,i)},t.prototype.narrowed_to=function(h){var i=h.width,n=h.height;return new t({width:e(this.width,i),height:e(this.height,n)})},t.prototype.narrow_to=function(t){var h=t.width,i=t.height;this.width=e(this.width,h),this.height=e(this.height,i)},t.prototype.grow_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:this.width+i+e,height:this.height+n+o})},t.prototype.shrink_by=function(h){var i=h.left,e=h.right,o=h.top,r=h.bottom;return new t({width:n(this.width-i-e,0),height:n(this.height-o-r,0)})},t.prototype.map=function(h,i){return new t({width:h(this.width),height:(null!=i?i:h)(this.height)})},t}();i.Sizeable=o,o.__name__="Sizeable"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var h=i(1),n=i(296),s=i(193),r=Math.min,g=Math.max,o=Math.round,a=function(){function i(){this._bbox=new s.BBox,this._inner_bbox=new s.BBox;var i=this;this._top={get value(){return i.bbox.top}},this._left={get value(){return i.bbox.left}},this._width={get value(){return i.bbox.width}},this._height={get value(){return i.bbox.height}},this._right={get value(){return i.bbox.right}},this._bottom={get value(){return i.bbox.bottom}},this._hcenter={get value(){return i.bbox.hcenter}},this._vcenter={get value(){return i.bbox.vcenter}}}return Object.defineProperty(i.prototype,"bbox",{get:function(){return this._bbox},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"sizing",{get:function(){return this._sizing},enumerable:!0,configurable:!0}),i.prototype.set_sizing=function(i){var t=i.width_policy||"fit",e=i.width,h=null!=i.min_width?i.min_width:0,n=null!=i.max_width?i.max_width:1/0,s=i.height_policy||"fit",r=i.height,g=null!=i.min_height?i.min_height:0,o=null!=i.max_height?i.max_height:1/0,a=i.aspect,u=i.margin||{top:0,right:0,bottom:0,left:0},l=!1!==i.visible,_=i.halign||"start",d=i.valign||"start";this._sizing={width_policy:t,min_width:h,width:e,max_width:n,height_policy:s,min_height:g,height:r,max_height:o,aspect:a,margin:u,visible:l,halign:_,valign:d,size:{width:e,height:r},min_size:{width:h,height:g},max_size:{width:n,height:o}},this._init()},i.prototype._init=function(){},i.prototype._set_geometry=function(i,t){this._bbox=i,this._inner_bbox=t},i.prototype.set_geometry=function(i,t){this._set_geometry(i,t||i)},i.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},i.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},i.prototype.apply_aspect=function(i,t){var e=t.width,h=t.height,n=this.sizing.aspect;if(null!=n){var s=this.sizing,r=s.width_policy,g=s.height_policy;if("fixed"!=r&&"fixed"!=g)if(r==g){var a=e,u=o(e/n),l=o(h*n),_=h;Math.abs(i.width-a)+Math.abs(i.height-u)<=Math.abs(i.width-l)+Math.abs(i.height-_)?(e=a,h=u):(e=l,h=_)}else!function(i,t){var e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]}(r,g)?e=o(h*n):h=o(e/n);else"fixed"==r?h=o(e/n):"fixed"==g&&(e=o(h*n))}return{width:e,height:h}},i.prototype.measure=function(i){var t=this;if(!this.sizing.visible)return{width:0,height:0};var e=function(i){return"fixed"==t.sizing.width_policy&&null!=t.sizing.width?t.sizing.width:i},h=function(i){return"fixed"==t.sizing.height_policy&&null!=t.sizing.height?t.sizing.height:i},s=new n.Sizeable(i).shrink_by(this.sizing.margin).map(e,h),r=this._measure(s),g=this.clip_size(r),o=e(g.width),a=h(g.height),u=this.apply_aspect(s,{width:o,height:a});return Object.assign(Object.assign({},r),u)},i.prototype.compute=function(i){void 0===i&&(i={});var t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),e=t.width,h=t.height,n=new s.BBox({left:0,top:0,width:e,height:h}),r=void 0;if(null!=t.inner){var g=t.inner,o=g.left,a=g.top,u=g.right,l=g.bottom;r=new s.BBox({left:o,top:a,right:e-u,bottom:h-l})}this.set_geometry(n,r)},Object.defineProperty(i.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!0,configurable:!0}),i.prototype.clip_width=function(i){return g(this.sizing.min_width,r(i,this.sizing.max_width))},i.prototype.clip_height=function(i){return g(this.sizing.min_height,r(i,this.sizing.max_height))},i.prototype.clip_size=function(i){var t=i.width,e=i.height;return{width:this.clip_width(t),height:this.clip_height(e)}},i}();e.Layoutable=a,a.__name__="Layoutable";var u=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return h.__extends(t,i),t.prototype._measure=function(i){var t,e,h=this.sizing,n=h.width_policy,s=h.height_policy;if(i.width==1/0)t=null!=this.sizing.width?this.sizing.width:0;else switch(n){case"fixed":t=null!=this.sizing.width?this.sizing.width:0;break;case"min":t=null!=this.sizing.width?r(i.width,this.sizing.width):0;break;case"fit":t=null!=this.sizing.width?r(i.width,this.sizing.width):i.width;break;case"max":t=null!=this.sizing.width?g(i.width,this.sizing.width):i.width}if(i.height==1/0)e=null!=this.sizing.height?this.sizing.height:0;else switch(s){case"fixed":e=null!=this.sizing.height?this.sizing.height:0;break;case"min":e=null!=this.sizing.height?r(i.height,this.sizing.height):0;break;case"fit":e=null!=this.sizing.height?r(i.height,this.sizing.height):i.height;break;case"max":e=null!=this.sizing.height?g(i.height,this.sizing.height):i.height}return{width:t,height:e}},t}(a);e.LayoutItem=u,u.__name__="LayoutItem";var l=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return h.__extends(t,i),t.prototype._measure=function(i){var t=this,e=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(e);return{width:function(){switch(t.sizing.width_policy){case"fixed":return null!=t.sizing.width?t.sizing.width:e.width;case"min":return e.width;case"fit":return h.width;case"max":return Math.max(e.width,h.width)}}(),height:function(){switch(t.sizing.height_policy){case"fixed":return null!=t.sizing.height?t.sizing.height:e.height;case"min":return e.height;case"fit":return h.height;case"max":return Math.max(e.height,h.height)}}()}},t}(a);e.ContentLayoutable=l,l.__name__="ContentLayoutable"},
function _(t,e,h){Object.defineProperty(h,"__esModule",{value:!0});var r=t(1),o=t(297),i=t(193),n=function(t){function e(){var e=t.apply(this,arguments)||this;return e.children=[],e}return r.__extends(e,t),e}(o.Layoutable);h.Stack=n,n.__name__="Stack";var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._measure=function(t){for(var e=0,h=0,r=0,o=this.children;r<o.length;r++){var i=o[r].measure({width:0,height:0});e+=i.width,h=Math.max(h,i.height)}return{width:e,height:h}},e.prototype._set_geometry=function(e,h){t.prototype._set_geometry.call(this,e,h);for(var r=e.top,o=e.bottom,n=e.left,a=0,c=this.children;a<c.length;a++){var _=c[a],s=_.measure({width:0,height:0}).width;_.set_geometry(new i.BBox({left:n,width:s,top:r,bottom:o})),n+=s}},e}(n);h.HStack=a,a.__name__="HStack";var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._measure=function(t){for(var e=0,h=0,r=0,o=this.children;r<o.length;r++){var i=o[r].measure({width:0,height:0});e=Math.max(e,i.width),h+=i.height}return{width:e,height:h}},e.prototype._set_geometry=function(e,h){t.prototype._set_geometry.call(this,e,h);for(var r=e.left,o=e.right,n=e.top,a=0,c=this.children;a<c.length;a++){var _=c[a],s=_.measure({width:0,height:0}).height;_.set_geometry(new i.BBox({top:n,height:s,left:r,right:o})),n+=s}},e}(n);h.VStack=c,c.__name__="VStack";var _=function(t){function e(){var e=t.apply(this,arguments)||this;return e.children=[],e}return r.__extends(e,t),e.prototype._measure=function(t){for(var e=0,h=0,r=0,o=this.children;r<o.length;r++){var i=o[r].layout.measure(t);e=Math.max(e,i.width),h=Math.max(h,i.height)}return{width:e,height:h}},e.prototype._set_geometry=function(e,h){t.prototype._set_geometry.call(this,e,h);for(var r=0,o=this.children;r<o.length;r++){var n=o[r],a=n.layout,c=n.anchor,_=n.margin,s=e.left,g=e.right,l=e.top,u=e.bottom,p=e.hcenter,d=e.vcenter,m=a.measure(e),w=m.width,f=m.height,y=void 0;switch(c){case"top_left":y=new i.BBox({left:s+_,top:l+_,width:w,height:f});break;case"top_center":y=new i.BBox({hcenter:p,top:l+_,width:w,height:f});break;case"top_right":y=new i.BBox({right:g-_,top:l+_,width:w,height:f});break;case"bottom_right":y=new i.BBox({right:g-_,bottom:u-_,width:w,height:f});break;case"bottom_center":y=new i.BBox({hcenter:p,bottom:u-_,width:w,height:f});break;case"bottom_left":y=new i.BBox({left:s+_,bottom:u-_,width:w,height:f});break;case"center_left":y=new i.BBox({left:s+_,vcenter:d,width:w,height:f});break;case"center":y=new i.BBox({hcenter:p,vcenter:d,width:w,height:f});break;case"center_right":y=new i.BBox({right:g-_,vcenter:d,width:w,height:f})}a.set_geometry(y)}},e}(o.Layoutable);h.AnchorLayout=_,_.__name__="AnchorLayout"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),r=t(296),o=t(297),s=t(116),a=t(193),h=t(117),c=Math.max,l=Math.round,u=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i},t.prototype.apply=function(t,i){var e=this.get(t);this._map.set(t,i(e))},t}();u.__name__="DefaultMap";var f=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!0,configurable:!0}),t.prototype.add=function(t,i){var e=t.r1,n=t.c1;this._nrows=c(this._nrows,e+1),this._ncols=c(this._ncols,n+1),this._items.push({span:t,data:i})},t.prototype.at=function(t,i){return this._items.filter((function(e){var n=e.span;return n.r0<=t&&t<=n.r1&&n.c0<=i&&i<=n.c1})).map((function(t){return t.data}))},t.prototype.row=function(t){return this._items.filter((function(i){var e=i.span;return e.r0<=t&&t<=e.r1})).map((function(t){return t.data}))},t.prototype.col=function(t){return this._items.filter((function(i){var e=i.span;return e.c0<=t&&t<=e.c1})).map((function(t){return t.data}))},t.prototype.foreach=function(t){for(var i=0,e=this._items;i<e.length;i++){var n=e[i];t(n.span,n.data)}},t.prototype.map=function(i){for(var e=new t,n=0,r=this._items;n<r.length;n++){var o=r[n],s=o.span,a=o.data;e.add(s,i(s,a))}return e},t}();f.__name__="Container";var p=function(t){function i(i){void 0===i&&(i=[]);var e=t.call(this)||this;return e.items=i,e.rows="auto",e.cols="auto",e.spacing=0,e.absolute=!1,e}return n.__extends(i,t),i.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var i=this._state.cols;return h.some(i,(function(t){return"max"==t.policy}))},i.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var i=this._state.rows;return h.some(i,(function(t){return"max"==t.policy}))},i.prototype._init=function(){var i=this;t.prototype._init.call(this);for(var e=new f,n=0,r=this.items;n<r.length;n++){var o=r[n],a=o.layout,c=o.row,l=o.col,u=o.row_span,p=o.col_span;if(a.sizing.visible){var g=c,_=l,d=c+(null!=u?u:1)-1,w=l+(null!=p?p:1)-1;e.add({r0:g,c0:_,r1:d,c1:w},a)}}for(var y=e.nrows,m=e.ncols,v=new Array(y),x=function(t){var n,r=null==(n=s.isPlainObject(i.rows)?i.rows[t]||i.rows["*"]:i.rows)?{policy:"auto"}:s.isNumber(n)?{policy:"fixed",height:n}:s.isString(n)?{policy:n}:n,o=r.align||"auto";if("fixed"==r.policy)v[t]={policy:"fixed",height:r.height,align:o};else if("min"==r.policy)v[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)v[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");h.some(e.row(t),(function(t){return t.is_height_expanding()}))?v[t]={policy:"max",flex:1,align:o}:v[t]={policy:"min",align:o}}},b=0;b<y;b++)x(b);for(var z=new Array(m),j=function(t){var n,r=null==(n=s.isPlainObject(i.cols)?i.cols[t]||i.cols["*"]:i.cols)?{policy:"auto"}:s.isNumber(n)?{policy:"fixed",width:n}:s.isString(n)?{policy:n}:n,o=r.align||"auto";if("fixed"==r.policy)z[t]={policy:"fixed",width:r.width,align:o};else if("min"==r.policy)z[t]={policy:"min",align:o};else if("fit"==r.policy||"max"==r.policy)z[t]={policy:r.policy,flex:r.flex||1,align:o};else{if("auto"!=r.policy)throw new Error("unrechable");h.some(e.col(t),(function(t){return t.is_width_expanding()}))?z[t]={policy:"max",flex:1,align:o}:z[t]={policy:"min",align:o}}},O=0;O<m;O++)j(O);var B=s.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing,M=B[0],P=B[1];this._state={items:e,nrows:y,ncols:m,rows:v,cols:z,rspacing:M,cspacing:P}},i.prototype._measure_totals=function(t,i){var e=this._state,n=e.nrows,r=e.ncols,o=e.rspacing,s=e.cspacing;return{height:h.sum(t)+(n-1)*o,width:h.sum(i)+(r-1)*s}},i.prototype._measure_cells=function(t){for(var i=this._state,e=i.items,n=i.nrows,o=i.ncols,s=i.rows,a=i.cols,h=i.rspacing,u=i.cspacing,p=new Array(n),g=0;g<n;g++){var _=s[g];p[g]="fixed"==_.policy?_.height:0}for(var d=new Array(o),w=0;w<o;w++){var y=a[w];d[w]="fixed"==y.policy?y.width:0}var m=new f;return e.foreach((function(i,e){for(var n=i.r0,o=i.c0,f=i.r1,g=i.c1,_=(f-n)*h,w=(g-o)*u,y=0,v=n;v<=f;v++)y+=t(v,o).height;y+=_;for(var x=0,b=o;b<=g;b++)x+=t(n,b).width;x+=w;var z=e.measure({width:x,height:y});m.add(i,{layout:e,size_hint:z});var j=new r.Sizeable(z).grow_by(e.sizing.margin);j.height-=_,j.width-=w;var O=[];for(v=n;v<=f;v++){var B=s[v];"fixed"==B.policy?j.height-=B.height:O.push(v)}if(j.height>0)for(var M=l(j.height/O.length),P=0,A=O;P<A.length;P++){v=A[P];p[v]=c(p[v],M)}var C=[];for(b=o;b<=g;b++){var N=a[b];"fixed"==N.policy?j.width-=N.width:C.push(b)}if(j.width>0)for(var S=l(j.width/C.length),E=0,G=C;E<G.length;E++){b=G[E];d[b]=c(d[b],S)}})),{size:this._measure_totals(p,d),row_heights:p,col_widths:d,size_hints:m}},i.prototype._measure_grid=function(t){var i,e=this._state,n=e.nrows,r=e.ncols,o=e.rows,s=e.cols,a=e.rspacing,h=e.cspacing,u=this._measure_cells((function(t,i){var e=o[t],n=s[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==e.policy?e.height:1/0}}));i="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:u.size.height;for(var f,p=0,g=0;g<n;g++){"fit"==(w=o[g]).policy||"max"==w.policy?p+=w.flex:i-=u.row_heights[g]}if(i-=(n-1)*a,0!=p&&i>0)for(g=0;g<n;g++){if("fit"==(w=o[g]).policy||"max"==w.policy)i-=y=l(i*(w.flex/p)),u.row_heights[g]=y,p-=w.flex}else if(i<0){var _=0;for(g=0;g<n;g++){"fixed"!=(w=o[g]).policy&&_++}var d=-i;for(g=0;g<n;g++){var w;if("fixed"!=(w=o[g]).policy){var y=u.row_heights[g],m=l(d/_);u.row_heights[g]=c(y-m,0),d-=m>y?y:m,_--}}}f="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:u.size.width;for(var v=0,x=0;x<r;x++){"fit"==(z=s[x]).policy||"max"==z.policy?v+=z.flex:f-=u.col_widths[x]}if(f-=(r-1)*h,0!=v&&f>0)for(x=0;x<r;x++){if("fit"==(z=s[x]).policy||"max"==z.policy)f-=j=l(f*(z.flex/v)),u.col_widths[x]=j,v-=z.flex}else if(f<0){for(_=0,x=0;x<r;x++){"fixed"!=(z=s[x]).policy&&_++}var b=-f;for(x=0;x<r;x++){var z;if("fixed"!=(z=s[x]).policy){var j=u.col_widths[x];m=l(b/_);u.col_widths[x]=c(j-m,0),b-=m>j?j:m,_--}}}var O=this._measure_cells((function(t,i){return{width:u.col_widths[i],height:u.row_heights[t]}})),B=O.row_heights,M=O.col_widths,P=O.size_hints;return{size:this._measure_totals(B,M),row_heights:B,col_widths:M,size_hints:P}},i.prototype._measure=function(t){return this._measure_grid(t).size},i.prototype._set_geometry=function(i,e){t.prototype._set_geometry.call(this,i,e);for(var n=this._state,r=n.nrows,o=n.ncols,s=n.rspacing,h=n.cspacing,f=this._measure_grid(i),p=f.row_heights,g=f.col_widths,_=f.size_hints,d=this._state.rows.map((function(t,i){return Object.assign(Object.assign({},t),{top:0,height:p[i],get bottom(){return this.top+this.height}})})),w=this._state.cols.map((function(t,i){return Object.assign(Object.assign({},t),{left:0,width:g[i],get right(){return this.left+this.width}})})),y=_.map((function(t,i){return Object.assign(Object.assign({},i),{outer:new a.BBox,inner:new a.BBox})})),m=0,v=this.absolute?i.top:0;m<r;m++){var x=d[m];x.top=v,v+=x.height+s}for(var b=0,z=this.absolute?i.left:0;b<o;b++){var j=w[b];j.left=z,z+=j.width+h}y.foreach((function(t,i){var e=t.r0,n=t.c0,r=t.r1,o=t.c1,c=i.layout,u=i.size_hint,f=c.sizing,p=u.width,g=u.height,_=function(t,i){for(var e=(i-t)*h,n=t;n<=i;n++)e+=w[n].width;return e}(n,o),y=function(t,i){for(var e=(i-t)*s,n=t;n<=i;n++)e+=d[n].height;return e}(e,r),m=n==o&&"auto"!=w[n].align?w[n].align:f.halign,v=e==r&&"auto"!=d[e].align?d[e].align:f.valign,x=w[n].left;"start"==m?x+=f.margin.left:"center"==m?x+=l((_-p)/2):"end"==m&&(x+=_-f.margin.right-p);var b=d[e].top;"start"==v?b+=f.margin.top:"center"==v?b+=l((y-g)/2):"end"==v&&(b+=y-f.margin.bottom-g),i.outer=new a.BBox({left:x,top:b,width:p,height:g})}));var O=d.map((function(){return{start:new u((function(){return 0})),end:new u((function(){return 0}))}})),B=w.map((function(){return{start:new u((function(){return 0})),end:new u((function(){return 0}))}}));y.foreach((function(t,i){var e=t.r0,n=t.c0,r=t.r1,o=t.c1,s=i.size_hint,a=i.outer,h=s.inner;null!=h&&(O[e].start.apply(a.top,(function(t){return c(t,h.top)})),O[r].end.apply(d[r].bottom-a.bottom,(function(t){return c(t,h.bottom)})),B[n].start.apply(a.left,(function(t){return c(t,h.left)})),B[o].end.apply(w[o].right-a.right,(function(t){return c(t,h.right)})))})),y.foreach((function(t,i){var e=t.r0,n=t.c0,r=t.r1,o=t.c1,s=i.size_hint,h=i.outer;function c(t){var i=t.left,e=t.right,n=t.top,r=t.bottom,o=h.width-i-e,s=h.height-n-r;return new a.BBox({left:i,top:n,width:o,height:s})}if(null!=s.inner){var l=c(s.inner);if(!1!==s.align){var u=O[e].start.get(h.top),f=O[r].end.get(d[r].bottom-h.bottom),p=B[n].start.get(h.left),g=B[o].end.get(w[o].right-h.right);try{l=c({top:u,bottom:f,left:p,right:g})}catch(t){}}i.inner=l}else i.inner=h})),y.foreach((function(t,i){var e=i.layout,n=i.outer,r=i.inner;e.set_geometry(n,r)}))},i}(o.Layoutable);e.Grid=p,p.__name__="Grid";var g=function(t){function i(i){var e=t.call(this)||this;return e.items=i.map((function(t,i){return{layout:t,row:0,col:i}})),e.rows="fit",e}return n.__extends(i,t),i}(p);e.Row=g,g.__name__="Row";var _=function(t){function i(i){var e=t.call(this)||this;return e.items=i.map((function(t,i){return{layout:t,row:i,col:0}})),e.cols="fit",e}return n.__extends(i,t),i}(p);e.Column=_,_.__name__="Column"},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),o=e(297),r=e(296),a=e(174),u=function(e){function n(n){var t=e.call(this)||this;return t.content_size=a.unsized(n,(function(){return new r.Sizeable(a.size(n))})),t}return i.__extends(n,e),n.prototype._content_size=function(){return this.content_size},n}(o.ContentLayoutable);t.ContentBox=u,u.__name__="ContentBox";var _=function(e){function n(n){var t=e.call(this)||this;return t.el=n,t}return i.__extends(n,e),n.prototype._measure=function(e){var n=this,t=new r.Sizeable(e).bounded_to(this.sizing.size);return a.sized(this.el,t,(function(){var e=new r.Sizeable(a.content_size(n.el)),t=a.extents(n.el),i=t.border,o=t.padding;return e.grow_by(i).grow_by(o).map(Math.ceil)}))},n}(o.Layoutable);t.VariadicBox=_,_.__name__="VariadicBox"},
function _(e,r,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(302);u.Expression=a.Expression;var n=e(303);u.Stack=n.Stack;var o=e(304);u.CumSum=o.CumSum},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),r=function(t){function e(e){var n=t.call(this,e)||this;return n._connected={},n._result={},n}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._connected={},this._result={}},e.prototype.v_compute=function(t){var e=this;null==this._connected[t.id]&&(this.connect(t.change,(function(){return delete e._result[t.id]})),this.connect(t.patching,(function(){return delete e._result[t.id]})),this.connect(t.streaming,(function(){return delete e._result[t.id]})),this._connected[t.id]=!0);var n=this._result[t.id];return null==n&&(this._result[t.id]=n=this._v_compute(t)),n},e}(t(177).Model);n.Expression=r,r.__name__="Expression"},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),r=t(302),a=i.__importStar(t(127)),o=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_Stack=function(){this.define({fields:[a.Array,[]]})},n.prototype._v_compute=function(t){for(var n,e=null!==(n=t.get_length())&&void 0!==n?n:0,i=new Float64Array(e),r=0,a=this.fields;r<a.length;r++){var o=a[r],_=t.data[o];if(null!=_)for(var l=0,u=Math.min(e,_.length);l<u;l++)i[l]+=_[l]}return i},n}(r.Expression);e.Stack=o,o.__name__="Stack",o.init_Stack()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(302),u=i.__importStar(e(127)),o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_CumSum=function(){this.define({field:[u.String],include_zero:[u.Boolean,!1]})},t.prototype._v_compute=function(e){var t=new Float64Array(e.get_length()||0),n=e.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(var r=1;r<t.length;r++)t[r]=t[r-1]+n[r-i];return t},t}(r.Expression);n.CumSum=o,o.__name__="CumSum",o.init_CumSum()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(306);t.BooleanFilter=l.BooleanFilter;var i=e(308);t.CustomJSFilter=i.CustomJSFilter;var o=e(307);t.Filter=o.Filter;var F=e(309);t.GroupFilter=F.GroupFilter;var a=e(310);t.IndexFilter=a.IndexFilter},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(1),l=e(307),i=t.__importStar(e(127)),r=e(178),a=e(117),s=e(116),u=function(e){function n(n){return e.call(this,n)||this}return t.__extends(n,e),n.init_BooleanFilter=function(){this.define({booleans:[i.Array,null]})},n.prototype.compute_indices=function(e){var n=this.booleans;return null!=n&&n.length>0?a.every(n,s.isBoolean)?(n.length!==e.get_length()&&r.logger.warn("BooleanFilter "+this.id+": length of booleans doesn't match data source"),a.range(0,n.length).filter((function(e){return!0===n[e]}))):(r.logger.warn("BooleanFilter "+this.id+": booleans should be array of booleans, defaulting to no filtering"),null):(null!=n&&0==n.length?r.logger.warn("BooleanFilter "+this.id+": booleans is empty, defaulting to no filtering"):r.logger.warn("BooleanFilter "+this.id+": booleans was not set, defaulting to no filtering"),null)},n}(l.Filter);o.BooleanFilter=u,u.__name__="BooleanFilter",u.init_BooleanFilter()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(177),l=i.__importStar(e(127)),o=e(116),a=e(117),f=e(178),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Filter=function(){this.define({filter:[l.Array,null]})},t.prototype.compute_indices=function(e){var t=this.filter;return null!=t&&t.length>=0?o.isArrayOf(t,o.isBoolean)?a.range(0,t.length).filter((function(e){return!0===t[e]})):o.isArrayOf(t,o.isInteger)?t:(f.logger.warn("Filter "+this.id+": filter should either be array of only booleans or only integers, defaulting to no filtering"),null):(f.logger.warn("Filter "+this.id+": filter was not set to be an array, defaulting to no filtering"),null)},t}(n.Model);r.Filter=u,u.__name__="Filter",u.init_Filter()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),i=e(307),o=n.__importStar(e(127)),u=e(131),s=e(133),c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_CustomJSFilter=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(t.prototype,"names",{get:function(){return u.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return u.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=s.use_strict(this.code);return new(Function.bind.apply(Function,n.__spreadArrays([void 0],this.names,["source",e])))},enumerable:!0,configurable:!0}),t.prototype.compute_indices=function(t){return this.filter=this.func.apply(this,n.__spreadArrays(this.values,[t])),e.prototype.compute_indices.call(this,t)},t}(i.Filter);r.CustomJSFilter=c,c.__name__="CustomJSFilter",c.init_CustomJSFilter()},
function _(n,t,i){Object.defineProperty(i,"__esModule",{value:!0});var e=n(1),r=n(307),u=e.__importStar(n(127)),o=n(178),l=n(117),c=function(n){function t(t){var i=n.call(this,t)||this;return i.indices=null,i}return e.__extends(t,n),t.init_GroupFilter=function(){this.define({column_name:[u.String],group:[u.String]})},t.prototype.compute_indices=function(n){var t=this,i=n.get_column(this.column_name);return null==i?(o.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=l.range(0,n.get_length()||0).filter((function(n){return i[n]===t.group})),0===this.indices.length&&o.logger.warn("group filter: group '"+this.group+"' did not match any values in column '"+this.column_name+"'"),this.indices)},t}(r.Filter);i.GroupFilter=c,c.__name__="GroupFilter",c.init_GroupFilter()},
function _(i,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=i(1),r=i(307),l=t.__importStar(i(127)),s=i(178),d=i(116),o=i(117),u=function(i){function e(e){return i.call(this,e)||this}return t.__extends(e,i),e.init_IndexFilter=function(){this.define({indices:[l.Array,null]})},e.prototype.compute_indices=function(i){return null!=this.indices&&this.indices.length>=0?o.every(this.indices,d.isInteger)?this.indices:(s.logger.warn("IndexFilter "+this.id+": indices should be array of integers, defaulting to no filtering"),null):(s.logger.warn("IndexFilter "+this.id+": indices was not set, defaulting to no filtering"),null)},e}(r.Filter);n.IndexFilter=u,u.__name__="IndexFilter",u.init_IndexFilter()},
function _(r,t,a){Object.defineProperty(a,"__esModule",{value:!0});var e=r(220);a.BasicTickFormatter=e.BasicTickFormatter;var c=r(260);a.CategoricalTickFormatter=c.CategoricalTickFormatter;var i=r(264);a.DatetimeTickFormatter=i.DatetimeTickFormatter;var o=r(312);a.FuncTickFormatter=o.FuncTickFormatter;var m=r(277);a.LogTickFormatter=m.LogTickFormatter;var F=r(280);a.MercatorTickFormatter=F.MercatorTickFormatter;var k=r(313);a.NumeralTickFormatter=k.NumeralTickFormatter;var T=r(314);a.PrintfTickFormatter=T.PrintfTickFormatter;var v=r(221);a.TickFormatter=v.TickFormatter},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var r=t(1),i=t(221),o=r.__importStar(t(127)),a=t(131),u=t(133),c=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_FuncTickFormatter=function(){this.define({args:[o.Any,{}],code:[o.String,""]})},Object.defineProperty(e.prototype,"names",{get:function(){return a.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"values",{get:function(){return a.values(this.args)},enumerable:!0,configurable:!0}),e.prototype._make_func=function(){var t=u.use_strict(this.code);return new(Function.bind.apply(Function,r.__spreadArrays([void 0,"tick","index","ticks"],this.names,[t])))},e.prototype.doFormat=function(t,e){var n=this,i=this._make_func().bind({});return t.map((function(t,e,o){return i.apply(void 0,r.__spreadArrays([t,e,o],n.values))}))},e}(i.TickFormatter);n.FuncTickFormatter=c,c.__name__="FuncTickFormatter",c.init_FuncTickFormatter()},
function _(r,t,n){Object.defineProperty(n,"__esModule",{value:!0});var e=r(1),o=e.__importStar(r(267)),i=r(221),a=e.__importStar(r(127)),u=function(r){function t(t){return r.call(this,t)||this}return e.__extends(t,r),t.init_NumeralTickFormatter=function(){this.define({format:[a.String,"0,0"],language:[a.String,"en"],rounding:[a.RoundingFunction,"round"]})},Object.defineProperty(t.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!0,configurable:!0}),t.prototype.doFormat=function(r,t){var n=this.format,e=this.language,i=this._rounding_fn;return r.map((function(r){return o.format(r,n,e,i)}))},t}(i.TickFormatter);n.NumeralTickFormatter=u,u.__name__="NumeralTickFormatter",u.init_NumeralTickFormatter()},
function _(t,r,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),e=t(221),o=t(266),a=n.__importStar(t(127)),f=function(t){function r(r){return t.call(this,r)||this}return n.__extends(r,t),r.init_PrintfTickFormatter=function(){this.define({format:[a.String,"%s"]})},r.prototype.doFormat=function(t,r){var i=this;return t.map((function(t){return o.sprintf(i.format,t)}))},r}(e.TickFormatter);i.PrintfTickFormatter=f,f.__name__="PrintfTickFormatter",f.init_PrintfTickFormatter()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var v=a(316);r.AnnularWedge=v.AnnularWedge;var l=a(317);r.Annulus=l.Annulus;var t=a(318);r.Arc=t.Arc;var i=a(319);r.Bezier=i.Bezier;var n=a(320);r.Circle=n.Circle;var u=a(321);r.CenterRotatable=u.CenterRotatable;var c=a(322);r.Ellipse=c.Ellipse;var g=a(323);r.EllipseOval=g.EllipseOval;var A=a(194);r.Glyph=A.Glyph;var p=a(200);r.HArea=p.HArea;var s=a(324);r.HBar=s.HBar;var d=a(326);r.HexTile=d.HexTile;var R=a(327);r.Image=R.Image;var o=a(329);r.ImageRGBA=o.ImageRGBA;var y=a(330);r.ImageURL=y.ImageURL;var h=a(188);r.Line=h.Line;var m=a(332);r.MultiLine=m.MultiLine;var B=a(333);r.MultiPolygons=B.MultiPolygons;var P=a(334);r.Oval=P.Oval;var G=a(199);r.Patch=G.Patch;var H=a(335);r.Patches=H.Patches;var I=a(336);r.Quad=I.Quad;var L=a(337);r.Quadratic=L.Quadratic;var M=a(338);r.Ray=M.Ray;var O=a(339);r.Rect=O.Rect;var x=a(340);r.Segment=x.Segment;var C=a(341);r.Step=C.Step;var E=a(342);r.Text=E.Text;var Q=a(202);r.VArea=Q.VArea;var S=a(343);r.VBar=S.VBar;var T=a(344);r.Wedge=T.Wedge;var V=a(189);r.XYGlyph=V.XYGlyph},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),s=t(189),n=t(198),a=r.__importStar(t(195)),_=r.__importStar(t(127)),o=t(118),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(var t=0,e=this._start_angle.length;t<e;t++)this._angle[t]=this._end_angle[t]-this._start_angle[t]},e.prototype._render=function(t,e,i){for(var r=i.sx,s=i.sy,n=i._start_angle,a=i._angle,_=i.sinner_radius,o=i.souter_radius,u=this.model.properties.direction.value(),h=0,l=e;h<l.length;h++){var d=l[h];isNaN(r[d]+s[d]+_[d]+o[d]+n[d]+a[d])||(t.translate(r[d],s[d]),t.rotate(n[d]),t.moveTo(o[d],0),t.beginPath(),t.arc(0,0,o[d],0,a[d],u),t.rotate(a[d]),t.lineTo(_[d],0),t.arc(0,0,_[d],0,-a[d],!u),t.closePath(),t.rotate(-a[d]-n[d]),t.translate(-r[d],-s[d]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,d),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,d),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,r,s,n,_,u=t.sx,h=t.sy,l=this.renderer.xscale.invert(u),d=this.renderer.yscale.invert(h);if("data"==this.model.properties.outer_radius.units)r=l-this.max_outer_radius,n=l+this.max_outer_radius,s=d-this.max_outer_radius,_=d+this.max_outer_radius;else{var c=u-this.max_outer_radius,p=u+this.max_outer_radius;r=(e=this.renderer.xscale.r_invert(c,p))[0],n=e[1];var x=h-this.max_outer_radius,g=h+this.max_outer_radius;s=(i=this.renderer.yscale.r_invert(x,g))[0],_=i[1]}for(var v=[],y=0,f=this.index.indices({x0:r,x1:n,y0:s,y1:_});y<f.length;y++){var m=f[y],w=Math.pow(this.souter_radius[m],2),A=Math.pow(this.sinner_radius[m],2),M=this.renderer.xscale.r_compute(l,this._x[m]),S=(c=M[0],p=M[1],this.renderer.yscale.r_compute(d,this._y[m]));x=S[0],g=S[1];(k=Math.pow(c-p,2)+Math.pow(x-g,2))<=w&&k>=A&&v.push([m,k])}for(var W=this.model.properties.direction.value(),b=[],D=0,P=v;D<P.length;D++){var V=P[D],k=(m=V[0],V[1]),z=Math.atan2(h-this.sy[m],u-this.sx[m]);o.angle_between(-z,-this._start_angle[m],-this._end_angle[m],W)&&b.push([m,k])}return a.create_hit_test_result_from_hits(b)},e.prototype.draw_legend_for_index=function(t,e,i){n.generic_area_legend(this.visuals,t,e,i)},e.prototype._scenterxy=function(t){var e=(this.sinner_radius[t]+this.souter_radius[t])/2,i=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(i),y:this.sy[t]+e*Math.sin(i)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(s.XYGlyphView);i.AnnularWedgeView=u,u.__name__="AnnularWedgeView";var h=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_AnnularWedge=function(){this.prototype.default_view=u,this.mixins(["line","fill"]),this.define({direction:[_.Direction,"anticlock"],inner_radius:[_.DistanceSpec],outer_radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})},e}(s.XYGlyph);i.AnnularWedge=h,h.__name__="AnnularWedge",h.init_AnnularWedge()},
function _(r,i,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(1),s=r(189),a=e.__importStar(r(195)),n=e.__importStar(r(127)),u=r(209),_=function(r){function i(){return null!==r&&r.apply(this,arguments)||this}return e.__extends(i,r),i.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},i.prototype._render=function(r,i,t){for(var e=t.sx,s=t.sy,a=t.sinner_radius,n=t.souter_radius,_=0,h=i;_<h.length;_++){var o=h[_];if(!isNaN(e[o]+s[o]+a[o]+n[o])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(r,o),r.beginPath(),u.is_ie)for(var d=0,l=[!1,!0];d<l.length;d++){var c=l[d];r.arc(e[o],s[o],a[o],0,Math.PI,c),r.arc(e[o],s[o],n[o],Math.PI,0,!c)}else r.arc(e[o],s[o],a[o],0,2*Math.PI,!0),r.arc(e[o],s[o],n[o],2*Math.PI,0,!1);r.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(r,o),r.beginPath(),r.arc(e[o],s[o],a[o],0,2*Math.PI),r.moveTo(e[o]+n[o],s[o]),r.arc(e[o],s[o],n[o],0,2*Math.PI),r.stroke())}}},i.prototype._hit_point=function(r){var i,t,e,s,n,u,_=r.sx,h=r.sy,o=this.renderer.xscale.invert(_),d=this.renderer.yscale.invert(h);if("data"==this.model.properties.outer_radius.units)e=o-this.max_outer_radius,n=o+this.max_outer_radius,s=d-this.max_outer_radius,u=d+this.max_outer_radius;else{var l=_-this.max_outer_radius,c=_+this.max_outer_radius;e=(i=this.renderer.xscale.r_invert(l,c))[0],n=i[1];var p=h-this.max_outer_radius,v=h+this.max_outer_radius;s=(t=this.renderer.yscale.r_invert(p,v))[0],u=t[1]}for(var x=[],f=0,y=this.index.indices({x0:e,x1:n,y0:s,y1:u});f<y.length;f++){var m=y[f],M=Math.pow(this.souter_radius[m],2),w=Math.pow(this.sinner_radius[m],2),A=this.renderer.xscale.r_compute(o,this._x[m]),P=(l=A[0],c=A[1],this.renderer.yscale.r_compute(d,this._y[m])),g=(p=P[0],v=P[1],Math.pow(l-c,2)+Math.pow(p-v,2));g<=M&&g>=w&&x.push([m,g])}return a.create_hit_test_result_from_hits(x)},i.prototype.draw_legend_for_index=function(r,i,t){var e=i.x0,s=i.y0,a=i.x1,n=i.y1,u=t+1,_=new Array(u);_[t]=(e+a)/2;var h=new Array(u);h[t]=(s+n)/2;var o=.5*Math.min(Math.abs(a-e),Math.abs(n-s)),d=new Array(u);d[t]=.4*o;var l=new Array(u);l[t]=.8*o,this._render(r,[t],{sx:_,sy:h,sinner_radius:d,souter_radius:l})},i}(s.XYGlyphView);t.AnnulusView=_,_.__name__="AnnulusView";var h=function(r){function i(i){return r.call(this,i)||this}return e.__extends(i,r),i.init_Annulus=function(){this.prototype.default_view=_,this.mixins(["line","fill"]),this.define({inner_radius:[n.DistanceSpec],outer_radius:[n.DistanceSpec]})},i}(s.XYGlyph);t.Annulus=h,h.__name__="Annulus",h.init_Annulus()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=i(1),r=i(189),s=i(198),a=n.__importStar(i(127)),_=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(e,i),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(i,e,t){var n=t.sx,r=t.sy,s=t.sradius,a=t._start_angle,_=t._end_angle;if(this.visuals.line.doit)for(var o=this.model.properties.direction.value(),l=0,c=e;l<c.length;l++){var d=c[l];isNaN(n[d]+r[d]+s[d]+a[d]+_[d])||(i.beginPath(),i.arc(n[d],r[d],s[d],a[d],_[d],o),this.visuals.line.set_vectorize(i,d),i.stroke())}},e.prototype.draw_legend_for_index=function(i,e,t){s.generic_line_legend(this.visuals,i,e,t)},e}(r.XYGlyphView);t.ArcView=_,_.__name__="ArcView";var o=function(i){function e(e){return i.call(this,e)||this}return n.__extends(e,i),e.init_Arc=function(){this.prototype.default_view=_,this.mixins(["line"]),this.define({direction:[a.Direction,"anticlock"],radius:[a.DistanceSpec],start_angle:[a.AngleSpec],end_angle:[a.AngleSpec]})},e}(r.XYGlyph);t.Arc=o,o.__name__="Arc",o.init_Arc()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),r=t(190),s=t(194),a=t(198);function h(t,e,i,n,r,s,a,h){for(var o=[],_=[[],[]],c=0;c<=2;c++){var y=void 0,p=void 0,u=void 0;if(0===c?(p=6*t-12*i+6*r,y=-3*t+9*i-9*r+3*a,u=3*i-3*t):(p=6*e-12*n+6*s,y=-3*e+9*n-9*s+3*h,u=3*n-3*e),Math.abs(y)<1e-12){if(Math.abs(p)<1e-12)continue;0<(M=-u/p)&&M<1&&o.push(M)}else{var l=p*p-4*u*y,x=Math.sqrt(l);if(!(l<0)){var v=(-p+x)/(2*y);0<v&&v<1&&o.push(v);var f=(-p-x)/(2*y);0<f&&f<1&&o.push(f)}}}for(var d=o.length,m=d;d--;){var M,w=1-(M=o[d]),z=w*w*w*t+3*w*w*M*i+3*w*M*M*r+M*M*M*a;_[0][d]=z;var g=w*w*w*e+3*w*w*M*n+3*w*M*M*s+M*M*M*h;_[1][d]=g}return _[0][m]=t,_[1][m]=e,_[0][m+1]=a,_[1][m+1]=h,[Math.min.apply(Math,_[0]),Math.max.apply(Math,_[1]),Math.max.apply(Math,_[0]),Math.min.apply(Math,_[1])]}var o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e])){var n=h(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]),s=n[0],a=n[1],o=n[2],_=n[3];t.push({x0:s,y0:a,x1:o,y1:_,i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,s=i.sx1,a=i.sy1,h=i.scx0,o=i.scy0,_=i.scx1,c=i.scy1;if(this.visuals.line.doit)for(var y=0,p=e;y<p.length;y++){var u=p[y];isNaN(n[u]+r[u]+s[u]+a[u]+h[u]+o[u]+_[u]+c[u])||(t.beginPath(),t.moveTo(n[u],r[u]),t.bezierCurveTo(h[u],o[u],_[u],c[u],s[u],a[u]),this.visuals.line.set_vectorize(t,u),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){a.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(s.GlyphView);i.BezierView=o,o.__name__="BezierView";var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Bezier=function(){this.prototype.default_view=o,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(["line"])},e}(s.Glyph);i.Bezier=_,_.__name__="Bezier",_.init_Bezier()},
function _(i,s,e){Object.defineProperty(e,"__esModule",{value:!0});var t=i(1),r=i(189),a=t.__importStar(i(195)),n=t.__importStar(i(127)),h=i(117),d=i(120),_=function(i){function s(){return null!==i&&i.apply(this,arguments)||this}return t.__extends(s,i),s.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.spec.units)switch(this.model.properties.radius_dimension.spec.value){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":var i=this.sdist(this.renderer.xscale,this._x,this._radius),s=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=d.map(i,(function(i,e){return Math.max(i,s[e])}));break;case"min":i=this.sdist(this.renderer.xscale,this._x,this._radius);var e=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=d.map(i,(function(i,s){return Math.min(i,e[s])}))}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=d.map(this._size,(function(i){return i/2}))},s.prototype._mask_data=function(){var i,s,e,t,r,a,n,h,d=this.renderer.plot_view.frame.bbox.ranges,_=d[0],u=d[1];if(null!=this._radius&&"data"==this.model.properties.radius.units){var l=_.start,o=_.end;r=(i=this.renderer.xscale.r_invert(l,o))[0],n=i[1],r-=this.max_radius,n+=this.max_radius;var c=u.start,p=u.end;a=(s=this.renderer.yscale.r_invert(c,p))[0],h=s[1],a-=this.max_radius,h+=this.max_radius}else{l=_.start-this.max_size,o=_.end+this.max_size;r=(e=this.renderer.xscale.r_invert(l,o))[0],n=e[1];c=u.start-this.max_size,p=u.end+this.max_size;a=(t=this.renderer.yscale.r_invert(c,p))[0],h=t[1]}return this.index.indices({x0:r,x1:n,y0:a,y1:h})},s.prototype._render=function(i,s,e){for(var t=e.sx,r=e.sy,a=e.sradius,n=0,h=s;n<h.length;n++){var d=h[n];isNaN(t[d]+r[d]+a[d])||(i.beginPath(),i.arc(t[d],r[d],a[d],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,d),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,d),i.stroke()))}},s.prototype._hit_point=function(i){var s,e,t,r,n,h,d=i.sx,_=i.sy,u=this.renderer.xscale.invert(d),l=this.renderer.yscale.invert(_);if(null!=this._radius&&"data"==this.model.properties.radius.units)t=u-this.max_radius,r=u+this.max_radius,n=l-this.max_radius,h=l+this.max_radius;else{var o=d-this.max_size,c=d+this.max_size;t=(s=this.renderer.xscale.r_invert(o,c))[0],r=s[1];var p=_-this.max_size,x=_+this.max_size;n=(e=this.renderer.yscale.r_invert(p,x))[0],h=e[1]}var y=this.index.indices({x0:t,x1:r,y0:n,y1:h}),v=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(var m=0,f=y;m<f.length;m++){var z=f[m],w=Math.pow(this.sradius[z],2),M=this.renderer.xscale.r_compute(u,this._x[z]),g=(o=M[0],c=M[1],this.renderer.yscale.r_compute(l,this._y[z]));p=g[0],x=g[1];(k=Math.pow(o-c,2)+Math.pow(p-x,2))<=w&&v.push([z,k])}else for(var b=0,C=y;b<C.length;b++){var k;z=C[b],w=Math.pow(this.sradius[z],2);(k=Math.pow(this.sx[z]-d,2)+Math.pow(this.sy[z]-_,2))<=w&&v.push([z,k])}return a.create_hit_test_result_from_hits(v)},s.prototype._hit_span=function(i){var s,e,t,r,n,h,d,_,u=i.sx,l=i.sy,o=this.bounds(),c=a.create_empty_hit_test_result();if("h"==i.direction){var p=void 0,x=void 0;if(d=o.y0,_=o.y1,null!=this._radius&&"data"==this.model.properties.radius.units)p=u-this.max_radius,x=u+this.max_radius,n=(s=this.renderer.xscale.r_invert(p,x))[0],h=s[1];else p=u-(y=this.max_size/2),x=u+y,n=(e=this.renderer.xscale.r_invert(p,x))[0],h=e[1]}else{var y,v=void 0,m=void 0;if(n=o.x0,h=o.x1,null!=this._radius&&"data"==this.model.properties.radius.units)v=l-this.max_radius,m=l+this.max_radius,d=(t=this.renderer.yscale.r_invert(v,m))[0],_=t[1];else v=l-(y=this.max_size/2),m=l+y,d=(r=this.renderer.yscale.r_invert(v,m))[0],_=r[1]}var f=this.index.indices({x0:n,x1:h,y0:d,y1:_});return c.indices=f,c},s.prototype._hit_rect=function(i){var s=i.sx0,e=i.sx1,t=i.sy0,r=i.sy1,n=this.renderer.xscale.r_invert(s,e),h=n[0],d=n[1],_=this.renderer.yscale.r_invert(t,r),u=_[0],l=_[1],o=a.create_empty_hit_test_result();return o.indices=this.index.indices({x0:h,x1:d,y0:u,y1:l}),o},s.prototype._hit_poly=function(i){for(var s=i.sx,e=i.sy,t=h.range(0,this.sx.length),r=[],n=0,d=t.length;n<d;n++){var _=t[n];a.point_in_poly(this.sx[n],this.sy[n],s,e)&&r.push(_)}var u=a.create_empty_hit_test_result();return u.indices=r,u},s.prototype.draw_legend_for_index=function(i,s,e){var t=s.x0,r=s.y0,a=s.x1,n=s.y1,h=e+1,d=new Array(h);d[e]=(t+a)/2;var _=new Array(h);_[e]=(r+n)/2;var u=new Array(h);u[e]=.2*Math.min(Math.abs(a-t),Math.abs(n-r)),this._render(i,[e],{sx:d,sy:_,sradius:u})},s}(r.XYGlyphView);e.CircleView=_,_.__name__="CircleView";var u=function(i){function s(s){return i.call(this,s)||this}return t.__extends(s,i),s.init_Circle=function(){this.prototype.default_view=_,this.mixins(["line","fill"]),this.define({angle:[n.AngleSpec,0],size:[n.DistanceSpec,{units:"screen",value:4}],radius:[n.DistanceSpec],radius_dimension:[n.RadiusDimension,"x"]})},s.prototype.initialize=function(){i.prototype.initialize.call(this),this.properties.radius.optional=!0},s}(r.XYGlyph);e.Circle=u,u.__name__="Circle",u.init_Circle()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),a=e(189),l=i.__importStar(e(127)),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t}(a.XYGlyphView);n.CenterRotatableView=r,r.__name__="CenterRotatableView";var _=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_CenterRotatable=function(){this.mixins(["line","fill"]),this.define({angle:[l.AngleSpec,0],width:[l.DistanceSpec],height:[l.DistanceSpec]})},t}(a.XYGlyph);n.CenterRotatable=_,_.__name__="CenterRotatable",_.init_CenterRotatable()},
function _(e,i,l){Object.defineProperty(l,"__esModule",{value:!0});var n=e(1),t=e(323),_=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(i,e),i}(t.EllipseOvalView);l.EllipseView=_,_.__name__="EllipseView";var s=function(e){function i(i){return e.call(this,i)||this}return n.__extends(i,e),i.init_Ellipse=function(){this.prototype.default_view=_},i}(t.EllipseOval);l.Ellipse=s,s.__name__="Ellipse",s.init_Ellipse()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var s=t(1),h=t(321),r=s.__importStar(t(195)),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},i.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},i.prototype._render=function(t,i,e){for(var s=e.sx,h=e.sy,r=e.sw,a=e.sh,n=e._angle,_=0,l=i;_<l.length;_++){var o=l[_];isNaN(s[o]+h[o]+r[o]+a[o]+n[o])||(t.beginPath(),t.ellipse(s[o],h[o],r[o]/2,a[o]/2,n[o],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,o),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,o),t.stroke()))}},i.prototype._hit_point=function(t){var i,e,s,h,a,n,_,l,o,d,p,x,u,m=t.sx,w=t.sy,y=this.renderer.xscale.invert(m),c=this.renderer.yscale.invert(w);"data"==this.model.properties.width.units?(a=y-this.max_width,n=y+this.max_width):(d=m-this.max_width,p=m+this.max_width,a=(i=this.renderer.xscale.r_invert(d,p))[0],n=i[1]),"data"==this.model.properties.height.units?(_=c-this.max_height,l=c+this.max_height):(x=w-this.max_height,u=w+this.max_height,_=(e=this.renderer.yscale.r_invert(x,u))[0],l=e[1]);for(var v=[],f=0,g=this.index.indices({x0:a,x1:n,y0:_,y1:l});f<g.length;f++){var b=g[f];r.point_in_ellipse(m,w,this._angle[b],this.sh[b]/2,this.sw[b]/2,this.sx[b],this.sy[b])&&(d=(s=this.renderer.xscale.r_compute(y,this._x[b]))[0],p=s[1],x=(h=this.renderer.yscale.r_compute(c,this._y[b]))[0],u=h[1],o=Math.pow(d-p,2)+Math.pow(x-u,2),v.push([b,o]))}return r.create_hit_test_result_from_hits(v)},i.prototype.draw_legend_for_index=function(t,i,e){var s=i.x0,h=i.y0,r=i.x1,a=i.y1,n=e+1,_=new Array(n);_[e]=(s+r)/2;var l=new Array(n);l[e]=(h+a)/2;var o=this.sw[e]/this.sh[e],d=.8*Math.min(Math.abs(r-s),Math.abs(a-h)),p=new Array(n),x=new Array(n);o>1?(p[e]=d,x[e]=d/o):(p[e]=d*o,x[e]=d),this._render(t,[e],{sx:_,sy:l,sw:p,sh:x,_angle:[0]})},i.prototype._bounds=function(t){var i=t.x0,e=t.x1,s=t.y0,h=t.y1;return{x0:i-this.max_w2,x1:e+this.max_w2,y0:s-this.max_h2,y1:h+this.max_h2}},i}(h.CenterRotatableView);e.EllipseOvalView=a,a.__name__="EllipseOvalView";var n=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i}(h.CenterRotatable);e.EllipseOval=n,n.__name__="EllipseOval"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var s=t(1),r=t(325),h=s.__importStar(t(127)),n=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},i.prototype.scentery=function(t){return this.sy[t]},i.prototype._index_data=function(){return this._index_box(this._y.length)},i.prototype._lrtb=function(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]},i.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(var i=0;i<t;i++)this.stop[i]=this.sy[i]-this.sh[i]/2,this.sbottom[i]=this.sy[i]+this.sh[i]/2;this._clamp_viewport()},i}(r.BoxView);e.HBarView=n,n.__name__="HBarView";var o=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_HBar=function(){this.prototype.default_view=n,this.coords([["left","y"]]),this.define({height:[h.NumberSpec],right:[h.CoordinateSpec]}),this.override({left:0})},i}(r.Box);e.HBar=o,o.__name__="HBar",o.init_HBar()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=t(190),s=t(194),o=t(198),a=i.__importStar(t(195)),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.get_anchor_point=function(t,e,r){var i=Math.min(this.sleft[e],this.sright[e]),n=Math.max(this.sright[e],this.sleft[e]),s=Math.min(this.stop[e],this.sbottom[e]),o=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:s};case"top_center":return{x:(i+n)/2,y:s};case"top_right":return{x:n,y:s};case"bottom_left":return{x:i,y:o};case"bottom_center":return{x:(i+n)/2,y:o};case"bottom_right":return{x:n,y:o};case"center_left":return{x:i,y:(s+o)/2};case"center":return{x:(i+n)/2,y:(s+o)/2};case"center_right":return{x:n,y:(s+o)/2};default:return null}},e.prototype._index_box=function(t){for(var e=[],r=0;r<t;r++){var i=this._lrtb(r),s=i[0],o=i[1],a=i[2],h=i[3];!isNaN(s+o+a+h)&&isFinite(s+o+a+h)&&e.push({x0:Math.min(s,o),y0:Math.min(a,h),x1:Math.max(o,s),y1:Math.max(a,h),i:r})}return new n.SpatialIndex(e)},e.prototype._render=function(t,e,r){for(var i=this,n=r.sleft,s=r.sright,o=r.stop,a=r.sbottom,h=function(e){if(isNaN(n[e]+o[e]+s[e]+a[e]))return"continue";t.rect(n[e],o[e],s[e]-n[e],a[e]-o[e]),_.visuals.fill.doit&&(_.visuals.fill.set_vectorize(t,e),t.beginPath(),t.rect(n[e],o[e],s[e]-n[e],a[e]-o[e]),t.fill()),_.visuals.hatch.doit2(t,e,(function(){t.beginPath(),t.rect(n[e],o[e],s[e]-n[e],a[e]-o[e]),t.fill()}),(function(){return i.renderer.request_render()})),_.visuals.line.doit&&(_.visuals.line.set_vectorize(t,e),t.beginPath(),t.rect(n[e],o[e],s[e]-n[e],a[e]-o[e]),t.stroke())},_=this,c=0,l=e;c<l.length;c++){h(l[c])}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,r=this.stop.length,i=0;i<r;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,r=t.sy,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(r),s=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=a.create_empty_hit_test_result();return o.indices=s,o},e.prototype._hit_span=function(t){var e,r=t.sx,i=t.sy;if("v"==t.direction){var n=this.renderer.yscale.invert(i),s=this.renderer.plot_view.frame.bbox.h_range,o=this.renderer.xscale.r_invert(s.start,s.end),h=o[0],_=o[1];e=this.index.indices({x0:h,y0:n,x1:_,y1:n})}else{var c=this.renderer.xscale.invert(r),l=this.renderer.plot_view.frame.bbox.v_range,u=this.renderer.yscale.r_invert(l.start,l.end),x=u[0],p=u[1];e=this.index.indices({x0:c,y0:x,x1:c,y1:p})}var f=a.create_empty_hit_test_result();return f.indices=e,f},e.prototype.draw_legend_for_index=function(t,e,r){o.generic_area_legend(this.visuals,t,e,r)},e}(s.GlyphView);r.BoxView=h,h.__name__="BoxView";var _=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Box=function(){this.mixins(["line","fill","hatch"])},e}(s.Glyph);r.Box=_,_.__name__="Box",_.init_Box()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),r=e(194),n=s.__importStar(e(195)),a=s.__importStar(e(127)),o=e(190),h=e(198),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.scenterx=function(e){return this.sx[e]},t.prototype.scentery=function(e){return this.sy[e]},t.prototype._set_data=function(){var e=this._q.length,t=this.model.size,i=this.model.aspect_scale;if(this._x=new Float64Array(e),this._y=new Float64Array(e),"pointytop"==this.model.orientation)for(var s=0;s<e;s++)this._x[s]=t*Math.sqrt(3)*(this._q[s]+this._r[s]/2)/i,this._y[s]=3*-t/2*this._r[s];else for(s=0;s<e;s++)this._x[s]=3*t/2*this._q[s],this._y[s]=-t*Math.sqrt(3)*(this._r[s]+this._q[s]/2)*i},t.prototype._index_data=function(){var e,t=this.model.size,i=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?(i=(e=[t,i])[0],t=e[1],t*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var s=[],r=0;r<this._x.length;r++){var n=this._x[r],a=this._y[r];!isNaN(n+a)&&isFinite(n+a)&&s.push({x0:n-i,y0:a-t,x1:n+i,y1:a+t,i:r})}return new o.SpatialIndex(s)},t.prototype.map_data=function(){var e,t;e=this.map_to_screen(this._x,this._y),this.sx=e[0],this.sy=e[1],t=this._get_unscaled_vertices(),this.svx=t[0],this.svy=t[1]},t.prototype._get_unscaled_vertices=function(){var e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){var i=this.renderer.yscale,s=this.renderer.xscale,r=Math.abs(i.compute(0)-i.compute(e));return[[0,-(n=Math.sqrt(3)/2*Math.abs(s.compute(0)-s.compute(e))/t),-n,0,n,n],[r,a=r/2,-a,-r,-a,a]]}var n,a;i=this.renderer.xscale,s=this.renderer.yscale;return[[r=Math.abs(i.compute(0)-i.compute(e)),a=r/2,-a,-r,-a,a],[0,-(n=Math.sqrt(3)/2*Math.abs(s.compute(0)-s.compute(e))*t),-n,0,n,n]]},t.prototype._render=function(e,t,i){for(var s=i.sx,r=i.sy,n=i.svx,a=i.svy,o=i._scale,h=0,_=t;h<_.length;h++){var l=_[h];if(!isNaN(s[l]+r[l]+o[l])){e.translate(s[l],r[l]),e.beginPath();for(var c=0;c<6;c++)e.lineTo(n[c]*o[l],a[c]*o[l]);e.closePath(),e.translate(-s[l],-r[l]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,l),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,l),e.stroke())}}},t.prototype._hit_point=function(e){for(var t=e.sx,i=e.sy,s=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(i),a=[],o=0,h=this.index.indices({x0:s,y0:r,x1:s,y1:r});o<h.length;o++){var _=h[o];n.point_in_poly(t-this.sx[_],i-this.sy[_],this.svx,this.svy)&&a.push(_)}var l=n.create_empty_hit_test_result();return l.indices=a,l},t.prototype._hit_span=function(e){var t,i=e.sx,s=e.sy;if("v"==e.direction){var r=this.renderer.yscale.invert(s),a=this.renderer.plot_view.frame.bbox.h_range,o=this.renderer.xscale.r_invert(a.start,a.end),h=o[0],_=o[1];t=this.index.indices({x0:h,y0:r,x1:_,y1:r})}else{var l=this.renderer.xscale.invert(i),c=this.renderer.plot_view.frame.bbox.v_range,p=this.renderer.yscale.r_invert(c.start,c.end),d=p[0],y=p[1];t=this.index.indices({x0:l,y0:d,x1:l,y1:y})}var u=n.create_empty_hit_test_result();return u.indices=t,u},t.prototype._hit_rect=function(e){var t=e.sx0,i=e.sx1,s=e.sy0,r=e.sy1,a=this.renderer.xscale.r_invert(t,i),o=a[0],h=a[1],_=this.renderer.yscale.r_invert(s,r),l=_[0],c=_[1],p=n.create_empty_hit_test_result();return p.indices=this.index.indices({x0:o,x1:h,y0:l,y1:c}),p},t.prototype.draw_legend_for_index=function(e,t,i){h.generic_area_legend(this.visuals,e,t,i)},t}(r.GlyphView);i.HexTileView=_,_.__name__="HexTileView";var l=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_HexTile=function(){this.prototype.default_view=_,this.coords([["r","q"]]),this.mixins(["line","fill"]),this.define({size:[a.Number,1],aspect_scale:[a.Number,1],scale:[a.NumberSpec,1],orientation:[a.HexTileOrientation,"pointytop"]}),this.override({line_color:null})},t}(r.Glyph);i.HexTile=l,l.__name__="HexTile",l.init_HexTile()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var i=e(1),n=e(328),r=e(222),_=i.__importStar(e(127)),o=e(117),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this.connect(this.model.color_mapper.change,(function(){return t._update_image()})),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(),this.renderer.plot_view.request_render())},t.prototype._set_data=function(){this._set_width_heigh_data();for(var e=this.model.color_mapper.rgba_mapper,t=0,a=this._image.length;t<a;t++){var i=void 0;if(null!=this._image_shape&&this._image_shape[t].length>0){i=this._image[t];var n=this._image_shape[t];this._height[t]=n[0],this._width[t]=n[1]}else{var r=this._image[t];i=o.concat(r),this._height[t]=r.length,this._width[t]=r[0].length}var _=e.v_compute(i);this._set_image_data_from_buffer(t,_)}},t.prototype._render=function(e,t,a){var i=a.image_data,n=a.sx,r=a.sy,_=a.sw,o=a.sh,s=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(var h=0,l=t;h<l.length;h++){var g=l[h];if(null!=i[g]&&!isNaN(n[g]+r[g]+_[g]+o[g])){var m=r[g];e.translate(0,m),e.scale(1,-1),e.translate(0,-m),e.drawImage(i[g],0|n[g],0|r[g],_[g],o[g]),e.translate(0,m),e.scale(1,-1),e.translate(0,-m)}}e.setImageSmoothingEnabled(s)},t}(n.ImageBaseView);a.ImageView=s,s.__name__="ImageView";var h=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Image=function(){this.prototype.default_view=s,this.define({color_mapper:[_.Instance,function(){return new r.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]})},t}(n.ImageBase);a.Image=h,h.__name__="Image",h.init_Image()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),h=e(189),a=s.__importStar(e(127)),r=s.__importStar(e(195)),n=e(190),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._render=function(e,t,i){},t.prototype._index_data=function(){for(var e=[],t=0,i=this._x.length;t<i;t++){var s=this._lrtb(t),h=s[0],a=s[1],r=s[2],_=s[3];!isNaN(h+a+r+_)&&isFinite(h+a+r+_)&&e.push({x0:h,y0:_,x1:a,y1:r,i:t})}return new n.SpatialIndex(e)},t.prototype._lrtb=function(e){var t=this.renderer.xscale.source_range,i=this._x[e],s=t.is_reversed?i-this._dw[e]:i+this._dw[e],h=this.renderer.yscale.source_range,a=this._y[e],r=h.is_reversed?a-this._dh[e]:a+this._dh[e],n=i<s?[i,s]:[s,i],_=a<r?[a,r]:[r,a];return[n[0],n[1],_[1],_[0]]},t.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length))},t.prototype._get_or_create_canvas=function(e){var t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;var i=document.createElement("canvas");return i.width=this._width[e],i.height=this._height[e],i},t.prototype._set_image_data_from_buffer=function(e,t){var i=this._get_or_create_canvas(e),s=i.getContext("2d"),h=s.getImageData(0,0,this._width[e],this._height[e]);h.data.set(t),s.putImageData(h,0,0),this.image_data[e]=i},t.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},t.prototype._image_index=function(e,t,i){var s=this._lrtb(e),h=s[0],a=s[1],r=s[2],n=s[3],_=this._width[e],d=this._height[e],o=(a-h)/_,g=(r-n)/d,l=Math.floor((t-h)/o),c=Math.floor((i-n)/g);return this.renderer.xscale.source_range.is_reversed&&(l=_-l-1),this.renderer.yscale.source_range.is_reversed&&(c=d-c-1),{index:e,dim1:l,dim2:c,flat_index:c*_+l}},t.prototype._hit_point=function(e){var t=e.sx,i=e.sy,s=this.renderer.xscale.invert(t),h=this.renderer.yscale.invert(i),a=this.index.indices({x0:s,x1:s,y0:h,y1:h}),n=r.create_empty_hit_test_result();n.image_indices=[];for(var _=0,d=a;_<d.length;_++){var o=d[_];t!=1/0&&i!=1/0&&n.image_indices.push(this._image_index(o,s,h))}return n},t}(h.XYGlyphView);i.ImageBaseView=_,_.__name__="ImageBaseView";var d=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_ImageBase=function(){this.prototype.default_view=_,this.define({image:[a.NumberSpec],dw:[a.DistanceSpec],dh:[a.DistanceSpec],dilate:[a.Boolean,!1],global_alpha:[a.Number,1]})},t}(h.XYGlyph);i.ImageBase=d,d.__name__="ImageBase",d.init_ImageBase()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var i=e(1),n=e(328),r=e(117),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._set_data=function(e){this._set_width_heigh_data();for(var t=0,a=this._image.length;t<a;t++)if(!(null!=e&&e.indexOf(t)<0)){var i=void 0;if(null!=this._image_shape&&this._image_shape[t].length>0){i=this._image[t].buffer;var n=this._image_shape[t];this._height[t]=n[0],this._width[t]=n[1]}else{var h=this._image[t],s=r.concat(h);i=new ArrayBuffer(4*s.length);for(var _=new Uint32Array(i),l=0,o=s.length;l<o;l++)_[l]=s[l];this._height[t]=h.length,this._width[t]=h[0].length}var g=new Uint8Array(i);this._set_image_data_from_buffer(t,g)}},t.prototype._render=function(e,t,a){var i=a.image_data,n=a.sx,r=a.sy,h=a.sw,s=a.sh,_=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(var l=0,o=t;l<o.length;l++){var g=o[l];if(!isNaN(n[g]+r[g]+h[g]+s[g])){var m=r[g];e.translate(0,m),e.scale(1,-1),e.translate(0,-m),e.drawImage(i[g],0|n[g],0|r[g],h[g],s[g]),e.translate(0,m),e.scale(1,-1),e.translate(0,-m)}}e.setImageSmoothingEnabled(_)},t}(n.ImageBaseView);a.ImageRGBAView=h,h.__name__="ImageRGBAView";var s=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageRGBA=function(){this.prototype.default_view=h},t}(n.ImageBase);a.ImageRGBA=s,s.__name__="ImageRGBA",s.init_ImageRGBA()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=e(189),a=i.__importStar(e(127)),s=e(120),o=e(190),h=e(331),_=function(e){function t(){var t=e.apply(this,arguments)||this;return t._images_rendered=!1,t}return i.__extends(t,e),t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._index_data=function(){return new o.SpatialIndex([])},t.prototype._set_data=function(){var e=this;null!=this.image&&this.image.length==this._url.length||(this.image=s.map(this._url,(function(){return null})));for(var t=this.model,r=t.retry_attempts,i=t.retry_timeout,n=function(t,n){var s=a._url[t];if(null==s||""==s)return"continue";new h.ImageLoader(s,{loaded:function(r){e.image[t]=r,e.renderer.request_render()},attempts:r+1,timeout:i})},a=this,o=0,_=this._url.length;o<_;o++)n(o);var l="data"==this.model.properties.w.units,u="data"==this.model.properties.h.units,c=this._x.length,d=new Array(l?2*c:c),p=new Array(u?2*c:c);for(o=0;o<c;o++)d[o]=this._x[o],p[o]=this._y[o];if(l)for(o=0;o<c;o++)d[c+o]=this._x[o]+this._w[o];if(u)for(o=0;o<c;o++)p[c+o]=this._y[o]+this._h[o];var m=s.min(d),f=s.max(d),g=s.min(p),y=s.max(p);this._bounds_rect={x0:m,x1:f,y0:g,y1:y}},t.prototype.has_finished=function(){return e.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){var e=null!=this.model.w?this._w:s.map(this._x,(function(){return NaN})),t=null!=this.model.h?this._h:s.map(this._x,(function(){return NaN}));switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}},t.prototype._render=function(e,t,r){var i=r.image,n=r.sx,a=r.sy,s=r.sw,o=r.sh,h=r._angle,_=this.renderer.plot_view.frame;e.rect(_._left.value+1,_._top.value+1,_._width.value-2,_._height.value-2),e.clip();for(var l=!0,u=0,c=t;u<c.length;u++){var d=c[u];if(!isNaN(n[d]+a[d]+h[d])){var p=i[d];null!=p?this._render_image(e,d,p,n,a,s,o,h):l=!1}}l&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(e,t,r,i,n){switch(e){case"top_left":return[t,r];case"top_center":return[t-i/2,r];case"top_right":return[t-i,r];case"center_right":return[t-i,r-n/2];case"bottom_right":return[t-i,r-n];case"bottom_center":return[t-i/2,r-n];case"bottom_left":return[t,r-n];case"center_left":return[t,r-n/2];case"center":return[t-i/2,r-n/2]}},t.prototype._render_image=function(e,t,r,i,n,a,s,o){isNaN(a[t])&&(a[t]=r.width),isNaN(s[t])&&(s[t]=r.height);var h=this.model.anchor,_=this._final_sx_sy(h,i[t],n[t],a[t],s[t]),l=_[0],u=_[1];e.save(),e.globalAlpha=this.model.global_alpha;var c=a[t]/2,d=s[t]/2;o[t]?(e.translate(l,u),e.translate(c,d),e.rotate(o[t]),e.translate(-c,-d),e.drawImage(r,0,0,a[t],s[t]),e.translate(c,d),e.rotate(-o[t]),e.translate(-c,-d),e.translate(-l,-u)):e.drawImage(r,l,u,a[t],s[t]),e.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(n.XYGlyphView);r.ImageURLView=_,_.__name__="ImageURLView";var l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageURL=function(){this.prototype.default_view=_,this.define({url:[a.StringSpec],anchor:[a.Anchor,"top_left"],global_alpha:[a.Number,1],angle:[a.AngleSpec,0],w:[a.DistanceSpec],h:[a.DistanceSpec],dilate:[a.Boolean,!1],retry_attempts:[a.Number,0],retry_timeout:[a.Number,0]})},t}(n.XYGlyph);r.ImageURL=l,l.__name__="ImageURL",l.init_ImageURL()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(178),t=function(){function e(e,i){var n=this;void 0===i&&(i={}),this._image=new Image,this._finished=!1;var t=i.attempts,r=void 0===t?1:t,a=i.timeout,g=void 0===a?1:a;this.promise=new Promise((function(t,a){n._image.crossOrigin="anonymous";var u=0;n._image.onerror=function(){if(++u==r){var t="unable to load "+e+" image after "+r+" attempts";if(o.logger.warn(t),null==n._image.crossOrigin)return void(null!=i.failed&&i.failed());o.logger.warn("attempting to load "+e+" without a cross origin policy"),n._image.crossOrigin=null,u=0}setTimeout((function(){return n._image.src=e}),g)},n._image.onload=function(){n._finished=!0,null!=i.loaded&&i.loaded(n._image),t(n._image)},n._image.src=e}))}return Object.defineProperty(e.prototype,"finished",{get:function(){return this._finished},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"image",{get:function(){return this._image},enumerable:!0,configurable:!0}),e}();n.ImageLoader=t,t.__name__="ImageLoader"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(190),r=n.__importStar(t(195)),o=t(131),_=t(117),h=t(116),l=t(194),a=t(198),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)if(null!=this._xs[e]&&0!==this._xs[e].length){for(var n=this._xs[e],r=[],o=0,l=n.length;o<l;o++){var a=n[o];h.isStrictNaN(a)||r.push(a)}var u=this._ys[e],p=[];for(o=0,l=u.length;o<l;o++){var c=u[o];h.isStrictNaN(c)||p.push(c)}var y=[_.min(r),_.max(r)],x=y[0],f=y[1],v=[_.min(p),_.max(p)],d=v[0],m=v[1];t.push({x0:x,y0:d,x1:f,y1:m,i:e})}return new s.SpatialIndex(t)},e.prototype._render=function(t,e,i){for(var n=i.sxs,s=i.sys,r=0,o=e;r<o.length;r++){var _=o[r],h=[n[_],s[_]],l=h[0],a=h[1];this.visuals.line.set_vectorize(t,_);for(var u=0,p=l.length;u<p;u++)0!=u?isNaN(l[u])||isNaN(a[u])?(t.stroke(),t.beginPath()):t.lineTo(l[u],a[u]):(t.beginPath(),t.moveTo(l[u],a[u]));t.stroke()}},e.prototype._hit_point=function(t){for(var e=r.create_empty_hit_test_result(),i={x:t.sx,y:t.sy},n=9999,s={},_=0,h=this.sxs.length;_<h;_++){for(var l=Math.max(2,this.visuals.line.cache_select("line_width",_)/2),a=null,u=0,p=this.sxs[_].length-1;u<p;u++){var c={x:this.sxs[_][u],y:this.sys[_][u]},y={x:this.sxs[_][u+1],y:this.sys[_][u+1]},x=r.dist_to_segment(i,c,y);x<l&&x<n&&(n=x,a=[u])}a&&(s[_]=a)}return e.indices=o.keys(s).map((function(t){return parseInt(t,10)})),e.multiline_indices=s,e},e.prototype._hit_span=function(t){var e,i,n=t.sx,s=t.sy,_=r.create_empty_hit_test_result();"v"===t.direction?(e=this.renderer.yscale.invert(s),i=this._ys):(e=this.renderer.xscale.invert(n),i=this._xs);for(var h={},l=0,a=i.length;l<a;l++){for(var u=[],p=0,c=i[l].length-1;p<c;p++)i[l][p]<=e&&e<=i[l][p+1]&&u.push(p);u.length>0&&(h[l]=u)}return _.indices=o.keys(h).map((function(t){return parseInt(t,10)})),_.multiline_indices=h,_},e.prototype.get_interpolation_hit=function(t,e,i){var n=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]],s=n[0],r=n[1],o=n[2],_=n[3];return a.line_interpolation(this.renderer,i,s,r,o,_)},e.prototype.draw_legend_for_index=function(t,e,i){a.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(l.GlyphView);i.MultiLineView=u,u.__name__="MultiLineView";var p=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_MultiLine=function(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins(["line"])},e}(l.Glyph);i.MultiLine=p,p.__name__="MultiLine",p.init_MultiLine()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=t(190),s=t(194),o=t(198),h=t(117),a=t(120),l=r.__importStar(t(195)),_=t(116),f=t(119),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var r=0,s=this._xs[e].length;r<s;r++){var o=this._xs[e][r][0],a=this._ys[e][r][0];0!=o.length&&t.push({x0:h.min(o),y0:h.min(a),x1:h.max(o),y1:h.max(a),i:e})}return this.hole_index=this._index_hole_data(),new n.SpatialIndex(t)},e.prototype._index_hole_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var r=0,s=this._xs[e].length;r<s;r++)if(this._xs[e][r].length>1)for(var o=1,a=this._xs[e][r].length;o<a;o++){var l=this._xs[e][r][o],_=this._ys[e][r][o];0!=l.length&&t.push({x0:h.min(l),y0:h.min(_),x1:h.max(l),y1:h.max(_),i:e})}return new n.SpatialIndex(t)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],r=e[1],n=this.renderer.plot_view.frame.y_ranges.default,s=[n.min,n.max],o=s[0],h=s[1];return this.index.indices({x0:i,x1:r,y0:o,y1:h}).sort((function(t,e){return t-e})).filter((function(t,e,i){return 0===e||t!==i[e-1]}))},e.prototype._inner_loop=function(t,e,i){t.beginPath();for(var r=0,n=e.length;r<n;r++)for(var s=0,o=e[r].length;s<o;s++){for(var h=e[r][s],a=i[r][s],l=0,_=h.length;l<_;l++)0!=l?t.lineTo(h[l],a[l]):t.moveTo(h[l],a[l]);t.closePath()}},e.prototype._render=function(t,e,i){var r=this,n=i.sxs,s=i.sys;if(this.visuals.fill.doit||this.visuals.line.doit)for(var o=function(e){var i=[n[e],s[e]],o=i[0],a=i[1];h.visuals.fill.doit&&(h.visuals.fill.set_vectorize(t,e),h._inner_loop(t,o,a),t.fill("evenodd")),h.visuals.hatch.doit2(t,e,(function(){r._inner_loop(t,o,a),t.fill("evenodd")}),(function(){return r.renderer.request_render()})),h.visuals.line.doit&&(h.visuals.line.set_vectorize(t,e),h._inner_loop(t,o,a),t.stroke())},h=this,a=0,l=e;a<l.length;a++){o(l[a])}},e.prototype._hit_rect=function(t){for(var e=t.sx0,i=t.sx1,r=t.sy0,n=t.sy1,s=[e,i,i,e],o=[r,r,n,n],h=this.renderer.xscale.r_invert(e,i),a=h[0],_=h[1],f=this.renderer.yscale.r_invert(r,n),u=f[0],y=f[1],p=this.index.indices({x0:a,x1:_,y0:u,y1:y}),d=[],v=0,c=p.length;v<c;v++){for(var x=p[v],g=this.sxs[x],m=this.sys[x],w=!0,P=0,A=g.length;P<A;P++){for(var b=0,M=g[P][0].length;b<M;b++){var k=g[P][0][b],S=m[P][0][b];if(!l.point_in_poly(k,S,s,o)){w=!1;break}}if(!w)break}w&&d.push(x)}var T=l.create_empty_hit_test_result();return T.indices=d,T},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,r=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(i),s=this.index.indices({x0:r,y0:n,x1:r,y1:n}),o=this.hole_index.indices({x0:r,y0:n,x1:r,y1:n}),h=[],a=0,_=s.length;a<_;a++)for(var f=s[a],u=this.sxs[f],y=this.sys[f],p=0,d=u.length;p<d;p++){var v=u[p].length;if(l.point_in_poly(e,i,u[p][0],y[p][0]))if(1==v)h.push(f);else if(-1==o.indexOf(f))h.push(f);else if(v>1){for(var c=!1,x=1;x<v;x++){var g=u[p][x],m=y[p][x];if(l.point_in_poly(e,i,g,m)){c=!0;break}}c||h.push(f)}}var w=l.create_empty_hit_test_result();return w.indices=h,w},e.prototype._get_snap_coord=function(t){return a.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxs[t].length)return this._get_snap_coord(this.sxs[t][0][0]);for(var r=this.sxs[t],n=this.sys[t],s=0,o=r.length;s<o;s++)if(l.point_in_poly(e,i,r[s][0],n[s][0]))return this._get_snap_coord(r[s][0]);f.unreachable()},e.prototype.scentery=function(t,e,i){if(1==this.sys[t].length)return this._get_snap_coord(this.sys[t][0][0]);for(var r=this.sxs[t],n=this.sys[t],s=0,o=r.length;s<o;s++)if(l.point_in_poly(e,i,r[s][0],n[s][0]))return this._get_snap_coord(n[s][0]);f.unreachable()},e.prototype.map_data=function(){for(var t=0,e=this.model._coords;t<e.length;t++){var i=e[t],r=i[0],n=i[1],s="s"+r,o="s"+n;if(n="_"+n,null!=this[r="_"+r]&&(_.isArray(this[r][0])||_.isTypedArray(this[r][0]))){var h=this[r].length;this[s]=new Array(h),this[o]=new Array(h);for(var a=0;a<h;a++){var l=this[r][a].length;this[s][a]=new Array(l),this[o][a]=new Array(l);for(var f=0;f<l;f++){var u=this[r][a][f].length;this[s][a][f]=new Array(u),this[o][a][f]=new Array(u);for(var y=0;y<u;y++){var p=this.map_to_screen(this[r][a][f][y],this[n][a][f][y]),d=p[0],v=p[1];this[s][a][f][y]=d,this[o][a][f][y]=v}}}}}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(s.GlyphView);i.MultiPolygonsView=u,u.__name__="MultiPolygonsView";var y=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_MultiPolygons=function(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e}(s.Glyph);i.MultiPolygons=y,y.__name__="MultiPolygons",y.init_MultiPolygons()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var s=t(1),h=t(323),n=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype._map_data=function(){var t,i=this._x.length;this.sw=new Float64Array(i),t="data"==this.model.properties.width.units?this.sdist(this.renderer.xscale,this._x,this._width,"center"):this._width;for(var e=0;e<i;e++)this.sw[e]=.75*t[e];"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},i}(h.EllipseOvalView);e.OvalView=n,n.__name__="OvalView";var r=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_Oval=function(){this.prototype.default_view=n},i}(h.EllipseOval);e.Oval=r,r.__name__="Oval",r.init_Oval()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),n=t(190),r=t(194),o=t(198),_=t(117),a=t(120),h=t(116),l=s.__importStar(t(195)),u=t(119),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._build_discontinuous_object=function(t){for(var e=[],i=0,s=t.length;i<s;i++){e[i]=[];for(var n=_.copy(t[i]);n.length>0;){var r=_.find_last_index(n,(function(t){return h.isStrictNaN(t)})),o=void 0;r>=0?o=n.splice(r):(o=n,n=[]);var a=o.filter((function(t){return!h.isStrictNaN(t)}));e[i].push(a)}}return e},e.prototype._index_data=function(){for(var t=this._build_discontinuous_object(this._xs),e=this._build_discontinuous_object(this._ys),i=[],s=0,r=this._xs.length;s<r;s++)for(var o=0,a=t[s].length;o<a;o++){var h=t[s][o],l=e[s][o];0!=h.length&&i.push({x0:_.min(h),y0:_.min(l),x1:_.max(h),y1:_.max(l),i:s})}return new n.SpatialIndex(i)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],s=e[1],n=this.renderer.plot_view.frame.y_ranges.default,r=[n.min,n.max],o=r[0],_=r[1];return this.index.indices({x0:i,x1:s,y0:o,y1:_}).sort((function(t,e){return t-e}))},e.prototype._inner_loop=function(t,e,i,s){for(var n=0,r=e.length;n<r;n++)0!=n?isNaN(e[n]+i[n])?(t.closePath(),s.apply(t),t.beginPath()):t.lineTo(e[n],i[n]):(t.beginPath(),t.moveTo(e[n],i[n]));t.closePath(),s.call(t)},e.prototype._render=function(t,e,i){var s=this,n=i.sxs,r=i.sys;this.sxss=this._build_discontinuous_object(n),this.syss=this._build_discontinuous_object(r);for(var o=function(e){var i=[n[e],r[e]],o=i[0],a=i[1];_.visuals.fill.doit&&(_.visuals.fill.set_vectorize(t,e),_._inner_loop(t,o,a,t.fill)),_.visuals.hatch.doit2(t,e,(function(){return s._inner_loop(t,o,a,t.fill)}),(function(){return s.renderer.request_render()})),_.visuals.line.doit&&(_.visuals.line.set_vectorize(t,e),_._inner_loop(t,o,a,t.stroke))},_=this,a=0,h=e;a<h.length;a++){o(h[a])}},e.prototype._hit_rect=function(t){for(var e=t.sx0,i=t.sx1,s=t.sy0,n=t.sy1,r=[e,i,i,e],o=[s,s,n,n],_=this.renderer.xscale.r_invert(e,i),a=_[0],h=_[1],u=this.renderer.yscale.r_invert(s,n),c=u[0],p=u[1],d=this.index.indices({x0:a,x1:h,y0:c,y1:p}),f=[],y=0,v=d.length;y<v;y++){for(var x=d[y],g=this.sxs[x],m=this.sys[x],b=!0,P=0,w=g.length;P<w;P++){var j=g[P],N=m[P];if(!l.point_in_poly(j,N,r,o)){b=!1;break}}b&&f.push(x)}var S=l.create_empty_hit_test_result();return S.indices=f,S},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,s=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(i),r=this.index.indices({x0:s,y0:n,x1:s,y1:n}),o=[],_=0,a=r.length;_<a;_++)for(var h=r[_],u=this.sxss[h],c=this.syss[h],p=0,d=u.length;p<d;p++)l.point_in_poly(e,i,u[p],c[p])&&o.push(h);var f=l.create_empty_hit_test_result();return f.indices=o,f},e.prototype._get_snap_coord=function(t){return a.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxss[t].length)return this._get_snap_coord(this.sxs[t]);for(var s=this.sxss[t],n=this.syss[t],r=0,o=s.length;r<o;r++)if(l.point_in_poly(e,i,s[r],n[r]))return this._get_snap_coord(s[r]);u.unreachable()},e.prototype.scentery=function(t,e,i){if(1==this.syss[t].length)return this._get_snap_coord(this.sys[t]);for(var s=this.sxss[t],n=this.syss[t],r=0,o=s.length;r<o;r++)if(l.point_in_poly(e,i,s[r],n[r]))return this._get_snap_coord(n[r]);u.unreachable()},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.PatchesView=c,c.__name__="PatchesView";var p=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Patches=function(){this.prototype.default_view=c,this.coords([["xs","ys"]]),this.mixins(["line","fill","hatch"])},e}(r.Glyph);i.Patches=p,p.__name__="Patches",p.init_Patches()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(325),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._right.length)},e.prototype._lrtb=function(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]},e}(o.BoxView);i.QuadView=r,r.__name__="QuadView";var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_Quad=function(){this.prototype.default_view=r,this.coords([["right","bottom"],["left","top"]])},e}(o.Box);i.Quad=u,u.__name__="Quad",u.init_Quad()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),r=t(190),s=t(194),a=t(198);function o(t,i,e){if(i==(t+e)/2)return[t,e];var n=(t-i)/(t-2*i+e),r=t*Math.pow(1-n,2)+2*i*(1-n)*n+e*Math.pow(n,2);return[Math.min(t,e,r),Math.max(t,e,r)]}var _=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._index_data=function(){for(var t=[],i=0,e=this._x0.length;i<e;i++)if(!isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx[i]+this._cy[i])){var n=o(this._x0[i],this._cx[i],this._x1[i]),s=n[0],a=n[1],_=o(this._y0[i],this._cy[i],this._y1[i]),h=_[0],u=_[1];t.push({x0:s,y0:h,x1:a,y1:u,i:i})}return new r.SpatialIndex(t)},i.prototype._render=function(t,i,e){var n=e.sx0,r=e.sy0,s=e.sx1,a=e.sy1,o=e.scx,_=e.scy;if(this.visuals.line.doit)for(var h=0,u=i;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+s[c]+a[c]+o[c]+_[c])||(t.beginPath(),t.moveTo(n[c],r[c]),t.quadraticCurveTo(o[c],_[c],s[c],a[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}},i.prototype.draw_legend_for_index=function(t,i,e){a.generic_line_legend(this.visuals,t,i,e)},i.prototype.scenterx=function(){throw new Error("not implemented")},i.prototype.scentery=function(){throw new Error("not implemented")},i}(s.GlyphView);e.QuadraticView=_,_.__name__="QuadraticView";var h=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Quadratic=function(){this.prototype.default_view=_,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(["line"])},i}(s.Glyph);e.Quadratic=h,h.__name__="Quadratic",h.init_Quadratic()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(189),s=e(198),a=n.__importStar(e(127)),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},t.prototype._render=function(e,t,i){var n=i.sx,r=i.sy,s=i.slength,a=i._angle;if(this.visuals.line.doit){for(var l=2*(this.renderer.plot_view.frame._width.value+this.renderer.plot_view.frame._height.value),_=0,h=s.length;_<h;_++)0==s[_]&&(s[_]=l);for(var o=0,u=t;o<u.length;o++){_=u[o];isNaN(n[_]+r[_]+a[_]+s[_])||(e.translate(n[_],r[_]),e.rotate(a[_]),e.beginPath(),e.moveTo(0,0),e.lineTo(s[_],0),this.visuals.line.set_vectorize(e,_),e.stroke(),e.rotate(-a[_]),e.translate(-n[_],-r[_]))}}},t.prototype.draw_legend_for_index=function(e,t,i){s.generic_line_legend(this.visuals,e,t,i)},t}(r.XYGlyphView);i.RayView=l,l.__name__="RayView";var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Ray=function(){this.prototype.default_view=l,this.mixins(["line"]),this.define({length:[a.DistanceSpec],angle:[a.AngleSpec]})},t}(r.XYGlyph);i.Ray=_,_.__name__="Ray",_.init_Ray()},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(1),h=t(321),r=t(198),a=e.__importStar(t(195)),n=e.__importStar(t(127)),_=t(120),o=function(t){function s(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(s,t),s.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},s.prototype._map_data=function(){var t,s;if("data"==this.model.properties.width.units)t=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var i=this.sx.length;this.sx0=new Float64Array(i);for(var e=0;e<i;e++)this.sx0[e]=this.sx[e]-this.sw[e]/2}if("data"==this.model.properties.height.units)s=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),this.sh=s[0],this.sy1=s[1];else{this.sh=this._height;var h=this.sy.length;this.sy1=new Float64Array(h);for(e=0;e<h;e++)this.sy1[e]=this.sy[e]-this.sh[e]/2}var r=this.sw.length;this.ssemi_diag=new Float64Array(r);for(e=0;e<r;e++)this.ssemi_diag[e]=Math.sqrt(this.sw[e]/2*this.sw[e]/2+this.sh[e]/2*this.sh[e]/2)},s.prototype._render=function(t,s,i){var e=i.sx,h=i.sy,r=i.sx0,a=i.sy1,n=i.sw,_=i.sh,o=i._angle;if(this.visuals.fill.doit)for(var l=0,d=s;l<d.length;l++){var c=d[l];isNaN(e[c]+h[c]+r[c]+a[c]+n[c]+_[c]+o[c])||(this.visuals.fill.set_vectorize(t,c),o[c]?(t.translate(e[c],h[c]),t.rotate(o[c]),t.fillRect(-n[c]/2,-_[c]/2,n[c],_[c]),t.rotate(-o[c]),t.translate(-e[c],-h[c])):t.fillRect(r[c],a[c],n[c],_[c]))}if(this.visuals.line.doit){t.beginPath();for(var u=0,y=s;u<y.length;u++){c=y[u];isNaN(e[c]+h[c]+r[c]+a[c]+n[c]+_[c]+o[c])||0!=n[c]&&0!=_[c]&&(o[c]?(t.translate(e[c],h[c]),t.rotate(o[c]),t.rect(-n[c]/2,-_[c]/2,n[c],_[c]),t.rotate(-o[c]),t.translate(-e[c],-h[c])):t.rect(r[c],a[c],n[c],_[c]),this.visuals.line.set_vectorize(t,c),t.stroke(),t.beginPath())}t.stroke()}},s.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},s.prototype._hit_point=function(t){for(var s=t.sx,i=t.sy,e=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(i),r=[],n=0,o=this.sx0.length;n<o;n++)r.push(this.sx0[n]+this.sw[n]/2);var l=[];for(n=0,o=this.sy1.length;n<o;n++)l.push(this.sy1[n]+this.sh[n]/2);for(var d=_.max(this._ddist(0,r,this.ssemi_diag)),c=_.max(this._ddist(1,l,this.ssemi_diag)),u=e-d,y=e+d,f=h-c,p=h+c,x=[],v=0,g=this.index.indices({x0:u,x1:y,y0:f,y1:p});v<g.length;v++){n=g[v];var m=void 0,w=void 0;if(this._angle[n]){var b=Math.sin(-this._angle[n]),R=Math.cos(-this._angle[n]),A=R*(s-this.sx[n])-b*(i-this.sy[n])+this.sx[n],F=b*(s-this.sx[n])+R*(i-this.sy[n])+this.sy[n];s=A,i=F,w=Math.abs(this.sx[n]-s)<=this.sw[n]/2,m=Math.abs(this.sy[n]-i)<=this.sh[n]/2}else w=s-this.sx0[n]<=this.sw[n]&&s-this.sx0[n]>=0,m=i-this.sy1[n]<=this.sh[n]&&i-this.sy1[n]>=0;m&&w&&x.push(n)}var M=a.create_empty_hit_test_result();return M.indices=x,M},s.prototype._map_dist_corner_for_data_side_length=function(t,s,i){for(var e=t.length,h=new Float64Array(e),r=new Float64Array(e),a=0;a<e;a++)h[a]=Number(t[a])-s[a]/2,r[a]=Number(t[a])+s[a]/2;for(var n=i.v_compute(h),_=i.v_compute(r),o=this.sdist(i,h,s,"edge",this.model.dilate),l=n,d=(a=0,n.length);a<d;a++)if(n[a]!=_[a]){l=n[a]<_[a]?n:_;break}return[o,l]},s.prototype._ddist=function(t,s,i){for(var e=0==t?this.renderer.xscale:this.renderer.yscale,h=s,r=h.length,a=new Float64Array(r),n=0;n<r;n++)a[n]=h[n]+i[n];var _=e.v_invert(h),o=e.v_invert(a),l=_.length,d=new Float64Array(l);for(n=0;n<l;n++)d[n]=Math.abs(o[n]-_[n]);return d},s.prototype.draw_legend_for_index=function(t,s,i){r.generic_area_legend(this.visuals,t,s,i)},s.prototype._bounds=function(t){var s=t.x0,i=t.x1,e=t.y0,h=t.y1;return{x0:s-this.max_w2,x1:i+this.max_w2,y0:e-this.max_h2,y1:h+this.max_h2}},s}(h.CenterRotatableView);i.RectView=o,o.__name__="RectView";var l=function(t){function s(s){return t.call(this,s)||this}return e.__extends(s,t),s.init_Rect=function(){this.prototype.default_view=o,this.define({dilate:[n.Boolean,!1]})},s}(h.CenterRotatable);i.Rect=l,l.__name__="Rect",l.init_Rect()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),n=s.__importStar(t(195)),r=t(190),h=t(194),a=t(198),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++){var s=this._x0[e],n=this._x1[e],h=this._y0[e],a=this._y1[e];isNaN(s+n+h+a)||t.push({x0:Math.min(s,n),y0:Math.min(h,a),x1:Math.max(s,n),y1:Math.max(h,a),i:e})}return new r.SpatialIndex(t)},e.prototype._render=function(t,e,i){var s=i.sx0,n=i.sy0,r=i.sx1,h=i.sy1;if(this.visuals.line.doit)for(var a=0,_=e;a<_.length;a++){var o=_[a];isNaN(s[o]+n[o]+r[o]+h[o])||(t.beginPath(),t.moveTo(s[o],n[o]),t.lineTo(r[o],h[o]),this.visuals.line.set_vectorize(t,o),t.stroke())}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,s={x:e,y:i},r=[],h=this.renderer.xscale.r_invert(e-2,e+2),a=h[0],_=h[1],o=this.renderer.yscale.r_invert(i-2,i+2),l=o[0],y=o[1],x=0,c=this.index.indices({x0:a,y0:l,x1:_,y1:y});x<c.length;x++){var u=c[x],d=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",u)/2),2),p={x:this.sx0[u],y:this.sy0[u]},v={x:this.sx1[u],y:this.sy1[u]};n.dist_to_segment_squared(s,p,v)<d&&r.push(u)}var f=n.create_empty_hit_test_result();return f.indices=r,f},e.prototype._hit_span=function(t){var e,i,s,r,h,a=this.renderer.plot_view.frame.bbox.ranges,_=a[0],o=a[1],l=t.sx,y=t.sy;"v"==t.direction?(h=this.renderer.yscale.invert(y),s=(e=[this._y0,this._y1])[0],r=e[1]):(h=this.renderer.xscale.invert(l),s=(i=[this._x0,this._x1])[0],r=i[1]);for(var x=[],c=this.renderer.xscale.r_invert(_.start,_.end),u=c[0],d=c[1],p=this.renderer.yscale.r_invert(o.start,o.end),v=p[0],f=p[1],m=0,g=this.index.indices({x0:u,y0:v,x1:d,y1:f});m<g.length;m++){var w=g[m];(s[w]<=h&&h<=r[w]||r[w]<=h&&h<=s[w])&&x.push(w);var M=1.5+this.visuals.line.cache_select("line_width",w)/2;s[w]==r[w]&&("h"==t.direction?Math.abs(this.sx0[w]-l)<=M&&x.push(w):Math.abs(this.sy0[w]-y)<=M&&x.push(w))}var S=n.create_empty_hit_test_result();return S.indices=x,S},e.prototype.scenterx=function(t){return(this.sx0[t]+this.sx1[t])/2},e.prototype.scentery=function(t){return(this.sy0[t]+this.sy1[t])/2},e.prototype.draw_legend_for_index=function(t,e,i){a.generic_line_legend(this.visuals,t,e,i)},e}(h.GlyphView);i.SegmentView=_,_.__name__="SegmentView";var o=function(t){function e(e){return t.call(this,e)||this}return s.__extends(e,t),e.init_Segment=function(){this.prototype.default_view=_,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(["line"])},e}(h.Glyph);i.Segment=o,o.__name__="Segment",o.init_Segment()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),o=e(189),r=e(198),a=n.__importStar(e(127)),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype._render=function(e,t,i){var n,o,r,a,l,s,_=i.sx,u=i.sy,d=!1,f=null;this.visuals.line.set_value(e);var p=t.length;if(!(p<2)){e.beginPath(),e.moveTo(_[0],u[0]);for(var h=0,c=t;h<c.length;h++){var v=c[h],b=void 0,m=void 0,g=void 0,w=void 0;switch(this.model.mode){case"before":b=(n=[_[v-1],u[v]])[0],g=n[1],m=(o=[_[v],u[v]])[0],w=o[1];break;case"after":b=(r=[_[v],u[v-1]])[0],g=r[1],m=(a=[_[v],u[v]])[0],w=a[1];break;case"center":var y=(_[v-1]+_[v])/2;b=(l=[y,u[v-1]])[0],g=l[1],m=(s=[y,u[v]])[0],w=s[1];break;default:throw new Error("unexpected")}if(d){if(!isFinite(_[v]+u[v])){e.stroke(),e.beginPath(),d=!1,f=v;continue}null!=f&&v-f>1&&(e.stroke(),d=!1)}d?(e.lineTo(b,g),e.lineTo(m,w)):(e.beginPath(),e.moveTo(_[v],u[v]),d=!0),f=v}e.lineTo(_[p-1],u[p-1]),e.stroke()}},t.prototype.draw_legend_for_index=function(e,t,i){r.generic_line_legend(this.visuals,e,t,i)},t}(o.XYGlyphView);i.StepView=l,l.__name__="StepView";var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Step=function(){this.prototype.default_view=l,this.mixins(["line"]),this.define({mode:[a.StepMode,"before"]})},t}(o.XYGlyph);i.Step=s,s.__name__="Step",s.init_Step()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),n=t(189),r=i.__importStar(t(195)),_=i.__importStar(t(127)),o=t(239),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._rotate_point=function(t,e,s,i,n){return[(t-s)*Math.cos(n)-(e-i)*Math.sin(n)+s,(t-s)*Math.sin(n)+(e-i)*Math.cos(n)+i]},e.prototype._text_bounds=function(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]},e.prototype._render=function(t,e,s){var i=s.sx,n=s.sy,r=s._x_offset,_=s._y_offset,a=s._angle,h=s._text;this._sys=[],this._sxs=[];for(var u=0,l=e;u<l.length;u++){var x=l[u];if(!isNaN(i[x]+n[x]+r[x]+_[x]+a[x])&&null!=h[x]&&(this._sxs[x]=[],this._sys[x]=[],this.visuals.text.doit)){var p=""+h[x];t.save(),t.translate(i[x]+r[x],n[x]+_[x]),t.rotate(a[x]),this.visuals.text.set_vectorize(t,x);var c=this.visuals.text.cache_select("font",x),f=o.measure_font(c).height,y=this.visuals.text.text_line_height.value()*f;if(-1==p.indexOf("\n")){t.fillText(p,0,0);var v=i[x]+r[x],d=n[x]+_[x],m=t.measureText(p).width,g=this._text_bounds(v,d,m,y),b=g[0],T=g[1];this._sxs[x].push(b),this._sys[x].push(T)}else{var w=p.split("\n"),S=y*w.length,M=this.visuals.text.cache_select("text_baseline",x),N=void 0;switch(M){case"top":N=0;break;case"middle":N=-S/2+y/2;break;case"bottom":N=-S+y;break;default:N=0,console.warn("'"+M+"' baseline not supported with multi line text")}for(var k=0,V=w;k<V.length;k++){var G=V[k];t.fillText(G,0,N);v=i[x]+r[x],d=N+n[x]+_[x],m=t.measureText(G).width;var O=this._text_bounds(v,d,m,y);b=O[0],T=O[1];this._sxs[x].push(b),this._sys[x].push(T),N+=y}}t.restore()}}},e.prototype._hit_point=function(t){for(var e=t.sx,s=t.sy,i=[],n=0;n<this._sxs.length;n++)for(var _=this._sxs[n],o=this._sys[n],a=_.length,h=0,u=a;h<u;h++){var l=this._rotate_point(e,s,_[a-1][0],o[a-1][0],-this._angle[n]),x=l[0],p=l[1];r.point_in_poly(x,p,_[h],o[h])&&i.push(n)}var c=r.create_empty_hit_test_result();return c.indices=i,c},e.prototype._scenterxy=function(t){var e=this._sxs[t][0][0],s=this._sys[t][0][0],i=(this._sxs[t][0][2]+e)/2,n=(this._sys[t][0][2]+s)/2,r=this._rotate_point(i,n,e,s,this._angle[t]);return{x:r[0],y:r[1]}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(n.XYGlyphView);s.TextView=a,a.__name__="TextView";var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_Text=function(){this.prototype.default_view=a,this.mixins(["text"]),this.define({text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,0],y_offset:[_.NumberSpec,0]})},e}(n.XYGlyph);s.Text=h,h.__name__="Text",h.init_Text()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var s=t(1),r=t(325),o=s.__importStar(t(127)),h=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(i,t),i.prototype.scenterx=function(t){return this.sx[t]},i.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},i.prototype._index_data=function(){return this._index_box(this._x.length)},i.prototype._lrtb=function(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]},i.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(var i=0;i<t;i++)this.sleft[i]=this.sx[i]-this.sw[i]/2,this.sright[i]=this.sx[i]+this.sw[i]/2;this._clamp_viewport()},i}(r.BoxView);e.VBarView=h,h.__name__="VBarView";var n=function(t){function i(i){return t.call(this,i)||this}return s.__extends(i,t),i.init_VBar=function(){this.prototype.default_view=h,this.coords([["x","bottom"]]),this.define({width:[o.NumberSpec],top:[o.CoordinateSpec]}),this.override({bottom:0})},i}(r.Box);e.VBar=n,n.__name__="VBar",n.init_VBar()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),r=e(189),n=e(198),a=s.__importStar(e(195)),_=s.__importStar(e(127)),o=e(118),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},t.prototype._render=function(e,t,i){for(var s=i.sx,r=i.sy,n=i.sradius,a=i._start_angle,_=i._end_angle,o=this.model.properties.direction.value(),h=0,l=t;h<l.length;h++){var d=l[h];isNaN(s[d]+r[d]+n[d]+a[d]+_[d])||(e.beginPath(),e.arc(s[d],r[d],n[d],a[d],_[d],o),e.lineTo(s[d],r[d]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,d),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,d),e.stroke()))}},t.prototype._hit_point=function(e){var t,i,s,r,n,_,h,l,d,u,c,p,y,f=e.sx,v=e.sy,g=this.renderer.xscale.invert(f),x=this.renderer.yscale.invert(v),m=2*this.max_radius;"data"===this.model.properties.radius.units?(u=g-m,c=g+m,p=x-m,y=x+m):(_=f-m,h=f+m,u=(t=this.renderer.xscale.r_invert(_,h))[0],c=t[1],l=v-m,d=v+m,p=(i=this.renderer.yscale.r_invert(l,d))[0],y=i[1]);for(var w=[],M=0,W=this.index.indices({x0:u,x1:c,y0:p,y1:y});M<W.length;M++){var S=W[M],b=Math.pow(this.sradius[S],2);_=(s=this.renderer.xscale.r_compute(g,this._x[S]))[0],h=s[1],l=(r=this.renderer.yscale.r_compute(x,this._y[S]))[0],d=r[1],(n=Math.pow(_-h,2)+Math.pow(l-d,2))<=b&&w.push([S,n])}for(var P=this.model.properties.direction.value(),V=[],k=0,z=w;k<z.length;k++){var A=z[k],D=(S=A[0],A[1]),G=Math.atan2(v-this.sy[S],f-this.sx[S]);o.angle_between(-G,-this._start_angle[S],-this._end_angle[S],P)&&V.push([S,D])}return a.create_hit_test_result_from_hits(V)},t.prototype.draw_legend_for_index=function(e,t,i){n.generic_area_legend(this.visuals,e,t,i)},t.prototype._scenterxy=function(e){var t=this.sradius[e]/2,i=(this._start_angle[e]+this._end_angle[e])/2;return{x:this.sx[e]+t*Math.cos(i),y:this.sy[e]+t*Math.sin(i)}},t.prototype.scenterx=function(e){return this._scenterxy(e).x},t.prototype.scentery=function(e){return this._scenterxy(e).y},t}(r.XYGlyphView);i.WedgeView=h,h.__name__="WedgeView";var l=function(e){function t(t){return e.call(this,t)||this}return s.__extends(t,e),t.init_Wedge=function(){this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({direction:[_.Direction,"anticlock"],radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})},t}(r.XYGlyph);i.Wedge=l,l.__name__="Wedge",l.init_Wedge()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(206),t),_.__exportStar(e(346),t),_.__exportStar(e(347),t)},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),o=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t}(e(177).Model);n.LayoutProvider=o,o.__name__="LayoutProvider"},
function _(t,a,r){Object.defineProperty(r,"__esModule",{value:!0});var o=t(1),e=t(346),i=o.__importStar(t(127)),n=function(t){function a(a){return t.call(this,a)||this}return o.__extends(a,t),a.init_StaticLayoutProvider=function(){this.define({graph_layout:[i.Any,{}]})},a.prototype.get_node_coordinates=function(t){for(var a=[],r=[],o=t.data.index,e=0,i=o.length;e<i;e++){var n=this.graph_layout[o[e]],u=null!=n?n:[NaN,NaN],d=u[0],s=u[1];a.push(d),r.push(s)}return[a,r]},a.prototype.get_edge_coordinates=function(t){for(var a,r,o=[],e=[],i=t.data.start,n=t.data.end,u=null!=t.data.xs&&null!=t.data.ys,d=0,s=i.length;d<s;d++){var l=null!=this.graph_layout[i[d]]&&null!=this.graph_layout[n[d]];if(u&&l)o.push(t.data.xs[d]),e.push(t.data.ys[d]);else{var _=void 0,h=void 0;l?(h=(a=[this.graph_layout[i[d]],this.graph_layout[n[d]]])[0],_=a[1]):(h=(r=[[NaN,NaN],[NaN,NaN]])[0],_=r[1]),o.push([h[0],_[0]]),e.push([h[1],_[1]])}}return[o,e]},a}(e.LayoutProvider);r.StaticLayoutProvider=n,n.__name__="StaticLayoutProvider",n.init_StaticLayoutProvider()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var i=e(349);d.Grid=i.Grid},
function _(i,e,n){Object.defineProperty(n,"__esModule",{value:!0});var t=i(1),r=i(257),o=t.__importStar(i(127)),a=i(116),s=function(i){function e(){return null!==i&&i.apply(this,arguments)||this}return t.__extends(e,i),e.prototype.render=function(){if(this.model.visible){var i=this.plot_view.canvas_view.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}},e.prototype.connect_signals=function(){var e=this;i.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return e.request_render()}))},e.prototype._draw_regions=function(i){var e=this;if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit){this.visuals.band_fill.set_value(i);for(var n=this.grid_coords("major",!1),t=n[0],r=n[1],o=function(n){if(n%2!=1)return"continue";var o=a.plot_view.map_to_screen(t[n],r[n],a.model.x_range_name,a.model.y_range_name),s=o[0],_=o[1],d=a.plot_view.map_to_screen(t[n+1],r[n+1],a.model.x_range_name,a.model.y_range_name),l=d[0],h=d[1];a.visuals.band_fill.doit&&i.fillRect(s[0],_[0],l[1]-s[0],h[1]-_[0]),a.visuals.band_hatch.doit2(i,n,(function(){i.fillRect(s[0],_[0],l[1]-s[0],h[1]-_[0])}),(function(){return e.request_render()}))},a=this,s=0;s<t.length-1;s++)o(s)}},e.prototype._draw_grids=function(i){if(this.visuals.grid_line.doit){var e=this.grid_coords("major"),n=e[0],t=e[1];this._draw_grid_helper(i,this.visuals.grid_line,n,t)}},e.prototype._draw_minor_grids=function(i){if(this.visuals.minor_grid_line.doit){var e=this.grid_coords("minor"),n=e[0],t=e[1];this._draw_grid_helper(i,this.visuals.minor_grid_line,n,t)}},e.prototype._draw_grid_helper=function(i,e,n,t){e.set_value(i);for(var r=0;r<n.length;r++){var o=this.plot_view.map_to_screen(n[r],t[r],this.model.x_range_name,this.model.y_range_name),a=o[0],s=o[1];i.beginPath(),i.moveTo(Math.round(a[0]),Math.round(s[0]));for(var _=1;_<a.length;_++)i.lineTo(Math.round(a[_]),Math.round(s[_]));i.stroke()}},e.prototype.ranges=function(){var i=this.model.dimension,e=(i+1)%2,n=this.plot_view.frame,t=[n.x_ranges[this.model.x_range_name],n.y_ranges[this.model.y_range_name]];return[t[i],t[e]]},e.prototype.computed_bounds=function(){var i,e,n,t=this.ranges()[0],r=this.model.bounds,o=[t.min,t.max];if(a.isArray(r))e=Math.min(r[0],r[1]),n=Math.max(r[0],r[1]),e<o[0]&&(e=o[0]),n>o[1]&&(n=o[1]);else{e=o[0],n=o[1];for(var s=0,_=this.plot_view.axis_views;s<_.length;s++){var d=_[s];d.dimension==this.model.dimension&&d.model.x_range_name==this.model.x_range_name&&d.model.y_range_name==this.model.y_range_name&&(e=(i=d.computed_bounds)[0],n=i[1])}}return[e,n]},e.prototype.grid_coords=function(i,e){var n;void 0===e&&(e=!0);var t=this.model.dimension,r=(t+1)%2,o=this.ranges(),a=o[0],s=o[1],_=this.computed_bounds(),d=_[0],l=_[1];d=(n=[Math.min(d,l),Math.max(d,l)])[0],l=n[1];var h=[[],[]],u=this.model.get_ticker();if(null==u)return h;var m=u.get_ticks(d,l,a,s.min,{})[i],c=a.min,g=a.max,v=s.min,p=s.max;e||(m[0]!=c&&m.splice(0,0,c),m[m.length-1]!=g&&m.push(g));for(var f=0;f<m.length;f++)if(m[f]!=c&&m[f]!=g||!e){for(var y=[],w=[],x=0;x<2;x++){var b=v+(p-v)/1*x;y.push(m[f]),w.push(b)}h[t].push(y),h[r].push(w)}return h},e}(r.GuideRendererView);n.GridView=s,s.__name__="GridView";var _=function(i){function e(e){return i.call(this,e)||this}return t.__extends(e,i),e.init_Grid=function(){this.prototype.default_view=s,this.mixins(["line:grid_","line:minor_grid_","fill:band_","hatch:band_"]),this.define({bounds:[o.Any,"auto"],dimension:[o.Any,0],axis:[o.Instance],ticker:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},e.prototype.get_ticker=function(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null},e}(r.GuideRenderer);n.Grid=_,_.__name__="Grid",_.init_Grid()},
function _(a,o,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(351);r.Box=e.Box;var v=a(353);r.Column=v.Column;var x=a(354);r.GridBox=x.GridBox;var B=a(355);r.HTMLBox=B.HTMLBox;var n=a(352);r.LayoutDOM=n.LayoutDOM;var t=a(356);r.Row=t.Row;var u=a(357);r.Spacer=u.Spacer;var d=a(358);r.Panel=d.Panel,r.Tabs=d.Tabs;var i=a(362);r.WidgetBox=i.WidgetBox},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),o=e(352),r=i.__importStar(e(127)),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(n,e),n.prototype.connect_signals=function(){var n=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return n.rebuild()}))},Object.defineProperty(n.prototype,"child_models",{get:function(){return this.model.children},enumerable:!0,configurable:!0}),n}(o.LayoutDOMView);t.BoxView=c,c.__name__="BoxView";var u=function(e){function n(n){return e.call(this,n)||this}return i.__extends(n,e),n.init_Box=function(){this.define({children:[r.Array,[]],spacing:[r.Number,0]})},n}(o.LayoutDOM);t.Box=u,u.__name__="Box",u.init_Box()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var o=t(1),n=t(177),s=t(174),r=t(178),l=t(116),a=o.__importStar(t(127)),h=t(204),u=t(172),_=t(175),c=function(t){function i(){var i=t.apply(this,arguments)||this;return i._idle_notified=!1,i._offset_parent=null,i._viewport={},i}return o.__extends(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_root?"relative":"absolute",this._child_views={}},i.prototype.lazy_initialize=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),[2]}}))}))},i.prototype.remove=function(){for(var i=0,e=this.child_views;i<e.length;i++){e[i].remove()}this._child_views={},t.prototype.remove.call(this)},i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.is_root&&(this._on_resize=function(){return i.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((function(){var t=i.el.offsetParent;i._offset_parent!=t&&(i._offset_parent=t,null!=t&&(i.compute_viewport(),i.invalidate_layout()))}),250));var e=this.model.properties;this.on_change([e.width,e.height,e.min_width,e.min_height,e.max_width,e.max_height,e.margin,e.width_policy,e.height_policy,e.sizing_mode,e.aspect_ratio,e.visible],(function(){return i.invalidate_layout()})),this.on_change([e.background,e.css_classes],(function(){return i.invalidate_render()}))},i.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},i.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(i.prototype,"child_views",{get:function(){var t=this;return this.child_models.map((function(i){return t._child_views[i.id]}))},enumerable:!0,configurable:!0}),i.prototype.build_child_views=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,h.build_views(this._child_views,this.child_models,{parent:this})];case 1:return t.sent(),[2]}}))}))},i.prototype.render=function(){var i;t.prototype.render.call(this),s.empty(this.el);var e=this.model.background;this.el.style.backgroundColor=null!=e?e:"",(i=s.classes(this.el).clear()).add.apply(i,this.css_classes());for(var o=0,n=this.child_views;o<n.length;o++){var r=n[o];this.el.appendChild(r.el),r.render()}},i.prototype.update_layout=function(){for(var t=0,i=this.child_views;t<i.length;t++){i[t].update_layout()}this._update_layout()},i.prototype.update_position=function(){this.el.style.display=this.model.visible?"block":"none";var t=this.is_root?this.layout.sizing.margin:void 0;s.position(this.el,this.layout.bbox,t);for(var i=0,e=this.child_views;i<e.length;i++){e[i].update_position()}},i.prototype.after_layout=function(){for(var t=0,i=this.child_views;t<i.length;t++){i[t].after_layout()}this._has_finished=!0},i.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},i.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()},i.prototype.build=function(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this},i.prototype.rebuild=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),this.invalidate_render(),[2]}}))}))},i.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),r.logger.debug("layout computed in "+(Date.now()-t)+" ms"),this.notify_finished()},i.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},i.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},i.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},i.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;for(var i=0,e=this.child_views;i<e.length;i++){if(!e[i].has_finished())return!1}return!0},i.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},i.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},i.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},i.prototype.box_sizing=function(){var t=this.model,i=t.width_policy,e=t.height_policy,o=t.aspect_ratio;"auto"==i&&(i=this._width_policy()),"auto"==e&&(e=this._height_policy());var n=this.model.sizing_mode;if(null!=n)if("fixed"==n)i=e="fixed";else if("stretch_both"==n)i=e="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)e="max";else switch(null==o&&(o="auto"),n){case"scale_width":i="max",e="min";break;case"scale_height":i="min",e="max";break;case"scale_both":i="max",e="max"}var s={width_policy:i,height_policy:e},r=this.model,a=r.min_width,h=r.min_height;null!=a&&(s.min_width=a),null!=h&&(s.min_height=h);var u=this.model,_=u.width,c=u.height;null!=_&&(s.width=_),null!=c&&(s.height=c);var d=this.model,p=d.max_width,f=d.max_height;null!=p&&(s.max_width=p),null!=f&&(s.max_height=f),"auto"==o&&null!=_&&null!=c?s.aspect=_/c:l.isNumber(o)&&(s.aspect=o);var m=this.model.margin;if(null!=m)if(l.isNumber(m))s.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var y=m[0],v=m[1];s.margin={top:y,right:v,bottom:y,left:v}}else{var g=m[0],w=m[1],b=m[2],x=m[3];s.margin={top:g,right:w,bottom:b,left:x}}s.visible=this.model.visible;var z=this.model.align;return l.isArray(z)?(s.halign=z[0],s.valign=z[1]):s.halign=s.valign=z,s},i.prototype._viewport_size=function(){var t=this;return s.undisplayed(this.el,(function(){for(var i=t.el;i=i.parentElement;)if(!i.classList.contains(_.bk_root)){if(i==document.body){var e=s.extents(document.body).margin,o=e.left,n=e.right,r=e.top,l=e.bottom;return{width:Math.ceil(document.documentElement.clientWidth-o-n),height:Math.ceil(document.documentElement.clientHeight-r-l)}}var a=s.extents(i).padding,h=a.left,u=a.right,c=a.top,d=a.bottom,p=i.getBoundingClientRect(),f=p.width,m=p.height,y=Math.ceil(f-h-u),v=Math.ceil(m-c-d);if(y>0||v>0)return{width:y>0?y:void 0,height:v>0?v:void 0}}return{}}))},i.prototype.serializable_state=function(){return Object.assign(Object.assign({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box,children:this.child_views.map((function(t){return t.serializable_state()}))})},i}(u.DOMView);e.LayoutDOMView=c,c.__name__="LayoutDOMView";var d=function(t){function i(i){return t.call(this,i)||this}return o.__extends(i,t),i.init_LayoutDOM=function(){this.define({width:[a.Number,null],height:[a.Number,null],min_width:[a.Number,null],min_height:[a.Number,null],max_width:[a.Number,null],max_height:[a.Number,null],margin:[a.Any,[0,0,0,0]],width_policy:[a.Any,"auto"],height_policy:[a.Any,"auto"],aspect_ratio:[a.Any,null],sizing_mode:[a.SizingMode,null],visible:[a.Boolean,!0],disabled:[a.Boolean,!1],align:[a.Any,"start"],background:[a.Color,null],css_classes:[a.Array,[]]})},i}(n.Model);e.LayoutDOM=d,d.__name__="LayoutDOM",d.init_LayoutDOM()},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),e=t(351),u=t(299),s=o.__importStar(t(127)),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new u.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},n}(e.BoxView);i.ColumnView=_,_.__name__="ColumnView";var l=function(t){function n(n){return t.call(this,n)||this}return o.__extends(n,t),n.init_Column=function(){this.prototype.default_view=_,this.define({rows:[s.Any,"auto"]})},n}(e.Box);i.Column=l,l.__name__="Column",l.init_Column()},
function _(t,i,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),e=t(352),r=t(299),s=n.__importStar(t(127)),l=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return i.rebuild()}))},Object.defineProperty(i.prototype,"child_models",{get:function(){return this.model.children.map((function(t){return t[0]}))},enumerable:!0,configurable:!0}),i.prototype._update_layout=function(){this.layout=new r.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(var t=0,i=this.model.children;t<i.length;t++){var o=i[t],n=o[0],e=o[1],s=o[2],l=o[3],u=o[4],a=this._child_views[n.id];this.layout.items.push({layout:a.layout,row:e,col:s,row_span:l,col_span:u})}this.layout.set_sizing(this.box_sizing())},i}(e.LayoutDOMView);o.GridBoxView=l,l.__name__="GridBoxView";var u=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_GridBox=function(){this.prototype.default_view=l,this.define({children:[s.Array,[]],rows:[s.Any,"auto"],cols:[s.Any,"auto"],spacing:[s.Any,0]})},i}(e.LayoutDOM);o.GridBox=u,u.__name__="GridBox",u.init_GridBox()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(352),u=t(295),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._update_layout=function(){this.layout=new u.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},e}(i.LayoutDOMView);n.HTMLBoxView=r,r.__name__="HTMLBoxView";var _=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e}(i.LayoutDOM);n.HTMLBox=_,_.__name__="HTMLBox"},
function _(t,i,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),e=t(351),s=t(299),u=n.__importStar(t(127)),_=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new s.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},i}(e.BoxView);o.RowView=_,_.__name__="RowView";var a=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Row=function(){this.prototype.default_view=_,this.define({cols:[u.Any,"auto"]})},i}(e.Box);o.Row=a,a.__name__="Row",a.init_Row()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(352),o=e(295),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),Object.defineProperty(t.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),t.prototype._update_layout=function(){this.layout=new o.LayoutItem,this.layout.set_sizing(this.box_sizing())},t}(r.LayoutDOMView);n.SpacerView=u,u.__name__="SpacerView";var a=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Spacer=function(){this.prototype.default_view=u},t}(r.LayoutDOM);n.Spacer=a,a.__name__="Spacer",a.init_Spacer()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),s=e(295),r=e(174),l=e(117),n=a.__importStar(e(127)),o=e(352),h=e(177),c=e(253),d=e(359),_=e(360),u=e(361),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,(function(){return t.rebuild()})),this.connect(this.model.properties.active.change,(function(){return t.on_active_change()}))},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.tabs.map((function(e){return e.child}))},enumerable:!0,configurable:!0}),t.prototype._update_layout=function(){var e=this.model.tabs_location,t="above"==e||"below"==e,i=this.scroll_el,n=this.headers_el;this.header=new(function(e){function s(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(s,e),s.prototype._measure=function(a){var s=r.size(i),o=r.children(n).slice(0,3).map((function(e){return r.size(e)})),h=e.prototype._measure.call(this,a),c=h.width,d=h.height;if(t){var _=s.width+l.sum(o.map((function(e){return e.width})));return{width:a.width!=1/0?a.width:_,height:d}}var u=s.height+l.sum(o.map((function(e){return e.height})));return{width:c,height:a.height!=1/0?a.height:u}},s}(s.ContentBox))(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var o=1,h=1;switch(e){case"above":o-=1;break;case"below":o+=1;break;case"left":h-=1;break;case"right":h+=1}var c={layout:this.header,row:o,col:h},d=this.child_views.map((function(e){return{layout:e.layout,row:1,col:1}}));this.layout=new s.Grid(a.__spreadArrays([c],d)),this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){e.prototype.update_position.call(this),this.header_el.style.position="absolute",r.position(this.header_el,this.header.bbox);var t=this.model.tabs_location,i="above"==t||"below"==t,a=r.size(this.scroll_el),s=r.scroll_size(this.headers_el);if(i){var l=this.header.bbox.width;s.width>l?(this.wrapper_el.style.maxWidth=l-a.width+"px",r.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",r.undisplay(this.scroll_el))}else{var n=this.header.bbox.height;s.height>n?(this.wrapper_el.style.maxHeight=n-a.height+"px",r.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",r.undisplay(this.scroll_el))}for(var o=this.child_views,h=0,c=o;h<c.length;h++){var d=c[h];r.hide(d.el)}var _=o[this.model.active];null!=_&&r.show(_.el)},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=this.model.active,a=this.model.tabs_location,s="above"==a||"below"==a,n=this.model.tabs.map((function(e,a){var s=r.div({class:[d.bk_tab,a==i?c.bk_active:null]},e.title);if(s.addEventListener("click",(function(e){e.target==e.currentTarget&&t.change_active(a)})),e.closable){var n=r.div({class:d.bk_close});n.addEventListener("click",(function(e){if(e.target==e.currentTarget){t.model.tabs=l.remove_at(t.model.tabs,a);var i=t.model.tabs.length;t.model.active>i-1&&(t.model.active=i-1)}})),s.appendChild(n)}return s}));this.headers_el=r.div({class:[d.bk_headers]},n),this.wrapper_el=r.div({class:d.bk_headers_wrapper},this.headers_el);var o=r.div({class:[_.bk_btn,_.bk_btn_default],disabled:""},r.div({class:[u.bk_caret,c.bk_left]})),h=r.div({class:[_.bk_btn,_.bk_btn_default]},r.div({class:[u.bk_caret,c.bk_right]})),p=0,b=function(e){return function(){var i=t.model.tabs.length;0==(p="left"==e?Math.max(p-1,0):Math.min(p+1,i-1))?o.setAttribute("disabled",""):o.removeAttribute("disabled"),p==i-1?h.setAttribute("disabled",""):h.removeAttribute("disabled");var a=r.children(t.headers_el).slice(0,p).map((function(e){return e.getBoundingClientRect()}));if(s){var n=-l.sum(a.map((function(e){return e.width})));t.headers_el.style.left=n+"px"}else{var c=-l.sum(a.map((function(e){return e.height})));t.headers_el.style.top=c+"px"}}};o.addEventListener("click",b("left")),h.addEventListener("click",b("right")),this.scroll_el=r.div({class:_.bk_btn_group},o,h),this.header_el=r.div({class:[d.bk_tabs_header,c.bk_side(a)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},t.prototype.change_active=function(e){e!=this.model.active&&(this.model.active=e)},t.prototype.on_active_change=function(){for(var e=this.model.active,t=r.children(this.headers_el),i=0,a=t;i<a.length;i++){a[i].classList.remove(c.bk_active)}t[e].classList.add(c.bk_active);for(var s=this.child_views,l=0,n=s;l<n.length;l++){var o=n[l];r.hide(o.el)}r.show(s[e].el)},t}(o.LayoutDOMView);i.TabsView=p,p.__name__="TabsView";var b=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Tabs=function(){this.prototype.default_view=p,this.define({tabs:[n.Array,[]],tabs_location:[n.Location,"above"],active:[n.Number,0]})},t}(o.LayoutDOM);i.Tabs=b,b.__name__="Tabs",b.init_Tabs();var v=function(e){function t(t){return e.call(this,t)||this}return a.__extends(t,e),t.init_Panel=function(){this.define({title:[n.String,""],child:[n.Instance],closable:[n.Boolean,!1]})},t}(h.Model);i.Panel=v,v.__name__="Panel",v.init_Panel()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});var b=e(1);e(175),b.__importStar(e(174)).styles.append('.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>\\\n      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,\\\n      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">\\\n        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>\\\n        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>\\\n      </svg>\');\n}\n'),n.bk_tabs_header="bk-tabs-header",n.bk_headers_wrapper="bk-headers-wrapper",n.bk_headers="bk-headers",n.bk_tab="bk-tab",n.bk_close="bk-close"},
function _(n,o,b){Object.defineProperty(b,"__esModule",{value:!0});var r=n(1);n(175),r.__importStar(n(174)).styles.append(".bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"),b.bk_btn="bk-btn",b.bk_btn_group="bk-btn-group",b.bk_btn_default="bk-btn-default",b.bk_btn_primary="bk-btn-primary",b.bk_btn_success="bk-btn-success",b.bk_btn_warning="bk-btn-warning",b.bk_btn_danger="bk-btn-danger",b.bk_btn_type=function(n){switch(n){case"default":return b.bk_btn_default;case"primary":return b.bk_btn_primary;case"success":return b.bk_btn_success;case"warning":return b.bk_btn_warning;case"danger":return b.bk_btn_danger}},b.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(n,o,r){Object.defineProperty(r,"__esModule",{value:!0});var b=n(1);n(175),b.__importStar(n(174)).styles.append(".bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"),r.bk_menu="bk-menu",r.bk_caret="bk-caret",r.bk_divider="bk-divider"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(353),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(o.ColumnView);i.WidgetBoxView=_,_.__name__="WidgetBoxView";var u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_WidgetBox=function(){this.prototype.default_view=_},e}(o.Column);i.WidgetBox=u,u.__name__="WidgetBox",u.init_WidgetBox()},
function _(r,a,o){Object.defineProperty(o,"__esModule",{value:!0});var e=r(364);o.CategoricalColorMapper=e.CategoricalColorMapper;var p=r(366);o.CategoricalMarkerMapper=p.CategoricalMarkerMapper;var l=r(367);o.CategoricalPatternMapper=l.CategoricalPatternMapper;var C=r(223);o.ContinuousColorMapper=C.ContinuousColorMapper;var M=r(224);o.ColorMapper=M.ColorMapper;var t=r(222);o.LinearColorMapper=t.LinearColorMapper;var i=r(368);o.LogColorMapper=i.LogColorMapper},
function _(t,r,e){Object.defineProperty(e,"__esModule",{value:!0});var o=t(1),a=t(365),i=t(224),n=o.__importStar(t(127)),_=function(t){function r(r){return t.call(this,r)||this}return o.__extends(r,t),r.init_CategoricalColorMapper=function(){this.define({factors:[n.Array],start:[n.Number,0],end:[n.Number]})},r.prototype._v_compute=function(t,r,e,o){var i=o.nan_color;a.cat_v_compute(t,this.factors,e,r,this.start,this.end,i)},r}(i.ColorMapper);e.CategoricalColorMapper=_,_.__name__="CategoricalColorMapper",_.init_CategoricalColorMapper()},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=n(120),l=n(116);function r(n,e){if(n.length!=e.length)return!1;for(var t=0,i=n.length;t<i;t++)if(n[t]!==e[t])return!1;return!0}t._cat_equals=r,t.cat_v_compute=function(n,e,t,u,o,f,c){for(var _=function(_,a){var v=n[_],d=void 0;l.isString(v)?d=i.index_of(e,v):(null!=o?v=null!=f?v.slice(o,f):v.slice(o):null!=f&&(v=v.slice(0,f)),d=1==v.length?i.index_of(e,v[0]):i.find_index(e,(function(n){return r(n,v)})));var g=void 0;g=d<0||d>=t.length?c:t[d],u[_]=g},a=0,v=n.length;a<v;a++)_(a)}},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var a=r(1),i=r(365),n=r(225),c=a.__importStar(r(127)),o=function(r){function e(e){return r.call(this,e)||this}return a.__extends(e,r),e.init_CategoricalMarkerMapper=function(){this.define({factors:[c.Array],markers:[c.Array],start:[c.Number,0],end:[c.Number],default_value:[c.MarkerType,"circle"]})},e.prototype.v_compute=function(r){var e=new Array(r.length);return i.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(n.Mapper);t.CategoricalMarkerMapper=o,o.__name__="CategoricalMarkerMapper",o.init_CategoricalMarkerMapper()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var a=t(1),n=t(365),i=t(225),p=a.__importStar(t(127)),o=function(t){function e(e){return t.call(this,e)||this}return a.__extends(e,t),e.init_CategoricalPatternMapper=function(){this.define({factors:[p.Array],patterns:[p.Array],start:[p.Number,0],end:[p.Number],default_value:[p.HatchPatternType," "]})},e.prototype.v_compute=function(t){var e=new Array(t.length);return n.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(i.Mapper);r.CategoricalPatternMapper=o,o.__name__="CategoricalPatternMapper",o.init_CategoricalPatternMapper()},
function _(o,l,e){Object.defineProperty(e,"__esModule",{value:!0});var t=o(1),n=o(223),r=o(120),i=function(o){function l(l){return o.call(this,l)||this}return t.__extends(l,o),l.prototype._v_compute=function(o,l,e,t){for(var n=t.nan_color,i=t.low_color,h=t.high_color,a=e.length,u=null!=this.low?this.low:r.min(o),s=null!=this.high?this.high:r.max(o),_=a/(Math.log(s)-Math.log(u)),g=e.length-1,f=0,c=o.length;f<c;f++){var p=o[f];if(isNaN(p))l[f]=n;else if(p>s)l[f]=null!=h?h:e[g];else if(p!=s)if(p<u)l[f]=null!=i?i:e[0];else{var M=Math.log(p)-Math.log(u),v=Math.floor(M*_);v>g&&(v=g),l[f]=e[v]}else l[f]=e[g]}},l}(n.ContinuousColorMapper);e.LogColorMapper=i,i.__name__="LogColorMapper"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0}),e(1).__exportStar(e(370),t);var a=e(371);t.Marker=a.Marker;var _=e(372);t.Scatter=_.Scatter},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var i=e(1),r=e(371),n=Math.sqrt(3);function s(e,t){e.moveTo(-t,t),e.lineTo(t,-t),e.moveTo(-t,-t),e.lineTo(t,t)}function c(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function l(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function a(e,t){var o=t*n,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function u(e,t,o,i,r){var n=.65*o;c(e,o),s(e,n),i.doit&&(i.set_vectorize(e,t),e.stroke())}function v(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function _(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),s(e,o),e.stroke())}function d(e,t,o,i,r){c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function f(e,t,o,i,r){l(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function T(e,t,o,i,r){l(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function z(e,t,o,i,r){!function(e,t){var o=t/2,i=n*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function k(e,t,o,i,r){e.rotate(Math.PI),a(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function h(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function m(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function C(e,t,o,i,r){var n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),s(e,o),e.stroke())}function q(e,t,o,i,r){a(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function p(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){s(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function P(e,t){var o,n=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(o,e),o.initClass=function(){this.prototype._render_one=t},o}(r.MarkerView);n.initClass();var s=((o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.default_view=n},t}(r.Marker)).__name__=e,o);return s.initClass(),s}o.Asterisk=P("Asterisk",u),o.CircleCross=P("CircleCross",v),o.CircleX=P("CircleX",_),o.Cross=P("Cross",d),o.Dash=P("Dash",p),o.Diamond=P("Diamond",f),o.DiamondCross=P("DiamondCross",T),o.Hex=P("Hex",z),o.InvertedTriangle=P("InvertedTriangle",k),o.Square=P("Square",h),o.SquareCross=P("SquareCross",m),o.SquareX=P("SquareX",C),o.Triangle=P("Triangle",q),o.X=P("X",M),o.marker_funcs={asterisk:u,circle:function(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())},circle_cross:v,circle_x:_,cross:d,diamond:f,diamond_cross:T,hex:z,inverted_triangle:k,square:h,square_cross:m,square_x:C,triangle:q,dash:p,x:M}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(189),n=i.__importStar(e(195)),a=i.__importStar(e(127)),_=e(117),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._render=function(e,t,r){for(var i=r.sx,s=r.sy,n=r._size,a=r._angle,_=0,h=t;_<h.length;_++){var o=h[_];if(!isNaN(i[o]+s[o]+n[o]+a[o])){var l=n[o]/2;e.beginPath(),e.translate(i[o],s[o]),a[o]&&e.rotate(a[o]),this._render_one(e,o,l,this.visuals.line,this.visuals.fill),a[o]&&e.rotate(-a[o]),e.translate(-i[o],-s[o])}}},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame.bbox.h_range,t=e.start-this.max_size,r=e.end+this.max_size,i=this.renderer.xscale.r_invert(t,r),s=i[0],n=i[1],a=this.renderer.plot_view.frame.bbox.v_range,_=a.start-this.max_size,h=a.end+this.max_size,o=this.renderer.yscale.r_invert(_,h),l=o[0],x=o[1];return this.index.indices({x0:s,x1:n,y0:l,y1:x})},t.prototype._hit_point=function(e){for(var t=e.sx,r=e.sy,i=t-this.max_size,s=t+this.max_size,a=this.renderer.xscale.r_invert(i,s),_=a[0],h=a[1],o=r-this.max_size,l=r+this.max_size,x=this.renderer.yscale.r_invert(o,l),y=x[0],c=x[1],d=[],u=0,p=this.index.indices({x0:_,x1:h,y0:y,y1:c});u<p.length;u++){var v=p[u],f=this._size[v]/2,m=Math.abs(this.sx[v]-t)+Math.abs(this.sy[v]-r);Math.abs(this.sx[v]-t)<=f&&Math.abs(this.sy[v]-r)<=f&&d.push([v,m])}return n.create_hit_test_result_from_hits(d)},t.prototype._hit_span=function(e){var t,r,i,s,a,_,h=e.sx,o=e.sy,l=this.bounds(),x=this.max_size/2,y=n.create_empty_hit_test_result();if("h"==e.direction){a=l.y0,_=l.y1;var c=h-x,d=h+x;i=(t=this.renderer.xscale.r_invert(c,d))[0],s=t[1]}else{i=l.x0,s=l.x1;var u=o-x,p=o+x;a=(r=this.renderer.yscale.r_invert(u,p))[0],_=r[1]}var v=this.index.indices({x0:i,x1:s,y0:a,y1:_});return y.indices=v,y},t.prototype._hit_rect=function(e){var t=e.sx0,r=e.sx1,i=e.sy0,s=e.sy1,a=this.renderer.xscale.r_invert(t,r),_=a[0],h=a[1],o=this.renderer.yscale.r_invert(i,s),l=o[0],x=o[1],y=n.create_empty_hit_test_result();return y.indices=this.index.indices({x0:_,x1:h,y0:l,y1:x}),y},t.prototype._hit_poly=function(e){for(var t=e.sx,r=e.sy,i=_.range(0,this.sx.length),s=[],a=0,h=i.length;a<h;a++){var o=i[a];n.point_in_poly(this.sx[a],this.sy[a],t,r)&&s.push(o)}var l=n.create_empty_hit_test_result();return l.indices=s,l},t.prototype.draw_legend_for_index=function(e,t,r){var i=t.x0,s=t.x1,n=t.y0,a=t.y1,_=r+1,h=new Array(_);h[r]=(i+s)/2;var o=new Array(_);o[r]=(n+a)/2;var l=new Array(_);l[r]=.4*Math.min(Math.abs(s-i),Math.abs(a-n));var x=new Array(_);x[r]=0,this._render(e,[r],{sx:h,sy:o,_size:l,_angle:x})},t}(s.XYGlyphView);r.MarkerView=h,h.__name__="MarkerView";var o=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Marker=function(){this.mixins(["line","fill"]),this.define({size:[a.DistanceSpec,{units:"screen",value:4}],angle:[a.AngleSpec,0]})},t}(s.XYGlyph);r.Marker=o,o.__name__="Marker",o.init_Marker()},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});var a=r(1),n=r(371),i=r(370),_=a.__importStar(r(127)),s=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return a.__extends(e,r),e.prototype._render=function(r,e,t){for(var a=t.sx,n=t.sy,_=t._size,s=t._angle,l=t._marker,o=0,u=e;o<u.length;o++){var c=u[o];if(!isNaN(a[c]+n[c]+_[c]+s[c])&&null!=l[c]){var f=_[c]/2;r.beginPath(),r.translate(a[c],n[c]),s[c]&&r.rotate(s[c]),i.marker_funcs[l[c]](r,c,f,this.visuals.line,this.visuals.fill),s[c]&&r.rotate(-s[c]),r.translate(-a[c],-n[c])}}},e.prototype.draw_legend_for_index=function(r,e,t){var a=e.x0,n=e.x1,i=e.y0,_=e.y1,s=t+1,l=new Array(s);l[t]=(a+n)/2;var o=new Array(s);o[t]=(i+_)/2;var u=new Array(s);u[t]=.4*Math.min(Math.abs(n-a),Math.abs(_-i));var c=new Array(s);c[t]=0;var f=new Array(s);f[t]=this._marker[t],this._render(r,[t],{sx:l,sy:o,_size:u,_angle:c,_marker:f})},e}(n.MarkerView);t.ScatterView=s,s.__name__="ScatterView";var l=function(r){function e(e){return r.call(this,e)||this}return a.__extends(e,r),e.init_Scatter=function(){this.prototype.default_view=s,this.define({marker:[_.MarkerSpec,{value:"circle"}]})},e}(n.Marker);t.Scatter=l,l.__name__="Scatter",l.init_Scatter()},
function _(a,o,p){Object.defineProperty(p,"__esModule",{value:!0});var t=a(374);p.MapOptions=t.MapOptions;var e=a(374);p.GMapOptions=e.GMapOptions;var n=a(374);p.GMapPlot=n.GMapPlot;var M=a(375);p.Plot=M.Plot},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(1),o=t(178),a=t(375),r=e.__importStar(t(127)),p=t(177),_=t(238),s=t(395);i.GMapPlotView=s.GMapPlotView;var l=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_MapOptions=function(){this.define({lat:[r.Number],lng:[r.Number],zoom:[r.Number,12]})},n}(p.Model);i.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();var u=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_GMapOptions=function(){this.define({map_type:[r.String,"roadmap"],scale_control:[r.Boolean,!1],styles:[r.String],tilt:[r.Int,45]})},n}(l);i.GMapOptions=u,u.__name__="GMapOptions",u.init_GMapOptions();var c=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_GMapPlot=function(){this.prototype.default_view=s.GMapPlotView,this.define({map_options:[r.Instance],api_key:[r.String]}),this.override({x_range:function(){return new _.Range1d},y_range:function(){return new _.Range1d}})},n.prototype.initialize=function(){t.prototype.initialize.call(this),this.use_map=!0,this.api_key||o.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},n}(a.Plot);i.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),o=n.__importStar(e(127)),i=e(122),a=e(117),l=e(131),u=e(116),s=e(352),c=e(249),_=e(227),h=e(376),d=e(181),f=e(186),b=e(293),p=e(388);r.PlotView=p.PlotView;var g=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_Plot=function(){this.prototype.default_view=p.PlotView,this.mixins(["line:outline_","fill:background_","fill:border_"]),this.define({toolbar:[o.Instance,function(){return new h.Toolbar}],toolbar_location:[o.Location,"right"],toolbar_sticky:[o.Boolean,!0],plot_width:[o.Number,600],plot_height:[o.Number,600],frame_width:[o.Number,null],frame_height:[o.Number,null],title:[o.Any,function(){return new c.Title({text:""})}],title_location:[o.Location,"above"],above:[o.Array,[]],below:[o.Array,[]],left:[o.Array,[]],right:[o.Array,[]],center:[o.Array,[]],renderers:[o.Array,[]],x_range:[o.Instance,function(){return new b.DataRange1d}],extra_x_ranges:[o.Any,{}],y_range:[o.Instance,function(){return new b.DataRange1d}],extra_y_ranges:[o.Any,{}],x_scale:[o.Instance,function(){return new _.LinearScale}],y_scale:[o.Instance,function(){return new _.LinearScale}],lod_factor:[o.Number,10],lod_interval:[o.Number,300],lod_threshold:[o.Number,2e3],lod_timeout:[o.Number,500],hidpi:[o.Boolean,!0],output_backend:[o.OutputBackend,"canvas"],min_border:[o.Number,5],min_border_top:[o.Number,null],min_border_left:[o.Number,null],min_border_bottom:[o.Number,null],min_border_right:[o.Number,null],inner_width:[o.Number],inner_height:[o.Number],outer_width:[o.Number],outer_height:[o.Number],match_aspect:[o.Boolean,!1],aspect_scale:[o.Number,1],reset_policy:[o.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},Object.defineProperty(t.prototype,"width",{get:function(){var e=this.getv("width");return null!=e?e:this.plot_width},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){var e=this.getv("height");return null!=e?e:this.plot_height},enumerable:!0,configurable:!0}),t.prototype._doc_attached=function(){e.prototype._doc_attached.call(this),this._tell_document_about_change("inner_height",null,this.inner_height,{}),this._tell_document_about_change("inner_width",null,this.inner_width,{})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.reset=new i.Signal0(this,"reset");for(var t=0,r=l.values(this.extra_x_ranges).concat(this.x_range);t<r.length;t++){var n=r[t],o=n.plots;u.isArray(o)&&(o=o.concat(this),n.setv({plots:o},{silent:!0}))}for(var a=0,s=l.values(this.extra_y_ranges).concat(this.y_range);a<s.length;a++){var c=s[a];o=c.plots;u.isArray(o)&&(o=o.concat(this),c.setv({plots:o},{silent:!0}))}},t.prototype.add_layout=function(e,t){void 0===t&&(t="center"),this.getv(t).push(e)},t.prototype.remove_layout=function(e){var t=function(t){a.remove_by(t,(function(t){return t==e}))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)},t.prototype.add_renderers=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.renderers=this.renderers.concat(e)},t.prototype.add_glyph=function(e,t,r){void 0===t&&(t=new d.ColumnDataSource),void 0===r&&(r={});var n=Object.assign(Object.assign({},r),{data_source:t,glyph:e}),o=new f.GlyphRenderer(n);return this.add_renderers(o),o},t.prototype.add_tools=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.toolbar.tools=this.toolbar.tools.concat(e)},Object.defineProperty(t.prototype,"panels",{get:function(){return this.side_panels.concat(this.center)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"side_panels",{get:function(){var e=this.above,t=this.below,r=this.left,n=this.right;return a.concat([e,t,r,n])},enumerable:!0,configurable:!0}),t}(s.LayoutDOM);r.Plot=g,g.__name__="Plot",g.init_Plot()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),s=n.__importStar(t(127)),o=t(116),a=t(117),c=t(377),r=t(382),l=function(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},h=function(t){return"tap"==t||"pan"==t},_=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Toolbar=function(){this.prototype.default_view=r.ToolbarBaseView,this.define({active_drag:[s.Any,"auto"],active_inspect:[s.Any,"auto"],active_scroll:[s.Any,"auto"],active_tap:[s.Any,"auto"],active_multi:[s.Any,null]})},i.prototype.connect_signals=function(){var i=this;t.prototype.connect_signals.call(this),this.connect(this.properties.tools.change,(function(){return i._init_tools()}))},i.prototype._init_tools=function(){var i=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof c.InspectTool){for(var e=!1,n=0,s=this.inspectors;n<s.length;n++){(v=s[n])!=this.active_inspect?v.active=!1:e=!0}e||(this.active_inspect=null)}else if(o.isArray(this.active_inspect)){var r=a.intersection(this.active_inspect,this.inspectors);r.length!=this.active_inspect.length&&(this.active_inspect=r);for(var _=0,u=this.inspectors;_<u.length;_++){var v=u[_];a.includes(this.active_inspect,v)||(v.active=!1)}}else if(null==this.active_inspect)for(var p=0,f=this.inspectors;p<f.length;p++){(v=f[p]).active=!1}var g=function(t){t.active?i._active_change(t):t.active=!0};for(var y in this.gestures){(m=this.gestures[y]).tools=a.sort_by(m.tools,(function(t){return t.default_order}));for(var d=0,b=m.tools;d<b.length;d++){var T=b[d];this.connect(T.properties.active.change,this._active_change.bind(this,T))}}for(var y in this.gestures){var A=l(y);if(A){var m,w=this[A];if("auto"==w)0!=(m=this.gestures[y]).tools.length&&h(y)&&g(m.tools[0]);else null!=w&&(a.includes(this.tools,w)?g(w):this[A]=null)}}},i}(r.ToolbarBase);e.Toolbar=_,_.__name__="Toolbar",_.init_Toolbar()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(378),_=t(381),l=o.__importStar(t(127)),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(i.ButtonToolView);n.InspectToolView=r,r.__name__="InspectToolView";var u=function(t){function e(e){var n=t.call(this,e)||this;return n.event_type="move",n}return o.__extends(e,t),e.init_InspectTool=function(){this.prototype.button_view=_.OnOffButtonView,this.define({toggleable:[l.Boolean,!0]}),this.override({active:!0})},e}(i.ButtonTool);n.InspectTool=u,u.__name__="InspectTool",u.init_InspectTool()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=t(172),r=t(379),l=t(174),u=o.__importStar(t(127)),s=t(133),c=t(116),a=t(380),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this.connect(this.model.change,(function(){return e.render()})),this.el.addEventListener("click",(function(){return e._clicked()})),this.render()},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(a.bk_toolbar_button)},e.prototype.render=function(){l.empty(this.el);var t=this.model.computed_icon;c.isString(t)&&(s.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip},e}(i.DOMView);n.ButtonToolButtonView=_,_.__name__="ButtonToolButtonView";var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(r.ToolView);n.ButtonToolView=p,p.__name__="ButtonToolView";var d=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_ButtonTool=function(){this.internal({disabled:[u.Boolean,!1]})},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),e}(r.Tool);n.ButtonTool=d,d.__name__="ButtonTool",d.init_ButtonTool()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var o=t(1),i=o.__importStar(t(127)),r=t(173),a=t(117),s=t(177),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!0,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){e.model.active?e.activate():e.deactivate()}))},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(r.View);n.ToolView=c,c.__name__="ToolView";var l=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_Tool=function(){this.prototype._known_aliases=new Map,this.internal({active:[i.Boolean,!1]})},Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},e.prototype._get_dim_limits=function(t,e,n,o){var i,r=t[0],s=t[1],c=e[0],l=e[1],p=n.bbox.h_range;"width"==o||"both"==o?(i=[a.min([r,c]),a.max([r,c])],i=[a.max([i[0],p.start]),a.min([i[1],p.end])]):i=[p.start,p.end];var _,u=n.bbox.v_range;return"height"==o||"both"==o?(_=[a.min([s,l]),a.max([s,l])],_=[a.max([_[0],u.start]),a.min([_[1],u.end])]):_=[u.start,u.end],[i,_]},e.register_alias=function(t,e){this.prototype._known_aliases.set(t,e)},e.from_string=function(t){var e=this.prototype._known_aliases.get(t);if(null!=e)return e();var n=o.__spreadArrays(this.prototype._known_aliases.keys());throw new Error("unexpected tool name '"+t+"', possible tools are "+n.join(", "))},e}(s.Model);n.Tool=l,l.__name__="Tool",l.init_Tool()},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0});var n=o(1);o(175),n.__importStar(o(174)).styles.append('.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),o=t(378),c=t(253),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.active?this.el.classList.add(c.bk_active):this.el.classList.remove(c.bk_active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(o.ButtonToolButtonView);i.OnOffButtonView=l,l.__name__="OnOffButtonView"},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),n=t(178),l=t(174),s=t(204),r=i.__importStar(t(127)),a=t(172),u=t(117),c=t(123),_=t(116),h=t(177),v=t(383),p=t(384),d=t(385),f=t(377),b=t(380),g=t(387),y=t(253),m=function(t){function o(o){return t.call(this,o)||this}return i.__extends(o,t),o.init_ToolbarViewModel=function(){this.define({_visible:[r.Any,null],autohide:[r.Boolean,!1]})},Object.defineProperty(o.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!0,configurable:!0}),o}(h.Model);e.ToolbarViewModel=m,m.__name__="ToolbarViewModel",m.init_ToolbarViewModel();var w=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views={},this._toolbar_view_model=new m({autohide:this.model.autohide})},o.prototype.lazy_initialize=function(){return i.__awaiter(this,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),[2]}}))}))},o.prototype.connect_signals=function(){var o=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,(function(){return i.__awaiter(o,void 0,void 0,(function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),this.render(),[2]}}))}))})),this.connect(this.model.properties.autohide.change,(function(){o._toolbar_view_model.autohide=o.model.autohide,o._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(function(){return o._on_visible_change()}))},o.prototype.remove=function(){s.remove_views(this._tool_button_views),t.prototype.remove.call(this)},o.prototype._build_tool_button_views=function(){return i.__awaiter(this,void 0,void 0,(function(){var t;return i.__generator(this,(function(o){switch(o.label){case 0:return t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools,[4,s.build_views(this._tool_button_views,t,{parent:this},(function(t){return t.button_view}))];case 1:return o.sent(),[2]}}))}))},o.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},o.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible,o=b.bk_toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)},o.prototype.render=function(){var t=this;if(l.empty(this.el),this.el.classList.add(b.bk_toolbar),this.el.classList.add(y.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var o="grey"===this.model.logo?g.bk_grey:null,e=l.a({href:"https://bokeh.org/",target:"_blank",class:[g.bk_logo,g.bk_logo_small,o]});this.el.appendChild(e)}var i=[],n=function(o){return t._tool_button_views[o.id].el},s=this.model.gestures;for(var r in s)i.push(s[r].tools.map(n));i.push(this.model.actions.map(n)),i.push(this.model.inspectors.filter((function(t){return t.toggleable})).map(n));for(var a=0,u=i;a<u.length;a++){var c=u[a];if(0!==c.length){var _=l.div({class:b.bk_button_bar},c);this.el.appendChild(_)}}},o.prototype.update_layout=function(){},o.prototype.update_position=function(){},o.prototype.after_layout=function(){this._has_finished=!0},o}(a.DOMView);function T(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=w,w.__name__="ToolbarBaseView";var k=function(t){function o(o){return t.call(this,o)||this}return i.__extends(o,t),o.init_ToolbarBase=function(){this.prototype.default_view=w,this.define({tools:[r.Array,[]],logo:[r.Logo,"normal"],autohide:[r.Boolean,!1]}),this.internal({gestures:[r.Any,T],actions:[r.Array,[]],inspectors:[r.Array,[]],help:[r.Array,[]],toolbar_location:[r.Location,"right"]})},o.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},o.prototype._init_tools=function(){var t=this,o=function(t,o){if(t.length!=o.length)return!0;var e=new c.Set(o.map((function(t){return t.id})));return u.some(t,(function(t){return!e.has(t.id)}))},e=this.tools.filter((function(t){return t instanceof f.InspectTool}));o(this.inspectors,e)&&(this.inspectors=e);var i=this.tools.filter((function(t){return t instanceof d.HelpTool}));o(this.help,i)&&(this.help=i);var l=this.tools.filter((function(t){return t instanceof p.ActionTool}));o(this.actions,l)&&(this.actions=l);for(var s=function(o,e){o in t.gestures||n.logger.warn("Toolbar: unknown event type '"+o+"' for tool: "+e.type+" ("+e.id+")")},r={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}},a=0,h=this.tools;a<h.length;a++){var b=h[a];if(b instanceof v.GestureTool&&b.event_type)if(_.isString(b.event_type))r[b.event_type].tools.push(b),s(b.event_type,b);else{r.multi.tools.push(b);for(var g=0,y=b.event_type;g<y.length;g++){s(y[g],b)}}}for(var m=function(t){var e=w.gestures[t];o(e.tools,r[t].tools)&&(e.tools=r[t].tools),e.active&&u.every(e.tools,(function(t){return t.id!=e.active.id}))&&(e.active=null)},w=this,T=0,k=Object.keys(r);T<k.length;T++){m(k[T])}},Object.defineProperty(o.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!0,configurable:!0}),Object.defineProperty(o.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!0,configurable:!0}),o.prototype._active_change=function(t){var o=t.event_type;if(null!=o)for(var e=0,i=_.isString(o)?[o]:o;e<i.length;e++){var l=i[e];if(t.active){var s=this.gestures[l].active;null!=s&&t!=s&&(n.logger.debug("Toolbar: deactivating tool: "+s.type+" ("+s.id+") for event type '"+l+"'"),s.active=!1),this.gestures[l].active=t,n.logger.debug("Toolbar: activating tool: "+t.type+" ("+t.id+") for event type '"+l+"'")}else this.gestures[l].active=null}},o}(h.Model);e.ToolbarBase=k,k.__name__="ToolbarBase",k.init_ToolbarBase()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(1),u=e(378),r=e(381),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t}(u.ButtonToolView);n.GestureToolView=_,_.__name__="GestureToolView";var i=function(e){function t(t){var n=e.call(this,t)||this;return n.button_view=r.OnOffButtonView,n}return o.__extends(t,e),t}(u.ButtonTool);n.GestureTool=i,i.__name__="GestureTool"},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});var e=t(1),i=t(378),u=t(122),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype._clicked=function(){this.model.do.emit()},n}(i.ButtonToolButtonView);o.ActionToolButtonView=c,c.__name__="ActionToolButtonView";var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,(function(){return n.doit()}))},n}(i.ButtonToolView);o.ActionToolView=l,l.__name__="ActionToolView";var _=function(t){function n(n){var o=t.call(this,n)||this;return o.button_view=c,o.do=new u.Signal0(o,"do"),o}return e.__extends(n,t),n}(i.ButtonTool);o.ActionTool=_,_.__name__="ActionTool"},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),n=t(384),l=i.__importStar(t(127)),r=t(386),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.doit=function(){window.open(this.model.redirect)},e}(n.ActionToolView);o.HelpToolView=p,p.__name__="HelpToolView";var _=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Help",o.icon=r.bk_tool_icon_help,o}return i.__extends(e,t),e.init_HelpTool=function(){this.prototype.default_view=p,this.define({help_tooltip:[l.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[l.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}),this.register_alias("help",(function(){return new e}))},Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!0,configurable:!0}),e}(n.ActionTool);o.HelpTool=_,_.__name__="HelpTool",_.init_HelpTool()},
function _(A,g,o){Object.defineProperty(o,"__esModule",{value:!0});var C=A(1);A(175),C.__importStar(A(174)).styles.append('.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n'),o.bk_tool_icon_box_select="bk-tool-icon-box-select",o.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",o.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",o.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",o.bk_tool_icon_help="bk-tool-icon-help",o.bk_tool_icon_hover="bk-tool-icon-hover",o.bk_tool_icon_crosshair="bk-tool-icon-crosshair",o.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",o.bk_tool_icon_pan="bk-tool-icon-pan",o.bk_tool_icon_xpan="bk-tool-icon-xpan",o.bk_tool_icon_ypan="bk-tool-icon-ypan",o.bk_tool_icon_range="bk-tool-icon-range",o.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",o.bk_tool_icon_redo="bk-tool-icon-redo",o.bk_tool_icon_reset="bk-tool-icon-reset",o.bk_tool_icon_save="bk-tool-icon-save",o.bk_tool_icon_tap_select="bk-tool-icon-tap-select",o.bk_tool_icon_undo="bk-tool-icon-undo",o.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.bk_tool_icon_box_edit="bk-tool-icon-box-edit",o.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",o.bk_tool_icon_point_draw="bk-tool-icon-point-draw",o.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit"},
function _(o,l,g){Object.defineProperty(g,"__esModule",{value:!0});var n=o(1);o(175),n.__importStar(o(174)).styles.append(".bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\\'http://www.w3.org/2000/svg\\'><filter id=\\'grayscale\\'><feColorMatrix type=\\'matrix\\' values=\\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\\'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"),g.bk_logo="bk-logo",g.bk_logo_notebook="bk-logo-notebook",g.bk_logo_small="bk-logo-small",g.bk_grey="bk-grey"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),n=this&&this.__rest||function(t,e){var i={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(i[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(r=Object.getOwnPropertySymbols(t);n<r.length;n++)e.indexOf(r[n])<0&&Object.prototype.propertyIsEnumerable.call(t,r[n])&&(i[r[n]]=t[r[n]])}return i},s=t(291),a=t(287),o=t(293),l=t(186),h=t(352),_=t(249),u=t(256),d=t(250),p=t(389),c=t(122),v=t(204),f=t(390),g=t(176),m=t(178),y=t(393),b=t(116),w=t(117),x=t(131),O=t(295),z=t(298),S=t(394),P=t(299),M=t(193),R=function(t){function e(){var e=t.apply(this,arguments)||this;return e.min_border={left:0,top:0,right:0,bottom:0},e}return r.__extends(e,t),e.prototype._measure=function(t){var e=this;t=new O.Sizeable(t).bounded_to(this.sizing.size);var i,r,n,s=this.left_panel.measure({width:0,height:t.height}),a=Math.max(s.width,this.min_border.left),o=this.right_panel.measure({width:0,height:t.height}),l=Math.max(o.width,this.min_border.right),h=this.top_panel.measure({width:t.width,height:0}),_=Math.max(h.height,this.min_border.top),u=this.bottom_panel.measure({width:t.width,height:0}),d=Math.max(u.height,this.min_border.bottom),p=new O.Sizeable(t).shrink_by({left:a,right:l,top:_,bottom:d}),c=this.center_panel.measure(p);return{width:a+c.width+l,height:_+c.height+d,inner:{left:a,right:l,top:_,bottom:d},align:(i=e.center_panel.sizing,r=i.width_policy,n=i.height_policy,"fixed"!=r&&"fixed"!=n)}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i),this.center_panel.set_geometry(i);var r=this.left_panel.measure({width:0,height:e.height}),n=this.right_panel.measure({width:0,height:e.height}),s=this.top_panel.measure({width:e.width,height:0}),a=this.bottom_panel.measure({width:e.width,height:0}),o=i.left,l=i.top,h=i.right,_=i.bottom;this.top_panel.set_geometry(new M.BBox({left:o,right:h,bottom:l,height:s.height})),this.bottom_panel.set_geometry(new M.BBox({left:o,right:h,top:_,height:a.height})),this.left_panel.set_geometry(new M.BBox({top:l,bottom:_,right:o,width:r.width})),this.right_panel.set_geometry(new M.BBox({top:l,bottom:_,left:h,width:n.width}))},e}(O.Layoutable);i.PlotLayout=R,R.__name__="PlotLayout";var k=function(t){function e(){var e=t.apply(this,arguments)||this;return e._outer_bbox=new M.BBox,e._inner_bbox=new M.BBox,e._needs_paint=!0,e._needs_layout=!1,e}return r.__extends(e,t),Object.defineProperty(e.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!0,configurable:!0}),e.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},e.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()},e.prototype.request_render=function(){this.request_paint()},e.prototype.request_paint=function(){this.is_paused||this.throttled_paint()},e.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint()},e.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new p.Reset)},e.prototype.remove=function(){this.ui_event_bus.destroy(),v.remove_views(this.renderer_views),v.remove_views(this.tool_views),this.canvas_view.remove(),t.prototype.remove.call(this)},e.prototype.render=function(){t.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this.force_paint=new c.Signal0(this,"force_paint"),this.state_changed=new c.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new g.Visuals(this.model),this._initial_state_info={selection:{},dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.canvas=new a.Canvas({use_hidpi:this.model.hidpi,output_backend:this.model.output_backend}),this.frame=new s.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.throttled_paint=y.throttle((function(){return e.force_paint.emit()}),15);var i=this.model,r=i.title_location,n=i.title;null!=r&&null!=n&&(this._title=n instanceof _.Title?n:new _.Title({text:n}));var o=this.model,l=o.toolbar_location,h=o.toolbar;null!=l&&null!=h&&(this._toolbar=new d.ToolbarPanel({toolbar:h}),h.toolbar_location=l),this.renderer_views={},this.tool_views={}},e.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){var t;return r.__generator(this,(function(e){switch(e.label){case 0:return t=this,[4,v.build_view(this.canvas,{parent:this})];case 1:return t.canvas_view=e.sent(),this.ui_event_bus=new f.UIEvents(this,this.model.toolbar,this.canvas_view.events_el),[4,this.build_renderer_views()];case 2:return e.sent(),[4,this.build_tool_views()];case 3:return e.sent(),this.update_dataranges(),this.unpause(!0),m.logger.debug("PlotView initialized"),[2]}}))}))},e.prototype._width_policy=function(){return null==this.model.frame_width?t.prototype._width_policy.call(this):"min"},e.prototype._height_policy=function(){return null==this.model.frame_height?t.prototype._height_policy.call(this):"min"},e.prototype._update_layout=function(){var t=this;this.layout=new R,this.layout.set_sizing(this.box_sizing());var e=this.model,i=e.frame_width,r=e.frame_height;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=i?{width_policy:"fixed",width:i}:{width_policy:"fit"}),null!=r?{height_policy:"fixed",height:r}:{height_policy:"fit"}));var n=w.copy(this.model.above),s=w.copy(this.model.below),a=w.copy(this.model.left),o=w.copy(this.model.right),l=function(t){switch(t){case"above":return n;case"below":return s;case"left":return a;case"right":return o}},h=this.model,u=h.title_location,p=h.title;null!=u&&null!=p&&l(u).push(this._title);var c=this.model,v=c.toolbar_location,f=c.toolbar;if(null!=v&&null!=f){var g=l(v),m=!0;if(this.model.toolbar_sticky)for(var y=0;y<g.length;y++){var x=g[y];if(x instanceof _.Title){g[y]="above"==v||"below"==v?[x,this._toolbar]:[this._toolbar,x],m=!1;break}}m&&g.push(this._toolbar)}var O=function(e,i){var r=t.renderer_views[i.id];return r.layout=new S.SidePanel(e,r)},M=function(t,e){for(var i="above"==t||"below"==t,r=[],n=0,s=e;n<s.length;n++){var a=s[n];if(b.isArray(a)){var o=a.map((function(e){var r,n=O(t,e);if(e instanceof d.ToolbarPanel){var s=i?"width_policy":"height_policy";n.set_sizing(Object.assign(Object.assign({},n.sizing),((r={})[s]="min",r)))}return n})),l=void 0;i?(l=new P.Row(o)).set_sizing({width_policy:"max",height_policy:"min"}):(l=new P.Column(o)).set_sizing({width_policy:"min",height_policy:"max"}),l.absolute=!0,r.push(l)}else r.push(O(t,a))}return r},k=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:k,top:null!=this.model.min_border_top?this.model.min_border_top:k,right:null!=this.model.min_border_right?this.model.min_border_right:k,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:k};var j=new z.VStack,B=new z.VStack,q=new z.HStack,T=new z.HStack;j.children=w.reversed(M("above",n)),B.children=M("below",s),q.children=w.reversed(M("left",a)),T.children=M("right",o),j.set_sizing({width_policy:"fit",height_policy:"min"}),B.set_sizing({width_policy:"fit",height_policy:"min"}),q.set_sizing({width_policy:"min",height_policy:"fit"}),T.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=j,this.layout.bottom_panel=B,this.layout.left_panel=q,this.layout.right_panel=T},Object.defineProperty(e.prototype,"axis_views",{get:function(){var t=[];for(var e in this.renderer_views){var i=this.renderer_views[e];i instanceof u.AxisView&&t.push(i)}return t},enumerable:!0,configurable:!0}),e.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},e.prototype.set_toolbar_visibility=function(t){for(var e=0,i=this.visibility_callbacks;e<i.length;e++){(0,i[e])(t)}},e.prototype.prepare_webgl=function(t,e){var i=this.canvas_view.webgl;if(null!=i){var r=this.canvas_view.bbox,n=r.width,s=r.height,a=this.canvas_view.model.pixel_ratio;i.canvas.width=a*n,i.canvas.height=a*s;var o=i.gl;o.enable(o.SCISSOR_TEST);var l=e[0],h=e[1],_=e[2],u=e[3],d=this.canvas_view.bbox,p=d.xview,c=d.yview,v=p.compute(l),f=c.compute(h+u);o.scissor(t*v,t*f,t*_,t*u),o.enable(o.BLEND),o.blendFuncSeparate(o.SRC_ALPHA,o.ONE_MINUS_SRC_ALPHA,o.ONE_MINUS_DST_ALPHA,o.ONE)}},e.prototype.clear_webgl=function(){var t=this.canvas_view.webgl;if(null!=t){var e=t.gl,i=t.canvas;e.viewport(0,0,i.width,i.height),e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT||e.DEPTH_BUFFER_BIT)}},e.prototype.blit_webgl=function(){var t=this.canvas_view,e=t.ctx,i=t.webgl;if(null!=i&&(m.logger.debug("drawing with WebGL"),e.restore(),e.drawImage(i.canvas,0,0),e.save(),this.model.hidpi)){var r=this.canvas.pixel_ratio;e.scale(r,r),e.translate(.5,.5)}},e.prototype.update_dataranges=function(){for(var t={},e={},i=!1,r=0,n=x.values(this.frame.x_ranges).concat(x.values(this.frame.y_ranges));r<n.length;r++){var s=n[r];s instanceof o.DataRange1d&&"log"==s.scale_hint&&(i=!0)}for(var a in this.renderer_views){var h=this.renderer_views[a];if(h instanceof l.GlyphRendererView){var _=h.glyph.bounds();if(null!=_&&(t[a]=_),i){var u=h.glyph.log_bounds();null!=u&&(e[a]=u)}}}var d,p=!1,c=!1,v=this.frame.bbox,f=v.width,g=v.height;!1!==this.model.match_aspect&&0!=f&&0!=g&&(d=1/this.model.aspect_scale*(f/g));for(var y=0,b=x.values(this.frame.x_ranges);y<b.length;y++){if((M=b[y])instanceof o.DataRange1d){var w="log"==M.scale_hint?e:t;M.update(w,0,this.model.id,d),M.follow&&(p=!0)}null!=M.bounds&&(c=!0)}for(var O=0,z=x.values(this.frame.y_ranges);O<z.length;O++){if((j=z[O])instanceof o.DataRange1d){w="log"==j.scale_hint?e:t;j.update(w,1,this.model.id,d),j.follow&&(p=!0)}null!=j.bounds&&(c=!0)}if(p&&c){m.logger.warn("Follow enabled so bounds are unset.");for(var S=0,P=x.values(this.frame.x_ranges);S<P.length;S++){var M;(M=P[S]).bounds=null}for(var R=0,k=x.values(this.frame.y_ranges);R<k.length;R++){var j;(j=k[R]).bounds=null}}this.range_update_timestamp=Date.now()},e.prototype.map_to_screen=function(t,e,i,r){return void 0===i&&(i="default"),void 0===r&&(r="default"),this.frame.map_to_screen(t,e,i,r)},e.prototype.push_state=function(t,e){var i=this.state,r=i.history,n=i.index,s=null!=r[n]?r[n].info:{},a=Object.assign(Object.assign(Object.assign({},this._initial_state_info),s),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()},e.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},e.prototype.can_undo=function(){return this.state.index>=0},e.prototype.can_redo=function(){return this.state.index<this.state.history.length-1},e.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},e.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},e.prototype.get_selection=function(){for(var t={},e=0,i=this.model.renderers;e<i.length;e++){var r=i[e];if(r instanceof l.GlyphRenderer){var n=r.data_source.selected;t[r.id]=n}}return t},e.prototype.update_selection=function(t){for(var e=0,i=this.model.renderers;e<i.length;e++){var r=i[e];if(r instanceof l.GlyphRenderer){var n=r.data_source;null!=t?null!=t[r.id]&&n.selected.update(t[r.id],!0,!1):n.selection_manager.clear()}}},e.prototype.reset_selection=function(){this.update_selection(null)},e.prototype._update_ranges_together=function(t){for(var e=1,i=0,r=t;i<r.length;i++){var n=r[i],s=n[0],a=n[1];e=Math.min(e,this._get_weight_to_constrain_interval(s,a))}if(e<1)for(var o=0,l=t;o<l.length;o++){var h=l[o];s=h[0];(a=h[1]).start=e*a.start+(1-e)*s.start,a.end=e*a.end+(1-e)*s.end}},e.prototype._update_ranges_individually=function(t,e,i,r){for(var n=!1,s=0,a=t;s<a.length;s++){var o=a[s],l=o[0],h=o[1];if(!i){var _=this._get_weight_to_constrain_interval(l,h);_<1&&(h.start=_*h.start+(1-_)*l.start,h.end=_*h.end+(1-_)*l.end)}if(null!=l.bounds&&"auto"!=l.bounds){var u=l.bounds,d=u[0],p=u[1],c=Math.abs(h.end-h.start);l.is_reversed?(null!=d&&d>=h.end&&(n=!0,h.end=d,(e||i)&&(h.start=d+c)),null!=p&&p<=h.start&&(n=!0,h.start=p,(e||i)&&(h.end=p-c))):(null!=d&&d>=h.start&&(n=!0,h.start=d,(e||i)&&(h.end=d+c)),null!=p&&p<=h.end&&(n=!0,h.end=p,(e||i)&&(h.start=p-c)))}}if(!(i&&n&&r))for(var v=0,f=t;v<f.length;v++){var g=f[v];l=g[0],h=g[1];l.have_updated_interactively=!0,l.start==h.start&&l.end==h.end||l.setv(h)}},e.prototype._get_weight_to_constrain_interval=function(t,e){var i=t.min_interval,r=t.max_interval;if(null!=t.bounds&&"auto"!=t.bounds){var n=t.bounds,s=n[0],a=n[1];if(null!=s&&null!=a){var o=Math.abs(a-s);r=null!=r?Math.min(r,o):o}}var l=1;if(null!=i||null!=r){var h=Math.abs(t.end-t.start),_=Math.abs(e.end-e.start);i>0&&_<i&&(l=(h-i)/(h-_)),r>0&&_>r&&(l=(r-h)/(_-h)),l=Math.max(0,Math.min(1,l))}return l},e.prototype.update_range=function(t,e,i,r){void 0===e&&(e=!1),void 0===i&&(i=!1),void 0===r&&(r=!0),this.pause();var n=this.frame,s=n.x_ranges,a=n.y_ranges;if(null==t){for(var o in s){(h=s[o]).reset()}for(var o in a){(h=a[o]).reset()}this.update_dataranges()}else{var l=[];for(var o in s){var h=s[o];l.push([h,t.xrs[o]])}for(var o in a){h=a[o];l.push([h,t.yrs[o]])}i&&this._update_ranges_together(l),this._update_ranges_individually(l,e,i,r)}this.unpause()},e.prototype.reset_range=function(){this.update_range(null)},e.prototype._invalidate_layout=function(){var t=this;(function(){for(var e=0,i=t.model.side_panels;e<i.length;e++){var r=i[e];if(t.renderer_views[r.id].layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()},e.prototype.get_renderer_views=function(){var t=this;return this.computed_renderers.map((function(e){return t.renderer_views[e.id]}))},e.prototype.build_renderer_views=function(){return r.__awaiter(this,void 0,void 0,(function(){var t,e,i,n,s,a,o,l,h,_;return r.__generator(this,(function(r){switch(r.label){case 0:for(this.computed_renderers=[],(n=this.computed_renderers).push.apply(n,this.model.above),(s=this.computed_renderers).push.apply(s,this.model.below),(a=this.computed_renderers).push.apply(a,this.model.left),(o=this.computed_renderers).push.apply(o,this.model.right),(l=this.computed_renderers).push.apply(l,this.model.center),(h=this.computed_renderers).push.apply(h,this.model.renderers),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar),t=0,e=this.model.toolbar.tools;t<e.length;t++)null!=(i=e[t]).overlay&&this.computed_renderers.push(i.overlay),(_=this.computed_renderers).push.apply(_,i.synthetic_renderers);return[4,v.build_views(this.renderer_views,this.computed_renderers,{parent:this})];case 1:return r.sent(),[2]}}))}))},e.prototype.build_tool_views=function(){return r.__awaiter(this,void 0,void 0,(function(){var t,e=this;return r.__generator(this,(function(i){switch(i.label){case 0:return t=this.model.toolbar.tools,[4,v.build_views(this.tool_views,t,{parent:this})];case 1:return i.sent().map((function(t){return e.ui_event_bus.register_tool(t)})),[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.force_paint,(function(){return e.repaint()}));var i=this.frame,n=i.x_ranges,s=i.y_ranges;for(var a in n){var o=n[a];this.connect(o.change,(function(){e._needs_layout=!0,e.request_paint()}))}for(var a in s){o=s[a];this.connect(o.change,(function(){e._needs_layout=!0,e.request_paint()}))}this.connect(this.model.properties.renderers.change,(function(){return r.__awaiter(e,void 0,void 0,(function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return t.sent(),[2]}}))}))})),this.connect(this.model.toolbar.properties.tools.change,(function(){return r.__awaiter(e,void 0,void 0,(function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,this.build_renderer_views()];case 1:return t.sent(),[4,this.build_tool_views()];case 2:return t.sent(),[2]}}))}))})),this.connect(this.model.change,(function(){return e.request_paint()})),this.connect(this.model.reset,(function(){return e.reset()}))},e.prototype.set_initial_range=function(){var t=!0,e=this.frame,i=e.x_ranges,r=e.y_ranges,n={},s={};for(var a in i){var o=i[a],l=o.start,h=o.end;if(null==l||null==h||b.isStrictNaN(l+h)){t=!1;break}n[a]={start:l,end:h}}if(t)for(var a in r){var _=r[a];l=_.start,h=_.end;if(null==l||null==h||b.isStrictNaN(l+h)){t=!1;break}s[a]={start:l,end:h}}t?(this._initial_state_info.range={xrs:n,yrs:s},m.logger.debug("initial ranges set")):m.logger.warn("could not set initial ranges")},e.prototype.has_finished=function(){if(!t.prototype.has_finished.call(this))return!1;for(var e in this.renderer_views){if(!this.renderer_views[e].has_finished())return!1}return!0},e.prototype.after_layout=function(){if(t.prototype.after_layout.call(this),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),outer_width:Math.round(this.layout._width.value),outer_height:Math.round(this.layout._height.value)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var e=this.layout.bbox,i=e.width,r=e.height;this.canvas_view.prepare_canvas(i,r),this._outer_bbox=this.layout.bbox,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&(this._needs_paint=!1,this.paint())},e.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},e.prototype.paint=function(){var t=this;if(!this.is_paused){m.logger.trace("PlotView.paint() for "+this.model.id);var e=this.model.document;if(null!=e){var i=e.interactive_duration();i>=0&&i<this.model.lod_interval?setTimeout((function(){e.interactive_duration()>t.model.lod_timeout&&e.interactive_stop(t.model),t.request_paint()}),this.model.lod_timeout):e.interactive_stop(this.model)}for(var r in this.renderer_views){var n=this.renderer_views[r];if(null==this.range_update_timestamp||n instanceof l.GlyphRendererView&&n.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}var s=this.canvas_view.ctx,a=this.canvas.pixel_ratio;s.save(),this.model.hidpi&&(s.scale(a,a),s.translate(.5,.5));var o=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value];if(this._map_hook(s,o),this._paint_empty(s,o),this.prepare_webgl(a,o),this.clear_webgl(),this.visuals.outline_line.doit){s.save(),this.visuals.outline_line.set_value(s);var h=o[0],_=o[1],u=o[2],d=o[3];h+u==this.layout._width.value&&(u-=1),_+d==this.layout._height.value&&(d-=1),s.strokeRect(h,_,u,d),s.restore()}this._paint_levels(s,["image","underlay","glyph"],o,!0),this._paint_levels(s,["annotation"],o,!1),this._paint_levels(s,["overlay"],o,!1),null==this._initial_state_info.range&&this.set_initial_range(),s.restore()}},e.prototype._paint_levels=function(t,e,i,r){for(var n=0,s=e;n<s.length;n++)for(var a=s[n],o=0,l=this.computed_renderers;o<l.length;o++){var h=l[o];if(h.level==a){var _=this.renderer_views[h.id];t.save(),(r||_.needs_clip)&&(t.beginPath(),t.rect.apply(t,i),t.clip()),_.render(),t.restore(),_.has_webgl&&(this.blit_webgl(),this.clear_webgl())}}},e.prototype._map_hook=function(t,e){},e.prototype._paint_empty=function(t,e){var i=[0,0,this.layout._width.value,this.layout._height.value],r=i[0],n=i[1],s=i[2],a=i[3],o=e[0],l=e[1],h=e[2],_=e[3];t.clearRect(r,n,s,a),this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(r,n,s,a),t.clearRect(o,l,h,_)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(o,l,h,_))},e.prototype.save=function(t){this.canvas_view.save(t)},e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this),i=e.children,s=n(e,["children"]),a=this.get_renderer_views().map((function(t){return t.serializable_state()})).filter((function(t){return"bbox"in t}));return Object.assign(Object.assign({},s),{children:r.__spreadArrays(i,a)})},e}(h.LayoutDOMView);i.PlotView=k,k.__name__="PlotView"},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var r=t(1),o=this&&this.__decorate||function(t,n,e,r){var o,s=arguments.length,_=s<3?n:null===r?r=Object.getOwnPropertyDescriptor(n,e):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)_=Reflect.decorate(t,n,e,r);else for(var i=t.length-1;i>=0;i--)(o=t[i])&&(_=(s<3?o(_):s>3?o(n,e,_):o(n,e))||_);return s>3&&_&&Object.defineProperty(n,e,_),_};function s(t){return function(n){n.prototype.event_name=t}}var _=function(){function t(){this.origin=null}return t.prototype.to_json=function(){return{event_name:this.event_name,event_values:this._to_json()}},t.prototype._to_json=function(){return{model:this.origin}},t}();e.BokehEvent=_,_.__name__="BokehEvent";var i=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(_);e.ButtonClick=i,i.__name__="ButtonClick",e.ButtonClick=i=o([s("button_click")],i);var a=function(t){function n(n){var e=t.call(this)||this;return e.item=n,e}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.item;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{item:n})},n}(_);e.MenuItemClick=a,a.__name__="MenuItemClick",e.MenuItemClick=a=o([s("menu_item_click")],a);var u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(_);e.UIEvent=u,u.__name__="UIEvent";var c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(u);e.LODStart=c,c.__name__="LODStart",e.LODStart=c=o([s("lodstart")],c);var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(u);e.LODEnd=l,l.__name__="LODEnd",e.LODEnd=l=o([s("lodend")],l);var p=function(t){function n(n,e){var r=t.call(this)||this;return r.geometry=n,r.final=e,r}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.geometry,e=this.final;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{geometry:n,final:e})},n}(u);e.SelectionGeometry=p,p.__name__="SelectionGeometry",e.SelectionGeometry=p=o([s("selectiongeometry")],p);var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(u);e.Reset=h,h.__name__="Reset",e.Reset=h=o([s("reset")],h);var f=function(t){function n(n,e,r,o){var s=t.call(this)||this;return s.sx=n,s.sy=e,s.x=r,s.y=o,s}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.sx,e=this.sy,r=this.x,o=this.y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{sx:n,sy:e,x:r,y:o})},n}(u);e.PointEvent=f,f.__name__="PointEvent";var y=function(t){function n(n,e,r,o,s,_){var i=t.call(this,n,e,r,o)||this;return i.sx=n,i.sy=e,i.x=r,i.y=o,i.delta_x=s,i.delta_y=_,i}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.delta_x,e=this.delta_y;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta_x:n,delta_y:e})},n}(f);e.Pan=y,y.__name__="Pan",e.Pan=y=o([s("pan")],y);var v=function(t){function n(n,e,r,o,s){var _=t.call(this,n,e,r,o)||this;return _.sx=n,_.sy=e,_.x=r,_.y=o,_.scale=s,_}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.scale;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{scale:n})},n}(f);e.Pinch=v,v.__name__="Pinch",e.Pinch=v=o([s("pinch")],v);var d=function(t){function n(n,e,r,o,s){var _=t.call(this,n,e,r,o)||this;return _.sx=n,_.sy=e,_.x=r,_.y=o,_.rotation=s,_}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.rotation;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{rotation:n})},n}(f);e.Rotate=d,d.__name__="Rotate",e.Rotate=d=o([s("rotate")],d);var m=function(t){function n(n,e,r,o,s){var _=t.call(this,n,e,r,o)||this;return _.sx=n,_.sy=e,_.x=r,_.y=o,_.delta=s,_}return r.__extends(n,t),n.prototype._to_json=function(){var n=this.delta;return Object.assign(Object.assign({},t.prototype._to_json.call(this)),{delta:n})},n}(f);e.MouseWheel=m,m.__name__="MouseWheel",e.MouseWheel=m=o([s("wheel")],m);var x=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.MouseMove=x,x.__name__="MouseMove",e.MouseMove=x=o([s("mousemove")],x);var j=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.MouseEnter=j,j.__name__="MouseEnter",e.MouseEnter=j=o([s("mouseenter")],j);var P=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.MouseLeave=P,P.__name__="MouseLeave",e.MouseLeave=P=o([s("mouseleave")],P);var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.Tap=O,O.__name__="Tap",e.Tap=O=o([s("tap")],O);var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.DoubleTap=b,b.__name__="DoubleTap",e.DoubleTap=b=o([s("doubletap")],b);var g=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.Press=g,g.__name__="Press",e.Press=g=o([s("press")],g);var E=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.PressUp=E,E.__name__="PressUp",e.PressUp=E=o([s("pressup")],E);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.PanStart=M,M.__name__="PanStart",e.PanStart=M=o([s("panstart")],M);var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.PanEnd=R,R.__name__="PanEnd",e.PanEnd=R=o([s("panend")],R);var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.PinchStart=S,S.__name__="PinchStart",e.PinchStart=S=o([s("pinchstart")],S);var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.PinchEnd=k,k.__name__="PinchEnd",e.PinchEnd=k=o([s("pinchend")],k);var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.RotateStart=D,D.__name__="RotateStart",e.RotateStart=D=o([s("rotatestart")],D);var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n}(f);e.RotateEnd=L,L.__name__="RotateEnd",e.RotateEnd=L=o([s("rotateend")],L)},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),r=i.__importDefault(t(391)),s=t(122),o=t(178),a=t(174),_=t(392),h=t(117),p=t(131),c=t(116),u=t(209),l=i.__importStar(t(389));var v=function(){function t(t,e,n){var i=this;this.plot_view=t,this.toolbar=e,this.hit_area=n,this.pan_start=new s.Signal(this,"pan:start"),this.pan=new s.Signal(this,"pan"),this.pan_end=new s.Signal(this,"pan:end"),this.pinch_start=new s.Signal(this,"pinch:start"),this.pinch=new s.Signal(this,"pinch"),this.pinch_end=new s.Signal(this,"pinch:end"),this.rotate_start=new s.Signal(this,"rotate:start"),this.rotate=new s.Signal(this,"rotate"),this.rotate_end=new s.Signal(this,"rotate:end"),this.tap=new s.Signal(this,"tap"),this.doubletap=new s.Signal(this,"doubletap"),this.press=new s.Signal(this,"press"),this.pressup=new s.Signal(this,"pressup"),this.move_enter=new s.Signal(this,"move:enter"),this.move=new s.Signal(this,"move"),this.move_exit=new s.Signal(this,"move:exit"),this.scroll=new s.Signal(this,"scroll"),this.keydown=new s.Signal(this,"keydown"),this.keyup=new s.Signal(this,"keyup"),this.hammer=new r.default(this.hit_area,{touchAction:"auto",inputClass:r.default.TouchMouseInput}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(function(t){return i._mouse_move(t)})),this.hit_area.addEventListener("mouseenter",(function(t){return i._mouse_enter(t)})),this.hit_area.addEventListener("mouseleave",(function(t){return i._mouse_exit(t)})),this.hit_area.addEventListener("wheel",(function(t){return i._mouse_wheel(t)})),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}return t.prototype.destroy=function(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(function(e){return t._doubletap(e)})),this.hammer.on("tap",(function(e){return t._tap(e)})),this.hammer.on("press",(function(e){return t._press(e)})),this.hammer.on("pressup",(function(e){return t._pressup(e)})),this.hammer.get("pan").set({direction:r.default.DIRECTION_ALL}),this.hammer.on("panstart",(function(e){return t._pan_start(e)})),this.hammer.on("pan",(function(e){return t._pan(e)})),this.hammer.on("panend",(function(e){return t._pan_end(e)})),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(function(e){return t._pinch_start(e)})),this.hammer.on("pinch",(function(e){return t._pinch(e)})),this.hammer.on("pinchend",(function(e){return t._pinch_end(e)})),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(function(e){return t._rotate_start(e)})),this.hammer.on("rotate",(function(e){return t._rotate(e)})),this.hammer.on("rotateend",(function(e){return t._rotate_end(e)}))},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&(c.isString(n)?this._register_tool(t,n):n.forEach((function(n,i){return e._register_tool(t,n,i<1)})))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var i=t,r=i.model.id,s=function(t){return function(e){e.id==r&&t(e.e)}},a=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=i._pan_start&&i.connect(this.pan_start,s(i._pan_start.bind(i))),null!=i._pan&&i.connect(this.pan,s(i._pan.bind(i))),null!=i._pan_end&&i.connect(this.pan_end,s(i._pan_end.bind(i)));break;case"pinch":null!=i._pinch_start&&i.connect(this.pinch_start,s(i._pinch_start.bind(i))),null!=i._pinch&&i.connect(this.pinch,s(i._pinch.bind(i))),null!=i._pinch_end&&i.connect(this.pinch_end,s(i._pinch_end.bind(i)));break;case"rotate":null!=i._rotate_start&&i.connect(this.rotate_start,s(i._rotate_start.bind(i))),null!=i._rotate&&i.connect(this.rotate,s(i._rotate.bind(i))),null!=i._rotate_end&&i.connect(this.rotate_end,s(i._rotate_end.bind(i)));break;case"move":null!=i._move_enter&&i.connect(this.move_enter,s(i._move_enter.bind(i))),null!=i._move&&i.connect(this.move,s(i._move.bind(i))),null!=i._move_exit&&i.connect(this.move_exit,s(i._move_exit.bind(i)));break;case"tap":null!=i._tap&&i.connect(this.tap,s(i._tap.bind(i)));break;case"press":null!=i._press&&i.connect(this.press,s(i._press.bind(i))),null!=i._pressup&&i.connect(this.pressup,s(i._pressup.bind(i)));break;case"scroll":null!=i._scroll&&i.connect(this.scroll,s(i._scroll.bind(i)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=i._doubletap&&i.connect(this.doubletap,a(i._doubletap.bind(i))),null!=i._keydown&&i.connect(this.keydown,a(i._keydown.bind(i))),null!=i._keyup&&i.connect(this.keyup,a(i._keyup.bind(i))),u.is_mobile&&null!=i._scroll&&"pinch"==e&&(o.logger.debug("Registering scroll on touch screen"),i.connect(this.scroll,s(i._scroll.bind(i)))))},t.prototype._hit_test_renderers=function(t,e){for(var n=this.plot_view.get_renderer_views(),i=0,r=h.reversed(n);i<r.length;i++){var s=r[i],o=s.model.level;if(("annotation"==o||"overlay"==o)&&null!=s.interactive_hit&&s.interactive_hit(t,e))return s}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.layout.bbox.contains(t,e)},t.prototype._trigger=function(t,e,n){var i=this,r=this.toolbar.gestures,s=t.name.split(":")[0],o=this._hit_test_renderers(e.sx,e.sy),a=this._hit_test_canvas(e.sx,e.sy);switch(s){case"move":null!=(l=r[s].active)&&this.trigger(t,e,l.id);var _=this.toolbar.inspectors.filter((function(t){return t.active})),h="default";null!=o?(h=o.cursor(e.sx,e.sy)||h,p.isEmpty(_)||(t=this.move_exit)):this._hit_test_frame(e.sx,e.sy)&&(p.isEmpty(_)||(h="crosshair")),this.plot_view.set_cursor(h),this.plot_view.set_toolbar_visibility(a),_.map((function(n){return i.trigger(t,e,n.id)}));break;case"tap":var c=n.target;if(null!=c&&c!=this.hit_area)return;null!=o&&null!=o.on_hit&&o.on_hit(e.sx,e.sy),null!=(l=r[s].active)&&this.trigger(t,e,l.id);break;case"scroll":null!=(l=r[u.is_mobile?"pinch":"scroll"].active)&&(n.preventDefault(),n.stopPropagation(),this.trigger(t,e,l.id));break;case"pan":null!=(l=r[s].active)&&(n.preventDefault(),this.trigger(t,e,l.id));break;default:var l;null!=(l=r[s].active)&&this.trigger(t,e,l.id)}this._trigger_bokeh_event(e)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=this,n=function(){var n=e.plot_view.frame.xscales.default,i=e.plot_view.frame.yscales.default,r=t.sx,s=t.sy,o=n.invert(r),a=i.invert(s);switch(t.type){case"wheel":return new l.MouseWheel(r,s,o,a,t.delta);case"mousemove":return new l.MouseMove(r,s,o,a);case"mouseenter":return new l.MouseEnter(r,s,o,a);case"mouseleave":return new l.MouseLeave(r,s,o,a);case"tap":return new l.Tap(r,s,o,a);case"doubletap":return new l.DoubleTap(r,s,o,a);case"press":return new l.Press(r,s,o,a);case"pressup":return new l.PressUp(r,s,o,a);case"pan":return new l.Pan(r,s,o,a,t.deltaX,t.deltaY);case"panstart":return new l.PanStart(r,s,o,a);case"panend":return new l.PanEnd(r,s,o,a);case"pinch":return new l.Pinch(r,s,o,a,t.scale);case"pinchstart":return new l.PinchStart(r,s,o,a);case"pinchend":return new l.PinchEnd(r,s,o,a);case"rotate":return new l.Rotate(r,s,o,a,t.rotation);case"rotatestart":return new l.RotateStart(r,s,o,a);case"rotateend":return new l.RotateEnd(r,s,o,a);default:return}}();null!=n&&this.plot_view.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,i=e.pageY,r=a.offset(this.hit_area);return{sx:n-r.left,sy:i-r.top}},t.prototype._pan_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey})},t.prototype._pinch_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey})},t.prototype._rotate_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey})},t.prototype._tap_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey})},t.prototype._move_event=function(t){return Object.assign({type:t.type},this._get_sxy(t))},t.prototype._scroll_event=function(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:_.getDeltaY(t)})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._pressup=function(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();n.UIEvents=v,v.__name__="UIEvents"},
function _(t,e,n){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,n,i,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=n.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,n){return setTimeout(y(t,n),e)}function p(t,e,n){return!!Array.isArray(t)&&(f(t,n[e],n),!0)}function f(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(void 0!==t.length)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function v(e,n,i){var r="DEPRECATED METHOD: "+n+"\n"+i+" AT \n";return function(){var n=new Error("get-stack-trace"),i=n&&n.stack?n.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,i),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(null!=i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var d=v((function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&void 0===t[i[r]])&&(t[i[r]]=e[i[r]]),r++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,n){var i,r=e.prototype;(i=t.prototype=Object.create(r)).constructor=t,i._super=r,n&&s(i,n)}function y(t,e){return function(){return t.apply(e,arguments)}}function T(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function E(t,e){return void 0===t?e:t}function I(t,e,n){f(S(e),(function(e){t.addEventListener(e,n,!1)}))}function A(t,e,n){f(S(e),(function(e){t.removeEventListener(e,n,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function x(t){return Array.prototype.slice.call(t,0)}function P(t,e,n){for(var i=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&i.push(t[s]),r[s]=o,s++}return n&&(i=e?i.sort((function(t,n){return t[e]>n[e]})):i.sort()),i}function D(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),s=0;s<o.length;){if((i=(n=o[s])?n+r:e)in t)return i;s++}}var w=1;function O(e){var n=e.ownerDocument||e;return n.defaultView||n.parentWindow||t}var R="ontouchstart"in t,M=void 0!==D(t,"PointerEvent"),z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N=["x","y"],X=["clientX","clientY"];function Y(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){T(t.options.enable,[t])&&n.handler(e)},this.init()}function F(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,s=1&e&&i-r==0,o=12&e&&i-r==0;n.isFirst=!!s,n.isFinal=!!o,s&&(t.session={}),n.eventType=e,function(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=W(e));r>1&&!n.firstMultiple?n.firstMultiple=W(e):1===r&&(n.firstMultiple=!1);var s=n.firstInput,o=n.firstMultiple,a=o?o.center:s.center,h=e.center=q(i);e.timeStamp=c(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=U(a,h),e.distance=L(a,h),function(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y});e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}(n,e),e.offsetDirection=H(e.deltaX,e.deltaY);var l=k(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=l.x,e.overallVelocityY=l.y,e.overallVelocity=u(l.x)>u(l.y)?l.x:l.y,e.scale=o?(p=o.pointers,f=i,L(f[0],f[1],X)/L(p[0],p[1],X)):1,e.rotation=o?function(t,e){return U(e[1],e[0],X)+U(t[1],t[0],X)}(o.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,function(t,e){var n,i,r,s,o=t.lastInterval||e,a=e.timeStamp-o.timeStamp;if(8!=e.eventType&&(a>25||void 0===o.velocity)){var h=e.deltaX-o.deltaX,c=e.deltaY-o.deltaY,l=k(a,h,c);i=l.x,r=l.y,n=u(l.x)>u(l.y)?l.x:l.y,s=H(h,c),t.lastInterval=e}else n=o.velocity,i=o.velocityX,r=o.velocityY,s=o.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=s}(n,e);var p,f;var v=t.element;_(e.srcEvent.target,v)&&(v=e.srcEvent.target);e.target=v}(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function W(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:h(t.pointers[n].clientX),clientY:h(t.pointers[n].clientY)},n++;return{timeStamp:c(),pointers:e,center:q(e),deltaX:t.deltaX,deltaY:t.deltaY}}function q(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:h(n/e),y:h(i/e)}}function k(t,e,n){return{x:e/t||0,y:n/t||0}}function H(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function L(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function U(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}Y.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var V={mousedown:1,mousemove:2,mouseup:4};function j(){this.evEl="mousedown",this.evWin="mousemove mouseup",this.pressed=!1,Y.apply(this,arguments)}g(j,Y,{handler:function(t){var e=V[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var G={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Z={2:"touch",3:"pen",4:"mouse",5:"kinect"},B="pointerdown",$="pointermove pointerup pointercancel";function J(){this.evEl=B,this.evWin=$,Y.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(B="MSPointerDown",$="MSPointerMove MSPointerUp MSPointerCancel"),g(J,Y,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=G[i],s=Z[t.pointerType]||t.pointerType,o="touch"==s,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),n&&e.splice(a,1))}});var K={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function Q(){this.evTarget="touchstart",this.evWin="touchstart touchmove touchend touchcancel",this.started=!1,Y.apply(this,arguments)}function tt(t,e){var n=x(t.touches),i=x(t.changedTouches);return 12&e&&(n=P(n.concat(i),"identifier",!0)),[n,i]}g(Q,Y,{handler:function(t){var e=K[t.type];if(1===e&&(this.started=!0),this.started){var n=tt.call(this,t,e);12&e&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var et={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function nt(){this.evTarget="touchstart touchmove touchend touchcancel",this.targetIds={},Y.apply(this,arguments)}function it(t,e){var n=x(t.touches),i=this.targetIds;if(3&e&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,s,o=x(t.changedTouches),a=[],h=this.target;if(s=n.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)i[s[r].identifier]=!0,r++;for(r=0;r<o.length;)i[o[r].identifier]&&a.push(o[r]),12&e&&delete i[o[r].identifier],r++;return a.length?[P(s.concat(a),"identifier",!0),a]:void 0}g(nt,Y,{handler:function(t){var e=et[t.type],n=it.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});function rt(){Y.apply(this,arguments);var t=y(this.handler,this);this.touch=new nt(this.manager,t),this.mouse=new j(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function st(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,ot.call(this,e)):12&t&&ot.call(this,e)}function ot(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches;setTimeout((function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)}),2500)}}function at(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],s=Math.abs(e-r.x),o=Math.abs(n-r.y);if(s<=25&&o<=25)return!0}return!1}g(rt,Y,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)st.call(this,e,n);else if(r&&at.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var ht=D(a.style,"touchAction"),ut=void 0!==ht,ct=function(){if(!ut)return!1;var e={},n=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(i){e[i]=!n||t.CSS.supports("touch-action",i)})),e}();function lt(t,e){this.manager=t,this.set(e)}lt.prototype={set:function(t){"compute"==t&&(t=this.compute()),ut&&this.manager.element.style&&ct[t]&&(this.manager.element.style[ht]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){T(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,"none"))return"none";var e=C(t,"pan-x"),n=C(t,"pan-y");if(e&&n)return"none";if(e||n)return e?"pan-x":"pan-y";if(C(t,"manipulation"))return"manipulation";return"auto"}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var i=this.actions,r=C(i,"none")&&!ct.none,s=C(i,"pan-y")&&!ct["pan-y"],o=C(i,"pan-x")&&!ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&n||o&&24&n?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};function pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function ft(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function vt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function dt(t,e){var n=e.manager;return n?n.get(t):t}function mt(){pt.apply(this,arguments)}function gt(){mt.apply(this,arguments),this.pX=null,this.pY=null}function yt(){mt.apply(this,arguments)}function Tt(){pt.apply(this,arguments),this._timer=null,this._input=null}function Et(){mt.apply(this,arguments)}function It(){mt.apply(this,arguments)}function At(){pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function _t(t,e){return(e=e||{}).recognizers=E(e.recognizers,_t.defaults.preset),new Ct(t,e)}pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=dt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=dt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=dt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=dt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,n=this.state;function i(n){e.manager.emit(n,t)}n<8&&i(e.options.event+ft(n)),i(e.options.event),t.additionalEvent&&i(t.additionalEvent),n>=8&&i(e.options.event+ft(n))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!T(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(mt,pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=6&e,r=this.attrTest(t);return i&&(8&n||!r)?16|e:i||r?4&n?8|e:2&e?4|e:2:32}}),g(gt,mt,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push("pan-y"),24&t&&e.push("pan-x"),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,n=s!=this.pX,i=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,n=o!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return mt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=vt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(yt,mt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Tt,pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return["auto"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Et,mt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(It,mt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return gt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return 30&n?e=t.overallVelocity:6&n?e=t.overallVelocityX:24&n&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=vt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(At,pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return["manipulation"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(i&&r&&n){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||L(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return 32},failTimeout:function(){return this._timer=l((function(){this.state=32}),this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),_t.VERSION="2.0.7",_t.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Et,{enable:!1}],[yt,{enable:!1},["rotate"]],[It,{direction:6}],[gt,{direction:6},["swipe"]],[At],[At,{event:"doubletap",taps:2},["tap"]],[Tt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Ct(t,e){var n;this.options=s({},_t.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((n=this).options.inputClass||(M?J:z?nt:R?rt:j))(n,F),this.touchAction=new lt(this,this.options.touchAction),St(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function St(t,e){var n,i=t.element;i.style&&(f(t.options.cssProps,(function(r,s){n=D(i.style,s),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""})),e||(t.oldCssProps={}))}Ct.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var n;this.touchAction.preventDefaults(t);var i=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<i.length;)n=i[s],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&14&n.state&&(r=e.curRecognizer=n),s++}},get:function(t){if(t instanceof pt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=b(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(void 0!==t&&void 0!==e){var n=this.handlers;return f(S(t),(function(t){n[t]=n[t]||[],n[t].push(e)})),this}},off:function(t,e){if(void 0!==t){var n=this.handlers;return f(S(t),(function(t){e?n[t]&&n[t].splice(b(n[t],e),1):delete n[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var i=n.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<i.length;)i[r](e),r++}},destroy:function(){this.element&&St(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(_t,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:32,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:24,DIRECTION_ALL:30,Manager:Ct,Input:Y,TouchAction:lt,TouchInput:nt,MouseInput:j,PointerEventInput:J,TouchMouseInput:rt,SingleTouchInput:Q,Recognizer:pt,AttrRecognizer:mt,Tap:At,Pan:gt,Swipe:It,Pinch:yt,Rotate:Et,Press:Tt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:y,prefixed:D}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=_t,"function"==typeof define&&define.amd?define((function(){return _t})):void 0!==e&&e.exports?e.exports=_t:t.Hammer=_t}(window,document)},
function _(e,t,n){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function r(e){var t=getComputedStyle(e).fontSize;return null!=t?parseInt(t,10):null}Object.defineProperty(n,"__esModule",{value:!0}),n.getDeltaY=function(e){var t,n=-e.deltaY;if(e.target instanceof HTMLElement)switch(e.deltaMode){case e.DOM_DELTA_LINE:n*=r((t=e.target).offsetParent||document.body)||r(t)||16;break;case e.DOM_DELTA_PAGE:n*=function(e){return e.clientHeight}(e.target)}return n}},
function _(n,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(n){return n(Date.now()),-1};o.throttle=function(n,e){var o=null,t=0,u=!1,d=function(){t=Date.now(),o=null,u=!1,n()};return function(){var n=Date.now(),w=e-(n-t);w<=0&&!u?(null!=o&&clearTimeout(o),u=!0,i(d)):o||u||(o=setTimeout((function(){return i(d)}),w))}}},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var l=e(1),r=e(296),a=e(297),o=e(116),n=Math.PI/2,h="left",s="center",d={above:{parallel:0,normal:-n,horizontal:0,vertical:-n},below:{parallel:0,normal:n,horizontal:0,vertical:n},left:{parallel:-n,normal:0,horizontal:0,vertical:-n},right:{parallel:n,normal:0,horizontal:0,vertical:n}},c={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},p={above:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},below:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},left:{justified:s,parallel:s,normal:"right",horizontal:"right",vertical:s},right:{justified:s,parallel:s,normal:h,horizontal:h,vertical:s}},_={above:"right",below:h,left:"right",right:h},b={above:h,below:"right",left:"right",right:h},m=function(e){function t(t,i){var l=e.call(this)||this;switch(l.side=t,l.obj=i,l.side){case"above":l._dim=0,l._normals=[0,-1];break;case"below":l._dim=0,l._normals=[0,1];break;case"left":l._dim=1,l._normals=[-1,0];break;case"right":l._dim=1,l._normals=[1,0]}return l.is_horizontal?l.set_sizing({width_policy:"max",height_policy:"fixed"}):l.set_sizing({width_policy:"fixed",height_policy:"max"}),l}return l.__extends(t,e),t.prototype._content_size=function(){return new r.Sizeable(this.get_oriented_size())},t.prototype.get_oriented_size=function(){var e=this.obj.get_size(),t=e.width,i=e.height;return!this.obj.rotate||this.is_horizontal?{width:t,height:i}:{width:i,height:t}},t.prototype.has_size_changed=function(){var e=this.get_oriented_size(),t=e.width,i=e.height;return this.is_horizontal?this.bbox.height!=i:this.bbox.width!=t},Object.defineProperty(t.prototype,"dimension",{get:function(){return this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"normals",{get:function(){return this._normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_horizontal",{get:function(){return 0==this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_vertical",{get:function(){return 1==this._dim},enumerable:!0,configurable:!0}),t.prototype.apply_label_text_heuristics=function(e,t){var i,l,r=this.side;o.isString(t)?(i=c[r][t],l=p[r][t]):0===t?(i="whatever",l="whatever"):t<0?(i="middle",l=_[r]):(i="middle",l=b[r]),e.textBaseline=i,e.textAlign=l},t.prototype.get_label_angle_heuristic=function(e){return d[this.side][e]},t}(a.ContentLayoutable);i.SidePanel=m,m.__name__="SidePanel"},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),n=t(122),s=t(174),a=t(138),p=t(388),l=new n.Signal0({},"gmaps_ready"),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var o=this.model.map_options,i=o.zoom,n=o.lat,s=o.lng;if(this.initial_zoom=i,this.initial_lat=n,this.initial_lng=s,"undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback)!function(t){window._bokeh_gmaps_callback=function(){return l.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?v=3.36&key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(atob(this.model.api_key));l.connect((function(){return e.request_render()}))}this.unpause()},e.prototype.remove=function(){s.remove(this.map_el),t.prototype.remove.call(this)},e.prototype.update_range=function(e){if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(e.sdx||0,e.sdy||0),t.prototype.update_range.call(this,e);else if(null!=e.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e);var o=e.factor<0?-1:1,i=this.map.getZoom(),n=i+o;if(n>=2){this.map.setZoom(n);var s=this._get_projected_bounds(),a=s[0];s[1]-a<0&&this.map.setZoom(i)}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var o=this.model.map_options,i={center:new e.LatLng(o.lat,o.lng),zoom:o.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[o.map_type],scaleControl:o.scale_control,tilt:o.tilt};null!=o.styles&&(i.styles=JSON.parse(o.styles)),this.map_el=s.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new e.Map(this.map_el,i),e.event.addListener(this.map,"idle",(function(){return t._set_bokeh_ranges()})),e.event.addListener(this.map,"bounds_changed",(function(){return t._set_bokeh_ranges()})),e.event.addListenerOnce(this.map,"tilesloaded",(function(){return t._render_finished()})),this.connect(this.model.properties.map_options.change,(function(){return t._update_options()})),this.connect(this.model.map_options.properties.styles.change,(function(){return t._update_styles()})),this.connect(this.model.map_options.properties.lat.change,(function(){return t._update_center("lat")})),this.connect(this.model.map_options.properties.lng.change,(function(){return t._update_center("lng")})),this.connect(this.model.map_options.properties.zoom.change,(function(){return t._update_zoom()})),this.connect(this.model.map_options.properties.map_type.change,(function(){return t._update_map_type()})),this.connect(this.model.map_options.properties.scale_control.change,(function(){return t._update_scale_control()})),this.connect(this.model.map_options.properties.tilt.change,(function(){return t._update_tilt()}))},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),o=t.getSouthWest();return[o.lng(),e.lng(),o.lat(),e.lat()]},e.prototype._get_projected_bounds=function(){var t=this._get_latlon_bounds(),e=t[0],o=t[1],i=t[2],n=t[3],s=a.wgs84_mercator.forward([e,i]),p=s[0],l=s[1],_=a.wgs84_mercator.forward([o,n]);return[p,_[0],l,_[1]]},e.prototype._set_bokeh_ranges=function(){var t=this._get_projected_bounds(),e=t[0],o=t[1],i=t[2],n=t[3];this.frame.x_range.setv({start:e,end:o}),this.frame.y_range.setv({start:i,end:n})},e.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){var o=e[0],i=e[1],n=e[2],s=e[3];this.map_el.style.top=i+"px",this.map_el.style.left=o+"px",this.map_el.style.width=n+"px",this.map_el.style.height=s+"px"}},e.prototype._paint_empty=function(t,e){var o=this.layout._width.value,i=this.layout._height.value,n=e[0],s=e[1],a=e[2],p=e[3];t.clearRect(0,0,o,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(o,i),t.lineTo(o,0),t.lineTo(0,0),t.moveTo(n,s),t.lineTo(n+a,s),t.lineTo(n+a,s+p),t.lineTo(n,s+p),t.lineTo(n,s),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())},e}(p.PlotView);o.GMapPlotView=_,_.__name__="GMapPlotView"},
function _(a,e,n){Object.defineProperty(n,"__esModule",{value:!0});var g=a(294);n.DataRange=g.DataRange;var R=a(293);n.DataRange1d=R.DataRange1d;var r=a(196);n.FactorRange=r.FactorRange;var t=a(197);n.Range=t.Range;var d=a(238);n.Range1d=d.Range1d},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var n=e(186);d.GlyphRenderer=n.GlyphRenderer;var R=e(205);d.GraphRenderer=R.GraphRenderer;var a=e(257);d.GuideRenderer=a.GuideRenderer;var G=e(171);d.Renderer=G.Renderer},
function _(a,e,c){Object.defineProperty(c,"__esModule",{value:!0});var l=a(292);c.CategoricalScale=l.CategoricalScale;var o=a(228);c.ContinuousScale=o.ContinuousScale;var r=a(227);c.LinearScale=r.LinearScale;var S=a(237);c.LogScale=S.LogScale;var n=a(229);c.Scale=n.Scale},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),e(1).__exportStar(e(207),o);var n=e(184);o.Selection=n.Selection},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=a(401);r.ServerSentDataSource=o.ServerSentDataSource;var S=a(403);r.AjaxDataSource=S.AjaxDataSource;var u=a(181);r.ColumnDataSource=u.ColumnDataSource;var t=a(182);r.ColumnarDataSource=t.ColumnarDataSource;var c=a(203);r.CDSView=c.CDSView;var D=a(183);r.DataSource=D.DataSource;var v=a(404);r.GeoJSONDataSource=v.GeoJSONDataSource;var n=a(402);r.WebDataSource=n.WebDataSource},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var a=e(1),n=function(e){function t(t){var i=e.call(this,t)||this;return i.initialized=!1,i}return a.__extends(t,e),t.prototype.destroy=function(){e.prototype.destroy.call(this)},t.prototype.setup=function(){var e=this;this.initialized||(this.initialized=!0,new EventSource(this.data_url).onmessage=function(t){e.load_data(JSON.parse(t.data),e.mode,e.max_size)})},t}(e(402).WebDataSource);i.ServerSentDataSource=n,n.__name__="ServerSentDataSource"},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});var r=t(1),i=t(181),n=r.__importStar(t(127)),o=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.prototype.load_data=function(t,e,a){var r,i=this.adapter;switch(r=null!=i?i.execute(this,{response:t}):t,e){case"replace":this.data=r;break;case"append":for(var n=this.data,o=0,u=this.columns();o<u.length;o++){var c=u[o],l=Array.from(n[c]),s=Array.from(r[c]);r[c]=l.concat(s).slice(-a)}this.data=r}},e.init_WebDataSource=function(){this.define({mode:[n.UpdateMode,"replace"],max_size:[n.Number],adapter:[n.Any,null],data_url:[n.String]})},e}(i.ColumnDataSource);a.WebDataSource=o,o.__name__="WebDataSource",o.init_WebDataSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var r=t(1),o=t(402),a=t(178),n=r.__importStar(t(127)),s=function(t){function e(e){var i=t.call(this,e)||this;return i.initialized=!1,i}return r.__extends(e,t),e.init_AjaxDataSource=function(){this.define({polling_interval:[n.Number],content_type:[n.String,"application/json"],http_headers:[n.Any,{}],method:[n.HTTPMethod,"POST"],if_modified:[n.Boolean,!1]})},e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)){this.interval=setInterval((function(){return t.get_data(t.mode,t.max_size,t.if_modified)}),this.polling_interval)}},e.prototype.get_data=function(t,e,i){var r=this;void 0===e&&(e=0),void 0===i&&(i=!1);var o=this.prepare_request();o.addEventListener("load",(function(){return r.do_load(o,t,e)})),o.addEventListener("error",(function(){return r.do_error(o)})),o.send()},e.prototype.prepare_request=function(){var t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);var e=this.http_headers;for(var i in e){var r=e[i];t.setRequestHeader(i,r)}return t},e.prototype.do_load=function(t,e,i){if(200===t.status){var r=JSON.parse(t.responseText);this.load_data(r,e,i)}},e.prototype.do_error=function(t){a.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e}(o.WebDataSource);i.AjaxDataSource=s,s.__name__="AjaxDataSource",s.init_AjaxDataSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var o=e(1),n=e(182),a=e(178),i=o.__importStar(e(127)),s=e(117);function l(e){return null!=e?e:NaN}var _=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_GeoJSONDataSource=function(){this.define({geojson:[i.Any]}),this.internal({data:[i.Any,{}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._update_data()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,(function(){return t._update_data()}))},t.prototype._update_data=function(){this.data=this.geojson_to_column_data()},t.prototype._get_new_list_array=function(e){return s.range(0,e).map((function(e){return[]}))},t.prototype._get_new_nan_array=function(e){return s.range(0,e).map((function(e){return NaN}))},t.prototype._add_properties=function(e,t,r,o){var n=e.properties||{};for(var a in n)t.hasOwnProperty(a)||(t[a]=this._get_new_nan_array(o)),t[a][r]=l(n[a])},t.prototype._add_geometry=function(e,t,r){function o(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":var n=e.coordinates,i=n[0],s=n[1],_=n[2];t.x[r]=i,t.y[r]=s,t.z[r]=l(_);break;case"LineString":for(var u=e.coordinates,c=0;c<u.length;c++){var g=u[c];i=g[0],s=g[1],_=g[2];t.xs[r][c]=i,t.ys[r][c]=s,t.zs[r][c]=l(_)}break;case"Polygon":e.coordinates.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");var p=e.coordinates[0];for(c=0;c<p.length;c++){var y=p[c];i=y[0],s=y[1],_=y[2];t.xs[r][c]=i,t.ys[r][c]=s,t.zs[r][c]=l(_)}break;case"MultiPoint":a.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(u=e.coordinates.reduce(o),c=0;c<u.length;c++){var h=u[c];i=h[0],s=h[1],_=h[2];t.xs[r][c]=i,t.ys[r][c]=s,t.zs[r][c]=l(_)}break;case"MultiPolygon":for(var d=[],f=0,m=e.coordinates;f<m.length;f++){var w=m[f];w.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),d.push(w[0])}for(u=d.reduce(o),c=0;c<u.length;c++){var v=u[c];i=v[0],s=v[1],_=v[2];t.xs[r][c]=i,t.ys[r][c]=s,t.zs[r][c]=l(_)}break;default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}},t.prototype.geojson_to_column_data=function(){var e,t=JSON.parse(this.geojson);switch(t.type){case"GeometryCollection":if(null==t.geometries)throw new Error("No geometries found in GeometryCollection");if(0===t.geometries.length)throw new Error("geojson.geometries must have one or more items");e=t.geometries;break;case"FeatureCollection":if(null==t.features)throw new Error("No features found in FeaturesCollection");if(0==t.features.length)throw new Error("geojson.features must have one or more items");e=t.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}for(var r=0,o=0,n=e;o<n.length;o++){"GeometryCollection"==(u="Feature"===(_=n[o]).type?_.geometry:_).type?r+=u.geometries.length:r+=1}for(var a={x:this._get_new_nan_array(r),y:this._get_new_nan_array(r),z:this._get_new_nan_array(r),xs:this._get_new_list_array(r),ys:this._get_new_list_array(r),zs:this._get_new_list_array(r)},i=0,s=0,l=e;s<l.length;s++){var _,u;if("GeometryCollection"==(u="Feature"==(_=l[s]).type?_.geometry:_).type)for(var c=0,g=u.geometries;c<g.length;c++){var p=g[c];this._add_geometry(p,a,i),"Feature"===_.type&&this._add_properties(_,a,i,r),i+=1}else this._add_geometry(u,a,i),"Feature"===_.type&&this._add_properties(_,a,i,r),i+=1}return a},t}(n.ColumnarDataSource);r.GeoJSONDataSource=_,_.__name__="GeoJSONDataSource",_.init_GeoJSONDataSource()},
function _(e,r,i){Object.defineProperty(i,"__esModule",{value:!0});var c=e(217);i.AdaptiveTicker=c.AdaptiveTicker;var a=e(216);i.BasicTicker=a.BasicTicker;var k=e(259);i.CategoricalTicker=k.CategoricalTicker;var T=e(270);i.CompositeTicker=T.CompositeTicker;var t=e(218);i.ContinuousTicker=t.ContinuousTicker;var o=e(269);i.DatetimeTicker=o.DatetimeTicker;var v=e(271);i.DaysTicker=v.DaysTicker;var n=e(406);i.FixedTicker=n.FixedTicker;var s=e(278);i.LogTicker=s.LogTicker;var l=e(281);i.MercatorTicker=l.MercatorTicker;var u=e(274);i.MonthsTicker=u.MonthsTicker;var d=e(272);i.SingleIntervalTicker=d.SingleIntervalTicker;var g=e(219);i.Ticker=g.Ticker;var C=e(275);i.YearsTicker=C.YearsTicker},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=i(1),r=i(218),_=n.__importStar(i(127)),o=function(i){function t(t){var e=i.call(this,t)||this;return e.min_interval=0,e.max_interval=0,e}return n.__extends(t,i),t.init_FixedTicker=function(){this.define({ticks:[_.Array,[]],minor_ticks:[_.Array,[]]})},t.prototype.get_ticks_no_defaults=function(i,t,e,n){return{major:this.ticks,minor:this.minor_ticks}},t.prototype.get_interval=function(i,t,e){return 0},t}(r.ContinuousTicker);e.FixedTicker=o,o.__name__="FixedTicker",o.init_FixedTicker()},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var T=e(408);o.BBoxTileSource=T.BBoxTileSource;var c=e(409);o.MercatorTileSource=c.MercatorTileSource;var i=e(412);o.QUADKEYTileSource=i.QUADKEYTileSource;var l=e(413);o.TileRenderer=l.TileRenderer;var S=e(410);o.TileSource=S.TileSource;var u=e(416);o.TMSTileSource=u.TMSTileSource;var a=e(414);o.WMTSTileSource=a.WMTSTileSource},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),o=e(409),n=i.__importStar(e(127)),_=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_BBoxTileSource=function(){this.define({use_latlon:[n.Boolean,!1]})},t.prototype.get_image_url=function(e,t,r){var i,o,n,_,l,u,a=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(_=(i=this.get_tile_geographic_bounds(e,t,r))[0],u=i[1],n=i[2],l=i[3]):(_=(o=this.get_tile_meter_bounds(e,t,r))[0],u=o[1],n=o[2],l=o[3]),a.replace("{XMIN}",_.toString()).replace("{YMIN}",u.toString()).replace("{XMAX}",n.toString()).replace("{YMAX}",l.toString())},t}(o.MercatorTileSource);r.BBoxTileSource=_,_.__name__="BBoxTileSource",_.init_BBoxTileSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1),r=t(410),_=o.__importStar(t(127)),n=t(117),s=t(411),u=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_MercatorTileSource=function(){this.define({snap_to_zoom:[_.Boolean,!1],wrap_around:[_.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=n.range(this.min_zoom,this.max_zoom+1).map((function(t){return e.get_resolution(t)}))},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,i){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,i)))&&!(e<0||e>=Math.pow(2,i))},e.prototype.parent_by_tile_xyz=function(t,e,i){var o=this.tile_xyz_to_quadkey(t,e,i),r=o.substring(0,o.length-1);return this.quadkey_to_tile_xyz(r)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]},e.prototype.get_level_by_extent=function(t,e,i){for(var o=(t[2]-t[0])/i,r=(t[3]-t[1])/e,_=Math.max(o,r),n=0,s=0,u=this._resolutions;s<u.length;s++){if(_>u[s]){if(0==n)return 0;if(n>0)return n-1}n+=1}return n-1},e.prototype.get_closest_level_by_extent=function(t,e,i){var o=(t[2]-t[0])/i,r=(t[3]-t[1])/e,_=Math.max(o,r),n=this._resolutions.reduce((function(t,e){return Math.abs(e-_)<Math.abs(t-_)?e:t}));return this._resolutions.indexOf(n)},e.prototype.snap_to_zoom_level=function(t,e,i,o){var r=t[0],_=t[1],n=t[2],s=t[3],u=this._resolutions[o],a=i*u,l=e*u;if(!this.snap_to_zoom){var p=(n-r)/a,h=(s-_)/l;p>h?(a=n-r,l*=p):(a*=h,l=s-_)}var y=(a-(n-r))/2,c=(l-(s-_))/2;return[r-y,_-c,n+y,s+c]},e.prototype.tms_to_wmts=function(t,e,i){return[t,Math.pow(2,i)-1-e,i]},e.prototype.wmts_to_tms=function(t,e,i){return[t,Math.pow(2,i)-1-e,i]},e.prototype.pixels_to_meters=function(t,e,i){var o=this.get_resolution(i);return[t*o-this.x_origin_offset,e*o-this.y_origin_offset]},e.prototype.meters_to_pixels=function(t,e,i){var o=this.get_resolution(i);return[(t+this.x_origin_offset)/o,(e+this.y_origin_offset)/o]},e.prototype.pixels_to_tile=function(t,e){var i=Math.ceil(t/this.tile_size);return[i=0===i?i:i-1,Math.max(Math.ceil(e/this.tile_size)-1,0)]},e.prototype.pixels_to_raster=function(t,e,i){return[t,(this.tile_size<<i)-e]},e.prototype.meters_to_tile=function(t,e,i){var o=this.meters_to_pixels(t,e,i),r=o[0],_=o[1];return this.pixels_to_tile(r,_)},e.prototype.get_tile_meter_bounds=function(t,e,i){var o=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),r=o[0],_=o[1],n=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[r,_,n[0],n[1]]},e.prototype.get_tile_geographic_bounds=function(t,e,i){var o=this.get_tile_meter_bounds(t,e,i),r=s.meters_extent_to_geographic(o);return[r[0],r[1],r[2],r[3]]},e.prototype.get_tiles_by_extent=function(t,e,i){void 0===i&&(i=1);var o=t[0],r=t[1],_=t[2],n=t[3],s=this.meters_to_tile(o,r,e),u=s[0],a=s[1],l=this.meters_to_tile(_,n,e),p=l[0],h=l[1];u-=i,a-=i,p+=i;for(var y=[],c=h+=i;c>=a;c--)for(var f=u;f<=p;f++)this.is_valid_tile(f,c,e)&&y.push([f,c,e,this.get_tile_meter_bounds(f,c,e)]);return this.sort_tiles_from_center(y,[u,a,p,h]),y},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,i=0,o=t.length,r=o;r>0;r--){var _=1<<r-1;switch(t.charAt(o-r)){case"0":continue;case"1":e|=_;break;case"2":i|=_;break;case"3":e|=_,i|=_;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,o]},e.prototype.tile_xyz_to_quadkey=function(t,e,i){for(var o="",r=i;r>0;r--){var _=1<<r-1,n=0;0!=(t&_)&&(n+=1),0!=(e&_)&&(n+=2),o+=n.toString()}return o},e.prototype.children_by_tile_xyz=function(t,e,i){for(var o=this.tile_xyz_to_quadkey(t,e,i),r=[],_=0;_<=3;_++){var n=this.quadkey_to_tile_xyz(o+_.toString()),s=n[0],u=n[1],a=n[2],l=this.get_tile_meter_bounds(s,u,a);r.push([s,u,a,l])}return r},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,i){var o,r,_,n=this.calculate_world_x_by_tile_xyz(t,e,i);t=(o=this.normalize_xyz(t,e,i))[0],e=o[1],i=o[2];for(var s=this.tile_xyz_to_quadkey(t,e,i);s.length>0;)if(s=s.substring(0,s.length-1),t=(r=this.quadkey_to_tile_xyz(s))[0],e=r[1],i=r[2],t=(_=this.denormalize_xyz(t,e,i,n))[0],e=_[1],i=_[2],this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,i){if(this.wrap_around){var o=Math.pow(2,i);return[(t%o+o)%o,e,i]}return[t,e,i]},e.prototype.denormalize_xyz=function(t,e,i,o){return[t+o*Math.pow(2,i),e,i]},e.prototype.denormalize_meters=function(t,e,i,o){return[t+2*o*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,i){return Math.floor(t/Math.pow(2,i))},e}(r.TileSource);i.MercatorTileSource=u,u.__name__="MercatorTileSource",u.init_MercatorTileSource()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});var i=t(1),n=t(177),o=i.__importStar(t(127)),a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.init_TileSource=function(){this.define({url:[o.String,""],tile_size:[o.Number,256],max_zoom:[o.Number,30],min_zoom:[o.Number,0],extra_url_vars:[o.Any,{}],attribution:[o.String,""],x_origin_offset:[o.Number],y_origin_offset:[o.Number],initial_resolution:[o.Number]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.tiles=new Map,this._normalize_case()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return e._clear_cache()}))},e.prototype.string_lookup_replace=function(t,e){var r=t;for(var i in e){var n=e[i];r=r.replace("{"+i+"}",n)}return r},e.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},e.prototype._clear_cache=function(){this.tiles=new Map},e.prototype.tile_xyz_to_key=function(t,e,r){return t+":"+e+":"+r},e.prototype.key_to_tile_xyz=function(t){var e=t.split(":").map((function(t){return parseInt(t)}));return[e[0],e[1],e[2]]},e.prototype.sort_tiles_from_center=function(t,e){var r=e[0],i=e[1],n=e[2],o=e[3],a=(n-r)/2+r,c=(o-i)/2+i;t.sort((function(t,e){return Math.sqrt(Math.pow(a-t[0],2)+Math.pow(c-t[1],2))-Math.sqrt(Math.pow(a-e[0],2)+Math.pow(c-e[1],2))}))},e.prototype.get_image_url=function(t,e,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",r.toString())},e}(n.Model);r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(138);function o(e,r){return n.wgs84_mercator.forward([e,r])}function _(e,r){return n.wgs84_mercator.inverse([e,r])}t.geographic_to_meters=o,t.meters_to_geographic=_,t.geographic_extent_to_meters=function(e){var r=e[0],t=e[1],n=e[2],_=e[3],c=o(r,t),a=c[0],i=c[1],u=o(n,_);return[a,i,u[0],u[1]]},t.meters_extent_to_geographic=function(e){var r=e[0],t=e[1],n=e[2],o=e[3],c=_(r,t),a=c[0],i=c[1],u=_(n,o);return[a,i,u[0],u[1]]}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var _=e(1),i=function(e){function t(t){return e.call(this,t)||this}return _.__extends(t,e),t.prototype.get_image_url=function(e,t,r){var _=this.string_lookup_replace(this.url,this.extra_url_vars),i=this.tms_to_wmts(e,t,r),u=i[0],o=i[1],n=i[2],l=this.tile_xyz_to_quadkey(u,o,n);return _.replace("{Q}",l)},t}(e(409).MercatorTileSource);r.QUADKEYTileSource=i,i.__name__="QUADKEYTileSource"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),r=e(414),a=e(187),_=e(238),s=e(174),o=n.__importStar(e(127)),l=e(331),h=e(117),u=e(116),d=e(185),p=e(181),c=e(415),m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(){this._tiles=[],e.prototype.initialize.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.tile_source.change,(function(){return t.request_render()}))},t.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(t.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_canvas",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!0,configurable:!0}),t.prototype._set_data=function(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},t.prototype._update_attribution=function(){null!=this.attribution_el&&s.removeElement(this.attribution_el);var e=this.model.tile_source.attribution;if(u.isString(e)&&e.length>0){var t=this.plot_view,i=t.layout,n=t.frame,r=i._width.value-n._right.value,a=i._height.value-n._bottom.value,_=n._width.value;this.attribution_el=s.div({class:c.bk_tile_attribution,style:{position:"absolute",right:r+"px",bottom:a+"px","max-width":_-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"7pt","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},t.prototype._map_data=function(){this.initial_extent=this.get_extent();var e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof _.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof _.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()},t.prototype._create_tile=function(e,t,i,n,r){var a=this;void 0===r&&(r=!1);var _=this.model.tile_source.normalize_xyz(e,t,i),s=_[0],o=_[1],h=_[2],u={img:void 0,tile_coords:[e,t,i],normalized_coords:[s,o,h],quadkey:this.model.tile_source.tile_xyz_to_quadkey(e,t,i),cache_key:this.model.tile_source.tile_xyz_to_key(e,t,i),bounds:n,loaded:!1,finished:!1,x_coord:n[0],y_coord:n[3]},d=this.model.tile_source.get_image_url(s,o,h);new l.ImageLoader(d,{loaded:function(e){Object.assign(u,{img:e,loaded:!0}),r?(u.finished=!0,a.notify_finished()):a.request_render()},failed:function(){u.finished=!0}}),this.model.tile_source.tiles.set(u.cache_key,u),this._tiles.push(u)},t.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){var e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame._height.value,this.map_frame._width.value),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}},t.prototype.has_finished=function(){if(!e.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;for(var t=0,i=this._tiles;t<i.length;t++){if(!i[t].finished)return!1}return!0},t.prototype.render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},t.prototype._draw_tile=function(e){var t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){var i=this.plot_view.map_to_screen([t.bounds[0]],[t.bounds[3]]),n=i[0][0],r=i[1][0],a=this.plot_view.map_to_screen([t.bounds[2]],[t.bounds[1]]),_=a[0][0]-n,s=a[1][0]-r,o=n,l=r,h=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,o,l,_,s),this.map_canvas.setImageSmoothingEnabled(h),t.finished=!0}},t.prototype._set_rect=function(){var e=this.plot_model.properties.outline_line_width.value(),t=this.map_frame._left.value+e/2,i=this.map_frame._top.value+e/2,n=this.map_frame._width.value-e,r=this.map_frame._height.value-e;this.map_canvas.rect(t,i,n,r),this.map_canvas.clip()},t.prototype._render_tiles=function(e){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(var t=0,i=e;t<i.length;t++){var n=i[t];this._draw_tile(n)}this.map_canvas.restore()},t.prototype._prefetch_tiles=function(){for(var e=this.model.tile_source,t=this.get_extent(),i=this.map_frame._height.value,n=this.map_frame._width.value,r=this.model.tile_source.get_level_by_extent(t,i,n),a=this.model.tile_source.get_tiles_by_extent(t,r),_=0,s=Math.min(10,a.length);_<s;_++)for(var o=a[_],l=o[0],h=o[1],u=o[2],d=0,p=this.model.tile_source.children_by_tile_xyz(l,h,u);d<p.length;d++){var c=p[d],m=c[0],f=c[1],g=c[2],v=c[3];e.tiles.has(e.tile_xyz_to_key(m,f,g))||this._create_tile(m,f,g,v,!0)}},t.prototype._fetch_tiles=function(e){for(var t=0,i=e;t<i.length;t++){var n=i[t],r=n[0],a=n[1],_=n[2],s=n[3];this._create_tile(r,a,_,s)}},t.prototype._update=function(){var e=this,t=this.model.tile_source,i=t.min_zoom,n=t.max_zoom,r=this.get_extent(),a=this.extent[2]-this.extent[0]<r[2]-r[0],_=this.map_frame._height.value,s=this.map_frame._width.value,o=t.get_level_by_extent(r,_,s),l=!1;o<i?(r=this.extent,o=i,l=!0):o>n&&(r=this.extent,o=n,l=!0),l&&(this.x_range.setv({x_range:{start:r[0],end:r[2]}}),this.y_range.setv({start:r[1],end:r[3]})),this.extent=r;for(var u=t.get_tiles_by_extent(r,o),d=[],p=[],c=[],m=[],f=0,g=u;f<g.length;f++){var v=g[f],y=v[0],x=v[1],b=v[2],w=t.tile_xyz_to_key(y,x,b),z=t.tiles.get(w);if(null!=z&&z.loaded)p.push(w);else if(this.model.render_parents){var T=t.get_closest_parent_by_tile_xyz(y,x,b),k=T[0],R=T[1],S=T[2],j=t.tile_xyz_to_key(k,R,S),O=t.tiles.get(j);if(null!=O&&O.loaded&&!h.includes(c,j)&&c.push(j),a)for(var I=0,P=t.children_by_tile_xyz(y,x,b);I<P.length;I++){var q=P[I],M=q[0],E=q[1],D=q[2],V=t.tile_xyz_to_key(M,E,D);t.tiles.has(V)&&m.push(V)}}null==z&&d.push(v)}this._render_tiles(c),this._render_tiles(m),this._render_tiles(p),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((function(){return e._fetch_tiles(d)}),65)},t}(a.DataRendererView);i.TileRendererView=m,m.__name__="TileRendererView";var f=function(e){function t(t){var i=e.call(this,t)||this;return i._selection_manager=new d.SelectionManager({source:new p.ColumnDataSource}),i}return n.__extends(t,e),t.init_TileRenderer=function(){this.prototype.default_view=m,this.define({alpha:[o.Number,1],smoothing:[o.Boolean,!0],tile_source:[o.Instance,function(){return new r.WMTSTileSource}],render_parents:[o.Boolean,!0]})},t.prototype.get_selection_manager=function(){return this._selection_manager},t}(a.DataRenderer);i.TileRenderer=f,f.__name__="TileRenderer",f.init_TileRenderer()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),n=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.prototype.get_image_url=function(e,t,r){var i=this.string_lookup_replace(this.url,this.extra_url_vars),n=this.tms_to_wmts(e,t,r),o=n[0],_=n[1],u=n[2];return i.replace("{X}",o.toString()).replace("{Y}",_.toString()).replace("{Z}",u.toString())},t}(e(409).MercatorTileSource);r.WMTSTileSource=n,n.__name__="WMTSTileSource"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var o=t(1);t(175),o.__importStar(t(174)).styles.append(".bk-root .bk-tile-attribution a {\n  color: black;\n}\n"),i.bk_tile_attribution="bk-tile-attribution"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),n=function(e){function r(r){return e.call(this,r)||this}return i.__extends(r,e),r.prototype.get_image_url=function(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())},r}(e(409).MercatorTileSource);t.TMSTileSource=n,n.__name__="TMSTileSource"},
function _(e,r,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(418);a.CanvasTexture=t.CanvasTexture;var u=e(420);a.ImageURLTexture=u.ImageURLTexture;var v=e(419);a.Texture=v.Texture},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var r=e(1),i=e(419),a=r.__importStar(e(127)),u=e(133),c=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_CanvasTexture=function(){this.define({code:[a.String]})},Object.defineProperty(t.prototype,"func",{get:function(){var e=u.use_strict(this.code);return new Function("ctx","color","scale","weight",e)},enumerable:!0,configurable:!0}),t.prototype.get_pattern=function(e,t,n){var r=this;return function(i){var a=document.createElement("canvas");a.width=t,a.height=t;var u=a.getContext("2d");return r.func.call(r,u,e,t,n),i.createPattern(a,r.repetition)}},t}(i.Texture);n.CanvasTexture=c,c.__name__="CanvasTexture",c.init_CanvasTexture()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(177),o=i.__importStar(e(127)),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_Texture=function(){this.define({repetition:[o.TextureRepetition,"repeat"]})},t.prototype.onload=function(e){e()},t}(r.Model);n.Texture=u,u.__name__="Texture",u.init_Texture()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),r=e(419),o=i.__importStar(e(127)),a=e(331),u=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_ImageURLTexture=function(){this.define({url:[o.String]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._loader=new a.ImageLoader(this.url)},t.prototype.get_pattern=function(e,t,n){var i=this;return function(e){return i._loader.finished?e.createPattern(i._loader.image,i.repetition):null}},t.prototype.onload=function(e){this._loader.promise.then((function(){return e()}))},t}(r.Texture);n.ImageURLTexture=u,u.__name__="ImageURLTexture",u.init_ImageURLTexture()},
function _(o,l,T){Object.defineProperty(T,"__esModule",{value:!0});var a=o(384);T.ActionTool=a.ActionTool;var r=o(422);T.CustomAction=r.CustomAction;var e=o(385);T.HelpTool=e.HelpTool;var v=o(423);T.RedoTool=v.RedoTool;var t=o(424);T.ResetTool=t.ResetTool;var n=o(425);T.SaveTool=n.SaveTool;var s=o(426);T.UndoTool=s.UndoTool;var P=o(427);T.ZoomInTool=P.ZoomInTool;var c=o(429);T.ZoomOutTool=c.ZoomOutTool;var i=o(378);T.ButtonTool=i.ButtonTool;var d=o(430);T.EditTool=d.EditTool;var u=o(431);T.BoxEditTool=u.BoxEditTool;var y=o(432);T.FreehandDrawTool=y.FreehandDrawTool;var m=o(433);T.PointDrawTool=m.PointDrawTool;var x=o(434);T.PolyDrawTool=x.PolyDrawTool;var B=o(435);T.PolyTool=B.PolyTool;var S=o(436);T.PolyEditTool=S.PolyEditTool;var b=o(437);T.BoxSelectTool=b.BoxSelectTool;var h=o(440);T.BoxZoomTool=h.BoxZoomTool;var Z=o(383);T.GestureTool=Z.GestureTool;var p=o(441);T.LassoSelectTool=p.LassoSelectTool;var w=o(442);T.PanTool=w.PanTool;var C=o(443);T.PolySelectTool=C.PolySelectTool;var D=o(444);T.RangeTool=D.RangeTool;var E=o(438);T.SelectTool=E.SelectTool;var H=o(445);T.TapTool=H.TapTool;var R=o(446);T.WheelPanTool=R.WheelPanTool;var A=o(447);T.WheelZoomTool=A.WheelZoomTool;var I=o(448);T.CrosshairTool=I.CrosshairTool;var W=o(449);T.CustomJSHover=W.CustomJSHover;var O=o(450);T.HoverTool=O.HoverTool;var _=o(377);T.InspectTool=_.InspectTool;var f=o(379);T.Tool=f.Tool;var g=o(451);T.ToolProxy=g.ToolProxy;var F=o(376);T.Toolbar=F.Toolbar;var G=o(382);T.ToolbarBase=G.ToolbarBase;var J=o(452);T.ProxyToolbar=J.ProxyToolbar;var L=o(452);T.ToolbarBox=L.ToolbarBox},
function _(t,o,n){Object.defineProperty(n,"__esModule",{value:!0});var i=t(1),e=t(384),c=i.__importStar(t(127)),u=t(380),r=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(u.bk_toolbar_button_custom_action)},o}(e.ActionToolButtonView);n.CustomActionButtonView=r,r.__name__="CustomActionButtonView";var s=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.doit=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},o}(e.ActionToolView);n.CustomActionView=s,s.__name__="CustomActionView";var l=function(t){function o(o){var n=t.call(this,o)||this;return n.tool_name="Custom Action",n.button_view=r,n}return i.__extends(o,t),o.init_CustomAction=function(){this.prototype.default_view=s,this.define({action_tooltip:[c.String,"Perform a Custom Action"],callback:[c.Any],icon:[c.String]})},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!0,configurable:!0}),o}(e.ActionTool);n.CustomAction=l,l.__name__="CustomAction",l.init_CustomAction()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});var n=o(1),i=o(384),r=o(386),_=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return n.__extends(t,o),t.prototype.connect_signals=function(){var t=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return t.model.disabled=!t.plot_view.can_redo()}))},t.prototype.doit=function(){this.plot_view.redo()},t}(i.ActionToolView);e.RedoToolView=_,_.__name__="RedoToolView";var l=function(o){function t(t){var e=o.call(this,t)||this;return e.tool_name="Redo",e.icon=r.bk_tool_icon_redo,e}return n.__extends(t,o),t.init_RedoTool=function(){this.prototype.default_view=_,this.override({disabled:!0}),this.register_alias("redo",(function(){return new t}))},t}(i.ActionTool);e.RedoTool=l,l.__name__="RedoTool",l.init_RedoTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),i=e(384),_=e(386),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.doit=function(){this.plot_view.reset()},t}(i.ActionToolView);o.ResetToolView=r,r.__name__="ResetToolView";var s=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Reset",o.icon=_.bk_tool_icon_reset,o}return n.__extends(t,e),t.init_ResetTool=function(){this.prototype.default_view=r,this.register_alias("reset",(function(){return new t}))},t}(i.ActionTool);o.ResetTool=s,s.__name__="ResetTool",s.init_ResetTool()},
function _(o,e,t){Object.defineProperty(t,"__esModule",{value:!0});var n=o(1),i=o(384),_=o(386),a=function(o){function e(){return null!==o&&o.apply(this,arguments)||this}return n.__extends(e,o),e.prototype.doit=function(){this.plot_view.save("bokeh_plot")},e}(i.ActionToolView);t.SaveToolView=a,a.__name__="SaveToolView";var l=function(o){function e(e){var t=o.call(this,e)||this;return t.tool_name="Save",t.icon=_.bk_tool_icon_save,t}return n.__extends(e,o),e.init_SaveTool=function(){this.prototype.default_view=a,this.register_alias("save",(function(){return new e}))},e}(i.ActionTool);t.SaveTool=l,l.__name__="SaveTool",l.init_SaveTool()},
function _(o,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=o(1),e=o(384),_=o(386),l=function(o){function n(){return null!==o&&o.apply(this,arguments)||this}return i.__extends(n,o),n.prototype.connect_signals=function(){var n=this;o.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,(function(){return n.model.disabled=!n.plot_view.can_undo()}))},n.prototype.doit=function(){this.plot_view.undo()},n}(e.ActionToolView);t.UndoToolView=l,l.__name__="UndoToolView";var r=function(o){function n(n){var t=o.call(this,n)||this;return t.tool_name="Undo",t.icon=_.bk_tool_icon_undo,t}return i.__extends(n,o),n.init_UndoTool=function(){this.prototype.default_view=l,this.override({disabled:!0}),this.register_alias("undo",(function(){return new n}))},n}(e.ActionTool);t.UndoTool=r,r.__name__="UndoTool",r.init_UndoTool()},
function _(o,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=o(1),e=o(384),s=o(428),r=n.__importStar(o(127)),_=o(386),l=function(o){function t(){return null!==o&&o.apply(this,arguments)||this}return n.__extends(t,o),t.prototype.doit=function(){var o=this.plot_view.frame,t=this.model.dimensions,i="width"==t||"both"==t,n="height"==t||"both"==t,e=s.scale_range(o,this.model.factor,i,n);this.plot_view.push_state("zoom_out",{range:e}),this.plot_view.update_range(e,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(e.ActionToolView);i.ZoomInToolView=l,l.__name__="ZoomInToolView";var m=function(o){function t(t){var i=o.call(this,t)||this;return i.tool_name="Zoom In",i.icon=_.bk_tool_icon_zoom_in,i}return n.__extends(t,o),t.init_ZoomInTool=function(){this.prototype.default_view=l,this.define({factor:[r.Percent,.1],dimensions:[r.Dimensions,"both"]}),this.register_alias("zoom_in",(function(){return new t({dimensions:"both"})})),this.register_alias("xzoom_in",(function(){return new t({dimensions:"width"})})),this.register_alias("yzoom_in",(function(){return new t({dimensions:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(e.ActionTool);i.ZoomInTool=m,m.__name__="ZoomInTool",m.init_ZoomInTool()},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});var a=r(118);function o(r,n,e){var a=[r.start,r.end],o=a[0],t=a[1],l=null!=e?e:(t+o)/2;return[o-(o-l)*n,t-(t-l)*n]}function t(r,n){var e=n[0],a=n[1],o={};for(var t in r){var l=r[t].r_invert(e,a),i=l[0],v=l[1];o[t]={start:i,end:v}}return o}e.scale_highlow=o,e.get_info=t,e.scale_range=function(r,n,e,l,i){void 0===e&&(e=!0),void 0===l&&(l=!0),n=a.clamp(n,-.9,.9);var v=e?n:0,u=o(r.bbox.h_range,v,null!=i?i.x:void 0),c=u[0],s=u[1],_=t(r.xscales,[c,s]),d=l?n:0,f=o(r.bbox.v_range,d,null!=i?i.y:void 0),b=f[0],g=f[1];return{xrs:_,yrs:t(r.yscales,[b,g]),factor:n}}},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),n=t(384),s=t(428),r=i.__importStar(t(127)),_=t(386),u=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(o,t),o.prototype.doit=function(){var t=this.plot_view.frame,o=this.model.dimensions,e="width"==o||"both"==o,i="height"==o||"both"==o,n=s.scale_range(t,-this.model.factor,e,i);this.plot_view.push_state("zoom_out",{range:n}),this.plot_view.update_range(n,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)},o}(n.ActionToolView);e.ZoomOutToolView=u,u.__name__="ZoomOutToolView";var l=function(t){function o(o){var e=t.call(this,o)||this;return e.tool_name="Zoom Out",e.icon=_.bk_tool_icon_zoom_out,e}return i.__extends(o,t),o.init_ZoomOutTool=function(){this.prototype.default_view=u,this.define({factor:[r.Percent,.1],dimensions:[r.Dimensions,"both"]}),this.register_alias("zoom_out",(function(){return new o({dimensions:"both"})})),this.register_alias("xzoom_out",(function(){return new o({dimensions:"width"})})),this.register_alias("yzoom_out",(function(){return new o({dimensions:"height"})}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),o}(n.ActionTool);e.ZoomOutTool=l,l.__name__="ZoomOutTool",l.init_ZoomOutTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1),r=n.__importStar(e(127)),i=e(117),a=e(116),s=e(383),_=function(e){function t(){var t=e.apply(this,arguments)||this;return t._mouse_in_frame=!0,t}return n.__extends(t,e),t.prototype._move_enter=function(e){this._mouse_in_frame=!0},t.prototype._move_exit=function(e){this._mouse_in_frame=!1},t.prototype._map_drag=function(e,t,o){var n=this.plot_view.frame;return n.bbox.contains(e,t)?[n.xscales[o.x_range_name].invert(e),n.yscales[o.y_range_name].invert(t)]:null},t.prototype._delete_selected=function(e){var t=e.data_source,o=t.selected.indices;o.sort();for(var n=0,r=t.columns();n<r.length;n++)for(var i=r[n],a=t.get_array(i),s=0;s<o.length;s++){var _=o[s];a.splice(_-s,1)}this._emit_cds_changes(t)},t.prototype._pop_glyphs=function(e,t){var o=e.columns();if(t&&o.length)for(var n=0,r=o;n<r.length;n++){var i=r[n],s=e.get_array(i),_=s.length-t+1;_<1||(a.isArray(s)||(s=Array.from(s),e.data[i]=s),s.splice(0,_))}},t.prototype._emit_cds_changes=function(e,t,o,n){void 0===t&&(t=!0),void 0===o&&(o=!0),void 0===n&&(n=!0),o&&e.selection_manager.clear(),t&&e.change.emit(),n&&(e.data=e.data,e.properties.data.change.emit())},t.prototype._drag_points=function(e,t){if(null!=this._basepoint){for(var o=this._basepoint,n=o[0],r=o[1],i=0,a=t;i<a.length;i++){var s=a[i],_=this._map_drag(n,r,s),l=this._map_drag(e.sx,e.sy,s);if(null!=l&&null!=_){for(var c=l[0],p=l[1],u=[c-_[0],p-_[1]],d=u[0],m=u[1],f=s.glyph,h=s.data_source,g=[f.x.field,f.y.field],v=g[0],y=g[1],b=0,x=h.selected.indices;b<x.length;b++){var T=x[b];v&&(h.data[v][T]+=d),y&&(h.data[y][T]+=m)}h.change.emit()}}this._basepoint=[e.sx,e.sy]}},t.prototype._pad_empty_columns=function(e,t){for(var o=0,n=e.columns();o<n.length;o++){var r=n[o];i.includes(t,r)||e.get_array(r).push(this.model.empty_value)}},t.prototype._select_event=function(e,t,o){var n=this.plot_view.frame,r=e.sx,i=e.sy;if(!n.bbox.contains(r,i))return[];for(var a={type:"point",sx:r,sy:i},s=[],_=0,l=o;_<l.length;_++){var c=l[_],p=c.get_selection_manager(),u=c.data_source,d=[this.plot_view.renderer_views[c.id]];p.select(d,a,!0,t)&&s.push(c),u.properties.selected.change.emit()}return s},t}(s.GestureToolView);o.EditToolView=_,_.__name__="EditToolView";var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_EditTool=function(){this.define({custom_icon:[r.String],custom_tooltip:[r.String],empty_value:[r.Any],renderers:[r.Array,[]]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.custom_tooltip||this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.custom_icon||this.icon},enumerable:!0,configurable:!0}),t}(s.GestureTool);o.EditTool=l,l.__name__="EditTool",l.init_EditTool()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=t(1),o=t(174),_=s.__importStar(t(127)),n=t(430),a=t(386),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(e,t),e.prototype._tap=function(t){if(null==this._draw_basepoint&&null==this._basepoint){var e=t.shiftKey;this._select_event(t,e,this.model.renderers)}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var s=i[e];if(t.keyCode===o.Keys.Backspace)this._delete_selected(s);else if(t.keyCode==o.Keys.Esc){s.data_source.selection_manager.clear()}}},e.prototype._set_extent=function(t,e,i,s){var o=t[0],_=t[1],n=e[0],a=e[1];void 0===s&&(s=!1);var r=this.model.renderers[0],d=this.plot_view.frame,l=r.glyph,h=r.data_source,p=d.xscales[r.x_range_name],u=d.yscales[r.y_range_name],f=p.r_invert(o,_),c=f[0],m=f[1],y=u.r_invert(n,a),v=y[0],b=y[1],x=[(c+m)/2,(v+b)/2],g=x[0],w=x[1],E=[m-c,b-v],T=E[0],B=E[1],K=[l.x.field,l.y.field],k=K[0],j=K[1],V=[l.width.field,l.height.field],C=V[0],D=V[1];if(i)this._pop_glyphs(h,this.model.num_objects),k&&h.get_array(k).push(g),j&&h.get_array(j).push(w),C&&h.get_array(C).push(T),D&&h.get_array(D).push(B),this._pad_empty_columns(h,[k,j,C,D]);else{var I=h.data[k].length-1;k&&(h.data[k][I]=g),j&&(h.data[j][I]=w),C&&(h.data[C][I]=T),D&&(h.data[D][I]=B)}this._emit_cds_changes(h,!0,!1,s)},e.prototype._update_box=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var s=[t.sx,t.sy],o=this.plot_view.frame,_=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,s,o,_);if(null!=n){var a=n[0],r=n[1];this._set_extent(a,r,e,i)}}},e.prototype._doubletap=function(t){this.model.active&&(null!=this._draw_basepoint?(this._update_box(t,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[t.sx,t.sy],this._select_event(t,!0,this.model.renderers),this._update_box(t,!0,!1)))},e.prototype._move=function(t){this._update_box(t,!1,!1)},e.prototype._pan_start=function(t){if(t.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[t.sx,t.sy],this._update_box(t,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy]}},e.prototype._pan=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),t.shiftKey){if(null==this._draw_basepoint)return;this._update_box(t,e,i)}else{if(null==this._basepoint)return;this._drag_points(t,this.model.renderers)}},e.prototype._pan_end=function(t){if(this._pan(t,!1,!0),t.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(var e=0,i=this.model.renderers;e<i.length;e++){var s=i[e];this._emit_cds_changes(s.data_source,!1,!0,!0)}}},e}(n.EditToolView);i.BoxEditToolView=r,r.__name__="BoxEditToolView";var d=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Box Edit Tool",i.icon=a.bk_tool_icon_box_edit,i.event_type=["tap","pan","move"],i.default_order=1,i}return s.__extends(e,t),e.init_BoxEditTool=function(){this.prototype.default_view=r,this.define({dimensions:[_.Dimensions,"both"],num_objects:[_.Int,0]})},e}(n.EditTool);i.BoxEditTool=d,d.__name__="BoxEditTool",d.init_BoxEditTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var a=e(1),o=e(174),n=a.__importStar(e(127)),i=e(116),_=e(430),s=e(386),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t.prototype._draw=function(e,t,r){if(void 0===r&&(r=!1),this.model.active){var a=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,a);if(null!=o){var n=o[0],_=o[1],s=a.data_source,d=a.glyph,l=[d.xs.field,d.ys.field],h=l[0],p=l[1];if("new"==t)this._pop_glyphs(s,this.model.num_objects),h&&s.get_array(h).push([n]),p&&s.get_array(p).push([_]),this._pad_empty_columns(s,[h,p]);else if("add"==t){if(h){var u=s.data[h].length-1,c=s.get_array(h)[u];i.isArray(c)||(c=Array.from(c),s.data[h][u]=c),c.push(n)}if(p){var f=s.data[p].length-1,y=s.get_array(p)[f];i.isArray(y)||(y=Array.from(y),s.data[p][f]=y),y.push(_)}}this._emit_cds_changes(s,!0,!0,r)}}},t.prototype._pan_start=function(e){this._draw(e,"new")},t.prototype._pan=function(e){this._draw(e,"add")},t.prototype._pan_end=function(e){this._draw(e,"add",!0)},t.prototype._tap=function(e){this._select_event(e,e.shiftKey,this.model.renderers)},t.prototype._keyup=function(e){if(this.model.active&&this._mouse_in_frame)for(var t=0,r=this.model.renderers;t<r.length;t++){var a=r[t];e.keyCode===o.Keys.Esc?a.data_source.selection_manager.clear():e.keyCode===o.Keys.Backspace&&this._delete_selected(a)}},t}(_.EditToolView);r.FreehandDrawToolView=d,d.__name__="FreehandDrawToolView";var l=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Freehand Draw Tool",r.icon=s.bk_tool_icon_freehand_draw,r.event_type=["pan","tap"],r.default_order=3,r}return a.__extends(t,e),t.init_FreehandDrawTool=function(){this.prototype.default_view=d,this.define({num_objects:[n.Int,0]})},t}(_.EditTool);r.FreehandDrawTool=l,l.__name__="FreehandDrawTool",l.init_FreehandDrawTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var i=e(1),n=e(174),r=i.__importStar(e(127)),a=e(430),s=e(386),_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._tap=function(e){var t=e.shiftKey;if(!this._select_event(e,t,this.model.renderers).length&&this.model.add){var o=this.model.renderers[0],i=this._map_drag(e.sx,e.sy,o);if(null!=i){var n=o.glyph,r=o.data_source,a=[n.x.field,n.y.field],s=a[0],_=a[1],d=i[0],l=i[1];this._pop_glyphs(r,this.model.num_objects),s&&r.get_array(s).push(d),_&&r.get_array(_).push(l),this._pad_empty_columns(r,[s,_]),r.change.emit(),r.data=r.data,r.properties.data.change.emit()}}},t.prototype._keyup=function(e){if(this.model.active&&this._mouse_in_frame)for(var t=0,o=this.model.renderers;t<o.length;t++){var i=o[t];e.keyCode===n.Keys.Backspace?this._delete_selected(i):e.keyCode==n.Keys.Esc&&i.data_source.selection_manager.clear()}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,!0,this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)},t.prototype._pan_end=function(e){if(this.model.drag){this._pan(e);for(var t=0,o=this.model.renderers;t<o.length;t++){var i=o[t];this._emit_cds_changes(i.data_source,!1,!0,!0)}this._basepoint=null}},t}(a.EditToolView);o.PointDrawToolView=_,_.__name__="PointDrawToolView";var d=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Point Draw Tool",o.icon=s.bk_tool_icon_point_draw,o.event_type=["tap","pan","move"],o.default_order=2,o}return i.__extends(t,e),t.init_PointDrawTool=function(){this.prototype.default_view=_,this.define({add:[r.Boolean,!0],drag:[r.Boolean,!0],num_objects:[r.Int,0]})},t}(a.EditTool);o.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var r=e(1),a=e(174),s=r.__importStar(e(127)),o=e(116),n=e(435),_=e(386),d=function(e){function t(){var t=e.apply(this,arguments)||this;return t._drawing=!1,t._initialized=!1,t}return r.__extends(t,e),t.prototype._tap=function(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,e.shiftKey,this.model.renderers)},t.prototype._draw=function(e,t,i){void 0===i&&(i=!1);var a=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,a);if(this._initialized||this.activate(),null!=s){var n=this._snap_to_vertex.apply(this,r.__spreadArrays([e],s)),_=n[0],d=n[1],l=a.data_source,h=a.glyph,p=[h.xs.field,h.ys.field],c=p[0],y=p[1];if("new"==t)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([_,_]),y&&l.get_array(y).push([d,d]),this._pad_empty_columns(l,[c,y]);else if("edit"==t){if(c)(g=l.data[c][l.data[c].length-1])[g.length-1]=_;if(y)(u=l.data[y][l.data[y].length-1])[u.length-1]=d}else if("add"==t){if(c){var g,f=l.data[c].length-1,v=(g=l.get_array(c)[f])[g.length-1];g[g.length-1]=_,o.isArray(g)||(g=Array.from(g),l.data[c][f]=g),g.push(v)}if(y){var u,m=l.data[y].length-1,w=(u=l.get_array(y)[m])[u.length-1];u[u.length-1]=d,o.isArray(u)||(u=Array.from(u),l.data[y][m]=u),u.push(w)}}this._emit_cds_changes(l,!0,!1,i)}},t.prototype._show_vertices=function(){if(this.model.active){for(var e=[],t=[],i=0;i<this.model.renderers.length;i++){var r=this.model.renderers[i],a=r.data_source,s=r.glyph,o=[s.xs.field,s.ys.field],n=o[0],_=o[1];if(n)for(var d=0,l=a.get_array(n);d<l.length;d++){var h=l[d];Array.prototype.push.apply(e,h)}if(_)for(var p=0,c=a.get_array(_);p<c.length;p++){h=c[p];Array.prototype.push.apply(t,h)}this._drawing&&i==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}},t.prototype._doubletap=function(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))},t.prototype._move=function(e){this._drawing&&this._draw(e,"edit")},t.prototype._remove=function(){var e=this.model.renderers[0],t=e.data_source,i=e.glyph,r=[i.xs.field,i.ys.field],a=r[0],s=r[1];if(a){var o=t.data[a].length-1,n=t.get_array(a)[o];n.splice(n.length-1,1)}if(s){var _=t.data[s].length-1,d=t.get_array(s)[_];d.splice(d.length-1,1)}this._emit_cds_changes(t)},t.prototype._keyup=function(e){if(this.model.active&&this._mouse_in_frame)for(var t=0,i=this.model.renderers;t<i.length;t++){var r=i[t];e.keyCode===a.Keys.Backspace?this._delete_selected(r):e.keyCode==a.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),r.data_source.selection_manager.clear())}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,!0,this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){if(null!=this._basepoint&&this.model.drag){for(var t=this._basepoint,i=t[0],r=t[1],a=0,s=this.model.renderers;a<s.length;a++){var o=s[a],n=this._map_drag(i,r,o),_=this._map_drag(e.sx,e.sy,o);if(null!=_&&null!=n){var d=o.data_source,l=o.glyph,h=[l.xs.field,l.ys.field],p=h[0],c=h[1];if(p||c){for(var y=_[0],g=_[1],f=[y-n[0],g-n[1]],v=f[0],u=f[1],m=0,w=d.selected.indices;m<w.length;m++){var x=w[m],b=void 0,P=void 0,T=void 0;p&&(P=d.data[p][x]),b=c?(T=d.data[c][x]).length:P.length;for(var A=0;A<b;A++)P&&(P[A]+=v),T&&(T[A]+=u)}d.change.emit()}}}this._basepoint=[e.sx,e.sy]}},t.prototype._pan_end=function(e){if(this.model.drag){this._pan(e);for(var t=0,i=this.model.renderers;t<i.length;t++){var r=i[t];this._emit_cds_changes(r.data_source)}this._basepoint=null}},t.prototype.activate=function(){var e=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(var t=0,i=this.model.renderers;t<i.length;t++){var r=i[t].data_source;r.connect(r.properties.data.change,(function(){return e._show_vertices()}))}this._initialized=!0}},t.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},t}(n.PolyToolView);i.PolyDrawToolView=d,d.__name__="PolyDrawToolView";var l=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Polygon Draw Tool",i.icon=_.bk_tool_icon_poly_draw,i.event_type=["pan","tap","move"],i.default_order=3,i}return r.__extends(t,e),t.init_PolyDrawTool=function(){this.prototype.default_view=d,this.define({drag:[s.Boolean,!0],num_objects:[s.Int,0]})},t}(n.PolyTool);i.PolyDrawTool=l,l.__name__="PolyDrawTool",l.init_PolyDrawTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),o=i.__importStar(e(127)),n=e(116),_=e(430),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._set_vertices=function(e,t){var r=this.model.vertex_renderer.glyph,i=this.model.vertex_renderer.data_source,o=[r.x.field,r.y.field],_=o[0],l=o[1];_&&(n.isArray(e)?i.data[_]=e:r.x={value:e}),l&&(n.isArray(t)?i.data[l]=t:r.y={value:t}),this._emit_cds_changes(i,!0,!0,!1)},t.prototype._hide_vertices=function(){this._set_vertices([],[])},t.prototype._snap_to_vertex=function(e,t,r){if(this.model.vertex_renderer){var i=this._select_event(e,!1,[this.model.vertex_renderer]),o=this.model.vertex_renderer.data_source,n=this.model.vertex_renderer.glyph,_=[n.x.field,n.y.field],l=_[0],d=_[1];if(i.length){var s=o.selected.indices[0];l&&(t=o.data[l][s]),d&&(r=o.data[d][s]),o.selection_manager.clear()}}return[t,r]},t}(_.EditToolView);r.PolyToolView=l,l.__name__="PolyToolView";var d=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.init_PolyTool=function(){this.prototype.default_view=l,this.define({vertex_renderer:[o.Instance]})},t}(_.EditTool);r.PolyTool=d,d.__name__="PolyTool",d.init_PolyTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var i=e(1),s=e(174),_=e(116),d=e(435),n=e(386),a=function(e){function t(){var t=e.apply(this,arguments)||this;return t._drawing=!1,t}return i.__extends(t,e),t.prototype._doubletap=function(e){if(this.model.active){var t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null!=t){var r=t[0],i=t[1],s=this._select_event(e,!1,[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,n=[d.x.field,d.y.field],a=n[0],o=n[1];if(s.length&&null!=this._selected_renderer){var l=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[l+1],a&&_.get_array(a).splice(l+1,0,r),o&&_.get_array(o).splice(l+1,0,i),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}}},t.prototype._show_vertices=function(e){if(this.model.active){var t=this._select_event(e,!1,this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var r,i,s=t[0],d=s.glyph,n=s.data_source,a=n.selected.indices[0],o=[d.xs.field,d.ys.field],l=o[0],c=o[1];l?(r=n.data[l][a],_.isArray(r)||(n.data[l][a]=r=Array.from(r))):r=d.xs.value,c?(i=n.data[c][a],_.isArray(i)||(n.data[c][a]=i=Array.from(i))):i=d.ys.value,this._selected_renderer=s,this._set_vertices(r,i)}},t.prototype._move=function(e){var t;if(this._drawing&&null!=this._selected_renderer){var r=this.model.vertex_renderer,i=r.data_source,s=r.glyph,_=this._map_drag(e.sx,e.sy,r);if(null==_)return;var d=_[0],n=_[1],a=i.selected.indices;d=(t=this._snap_to_vertex(e,d,n))[0],n=t[1],i.selected.indices=a;var o=[s.x.field,s.y.field],l=o[0],c=o[1],h=a[0];l&&(i.data[l][h]=d),c&&(i.data[c][h]=n),i.change.emit(),this._selected_renderer.data_source.change.emit()}},t.prototype._tap=function(e){var t,r=this.model.vertex_renderer,i=this._map_drag(e.sx,e.sy,r);if(null!=i){if(this._drawing&&this._selected_renderer){var s=i[0],_=i[1],d=r.data_source,n=r.glyph,a=[n.x.field,n.y.field],o=a[0],l=a[1],c=d.selected.indices;s=(t=this._snap_to_vertex(e,s,_))[0],_=t[1];var h=c[0];if(d.selected.indices=[h+1],o){var v=d.get_array(o),p=v[h];v[h]=s,v.splice(h+1,0,p)}if(l){var u=d.get_array(l),y=u[h];u[h]=_,u.splice(h+1,0,y)}return d.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var f=e.shiftKey;this._select_event(e,f,[r]),this._select_event(e,f,this.model.renderers)}},t.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var e=this.model.vertex_renderer,t=e.data_source,r=e.glyph,i=t.selected.indices[0],s=[r.x.field,r.y.field],_=s[0],d=s[1];_&&t.get_array(_).splice(i,1),d&&t.get_array(d).splice(i,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},t.prototype._pan_start=function(e){this._select_event(e,!0,[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype._keyup=function(e){if(this.model.active&&this._mouse_in_frame)for(var t=0,r=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;t<r.length;t++){var i=r[t];e.keyCode===s.Keys.Backspace?(this._delete_selected(i),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==s.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),i.data_source.selection_manager.clear())}},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},t}(d.PolyToolView);r.PolyEditToolView=a,a.__name__="PolyEditToolView";var o=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Poly Edit Tool",r.icon=n.bk_tool_icon_poly_edit,r.event_type=["tap","pan","move"],r.default_order=4,r}return i.__extends(t,e),t.init_PolyEditTool=function(){this.prototype.default_view=a},t}(d.PolyTool);r.PolyEditTool=o,o.__name__="PolyEditTool",o.init_PolyEditTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var i=e(1),n=e(438),l=e(213),s=i.__importStar(e(127)),_=e(386),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._compute_limits=function(e){var t=this.plot_view.frame,o=this.model.dimensions,i=this._base_point;if("center"==this.model.origin){var n=i[0],l=i[1];i=[n-(e[0]-n),l-(e[1]-l)]}return this.model._get_dim_limits(i,e,t,o)},t.prototype._pan_start=function(e){var t=e.sx,o=e.sy;this._base_point=[t,o]},t.prototype._pan=function(e){var t=[e.sx,e.sy],o=this._compute_limits(t),i=o[0],n=o[1];if(this.model.overlay.update({left:i[0],right:i[1],top:n[0],bottom:n[1]}),this.model.select_every_mousemove){var l=e.shiftKey;this._do_select(i,n,!1,l)}},t.prototype._pan_end=function(e){var t=[e.sx,e.sy],o=this._compute_limits(t),i=o[0],n=o[1],l=e.shiftKey;this._do_select(i,n,!0,l),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},t.prototype._do_select=function(e,t,o,i){void 0===i&&(i=!1);var n={type:"rect",sx0:e[0],sx1:e[1],sy0:t[0],sy1:t[1]};this._select(n,o,i)},t}(n.SelectToolView);o.BoxSelectToolView=r,r.__name__="BoxSelectToolView";var a=function(){return new l.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},c=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Box Select",o.icon=_.bk_tool_icon_box_select,o.event_type="pan",o.default_order=30,o}return i.__extends(t,e),t.init_BoxSelectTool=function(){this.prototype.default_view=r,this.define({dimensions:[s.Dimensions,"both"],select_every_mousemove:[s.Boolean,!1],overlay:[s.Instance,a],origin:[s.BoxOrigin,"corner"]}),this.register_alias("box_select",(function(){return new t})),this.register_alias("xbox_select",(function(){return new t({dimensions:"width"})})),this.register_alias("ybox_select",(function(){return new t({dimensions:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(n.SelectTool);o.BoxSelectTool=c,c.__name__="BoxSelectTool",c.init_BoxSelectTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(1),s=e(383),i=e(186),o=e(205),a=e(439),_=n.__importStar(e(127)),c=e(174),l=e(389),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),Object.defineProperty(t.prototype,"computed_renderers",{get:function(){var e=this.model.renderers,t=this.plot_model.renderers,r=this.model.names;return a.compute_renderers(e,t,r)},enumerable:!0,configurable:!0}),t.prototype._computed_renderers_by_data_source=function(){for(var e={},t=0,r=this.computed_renderers;t<r.length;t++){var n=r[t],s=void 0;if(n instanceof i.GlyphRenderer)s=n.data_source.id;else{if(!(n instanceof o.GraphRenderer))continue;s=n.node_renderer.data_source.id}s in e||(e[s]=[]),e[s].push(n)}return e},t.prototype._keyup=function(e){if(e.keyCode==c.Keys.Esc){for(var t=0,r=this.computed_renderers;t<r.length;t++){r[t].get_selection_manager().clear()}this.plot_view.request_render()}},t.prototype._select=function(e,t,r){var n=this._computed_renderers_by_data_source();for(var s in n){for(var i=n[s],o=i[0].get_selection_manager(),a=[],_=0,c=i;_<c.length;_++){var l=c[_];l.id in this.plot_view.renderer_views&&a.push(this.plot_view.renderer_views[l.id])}o.select(a,e,t,r)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)},t.prototype._emit_selection_event=function(e,t){void 0===t&&(t=!0);var r,n=this.plot_view.frame,s=n.xscales.default,i=n.yscales.default;switch(e.type){case"point":var o=e.sx,a=e.sy,_=s.invert(o),c=i.invert(a);r=Object.assign(Object.assign({},e),{x:_,y:c});break;case"span":o=e.sx,a=e.sy,_=s.invert(o),c=i.invert(a);r=Object.assign(Object.assign({},e),{x:_,y:c});break;case"rect":var d=e.sx0,u=e.sx1,p=e.sy0,v=e.sy1,y=s.r_invert(d,u),f=y[0],h=y[1],m=i.r_invert(p,v),b=m[0],g=m[1];r=Object.assign(Object.assign({},e),{x0:f,y0:b,x1:h,y1:g});break;case"poly":o=e.sx,a=e.sy,_=s.v_invert(o),c=i.v_invert(a);r=Object.assign(Object.assign({},e),{x:_,y:c})}this.plot_model.trigger_event(new l.SelectionGeometry(r,t))},t}(s.GestureToolView);r.SelectToolView=d,d.__name__="SelectToolView";var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.init_SelectTool=function(){this.define({renderers:[_.Any,"auto"],names:[_.Array,[]]})},t}(s.GestureTool);r.SelectTool=u,u.__name__="SelectTool",u.init_SelectTool()},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0});var t=e(117);r.compute_renderers=function(e,n,r){if(null==e)return[];var u="auto"==e?n:e;return r.length>0&&(u=u.filter((function(e){return t.includes(r,e.name)}))),u}},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});var n=t(1),i=t(383),r=t(213),s=n.__importStar(t(127)),a=t(386),_=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(o,t),o.prototype._match_aspect=function(t,o,e){var n,i,r,s,a=e.bbox.aspect,_=e.bbox.h_range.end,l=e.bbox.h_range.start,u=e.bbox.v_range.end,h=e.bbox.v_range.start,p=Math.abs(t[0]-o[0]),m=Math.abs(t[1]-o[1]),c=0==m?0:p/m,d=(c>=a?[1,c/a]:[a/c,1])[0];return t[0]<=o[0]?(n=t[0],(i=t[0]+p*d)>_&&(i=_)):(i=t[0],(n=t[0]-p*d)<l&&(n=l)),p=Math.abs(i-n),t[1]<=o[1]?(s=t[1],(r=t[1]+p/a)>u&&(r=u)):(r=t[1],(s=t[1]-p/a)<h&&(s=h)),m=Math.abs(r-s),t[0]<=o[0]?i=t[0]+a*m:n=t[0]-a*m,[[n,i],[s,r]]},o.prototype._compute_limits=function(t){var o,e,n,i,r=this.plot_view.frame,s=this.model.dimensions,a=this._base_point;if("center"==this.model.origin){var _=a[0],l=a[1];a=[_-(t[0]-_),l-(t[1]-l)]}return this.model.match_aspect&&"both"==s?(n=(o=this._match_aspect(a,t,r))[0],i=o[1]):(n=(e=this.model._get_dim_limits(a,t,r,s))[0],i=e[1]),[n,i]},o.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},o.prototype._pan=function(t){var o=[t.sx,t.sy],e=this._compute_limits(o),n=e[0],i=e[1];this.model.overlay.update({left:n[0],right:n[1],top:i[0],bottom:i[1]})},o.prototype._pan_end=function(t){var o=[t.sx,t.sy],e=this._compute_limits(o),n=e[0],i=e[1];this._update(n,i),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},o.prototype._update=function(t,o){var e=t[0],n=t[1],i=o[0],r=o[1];if(!(Math.abs(n-e)<=5||Math.abs(r-i)<=5)){var s=this.plot_view.frame,a=s.xscales,_=s.yscales,l={};for(var u in a){var h=a[u].r_invert(e,n),p=h[0],m=h[1];l[u]={start:p,end:m}}var c={};for(var u in _){var d=_[u].r_invert(i,r);p=d[0],m=d[1];c[u]={start:p,end:m}}var v={xrs:l,yrs:c};this.plot_view.push_state("box_zoom",{range:v}),this.plot_view.update_range(v)}},o}(i.GestureToolView);e.BoxZoomToolView=_,_.__name__="BoxZoomToolView";var l=function(){return new r.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},u=function(t){function o(o){var e=t.call(this,o)||this;return e.tool_name="Box Zoom",e.icon=a.bk_tool_icon_box_zoom,e.event_type="pan",e.default_order=20,e}return n.__extends(o,t),o.init_BoxZoomTool=function(){this.prototype.default_view=_,this.define({dimensions:[s.Dimensions,"both"],overlay:[s.Instance,l],match_aspect:[s.Boolean,!1],origin:[s.BoxOrigin,"corner"]}),this.register_alias("box_zoom",(function(){return new o({dimensions:"both"})})),this.register_alias("xbox_zoom",(function(){return new o({dimensions:"width"})})),this.register_alias("ybox_zoom",(function(){return new o({dimensions:"height"})}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),o}(i.GestureTool);e.BoxZoomTool=u,u.__name__="BoxZoomTool",u.init_BoxZoomTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var s=e(1),i=e(438),a=e(246),l=e(174),n=s.__importStar(e(127)),_=e(386),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.data=null},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return t._active_change()}))},t.prototype._active_change=function(){this.model.active||this._clear_overlay()},t.prototype._keyup=function(e){e.keyCode==l.Keys.Enter&&this._clear_overlay()},t.prototype._pan_start=function(e){var t=e.sx,o=e.sy;this.data={sx:[t],sy:[o]}},t.prototype._pan=function(e){var t=e.sx,o=e.sy,s=this.plot_view.frame.bbox.clip(t,o),i=s[0],a=s[1];if(this.data.sx.push(i),this.data.sy.push(a),this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove){var l=e.shiftKey;this._do_select(this.data.sx,this.data.sy,!1,l)}},t.prototype._pan_end=function(e){this._clear_overlay();var t=e.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,t),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},t.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},t.prototype._do_select=function(e,t,o,s){var i={type:"poly",sx:e,sy:t};this._select(i,o,s)},t}(i.SelectToolView);o.LassoSelectToolView=c,c.__name__="LassoSelectToolView";var r=function(){return new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},p=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Lasso Select",o.icon=_.bk_tool_icon_lasso_select,o.event_type="pan",o.default_order=12,o}return s.__extends(t,e),t.init_LassoSelectTool=function(){this.prototype.default_view=c,this.define({select_every_mousemove:[n.Boolean,!0],overlay:[n.Instance,r]}),this.register_alias("lasso_select",(function(){return new t}))},t}(i.SelectTool);o.LassoSelectTool=p,p.__name__="LassoSelectTool",p.init_LassoSelectTool()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});var i=t(1),o=t(383),s=i.__importStar(t(127)),a=t(386),r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var n=t.sx,e=t.sy,i=this.plot_view.frame.bbox;if(!i.contains(n,e)){var o=i.h_range,s=i.v_range;(n<o.start||n>o.end)&&(this.v_axis_only=!0),(e<s.start||e>s.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},n.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},n.prototype._update=function(t,n){var e,i,o,s,a,r,_=this.plot_view.frame,l=t-this.last_dx,h=n-this.last_dy,d=_.bbox.h_range,p=d.start-l,u=d.end-l,c=_.bbox.v_range,f=c.start-h,m=c.end-h,v=this.model.dimensions;"width"!=v&&"both"!=v||this.v_axis_only?(e=d.start,i=d.end,o=0):(e=p,i=u,o=-l),"height"!=v&&"both"!=v||this.h_axis_only?(s=c.start,a=c.end,r=0):(s=f,a=m,r=-h),this.last_dx=t,this.last_dy=n;var y=_.xscales,b=_.yscales,x={};for(var g in y){var w=y[g].r_invert(e,i),P=w[0],T=w[1];x[g]={start:P,end:T}}var j={};for(var g in b){var k=b[g].r_invert(s,a);P=k[0],T=k[1];j[g]={start:P,end:T}}this.pan_info={xrs:x,yrs:j,sdx:o,sdy:r},this.plot_view.update_range(this.pan_info,!0)},n}(o.GestureToolView);e.PanToolView=r,r.__name__="PanToolView";var _=function(t){function n(n){var e=t.call(this,n)||this;return e.tool_name="Pan",e.event_type="pan",e.default_order=10,e}return i.__extends(n,t),n.init_PanTool=function(){this.prototype.default_view=r,this.define({dimensions:[s.Dimensions,"both"]}),this.register_alias("pan",(function(){return new n({dimensions:"both"})})),this.register_alias("xpan",(function(){return new n({dimensions:"width"})})),this.register_alias("ypan",(function(){return new n({dimensions:"height"})}))},Object.defineProperty(n.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"icon",{get:function(){switch(this.dimensions){case"both":return a.bk_tool_icon_pan;case"width":return a.bk_tool_icon_xpan;case"height":return a.bk_tool_icon_ypan}},enumerable:!0,configurable:!0}),n}(o.GestureTool);e.PanTool=_,_.__name__="PanTool",_.init_PanTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var i=t(1),l=t(438),n=t(246),a=t(174),s=i.__importStar(t(127)),c=t(117),_=t(386),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==a.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,o=t.sy;this.plot_view.frame.bbox.contains(e,o)&&(this.data.sx.push(e),this.data.sy.push(o),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))},e.prototype._do_select=function(t,e,o,i){var l={type:"poly",sx:t,sy:e};this._select(l,o,i)},e}(l.SelectToolView);o.PolySelectToolView=r,r.__name__="PolySelectToolView";var p=function(){return new n.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},y=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Poly Select",o.icon=_.bk_tool_icon_polygon_select,o.event_type="tap",o.default_order=11,o}return i.__extends(e,t),e.init_PolySelectTool=function(){this.prototype.default_view=r,this.define({overlay:[s.Instance,p]}),this.register_alias("poly_select",(function(){return new e}))},e}(l.SelectTool);o.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var n=t(1),s=t(213),r=t(178),l=n.__importStar(t(127)),a=t(383),o=t(386);function _(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function h(t,e,i,n){if(null==e)return!1;var s=i.compute(e);return Math.abs(t-s)<n}function u(t,e,i,n,s){var r=!0;if(null!=s.left&&null!=s.right){var l=i.invert(t);(l<s.left||l>s.right)&&(r=!1)}if(null!=s.bottom&&null!=s.top){var a=n.invert(e);(a<s.bottom||a>s.top)&&(r=!1)}return r}function d(t,e,i){var n=0;return t>=i.start&&t<=i.end&&(n+=1),e>=i.start&&e<=i.end&&(n+=1),n}function c(t,e,i,n){var s=e.compute(t),r=e.invert(s+i);return r>=n.start&&r<=n.end?r:t}function y(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,_(i))}function f(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,_(i))}function g(t,e,i,n){var s=e.r_compute(t.start,t.end),r=s[0],l=s[1],a=e.r_invert(r+i,l+i),o=a[0],_=a[1],h=d(t.start,t.end,n);d(o,_,n)>=h&&(t.start=o,t.end=_)}i.flip_side=_,i.is_near=h,i.is_inside=u,i.sides_inside=d,i.compute_value=c,i.update_range_end_side=y,i.update_range_start_side=f,i.update_range=g;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,(function(){return e.model.update_overlay_from_ranges()})),null!=this.model.y_range&&this.connect(this.model.y_range.change,(function(){return e.model.update_overlay_from_ranges()}))},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_view.frame,r=n.xscales.default,l=n.yscales.default,a=this.model.overlay,o=a.left,_=a.right,d=a.top,c=a.bottom,y=this.model.overlay.properties.line_width.value()+s.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(h(t.sx,o,r,y)?this.side=1:h(t.sx,_,r,y)?this.side=2:u(t.sx,t.sy,r,l,a)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&h(t.sy,c,l,y)&&(this.side=4),0==this.side&&h(t.sy,d,l,y)?this.side=5:u(t.sx,t.sy,r,l,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,s=this.model.x_range,r=this.model.y_range,l=e.xscales.default,a=e.yscales.default;if(null!=s)if(3==this.side||7==this.side)g(s,l,i,e.x_range);else if(1==this.side){var o=c(s.start,l,i,e.x_range);this.side=f(o,s,this.side)}else if(2==this.side){var _=c(s.end,l,i,e.x_range);this.side=y(_,s,this.side)}if(null!=r)if(6==this.side||7==this.side)g(r,a,n,e.y_range);else if(4==this.side){o=c(r.start,a,n,e.y_range);this.side=f(o,r,this.side)}else if(5==this.side){_=c(r.end,a,n,e.y_range);this.side=y(_,r,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0},e}(a.GestureToolView);i.RangeToolView=v,v.__name__="RangeToolView";var p=function(){return new s.BoxAnnotation({level:"overlay",render_mode:"canvas",fill_color:"lightgrey",fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:.5},line_dash:[2,2]})},m=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Range Tool",i.icon=o.bk_tool_icon_range,i.event_type="pan",i.default_order=1,i}return n.__extends(e,t),e.init_RangeTool=function(){this.prototype.default_view=v,this.define({x_range:[l.Instance,null],x_interaction:[l.Boolean,!0],y_range:[l.Instance,null],y_interaction:[l.Boolean,!0],overlay:[l.Instance,p]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,r.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e}(a.GestureTool);i.RangeTool=m,m.__name__="RangeTool",m.init_RangeTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var s=e(1),n=e(438),r=s.__importStar(e(127)),o=e(386),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s.__extends(t,e),t.prototype._tap=function(e){var t={type:"point",sx:e.sx,sy:e.sy},i=e.shiftKey;this._select(t,!0,i)},t.prototype._select=function(e,t,i){var s=this,n=this.model.callback;if("select"==this.model.behavior){var r=this._computed_renderers_by_data_source();for(var o in r){var a=r[o],_=a[0].get_selection_manager(),l=a.map((function(e){return s.plot_view.renderer_views[e.id]}));if(_.select(l,e,t,i)&&null!=n){var c=(y=this.plot_view.frame).xscales[a[0].x_range_name],p=y.yscales[a[0].y_range_name],u=c.invert(e.sx),v=p.invert(e.sy),h={geometries:Object.assign(Object.assign({},e),{x:u,y:v}),source:_.source};n.execute(this.model,h)}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(var f=0,m=this.computed_renderers;f<m.length;f++){var d=m[f];if((_=d.get_selection_manager()).inspect(this.plot_view.renderer_views[d.id],e)&&null!=n){var y;c=(y=this.plot_view.frame).xscales[d.x_range_name],p=y.yscales[d.y_range_name],u=c.invert(e.sx),v=p.invert(e.sy),h={geometries:Object.assign(Object.assign({},e),{x:u,y:v}),source:_.source};n.execute(this.model,h)}}},t}(n.SelectToolView);i.TapToolView=a,a.__name__="TapToolView";var _=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Tap",i.icon=o.bk_tool_icon_tap_select,i.event_type="tap",i.default_order=10,i}return s.__extends(t,e),t.init_TapTool=function(){this.prototype.default_view=a,this.define({behavior:[r.TapBehavior,"select"],callback:[r.Any]}),this.register_alias("click",(function(){return new t({behavior:"inspect"})})),this.register_alias("tap",(function(){return new t}))},t}(n.SelectTool);i.TapTool=_,_.__name__="TapTool",_.init_TapTool()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var i=e(1),o=e(383),r=i.__importStar(e(127)),a=e(386),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(t,e),t.prototype._scroll=function(e){var t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)},t.prototype._update_ranges=function(e){var t,n,i,o,r=this.plot_view.frame,a=r.bbox.h_range,s=r.bbox.v_range,l=[a.start,a.end],_=l[0],h=l[1],d=[s.start,s.end],u=d[0],p=d[1];switch(this.model.dimension){case"height":var c=Math.abs(p-u);t=_,n=h,i=u-c*e,o=p-c*e;break;case"width":var v=Math.abs(h-_);t=_-v*e,n=h-v*e,i=u,o=p;break;default:throw new Error("this shouldn't have happened")}var f=r.xscales,m=r.yscales,w={};for(var b in f){var g=f[b].r_invert(t,n),y=g[0],P=g[1];w[b]={start:y,end:P}}var T={};for(var b in m){var x=m[b].r_invert(i,o);y=x[0],P=x[1];T[b]={start:y,end:P}}var W={xrs:w,yrs:T,factor:e};this.plot_view.push_state("wheel_pan",{range:W}),this.plot_view.update_range(W,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)},t}(o.GestureToolView);n.WheelPanToolView=s,s.__name__="WheelPanToolView";var l=function(e){function t(t){var n=e.call(this,t)||this;return n.tool_name="Wheel Pan",n.icon=a.bk_tool_icon_wheel_pan,n.event_type="scroll",n.default_order=12,n}return i.__extends(t,e),t.init_WheelPanTool=function(){this.prototype.default_view=s,this.define({dimension:[r.Dimension,"width"]}),this.internal({speed:[r.Number,.001]}),this.register_alias("xwheel_pan",(function(){return new t({dimension:"width"})})),this.register_alias("ywheel_pan",(function(){return new t({dimension:"height"})}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!0,configurable:!0}),t}(o.GestureTool);n.WheelPanTool=l,l.__name__="WheelPanTool",l.init_WheelPanTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),n=e(383),s=e(428),l=i.__importStar(e(127)),r=e(209),_=e(386),h=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(o,e),o.prototype._pinch=function(e){var o,t=e.sx,i=e.sy,n=e.scale;o=n>=1?20*(n-1):-20/n,this._scroll({type:"wheel",sx:t,sy:i,delta:o})},o.prototype._scroll=function(e){var o=this.plot_view.frame,t=o.bbox.h_range,i=o.bbox.v_range,n=e.sx,l=e.sy,r=this.model.dimensions,_=("width"==r||"both"==r)&&t.start<n&&n<t.end,h=("height"==r||"both"==r)&&i.start<l&&l<i.end;if(_&&h||this.model.zoom_on_axis){var a=this.model.speed*e.delta,m=s.scale_range(o,a,_,h,{x:n,y:l});this.plot_view.push_state("wheel_zoom",{range:m}),this.plot_view.update_range(m,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}},o}(n.GestureToolView);t.WheelZoomToolView=h,h.__name__="WheelZoomToolView";var a=function(e){function o(o){var t=e.call(this,o)||this;return t.tool_name="Wheel Zoom",t.icon=_.bk_tool_icon_wheel_zoom,t.event_type=r.is_mobile?"pinch":"scroll",t.default_order=10,t}return i.__extends(o,e),o.init_WheelZoomTool=function(){this.prototype.default_view=h,this.define({dimensions:[l.Dimensions,"both"],maintain_focus:[l.Boolean,!0],zoom_on_axis:[l.Boolean,!0],speed:[l.Number,1/600]}),this.register_alias("wheel_zoom",(function(){return new o({dimensions:"both"})})),this.register_alias("xwheel_zoom",(function(){return new o({dimensions:"width"})})),this.register_alias("ywheel_zoom",(function(){return new o({dimensions:"height"})}))},Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),o}(n.GestureTool);t.WheelZoomTool=a,a.__name__="WheelZoomTool",a.init_WheelZoomTool()},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});var o=i(1),n=i(377),s=i(248),r=o.__importStar(i(127)),l=i(131),a=i(386),_=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return o.__extends(t,i),t.prototype._move=function(i){if(this.model.active){var t=i.sx,e=i.sy;this.plot_view.frame.bbox.contains(t,e)?this._update_spans(t,e):this._update_spans(null,null)}},t.prototype._move_exit=function(i){this._update_spans(null,null)},t.prototype._update_spans=function(i,t){var e=this.model.dimensions;"width"!=e&&"both"!=e||(this.model.spans.width.computed_location=t),"height"!=e&&"both"!=e||(this.model.spans.height.computed_location=i)},t}(n.InspectToolView);e.CrosshairToolView=_,_.__name__="CrosshairToolView";var h=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Crosshair",e.icon=a.bk_tool_icon_crosshair,e}return o.__extends(t,i),t.init_CrosshairTool=function(){this.prototype.default_view=_,this.define({dimensions:[r.Dimensions,"both"],line_color:[r.Color,"black"],line_width:[r.Number,1],line_alpha:[r.Number,1]}),this.internal({location_units:[r.SpatialUnits,"screen"],render_mode:[r.RenderMode,"css"],spans:[r.Any]}),this.register_alias("crosshair",(function(){return new t}))},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"synthetic_renderers",{get:function(){return l.values(this.spans)},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){i.prototype.initialize.call(this),this.spans={width:new s.Span({for_hover:!0,dimension:"width",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new s.Span({for_hover:!0,dimension:"height",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}},t}(n.InspectTool);e.CrosshairTool=h,h.__name__="CrosshairTool",h.init_CrosshairTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var o=e(1),n=e(177),i=o.__importStar(e(127)),s=e(131),u=e(133),a=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CustomJSHover=function(){this.define({args:[i.Any,{}],code:[i.String,""]})},Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),t.prototype._make_code=function(e,t,r,n){return new(Function.bind.apply(Function,o.__spreadArrays([void 0],s.keys(this.args),[e,t,r,u.use_strict(n)])))},t.prototype.format=function(e,t,r){return this._make_code("value","format","special_vars",this.code).apply(void 0,o.__spreadArrays(this.values,[e,t,r]))},t}(n.Model);r.CustomJSHover=a,a.__name__="CustomJSHover",a.init_CustomJSHover()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});var n=e(1),o=e(377),r=e(251),s=e(186),a=e(205),l=e(439),d=n.__importStar(e(195)),c=e(266),_=e(174),p=n.__importStar(e(127)),h=e(129),m=e(131),u=e(116),v=e(204),y=e(386),f=e(252);function x(e,t,i,n,o,r){var s,a,l={x:o[e],y:r[e]},c={x:o[e+1],y:r[e+1]};if("span"==t.type)"h"==t.direction?(s=Math.abs(l.x-i),a=Math.abs(c.x-i)):(s=Math.abs(l.y-n),a=Math.abs(c.y-n));else{var _={x:i,y:n};s=d.dist_2_pts(l,_),a=d.dist_2_pts(c,_)}return s<a?[[l.x,l.y],e]:[[c.x,c.y],e+1]}function g(e,t,i){return[[e[i],t[i]],i]}i._nearest_line_hit=x,i._line_hit=g;var b=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.ttviews={}},t.prototype.remove=function(){v.remove_views(this.ttviews),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);for(var i=0,n=this.computed_renderers;i<n.length;i++){var o=n[i];o instanceof s.GlyphRenderer?this.connect(o.data_source.inspect,this._update):o instanceof a.GraphRenderer&&(this.connect(o.node_renderer.data_source.inspect,this._update),this.connect(o.edge_renderer.data_source.inspect,this._update))}this.connect(this.model.properties.renderers.change,(function(){return t._computed_renderers=t._ttmodels=null})),this.connect(this.model.properties.names.change,(function(){return t._computed_renderers=t._ttmodels=null})),this.connect(this.model.properties.tooltips.change,(function(){return t._ttmodels=null}))},t.prototype._compute_ttmodels=function(){var e={},t=this.model.tooltips;if(null!=t)for(var i=0,n=this.computed_renderers;i<n.length;i++){var o=n[i];if(o instanceof s.GlyphRenderer){var l=new r.Tooltip({custom:u.isString(t)||u.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});e[o.id]=l}else if(o instanceof a.GraphRenderer){l=new r.Tooltip({custom:u.isString(t)||u.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});e[o.node_renderer.id]=l,e[o.edge_renderer.id]=l}}return v.build_views(this.ttviews,m.values(e),{parent:this.plot_view}),e},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var e=this.model.renderers,t=this.plot_model.renderers,i=this.model.names;this._computed_renderers=l.compute_renderers(e,t,i)}return this._computed_renderers},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!0,configurable:!0}),t.prototype._clear=function(){for(var e in this._inspect(1/0,1/0),this.ttmodels){this.ttmodels[e].clear()}},t.prototype._move=function(e){if(this.model.active){var t=e.sx,i=e.sy;this.plot_view.frame.bbox.contains(t,i)?this._inspect(t,i):this._clear()}},t.prototype._move_exit=function(){this._clear()},t.prototype._inspect=function(e,t){var i;"mouse"==this.model.mode?i={type:"point",sx:e,sy:t}:i={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t};for(var n=0,o=this.computed_renderers;n<o.length;n++){var r=o[n];r.get_selection_manager().inspect(this.plot_view.renderer_views[r.id],i)}null!=this.model.callback&&this._emit_callback(i)},t.prototype._update=function(e){var t,i,n,o,r,l,d,c,_,p,h,u,v,y,f,b,w=e[0],k=e[1].geometry;if(this.model.active&&(w instanceof s.GlyphRendererView||w instanceof a.GraphRendererView)){var T=w.model,H=this.ttmodels[T.id];if(null!=H){H.clear();var C=T.get_selection_manager(),G=C.inspectors[T.id];if(T instanceof s.GlyphRenderer&&(G=T.view.convert_selection_to_subset(G)),!G.is_empty()){for(var R=C.source,$=this.plot_view.frame,M=k.sx,A=k.sy,O=$.xscales[T.x_range_name],S=$.yscales[T.y_range_name],P=O.invert(M),V=S.invert(A),j=w.glyph,z=0,F=G.line_indices;z<F.length;z++){var L=F[z],E=j._x[L+1],I=j._y[L+1],B=L,N=void 0,q=void 0;switch(this.model.line_policy){case"interp":E=(t=j.get_interpolation_hit(L,k))[0],I=t[1],N=O.compute(E),q=S.compute(I);break;case"prev":N=(n=(i=g(j.sx,j.sy,L))[0])[0],q=n[1],B=i[1];break;case"next":N=(r=(o=g(j.sx,j.sy,L+1))[0])[0],q=r[1],B=o[1];break;case"nearest":N=(d=(l=x(L,k,M,A,j.sx,j.sy))[0])[0],q=d[1],B=l[1],E=j._x[B],I=j._y[B];break;default:N=(c=[M,A])[0],q=c[1]}var D={index:B,x:P,y:V,sx:M,sy:A,data_x:E,data_y:I,rx:N,ry:q,indices:G.line_indices,name:w.model.name};H.add(N,q,this._render_tooltips(R,B,D))}for(var J=0,K=G.image_indices;J<K.length;J++){var Q=K[J],U=(D={index:Q.index,x:P,y:V,sx:M,sy:A},this._render_tooltips(R,Q,D));H.add(M,A,U)}for(var W=0,X=G.indices;W<X.length;W++){L=X[W];if(m.isEmpty(G.multiline_indices)){E=null!=j._x?j._x[L]:void 0,I=null!=j._y?j._y[L]:void 0,N=void 0,q=void 0;if("snap_to_data"==this.model.point_policy){var Y=j.get_anchor_point(this.model.anchor,L,[M,A]);null==Y&&(Y=j.get_anchor_point("center",L,[M,A])),N=Y.x,q=Y.y}else N=(b=[M,A])[0],q=b[1];ne=void 0,D={index:ne=T instanceof s.GlyphRenderer?T.view.convert_indices_from_subset([L])[0]:L,x:P,y:V,sx:M,sy:A,data_x:E,data_y:I,indices:G.indices,name:w.model.name};H.add(N,q,this._render_tooltips(R,ne,D))}else for(var Z=0,ee=G.multiline_indices[L.toString()];Z<ee.length;Z++){var te=ee[Z],E=j._xs[L][te],I=j._ys[L][te],ie=te,N=void 0,q=void 0;switch(this.model.line_policy){case"interp":E=(_=j.get_interpolation_hit(L,te,k))[0],I=_[1],N=O.compute(E),q=S.compute(I);break;case"prev":N=(h=(p=g(j.sxs[L],j.sys[L],te))[0])[0],q=h[1],ie=p[1];break;case"next":N=(v=(u=g(j.sxs[L],j.sys[L],te+1))[0])[0],q=v[1],ie=u[1];break;case"nearest":N=(f=(y=x(te,k,M,A,j.sxs[L],j.sys[L]))[0])[0],q=f[1],ie=y[1],E=j._xs[L][ie],I=j._ys[L][ie];break;default:throw new Error("should't have happened")}var ne=void 0,D={index:ne=T instanceof s.GlyphRenderer?T.view.convert_indices_from_subset([L])[0]:L,x:P,y:V,sx:M,sy:A,data_x:E,data_y:I,segment_index:ie,indices:G.multiline_indices,name:w.model.name};H.add(N,q,this._render_tooltips(R,ne,D))}}}}}},t.prototype._emit_callback=function(e){for(var t=0,i=this.computed_renderers;t<i.length;t++){var n=i[t],o=n.data_source.inspected,r=this.plot_view.frame,s=r.xscales[n.x_range_name],a=r.yscales[n.y_range_name],l=s.invert(e.sx),d=a.invert(e.sy),c=Object.assign({x:l,y:d},e);this.model.callback.execute(this.model,{index:o,geometry:c,renderer:n})}},t.prototype._render_tooltips=function(e,t,i){var n=this.model.tooltips;if(u.isString(n))return(G=_.div()).innerHTML=c.replace_placeholders(n,e,t,this.model.formatters,i),G;if(u.isFunction(n))return n(e,i);for(var o=_.div({style:{display:"table",borderSpacing:"2px"}}),r=0,s=n;r<s.length;r++){var a=s[r],l=a[0],d=a[1],p=_.div({style:{display:"table-row"}});o.appendChild(p);var m=void 0;if(m=_.div({style:{display:"table-cell"},class:f.bk_tooltip_row_label},0!=l.length?l+": ":""),p.appendChild(m),m=_.div({style:{display:"table-cell"},class:f.bk_tooltip_row_value}),p.appendChild(m),d.indexOf("$color")>=0){var v=d.match(/\$color(\[.*\])?:(\w*)/),y=v[1],x=void 0===y?"":y,g=v[2],b=e.get_column(g);if(null==b){var w=_.span({},g+" unknown");m.appendChild(w);continue}var k=x.indexOf("hex")>=0,T=x.indexOf("swatch")>=0,H=u.isNumber(t)?b[t]:null;if(null==H){var C=_.span({},"(null)");m.appendChild(C);continue}k&&(H=h.color2hex(H));var G=_.span({},H);m.appendChild(G),T&&(G=_.span({class:f.bk_tooltip_color_block,style:{backgroundColor:H}}," "),m.appendChild(G))}else{(G=_.span()).innerHTML=c.replace_placeholders(d.replace("$~","$data_"),e,t,this.model.formatters,i),m.appendChild(G)}}return o},t}(o.InspectToolView);i.HoverToolView=b,b.__name__="HoverToolView";var w=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Hover",i.icon=y.bk_tool_icon_hover,i}return n.__extends(t,e),t.init_HoverTool=function(){this.prototype.default_view=b,this.define({tooltips:[p.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[p.Any,{}],renderers:[p.Any,"auto"],names:[p.Array,[]],mode:[p.HoverMode,"mouse"],point_policy:[p.PointPolicy,"snap_to_data"],line_policy:[p.LinePolicy,"nearest"],show_arrow:[p.Boolean,!0],anchor:[p.Anchor,"center"],attachment:[p.TooltipAttachment,"horizontal"],callback:[p.Any]}),this.register_alias("hover",(function(){return new t}))},t}(o.InspectTool);i.HoverTool=w,w.__name__="HoverTool",w.init_HoverTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});var n=t(1),i=n.__importStar(t(127)),r=t(122),c=t(177),l=t(377),u=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_ToolProxy=function(){this.define({tools:[i.Array,[]],active:[i.Boolean,!1],disabled:[i.Boolean,!1]})},Object.defineProperty(e.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"toggleable",{get:function(){var t=this.tools[0];return t instanceof l.InspectTool&&t.toggleable},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.do=new r.Signal0(this,"do")},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.do,(function(){return e.doit()})),this.connect(this.properties.active.change,(function(){return e.set_active()}))},e.prototype.doit=function(){for(var t=0,e=this.tools;t<e.length;t++){e[t].do.emit()}},e.prototype.set_active=function(){for(var t=0,e=this.tools;t<e.length;t++){e[t].active=this.active}},e}(c.Model);o.ToolProxy=u,u.__name__="ToolProxy",u.init_ToolProxy()},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});var e=t(1),r=e.__importStar(t(127)),n=t(117),s=t(382),l=t(451),a=t(352),h=t(295),p=function(t){function o(o){return t.call(this,o)||this}return e.__extends(o,t),o.init_ProxyToolbar=function(){this.define({toolbars:[r.Array,[]]})},o.prototype.initialize=function(){t.prototype.initialize.call(this),this._merge_tools()},o.prototype._merge_tools=function(){var t,o=this;this._proxied_tools=[];for(var i={},e={},r={},s=[],a=[],h=0,p=this.help;h<p.length;h++){var c=p[h];n.includes(a,c.redirect)||(s.push(c),a.push(c.redirect))}for(var u in(t=this._proxied_tools).push.apply(t,s),this.help=s,this.gestures){var _=this.gestures[u];u in r||(r[u]={});for(var f=0,y=_.tools;f<y.length;f++){(L=y[f]).type in r[u]||(r[u][L.type]=[]),r[u][L.type].push(L)}}for(var d=0,v=this.inspectors;d<v.length;d++){(L=v[d]).type in i||(i[L.type]=[]),i[L.type].push(L)}for(var g=0,b=this.actions;g<b.length;g++){(L=b[g]).type in e||(e[L.type]=[]),e[L.type].push(L)}var x=function(t,i){void 0===i&&(i=!1);var e=new l.ToolProxy({tools:t,active:i});return o._proxied_tools.push(e),e};for(var u in r){_=this.gestures[u];for(var m in _.tools=[],r[u]){if((z=r[u][m]).length>0)if("multi"==u)for(var T=0,w=z;T<w.length;T++){var B=x([L=w[T]]);_.tools.push(B),this.connect(B.properties.active.change,this._active_change.bind(this,B))}else{B=x(z);_.tools.push(B),this.connect(B.properties.active.change,this._active_change.bind(this,B))}}}for(var m in this.actions=[],e){var z=e[m];if("CustomAction"==m)for(var P=0,O=z;P<O.length;P++){var L=O[P];this.actions.push(x([L]))}else z.length>0&&this.actions.push(x(z))}for(var m in this.inspectors=[],i){(z=i[m]).length>0&&this.inspectors.push(x(z,!0))}for(var M in this.gestures){0!=(_=this.gestures[M]).tools.length&&(_.tools=n.sort_by(_.tools,(function(t){return t.default_order})),"pinch"!=M&&"scroll"!=M&&"multi"!=M&&(_.tools[0].active=!0))}},o}(s.ToolbarBase);i.ProxyToolbar=p,p.__name__="ProxyToolbar",p.init_ProxyToolbar();var c=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(o,t),o.prototype.initialize=function(){this.model.toolbar.toolbar_location=this.model.toolbar_location,t.prototype.initialize.call(this)},Object.defineProperty(o.prototype,"child_models",{get:function(){return[this.model.toolbar]},enumerable:!0,configurable:!0}),o.prototype._update_layout=function(){this.layout=new h.ContentBox(this.child_views[0].el),this.model.toolbar.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})},o}(a.LayoutDOMView);i.ToolbarBoxView=c,c.__name__="ToolbarBoxView";var u=function(t){function o(o){return t.call(this,o)||this}return e.__extends(o,t),o.init_ToolbarBox=function(){this.prototype.default_view=c,this.define({toolbar:[r.Instance],toolbar_location:[r.Location,"right"]})},o}(a.LayoutDOM);i.ToolbarBox=u,u.__name__="ToolbarBox",u.init_ToolbarBox()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var i=e(1),o=e(113),a=e(172),r=e(204),d=e(174),s=e(454);t.index={},t.add_document_standalone=function(e,n,l,c){return void 0===l&&(l=[]),void 0===c&&(c=!1),i.__awaiter(this,void 0,void 0,(function(){function u(o){return i.__awaiter(this,void 0,void 0,(function(){var c,u,_,f,w;return i.__generator(this,(function(i){switch(i.label){case 0:return u=e.roots(),_=u.indexOf(o),null!=(f=l[_])?c=f:n.classList.contains(s.BOKEH_ROOT)?c=n:(c=d.div({class:s.BOKEH_ROOT}),n.appendChild(c)),[4,r.build_view(o,{parent:null})];case 1:return(w=i.sent())instanceof a.DOMView&&w.renderTo(c),v.set(o,w),t.index[o.id]=w,[2,w]}}))}))}var v,_,f;return i.__generator(this,(function(n){switch(n.label){case 0:v=new Map,_=0,f=e.roots(),n.label=1;case 1:return _<f.length?[4,u(f[_])]:[3,4];case 2:n.sent(),n.label=3;case 3:return _++,[3,1];case 4:return c&&(window.document.title=e.title()),e.on_change((function(e){e instanceof o.RootAddedEvent?u(e.model):e instanceof o.RootRemovedEvent?function(e){var n=v.get(e);null!=n&&(n.remove(),v.delete(e),delete t.index[e.id])}(e.model):c&&e instanceof o.TitleChangedEvent&&(window.document.title=e.title)})),[2,i.__spreadArrays(v.values())]}}))}))}},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(174),t=e(175);function l(e){var r=document.getElementById(e);if(null==r)throw new Error("Error rendering Bokeh model: could not find #"+e+" HTML tag");if(!document.body.contains(r))throw new Error("Error rendering Bokeh model: element #"+e+" must be under <body>");if("SCRIPT"==r.tagName){var t=n.div({class:o.BOKEH_ROOT});n.replaceWith(r,t),r=t}return r}o.BOKEH_ROOT=t.bk_root,o._resolve_element=function(e){var r=e.elementid;return null!=r?l(r):document.body},o._resolve_root_elements=function(e){var r=[];if(null!=e.root_ids&&null!=e.roots)for(var o=0,n=e.root_ids;o<n.length;o++){var t=n[o];r.push(l(e.roots[t]))}return r}},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(1),r=e(456),s=e(178),a=e(453);o._get_ws_url=function(e,n){var o,t="ws:";return"https:"==window.location.protocol&&(t="wss:"),null!=n?(o=document.createElement("a")).href=n:o=window.location,null!=e?"/"==e&&(e=""):e=o.pathname.replace(/\/+$/,""),t+"//"+o.host+e+"/ws"};var i={};function u(e,n,o){var t=r.parse_token(n).session_id;e in i||(i[e]={});var s=i[e];return t in s||(s[t]=r.pull_session(e,n,o)),s[t]}o.add_document_from_session=function(e,n,o,i,c){return void 0===i&&(i=[]),void 0===c&&(c=!1),t.__awaiter(this,void 0,void 0,(function(){var l,d,_,w;return t.__generator(this,(function(t){switch(t.label){case 0:l=window.location.search.substr(1),t.label=1;case 1:return t.trys.push([1,3,,4]),[4,u(e,n,l)];case 2:return d=t.sent(),[3,4];case 3:throw _=t.sent(),w=r.parse_token(n).session_id,s.logger.error("Failed to load Bokeh session "+w+": "+_),_;case 4:return[2,a.add_document_standalone(d.document,o,i,c)]}}))}))}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});var o=e(1),s=e(178),r=e(113),i=e(457),c=e(458),l=e(459);t.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",t.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";var _=0;function a(e){var n=e.split(".")[0],t=n.length%4;return 0!=t&&(n+="=".repeat(4-t)),JSON.parse(atob(n.replace(/_/g,"/").replace(/-/g,"+")))}t.parse_token=a;var h=function(){function e(e,n,o){void 0===e&&(e=t.DEFAULT_SERVER_WEBSOCKET_URL),void 0===n&&(n=t.DEFAULT_TOKEN),void 0===o&&(o=null),this.url=e,this.token=n,this.args_string=o,this._number=_++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new c.Receiver,this.id=a(n).session_id.split(".")[0],s.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return e.prototype.connect=function(){return o.__awaiter(this,void 0,void 0,(function(){var e,n=this;return o.__generator(this,(function(t){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{return e=""+this.url,null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),[2,new Promise((function(e,t){n.socket.binaryType="arraybuffer",n.socket.onopen=function(){return n._on_open(e,t)},n.socket.onmessage=function(e){return n._on_message(e)},n.socket.onclose=function(e){return n._on_close(e,t)},n.socket.onerror=function(){return n._on_error(t)}}))]}catch(e){throw s.logger.error("websocket creation failed to url: "+this.url),s.logger.error(" - "+e),e}return[2]}))}))},e.prototype.close=function(){this.closed_permanently||(s.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())},e.prototype._schedule_reconnect=function(e){var n=this;setTimeout((function(){n.closed_permanently||s.logger.info("Websocket connection "+n._number+" disconnected, will not attempt to reconnect")}),e)},e.prototype.send=function(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)},e.prototype.send_with_reply=function(e){return o.__awaiter(this,void 0,void 0,(function(){var n,t=this;return o.__generator(this,(function(o){switch(o.label){case 0:return[4,new Promise((function(n,o){t._pending_replies.set(e.msgid(),{resolve:n,reject:o}),t.send(e)}))];case 1:if("ERROR"===(n=o.sent()).msgtype())throw new Error("Error reply "+n.content.text);return[2,n]}}))}))},e.prototype._pull_doc_json=function(){return o.__awaiter(this,void 0,void 0,(function(){var e,n;return o.__generator(this,(function(t){switch(t.label){case 0:return e=i.Message.create("PULL-DOC-REQ",{}),[4,this.send_with_reply(e)];case 1:if(!("doc"in(n=t.sent()).content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return[2,n.content.doc]}}))}))},e.prototype._repull_session_doc=function(e,n){return o.__awaiter(this,void 0,void 0,(function(){var t,c,_,a,h,u,d,g,p;return o.__generator(this,(function(o){switch(o.label){case 0:s.logger.debug(this.session?"Repulling session":"Pulling session for first time"),o.label=1;case 1:return o.trys.push([1,3,,4]),[4,this._pull_doc_json()];case 2:if(c=o.sent(),null==this.session)if(this.closed_permanently)s.logger.debug("Got new document after connection was already closed"),n(new Error("The connection has been closed"));else{for(_=r.Document.from_json(c),(a=r.Document._compute_patch_since_json(c,_)).events.length>0&&(s.logger.debug("Sending "+a.events.length+" changes from model construction back to server"),h=i.Message.create("PATCH-DOC",{},a),this.send(h)),this.session=new l.ClientSession(this,_,this.id),u=0,d=this._pending_messages;u<d.length;u++)g=d[u],this.session.handle(g);this._pending_messages=[],s.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(c),s.logger.debug("Updated existing session with new pulled doc");return[3,4];case 3:return p=o.sent(),null===(t=console.trace)||void 0===t||t.call(console,p),s.logger.error("Failed to repull session "+p),n(p),[3,4];case 4:return[2]}}))}))},e.prototype._on_open=function(e,n){var t=this;s.logger.info("Websocket connection "+this._number+" is now open"),this._current_handler=function(o){t._awaiting_ack_handler(o,e,n)}},e.prototype._on_message=function(e){null==this._current_handler&&s.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(e.toString())}var n=this._receiver.message;if(null!=n){var t=n.problem();null!=t&&this._close_bad_protocol(t),this._current_handler(n)}},e.prototype._on_close=function(e,n){s.logger.info("Lost websocket "+this._number+" connection, "+e.code+" ("+e.reason+")"),this.socket=null,this._pending_replies.forEach((function(e){return e.reject("Disconnected")})),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),n(new Error("Lost websocket connection, "+e.code+" ("+e.reason+")"))},e.prototype._on_error=function(e){s.logger.debug("Websocket error on socket "+this._number);var n="Could not open websocket";s.logger.error("Failed to connect to Bokeh server: "+n),e(new Error(n))},e.prototype._close_bad_protocol=function(e){s.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)},e.prototype._awaiting_ack_handler=function(e,n,t){var o=this;"ACK"===e.msgtype()?(this._current_handler=function(e){return o._steady_state_handler(e)},this._repull_session_doc(n,t)):this._close_bad_protocol("First message was not an ACK")},e.prototype._steady_state_handler=function(e){var n=e.reqid(),t=this._pending_replies.get(n);t?(this._pending_replies.delete(n),t.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)},e}();t.ClientConnection=h,h.__name__="ClientConnection",t.pull_session=function(e,n,t){return new h(e,n,t).connect()}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});var n=e(133),s=function(){function e(e,t,r){this.header=e,this.metadata=t,this.content=r,this.buffers=[]}return e.assemble=function(t,r,n){return new e(JSON.parse(t),JSON.parse(r),JSON.parse(n))},e.prototype.assemble_buffer=function(e,t){if((null!=this.header.num_buffers?this.header.num_buffers:0)<=this.buffers.length)throw new Error("too many buffers received, expecting #{nb}");this.buffers.push([e,t])},e.create=function(t,r,n){void 0===n&&(n={});var s=e.create_header(t);return new e(s,r,n)},e.create_header=function(e){return{msgid:n.uniqueId(),msgtype:e}},e.prototype.complete=function(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(!("num_buffers"in this.header)||this.buffers.length===this.header.num_buffers)},e.prototype.send=function(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");var t=JSON.stringify(this.header),r=JSON.stringify(this.metadata),n=JSON.stringify(this.content);e.send(t),e.send(r),e.send(n)},e.prototype.msgid=function(){return this.header.msgid},e.prototype.msgtype=function(){return this.header.msgtype},e.prototype.reqid=function(){return this.header.reqid},e.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},e}();r.Message=s,s.__name__="Message"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var r=t(457),_=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=this._fragments.slice(0,3),s=e[0],_=e[1],i=e[2];this._partial=r.Message.assemble(s,_,i),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(t instanceof ArrayBuffer)throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t}();s.Receiver=_,_.__name__="Receiver"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});var o=e(1),i=e(113),r=e(457),c=e(178),s=function(){function e(e,t,n){var o=this;this._connection=e,this.document=t,this.id=n,this._document_listener=function(e){return o._document_changed(e)},this.document.on_change(this._document_listener)}return e.prototype.handle=function(e){var t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):c.logger.debug("Doing nothing with message "+e.msgtype())},e.prototype.close=function(){this._connection.close()},e.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},e.prototype.request_server_info=function(){return o.__awaiter(this,void 0,void 0,(function(){var e;return o.__generator(this,(function(t){switch(t.label){case 0:return e=r.Message.create("SERVER-INFO-REQ",{}),[4,this._connection.send_with_reply(e)];case 1:return[2,t.sent().content]}}))}))},e.prototype.force_roundtrip=function(){return o.__awaiter(this,void 0,void 0,(function(){return o.__generator(this,(function(e){switch(e.label){case 0:return[4,this.request_server_info()];case 1:return e.sent(),[2]}}))}))},e.prototype._document_changed=function(e){if(!(e.setter_id===this.id||e instanceof i.ModelChangedEvent&&!(e.attr in e.model.serializable_attributes()))){var t=r.Message.create("PATCH-DOC",{},this.document.create_json_patch([e]));this._connection.send(t)}},e.prototype._handle_patch=function(e){this.document.apply_json_patch(e.content,e.buffers,this.id)},e.prototype._handle_ok=function(e){c.logger.trace("Unhandled OK reply to "+e.reqid())},e.prototype._handle_error=function(e){c.logger.error("Unhandled ERROR reply to "+e.reqid()+": "+e.content.text)},e}();n.ClientSession=s,s.__name__="ClientSession"},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});var n=e(113),r=e(458),s=e(178),i=e(131),a=e(453),l=e(454);function u(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);var t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function c(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){s.logger.info("Registering Jupyter comms for target "+e);var n=Jupyter.notebook.kernel.comm_manager;try{n.register_target(e,(function(t){s.logger.info("Registering Jupyter comms for target "+e);var n=new r.Receiver;t.on_msg(u.bind(o,n))}))}catch(e){s.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else if(o.roots()[0].id in t.kernels){s.logger.info("Registering JupyterLab comms for target "+e);var i=t.kernels[o.roots()[0].id];try{i.registerCommTarget(e,(function(t){s.logger.info("Registering JupyterLab comms for target "+e);var n=new r.Receiver;t.onMsg=u.bind(o,n)}))}catch(e){s.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+e+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}e(387),e(461),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=i.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");for(var t=n.Document.from_json(i.values(e)[0]),r=0,s=o;r<s.length;r++){var u=s[r];null!=u.notebook_comms_target&&c(u.notebook_comms_target,t);var g=l._resolve_element(u),m=l._resolve_root_elements(u);a.add_document_standalone(t,g,m)}}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});var n=e(1);e(175),n.__importStar(e(174)).styles.append("/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n")},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);_.__exportStar(e(457),t),_.__exportStar(e(458),t)},
function _(e,t,n){function s(){var e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);var n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}Object.defineProperty(n,"__esModule",{value:!0}),n.results={},n.init=function(){s()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,s()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,s()}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0}),r.safely=function(e,t){void 0===t&&(t=!1);try{return e()}catch(e){if(function(e){var t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");var r=document.createElement("span");r.style.backgroundColor="#a94442",r.style.borderRadius="0px 4px 0px 0px",r.style.color="white",r.style.cursor="pointer",r.style.cssFloat="right",r.style.fontSize="0.8em",r.style.margin="-6px -6px 0px 0px",r.style.padding="2px 5px 4px 5px",r.title="close",r.setAttribute("aria-label","close"),r.appendChild(document.createTextNode("x")),r.addEventListener("click",(function(){return a.removeChild(t)}));var l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));var o=document.createElement("pre");o.style.whiteSpace="unset",o.style.overflowX="auto";var n=e instanceof Error?e.message:e;o.appendChild(document.createTextNode(n)),t.appendChild(r),t.appendChild(l),t.appendChild(o);var a=document.getElementsByTagName("body")[0];a.insertBefore(t,a.firstChild)}(e),t)return;throw e}}},
], 0, {"legacy":0,"polyfill":2,"main":109,"index":110,"version":111,"embed/index":112,"document/index":113,"document/document":114,"base":115,"core/util/types":116,"core/util/array":117,"core/util/math":118,"core/util/assert":119,"core/util/arrayable":120,"core/has_props":121,"core/signaling":122,"core/util/data_structures":123,"core/util/eq":124,"core/util/callback":125,"core/property_mixins":126,"core/properties":127,"core/enums":128,"core/util/color":129,"core/util/svg_colors":130,"core/util/object":131,"core/util/refs":132,"core/util/string":133,"core/settings":134,"models/index":135,"models/annotations/index":136,"models/annotations/annotation":137,"core/util/projections":138,"models/renderers/renderer":171,"core/dom_view":172,"core/view":173,"core/dom":174,"styles/root":175,"core/visuals":176,"model":177,"core/logging":178,"models/annotations/arrow":179,"models/annotations/arrow_head":180,"models/sources/column_data_source":181,"models/sources/columnar_data_source":182,"models/sources/data_source":183,"models/selections/selection":184,"core/selection_manager":185,"models/renderers/glyph_renderer":186,"models/renderers/data_renderer":187,"models/glyphs/line":188,"models/glyphs/xy_glyph":189,"core/util/spatial":190,"core/util/bbox":193,"models/glyphs/glyph":194,"core/hittest":195,"models/ranges/factor_range":196,"models/ranges/range":197,"models/glyphs/utils":198,"models/glyphs/patch":199,"models/glyphs/harea":200,"models/glyphs/area":201,"models/glyphs/varea":202,"models/sources/cds_view":203,"core/build_views":204,"models/renderers/graph_renderer":205,"models/graphs/graph_hit_test_policy":206,"models/selections/interaction_policy":207,"core/util/serialization":208,"core/util/compat":209,"core/util/typed_array":210,"document/events":211,"models/annotations/band":212,"models/annotations/box_annotation":213,"styles/annotations":214,"models/annotations/color_bar":215,"models/tickers/basic_ticker":216,"models/tickers/adaptive_ticker":217,"models/tickers/continuous_ticker":218,"models/tickers/ticker":219,"models/formatters/basic_tick_formatter":220,"models/formatters/tick_formatter":221,"models/mappers/linear_color_mapper":222,"models/mappers/continuous_color_mapper":223,"models/mappers/color_mapper":224,"models/mappers/mapper":225,"models/transforms/transform":226,"models/scales/linear_scale":227,"models/scales/continuous_scale":228,"models/scales/scale":229,"models/transforms/index":230,"models/transforms/customjs_transform":231,"models/transforms/dodge":232,"models/transforms/interpolator":233,"models/transforms/jitter":234,"models/transforms/linear_interpolator":235,"models/transforms/step_interpolator":236,"models/scales/log_scale":237,"models/ranges/range1d":238,"core/util/text":239,"models/annotations/label":240,"models/annotations/text_annotation":241,"models/annotations/label_set":242,"models/annotations/legend":243,"models/annotations/legend_item":244,"core/vectorization":245,"models/annotations/poly_annotation":246,"models/annotations/slope":247,"models/annotations/span":248,"models/annotations/title":249,"models/annotations/toolbar_panel":250,"models/annotations/tooltip":251,"styles/tooltips":252,"styles/mixins":253,"models/annotations/whisker":254,"models/axes/index":255,"models/axes/axis":256,"models/renderers/guide_renderer":257,"models/axes/categorical_axis":258,"models/tickers/categorical_ticker":259,"models/formatters/categorical_tick_formatter":260,"models/axes/continuous_axis":261,"models/axes/datetime_axis":262,"models/axes/linear_axis":263,"models/formatters/datetime_tick_formatter":264,"core/util/templating":266,"models/tickers/datetime_ticker":269,"models/tickers/composite_ticker":270,"models/tickers/days_ticker":271,"models/tickers/single_interval_ticker":272,"models/tickers/util":273,"models/tickers/months_ticker":274,"models/tickers/years_ticker":275,"models/axes/log_axis":276,"models/formatters/log_tick_formatter":277,"models/tickers/log_ticker":278,"models/axes/mercator_axis":279,"models/formatters/mercator_tick_formatter":280,"models/tickers/mercator_ticker":281,"models/callbacks/index":282,"models/callbacks/customjs":283,"models/callbacks/callback":284,"models/callbacks/open_url":285,"models/canvas/index":286,"models/canvas/canvas":287,"core/util/canvas":288,"styles/canvas":289,"models/canvas/cartesian_frame":291,"models/scales/categorical_scale":292,"models/ranges/data_range1d":293,"models/ranges/data_range":294,"core/layout/index":295,"core/layout/types":296,"core/layout/layoutable":297,"core/layout/alignments":298,"core/layout/grid":299,"core/layout/html":300,"models/expressions/index":301,"models/expressions/expression":302,"models/expressions/stack":303,"models/expressions/cumsum":304,"models/filters/index":305,"models/filters/boolean_filter":306,"models/filters/filter":307,"models/filters/customjs_filter":308,"models/filters/group_filter":309,"models/filters/index_filter":310,"models/formatters/index":311,"models/formatters/func_tick_formatter":312,"models/formatters/numeral_tick_formatter":313,"models/formatters/printf_tick_formatter":314,"models/glyphs/index":315,"models/glyphs/annular_wedge":316,"models/glyphs/annulus":317,"models/glyphs/arc":318,"models/glyphs/bezier":319,"models/glyphs/circle":320,"models/glyphs/center_rotatable":321,"models/glyphs/ellipse":322,"models/glyphs/ellipse_oval":323,"models/glyphs/hbar":324,"models/glyphs/box":325,"models/glyphs/hex_tile":326,"models/glyphs/image":327,"models/glyphs/image_base":328,"models/glyphs/image_rgba":329,"models/glyphs/image_url":330,"core/util/image":331,"models/glyphs/multi_line":332,"models/glyphs/multi_polygons":333,"models/glyphs/oval":334,"models/glyphs/patches":335,"models/glyphs/quad":336,"models/glyphs/quadratic":337,"models/glyphs/ray":338,"models/glyphs/rect":339,"models/glyphs/segment":340,"models/glyphs/step":341,"models/glyphs/text":342,"models/glyphs/vbar":343,"models/glyphs/wedge":344,"models/graphs/index":345,"models/graphs/layout_provider":346,"models/graphs/static_layout_provider":347,"models/grids/index":348,"models/grids/grid":349,"models/layouts/index":350,"models/layouts/box":351,"models/layouts/layout_dom":352,"models/layouts/column":353,"models/layouts/grid_box":354,"models/layouts/html_box":355,"models/layouts/row":356,"models/layouts/spacer":357,"models/layouts/tabs":358,"styles/tabs":359,"styles/buttons":360,"styles/menus":361,"models/layouts/widget_box":362,"models/mappers/index":363,"models/mappers/categorical_color_mapper":364,"models/mappers/categorical_mapper":365,"models/mappers/categorical_marker_mapper":366,"models/mappers/categorical_pattern_mapper":367,"models/mappers/log_color_mapper":368,"models/markers/index":369,"models/markers/defs":370,"models/markers/marker":371,"models/markers/scatter":372,"models/plots/index":373,"models/plots/gmap_plot":374,"models/plots/plot":375,"models/tools/toolbar":376,"models/tools/inspectors/inspect_tool":377,"models/tools/button_tool":378,"models/tools/tool":379,"styles/toolbar":380,"models/tools/on_off_button":381,"models/tools/toolbar_base":382,"models/tools/gestures/gesture_tool":383,"models/tools/actions/action_tool":384,"models/tools/actions/help_tool":385,"styles/icons":386,"styles/logo":387,"models/plots/plot_canvas":388,"core/bokeh_events":389,"core/ui_events":390,"core/util/wheel":392,"core/util/throttle":393,"core/layout/side_panel":394,"models/plots/gmap_plot_canvas":395,"models/ranges/index":396,"models/renderers/index":397,"models/scales/index":398,"models/selections/index":399,"models/sources/index":400,"models/sources/server_sent_data_source":401,"models/sources/web_data_source":402,"models/sources/ajax_data_source":403,"models/sources/geojson_data_source":404,"models/tickers/index":405,"models/tickers/fixed_ticker":406,"models/tiles/index":407,"models/tiles/bbox_tile_source":408,"models/tiles/mercator_tile_source":409,"models/tiles/tile_source":410,"models/tiles/tile_utils":411,"models/tiles/quadkey_tile_source":412,"models/tiles/tile_renderer":413,"models/tiles/wmts_tile_source":414,"styles/tiles":415,"models/tiles/tms_tile_source":416,"models/textures/index":417,"models/textures/canvas_texture":418,"models/textures/texture":419,"models/textures/image_url_texture":420,"models/tools/index":421,"models/tools/actions/custom_action":422,"models/tools/actions/redo_tool":423,"models/tools/actions/reset_tool":424,"models/tools/actions/save_tool":425,"models/tools/actions/undo_tool":426,"models/tools/actions/zoom_in_tool":427,"core/util/zoom":428,"models/tools/actions/zoom_out_tool":429,"models/tools/edit/edit_tool":430,"models/tools/edit/box_edit_tool":431,"models/tools/edit/freehand_draw_tool":432,"models/tools/edit/point_draw_tool":433,"models/tools/edit/poly_draw_tool":434,"models/tools/edit/poly_tool":435,"models/tools/edit/poly_edit_tool":436,"models/tools/gestures/box_select_tool":437,"models/tools/gestures/select_tool":438,"models/tools/util":439,"models/tools/gestures/box_zoom_tool":440,"models/tools/gestures/lasso_select_tool":441,"models/tools/gestures/pan_tool":442,"models/tools/gestures/poly_select_tool":443,"models/tools/gestures/range_tool":444,"models/tools/gestures/tap_tool":445,"models/tools/gestures/wheel_pan_tool":446,"models/tools/gestures/wheel_zoom_tool":447,"models/tools/inspectors/crosshair_tool":448,"models/tools/inspectors/customjs_hover":449,"models/tools/inspectors/hover_tool":450,"models/tools/tool_proxy":451,"models/tools/toolbar_box":452,"embed/standalone":453,"embed/dom":454,"embed/server":455,"client/connection":456,"protocol/message":457,"protocol/receiver":458,"client/session":459,"embed/notebook":460,"styles/notebook":461,"protocol/index":462,"testing":463,"safely":464}, {});
})

