from typing import Any

FUSION_VERSION_COMPATIBILITY_OUTPUT: dict[str, dict[str, Any]] = {
    "1997mahadi/crypto_dlt_pipeline": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.0.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "1997mahadi/my_dbt_project": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Aaron-Zhou/synapse_statistic": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "Aidbox/aidbox": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "AltimateAI/altimate_snowflake_query_tags": {
        "latest_version": "=1.0.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0", "=1.0.1", "=1.0.2"],
        "package_latest_version_index_json": "=1.0.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.2",
    },
    "AxelThevenot/dbt_assertions": {
        "latest_version": "=1.8.3",
        "oldest_fusion_compatible_version": "=1.8.2",
        "latest_fusion_compatible_version": "=1.8.3",
        "fusion_compatible_versions": ["=1.8.2", "=1.8.3"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.3.0",
            "=1.4.0",
            "=1.5.0",
            "=1.5.1",
            "=1.6.0",
            "=1.7.0",
            "=1.8.0",
            "=1.8.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.8.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.8.3",
    },
    "AxelThevenot/dbt_star": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "BfdCampos/source_db": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.3", "=0.1.4", "=0.1.5"],
        "unknown_compatibility_versions": ["=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "Datavault-UK/automate_dv": {
        "latest_version": "=0.11.4",
        "oldest_fusion_compatible_version": "=0.11.4",
        "latest_fusion_compatible_version": "=0.11.4",
        "fusion_compatible_versions": ["=0.11.4"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.11.3",
            "=0.4.1",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6-b1",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.7.9",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
            "=0.9.5",
            "=0.9.6",
            "=0.9.7",
        ],
        "unknown_compatibility_versions": [
            "=0.2.1-pre",
            "=0.2.2-pre",
            "=0.2.3-pre",
            "=0.2.4-pre",
            "=0.3.1-pre",
            "=0.3.2-pre",
            "=0.3.3-pre",
        ],
        "package_latest_version_index_json": "=0.11.4",
        "package_redirect_name": "automate_dv",
        "package_redirect_namespace": "Datavault-UK",
        "latest_version_incl_prerelease": "=0.11.4",
        "package_redirect_id": "Datavault-UK/automate_dv",
    },
    "Datomni/ga4_metrics": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.2.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "Datomni/profitwell_metrics": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.1"],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "Delphi-Data/natural_language": {
        "latest_version": "=0.0.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.0", "=0.0.1", "=0.0.2", "=0.0.3"],
        "package_latest_version_index_json": "=0.0.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.3",
    },
    "Divergent-Insights/dbt_dataquality": {
        "latest_version": "=0.3.5",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.5",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.5",
    },
    "Divergent-Insights/snowflake_env_setup": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "EqualExperts/dbt_unit_testing": {
        "latest_version": "=0.4.20",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.4.20",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.4.0",
            "=0.4.1",
            "=0.4.11",
            "=0.4.12",
            "=0.4.2",
            "=0.4.20",
            "=0.4.3",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.20",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.20",
    },
    "Fleetio/dbt_segment": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.3.1", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": "dbt_segment",
        "package_redirect_namespace": "Fleetio",
        "latest_version_incl_prerelease": "=0.4.0",
        "package_redirect_id": "Fleetio/dbt_segment",
    },
    "GJMcClintock/dbt_tld": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "LewisDavies/upstream_prod": {
        "latest_version": "=0.9.8",
        "oldest_fusion_compatible_version": "=0.9.6",
        "latest_fusion_compatible_version": "=0.9.8",
        "fusion_compatible_versions": ["=0.9.6", "=0.9.7", "=0.9.8"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
            "=0.9.5",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1"],
        "package_latest_version_index_json": "=0.9.8",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.9.8",
    },
    "M-KOPA/insert_by_timeperiod": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.2.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "Matatika/tap_google_analytics": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.4.0"],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.3.0"],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.0",
    },
    "Matatika/tap_googleads": {
        "latest_version": "=0.6.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.3.0", "=0.4.0", "=0.5.0", "=0.6.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.0",
    },
    "Matatika/tap_meltano": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.3.0", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.0",
    },
    "Matatika/tap_solarvista": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.0",
    },
    "Matatika/tap_spotify": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.4.0"],
        "unknown_compatibility_versions": ["=0.3.0"],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.0",
    },
    "Matatika/tap_trello": {
        "latest_version": "=0.5.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.3.0", "=0.4.0", "=0.5.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.0",
    },
    "MaterializeInc/materialize_dbt_utils": {
        "latest_version": "=0.7.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.3.0", "=0.4.0", "=0.5.0"],
        "fusion_incompatible_versions": ["=0.6.0", "=0.7.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.7.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.7.0",
    },
    "Matts52/dbt_ml_eval": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.1.1"],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "Matts52/dbt_ml_inline_preprocessing": {
        "latest_version": "=0.2.8",
        "oldest_fusion_compatible_version": "=0.2.8",
        "latest_fusion_compatible_version": "=0.2.8",
        "fusion_compatible_versions": ["=0.2.8"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.8",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.8",
    },
    "Matts52/dbt_set_similarity": {
        "latest_version": "=0.2.2",
        "oldest_fusion_compatible_version": "=0.2.2",
        "latest_fusion_compatible_version": "=0.2.2",
        "fusion_compatible_versions": ["=0.2.2"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.2.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.2",
    },
    "Matts52/dbt_stat_test": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": "=0.1.2",
        "latest_fusion_compatible_version": "=0.1.2",
        "fusion_compatible_versions": ["=0.1.2"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "Montreal-Analytics/snowflake_utils": {
        "latest_version": "=0.6.3",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.6.3",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.3",
    },
    "Saras-Daton/Aftership": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Saras-Daton/AmazonAds": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.0.3",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.0",
    },
    "Saras-Daton/AmazonDSP": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.0.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "Saras-Daton/AmazonSellerCentral": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=1.0.0",
            "=1.1.2",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.1",
            "=1.1.2",
            "=1.1.3",
            "=1.1.4",
            "=1.1.5",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.0",
    },
    "Saras-Daton/AmazonVendorCentral": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.0.1", "=1.1.2", "=1.2.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.0",
    },
    "Saras-Daton/BingAds": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.1",
    },
    "Saras-Daton/FacebookAds": {
        "latest_version": "=1.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1", "=1.1.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.2",
    },
    "Saras-Daton/GoogleAds": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.1",
    },
    "Saras-Daton/GoogleAnalytics": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Saras-Daton/Recharge": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Saras-Daton/Shopify": {
        "latest_version": "=1.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1", "=1.1.2", "=1.1.3", "=1.1.4", "=1.1.5"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.5",
    },
    "Saras-Daton/Unicommerce": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.1",
    },
    "Saras-Daton/Upscribe": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Saras-Daton/Walmart": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.0",
    },
    "Saras-Daton/currency_exchange_rates": {
        "latest_version": "=1.1.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.0.0", "=1.0.1", "=1.0.2", "=1.0.3", "=1.1.3"],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.3",
    },
    "Saras-Daton/edm_data_transformation": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Saras-Daton/facebook_ads": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.1",
    },
    "Saras-Daton/klaviyo-fivetran-to-daton": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "ScalefreeCOM/datavault4dbt": {
        "latest_version": "=1.13.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=1.0.0",
            "=1.0.1",
            "=1.0.10",
            "=1.0.11",
            "=1.0.12",
            "=1.0.13",
            "=1.0.14",
            "=1.0.15",
            "=1.0.16",
            "=1.0.17",
            "=1.0.2",
            "=1.0.3",
            "=1.0.4",
            "=1.0.5",
            "=1.0.6",
            "=1.0.7",
            "=1.0.8",
            "=1.0.9",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.1.3",
            "=1.1.4",
            "=1.1.5",
            "=1.10.0",
            "=1.11.0",
            "=1.12.0",
            "=1.12.1",
            "=1.12.2",
            "=1.12.3",
            "=1.12.4",
            "=1.12.5",
            "=1.13.0",
            "=1.2.0",
            "=1.2.1",
            "=1.2.2",
            "=1.3.0",
            "=1.3.1",
            "=1.3.2",
            "=1.3.3",
            "=1.4.0",
            "=1.4.1",
            "=1.4.2",
            "=1.5.0",
            "=1.6.0",
            "=1.7.0",
            "=1.7.1",
            "=1.7.2",
            "=1.8.0",
            "=1.8.1",
            "=1.9.0",
            "=1.9.1",
            "=1.9.10",
            "=1.9.11",
            "=1.9.12",
            "=1.9.2",
            "=1.9.3",
            "=1.9.4",
            "=1.9.5",
            "=1.9.6",
            "=1.9.7",
            "=1.9.8",
            "=1.9.9",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.13.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.13.0",
    },
    "Snowflake-Labs/dbt_constraints": {
        "latest_version": "=1.0.7",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.0.7",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.0.3",
            "=1.0.4",
            "=1.0.5",
            "=1.0.6",
            "=1.0.7",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.7",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.7",
    },
    "Snowflake-Labs/dbt_semantic_view": {
        "latest_version": "=1.0.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=1.0.0", "=1.0.1", "=1.0.2", "=1.0.3"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.3",
    },
    "TasmanAnalytics/tasman_dbt_mta": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.0",
    },
    "TasmanAnalytics/tasman_dbt_package": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "TasmanAnalytics/tasman_dbt_revenuecat": {
        "latest_version": "=1.2.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.0.1",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0",
            "=1.2.1",
            "=1.2.2",
            "=1.2.3",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.3",
    },
    "TasmanAnalytics/tasman_identity_graph": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "Teradata/teradata_utils": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.1", "=0.0.2", "=0.1.0", "=1.1.1", "=1.2.0", "=1.3.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.0",
    },
    "Velir/ga4": {
        "latest_version": "=6.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0-initial-release",
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=1.0.0",
            "=2.0.0",
            "=2.0.1",
            "=3.0.0",
            "=3.0.1",
            "=3.1.0",
            "=3.2.0",
            "=3.2.1",
            "=4.0.0",
            "=5.0.0",
            "=5.1.0",
            "=5.1.1",
            "=6.0.0",
            "=6.0.1",
            "=6.0.2",
            "=6.1.0",
        ],
        "package_latest_version_index_json": "=6.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=6.1.0",
    },
    "YukiTechnologies/yuki_snowflake_dbt_tags": {
        "latest_version": "=0.2.5",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.2.5",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.2.2", "=0.2.3", "=0.2.5", "=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.2.4"],
        "package_latest_version_index_json": "=0.2.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.5",
    },
    "alittlesliceoftom/insert_by_timeperiod": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.2.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "andrewcstewart/uaparser": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "arnoN7/incr_stream": {
        "latest_version": "=1.3.1",
        "oldest_fusion_compatible_version": "=0.0.3",
        "latest_fusion_compatible_version": "=1.3.1",
        "fusion_compatible_versions": ["=0.0.3", "=1.0.0", "=1.0.2", "=1.1.0", "=1.2.0", "=1.2.1", "=1.3.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.1", "=0.0.2"],
        "package_latest_version_index_json": "=1.3.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.1",
    },
    "avohq/avo_audit": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.2.0", "=1.0.0", "=1.0.1"],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "bcodell/dbt_activity_schema": {
        "latest_version": "=0.5.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.3",
    },
    "bqbooster/dbt_bigquery_monitoring": {
        "latest_version": "=0.23.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.11.0",
            "=0.11.1",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.14.1",
            "=0.14.2",
            "=0.14.3",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2",
            "=0.18.0",
            "=0.18.1",
            "=0.18.2",
            "=0.18.3",
            "=0.18.4",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.19.3",
            "=0.20.0",
            "=0.20.1",
            "=0.20.2",
            "=0.20.3",
            "=0.20.4",
            "=0.21.0",
            "=0.22.0",
            "=0.23.0",
            "=0.23.1",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.2.0", "=0.3.0"],
        "package_latest_version_index_json": "=0.23.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.23.1",
    },
    "brooklyn-data/dbt_artifacts": {
        "latest_version": "=2.10.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=2.10.0",
        "fusion_compatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.2.0",
            "=2.0.0",
            "=2.1.0",
            "=2.1.1",
            "=2.10.0",
            "=2.2.0",
            "=2.2.1",
            "=2.2.2",
            "=2.2.3",
            "=2.3.0",
        ],
        "fusion_incompatible_versions": [
            "=2.4.0",
            "=2.4.1",
            "=2.4.2",
            "=2.4.3",
            "=2.5.0",
            "=2.6.0",
            "=2.6.1",
            "=2.6.2",
            "=2.6.3",
            "=2.6.4",
            "=2.7.0",
            "=2.8.0",
            "=2.9.0",
            "=2.9.1",
            "=2.9.2",
            "=2.9.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=2.10.0",
        "package_redirect_name": "dbt_artifacts",
        "package_redirect_namespace": "brooklyn-data",
        "latest_version_incl_prerelease": "=2.10.0",
        "package_redirect_id": "brooklyn-data/dbt_artifacts",
    },
    "calum-mcg/fuzzy_text": {
        "latest_version": "=0.0.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.3", "=0.0.4", "=0.0.5"],
        "unknown_compatibility_versions": ["=0.0.1", "=0.0.2"],
        "package_latest_version_index_json": "=0.0.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.5",
    },
    "cerebriumai/airbyte_facebook_ads": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "cerebriumai/airbyte_github": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": "airbyte_github",
        "package_redirect_namespace": "cerebriumai",
        "latest_version_incl_prerelease": "=0.2.0",
        "package_redirect_id": "cerebriumai/airbyte_github",
    },
    "cerebriumai/airbyte_google_ads": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "cerebriumai/airbyte_intercom": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "cerebriumai/airbyte_pipedrive": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "cerebriumai/airbyte_shopify": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "cerebriumai/airbyte_stripe": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.0",
        "fusion_compatible_versions": ["=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "creativeautomation/airbyte_shopify": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.1", "=0.1.0"],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "data-diving/dbt_diving": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=1.0.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=1.0.0", "=1.1.0", "=1.1.1", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.1",
    },
    "data-mie/dbt_profiler": {
        "latest_version": "=0.8.4",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.8.4",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.8.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.8.4",
    },
    "datalakehouse/dlh_quickbooks": {
        "latest_version": "=0.1.6",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.6",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5", "=0.1.6"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.6",
    },
    "datalakehouse/dlh_salesforce": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.5",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "datalakehouse/dlh_square": {
        "latest_version": "=0.1.4",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.4",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.4",
    },
    "datalakehouse/dlh_stripe": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "datalakehouse/dlh_xero": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=0.1.5",
        "fusion_compatible_versions": ["=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "datnguye/dbt_translate": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.0.1",
        "fusion_compatible_versions": ["=0.1.0", "=1.0.0", "=1.0.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "datooine/dbt_buckets": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dbt-labs/adwords": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": "=0.2.11",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": ["=0.2.11", "=0.2.12", "=0.3.0"],
        "fusion_incompatible_versions": ["=0.4.0"],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.2.0",
            "=0.2.1",
            "=0.2.10",
            "=0.2.2",
            "=0.2.2-a",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.2.2-a",
        ],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": "adwords",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.4.0",
        "package_redirect_id": "dbt-labs/adwords",
    },
    "dbt-labs/audit_helper": {
        "latest_version": "=0.12.2",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.12.2",
        "fusion_compatible_versions": [
            "=0.0.1",
            "=0.0.2",
            "=0.0.6",
            "=0.1.0",
            "=0.12.2",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.0.3",
            "=0.0.4",
            "=0.0.5",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=0.11.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.12.2",
        "package_redirect_name": "audit_helper",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.12.2",
        "package_redirect_id": "dbt-labs/audit_helper",
    },
    "dbt-labs/codegen": {
        "latest_version": "=0.14.0",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.14.0",
        "fusion_compatible_versions": [
            "=0.0.1",
            "=0.0.2",
            "=0.1.0",
            "=0.14.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.0.3",
            "=0.0.4",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.13.0",
            "=0.13.1",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.13.0-b1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.14.0",
        "package_redirect_name": "codegen",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.14.0",
        "package_redirect_id": "dbt-labs/codegen",
    },
    "dbt-labs/dbt_external_tables": {
        "latest_version": "=0.12.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.12.0",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.12.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.7.0",
            "=0.7.1",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0-b1",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.11.1",
            "=0.7.2",
            "=0.7.3",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.8.7",
            "=0.9.0-b1",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.12.0",
        "package_redirect_name": "dbt_external_tables",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.12.0",
        "package_redirect_id": "dbt-labs/dbt_external_tables",
    },
    "dbt-labs/dbt_project_evaluator": {
        "latest_version": "=1.1.2",
        "oldest_fusion_compatible_version": "=1.1.2",
        "latest_fusion_compatible_version": "=1.1.2",
        "fusion_compatible_versions": ["=1.1.2"],
        "fusion_incompatible_versions": [
            "=0.2.1",
            "=0.5.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.14.2",
            "=0.14.3",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.2",
    },
    "dbt-labs/dbt_utils": {
        "latest_version": "=1.3.3",
        "oldest_fusion_compatible_version": "=0.1.23",
        "latest_fusion_compatible_version": "=1.3.3",
        "fusion_compatible_versions": [
            "=0.1.23",
            "=0.1.24",
            "=0.1.25",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=1.3.2",
            "=1.3.3",
        ],
        "fusion_incompatible_versions": [
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4-b1",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.5",
            "=0.9.6",
            "=1.0.0-b1",
            "=1.0.0-b2",
            "=1.0.0-rc1",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0-rc1",
            "=1.2.0",
            "=1.3.0",
            "=1.3.1",
        ],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.1.0",
            "=0.1.1",
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.13",
            "=0.1.14",
            "=0.1.15",
            "=0.1.16",
            "=0.1.17",
            "=0.1.18",
            "=0.1.19",
            "=0.1.2",
            "=0.1.20",
            "=0.1.21",
            "=0.1.22",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
        ],
        "package_latest_version_index_json": "=1.3.3",
        "package_redirect_name": "dbt_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=1.3.3",
        "package_redirect_id": "dbt-labs/dbt_utils",
    },
    "dbt-labs/facebook_ads": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.7.0",
        "fusion_compatible_versions": ["=0.6.0", "=0.6.1", "=0.7.0", "=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": ["=0.7.1", "=0.8.0", "=0.9.0"],
        "unknown_compatibility_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.1.0",
            "=0.1.5",
            "=0.1.6",
        ],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.9.0",
        "package_redirect_id": "dbt-labs/facebook_ads",
    },
    "dbt-labs/logging": {
        "latest_version": "=0.8.0",
        "oldest_fusion_compatible_version": "=0.1.7",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": [
            "=0.1.7",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
        ],
        "fusion_incompatible_versions": ["=0.5.1", "=0.6.0", "=0.7.0", "=0.8.0"],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5", "=0.1.6"],
        "package_latest_version_index_json": "=0.8.0",
        "package_redirect_name": "logging",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.8.0",
        "package_redirect_id": "dbt-labs/logging",
    },
    "dbt-labs/metrics": {
        "latest_version": "=1.5.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=1.3.0-rc1",
            "=1.3.0",
            "=1.3.1",
            "=1.3.2",
            "=1.4.0-a1",
            "=1.4.0",
            "=1.4.1",
            "=1.5.0",
            "=1.5.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.5.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.5.1",
    },
    "dbt-labs/redshift": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=0.4.0", "=0.4.1", "=0.5.0"],
        "fusion_incompatible_versions": ["=0.5.1", "=0.6.0", "=0.6.1", "=0.7.0", "=0.8.0", "=0.9.0"],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.0.1",
            "=0.1.0",
        ],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": "redshift",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.9.0",
        "package_redirect_id": "dbt-labs/redshift",
    },
    "dbt-labs/snowplow": {
        "latest_version": "=0.15.1",
        "oldest_fusion_compatible_version": "=0.9.0",
        "latest_fusion_compatible_version": "=0.13.2",
        "fusion_compatible_versions": ["=0.10.0", "=0.11.0", "=0.12.0", "=0.13.0", "=0.13.1", "=0.13.2", "=0.9.0"],
        "fusion_incompatible_versions": ["=0.13.3", "=0.14.0", "=0.15.0", "=0.15.1"],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.3.8",
            "=0.3.9",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
        ],
        "package_latest_version_index_json": "=0.15.1",
        "package_redirect_name": "snowplow",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.15.1",
        "package_redirect_id": "dbt-labs/snowplow",
    },
    "dbt-labs/spark_utils": {
        "latest_version": "=0.3.3",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.3",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.2.2", "=0.2.3", "=0.3.1", "=0.3.3"],
        "fusion_incompatible_versions": ["=0.2.4", "=0.3.0", "=0.3.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.3",
        "package_redirect_name": "spark_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.3.3",
        "package_redirect_id": "dbt-labs/spark_utils",
    },
    "dbt-labs/stitch_utils": {
        "latest_version": "=0.5.0",
        "oldest_fusion_compatible_version": "=0.1.2",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": [
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
        ],
        "fusion_incompatible_versions": ["=0.3.1", "=0.4.0", "=0.4.1", "=0.4.2", "=0.5.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.0",
        "package_redirect_name": "stitch_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.5.0",
        "package_redirect_id": "dbt-labs/stitch_utils",
    },
    "dbt-msft/tsql_utils": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.6.4",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": [
            "=0.10.0",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.6.7",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.2.0",
    },
    "dlt-hub/asana": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dlt-hub/chess_pipeline": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.5", "=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "dlt-hub/dlt_zendesk_pipeline": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dlt-hub/freshdesk_pipeline": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.5"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "dlt-hub/ga4_event_export": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dlt-hub/github_events": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dlt-hub/hubspot": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.5"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "dlt-hub/jira_pipeline": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "dlt-hub/personio": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "dlt-hub/pipedrive": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.5"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "dlt-hub/salesforce": {
        "latest_version": "=0.2.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.2.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.2",
    },
    "dlt-hub/shopify": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.1", "=0.1.5"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "dlt-hub/stripe_analytics": {
        "latest_version": "=0.2.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.1",
    },
    "dlt-hub/workable": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "dwreeves/dbt_linreg": {
        "latest_version": "=0.3.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
            "=0.3.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.1",
    },
    "dwreeves/dbt_pca": {
        "latest_version": "=0.0.6",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.1", "=0.0.2", "=0.0.3", "=0.0.4", "=0.0.5", "=0.0.6"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.0.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.6",
    },
    "edanalytics/dbt_synth_data": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "edanalytics/edu_edfi_source": {
        "latest_version": "=0.5.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.2.1",
            "=0.2.10",
            "=0.2.11",
            "=0.2.12",
            "=0.2.13",
            "=0.2.14",
            "=0.2.15",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0-rc1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.4.0",
            "=0.4.1",
            "=0.4.10",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.4.8",
            "=0.4.9",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.2.0", "=0.1.0"],
        "package_latest_version_index_json": "=0.5.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.3",
    },
    "edanalytics/edu_wh": {
        "latest_version": "=0.5.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.2.1",
            "=0.2.10",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1-rc2", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.2.0"],
        "package_latest_version_index_json": "=0.5.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.3",
    },
    "elementary-data/elementary": {
        "latest_version": "=0.21.0",
        "oldest_fusion_compatible_version": "=0.21.0",
        "latest_fusion_compatible_version": "=0.21.0",
        "fusion_compatible_versions": ["=0.21.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.16.0",
            "=0.16.1",
            "=0.16.2",
            "=0.16.3",
            "=0.16.4",
            "=0.17.0",
            "=0.18.0",
            "=0.18.1",
            "=0.18.2",
            "=0.18.3",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.19.3",
            "=0.19.4",
            "=0.2.0",
            "=0.2.1",
            "=0.20.0",
            "=0.20.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.10",
            "=0.3.11",
            "=0.3.12",
            "=0.3.13",
            "=0.3.14",
            "=0.3.15",
            "=0.3.16",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.3.8",
            "=0.3.9",
            "=0.4.0",
            "=0.4.1",
            "=0.4.10",
            "=0.4.11",
            "=0.4.12",
            "=0.4.2",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.4.8",
            "=0.4.9",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.6.0",
            "=0.6.1",
            "=0.6.10",
            "=0.6.11",
            "=0.6.12",
            "=0.6.13",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.6.7",
            "=0.6.8",
            "=0.6.9",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.21.0",
        "package_redirect_name": "elementary",
        "package_redirect_namespace": "elementary-data",
        "latest_version_incl_prerelease": "=0.21.0",
        "package_redirect_id": "elementary-data/elementary",
    },
    "emilyriederer/dbtplyr": {
        "latest_version": "=0.3.3",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=0.3.3",
        "fusion_compatible_versions": ["=0.1.1", "=0.2.0", "=0.3.0", "=0.3.1", "=0.3.2", "=0.3.3"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.3.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.3",
    },
    "entechlog/dbt_snow_mask": {
        "latest_version": "=0.2.7",
        "oldest_fusion_compatible_version": "=0.1.8",
        "latest_fusion_compatible_version": "=0.2.7",
        "fusion_compatible_versions": [
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
        ],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.7",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.7",
    },
    "entechlog/dbt_snow_utils": {
        "latest_version": "=0.2.5",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.2.5",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.5",
    },
    "everpeace/dbt_models_metadata": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.1", "=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "fal-ai/feature_store": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "firebolt-db/dbt_artifacts_firebolt": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "fishtown-analytics/bing-ads": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.1", "=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "fishtown-analytics/bing_ads": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.1", "=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5"],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "fishtown-analytics/dbt-event-logging": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5"],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "fishtown-analytics/fishtown_analytics_ecommerce": {
        "latest_version": "=0.2.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.1",
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
        ],
        "package_latest_version_index_json": "=0.2.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.1",
    },
    "fishtown-analytics/heap": {
        "latest_version": "=0.2.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
        ],
        "package_latest_version_index_json": "=0.2.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.2",
    },
    "fishtown-analytics/outbrain": {
        "latest_version": "=0.1.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5"],
        "package_latest_version_index_json": "=0.1.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.5",
    },
    "fishtown-analytics/purecloud": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "fishtown-analytics/quickbooks": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.0"],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "fishtown-analytics/recurly": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "fishtown-analytics/shopify": {
        "latest_version": "=0.1.6",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5", "=0.1.6"],
        "package_latest_version_index_json": "=0.1.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.6",
    },
    "fishtown-analytics/stripe": {
        "latest_version": "=0.3.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.2.1", "=0.3.0", "=0.3.1"],
        "package_latest_version_index_json": "=0.3.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.1",
    },
    "fishtown-analytics/taboola": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "fishtown-analytics/zendesk": {
        "latest_version": "=0.1.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3"],
        "package_latest_version_index_json": "=0.1.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.3",
    },
    "fivetran/ad_reporting": {
        "latest_version": "=2.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=2.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.4.0", "=0.4.1", "=0.5.0", "=0.5.1", "=2.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.6.0-b1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.0.3",
            "=1.0.4",
            "=1.1.0",
            "=1.10.0",
            "=1.11.0",
            "=1.12.0",
            "=1.13.0",
            "=1.14.0",
            "=1.15.0",
            "=1.16.0",
            "=1.17.0",
            "=1.2.0",
            "=1.2.1",
            "=1.3.0",
            "=1.3.1",
            "=1.4.0",
            "=1.5.0",
            "=1.6.0",
            "=1.6.1",
            "=1.7.0",
            "=1.7.1",
            "=1.8.0",
            "=1.9.0",
            "=2.0.0",
            "=2.0.1",
            "=2.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=2.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=2.2.0",
    },
    "fivetran/amazon_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "amazon_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/amazon_ads",
    },
    "fivetran/amazon_selling_partner": {
        "latest_version": "=0.3.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": ["=0.3.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.2.1", "=0.2.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.0",
    },
    "fivetran/amplitude": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0-a1",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "amplitude",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/amplitude",
    },
    "fivetran/app_reporting": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.0",
    },
    "fivetran/apple_search_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "apple_search_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/apple_search_ads",
    },
    "fivetran/apple_store": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0-a1",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "apple_store",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/apple_store",
    },
    "fivetran/asana": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.4.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "asana",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/asana",
    },
    "fivetran/aws_cloud_cost": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.2.0"],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "fivetran/dynamics_365_crm": {
        "latest_version": "=0.1.0-b4",
        "oldest_fusion_compatible_version": "=0.1.0-b4",
        "latest_fusion_compatible_version": "=0.1.0-b4",
        "fusion_compatible_versions": ["=0.1.0-b4"],
        "fusion_incompatible_versions": ["=0.1.0-a1", "=0.1.0-a2", "=0.1.0-b1", "=0.1.0-b2", "=0.1.0-b3"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0-b4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0-b4",
    },
    "fivetran/facebook_ads": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/facebook_ads",
    },
    "fivetran/facebook_pages": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=1.0.0", "=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "facebook_pages",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/facebook_pages",
    },
    "fivetran/fivetran_log": {
        "latest_version": "=2.5.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=2.5.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.4.0", "=0.4.1", "=2.5.0"],
        "fusion_incompatible_versions": [
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.5.0-b1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
            "=1.10.0",
            "=1.11.0",
            "=1.2.0",
            "=1.3.0",
            "=1.4.0",
            "=1.4.1",
            "=1.4.2",
            "=1.4.3",
            "=1.5.0",
            "=1.6.0",
            "=1.7.0",
            "=1.7.1",
            "=1.7.2",
            "=1.7.3",
            "=1.8.0",
            "=1.9.0",
            "=1.9.1",
            "=2.0.0",
            "=2.1.0",
            "=2.1.1-a1",
            "=2.2.0",
            "=2.2.1",
            "=2.2.2",
            "=2.3.0-a1",
            "=2.3.0",
            "=2.3.1",
            "=2.3.2-a1",
            "=2.4.0-a1",
            "=2.4.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=2.5.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=2.5.0",
    },
    "fivetran/fivetran_utils": {
        "latest_version": "=0.4.11",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=0.4.11",
        "fusion_compatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.2.10",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.4.11",
        ],
        "fusion_incompatible_versions": [
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.3.8",
            "=0.3.9",
            "=0.4.0",
            "=0.4.1",
            "=0.4.10",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.4.8",
            "=0.4.9",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1"],
        "package_latest_version_index_json": "=0.4.11",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.11",
    },
    "fivetran/ga4_export": {
        "latest_version": "=0.5.0",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": ["=0.5.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.0",
    },
    "fivetran/github": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "github",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/github",
    },
    "fivetran/google_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=0.4.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "google_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/google_ads",
    },
    "fivetran/google_play": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "google_play",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/google_play",
    },
    "fivetran/greenhouse": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "greenhouse",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/greenhouse",
    },
    "fivetran/hubspot": {
        "latest_version": "=1.5.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.5.0",
        "fusion_compatible_versions": ["=0.4.0", "=0.4.1", "=1.4.0", "=1.5.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.15.1",
            "=0.16.0",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0",
            "=0.22.0",
            "=0.23.0",
            "=0.24.0",
            "=0.25.0",
            "=0.26.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.3.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.5.0",
        "package_redirect_name": "hubspot",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.5.0",
        "package_redirect_id": "fivetran/hubspot",
    },
    "fivetran/instagram_business": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.3.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "instagram_business",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/instagram_business",
    },
    "fivetran/intercom": {
        "latest_version": "=1.4.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.4.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=1.3.0", "=1.4.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=1.0.0",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.4.0",
        "package_redirect_name": "intercom",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.4.0",
        "package_redirect_id": "fivetran/intercom",
    },
    "fivetran/iterable": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=0.2.0", "=0.3.0", "=0.3.1", "=1.2.0", "=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "iterable",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/iterable",
    },
    "fivetran/jira": {
        "latest_version": "=1.3.1",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.3.1",
        "fusion_compatible_versions": ["=0.4.0", "=0.5.0", "=0.5.1", "=0.6.0", "=1.3.0", "=1.3.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.18.0",
            "=0.19.0",
            "=0.2.0",
            "=0.20.0",
            "=0.20.1-a1",
            "=0.20.1-a2",
            "=0.21.0",
            "=0.3.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.2.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.1",
        "package_redirect_name": "jira",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.1",
        "package_redirect_id": "fivetran/jira",
    },
    "fivetran/klaviyo": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.2.0", "=0.2.1", "=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "klaviyo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/klaviyo",
    },
    "fivetran/lever": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.2.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "lever",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/lever",
    },
    "fivetran/linkedin": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "linkedin",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/linkedin",
    },
    "fivetran/linkedin_pages": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=1.0.0", "=1.0.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "linkedin_pages",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/linkedin_pages",
    },
    "fivetran/mailchimp": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.4.0", "=0.5.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "mailchimp",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/mailchimp",
    },
    "fivetran/marketo": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.5.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.13.0",
            "=0.13.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "marketo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/marketo",
    },
    "fivetran/microsoft_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.1",
            "=0.10.0",
            "=0.11.0",
            "=0.11.1",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "microsoft_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/microsoft_ads",
    },
    "fivetran/mixpanel": {
        "latest_version": "=0.15.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.15.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.15.0", "=0.4.0", "=0.5.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.15.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.15.0",
    },
    "fivetran/netsuite": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=0.1.1", "=0.4.0", "=0.4.1", "=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0-b1",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2-a1",
            "=0.18.0",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.20.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.2.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "netsuite",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/netsuite",
    },
    "fivetran/pardot": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.4.0", "=0.5.0", "=0.6.0", "=1.0.0", "=1.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "pardot",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/pardot",
    },
    "fivetran/pendo": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "pendo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/pendo",
    },
    "fivetran/pinterest": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.4.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "pinterest",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/pinterest",
    },
    "fivetran/qualtrics": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": "=1.1.1",
        "latest_fusion_compatible_version": "=1.1.1",
        "fusion_compatible_versions": ["=1.1.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": "qualtrics",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.1",
        "package_redirect_id": "fivetran/qualtrics",
    },
    "fivetran/quickbooks": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.11.0",
            "=0.11.1",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0-a1",
            "=0.17.0",
            "=0.17.1-a1",
            "=0.17.1",
            "=0.18.0",
            "=0.18.1",
            "=0.18.2",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.20.0",
            "=0.20.1",
            "=0.21.0",
            "=0.21.1",
            "=0.22.0-a1",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1-a1",
            "=1.0.2-a1",
            "=1.1.0",
            "=1.1.1-a1",
            "=1.1.1-a2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "quickbooks",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/quickbooks",
    },
    "fivetran/recharge": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=1.3.0",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "recharge",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/recharge",
    },
    "fivetran/recurly": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "recurly",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/recurly",
    },
    "fivetran/reddit_ads": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.1.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1-a1",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "reddit_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/reddit_ads",
    },
    "fivetran/sage_intacct": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "sage_intacct",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/sage_intacct",
    },
    "fivetran/salesforce": {
        "latest_version": "=2.1.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=2.1.0",
        "fusion_compatible_versions": ["=0.4.0", "=2.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.5.0",
            "=0.5.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0",
            "=1.2.1",
            "=1.3.0",
            "=2.0.0",
            "=2.0.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=2.1.0",
        "package_redirect_name": "salesforce",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=2.1.0",
        "package_redirect_id": "fivetran/salesforce",
    },
    "fivetran/salesforce_formula_utils": {
        "latest_version": "=0.11.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=0.11.0",
        "fusion_compatible_versions": ["=0.11.0", "=0.3.0", "=0.3.1", "=0.3.2", "=0.4.0", "=0.4.1", "=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.2.0"],
        "package_latest_version_index_json": "=0.11.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.11.0",
    },
    "fivetran/salesforce_marketing_cloud": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=0.4.0",
        "fusion_compatible_versions": ["=0.4.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.0",
    },
    "fivetran/sap": {
        "latest_version": "=0.5.1",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.5.1",
        "fusion_compatible_versions": ["=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1-a1", "=0.2.1", "=0.3.0", "=0.3.1", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.1",
        "package_redirect_name": "sap",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=0.5.1",
        "package_redirect_id": "fivetran/sap",
    },
    "fivetran/servicenow": {
        "latest_version": "=0.6.0",
        "oldest_fusion_compatible_version": "=0.6.0",
        "latest_fusion_compatible_version": "=0.6.0",
        "fusion_compatible_versions": ["=0.6.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=0.5.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.0",
    },
    "fivetran/shopify": {
        "latest_version": "=1.3.1",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=1.3.1",
        "fusion_compatible_versions": ["=0.5.0", "=0.5.1", "=0.5.2", "=1.3.0", "=1.3.1"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.16.1",
            "=0.17.0",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0",
            "=0.21.1",
            "=0.21.2-a1",
            "=0.22.0",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.3.1",
        "package_redirect_name": "shopify",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.1",
        "package_redirect_id": "fivetran/shopify",
    },
    "fivetran/shopify_holistic_reporting": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.9.0",
    },
    "fivetran/snapchat_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.2.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "snapchat_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/snapchat_ads",
    },
    "fivetran/social_media_reporting": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=1.2.0", "=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.0",
    },
    "fivetran/stripe": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.3.0-a3",
        "fusion_compatible_versions": ["=0.1.0", "=0.5.0", "=0.5.1", "=1.2.0", "=1.3.0-a1", "=1.3.0-a2", "=1.3.0-a3"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.15.1",
            "=0.16.0",
            "=0.16.1",
            "=0.17.0",
            "=0.17.1",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "stripe",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0-a3",
        "package_redirect_id": "fivetran/stripe",
    },
    "fivetran/tiktok_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "tiktok_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/tiktok_ads",
    },
    "fivetran/twilio": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0", "=1.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "twilio",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/twilio",
    },
    "fivetran/twitter_ads": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "twitter_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/twitter_ads",
    },
    "fivetran/twitter_organic": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "twitter_organic",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/twitter_organic",
    },
    "fivetran/unified_rag": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0-a1",
            "=0.1.0-a2",
            "=0.1.0-a3",
            "=0.1.0-a4",
            "=0.1.0-a5",
            "=0.1.0-a6",
            "=0.1.0-a7",
            "=0.1.0-a8",
            "=0.1.0-a9",
            "=0.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "fivetran/workday": {
        "latest_version": "=0.6.0",
        "oldest_fusion_compatible_version": "=0.6.0",
        "latest_fusion_compatible_version": "=0.6.0",
        "fusion_compatible_versions": ["=0.6.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.0",
    },
    "fivetran/xero": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.1",
        "fusion_compatible_versions": ["=0.2.0", "=0.3.0", "=0.3.1", "=1.1.0", "=1.1.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": "xero",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.1",
        "package_redirect_id": "fivetran/xero",
    },
    "fivetran/youtube_analytics": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.1.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "youtube_analytics",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/youtube_analytics",
    },
    "fivetran/zendesk": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=1.2.0-a1",
            "=1.2.0-a2",
            "=1.2.0",
            "=1.2.1",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.12.0",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.18.0",
            "=0.18.1",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.19.3",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0-a2",
            "=0.21.0",
            "=0.22.0-a1",
            "=0.22.0-a2",
            "=0.22.0",
            "=0.23.0-a1",
            "=0.23.0",
            "=0.23.1-a1",
            "=0.24.0",
            "=0.24.1",
            "=0.24.2",
            "=0.25.0-a1",
            "=0.25.0",
            "=0.25.1-a1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.8.0-b1",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.1.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "zendesk",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/zendesk",
    },
    "fivetran/zuora": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2-a1",
            "=0.3.2-a2",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "zuora",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/zuora",
    },
    "flexor-ai/flexor": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "fullstorydev/dbt_fullstory": {
        "latest_version": "=0.10.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.10.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.10.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.10.1",
    },
    "get-select/dbt_snowflake_monitoring": {
        "latest_version": "=5.5.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.2.1",
            "=1.2.2",
            "=1.2.3",
            "=1.3.0",
            "=1.3.1",
            "=1.4.0",
            "=1.4.1",
            "=1.4.2",
            "=1.4.3",
            "=1.5.0",
            "=1.6.0",
            "=1.6.1",
            "=2.0.0",
            "=2.0.1",
            "=2.0.2",
            "=3.0.0",
            "=3.0.1",
            "=4.0.0",
            "=4.0.1",
            "=4.0.2",
            "=4.1.0",
            "=4.1.1",
            "=4.2.0",
            "=4.2.1",
            "=4.3.0",
            "=4.3.1",
            "=4.4.0",
            "=4.4.1",
            "=4.5.0",
            "=4.5.1",
            "=4.5.2",
            "=4.5.3",
            "=4.6.0",
            "=5.0.0",
            "=5.0.1",
            "=5.0.2",
            "=5.0.3",
            "=5.0.4",
            "=5.1.0",
            "=5.1.1",
            "=5.1.2",
            "=5.2.0",
            "=5.2.1",
            "=5.2.2",
            "=5.3.0",
            "=5.3.1",
            "=5.3.2",
            "=5.3.3",
            "=5.4.0",
            "=5.4.1",
            "=5.4.2",
            "=5.4.3",
            "=5.4.4",
            "=5.4.5",
            "=5.4.6",
            "=5.4.7",
            "=5.5.0",
        ],
        "package_latest_version_index_json": "=5.5.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=5.5.0",
    },
    "get-select/dbt_snowflake_query_tags": {
        "latest_version": "=2.5.4",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.1.3",
            "=2.0.0",
            "=2.0.1",
            "=2.0.2",
            "=2.1.0",
            "=2.2.0",
            "=2.3.0",
            "=2.3.1",
            "=2.3.2",
            "=2.3.3",
            "=2.4.0",
            "=2.4.1",
            "=2.5.0",
            "=2.5.1",
            "=2.5.2",
            "=2.5.3",
            "=2.5.4",
        ],
        "package_latest_version_index_json": "=2.5.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=2.5.4",
    },
    "gitlabhq/snowflake_spend": {
        "latest_version": "=1.4.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.4.0",
        "fusion_compatible_versions": ["=1.2.0", "=1.3.0", "=1.4.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=1.0.0", "=1.1.0"],
        "package_latest_version_index_json": "=1.4.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.4.0",
    },
    "gmdata-co/portable_google_sheets": {
        "latest_version": "=0.1.3",
        "oldest_fusion_compatible_version": "=0.0.2",
        "latest_fusion_compatible_version": "=0.1.3",
        "fusion_compatible_versions": ["=0.0.2", "=0.1.0", "=0.1.1", "=0.1.3"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.3",
    },
    "godatadriven/dbt_date": {
        "latest_version": "=0.17.0",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=0.17.0",
        "fusion_compatible_versions": ["=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.16.1", "=0.17.0", "=0.1.1"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.14.1",
            "=0.14.2",
            "=0.15.0",
            "=0.16.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.17.0",
        "package_redirect_name": "dbt_date",
        "package_redirect_namespace": "godatadriven",
        "latest_version_incl_prerelease": "=0.17.0",
        "package_redirect_id": "godatadriven/dbt_date",
    },
    "google/fhir_dbt_analytics": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": "=1.0.1",
        "latest_fusion_compatible_version": "=1.0.1",
        "fusion_compatible_versions": ["=1.0.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0"],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "google/fhir_dbt_utils": {
        "latest_version": "=1.0.8",
        "oldest_fusion_compatible_version": "=1.0.0",
        "latest_fusion_compatible_version": "=1.0.8",
        "fusion_compatible_versions": [
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.0.3",
            "=1.0.4",
            "=1.0.5",
            "=1.0.6",
            "=1.0.7",
            "=1.0.8",
            "=1.0.5",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.8",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.8",
    },
    "grafana/leaner_query": {
        "latest_version": "=0.2.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.13",
            "=0.1.14",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.2",
    },
    "henryupton/dbt_scd2_utils": {
        "latest_version": "=1.0.28",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=1.0.28",
        "fusion_compatible_versions": [
            "=0.0.1",
            "=0.0.2",
            "=1.0.0",
            "=1.0.1",
            "=1.0.10",
            "=1.0.11",
            "=1.0.12",
            "=1.0.13",
            "=1.0.14",
            "=1.0.15",
            "=1.0.16",
            "=1.0.17",
            "=1.0.18",
            "=1.0.19",
            "=1.0.2",
            "=1.0.20",
            "=1.0.21",
            "=1.0.22",
            "=1.0.23",
            "=1.0.24",
            "=1.0.25",
            "=1.0.26",
            "=1.0.27",
            "=1.0.28",
            "=1.0.3",
            "=1.0.4",
            "=1.0.5",
            "=1.0.6",
            "=1.0.7",
            "=1.0.8",
            "=1.0.9",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.28",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.28",
    },
    "hightouchio/dbt_hightouch": {
        "latest_version": "=0.1.6",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.0.1",
            "=0.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.6",
    },
    "infinitelambda/audit_helper_ext": {
        "latest_version": "=0.8.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.8.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.8.0",
    },
    "infinitelambda/carbon-analytics": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1"],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "infinitelambda/carbon_analytics": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "infinitelambda/data_diff": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "infinitelambda/dbt_alert": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "infinitelambda/dbt_tags": {
        "latest_version": "=1.9.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0",
            "=1.3.0",
            "=1.3.1",
            "=1.4.0",
            "=1.4.1",
            "=1.4.2",
            "=1.5.0",
            "=1.6.0",
            "=1.6.1",
            "=1.7.0",
            "=1.8.0",
            "=1.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.9.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.9.0",
    },
    "infinitelambda/dq_tools": {
        "latest_version": "=1.10.3",
        "oldest_fusion_compatible_version": "=1.1.1",
        "latest_fusion_compatible_version": "=1.10.3",
        "fusion_compatible_versions": [
            "=1.1.1",
            "=1.1.2",
            "=1.10.0",
            "=1.10.1",
            "=1.10.2",
            "=1.10.3",
            "=1.2.0",
            "=1.2.1",
            "=1.2.2",
            "=1.3.0",
            "=1.4.0",
            "=1.4.1",
            "=1.4.2",
            "=1.5.0",
            "=1.6.0",
            "=1.7.0",
            "=1.8.0",
            "=1.9.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.10.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.10.3",
    },
    "infinitelambda/dq_vault": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "infinitelambda/snowflake_evaluator": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "irvingpop/otel_export": {
        "latest_version": "=1.1.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=1.1.3"],
        "unknown_compatibility_versions": ["=1.0.0", "=1.1.0", "=1.1.1", "=1.1.2"],
        "package_latest_version_index_json": "=1.1.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.3",
    },
    "jitsucom/jitsu": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": "jitsu",
        "package_redirect_namespace": "jitsucom",
        "latest_version_incl_prerelease": "=0.1.1",
        "package_redirect_id": "jitsucom/jitsu",
    },
    "jmangroup/data_profiler": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": "=1.0.0",
        "latest_fusion_compatible_version": "=1.0.0",
        "fusion_compatible_versions": ["=1.0.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "jpmmcneill/dbt_graph_theory": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0-b1", "=0.1.0", "=0.2.0-b1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0-b1",
    },
    "kgmcquate/testgen": {
        "latest_version": "=1.0.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.2.0",
            "=0.2.1",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.0.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3"],
        "package_latest_version_index_json": "=1.0.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.3",
    },
    "kristeligt-dagblad/dbt_ml": {
        "latest_version": "=0.7.2",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.7.2",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.7.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.7.2",
    },
    "lalalilo/athena_utils": {
        "latest_version": "=0.6.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.6.0",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.0",
    },
    "masthead-data/bq_reservations": {
        "latest_version": "=0.0.3",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.0.3",
        "fusion_compatible_versions": ["=0.0.1", "=0.0.2", "=0.0.3"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.0.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.3",
    },
    "metaops-solutions/camunda": {
        "latest_version": "=0.0.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.2", "=0.0.3", "=0.0.4", "=0.0.5"],
        "unknown_compatibility_versions": ["=0.0.1"],
        "package_latest_version_index_json": "=0.0.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.5",
    },
    "metaplane/dbt_expectations": {
        "latest_version": "=0.10.10",
        "oldest_fusion_compatible_version": "=0.10.10",
        "latest_fusion_compatible_version": "=0.10.10",
        "fusion_compatible_versions": ["=0.10.10"],
        "fusion_incompatible_versions": [
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.10.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.5.8",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.10.10",
        "package_redirect_name": "dbt_expectations",
        "package_redirect_namespace": "metaplane",
        "latest_version_incl_prerelease": "=0.10.10",
        "package_redirect_id": "metaplane/dbt_expectations",
    },
    "mjirv/dbt_datamocktool": {
        "latest_version": "=0.3.5",
        "oldest_fusion_compatible_version": "=0.2.1",
        "latest_fusion_compatible_version": "=0.3.5",
        "fusion_compatible_versions": ["=0.2.1", "=0.2.2", "=0.3.0", "=0.3.1", "=0.3.2", "=0.3.3", "=0.3.4", "=0.3.5"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0-beta-fishtown",
            "=0.1.0-beta",
            "=0.1.1-beta-fishtown",
            "=0.1.1-beta",
            "=0.1.10",
            "=0.1.11",
            "=0.1.2-fishtown",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
        ],
        "package_latest_version_index_json": "=0.3.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.5",
    },
    "mjirv/dbt_product_analytics": {
        "latest_version": "=0.3.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.0.2",
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
        ],
        "package_latest_version_index_json": "=0.3.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.1",
    },
    "narratorai/activity_schema": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "oleg-solovyev/dbt_facebook_ads": {
        "latest_version": "=0.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.1",
    },
    "omnata-labs/dbt_ml_preprocessing": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.1.0",
    },
    "pvcy/dbt_privacy": {
        "latest_version": "=0.3.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.1",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.3.0", "=0.3.1"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.1",
    },
    "re-data/re_data": {
        "latest_version": "=0.11.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.10.9",
            "=0.11.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
        ],
        "unknown_compatibility_versions": ["=0.1.2", "=0.1.0-alpha", "=0.1.1-alpha"],
        "package_latest_version_index_json": "=0.11.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.11.0",
    },
    "rjh336/dbt_model_usage": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "rlsalcido24/lakehouse_utils": {
        "latest_version": "=1.3.94",
        "oldest_fusion_compatible_version": "=0.1.2",
        "latest_fusion_compatible_version": "=1.3.94",
        "fusion_compatible_versions": [
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.1.3",
            "=1.1.4",
            "=1.1.5",
            "=1.1.6",
            "=1.2.0",
            "=1.2.1",
            "=1.2.2",
            "=1.2.3",
            "=1.2.4",
            "=1.2.5",
            "=1.2.6",
            "=1.2.7",
            "=1.2.8",
            "=1.2.9",
            "=1.3.0",
            "=1.3.1",
            "=1.3.2",
            "=1.3.3",
            "=1.3.4",
            "=1.3.5",
            "=1.3.6",
            "=1.3.7",
            "=1.3.8",
            "=1.3.81",
            "=1.3.82",
            "=1.3.83",
            "=1.3.84",
            "=1.3.85",
            "=1.3.86",
            "=1.3.9",
            "=1.3.91",
            "=1.3.92",
            "=1.3.93",
            "=1.3.94",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.1"],
        "package_latest_version_index_json": "=1.3.94",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.94",
    },
    "rudderlabs/id_stitching": {
        "latest_version": "=1.3.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.2.0",
            "=1.3.0",
            "=1.3.1",
            "=1.3.2",
        ],
        "package_latest_version_index_json": "=1.3.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.2",
    },
    "rudderlabs/rudder_customer_journey_analysis": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0", "=1.0.1"],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "rudderlabs/rudder_events_registry": {
        "latest_version": "=1.0.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0", "=1.0.1", "=1.0.2"],
        "package_latest_version_index_json": "=1.0.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.2",
    },
    "rudderlabs/rudder_id_resolution": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0", "=1.0.1"],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "rudderlabs/rudder_sessionization": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=1.0.0", "=1.0.1"],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "sdebruyn/dbt_duckdb_utils": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "sgoley/postgres_utils": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.0.2",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.0.2", "=0.1.0", "=0.2.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "shankararul/dbt_eda_tools": {
        "latest_version": "=1.3.6",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.8.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.1.3",
            "=1.2.0",
            "=1.2.1",
            "=1.3.0",
            "=1.3.1",
            "=1.3.2",
            "=1.3.3",
            "=1.3.4",
            "=1.3.5",
            "=1.3.6",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.3.6",
    },
    "snowplow/snowplow_attribution": {
        "latest_version": "=0.5.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.1",
    },
    "snowplow/snowplow_ecommerce": {
        "latest_version": "=0.9.3",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.9.3",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.9.3",
    },
    "snowplow/snowplow_fractribution": {
        "latest_version": "=0.3.7",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.2.0"],
        "package_latest_version_index_json": "=0.3.7",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.7",
    },
    "snowplow/snowplow_media_player": {
        "latest_version": "=0.9.4",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.4",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.3.1", "=0.3.2", "=0.3.3", "=0.3.4"],
        "fusion_incompatible_versions": [
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.9.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.9.4",
    },
    "snowplow/snowplow_mobile": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "snowplow/snowplow_normalize": {
        "latest_version": "=0.4.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.4.0",
            "=0.4.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.4.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.1",
    },
    "snowplow/snowplow_unified": {
        "latest_version": "=0.5.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.0.1",
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.5",
    },
    "snowplow/snowplow_utils": {
        "latest_version": "=0.17.5",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0-rc1",
            "=0.14.0-rc2",
            "=0.14.0",
            "=0.14.1",
            "=0.14.2",
            "=0.14.3",
            "=0.15.0-rc1",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.16.0",
            "=0.16.1",
            "=0.16.2",
            "=0.16.3",
            "=0.16.4",
            "=0.16.5",
            "=0.16.6",
            "=0.16.7",
            "=0.16.8",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2",
            "=0.17.3",
            "=0.17.4",
            "=0.17.5",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.17.5",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.17.5",
    },
    "snowplow/snowplow_web": {
        "latest_version": "=1.0.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.13.3",
            "=0.14.0-rc1",
            "=0.14.0-rc2",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.16.0-rc1",
            "=0.16.0",
            "=0.16.1",
            "=0.16.2",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.1",
    },
    "splitgraph/ab2ft_stripe": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "starburstdata/trino_utils": {
        "latest_version": "=0.6.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=0.6.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.6.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.6.0",
    },
    "sutrolabs/census_utils": {
        "latest_version": "=0.1.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.2",
    },
    "techindicium/metalog": {
        "latest_version": "=1.0.0",
        "oldest_fusion_compatible_version": "=1.0.0-beta",
        "latest_fusion_compatible_version": "=1.0.0-beta2",
        "fusion_compatible_versions": ["=1.0.0-beta", "=1.0.0-beta2"],
        "fusion_incompatible_versions": ["=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.0.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=1.0.0",
    },
    "tnightengale/dbt_activity_schema": {
        "latest_version": "=0.4.1",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.0.1", "=0.0.2", "=0.0.3", "=0.1.0", "=0.1.1"],
        "fusion_incompatible_versions": ["=0.2.0", "=0.3.0", "=0.3.1", "=0.3.2", "=0.3.3", "=0.4.0", "=0.4.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.4.1",
    },
    "tnightengale/dbt_meta_testing": {
        "latest_version": "=0.3.6",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=0.3.6",
        "fusion_compatible_versions": ["=0.2.0", "=0.2.1", "=0.3.0", "=0.3.1", "=0.3.2", "=0.3.5", "=0.3.6"],
        "fusion_incompatible_versions": ["=0.3.3", "=0.3.4"],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.3.6",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.6",
    },
    "tuva-health/claims_preprocessing": {
        "latest_version": "=0.1.8",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
        ],
        "package_latest_version_index_json": "=0.1.8",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.8",
    },
    "tuva-health/cms_chronic_conditions": {
        "latest_version": "=0.1.8",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
        ],
        "package_latest_version_index_json": "=0.1.8",
        "package_redirect_name": "cms_chronic_conditions",
        "package_redirect_namespace": "tuva-health",
        "latest_version_incl_prerelease": "=0.1.8",
        "package_redirect_id": "tuva-health/cms_chronic_conditions",
    },
    "tuva-health/data_profiling": {
        "latest_version": "=0.1.7",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
        ],
        "package_latest_version_index_json": "=0.1.7",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.7",
    },
    "tuva-health/medicare_cclf_connector": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "tuva-health/medicare_claims_connector": {
        "latest_version": "=0.1.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.0",
    },
    "tuva-health/pmpm": {
        "latest_version": "=0.0.4",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.1", "=0.0.2", "=0.0.3", "=0.0.4"],
        "package_latest_version_index_json": "=0.0.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.4",
    },
    "tuva-health/readmissions": {
        "latest_version": "=0.1.9",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
        ],
        "package_latest_version_index_json": "=0.1.9",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.9",
    },
    "tuva-health/terminology": {
        "latest_version": "=0.1.17",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.13",
            "=0.1.14",
            "=0.1.15",
            "=0.1.16",
            "=0.1.17",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2"],
        "package_latest_version_index_json": "=0.1.17",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.17",
    },
    "tuva-health/the_tuva_project": {
        "latest_version": "=0.15.5",
        "oldest_fusion_compatible_version": "=0.3.1",
        "latest_fusion_compatible_version": "=0.15.5",
        "fusion_compatible_versions": [
            "=0.3.1",
            "=0.3.10",
            "=0.3.11",
            "=0.3.12",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.8",
            "=0.3.9",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.12.5",
            "=0.12.6",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.14.10",
            "=0.14.11",
            "=0.14.12",
            "=0.14.13",
            "=0.14.14",
            "=0.14.15",
            "=0.14.16",
            "=0.14.17",
            "=0.14.18",
            "=0.14.2",
            "=0.14.3",
            "=0.14.4",
            "=0.14.5",
            "=0.14.6",
            "=0.14.7",
            "=0.14.8",
            "=0.14.9",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.15.3",
            "=0.15.4",
            "=0.15.5",
            "=0.3.13",
            "=0.3.14",
            "=0.3.15",
            "=0.3.16",
            "=0.3.17",
            "=0.3.18",
            "=0.3.19",
            "=0.3.7",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.10",
            "=0.5.11",
            "=0.5.12",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.5.8",
            "=0.5.9",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.10",
            "=0.7.11",
            "=0.7.12",
            "=0.7.13",
            "=0.7.14",
            "=0.7.15",
            "=0.7.16",
            "=0.7.17",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.7.9",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.8.7",
            "=0.9.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
        ],
        "package_latest_version_index_json": "=0.15.5",
        "package_redirect_name": "the_tuva_project",
        "package_redirect_namespace": "tuva-health",
        "latest_version_incl_prerelease": "=0.15.5",
        "package_redirect_id": "tuva-health/the_tuva_project",
    },
    "tuva-health/tuva_chronic_conditions": {
        "latest_version": "=0.0.4",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": ["=0.0.1", "=0.0.2", "=0.0.3", "=0.0.4"],
        "package_latest_version_index_json": "=0.0.4",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.4",
    },
    "windsor-ai/dbt_facebook_ads": {
        "latest_version": "=0.0.2",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.0.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.0.2",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.2",
    },
    "xoniks/dbt_test_results": {
        "latest_version": "=0.0.11",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.0.11",
        "fusion_compatible_versions": ["=0.0.1", "=0.0.1", "=0.0.11"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.0.11",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.0.11",
    },
    "yu-iskw/dbt_airflow_macros": {
        "latest_version": "=0.3.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.2.2", "=0.2.3", "=0.2.4", "=0.3.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.3.0",
    },
    "yu-iskw/dbt_gcp_billing": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.1"],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.1.1",
    },
    "yu-iskw/dbt_ops": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.2.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.2.0",
    },
    "yu-iskw/dbt_unittest": {
        "latest_version": "=0.5.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.3.0", "=0.3.1", "=0.3.3", "=0.4.0", "=0.5.0", "=0.2.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.0",
        "package_redirect_name": None,
        "package_redirect_namespace": None,
        "latest_version_incl_prerelease": "=0.5.0",
    },
    "Datavault-UK/dbtvault": {
        "latest_version": "=0.11.4",
        "oldest_fusion_compatible_version": "=0.11.4",
        "latest_fusion_compatible_version": "=0.11.4",
        "fusion_compatible_versions": ["=0.11.4"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.11.3",
            "=0.4.1",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6-b1",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.7.9",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
            "=0.9.5",
            "=0.9.6",
            "=0.9.7",
        ],
        "unknown_compatibility_versions": [
            "=0.2.1-pre",
            "=0.2.2-pre",
            "=0.2.3-pre",
            "=0.2.4-pre",
            "=0.3.1-pre",
            "=0.3.2-pre",
            "=0.3.3-pre",
        ],
        "package_latest_version_index_json": "=0.11.4",
        "package_redirect_name": "automate_dv",
        "package_redirect_namespace": "Datavault-UK",
        "latest_version_incl_prerelease": "=0.11.4",
        "package_redirect_id": "Datavault-UK/automate_dv",
    },
    "calogica/dbt_date": {
        "latest_version": "=0.17.0",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=0.17.0",
        "fusion_compatible_versions": ["=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.16.1", "=0.17.0", "=0.1.1"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.14.1",
            "=0.14.2",
            "=0.15.0",
            "=0.16.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.17.0",
        "package_redirect_name": "dbt_date",
        "package_redirect_namespace": "godatadriven",
        "latest_version_incl_prerelease": "=0.17.0",
        "package_redirect_id": "godatadriven/dbt_date",
    },
    "calogica/dbt_expectations": {
        "latest_version": "=0.10.10",
        "oldest_fusion_compatible_version": "=0.10.10",
        "latest_fusion_compatible_version": "=0.10.10",
        "fusion_compatible_versions": ["=0.10.10"],
        "fusion_incompatible_versions": [
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.10.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.5.8",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.10.10",
        "package_redirect_name": "dbt_expectations",
        "package_redirect_namespace": "metaplane",
        "latest_version_incl_prerelease": "=0.10.10",
        "package_redirect_id": "metaplane/dbt_expectations",
    },
    "cerebriumai/github": {
        "latest_version": "=0.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.2.0",
        "package_redirect_name": "airbyte_github",
        "package_redirect_namespace": "cerebriumai",
        "latest_version_incl_prerelease": "=0.2.0",
        "package_redirect_id": "cerebriumai/airbyte_github",
    },
    "dbt-labs/segment": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.3.1", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": "dbt_segment",
        "package_redirect_namespace": "Fleetio",
        "latest_version_incl_prerelease": "=0.4.0",
        "package_redirect_id": "Fleetio/dbt_segment",
    },
    "elementary-data/elementary_data_reliability": {
        "latest_version": "=0.21.0",
        "oldest_fusion_compatible_version": "=0.21.0",
        "latest_fusion_compatible_version": "=0.21.0",
        "fusion_compatible_versions": ["=0.21.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.16.0",
            "=0.16.1",
            "=0.16.2",
            "=0.16.3",
            "=0.16.4",
            "=0.17.0",
            "=0.18.0",
            "=0.18.1",
            "=0.18.2",
            "=0.18.3",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.19.3",
            "=0.19.4",
            "=0.2.0",
            "=0.2.1",
            "=0.20.0",
            "=0.20.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.10",
            "=0.3.11",
            "=0.3.12",
            "=0.3.13",
            "=0.3.14",
            "=0.3.15",
            "=0.3.16",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.3.8",
            "=0.3.9",
            "=0.4.0",
            "=0.4.1",
            "=0.4.10",
            "=0.4.11",
            "=0.4.12",
            "=0.4.2",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.4.8",
            "=0.4.9",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.6.0",
            "=0.6.1",
            "=0.6.10",
            "=0.6.11",
            "=0.6.12",
            "=0.6.13",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.6.7",
            "=0.6.8",
            "=0.6.9",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=0.9.4",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.21.0",
        "package_redirect_name": "elementary",
        "package_redirect_namespace": "elementary-data",
        "latest_version_incl_prerelease": "=0.21.0",
        "package_redirect_id": "elementary-data/elementary",
    },
    "fishtown-analytics/adwords": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": "=0.2.11",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": ["=0.2.11", "=0.2.12", "=0.3.0"],
        "fusion_incompatible_versions": ["=0.4.0"],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.2.0",
            "=0.2.1",
            "=0.2.10",
            "=0.2.2",
            "=0.2.2-a",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.2.2-a",
        ],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": "adwords",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.4.0",
        "package_redirect_id": "dbt-labs/adwords",
    },
    "fishtown-analytics/audit_helper": {
        "latest_version": "=0.12.2",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.12.2",
        "fusion_compatible_versions": [
            "=0.0.1",
            "=0.0.2",
            "=0.0.6",
            "=0.1.0",
            "=0.12.2",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.0.3",
            "=0.0.4",
            "=0.0.5",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=0.11.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.12.2",
        "package_redirect_name": "audit_helper",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.12.2",
        "package_redirect_id": "dbt-labs/audit_helper",
    },
    "fishtown-analytics/codegen": {
        "latest_version": "=0.14.0",
        "oldest_fusion_compatible_version": "=0.0.1",
        "latest_fusion_compatible_version": "=0.14.0",
        "fusion_compatible_versions": [
            "=0.0.1",
            "=0.0.2",
            "=0.1.0",
            "=0.14.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.0.3",
            "=0.0.4",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.13.0",
            "=0.13.1",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.13.0-b1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.14.0",
        "package_redirect_name": "codegen",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.14.0",
        "package_redirect_id": "dbt-labs/codegen",
    },
    "fishtown-analytics/dbt-utils": {
        "latest_version": "=1.3.3",
        "oldest_fusion_compatible_version": "=0.1.23",
        "latest_fusion_compatible_version": "=1.3.3",
        "fusion_compatible_versions": [
            "=0.1.23",
            "=0.1.24",
            "=0.1.25",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=1.3.2",
            "=1.3.3",
        ],
        "fusion_incompatible_versions": [
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4-b1",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.5",
            "=0.9.6",
            "=1.0.0-b1",
            "=1.0.0-b2",
            "=1.0.0-rc1",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0-rc1",
            "=1.2.0",
            "=1.3.0",
            "=1.3.1",
        ],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.1.0",
            "=0.1.1",
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.13",
            "=0.1.14",
            "=0.1.15",
            "=0.1.16",
            "=0.1.17",
            "=0.1.18",
            "=0.1.19",
            "=0.1.2",
            "=0.1.20",
            "=0.1.21",
            "=0.1.22",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
        ],
        "package_latest_version_index_json": "=1.3.3",
        "package_redirect_name": "dbt_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=1.3.3",
        "package_redirect_id": "dbt-labs/dbt_utils",
    },
    "fishtown-analytics/dbt_external_tables": {
        "latest_version": "=0.12.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.12.0",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.12.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.7.0",
            "=0.7.1",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0-b1",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.11.1",
            "=0.7.2",
            "=0.7.3",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.8.7",
            "=0.9.0-b1",
            "=0.9.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.12.0",
        "package_redirect_name": "dbt_external_tables",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.12.0",
        "package_redirect_id": "dbt-labs/dbt_external_tables",
    },
    "fishtown-analytics/dbt_utils": {
        "latest_version": "=1.3.3",
        "oldest_fusion_compatible_version": "=0.1.23",
        "latest_fusion_compatible_version": "=1.3.3",
        "fusion_compatible_versions": [
            "=0.1.23",
            "=0.1.24",
            "=0.1.25",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=1.3.2",
            "=1.3.3",
        ],
        "fusion_incompatible_versions": [
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.6.4",
            "=0.6.5",
            "=0.6.6",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4-b1",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.5",
            "=0.9.6",
            "=1.0.0-b1",
            "=1.0.0-b2",
            "=1.0.0-rc1",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0-rc1",
            "=1.2.0",
            "=1.3.0",
            "=1.3.1",
        ],
        "unknown_compatibility_versions": [
            "=0.0.1",
            "=0.1.0",
            "=0.1.1",
            "=0.1.10",
            "=0.1.11",
            "=0.1.12",
            "=0.1.13",
            "=0.1.14",
            "=0.1.15",
            "=0.1.16",
            "=0.1.17",
            "=0.1.18",
            "=0.1.19",
            "=0.1.2",
            "=0.1.20",
            "=0.1.21",
            "=0.1.22",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
        ],
        "package_latest_version_index_json": "=1.3.3",
        "package_redirect_name": "dbt_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=1.3.3",
        "package_redirect_id": "dbt-labs/dbt_utils",
    },
    "fishtown-analytics/facebook-ads": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.7.0",
        "fusion_compatible_versions": ["=0.6.0", "=0.6.1", "=0.7.0", "=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": ["=0.7.1", "=0.8.0", "=0.9.0"],
        "unknown_compatibility_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.1.0",
            "=0.1.5",
            "=0.1.6",
        ],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.9.0",
        "package_redirect_id": "dbt-labs/facebook_ads",
    },
    "fishtown-analytics/facebook_ads": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.7.0",
        "fusion_compatible_versions": ["=0.6.0", "=0.6.1", "=0.7.0", "=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": ["=0.7.1", "=0.8.0", "=0.9.0"],
        "unknown_compatibility_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.2.7",
            "=0.2.8",
            "=0.2.9",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.4.5",
            "=0.4.6",
            "=0.4.7",
            "=0.1.0",
            "=0.1.5",
            "=0.1.6",
        ],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.9.0",
        "package_redirect_id": "dbt-labs/facebook_ads",
    },
    "fishtown-analytics/logging": {
        "latest_version": "=0.8.0",
        "oldest_fusion_compatible_version": "=0.1.7",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": [
            "=0.1.7",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
        ],
        "fusion_incompatible_versions": ["=0.5.1", "=0.6.0", "=0.7.0", "=0.8.0"],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1", "=0.1.2", "=0.1.3", "=0.1.4", "=0.1.5", "=0.1.6"],
        "package_latest_version_index_json": "=0.8.0",
        "package_redirect_name": "logging",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.8.0",
        "package_redirect_id": "dbt-labs/logging",
    },
    "fishtown-analytics/redshift": {
        "latest_version": "=0.9.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=0.5.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=0.4.0", "=0.4.1", "=0.5.0"],
        "fusion_incompatible_versions": ["=0.5.1", "=0.6.0", "=0.6.1", "=0.7.0", "=0.8.0", "=0.9.0"],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.0.1",
            "=0.1.0",
        ],
        "package_latest_version_index_json": "=0.9.0",
        "package_redirect_name": "redshift",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.9.0",
        "package_redirect_id": "dbt-labs/redshift",
    },
    "fishtown-analytics/segment": {
        "latest_version": "=0.4.0",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=0.3.1", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.4.0",
        "package_redirect_name": "dbt_segment",
        "package_redirect_namespace": "Fleetio",
        "latest_version_incl_prerelease": "=0.4.0",
        "package_redirect_id": "Fleetio/dbt_segment",
    },
    "fishtown-analytics/snowplow": {
        "latest_version": "=0.15.1",
        "oldest_fusion_compatible_version": "=0.9.0",
        "latest_fusion_compatible_version": "=0.13.2",
        "fusion_compatible_versions": ["=0.10.0", "=0.11.0", "=0.12.0", "=0.13.0", "=0.13.1", "=0.13.2", "=0.9.0"],
        "fusion_incompatible_versions": ["=0.13.3", "=0.14.0", "=0.15.0", "=0.15.1"],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.7",
            "=0.3.8",
            "=0.3.9",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
        ],
        "package_latest_version_index_json": "=0.15.1",
        "package_redirect_name": "snowplow",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.15.1",
        "package_redirect_id": "dbt-labs/snowplow",
    },
    "fishtown-analytics/spark_utils": {
        "latest_version": "=0.3.3",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.3.3",
        "fusion_compatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.2.2", "=0.2.3", "=0.3.1", "=0.3.3"],
        "fusion_incompatible_versions": ["=0.2.4", "=0.3.0", "=0.3.2"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.3.3",
        "package_redirect_name": "spark_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.3.3",
        "package_redirect_id": "dbt-labs/spark_utils",
    },
    "fishtown-analytics/stitch_utils": {
        "latest_version": "=0.5.0",
        "oldest_fusion_compatible_version": "=0.1.2",
        "latest_fusion_compatible_version": "=0.3.0",
        "fusion_compatible_versions": [
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
        ],
        "fusion_incompatible_versions": ["=0.3.1", "=0.4.0", "=0.4.1", "=0.4.2", "=0.5.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.0",
        "package_redirect_name": "stitch_utils",
        "package_redirect_namespace": "dbt-labs",
        "latest_version_incl_prerelease": "=0.5.0",
        "package_redirect_id": "dbt-labs/stitch_utils",
    },
    "fivetran/amazon_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "amazon_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/amazon_ads",
    },
    "fivetran/amplitude_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0-a1",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "amplitude",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/amplitude",
    },
    "fivetran/apple_search_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "apple_search_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/apple_search_ads",
    },
    "fivetran/apple_store_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0-a1",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "apple_store",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/apple_store",
    },
    "fivetran/asana_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.4.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "asana",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/asana",
    },
    "fivetran/facebook_ads_creative_history": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/facebook_ads",
    },
    "fivetran/facebook_ads_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "facebook_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/facebook_ads",
    },
    "fivetran/facebook_pages_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=1.0.0", "=1.1.0", "=1.1.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "facebook_pages",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/facebook_pages",
    },
    "fivetran/github_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "github",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/github",
    },
    "fivetran/google_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=0.4.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "google_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/google_ads",
    },
    "fivetran/google_play_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "google_play",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/google_play",
    },
    "fivetran/greenhouse_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "greenhouse",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/greenhouse",
    },
    "fivetran/hubspot_source": {
        "latest_version": "=1.5.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.5.0",
        "fusion_compatible_versions": ["=0.4.0", "=0.4.1", "=1.4.0", "=1.5.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.15.1",
            "=0.16.0",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0",
            "=0.22.0",
            "=0.23.0",
            "=0.24.0",
            "=0.25.0",
            "=0.26.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.3.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.5.0",
        "package_redirect_name": "hubspot",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.5.0",
        "package_redirect_id": "fivetran/hubspot",
    },
    "fivetran/instagram_business_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1", "=0.3.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "instagram_business",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/instagram_business",
    },
    "fivetran/intercom_source": {
        "latest_version": "=1.4.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.4.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.3.1", "=1.3.0", "=1.4.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=1.0.0",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.4.0",
        "package_redirect_name": "intercom",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.4.0",
        "package_redirect_id": "fivetran/intercom",
    },
    "fivetran/iterable_source": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=0.2.0", "=0.3.0", "=0.3.1", "=1.2.0", "=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "iterable",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/iterable",
    },
    "fivetran/jira_source": {
        "latest_version": "=1.3.1",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.3.1",
        "fusion_compatible_versions": ["=0.4.0", "=0.5.0", "=0.5.1", "=0.6.0", "=1.3.0", "=1.3.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.18.0",
            "=0.19.0",
            "=0.2.0",
            "=0.20.0",
            "=0.20.1-a1",
            "=0.20.1-a2",
            "=0.21.0",
            "=0.3.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.2.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.1",
        "package_redirect_name": "jira",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.1",
        "package_redirect_id": "fivetran/jira",
    },
    "fivetran/klaviyo_source": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.2.0", "=0.2.1", "=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "klaviyo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/klaviyo",
    },
    "fivetran/lever_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.2.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "lever",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/lever",
    },
    "fivetran/linkedin_pages_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.1.1", "=0.2.0", "=0.3.0", "=1.0.0", "=1.0.1"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "linkedin_pages",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/linkedin_pages",
    },
    "fivetran/linkedin_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0", "=0.1.1"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "linkedin",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/linkedin",
    },
    "fivetran/mailchimp_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.3.0", "=0.4.0", "=0.5.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "mailchimp",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/mailchimp",
    },
    "fivetran/marketo_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.5.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.13.0",
            "=0.13.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "marketo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/marketo",
    },
    "fivetran/microsoft_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.1",
            "=0.10.0",
            "=0.11.0",
            "=0.11.1",
            "=0.12.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "microsoft_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/microsoft_ads",
    },
    "fivetran/netsuite_source": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=0.1.1",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=0.1.1", "=0.4.0", "=0.4.1", "=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.10.0",
            "=0.11.0",
            "=0.12.0-b1",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.17.1",
            "=0.17.2-a1",
            "=0.18.0",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.20.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.6.3",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
            "=1.2.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "netsuite",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/netsuite",
    },
    "fivetran/pardot_source": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.4.0", "=0.5.0", "=0.6.0", "=1.0.0", "=1.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "pardot",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/pardot",
    },
    "fivetran/pendo_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "pendo",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/pendo",
    },
    "fivetran/pinterest_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.4.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.3.3",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "pinterest",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/pinterest",
    },
    "fivetran/qualtrics_source": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": "=1.1.1",
        "latest_fusion_compatible_version": "=1.1.1",
        "fusion_compatible_versions": ["=1.1.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.4.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": "qualtrics",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.1",
        "package_redirect_id": "fivetran/qualtrics",
    },
    "fivetran/quickbooks_source": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": ["=0.3.0", "=1.2.0", "=1.2.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.11.0",
            "=0.11.1",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0-a1",
            "=0.17.0",
            "=0.17.1-a1",
            "=0.17.1",
            "=0.18.0",
            "=0.18.1",
            "=0.18.2",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.20.0",
            "=0.20.1",
            "=0.21.0",
            "=0.21.1",
            "=0.22.0-a1",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1-a1",
            "=1.0.2-a1",
            "=1.1.0",
            "=1.1.1-a1",
            "=1.1.1-a2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "quickbooks",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/quickbooks",
    },
    "fivetran/recharge_source": {
        "latest_version": "=1.3.0",
        "oldest_fusion_compatible_version": "=1.3.0",
        "latest_fusion_compatible_version": "=1.3.0",
        "fusion_compatible_versions": ["=1.3.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.3.0",
        "package_redirect_name": "recharge",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0",
        "package_redirect_id": "fivetran/recharge",
    },
    "fivetran/recurly_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "recurly",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/recurly",
    },
    "fivetran/reddit_ads_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.1.0", "=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1-a1",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "reddit_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/reddit_ads",
    },
    "fivetran/sage_intacct_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=1.0.0",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "sage_intacct",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/sage_intacct",
    },
    "fivetran/salesforce_source": {
        "latest_version": "=2.1.0",
        "oldest_fusion_compatible_version": "=0.4.0",
        "latest_fusion_compatible_version": "=2.1.0",
        "fusion_compatible_versions": ["=0.4.0", "=2.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.3.0",
            "=0.3.1",
            "=0.5.0",
            "=0.5.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=0.9.2",
            "=0.9.3",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
            "=1.1.0",
            "=1.1.1",
            "=1.2.0",
            "=1.2.1",
            "=1.3.0",
            "=2.0.0",
            "=2.0.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=2.1.0",
        "package_redirect_name": "salesforce",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=2.1.0",
        "package_redirect_id": "fivetran/salesforce",
    },
    "fivetran/sap_source": {
        "latest_version": "=0.5.1",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=0.5.1",
        "fusion_compatible_versions": ["=0.5.0", "=0.5.1"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.2.1-a1", "=0.2.1", "=0.3.0", "=0.3.1", "=0.4.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.5.1",
        "package_redirect_name": "sap",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=0.5.1",
        "package_redirect_id": "fivetran/sap",
    },
    "fivetran/shopify_source": {
        "latest_version": "=1.3.1",
        "oldest_fusion_compatible_version": "=0.5.0",
        "latest_fusion_compatible_version": "=1.3.1",
        "fusion_compatible_versions": ["=0.5.0", "=0.5.1", "=0.5.2", "=1.3.0", "=1.3.1"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.16.1",
            "=0.17.0",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0",
            "=0.21.1",
            "=0.21.2-a1",
            "=0.22.0",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
            "=1.1.0",
            "=1.2.0",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.3.1",
        "package_redirect_name": "shopify",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.1",
        "package_redirect_id": "fivetran/shopify",
    },
    "fivetran/snapchat_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.2.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "snapchat_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/snapchat_ads",
    },
    "fivetran/stripe_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.3.0-a3",
        "fusion_compatible_versions": ["=0.1.0", "=0.5.0", "=0.5.1", "=1.2.0", "=1.3.0-a1", "=1.3.0-a2", "=1.3.0-a3"],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.11.0",
            "=0.12.0",
            "=0.13.0",
            "=0.14.0",
            "=0.14.1",
            "=0.15.0",
            "=0.15.1",
            "=0.16.0",
            "=0.16.1",
            "=0.17.0",
            "=0.17.1",
            "=0.18.0",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "stripe",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.3.0-a3",
        "package_redirect_id": "fivetran/stripe",
    },
    "fivetran/tiktok_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.8.1",
            "=0.9.0",
            "=1.0.0",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "tiktok_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/tiktok_ads",
    },
    "fivetran/twilio_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=0.4.0", "=0.5.0", "=1.0.0", "=1.1.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "twilio",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/twilio",
    },
    "fivetran/twitter_ads_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.3.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.3.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.1.1",
            "=0.1.2",
            "=0.10.0",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.4.0",
            "=0.5.0",
            "=0.5.1",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "twitter_ads",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/twitter_ads",
    },
    "fivetran/twitter_organic_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=1.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=1.1.0"],
        "fusion_incompatible_versions": ["=0.1.0", "=0.2.0", "=0.3.0", "=1.0.0"],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "twitter_organic",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/twitter_organic",
    },
    "fivetran/xero_source": {
        "latest_version": "=1.1.1",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=1.1.1",
        "fusion_compatible_versions": ["=0.2.0", "=0.3.0", "=0.3.1", "=1.1.0", "=1.1.1"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.5.0",
            "=0.6.0",
            "=0.6.1",
            "=0.6.2",
            "=0.7.0",
            "=0.8.0",
            "=0.9.0",
            "=1.0.0",
            "=1.0.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.1",
        "package_redirect_name": "xero",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.1",
        "package_redirect_id": "fivetran/xero",
    },
    "fivetran/youtube_analytics_source": {
        "latest_version": "=1.1.0",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.1.0",
        "fusion_compatible_versions": ["=0.1.0", "=1.1.0"],
        "fusion_incompatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.0.1",
            "=1.0.2",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.1.0",
        "package_redirect_name": "youtube_analytics",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.1.0",
        "package_redirect_id": "fivetran/youtube_analytics",
    },
    "fivetran/zendesk_source": {
        "latest_version": "=1.2.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=1.2.1",
        "fusion_compatible_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.6.0",
            "=0.7.0",
            "=0.7.1",
            "=1.2.0-a1",
            "=1.2.0-a2",
            "=1.2.0",
            "=1.2.1",
        ],
        "fusion_incompatible_versions": [
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.11.0",
            "=0.11.1",
            "=0.11.2",
            "=0.12.0",
            "=0.13.0",
            "=0.13.1",
            "=0.14.0",
            "=0.15.0",
            "=0.16.0",
            "=0.17.0",
            "=0.18.0",
            "=0.18.1",
            "=0.19.0-a1",
            "=0.19.0",
            "=0.19.1",
            "=0.19.2",
            "=0.19.3",
            "=0.2.0",
            "=0.20.0",
            "=0.21.0-a1",
            "=0.21.0-a2",
            "=0.21.0",
            "=0.22.0-a1",
            "=0.22.0-a2",
            "=0.22.0",
            "=0.23.0-a1",
            "=0.23.0",
            "=0.23.1-a1",
            "=0.24.0",
            "=0.24.1",
            "=0.24.2",
            "=0.25.0-a1",
            "=0.25.0",
            "=0.25.1-a1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.2",
            "=0.8.0-b1",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.9.0",
            "=0.9.1",
            "=1.0.0",
            "=1.0.1",
            "=1.1.0-a1",
            "=1.1.0-a2",
            "=1.1.0",
            "=1.1.1-a1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.1",
        "package_redirect_name": "zendesk",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.1",
        "package_redirect_id": "fivetran/zendesk",
    },
    "fivetran/zuora_source": {
        "latest_version": "=1.2.0",
        "oldest_fusion_compatible_version": "=1.2.0",
        "latest_fusion_compatible_version": "=1.2.0",
        "fusion_compatible_versions": ["=1.2.0"],
        "fusion_incompatible_versions": [
            "=0.1.0",
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.3.1",
            "=0.3.2-a1",
            "=0.3.2-a2",
            "=0.3.2",
            "=0.4.0",
            "=0.5.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
        ],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=1.2.0",
        "package_redirect_name": "zuora",
        "package_redirect_namespace": "fivetran",
        "latest_version_incl_prerelease": "=1.2.0",
        "package_redirect_id": "fivetran/zuora",
    },
    "jitsucom/dbt-jitsu": {
        "latest_version": "=0.1.1",
        "oldest_fusion_compatible_version": "=0.1.0",
        "latest_fusion_compatible_version": "=0.1.1",
        "fusion_compatible_versions": ["=0.1.0", "=0.1.1", "=0.1.0"],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [],
        "package_latest_version_index_json": "=0.1.1",
        "package_redirect_name": "jitsu",
        "package_redirect_namespace": "jitsucom",
        "latest_version_incl_prerelease": "=0.1.1",
        "package_redirect_id": "jitsucom/jitsu",
    },
    "tailsdotcom/dbt_artifacts": {
        "latest_version": "=2.10.0",
        "oldest_fusion_compatible_version": "=0.2.0",
        "latest_fusion_compatible_version": "=2.10.0",
        "fusion_compatible_versions": [
            "=0.2.0",
            "=0.2.1",
            "=0.3.0",
            "=0.4.0",
            "=0.4.1",
            "=0.4.2",
            "=0.4.3",
            "=0.4.4",
            "=0.5.0",
            "=0.6.0",
            "=0.7.0",
            "=0.8.0",
            "=1.0.0",
            "=1.1.0",
            "=1.1.1",
            "=1.1.2",
            "=1.2.0",
            "=2.0.0",
            "=2.1.0",
            "=2.1.1",
            "=2.10.0",
            "=2.2.0",
            "=2.2.1",
            "=2.2.2",
            "=2.2.3",
            "=2.3.0",
        ],
        "fusion_incompatible_versions": [
            "=2.4.0",
            "=2.4.1",
            "=2.4.2",
            "=2.4.3",
            "=2.5.0",
            "=2.6.0",
            "=2.6.1",
            "=2.6.2",
            "=2.6.3",
            "=2.6.4",
            "=2.7.0",
            "=2.8.0",
            "=2.9.0",
            "=2.9.1",
            "=2.9.2",
            "=2.9.3",
        ],
        "unknown_compatibility_versions": ["=0.1.0"],
        "package_latest_version_index_json": "=2.10.0",
        "package_redirect_name": "dbt_artifacts",
        "package_redirect_namespace": "brooklyn-data",
        "latest_version_incl_prerelease": "=2.10.0",
        "package_redirect_id": "brooklyn-data/dbt_artifacts",
    },
    "tuva-health/chronic_conditions": {
        "latest_version": "=0.1.8",
        "oldest_fusion_compatible_version": None,
        "latest_fusion_compatible_version": None,
        "fusion_compatible_versions": [],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
        ],
        "package_latest_version_index_json": "=0.1.8",
        "package_redirect_name": "cms_chronic_conditions",
        "package_redirect_namespace": "tuva-health",
        "latest_version_incl_prerelease": "=0.1.8",
        "package_redirect_id": "tuva-health/cms_chronic_conditions",
    },
    "tuva-health/core": {
        "latest_version": "=0.15.5",
        "oldest_fusion_compatible_version": "=0.3.1",
        "latest_fusion_compatible_version": "=0.15.5",
        "fusion_compatible_versions": [
            "=0.3.1",
            "=0.3.10",
            "=0.3.11",
            "=0.3.12",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.8",
            "=0.3.9",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.12.5",
            "=0.12.6",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.14.10",
            "=0.14.11",
            "=0.14.12",
            "=0.14.13",
            "=0.14.14",
            "=0.14.15",
            "=0.14.16",
            "=0.14.17",
            "=0.14.18",
            "=0.14.2",
            "=0.14.3",
            "=0.14.4",
            "=0.14.5",
            "=0.14.6",
            "=0.14.7",
            "=0.14.8",
            "=0.14.9",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.15.3",
            "=0.15.4",
            "=0.15.5",
            "=0.3.13",
            "=0.3.14",
            "=0.3.15",
            "=0.3.16",
            "=0.3.17",
            "=0.3.18",
            "=0.3.19",
            "=0.3.7",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.10",
            "=0.5.11",
            "=0.5.12",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.5.8",
            "=0.5.9",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.10",
            "=0.7.11",
            "=0.7.12",
            "=0.7.13",
            "=0.7.14",
            "=0.7.15",
            "=0.7.16",
            "=0.7.17",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.7.9",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.8.7",
            "=0.9.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
        ],
        "package_latest_version_index_json": "=0.15.5",
        "package_redirect_name": "the_tuva_project",
        "package_redirect_namespace": "tuva-health",
        "latest_version_incl_prerelease": "=0.15.5",
        "package_redirect_id": "tuva-health/the_tuva_project",
    },
    "tuva-health/tuva": {
        "latest_version": "=0.15.5",
        "oldest_fusion_compatible_version": "=0.3.1",
        "latest_fusion_compatible_version": "=0.15.5",
        "fusion_compatible_versions": [
            "=0.3.1",
            "=0.3.10",
            "=0.3.11",
            "=0.3.12",
            "=0.3.2",
            "=0.3.3",
            "=0.3.4",
            "=0.3.5",
            "=0.3.6",
            "=0.3.8",
            "=0.3.9",
            "=0.10.0",
            "=0.10.1",
            "=0.10.2",
            "=0.10.3",
            "=0.10.4",
            "=0.10.5",
            "=0.10.6",
            "=0.10.7",
            "=0.10.8",
            "=0.11.0",
            "=0.12.0",
            "=0.12.1",
            "=0.12.2",
            "=0.12.3",
            "=0.12.4",
            "=0.12.5",
            "=0.12.6",
            "=0.13.0",
            "=0.13.1",
            "=0.13.2",
            "=0.14.0",
            "=0.14.1",
            "=0.14.10",
            "=0.14.11",
            "=0.14.12",
            "=0.14.13",
            "=0.14.14",
            "=0.14.15",
            "=0.14.16",
            "=0.14.17",
            "=0.14.18",
            "=0.14.2",
            "=0.14.3",
            "=0.14.4",
            "=0.14.5",
            "=0.14.6",
            "=0.14.7",
            "=0.14.8",
            "=0.14.9",
            "=0.15.0",
            "=0.15.1",
            "=0.15.2",
            "=0.15.3",
            "=0.15.4",
            "=0.15.5",
            "=0.3.13",
            "=0.3.14",
            "=0.3.15",
            "=0.3.16",
            "=0.3.17",
            "=0.3.18",
            "=0.3.19",
            "=0.3.7",
            "=0.4.1",
            "=0.5.0",
            "=0.5.1",
            "=0.5.10",
            "=0.5.11",
            "=0.5.12",
            "=0.5.2",
            "=0.5.3",
            "=0.5.4",
            "=0.5.5",
            "=0.5.6",
            "=0.5.7",
            "=0.5.8",
            "=0.5.9",
            "=0.6.0",
            "=0.6.1",
            "=0.7.0",
            "=0.7.1",
            "=0.7.10",
            "=0.7.11",
            "=0.7.12",
            "=0.7.13",
            "=0.7.14",
            "=0.7.15",
            "=0.7.16",
            "=0.7.17",
            "=0.7.2",
            "=0.7.3",
            "=0.7.4",
            "=0.7.5",
            "=0.7.6",
            "=0.7.7",
            "=0.7.8",
            "=0.7.9",
            "=0.8.0",
            "=0.8.1",
            "=0.8.2",
            "=0.8.3",
            "=0.8.4",
            "=0.8.5",
            "=0.8.6",
            "=0.8.7",
            "=0.9.0",
        ],
        "fusion_incompatible_versions": [],
        "unknown_compatibility_versions": [
            "=0.1.0",
            "=0.1.1",
            "=0.1.2",
            "=0.1.3",
            "=0.1.4",
            "=0.1.5",
            "=0.1.6",
            "=0.1.7",
            "=0.1.8",
            "=0.1.9",
            "=0.2.0",
            "=0.2.1",
            "=0.2.2",
            "=0.2.3",
            "=0.2.4",
            "=0.2.5",
            "=0.2.6",
            "=0.3.0",
        ],
        "package_latest_version_index_json": "=0.15.5",
        "package_redirect_name": "the_tuva_project",
        "package_redirect_namespace": "tuva-health",
        "latest_version_incl_prerelease": "=0.15.5",
        "package_redirect_id": "tuva-health/the_tuva_project",
    },
}
