"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * CodePipeline Action to deploy an ECS Service.
 */
class EcsDeployAction extends action_1.Action {
    constructor(props) {
        var _b;
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            provider: 'ECS',
            artifactBounds: common_1.deployArtifactBounds(),
            inputs: [determineInputArtifact(props)],
            resource: props.service,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_EcsDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const deploymentTimeout = (_b = props.deploymentTimeout) === null || _b === void 0 ? void 0 : _b.toMinutes({ integral: true });
        if (deploymentTimeout !== undefined && (deploymentTimeout < 1 || deploymentTimeout > 60)) {
            throw new Error(`Deployment timeout must be between 1 and 60 minutes, got: ${deploymentTimeout}`);
        }
        this.props = props;
        this.deploymentTimeout = deploymentTimeout;
    }
    bound(_scope, _stage, options) {
        var _b;
        // permissions based on CodePipeline documentation:
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-custom-role.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'ecs:DescribeServices',
                'ecs:DescribeTaskDefinition',
                'ecs:DescribeTasks',
                'ecs:ListTasks',
                'ecs:RegisterTaskDefinition',
                'ecs:UpdateService',
            ],
            resources: ['*'],
        }));
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: ['iam:PassRole'],
            resources: ['*'],
            conditions: {
                StringEqualsIfExists: {
                    'iam:PassedToService': [
                        'ec2.amazonaws.com',
                        'ecs-tasks.amazonaws.com',
                    ],
                },
            },
        }));
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                ClusterName: this.props.service.cluster.clusterName,
                ServiceName: this.props.service.serviceName,
                FileName: (_b = this.props.imageFile) === null || _b === void 0 ? void 0 : _b.fileName,
                DeploymentTimeout: this.deploymentTimeout,
            },
        };
    }
}
exports.EcsDeployAction = EcsDeployAction;
_a = JSII_RTTI_SYMBOL_1;
EcsDeployAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.EcsDeployAction", version: "1.153.1" };
function determineInputArtifact(props) {
    if (props.imageFile && props.input) {
        throw new Error("Exactly one of 'input' or 'imageFile' can be provided in the ECS deploy Action");
    }
    if (props.imageFile) {
        return props.imageFile.artifact;
    }
    if (props.input) {
        return props.input;
    }
    throw new Error("Specifying one of 'input' or 'imageFile' is required for the ECS deploy Action");
}
//# sourceMappingURL=data:application/json;base64,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