# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-02-26 11:39
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models
from pymess.config import settings


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('pymess', '0004_dialermessage_is_final_state'),
    ]

    operations = [
        migrations.CreateModel(
            name='PushNotificationMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('sent_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='sent at')),
                ('recipient', models.CharField(max_length=20, verbose_name='recipient')),
                ('content', models.TextField(verbose_name='content')),
                ('template_slug', models.SlugField(blank=True, editable=False, max_length=100, null=True,
                                                   verbose_name='slug')),
                ('backend', models.CharField(blank=True, editable=False, max_length=250, null=True,
                                             verbose_name='backend')),
                ('error', models.TextField(blank=True, editable=False, null=True, verbose_name='error')),
                ('extra_data', models.TextField(blank=True, editable=False, null=True,
                                                          verbose_name='extra data')),
                ('extra_sender_data', models.TextField(blank=True, editable=False, null=True,
                                                                 verbose_name='extra sender data')),
                ('tag', models.SlugField(blank=True, editable=False, null=True, verbose_name='tag')),
                ('state', models.PositiveIntegerField(choices=[(1, 'waiting'), (2, 'sent'), (3, 'error'), (4, 'debug')],
                                                      editable=False, verbose_name='state')),
                ('heading', models.TextField(verbose_name='heading')),
                ('url', models.URLField(null=True, blank=True, verbose_name='URL')),
            ],
            options={
                'verbose_name': 'push notification',
                'verbose_name_plural': 'push notifications',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PushNotificationMessageRelatedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(verbose_name='ID of the related object')),
                ('object_id_int', models.PositiveIntegerField(blank=True, db_index=True, null=True,
                                                              verbose_name='ID of the related object in int format')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                   to='contenttypes.ContentType',
                                                   verbose_name='content type of the related object')),
                ('push_notification_message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                                related_name='related_objects',
                                                                to='pymess.PushNotificationMessage',
                                                                verbose_name='push notification message')),
            ],
            options={
                'verbose_name': 'related object of a push notification message',
                'verbose_name_plural': 'related objects of a push notification message',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PushNotificationTemplate',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('slug', models.SlugField(editable=False, max_length=100, primary_key=True, serialize=False,
                                          verbose_name='slug')),
                ('body', models.TextField(null=True, verbose_name='message body')),
                ('heading', models.TextField(verbose_name='heading')),
                ('is_active', models.BooleanField(default=True, verbose_name='is_active')),
            ],
            options={
                'verbose_name': 'push notification template',
                'verbose_name_plural': 'push notification templates',
                'ordering': ('-created_at',),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='pushnotificationmessage',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='push_notifications', to=settings.PUSH_NOTIFICATION_TEMPLATE_MODEL,
                                    verbose_name='template'),
        ),
    ]
