# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['acmhelper',
 'acmhelper.cli',
 'acmhelper.cli.system',
 'acmhelper.cli.system.default',
 'acmhelper.gen',
 'acmhelper.gen.graph']

package_data = \
{'': ['*']}

install_requires = \
['loguru>=0.6.0,<0.7.0', 'typer[all]>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['helper = AcmHelper.cli.main:app']}

setup_kwargs = {
    'name': 'acmhelper',
    'version': '0.1.1',
    'description': 'The helper for Acmer',
    'long_description': '# AcmHelper\n\n本地环境下的 Polygon , 但不止于 Polygon.\n\n你可以\n\n- 快速创建具有合理结构的题目文件夹\n- 指定 `std` , `checker` , `validator` , `interactor` \n- 使用不同语言完成不同部分 (cpp/py)\n- 使用额外的程序来测试数据的质量\n- 使用预制的数据生成器快速生成具有某些特征的数据\n- 同时使用多种数据生成器 , 并可以指定每个程序所接受的生成器\n- 享受由 `rich` , `typer` 带来的美丽\n\nTODO\n\n- [ ] 使 `helper sys run` 可以执行 `save` 下的数据\n- [ ] 添加对 `Validator` 和 `Interactor` 的支持\n- [ ] 根据 `hash` 动态选择是否编译\n\n## 简易使用说明\n\n得益于 `typer` , 关于题目生成的功能都可以通过输入 `helper --help` 大致了解\n\n### 安装\n\n`pip install acmhelper`\n\n**你需要具有全局的`g++` , 默认使用 `-std=c++17` 编译** , 可在设置修改\n\n### 快速从数据文件得到渲染的图\n\n**如果想要使用图的渲染功能 , 你需要下载 Graphviz 的二进制文件并且将其加入 Path**\n\n对于形式为 \n\n```txt\nn m (optional)\nu1 v1 w1 (w1 is optional)\n...\nun vn wn\n```\n\n的数据 , 可以使用 `helper render` 来快速渲染\n\n首先创建文件 `test.in` , 写入一个不连通的 `DAG`\n\n```txt\n5 2\n1 2 3\n1 3 5\n1 5 -7\n```\n\n在该文件目录下输入 `helper render -dic test.in`\n\n查看 `test.png` , 应该如下所示\n\n![test](Assert/test.png)\n\n具体的设置请使用 `helper render --help` 查看\n\n### 创建一道题目(以 "输出一个绝对值小于输入数字绝对值的整数"为例(`int`范围内))\n\n首先新建文件夹 `Problem` , 然后在此文件夹下打开命令行 , 输入 `helper sys init` , 回答问题 , 完成初始化\n\n如果初始化正确的话你的目录结构应该向下面的一样(部分文件可能没有 , 这需要我们后续手动创建)\n\n```txt\n题目目录结构\n- Problem\n    - config.json\n    - std.cpp/py\n    - testlib.h (optional)\n    - checker.cpp/py (optional with "testlib.h")\n    - interactor.cpp (optional with "testlib.h") (Not implemented)\n    - validator.cpp (optional with "testlib.h") (Not implemented)\n    - generator\n        - make1.cpp\n        - make2.py\n    - accept\n        - ac1.cpp\n        - ac2.py\n    - wrong\n        - wa1.cpp\n        - wa2.py\n    - exec\n        - something executable...\n    - data\n        - auto\n            - in\n                - 1.make1.in\n                - 2.make2.in\n            - out\n                - 1.ac1.out\n                - 1.wa1.out\n        - save\n            - in\n                - 1.make1.in\n                - 2.make2.in\n            - out\n                - 1.ac1.out\n                - 1.wa1.out\n    - log\n        - 20220303.log\n    - temp\n        - someting temporary...\n    - output\n        - something...\n```\n\n然后打开 `std.cpp` , 写入以下代码\n\n```cpp\n#include <bits/stdc++.h>\nusing namespace std;\n\nint main() {\n    int a; \n    cin >> a; \n    cout << abs(a)/2 << \'\\n\'; \n    return 0;\n}\n```\n\n保存后 , 我们来写第一个数据生成器 `make1.py` , 它只用来生成大于 `0` 的数.\n\n在 `generator` 下创建文件 `make1.py` , 写入以下代码\n\n```py\nfrom random import randint\nprint(randint(1, 1000))\n```\n\n接下来只需要修改一些配置 , 就可以通过 `CLI` 来生成数据了\n\n打开文件 `config.json` , 将如下代码复制\n\n```json\n{\n    "gen_list": [\n        "make1"\n    ],\n    "accept_list": [],\n    "wrong_list": [],\n    "gen_link_code": {\n        "make1": [\n            "std"\n        ]\n    },\n    "gen_data_num": {\n        "make1": 10\n    },\n    "time_limit": 2,\n    "max_time_limit": 10,\n    "std": "std",\n    "checker": "checker",\n    "interactor": "",\n    "validator": "",\n    "gcc_version" 17\n}\n```\n\n这个文件描述的含义是 , 有一个生成器 `make1` , 其生成 10 组数据 , 生成的数据被用来运行 `std` , 没有额外的理论错误和理论正确的代码 , `Time_Limit_Exceed` 的上界是 `2s` , 程序被 kill 掉的上界是 `10s` , std 的辨识名称为 `std` , checker 的辨识名称为 `checker` , 没有使用 `interactor` 和 `validator` , 使用 `-std=c++17` 编译\n\n保存后 , 输入 `helper sys run` , 你应该能看到我们暂时性的成功\n\n接下来 , 我们来添加额外的生成器,测试代码和 `checker` 来完善这道题\n\n在 `wrong` 下创建 `wa1.cpp` 和 `wa2.py` , 然后写入下述代码\n\n```cpp\n#include <bits/stdc++.h>\nusing namespace std;\n\nint main() {\n    int a; \n    cin >> a; \n    cout << a-1 << \'\\n\'; \n    return 0;\n}\n```\n\n\n\n```py\nn = int(input())\nprint(n + 1)\n```\n\n\n\n在 `accept` 下创建 `ac1.cpp` 写入如下代码\n\n```cpp\n#include <bits/stdc++.h>\nusing namespace std;\n\nint main() {\n    int a; \n    cin >> a; \n    if(a >= 0) { cout << a-1 << \'\\n\'; }\n    else { cout << a+1 << \'\\n\'; }\n    return 0;\n}\n```\n\n可以发现 , `wrong` 下的两个代码分别会在 `a<0` 和 `a>0` 时出错 , 所以我们再新建一个生成器\n\n在 `generator` 下创建 `make2.py` 写入如下代码 , 注意负号\n\n```py\nfrom random import randint\nprint(-randint(1, 1000))\n```\n\n可以发现这道题需要 `checker` , 打开 `checker.cpp` , 写入如下代码\n\n```cpp\n#include <bits/stdc++.h>\n#include "testlib.h"\nusing namespace std;\n\nint main(int argc,char** argv) {\n    registerTestlibCmd(argc,argv); // Required\n    int n = inf.readInt();\n    int m = ouf.readInt();\n    if(abs(m) < abs(n)) { quitf(_ok,"Correct!"); }\n    else { quitf(_wa,"Wrong Answer!"); }\n}\n```\n\n最后我们再修改一下 `config.json`\n\n```json\n{\n    "gen_list": [\n        "make1",\n        "make2"\n    ],\n    "accept_list": [\n        "ac1"\n    ],\n    "wrong_list": [\n        "wa1",\n        "wa2"\n    ],\n    "gen_link_code": {\n        "make1": [\n            "std",\n            "ac1",\n            "wa1",\n            "wa2"\n        ],\n        "make2": [\n            "std",\n            "ac1",\n            "wa1",\n            "wa2"\n        ]\n    },\n    "gen_data_num": {\n        "make1": 10,\n        "make2": 10\n    },\n    "time_limit": 2,\n    "max_time_limit": 10,\n    "std": "std",\n    "checker": "checker",\n    "interactor": "",\n    "validator": "",\n    "gcc_version": 17\n}\n```\n\n最后输入 `helper sys run` , 完成了.\n\n如果字体和终端合适 , 你应该会看到像这样的东西\n\n![result](Assert/table.png)\n\n不出意料地 , 两个不对的程序在合适的地方不对了.\n\n作为结尾 , 我们来使用 `CLI` 打包数据以及 `checker`\n\n输入 `helper sys add 1 2 3 4 5 6 7 8 9 10` , 这样我们就将前10组输入数据和 `std` 的输出数据从 `auto` 移动到了 `save` 下 , 值得注意的是 , 数据的编号会自动地递增 , 所以不用担心数据覆盖问题\n\n然后输入 `helper sys output checker.cc` , 查看 `output` 文件夹下 , 你应该可以看到名为 `data.zip` 的文件 , 其中的所有文件都被合适的重命名了 , 特殊的 , `checker` 被重命名为了 `checker.cc`\n\n更细节的使用请参考 `helper sys --help` , `helper sys add --help` 等',
    'author': 'CherryGS',
    'author_email': 'tickten@outlook.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
