# -*- coding: utf-8 -*-
"""
    pip_services3_commons.validate.ValidationResult
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Validation result implementation

    :copyright: Conceptual Vision Consulting LLC 2018-2019, see AUTHORS for more details.
    :license: MIT, see LICENSE for more details.
"""


class ValidationResult(object):
    """
    Result generated by schema validation
    """

    def __init__(self, path=None, type=None, code=None, message=None, expected=None, actual=None):
        """
        Creates a new instance of validation ressult and sets its values.

        :param path: a dot notation path of the validated element.

        :param type: a type of the validation result: Information, Warning, or Error.

        :param code: an error code.

        :param message: a human readable message.

        :param expected: an value expected by schema validation.

        :param actual: an actual value found by schema validation.
        """
        self._path = path
        self._type = type
        self._code = code
        self._message = message
        self._expected = expected
        self._actual = actual

    def get_path(self):
        """
        Gets dot notation path of the validated element.

        :return: the path of the validated element.
        """
        return self._path

    def get_type(self):
        """
        Gets the type of the validation result: Information, Warning, or Error.
        See :class: `ValidationResultType`

        :return: the type of the validation result.
        """
        return self._type

    def get_code(self):
        """
        Gets the error code.

        :return: the error code
        """
        return self._code

    def get_message(self):
        """
        Gets the human readable message.

        :return: the result message.
        """
        return self._message

    def get_expected(self):
        """
        Gets the value expected by schema validation.

        :return: the expected value.
        """
        return self._expected

    def get_actual(self):
        """
        Gets the actual value found by schema validation.

        :return: the actual value.
        """
        return self._actual

    def to_json(self):
        return {
            'path': self._path,
            'type': self._type,
            'code': self._code,
            'message': self._message,
            'expected': self._expected,
            'actual': self._actual
        }
