# coding: utf-8

"""
    Catalog Next API.

    This documentation describes the Catalog Next API for all versions and other miscellaneous endpoints.  # noqa: E501

    OpenAPI spec version: 1.16.6+dcs
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dcs_catalog_client.api_client import ApiClient


class V4Api(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def catalog_search(self, **kwargs):  # noqa: E501
        """Catalog search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.catalog_search(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str owner: search only for entries with the given owner name(s).
        :param str repo: search only for entries with the given repo name(s).
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.catalog_search_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.catalog_search_with_http_info(**kwargs)  # noqa: E501
            return data

    def catalog_search_with_http_info(self, **kwargs):  # noqa: E501
        """Catalog search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.catalog_search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str owner: search only for entries with the given owner name(s).
        :param str repo: search only for entries with the given repo name(s).
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['q', 'owner', 'repo', 'tag', 'lang', 'stage', 'subject', 'checking_level', 'book', 'include_history', 'include_metadata', 'show_ingredients', 'sort', 'order', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method catalog_search" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'owner' in params:
            query_params.append(('owner', params['owner']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'lang' in params:
            query_params.append(('lang', params['lang']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('stage', params['stage']))  # noqa: E501
        if 'subject' in params:
            query_params.append(('subject', params['subject']))  # noqa: E501
        if 'checking_level' in params:
            query_params.append(('checkingLevel', params['checking_level']))  # noqa: E501
        if 'book' in params:
            query_params.append(('book', params['book']))  # noqa: E501
        if 'include_history' in params:
            query_params.append(('includeHistory', params['include_history']))  # noqa: E501
        if 'include_metadata' in params:
            query_params.append(('includeMetadata', params['include_metadata']))  # noqa: E501
        if 'show_ingredients' in params:
            query_params.append(('showIngredients', params['show_ingredients']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['AccessToken', 'AuthorizationHeaderToken', 'BasicAuth', 'SudoHeader', 'SudoParam', 'TOTPHeader', 'Token']  # noqa: E501

        return self.api_client.call_api(
            '/v4/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogSearchResultsV4',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v4_get_catalog_entry(self, owner, repo, tag, **kwargs):  # noqa: E501
        """Catalog entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_get_catalog_entry(owner, repo, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str tag: release tag or default branch (required)
        :return: CatalogV4
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v4_get_catalog_entry_with_http_info(owner, repo, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.v4_get_catalog_entry_with_http_info(owner, repo, tag, **kwargs)  # noqa: E501
            return data

    def v4_get_catalog_entry_with_http_info(self, owner, repo, tag, **kwargs):  # noqa: E501
        """Catalog entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_get_catalog_entry_with_http_info(owner, repo, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str tag: release tag or default branch (required)
        :return: CatalogV4
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v4_get_catalog_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `v4_get_catalog_entry`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `v4_get_catalog_entry`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if self.api_client.client_side_validation and ('tag' not in params or
                                                       params['tag'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag` when calling `v4_get_catalog_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['AccessToken', 'AuthorizationHeaderToken', 'BasicAuth', 'SudoHeader', 'SudoParam', 'TOTPHeader', 'Token']  # noqa: E501

        return self.api_client.call_api(
            '/v4/entry/{owner}/{repo}/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogV4',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v4_get_metadata(self, owner, repo, tag, **kwargs):  # noqa: E501
        """Catalog entry metadata (manifest.yaml in JSON format)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_get_metadata(owner, repo, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str tag: release tag or default branch (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v4_get_metadata_with_http_info(owner, repo, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.v4_get_metadata_with_http_info(owner, repo, tag, **kwargs)  # noqa: E501
            return data

    def v4_get_metadata_with_http_info(self, owner, repo, tag, **kwargs):  # noqa: E501
        """Catalog entry metadata (manifest.yaml in JSON format)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_get_metadata_with_http_info(owner, repo, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str tag: release tag or default branch (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v4_get_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `v4_get_metadata`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `v4_get_metadata`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if self.api_client.client_side_validation and ('tag' not in params or
                                                       params['tag'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag` when calling `v4_get_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['AccessToken', 'AuthorizationHeaderToken', 'BasicAuth', 'SudoHeader', 'SudoParam', 'TOTPHeader', 'Token']  # noqa: E501

        return self.api_client.call_api(
            '/v4/entry/{owner}/{repo}/{tag}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v4_search_owner(self, owner, **kwargs):  # noqa: E501
        """Catalog search by owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_search_owner(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: owner of entries (required)
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str repo: search only for entries with the given repo name(s).
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v4_search_owner_with_http_info(owner, **kwargs)  # noqa: E501
        else:
            (data) = self.v4_search_owner_with_http_info(owner, **kwargs)  # noqa: E501
            return data

    def v4_search_owner_with_http_info(self, owner, **kwargs):  # noqa: E501
        """Catalog search by owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_search_owner_with_http_info(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: owner of entries (required)
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str repo: search only for entries with the given repo name(s).
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'q', 'repo', 'tag', 'lang', 'stage', 'subject', 'checking_level', 'book', 'include_history', 'include_metadata', 'show_ingredients', 'sort', 'order', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v4_search_owner" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `v4_search_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'lang' in params:
            query_params.append(('lang', params['lang']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('stage', params['stage']))  # noqa: E501
        if 'subject' in params:
            query_params.append(('subject', params['subject']))  # noqa: E501
        if 'checking_level' in params:
            query_params.append(('checkingLevel', params['checking_level']))  # noqa: E501
        if 'book' in params:
            query_params.append(('book', params['book']))  # noqa: E501
        if 'include_history' in params:
            query_params.append(('includeHistory', params['include_history']))  # noqa: E501
        if 'include_metadata' in params:
            query_params.append(('includeMetadata', params['include_metadata']))  # noqa: E501
        if 'show_ingredients' in params:
            query_params.append(('showIngredients', params['show_ingredients']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['AccessToken', 'AuthorizationHeaderToken', 'BasicAuth', 'SudoHeader', 'SudoParam', 'TOTPHeader', 'Token']  # noqa: E501

        return self.api_client.call_api(
            '/v4/search/{owner}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogSearchResultsV4',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v4_search_repo(self, owner, repo, **kwargs):  # noqa: E501
        """Catalog search by repo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_search_repo(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v4_search_repo_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.v4_search_repo_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def v4_search_repo_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Catalog search by repo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v4_search_repo_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: name of the owner (required)
        :param str repo: name of the repo (required)
        :param str q: keyword(s). Can use multiple `q=<keyword>`s or commas for more than one keyword
        :param str tag: search only for entries with the given release tag(s)
        :param str lang: search only for entries with the given language(s)
        :param str stage: specifies which release stage to be return of these stages: \"prod\" - return only the production releases (default); \"preprod\" - return the pre-production release if it exists instead of the production release; \"draft\" - return the draft release if it exists instead of pre-production or production release; \"latest\" -return the default branch (e.g. master) if it is a valid RC instead of the above
        :param str subject: search only for entries with the given subject(s). Must match the entire string (case insensitive)
        :param str checking_level: search only for entries with the given checking level(s). Can be 1, 2 or 3
        :param str book: search only for entries with the given book(s) (project ids)
        :param bool include_history: if true, all releases, not just the latest, are included. Default is false
        :param bool include_metadata: if false, only subject and title are searched with query terms, if true all metadata values are searched. Default is true
        :param bool show_ingredients: if true, a list of the projects in the resource and their file paths will be listed for each entry. Default is false
        :param str sort: sort repos alphanumerically by attribute. Supported values are \"subject\", \"title\", \"reponame\", \"tag\", \"released\", \"lang\", \"releases\", \"stars\", \"forks\". Default is by \"language\", \"subject\" and then \"tag\"
        :param str order: sort order, either \"asc\" (ascending) or \"desc\" (descending). Default is \"asc\", ignored if \"sort\" is not specified.
        :param int page: page number of results to return (1-based)
        :param int limit: page size of results, maximum page size is 50
        :return: CatalogSearchResultsV4
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'q', 'tag', 'lang', 'stage', 'subject', 'checking_level', 'book', 'include_history', 'include_metadata', 'show_ingredients', 'sort', 'order', 'page', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v4_search_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `v4_search_repo`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `v4_search_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'lang' in params:
            query_params.append(('lang', params['lang']))  # noqa: E501
        if 'stage' in params:
            query_params.append(('stage', params['stage']))  # noqa: E501
        if 'subject' in params:
            query_params.append(('subject', params['subject']))  # noqa: E501
        if 'checking_level' in params:
            query_params.append(('checkingLevel', params['checking_level']))  # noqa: E501
        if 'book' in params:
            query_params.append(('book', params['book']))  # noqa: E501
        if 'include_history' in params:
            query_params.append(('includeHistory', params['include_history']))  # noqa: E501
        if 'include_metadata' in params:
            query_params.append(('includeMetadata', params['include_metadata']))  # noqa: E501
        if 'show_ingredients' in params:
            query_params.append(('showIngredients', params['show_ingredients']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['AccessToken', 'AuthorizationHeaderToken', 'BasicAuth', 'SudoHeader', 'SudoParam', 'TOTPHeader', 'Token']  # noqa: E501

        return self.api_client.call_api(
            '/v4/search/{owner}/{repo}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CatalogSearchResultsV4',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
