# AUTOGENERATED! DO NOT EDIT! File to edit: 02_model.ipynb (unless otherwise specified).

__all__ = ['CNNTabularModel']

# Cell
from fastai.vision import *
from fastai.tabular import *

# Cell
class CNNTabularModel(Module):
    def __init__(self, cnn_model, tabular_model, layers, ps, out_sz):
        """
        Hybrid CNN and tabular model.
        Image and tabular data will pass through a cnn model and tabular model, respectively.
        The outputs from the two models will subsequently be concatenated will be fed into a few
        fully connected layers to generate the final output.

        :param cnn_model: cnn model for image data
        :param tabular_model: tabular model to tabular data
        :param layers: fully connected layers for concatenated data
        :ps: dropouts
        :out_sz: size of the final output
        """
        super().__init__()
        self.cnn_model = cnn_model
        self.tabular_model = tabular_model

        ps = ifnone(ps, [0]*len(layers))
        ps = listify(ps, layers)
        sizes = layers + [out_sz]
        actns = [nn.ReLU(inplace=True) for _ in range(len(sizes)-2)] + [None]

        layers = []
        for n_in,n_out,dp,act in zip(sizes[:-1],sizes[1:], ps, actns):
            layers += bn_drop_lin(n_in, n_out, bn=True, p=dp, actn=act)
        self.layers = nn.Sequential(*layers)


    def forward(self, *x):
        # image
        x_image = self.cnn_model(x[0])
        # tabular, expand categorical and continous data
        x_tab = self.tabular_model(*x[1])

        # concatenate the outputs
        x = torch.cat([x_image, x_tab], 1)

        # pass through fully connected layers
        x = self.layers(x)
        return x