# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['bleached']
setup_kwargs = {
    'name': 'bleached',
    'version': '1.0.0',
    'description': 'Validate HTML against a small subset (for example generated by bleach)',
    'long_description': '# bleached\n\nThis is a small HTML checker. It can validate that HTML code is safe.\n\nIt does not aim to support the entire HTML spec, rather it focuses on checking HTML that has been run through a sanitizer (such as [bleach](https://github.com/mozilla/bleach)).\n\n## How to use?\n\n```\n$ pip install bleached\n$ python3\n>>> import bleached\n>>> bleached.is_html_bleached(\'<p>Hello world</p>\')\nTrue\n>>> bleached.is_html_bleached(\'<script>alert("Hello world");</script>\')\nFalse\n>>> bleached.check_html(\'<p>Hello world</p>\')\n>>> bleached.check_html(\'<script>alert("Hello world");</script>\')\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nbleached.UnsafeInput: Line 1 character 8 (input index 7): Found forbidden opening tag \'script\'\n```\n\n## Why use this?\n\n[bleach](https://github.com/mozilla/bleach) is a great library for sanitizing untrusted HTML. You should use it instead of this where possible.\n\nHowever, it offers no way to check that a piece of HTML has been sanitized. Running the HTML through bleach again will only work if you have the exact same version, as bleach makes no guarantee of stability of their input. This is where bleached is useful.\n\n## Warnings\n\n* No validation of attributes is performed. If you choose to allow an attribute, it is up to you to validate the values.\n* This accepts a much smaller subset of HTML than web browsers. Be ready for false negatives if you use this to validate HTML documents.\n',
    'author': 'Remi Rampin',
    'author_email': 'remi@rampin.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'py_modules': modules,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
