# Copyright (C) 2021 Satoshi Konno. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# To the extent possible under law, Sony Computer Science Laboratories, Inc has waived 
# all copyright and related or neighboring rights to ECHONETLite-ObjectDatabase. 
# This work is published from: Japan.
#
# GENERATED FROM objects.pl DO NOT EDIT THIS FILE.

from .reader import Manufacture, Object, Property

__std_mra_objects: dict = {}


def get_all_std_mra_objects() -> dict:
    return __std_mra_objects

# Super class (0x0000)
obj = Object("Super class", 0x00, 0x00)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0x81, "Installation location", "raw", 0, "required", "required", "required"))
obj.add_property(Property(0x81, "Installation location", "", 0, "required", "required", "required"))
obj.add_property(Property(0x82, "Standard version information", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x83, "Identification number", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x83, "Identification number", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x84, "Measured instantaneous power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x85, "Measured cumulative power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x86, "Manufacturer's fault code", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x87, "Current limit setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x88, "Fault status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0x89, "Fault description", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8A, "Manufacturer code", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x8B, "Business facility code", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8C, "Product code", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8D, "Production number", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8E, "Production date", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8F, "Power-saving operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Location information", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Location information", "raw", 0, "optional", "optional", "required"))
obj.add_property(Property(0x93, "Remote control setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x93, "Remote controll setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x97, "Current time setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "date", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x99, "Power limit setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0x9A, "Cumulative operating time", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x9D, "Status change announcement property map", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9E, "Set property map", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9F, "Get property map", "raw", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x00)] = obj

# Node profile (0x0EF0)
obj = Object("Node profile", 0x0E, 0xF0)
obj.add_property(Property(0x80, "Operating status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0x82, "Version information", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x83, "Identification number", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x88, "Fault status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x89, "Fault description", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8A, "Manufacturer code", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x8B, "Business facility code", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8C, "Product code", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8D, "Production number", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x8E, "Production date", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x9D, "Status change announcement property map", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9E, "Set property map", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x9F, "Get property map", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Unique identifier data", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Number of self-node instances", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Number of self-node classes", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Instance list notification", "object", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xD6, "Self-node instance list S", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Self-node class list S", "object", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x0E, 0xF0)] = obj

# Hybrid water heater (0x02A6)
obj = Object("Hybrid water heater", 0x02, 0xA6)
obj.add_property(Property(0xB0, "Automatic water heating setting", "state", 1, "optional", "optional", "required"))
obj.add_property(Property(0xB2, "Water heating status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB3, "Heater status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB6, "Hot water supply mode setting for auxiliary heat source machine", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Heater mode setting for auxiliary heat source machine.", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Linkage mode setting for solar power generation", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB9, "Solar power generations utilization time", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC3, "Hot water supply status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE1, "Measured amount of hot water remaining in tank", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0xA6)] = obj

# Switch (supporting JEM-A/HA terminals) (0x05FD)
obj = Object("Switch (supporting JEM-A/HA terminals)", 0x05, 0xFD)
obj.add_property(Property(0xE0, "Connected device", "raw", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x05, 0xFD)] = obj

# Instantaneous water heater (0x0272)
obj = Object("Instantaneous water heater", 0x02, 0x72)
obj.add_property(Property(0x90, "ON timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Set value of ON timer relative time", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Hot water heating status", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Set value of hot water temperature", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Hot water warmer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD4, "Bath water volume setting 4", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD5, "Bath water volume setting 4 Maximum settable level", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Volume setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Mute setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xDA, "Duration of Automatic operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Remaining Automatic operation time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Set value of bath temperature", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Bath water heater status", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Bath Auto mode setting", "state", 1, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE4, "Bath additional boil-up operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Bath hot water adding operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Bath water temperature lowering operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Bath hot water volume setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Bath hot water volume setting 2", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Shower hot water supply status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Kitchen hot water supply status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Hot water warmer ON timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Set value of hot water warmer ON timer time", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Bath hot water volume setting 3", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Bath operation status monitor", "state", 1, "optional", "notApplicable", "required"))
__std_mra_objects[(0x02, 0x72)] = obj

# Commercial showcase (0x03CE)
obj = Object("Commercial showcase", 0x03, 0xCE)
obj.add_property(Property(0xB0, "Operation mode", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB0, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xBD, "Used to acquire measurements of discharge temperature.", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xD0, "This property indicates the type of the showcase.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "This property indicates the type of the showcase door.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "This property indicates refrigerator type, such as built-in or separate.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "This property indicates the shape of the showcase.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "This property indicates the purpose of the showcase, either refrigeration or freezing.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Indicates on/off status of lighting installed inside the showcase.", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xE1, "Indicates ON/OFF status of lighting installed outside the showcase.", "state", 1, "optional", "optional", "required"))
obj.add_property(Property(0xE2, "Indicates on/off status of compressor when showcase and compressor are a single unit.", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Used to acquire internal temperature measurements inside the showcase.", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Indicates rated power consumption necessary when showcase is cooling.", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Indicates rated power consumption when heater is operating during showcase defrosting.", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Indicates rated power consumption when showcase is operating fan motor.", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Indicates on/off status of showcases with heater for hot function.", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Indicates type of lighting installed inside the showcase.", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Indicates type of lighting installed outside the showcase.", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Indicates lighting level in % installed inside of the showcase.", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Indicates lighting level in % installed outside of the showcase.", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Set temperature setting of inside the case and acquire the current setting.", "number", 0, "required", "required", "optional"))
__std_mra_objects[(0x03, 0xCE)] = obj

# Illuminance sensor (0x00D0)
obj = Object("Illuminance sensor", 0x00, 0xD0)
obj.add_property(Property(0xE0, "Measured illuminance value 1", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measured illuminance value 2", "number", 0, "required_c", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0xD0)] = obj

# Television (0x0602)
obj = Object("Television", 0x06, 0x02)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required_o", "required"))
obj.add_property(Property(0xB0, "Display control setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Character string setting acceptance status", "state", 1, "required_o", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Supported character codes", "bitmap", 2, "required_o", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Character string to present to the user", "object", 0, "optional", "required", "optional"))
obj.add_property(Property(0xB4, "Length of character string accepted", "object", 0, "required_o", "notApplicable", "optional"))
__std_mra_objects[(0x06, 0x02)] = obj

# EV charger and discharger (0x027E)
obj = Object("EV charger and discharger", 0x02, 0x7E)
obj.add_property(Property(0xC0, "Dischargeable capacity of vehicle mounted battery 1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Dischargeable capacity of vehicle mounted battery 2", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Dischargeable capacity of vehicle mounted battery 2", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Remaining dischargeable capacity of vehicle mounted battery 1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Remaining dischargeable capacity of vehicle mounted battery 2", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Remaining dischargeable capacity of vehicle mounted battery 2", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Remaining dischargeable capacity of vehicle mounted battery 3", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Rated charge capacity", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Rated discharge capacity", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable/dischargeable status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric energy", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric energy", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging current", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Minimum/maximum discharging current", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Charger/Discharger type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Vehicle connection confirmation", "state", 1, "notApplicable", "required", "notApplicable"))
obj.add_property(Property(0xCE, "Chargeable capacity of vehicle mounted battery", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Remaining chargeable capacity of vehicle mounted battery", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Used capacity of vehicle mounted battery 1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Used capacity of vehicle mounted battery 2", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Used capacity of vehicle mounted battery 2", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging/discharging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured instantaneous charging/discharging current", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured instantaneous charging/discharging voltage", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measured cumulative amount of discharging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Cumulative amount of discharging electric energy reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD8, "Measured cumulative amount of charging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Cumulative amount of charging electric energy reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDB, "System interconnected type", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Charging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xDC, "Charging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xDD, "Discharging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xDD, "Discharging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xDE, "Purchasing electric power setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDF, "Re-interconnection permission setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Charging/Discharging electric power setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Remaining stored electricity of vehicle mounted battery1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity of vehicle mounted battery2", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity of vehicle mounted battery2", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity of vehicle mounted battery3", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Maintenance status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE6, "Vehicle ID", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Discharging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Discharging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Discharging current setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Rated voltage (Independent)", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7E)] = obj

# Package-type commercial air conditioner (outdoor unit) (0x0157)
obj = Object("Package-type commercial air conditioner (outdoor unit)", 0x01, 0x57)
obj.add_property(Property(0xAB, "Special state", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB8, "Rated power consumption of outdoor unit", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured outdoor unit temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Measured power consumption of outdoor unit", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Possible power savings for outdoor units", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Settings restricting power consumption of outdoor units", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xDF, "Minimum power consumption for restricted outdoor unit", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x57)] = obj

# Humidity sensor (0x0012)
obj = Object("Humidity sensor", 0x00, 0x12)
obj.add_property(Property(0xE0, "Measured value of relative humidity", "number", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x12)] = obj

# Mono functional lighting (0x0291)
obj = Object("Mono functional lighting", 0x02, 0x91)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB0, "Light level Setting", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x91)] = obj

# Power distribution board metering (0x0287)
obj = Object("Power distribution board metering", 0x02, 0x87)
obj.add_property(Property(0xB0, "Master rated capacity", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Number of measurement channels (simplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Channel range specification for cumulative amount of electric power consumption measurement (simplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Measured cumulative amount of electric power consumption list (simplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Channel range specification for instantaneous current measurement (simplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Measured instantaneous current list (simplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Channel range specification for instantaneous power consumption measurement (simplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Measured instantaneous power consumption list (simplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB8, "Number of measurement channels (duplex)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB9, "Channel range specification for cumulative amount of electric power consumption measurement (duplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Measured cumulative amount of electric power consumption list (duplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Channel range specification for instantaneous current measurement (duplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBC, "Measured instantaneous current list (duplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBD, "Channel range specification for instantaneous power consumption measurement (duplex)", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBE, "Measured instantaneous power consumption list (duplex)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "Measured cumulative amount of electric energy (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Unit for cumulative amounts of electric energy", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Historical data of measured cumulative amounts of electric energy (normal direction)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC6, "Measured instantaneous amount of electric energy", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Measured instantaneous currents", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Measured instantaneous voltages", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Measurement channel 1", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measurement channel 2", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measurement channel 3", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measurement channel 4", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measurement channel 5", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measurement channel 6", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measurement channel 7", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Measurement channel 8", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Measurement channel 9", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Measurement channel 10", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDA, "Measurement channel 11", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Measurement channel 12", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Measurement channel 13", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Measurement channel 14", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Measurement channel 15", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Measurement channel 16", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measurement channel 17", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measurement channel 18", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Measurement channel 19", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measurement channel 20", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measurement channel 21", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Measurement channel 22", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Measurement channel 23", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Measurement channel 24", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measurement channel 25", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE9, "Measurement channel 26", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Measurement channel 27", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Measurement channel 28", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Measurement channel 29", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Measurement channel 30", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEE, "Measurement channel 31", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEF, "Measurement channel 32", "object", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x87)] = obj

# Electric water heater (0x026B)
obj = Object("Electric water heater", 0x02, 0x6B)
obj.add_property(Property(0x90, "ON timer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Automatic water heating setting", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xB0, "Automatic water heating setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB1, "Automatic water temperature control setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Water heater status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Water heater status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xB3, "Water heating temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Manual water heating stop days setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Relative time setting value for manual water heating OFF", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Tank operation mode setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Daytime reheating permission setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Daytime reheating permission setting", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Alarm status", "bitmap", 4, "optional", "notApplicable", "required"))
obj.add_property(Property(0xC3, "Hot water supply status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC4, "Relative time setting for keeping bath temperature", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xC7, "Participation in energy shift", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xC8, "Standard time to start heating", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Number of energy shifts", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Daytime heating shift time 1", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xCB, "Expected electric energy at daytime heating shift time 1", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Consumption of electric energy per hour 1", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Daytime heating shift time 2", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xCE, "Expected electric energy at daytime heating shift time 2", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Consumption of electric energy per hour 2", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Temperature of supplied water setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Bath water temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD4, "Bath water volume setting4", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD5, "Bath water volume setting4 maximum settable level", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Volume setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Mute setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD8, "Remaining hot water volume", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Surplus electric energy power prediction value", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Rated power consumption of H/P unit in wintertime", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Rated power consumption of H/P unit in in-between seasons", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Rated power consumption of H/P unit in summertime", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Bath water volume setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Measured amount of water remaining in tank", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Automatic Bath Water Heating Mode Setting", "state", 1, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE4, "Manual bath reheating operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Addition of hot water function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Manual bath hot water addition function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Slight bath water temperature lowering function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Manual lukewarm water temperature lowering function setting.", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Bath water volume setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Bath water volume setting 2", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Bathroom priority setting", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Bath Operation Status Monitor", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xEE, "Bath water volume setting 3", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x6B)] = obj

# General lighting (0x0290)
obj = Object("General lighting", 0x02, 0x90)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Light level", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Light color setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Light level step setting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Light color step setting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Maximum specifiable values", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB5, "Maximum value of settable level for night lighting", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Lighting mode setting", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xB7, "Light level setting for main lighting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Light level step setting for main lighting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB9, "Light level setting for night lighting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Light level step setting for night lighting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBB, "Light color setting for main lighting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xBC, "Light color level step setting for main lighting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBD, "Light color setting for night lighting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xBE, "Light color level step setting for night lighting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBF, "Lighting mode status in auto mode", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "RGB setting for color lighting", "object", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x90)] = obj

# Storage battery (0x027D)
obj = Object("Storage battery", 0x02, 0x7D)
obj.add_property(Property(0x83, "Identification number", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0x97, "Current time setting", "time", 2, "required", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "date", 0, "required", "optional", "optional"))
obj.add_property(Property(0xA0, "AC effective capacity (charging)", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA1, "AC effective capacity (discharging)", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA2, "AC chargeable capacity", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA3, "AC dischargeable capacity", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA4, "AC chargeable electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA5, "AC dischargeable electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA6, "AC charge upper limit setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA7, "AC discharge lower limit setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA8, "AC measured cumulative charging electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xA9, "AC measured cumulative discharging electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xAA, "AC charge amount setting value", "", 0, "required", "required", "required"))
obj.add_property(Property(0xAB, "AC discharge amount setting value", "", 0, "required", "required", "required"))
obj.add_property(Property(0xC1, "Charging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xC2, "Discharging method", "state", 1, "required", "optional", "required"))
obj.add_property(Property(0xC7, "AC rated electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric power", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric power", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric power", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Minimum/maximum discharging electric power", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging current", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Minimum/maximum discharging current", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Re-interconnection permission setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCD, "Operation permission setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCE, "Independent operation permission setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Working operation status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xCF, "Working operation status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xD0, "Rated electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Rated capacity", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging/discharging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured instantaneous charging/discharging current", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured instantaneous charging/discharging voltage", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Measured cumulative discharging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Measured cumulative discharging electric energy reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD8, "Measured cumulative charging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Measured cumulative charging electric energy reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xDB, "System-interconnected type", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "System-interconnected type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Minimum/maximum charging power (Independent)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDD, "Minimum/maximum discharging power (Independent)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDE, "Minimum/maximum charging current (Independent)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Minimum/maximum discharging current (Independent)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Charging/discharging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Charging/discharging amount setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Charging/discharging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Charging/discharging amount setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Remaining stored electricity 1", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Remaining stored electricity 2", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity 3", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Battery state of health", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Battery type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Discharging amount setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Charging amount setting 2", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Discharging amount setting 2", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Discharging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "Discharging current setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Rated voltage (Independent)", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7D)] = obj

# Package-type commercial air conditioner (indoor unit) (except those for facilities) (0x0156)
obj = Object("Package-type commercial air conditioner (indoor unit) (except those for facilities)", 0x01, 0x56)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xAC, "Thermostat state", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xAE, "Current function (automatic operation mode)", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB3, "Temperature setting", "number", 0, "required", "required", "required"))
obj.add_property(Property(0xBB, "Measured indoor unit temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xDB, "Power consumption range for indoor units", "state", 1, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x56)] = obj

# Rice cooker (0x03BB)
obj = Object("Rice cooker", 0x03, 0xBB)
obj.add_property(Property(0x90, "Rice cooking reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "Rice cooking reservation time setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Rice cooking reservation relative time setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Cover closure status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Rice cooking status", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Rice cooking control setting", "state", 1, "required_o", "required_o", "optional"))
obj.add_property(Property(0xE1, "Warmer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Inner pot removal status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Cover removal status", "state", 1, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x03, 0xBB)] = obj

# High-voltage smart electric energy meter (0x028A)
obj = Object("High-voltage smart electric energy meter", 0x02, 0x8A)
obj.add_property(Property(0xC1, "Monthly maximum electric power demand", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Cumulative maximum electric power demand", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Electric power demand at fixed time (30-minute average electric power)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Number of effective digits of electric power demand", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Unit of electric power demand", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Historical data of measured electric power demand", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Unit of cumulative maximum electric power demand", "numericValue", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Measurement data of reactive electric power consumption (lag) for power factor measurement", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Measurement data of cumulative amount of reactive electric power consumption (lag) at fixed time for power factor measurement", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Number of effective digits for measurement data of cumulative amount of reactive electric power consumption (lag) for power factor measurement", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Unit of measurement data of cumulative amount of reactive electric power consumption (lag)", "numericValue", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Historical data of measurement data of cumulative amount of reactive electric power consumption (lag) for power factor measurement", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Coefficient", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Multiplying factor for coefficient", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Fixed date", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE2, "Measured cumulative amounts of active electric energy", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Cumulative amounts of active electric energy at fixed time", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measurement data of cumulative amounts of active electric energy for power factor measurement", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Number of effective digits for cumulative amount of active electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Unit of cumulative amounts of effective electric energy", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Historical data of measured cumulative amount of active electric energy", "object", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x8A)] = obj

# Cooking heater (0x03B9)
obj = Object("Cooking heater", 0x03, 0xB9)
obj.add_property(Property(0x96, "Relative time settings of off timers", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA1, "Child lock setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA2, "Radiant heater lock setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Heating status", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Heating setting", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "All stop setting", "state", 1, "notApplicable", "required_o", "optional"))
obj.add_property(Property(0xE0, "Heating modes of stoves", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Heating temperature setting", "object", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Heating power setting", "object", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xB9)] = obj

# VOC sensor (0x001D)
obj = Object("VOC sensor", 0x00, 0x1D)
obj.add_property(Property(0xB0, "Detection threshold level", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "VOC detection status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE0, "Measured value of VOC concentration", "number", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x1D)] = obj

# Bathroom heater dryer (0x0273)
obj = Object("Bathroom heater dryer", 0x02, 0x73)
obj.add_property(Property(0x90, "On timer reservation setting 1", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "On timer setting value", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "On relative timer setting value", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "Off timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "OFF timer setting value", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Off relative timer setting value", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Operation setting", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xB0, "Operation setting", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xB1, "Ventilation operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Bathroom prewarming operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB2, "Bathroom prewarming operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Bathroom heating operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Bathroom drying operation setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB5, "Cool air circulation operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Mist sauna operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Water mist operation setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBA, "Measured value of bathroom relative humidity", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of bathroom temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Filter cleaning reminder sign setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Human body detection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "On timer reservation setting 2", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "On timer reservation setting 2", "state", 1, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x73)] = obj

# Commercial show case outdoor unit (0x03D4)
obj = Object("Commercial show case outdoor unit", 0x03, 0xD4)
obj.add_property(Property(0xAA, "Indicates that the showcase freezer is in an exceptional status.", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB0, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xBE, "Used to acquire measurements of outdoor air temperature.", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Group information", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Group information", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xE2, "Indicates compressor ON/OFF status.", "state", 1, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xD4)] = obj

# Fuel cell (0x027C)
obj = Object("Fuel cell", 0x02, 0x7C)
obj.add_property(Property(0xC1, "Measured temperature of water in water heater", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Rated power generation output", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Rated power generation output", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Heating value of hot water storage tank", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Measured instantaneous power generation output", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Measured cumulative power generation output", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Cumulative power generation output reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xC6, "Cumulative energy generation output reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xC7, "Measured instantaneous gas consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Measured cumulative gas consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Cumulative gas consumption reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCA, "Power generation setting", "state", 1, "notApplicable", "optional", "optional"))
obj.add_property(Property(0xCA, "Power generation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCB, "Power generation status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Power generation status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xCC, "Measured in-house instantaneous power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Measured in-house cumulative power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Measured in-house cumulative energy consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "In-house cumulative power consumption reset", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCE, "In-house cumulative energy consumption reset", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xD0, "System interconnected type", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System interconnected type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Power generation request time setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xD2, "Designated power generation status", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xE1, "Measured remaining hot water amount", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Tank capacity", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7C)] = obj

# Water flowmeter (0x0281)
obj = Object("Water flowmeter", 0x02, 0x81)
obj.add_property(Property(0xD0, "Water flowmeter classification", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Owner classification", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Measured cumulative amount of flowing water", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Unit for measured Cumulative amounts of flowing water", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amount of flowing water", "array", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Detection of abnormal value in metering data", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE4, "Security data information", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "ID number setting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Verification expiration information", "raw", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x81)] = obj

# Home air conditioner (0x0130)
obj = Object("Home air conditioner", 0x01, 0x30)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0x8F, "Power-saving operation setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer-based reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting (time)", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "ON timer setting (relative time)", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer-based reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "OFF timer setting (time)", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "OFF timer setting (relative time)", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "required", "required", "required"))
obj.add_property(Property(0xA1, "Automatic control of air flow direction setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA3, "Automatic swing of air flow setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA4, "Air flow direction (vertical) setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA5, "Air flow direction (horizontal) setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xAA, "Special state", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xAB, "Non-priority state", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB0, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xB1, "Automatic temperature control setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Normal/highspeed/silent operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB3, "Set temperature value", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xB4, "Set value of relative humidity in dehumidifying mode", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB5, "Set temperature value in cooling mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB6, "Set temperature value in heating mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB7, "Set temperature value in dehumidifying mode", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB8, "Rated power consumption", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB9, "Measured value of current consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of room temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBB, "Measured value of room temperature", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xBC, "Set temperature value of user remote control", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBD, "Measured cooled air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured outdoor air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Relative temperature setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Ventilation function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC1, "Humidifier function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC2, "Ventilation air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC4, "Degree of humidification setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC6, "Mounted air cleaning method", "bitmap", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Air purifier function setting", "bitmap", 8, "optional", "optional", "optional"))
obj.add_property(Property(0xC8, "Mounted air refresh method", "bitmap", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Air refresher function setting", "bitmap", 8, "optional", "optional", "optional"))
obj.add_property(Property(0xCA, "Mounted self-cleaning method", "bitmap", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Self-cleaning function setting", "bitmap", 8, "optional", "optional", "optional"))
obj.add_property(Property(0xCC, "Special function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCD, "Operation status of components", "bitmap", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xCE, "Thermostat setting override function", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xCF, "Air purification mode setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Buzzer", "state", 1, "notApplicable", "optional", "notApplicable"))
__std_mra_objects[(0x01, 0x30)] = obj

# Electric energy sensor (0x0022)
obj = Object("Electric energy sensor", 0x00, 0x22)
obj.add_property(Property(0xE0, "Cumulative amounts of electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Medium-capacity sensor instantaneous electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Small-capacity sensor instantaneous electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Large-capacity sensor instantaneous electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Cumulative amounts of electric energy measurement log", "array", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Cumulative amounts of electric energy measurement log", "array", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Effective voltage value", "number", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x22)] = obj

# Washer and dryer (0x03D3)
obj = Object("Washer and dryer", 0x03, 0xD3)
obj.add_property(Property(0x90, "On timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "On timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative time-based on timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Door/cover open/close status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB2, "Washer and dryer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD0, "Washer and dryer cycle setting 1", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Washer and dryer cycle setting 2", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Drying cycle setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD3, "Washer and dryer cycle option list 1", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Washer and dryer cycle option list 2", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Washer and dryer cycle option list 3", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD6, "Water flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD7, "Rotation speed for spin drying setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xD8, "Degree of drying setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xDB, "Remaining washing time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Remaining drying time", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDF, "Elapsed time on the ON timer", "time", 2, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Presoaking time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Current stage of washer and dryer cycle", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Water volume setting 1", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE4, "Water volume setting 2", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Washing time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Number of times of rinsing setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Rinsing process setting", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Spin drying time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Drying time setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Warm water setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Bathtub water recycle setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Wrinkling minimization setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Time remaining to complete washer and dryer cycle", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEE, "Door/cover lock setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "Washer and dryer cycle", "raw", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x03, 0xD3)] = obj

# Electrically operated rain sliding door/shutter (0x0263)
obj = Object("Electrically operated rain sliding door/shutter", 0x02, 0x63)
obj.add_property(Property(0x89, "Fault description (Recoverable faults)", "state", 2, "optional", "notApplicable", "required"))
obj.add_property(Property(0x90, "Timer operation setting", "state", 1, "optional", "optional", "required"))
obj.add_property(Property(0xD0, "Opening speed setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Closing speed setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xD2, "Operation time", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE0, "Open/close operation setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xE1, "Degree-of-opening setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Blind angle setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Opening/closing speed setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Electric lock setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Remote operation setting status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE9, "Selective degree-of-opening setting", "state", 1, "optional", "optional", "required"))
obj.add_property(Property(0xEA, "Open/closed status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xED, "Slit degree-of-opening", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEE, "One-time opening speed setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xEF, "One-time closing speed setting", "state", 1, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x63)] = obj

# CO2 sensor (0x001B)
obj = Object("CO2 sensor", 0x00, 0x1B)
obj.add_property(Property(0xE0, "Measured value of CO2 concentration", "number", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x1B)] = obj

# Current sensor (0x0023)
obj = Object("Current sensor", 0x00, 0x23)
obj.add_property(Property(0xE0, "Measured current value 1", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Rated voltage to be measured", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Measured current value 2", "number", 0, "required_c", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x23)] = obj

# EV Charger (0x02A1)
obj = Object("EV Charger", 0x02, 0xA1)
obj.add_property(Property(0xC5, "Rated charge capacity", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC7, "Vehicle connection and chargeable status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xC8, "Minimum/maximum charging electric energy", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Minimum/maximum charging electric current", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Charger type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Vehicle connection confirmation", "state", 1, "notApplicable", "required", "optional"))
obj.add_property(Property(0xCE, "Chargeable capacity of vehicle mounted battery", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Remaining chargeable capacity of vehicle mounted battery", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Used capacity of vehicle mounted battery 1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Rated voltage", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured instantaneous charging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Measured cumulative amount of charging electric energy", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Cumulative amount of charging electric energy reset setting", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xDA, "Operation mode setting", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xE2, "Remaining stored electricity of vehicle mounted battery1", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Remaining stored electricity of vehicle mounted battery3", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE6, "Vehicle ID", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Charging amount setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Charging electric energy setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Charging current setting", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0xA1)] = obj

# Watt-hour meter (0x0280)
obj = Object("Watt-hour meter", 0x02, 0x80)
obj.add_property(Property(0xE0, "Cumulative amounts of electric energy measurement value", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Cumulative amounts of electric energy unit", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Cumulative amounts of electric energy measurement log 1", "array", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x80)] = obj

# Emergency button (0x0003)
obj = Object("Emergency button", 0x00, 0x03)
obj.add_property(Property(0xB1, "Emergency occurrence status", "state", 1, "required", "notApplicable", "required"))
obj.add_property(Property(0xBF, "Emergency occurrence status resetting", "state", 1, "notApplicable", "optional", "notApplicable"))
__std_mra_objects[(0x00, 0x03)] = obj

# Household solar power generation (0x0279)
obj = Object("Household solar power generation", 0x02, 0x79)
obj.add_property(Property(0x83, "Identification number", "raw", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0x97, "Current time setting", "time", 2, "required_c", "optional", "optional"))
obj.add_property(Property(0x98, "Current date setting", "date", 0, "required_c", "optional", "optional"))
obj.add_property(Property(0xA0, "Output power control setting 1", "number", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xA1, "Output power control setting 2", "number", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xA2, "Function to control purchase surplus electricity setting", "state", 1, "required_c", "optional", "optional"))
obj.add_property(Property(0xB0, "Output power controlling schedule", "object", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Next access date and time", "", 0, "required_c", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Function to control the type of surplus electricity purchase", "state", 1, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Output power change time setting value", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Upper limit clip setting value", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC0, "Operation power factor setting value", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "FIT contract type", "state", 1, "required", "required", "optional"))
obj.add_property(Property(0xC2, "Self-consumption type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Capacity approved by equipment", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Conversion coefficient", "number", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System-interconnected type", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "System-interconnected type", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Output power restraint status", "state", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measured instantaneous amount of electricity generated", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Measured cumulative amount of electric energy generated", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Resetting cumulative amount of electric energy generated", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy sold", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Resetting cumulative amount of electric energy sold", "state", 1, "notApplicable", "optional", "notApplicable"))
obj.add_property(Property(0xE5, "Power generation output limit setting 1", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Power generation output limit setting 2", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Limit setting for the amount of electricity sold", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Rated power generation output (System-interconnected)", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Rated power generation output (System-interconnected)", "", 0, "required", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power generation output (Independent)", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x79)] = obj

# Floor heater (0x027B)
obj = Object("Floor heater", 0x02, 0x7B)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0x90, "ON timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "Time set by ON timer", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Maximum temperature level", "number", 0, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE0, "Set temperature value", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE1, "Set temperature level by 15 steps", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE2, "Measured room temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured floor temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured floor temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Zone change setting", "bitmap", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Special operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Daily timer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "bitmap", 6, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "bitmap", 6, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Power consumption measurement method", "state", 1, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7B)] = obj

# Air pressure sensor (0x002D)
obj = Object("Air pressure sensor", 0x00, 0x2D)
obj.add_property(Property(0xE0, "Air pressure measurement", "number", 2, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x2D)] = obj

# Bath heating status sensor (0x0016)
obj = Object("Bath heating status sensor", 0x00, 0x16)
obj.add_property(Property(0xB0, "Detection threshold level", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Bath heating detection status", "state", 1, "required", "notApplicable", "required"))
__std_mra_objects[(0x00, 0x16)] = obj

# Cold or hot water heat source equipment (0x027A)
obj = Object("Cold or hot water heat source equipment", 0x02, 0x7A)
obj.add_property(Property(0x90, "ON timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x91, "ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x92, "Relative ON timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x94, "OFF timer reservation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0x95, "Time set by OFF timer", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0x96, "Relative OFF timer setting", "time", 2, "optional", "optional", "optional"))
obj.add_property(Property(0xD1, "Cold water temperature setting 2 Maximum allowable setting level", "number", 0, "optional", "optional", "required"))
obj.add_property(Property(0xD2, "Warm water temperature setting 2 Maximum allowable setting level", "number", 0, "optional", "optional", "required"))
obj.add_property(Property(0xE0, "Operation mode setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Water temperature setting 1", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE2, "Water temperature setting 2", "", 0, "required_c", "required_c", "optional"))
obj.add_property(Property(0xE3, "Measured temperature of outward water (Exit water Temperature)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Measured temperature of inward water (Entrance water Temperature)", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Special operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Daily timer setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Daily timer setting 1", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE8, "Daily timer setting 2", "raw", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Rated power consumption", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Power consumption measurement method", "state", 1, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x7A)] = obj

# Smart electric energy meter for sub-metering (0x028D)
obj = Object("Smart electric energy meter for sub-metering", 0x02, 0x8D)
obj.add_property(Property(0xD3, "Electric energy coefficient", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Unit for cumulative amount of electric energy (normal and reverse directions)", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Number of effective digits for cumulative amounts of electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Electric current coefficient", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD9, "Voltage coefficient", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE1, "Measured cumulative amount of electric energy(normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of electric energy (normal direction)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative amounts of electric energy (reverse direction)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE7, "Measured instantaneous electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measured instantaneous currents", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE9, "Measured instantaneous voltages", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Cumulative amounts of electric energy measured at fixed time(normal direction)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Cumulative amounts of electric energy measured at fixed time(reverse direction)", "object", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x8D)] = obj

# Lighting system (0x02A3)
obj = Object("Lighting system", 0x02, 0xA3)
obj.add_property(Property(0xB0, "Light level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Scene control setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Number that can assign scene control setting", "number", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0xA3)] = obj

# Ventilation fan (0x0133)
obj = Object("Ventilation fan", 0x01, 0x33)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xBF, "Ventilation Auto setting", "state", 1, "optional", "optional", "optional"))
__std_mra_objects[(0x01, 0x33)] = obj

# Electric lock (0x026F)
obj = Object("Electric lock", 0x02, 0x6F)
obj.add_property(Property(0xE0, "Lock setting1", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xE1, "Lock setting 2", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE2, "Lock status of door guard", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Door open/close status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Occupant/ non-occupant status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Alarm status", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xE6, "Auto lock mode setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE7, "Battery level", "state", 1, "optional", "optional", "required"))
__std_mra_objects[(0x02, 0x6F)] = obj

# Gas meter (0x0282)
obj = Object("Gas meter", 0x02, 0x82)
obj.add_property(Property(0xE0, "Cumulative amount of gas consumption measurement value", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Cumulative amounts of gas consumption measurement log", "array", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x02, 0x82)] = obj

# Air conditioner ventilation fan (0x0134)
obj = Object("Air conditioner ventilation fan", 0x01, 0x34)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xA0, "Set value of ventilation air flow rate", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Ventilation mode automatic setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Ventilation method setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB2, "Ventilation mode setting", "state", 1, "optional", "optional", "required"))
obj.add_property(Property(0xB3, "Cooling / heating high-low setting", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB4, "Set value of room relative humidity", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB9, "Measured value of electric current consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBA, "Measured value of room relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBE, "Measured value of outdoor air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xBF, "Ventilation auto setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Measured value of CO2 concentration", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Pollution detection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Measured value of outdoor relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD0, "Measured value of return air temperature", "array", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measured value of return relative humidity", "array", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measured value of charging air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured value of charging relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured value of discharging air temperature", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured value of discharging air relative humidity", "", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Heat exchanger operation setting", "state", 1, "optional", "optional", "optional"))
__std_mra_objects[(0x01, 0x34)] = obj

# Controller (0x05FF)
obj = Object("Controller", 0x05, 0xFF)
obj.add_property(Property(0xC0, "Controller ID", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Number of devices controlled", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Index", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC3, "Device ID", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Device type", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Name", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC6, "Connection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Business code of the device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC7, "Business code of the device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Product code of the device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC8, "Product code of the device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Manufacture date of the device to be controlled", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC9, "Manufacture date of the device to be controlled", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Registerd information renewal date of the device to be controlled", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCA, "Registerd information renewal date of the device to be controlled", "date", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Registerd information renewal version information of the device to be controlled", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCB, "Registerd information renewal version information of the device to be controlled", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCC, "Place to install device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCD, "Fault status of device to be controlled", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCE, "Set property map for device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xCF, "Get property map for device to be controlled", "raw", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Address of installation location", "raw", 0, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x05, 0xFF)] = obj

# Extended lighting system (0x02A4)
obj = Object("Extended lighting system", 0x02, 0xA4)
obj.add_property(Property(0xB0, "Light level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Scene control setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC1, "Number that can assign scene control setting.", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Power consumption rate list", "array", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC3, "Power consumption when fully lighted", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC4, "Possible power savings", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xC5, "Power consumption limit setting", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xC6, "Automatic operation controlling setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xC7, "Fading control change time setting", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0xA4)] = obj

# Temperature sensor (0x0011)
obj = Object("Temperature sensor", 0x00, 0x11)
obj.add_property(Property(0xE0, "Measured temperature value", "number", 0, "required", "notApplicable", "optional"))
__std_mra_objects[(0x00, 0x11)] = obj

# Human detection sensor (0x0007)
obj = Object("Human detection sensor", 0x00, 0x07)
obj.add_property(Property(0xB0, "Detection threshold level", "level", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xB1, "Human detection status", "state", 1, "required", "notApplicable", "required"))
__std_mra_objects[(0x00, 0x07)] = obj

# Refrigerator (0x03B7)
obj = Object("Refrigerator", 0x03, 0xB7)
obj.add_property(Property(0xA0, "Quick freeze function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA1, "Quick refrigeration function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA4, "Icemaker setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA5, "Icemaker operation status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xA6, "Icemaker tank status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xA8, "Refrigerator compartment humidification function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xA9, "Vegetable compartment humidification function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xAD, "Deodorization function setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xB0, "Door open/close status", "state", 1, "required_o", "notApplicable", "optional"))
obj.add_property(Property(0xB1, "Door open warning", "state", 1, "optional", "notApplicable", "required"))
obj.add_property(Property(0xB2, "Refrigerator compartment door status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB3, "Freezer compartment door status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB4, "Ice compartment door status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB5, "Vegetable compartment door status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xB6, "Multi-refrigerating mode compartment door status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD1, "Measured refrigerator compartment temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD2, "Measured freezer compartment temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD3, "Measured subzero-fresh compartment temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD4, "Measured vegetable compartment temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD5, "Measured multi-refrigerating mode compartment temperature", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD8, "Compressor rotation speed", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDA, "Measured electric current consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xDC, "Rated power consumption", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Maximum allowable temperature setting level", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Refrigerator compartment temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE3, "Freezer compartment temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE4, "Ice compartment temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE5, "Vegetable compartment temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE6, "Multi-refrigerating mode compartment temperature setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xE9, "Refrigerator compartment temperature level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEA, "Freezer compartment temperature level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEB, "Ice compartment temperature level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xEC, "Vegetable compartment temperature level setting", "number", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xED, "Multi-refrigerating mode compartment temperature level setting", "number", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x03, 0xB7)] = obj

# Air cleaner (0x0135)
obj = Object("Air cleaner", 0x01, 0x35)
obj.add_property(Property(0x80, "Operation status", "state", 1, "required", "required", "required"))
obj.add_property(Property(0xA0, "Air flow rate setting", "", 0, "optional", "optional", "optional"))
obj.add_property(Property(0xC0, "Air pollution detection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC1, "Smoke (cigarette) detection status", "state", 1, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xC2, "Optical catalyst operation setting", "state", 1, "optional", "optional", "optional"))
obj.add_property(Property(0xE1, "Filter change notice", "state", 1, "optional", "notApplicable", "optional"))
__std_mra_objects[(0x01, 0x35)] = obj

# Low-voltage smart electric energy meter (0x0288)
obj = Object("Low-voltage smart electric energy meter", 0x02, 0x88)
obj.add_property(Property(0xD3, "Coefficient", "number", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xD7, "Number of effective digits for cumulative amounts of electric energy", "number", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE0, "Measured cumulative amount of electric energy (normal direction)", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE1, "Unit for cumulative amounts of electric energy (normal and reverse directions)", "numericValue", 1, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE2, "Historical data of measured cumulative amounts of electric energy 1 (normal direction)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE3, "Measured cumulative amount of electric energy (reverse direction)", "", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE4, "Historical data of measured cumulative amounts of electric energy 1 (reverse direction)", "object", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xE5, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 1", "", 0, "required", "required", "optional"))
obj.add_property(Property(0xE7, "Measured instantaneous electric power", "", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xE8, "Measured instantaneous currents", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEA, "Cumulative amounts of electric energy measured at fixed time (normal direction)", "object", 0, "required", "notApplicable", "optional"))
obj.add_property(Property(0xEB, "Cumulative amounts of electric energy measured at fixed time (reverse direction)", "object", 0, "required_c", "notApplicable", "optional"))
obj.add_property(Property(0xEC, "Historical data of measured cumulative amounts of electric energy 2 (normal and reverse directions)", "object", 0, "optional", "notApplicable", "optional"))
obj.add_property(Property(0xED, "Day for which the historical data of measured cumulative amounts of electric energy is to be retrieved 2", "object", 0, "optional", "optional", "optional"))
__std_mra_objects[(0x02, 0x88)] = obj

