# Generated by Django 4.1.3 on 2022-11-13 02:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ExtensionSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("singleton", models.CharField(max_length=1)),
                ("index", models.PositiveSmallIntegerField(default=0)),
            ],
            options={
                "ordering": ["tag", "index"],
            },
        ),
        migrations.CreateModel(
            name="ExtlangSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=3, unique=True)),
                ("macrolanguage", models.CharField(max_length=3, null=True)),
                (
                    "scope",
                    models.CharField(
                        choices=[
                            ("I", "individual"),
                            ("C", "collection"),
                            ("M", "macrolanguage"),
                            ("S", "special"),
                        ],
                        default="I",
                        max_length=1,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="IANASubtagRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("deprecated", models.DateField(null=True)),
                ("added", models.DateField()),
                ("comments", models.TextField(null=True)),
                (
                    "pref_value",
                    models.CharField(
                        max_length=42,
                        null=True,
                        verbose_name="preferred value",
                    ),
                ),
            ],
            options={
                "verbose_name": "IANA (sub)tag",
            },
        ),
        migrations.CreateModel(
            name="IANASubtagRegistry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("file_date", models.DateField(unique=True)),
                ("saved", models.DateTimeField()),
            ],
            options={
                "verbose_name": "IANA Language Subtag Registry",
            },
        ),
        migrations.CreateModel(
            name="ISOLanguage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "ref_name",
                    models.CharField(
                        max_length=150,
                        unique=True,
                        verbose_name="reference name",
                    ),
                ),
                (
                    "part_3",
                    models.CharField(
                        max_length=3,
                        unique=True,
                        verbose_name="alpha-3 code (ISO 639-3)",
                    ),
                ),
                (
                    "lang_type",
                    models.CharField(
                        choices=[
                            ("A", "ancient"),
                            ("C", "constructed"),
                            ("E", "extinct"),
                            ("H", "historical"),
                            ("L", "living"),
                            ("S", "special"),
                        ],
                        max_length=1,
                        verbose_name="type",
                    ),
                ),
                (
                    "scope",
                    models.CharField(
                        choices=[
                            ("I", "individual"),
                            ("M", "macrolanguage"),
                            ("S", "special"),
                        ],
                        max_length=1,
                    ),
                ),
                ("comment", models.CharField(max_length=150, null=True)),
            ],
            options={
                "verbose_name": "ISO 639-3 language",
            },
        ),
        migrations.CreateModel(
            name="ISOLanguageCodes",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "part_2b",
                    models.CharField(
                        max_length=3,
                        unique=True,
                        verbose_name="bibliographic code (ISO 639-2/B)",
                    ),
                ),
                (
                    "part_2t",
                    models.CharField(
                        max_length=3,
                        unique=True,
                        verbose_name="terminological code (ISO 639-2/T)",
                    ),
                ),
                (
                    "part_1",
                    models.CharField(
                        max_length=2,
                        null=True,
                        verbose_name="alpha-2 code (ISO 639-1)",
                    ),
                ),
                (
                    "names_en",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="noms français",
                    ),
                ),
                (
                    "names_fr",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="English names",
                    ),
                ),
            ],
            options={
                "verbose_name": "ISO 639-2 and 639-1 language codeset",
            },
        ),
        migrations.CreateModel(
            name="LanguageSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=3, unique=True)),
                ("macrolanguage", models.CharField(max_length=3, null=True)),
                (
                    "scope",
                    models.CharField(
                        choices=[
                            ("I", "individual"),
                            ("C", "collection"),
                            ("M", "macrolanguage"),
                            ("S", "special"),
                        ],
                        default="I",
                        max_length=1,
                    ),
                ),
                (
                    "iana",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="jangle.ianasubtagrecord",
                    ),
                ),
                (
                    "iso_lang",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subtag",
                        to="jangle.isolanguage",
                    ),
                ),
                (
                    "iso_lang_codes",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subtag",
                        to="jangle.isolanguagecodes",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="LanguageTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "grandfathered_tag",
                    models.CharField(max_length=42, null=True),
                ),
                ("private", models.CharField(max_length=42, null=True)),
                (
                    "extlang",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="jangle.extlangsubtag",
                    ),
                ),
                (
                    "iana",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="jangle.ianasubtagrecord",
                    ),
                ),
                (
                    "lang",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="jangle.languagesubtag",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Region",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tier",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "global"),
                            (1, "regional"),
                            (2, "continental"),
                            (3, "sub-regional"),
                            (4, "intermediary"),
                            (5, "country or area"),
                        ]
                    ),
                ),
                (
                    "no",
                    models.PositiveSmallIntegerField(
                        unique=True,
                        verbose_name="ISO 3166-1 numeric / UN M.49 code",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="jangle.region",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Script",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        max_length=4,
                        unique=True,
                        verbose_name="ISO 15924 code",
                    ),
                ),
                (
                    "no",
                    models.PositiveSmallIntegerField(
                        unique=True, verbose_name="ISO 15924 number"
                    ),
                ),
                (
                    "names_en",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="English names",
                    ),
                ),
                (
                    "names_fr",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="noms français",
                    ),
                ),
                (
                    "pva",
                    models.CharField(
                        max_length=150,
                        null=True,
                        verbose_name="property value alias",
                    ),
                ),
                (
                    "unicode_version",
                    models.CharField(max_length=12, null=True),
                ),
                ("script_date", models.DateField(verbose_name="date")),
            ],
            options={
                "verbose_name": "ISO 15924 script",
            },
        ),
        migrations.CreateModel(
            name="SimpleISOLanguageCollection",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "part_5",
                    models.CharField(
                        max_length=3,
                        unique=True,
                        verbose_name="ISO 639-5 alpha-3 code",
                    ),
                ),
                (
                    "names_en",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="English names",
                    ),
                ),
                (
                    "names_fr",
                    models.CharField(
                        max_length=75,
                        unique=True,
                        verbose_name="noms français",
                    ),
                ),
            ],
            options={
                "verbose_name": "simple ISO 639-5 language collection",
            },
        ),
        migrations.CreateModel(
            name="VariantSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.CharField(max_length=8, unique=True)),
                (
                    "iana",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="jangle.ianasubtagrecord",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ScriptSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "iana",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="jangle.ianasubtagrecord",
                    ),
                ),
                (
                    "script",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subtag",
                        to="jangle.script",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="RegionSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=3, unique=True)),
                (
                    "ext_data",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="subtag",
                        to="jangle.region",
                    ),
                ),
                (
                    "iana",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="jangle.ianasubtagrecord",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="LanguageTagVariantSubtag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("index", models.PositiveSmallIntegerField(default=0)),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="variants_through",
                        to="jangle.languagetag",
                    ),
                ),
                (
                    "variant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tags_through",
                        to="jangle.variantsubtag",
                    ),
                ),
            ],
            options={
                "ordering": ["tag", "index"],
                "unique_together": {("tag", "variant"), ("tag", "index")},
            },
        ),
        migrations.AddField(
            model_name="languagetag",
            name="region",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="jangle.regionsubtag",
            ),
        ),
        migrations.AddField(
            model_name="languagetag",
            name="script",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="jangle.scriptsubtag",
            ),
        ),
        migrations.AddField(
            model_name="languagetag",
            name="variants",
            field=models.ManyToManyField(
                through="jangle.LanguageTagVariantSubtag",
                to="jangle.variantsubtag",
            ),
        ),
        migrations.AddField(
            model_name="languagesubtag",
            name="iso_lang_collection",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subtag",
                to="jangle.simpleisolanguagecollection",
            ),
        ),
        migrations.AddField(
            model_name="languagesubtag",
            name="suppress_script",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="jangle.script",
            ),
        ),
        migrations.CreateModel(
            name="ISORegion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "alpha_2",
                    models.CharField(
                        max_length=2,
                        unique=True,
                        verbose_name="ISO 3166-1 alpha-2 code",
                    ),
                ),
                (
                    "alpha_3",
                    models.CharField(
                        max_length=3,
                        unique=True,
                        verbose_name="ISO 3166-1 alpha-3 code",
                    ),
                ),
                (
                    "in_ldc",
                    models.BooleanField(
                        default=False, verbose_name="Least Developed Countries"
                    ),
                ),
                (
                    "in_lldc",
                    models.BooleanField(
                        default=False,
                        verbose_name="Land Locked Developing Countries",
                    ),
                ),
                (
                    "in_sids",
                    models.BooleanField(
                        default=False,
                        verbose_name="Small Island Developing States",
                    ),
                ),
                (
                    "region",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="iso",
                        to="jangle.region",
                    ),
                ),
            ],
            options={
                "verbose_name": "ISO 3166 Region",
            },
        ),
        migrations.CreateModel(
            name="ISOLanguageName",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "printable",
                    models.CharField(
                        max_length=75, verbose_name="printable translated name"
                    ),
                ),
                (
                    "inverted",
                    models.CharField(
                        max_length=75, verbose_name="inverted translated name"
                    ),
                ),
                (
                    "iso_lang",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="names",
                        to="jangle.isolanguage",
                    ),
                ),
            ],
            options={
                "verbose_name": "ISO 639-3 language name",
            },
        ),
        migrations.AddField(
            model_name="isolanguage",
            name="codes",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="language",
                to="jangle.isolanguagecodes",
            ),
        ),
        migrations.AddField(
            model_name="isolanguage",
            name="macrolanguage",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="individuals",
                to="jangle.isolanguage",
            ),
        ),
        migrations.AddField(
            model_name="ianasubtagrecord",
            name="registry",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="records",
                to="jangle.ianasubtagregistry",
            ),
        ),
        migrations.CreateModel(
            name="IANASubtagDescription",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.CharField(max_length=75)),
                ("index", models.PositiveSmallIntegerField(default=0)),
                (
                    "subtag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="descriptions",
                        to="jangle.ianasubtagrecord",
                    ),
                ),
            ],
            options={
                "ordering": ["subtag", "index"],
            },
        ),
        migrations.AddField(
            model_name="extlangsubtag",
            name="iana",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="jangle.ianasubtagrecord",
            ),
        ),
        migrations.AddField(
            model_name="extlangsubtag",
            name="iso_lang",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="ext_subtag",
                to="jangle.isolanguage",
            ),
        ),
        migrations.AddField(
            model_name="extlangsubtag",
            name="suppress_script",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="jangle.script",
            ),
        ),
        migrations.CreateModel(
            name="ExtensionSubtagText",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.CharField(max_length=8)),
                ("index", models.PositiveSmallIntegerField(default=0)),
                (
                    "extension",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="texts",
                        to="jangle.extensionsubtag",
                    ),
                ),
            ],
            options={
                "ordering": ["extension", "index"],
            },
        ),
        migrations.AddField(
            model_name="extensionsubtag",
            name="tag",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="extensions",
                to="jangle.languagetag",
            ),
        ),
        migrations.CreateModel(
            name="RegionName",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.TextField(max_length=150)),
                (
                    "iso_lang",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="jangle.isolanguage",
                    ),
                ),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="names",
                        to="jangle.region",
                    ),
                ),
            ],
            options={
                "unique_together": {("region", "iso_lang")},
            },
        ),
        migrations.AddConstraint(
            model_name="languagetag",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("lang__isnull", False),
                    ("grandfathered_tag__isnull", False),
                    ("private__isnull", False),
                    _connector="OR",
                ),
                name="langtag_or_grandfathered_or_private",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="ianasubtagdescription",
            unique_together={("subtag", "text"), ("subtag", "index")},
        ),
        migrations.AlterUniqueTogether(
            name="extensionsubtagtext",
            unique_together={("extension", "index")},
        ),
        migrations.AlterUniqueTogether(
            name="extensionsubtag",
            unique_together={("tag", "singleton"), ("tag", "index")},
        ),
    ]
