/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting ordinal regression.")
@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u00015\u0011\u0011\u0003\u0013\u001aP\u001fJ$\u0017N\\1m\u001b\u0016$(/[2t\u0015\t\u0019A!A\u0004nKR\u0014\u0018nY:\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0005ta\u0006\u00148\u000e\\5oO*\u0011\u0011BC\u0001\u0004QJz'\"A\u0006\u0002\u0005\u0005L7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003!!\u0013tjQ8n[>tW*\u001a;sS\u000e\u001c\b\u0002C\n\u0001\u0005\u000b\u0007I\u0011\t\u000b\u0002\u0007ULG-F\u0001\u0016!\t1BD\u0004\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;y\u0011aa\u0015;sS:<'BA\u000e\u0019\u0011!\u0001\u0003A!A!\u0002\u0013)\u0012\u0001B;jI\u0002BQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013&!\ty\u0001\u0001C\u0003\u0014C\u0001\u0007Q\u0003C\u0003#\u0001\u0011\u0005q\u0005F\u0001%\u0011\u001dI\u0003A1A\u0005\u0012)\n!A\u001d\u001a\u0016\u0003-\u0002\"\u0001\f\u001c\u000e\u00035R!AL\u0018\u0002\u000bA\f'/Y7\u000b\u0005\u0015\u0001$BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]j#a\u0003#pk\ndW\rU1sC6Da!\u000f\u0001!\u0002\u0013Y\u0013a\u0001:3A!91\b\u0001b\u0001\n#a\u0014!\u00045jiJ\u000bG/[8UC\ndW-F\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001E!\u0001\u0004qCJ\fWn]\u0005\u0003\u0005~\u0012aCT;mY\u0006\u0014G.\u001a#bi\u00064%/Y7f!\u0006\u0014\u0018-\u001c\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001f\u0002\u001d!LGOU1uS>$\u0016M\u00197fA!9a\t\u0001b\u0001\n#a\u0014aD2p]\u001a,8/[8o\u001b\u0006$(/\u001b=\t\r!\u0003\u0001\u0015!\u0003>\u0003A\u0019wN\u001c4vg&|g.T1ue&D\b\u0005C\u0004K\u0001\t\u0007I\u0011\u0003\u0016\u0002\u000f1|w\r\\8tg\"1A\n\u0001Q\u0001\n-\n\u0001\u0002\\8hY>\u001c8\u000f\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0005+\u0003EiW-\u00198QKJ\u001cE.Y:t\u000bJ\u0014xN\u001d\u0005\u0007!\u0002\u0001\u000b\u0011B\u0016\u0002%5,\u0017M\u001c)fe\u000ec\u0017m]:FeJ|'\u000f\t\u0005\u0006%\u0002!\taU\u0001\u0006O\u0016$(K\r\u000b\u0002)B\u0011q#V\u0005\u0003-b\u0011a\u0001R8vE2,\u0007\"\u0002-\u0001\t\u0003I\u0016\u0001E4fi\"KGOU1uS>$\u0016M\u00197f)\u0005Q\u0006CA.l\u001d\ta\u0006N\u0004\u0002^M:\u0011a,\u001a\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!A\u0019\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'\u0003\u0002ha\u0005\u00191/\u001d7\n\u0005%T\u0017a\u00029bG.\fw-\u001a\u0006\u0003OBJ!\u0001\\7\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA5k\u0011\u0015y\u0007\u0001\"\u0001Z\u0003I9W\r^\"p]\u001a,8/[8o\u001b\u0006$(/\u001b=\t\u000bE\u0004A\u0011A*\u0002\u0015\u001d,G\u000fT8hY>\u001c8\u000fC\u0003t\u0001\u0011\u00051+\u0001\u000bhKRlU-\u00198QKJ\u001cE.Y:t\u000bJ\u0014xN\u001d\u0005\u0006k\u0002!\tE^\u0001\u000bg\u0016$X*\u001a;sS\u000e\u001cH\u0003B<{\u0003\u001b\u0001\"a\u0006=\n\u0005eD\"\u0001B+oSRDQa\u001f;A\u0002q\fAA[:p]B\u0019Q0!\u0003\u000e\u0003yT1a`A\u0001\u0003\u001197o\u001c8\u000b\t\u0005\r\u0011QA\u0001\u0007O>|w\r\\3\u000b\u0005\u0005\u001d\u0011aA2p[&\u0019\u00111\u0002@\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000f\u0003\u0004\u0002\u0010Q\u0004\r!F\u0001\bG>tG/\u001a=u\u0011\u001d\t\u0019\u0002\u0001C!\u0003+\tAaY8qsR!\u0011qCA\r\u001b\u0005\u0001\u0001\u0002CA\u000e\u0003#\u0001\r!!\b\u0002\u000b\u0015DHO]1\u0011\u00071\ny\"C\u0002\u0002\"5\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0015\b\u0001\u0005\u0015\u00121FA\u0017!\ry\u0011qE\u0005\u0004\u0003S\u0011!AE'fiJL7m\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u0011qF\u0001g)\",\u0007e\u00197bgN\u0004S.Y6fg\u0002\ng/Y5mC\ndW\rI1mY\u0002jW\r\u001e:jGN\u0004C\u000f[1uAMD\u0017M]3eA\u0005\u001c'o\\:tA\u0005dG\u000eI1mO>\u0014\u0018\u000e\u001e5ng\u0002\u001aX\u000f\u001d9peRLgn\u001a\u0011pe\u0012Lg.\u00197!e\u0016<'/Z:tS>tg\u0006")
public class H2OOrdinalMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final NullableDataFrameParam hitRatioTable;
    private final NullableDataFrameParam confusionMatrix;
    private final DoubleParam logloss;
    private final DoubleParam meanPerClassError;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public NullableDataFrameParam hitRatioTable() {
        return this.hitRatioTable;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public Dataset<Row> getHitRatioTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.hitRatioTable()));
    }

    public Dataset<Row> getConfusionMatrix() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.confusionMatrix()));
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        super.setMetrics(json, context);
        if (json.has("r2")) {
            try {
                params4 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'r2' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'r2' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("hit_ratio_table")) {
            try {
                params3 = this.set("hitRatioTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "hit_ratio_table")));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'hit_ratio_table' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'hit_ratio_table' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("cm")) {
            try {
                params2 = this.set("confusionMatrix", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json.getAsJsonObject("cm"), "table")));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'cm' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'cm' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("logloss")) {
            try {
                params = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'logloss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'logloss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("mean_per_class_error")) {
            try {
                this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'mean_per_class_error' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'mean_per_class_error' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            return;
        }
    }

    @Override
    public H2OOrdinalMetrics copy(ParamMap extra) {
        return (H2OOrdinalMetrics)this.defaultCopy(extra);
    }

    public H2OOrdinalMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.hitRatioTable = this.nullableDataFrameParam("hitRatioTable", "The hit ratio table for this scoring run.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix object for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.hitRatioTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OOrdinalMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OOrdinalMetrics"));
    }
}

