/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.H2OMultinomialMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all multinomial metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011\u0001\u0004\u0013\u001aP\u001bVdG/\u001b8p[&\fGn\u0012'N\u001b\u0016$(/[2t\u0015\t\u0019A!A\u0004nKR\u0014\u0018nY:\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0005ta\u0006\u00148\u000e\\5oO*\u0011\u0011BC\u0001\u0004QJz'\"A\u0006\u0002\u0005\u0005L7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005UA%gT'vYRLgn\\7jC2lU\r\u001e:jGN\u0004\"aD\n\n\u0005Q\u0011!!\u0004%3\u001f\u001ecU*T3ue&\u001c7\u000f\u0003\u0005\u0017\u0001\t\u0015\r\u0011\"\u0011\u0018\u0003\r)\u0018\u000eZ\u000b\u00021A\u0011\u0011d\b\b\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011adG\u0001\u0007!J,G-\u001a4\n\u0005\u0001\n#AB*ue&twM\u0003\u0002\u001f7!A1\u0005\u0001B\u0001B\u0003%\u0001$\u0001\u0003vS\u0012\u0004\u0003\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0002(QA\u0011q\u0002\u0001\u0005\u0006-\u0011\u0002\r\u0001\u0007\u0005\u0006K\u0001!\tA\u000b\u000b\u0002O!9A\u0006\u0001b\u0001\n#i\u0013\u0001\u0005:fg&$W/\u00197EKZL\u0017M\\2f+\u0005q\u0003CA\u0018:\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0001\u0018M]1n\u0015\t)1G\u0003\u00025k\u0005)1\u000f]1sW*\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0004GA\u0006E_V\u0014G.\u001a)be\u0006l\u0007B\u0002\u001f\u0001A\u0003%a&A\tsKNLG-^1m\t\u00164\u0018.\u00198dK\u0002BqA\u0010\u0001C\u0002\u0013EQ&\u0001\u0007ok2dG)\u001a<jC:\u001cW\r\u0003\u0004A\u0001\u0001\u0006IAL\u0001\u000e]VdG\u000eR3wS\u0006t7-\u001a\u0011\t\u000f\t\u0003!\u0019!C\t[\u0005\u0019\u0011-[2\t\r\u0011\u0003\u0001\u0015!\u0003/\u0003\u0011\t\u0017n\u0019\u0011\t\u000f\u0019\u0003!\u0019!C\t\u000f\u0006!b.\u001e7m\t\u0016<'/Z3t\u001f\u001a4%/Z3e_6,\u0012\u0001\u0013\t\u0003_%K!A\u0013\u0019\u0003\u00131{gn\u001a)be\u0006l\u0007B\u0002'\u0001A\u0003%\u0001*A\u000bok2dG)Z4sK\u0016\u001cxJ\u001a$sK\u0016$w.\u001c\u0011\t\u000f9\u0003!\u0019!C\t\u000f\u0006A\"/Z:jIV\fG\u000eR3he\u0016,7o\u00144Ge\u0016,Gm\\7\t\rA\u0003\u0001\u0015!\u0003I\u0003e\u0011Xm]5ek\u0006dG)Z4sK\u0016\u001cxJ\u001a$sK\u0016$w.\u001c\u0011\t\u000bI\u0003A\u0011A*\u0002'\u001d,GOU3tS\u0012,\u0018\r\u001c#fm&\fgnY3\u0015\u0003Q\u0003\"AG+\n\u0005Y[\"A\u0002#pk\ndW\rC\u0003Y\u0001\u0011\u00051+A\bhKRtU\u000f\u001c7EKZL\u0017M\\2f\u0011\u0015Q\u0006\u0001\"\u0001T\u0003\u00199W\r^!J\u0007\")A\f\u0001C\u0001;\u00069r-\u001a;Ok2dG)Z4sK\u0016\u001cxJ\u001a$sK\u0016$w.\u001c\u000b\u0002=B\u0011!dX\u0005\u0003An\u0011A\u0001T8oO\")!\r\u0001C\u0001;\u0006Yr-\u001a;SKNLG-^1m\t\u0016<'/Z3t\u001f\u001a4%/Z3e_6DQ\u0001\u001a\u0001\u0005B\u0015\f!b]3u\u001b\u0016$(/[2t)\r1\u0017.\u001e\t\u00035\u001dL!\u0001[\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u000e\u0004\ra[\u0001\u0005UN|g\u000e\u0005\u0002mg6\tQN\u0003\u0002o_\u0006!qm]8o\u0015\t\u0001\u0018/\u0001\u0004h_><G.\u001a\u0006\u0002e\u0006\u00191m\\7\n\u0005Ql'A\u0003&t_:|%M[3di\")ao\u0019a\u00011\u000591m\u001c8uKb$\b\"\u0002=\u0001\t\u0003J\u0018\u0001B2paf$\"A_>\u000e\u0003\u0001AQ\u0001`<A\u0002u\fQ!\u001a=ue\u0006\u0004\"a\f@\n\u0005}\u0004$\u0001\u0003)be\u0006lW*\u00199)\u000f\u0001\t\u0019!!\u0003\u0002\fA\u0019q\"!\u0002\n\u0007\u0005\u001d!A\u0001\nNKR\u0014\u0018nY:EKN\u001c'/\u001b9uS>t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!!\u0004\u0002\u001bRCW\rI2mCN\u001c\b%\\1lKN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011bY2\u0004S.\u001e7uS:|W.[1mA5,GO]5dg\u0002\u001aX\u000f\u001d9peR,G\r\t2zA\u001dcU\nI1mO>\u0014\u0018\u000e\u001e5n]\u0001")
public class H2OMultinomialGLMMetrics
extends H2OMultinomialMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        super.setMetrics(json, context);
        if (json.has("residual_deviance")) {
            try {
                params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("null_deviance")) {
            try {
                params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("AIC")) {
            try {
                params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AIC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AIC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("null_degrees_of_freedom")) {
            try {
                params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            return;
        }
    }

    @Override
    public H2OMultinomialGLMMetrics copy(ParamMap extra) {
        return (H2OMultinomialGLMMetrics)this.defaultCopy(extra);
    }

    public H2OMultinomialGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OMultinomialGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OMultinomialGLMMetrics"));
    }
}

