/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class Meridian2LetterParse
extends SubParser {
    private static final int TO_LOWER = 32;

    Meridian2LetterParse() {
    }

    @Override
    public int estimateParsedLength() {
        return 2;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        int n2;
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 2) {
            return ~position;
        }
        char[] cArray = new char[2];
        int n3 = position;
        text.getChars(n3, n3 + 2, cArray, 0);
        if (cArray[0] < 'a' || cArray[0] > 'z') {
            if (cArray[0] < 'A' || cArray[0] > 'Z') {
                return ~position;
            }
            cArray[0] = (char)(cArray[0] + 32);
        }
        if (cArray[1] < 'a' || cArray[1] > 'z') {
            if (cArray[1] < 'A' || cArray[1] > 'Z') {
                return ~(position + 1);
            }
            cArray[1] = (char)(cArray[1] + 32);
        }
        switch (cArray[0]) {
            case 'a': {
                if (cArray[1] != 'm') {
                    return ~(position + 1);
                }
                n2 = 0;
                break;
            }
            case 'p': {
                if (cArray[1] != 'm') {
                    return ~(position + 1);
                }
                n2 = 1;
                break;
            }
            default: {
                return ~position;
            }
        }
        int n4 = position + 2;
        if (this.child != null) {
            n4 = this.child.parseInto(bucket, text, n4);
        } else if (this.ignoreSuffix) {
            n4 = text.length();
        }
        if (n4 >= 0) {
            bucket.saveField(DateTimeFieldType.halfdayOfDay(), n2);
        }
        return n4;
    }
}

