/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.FieldSet;
import ai.h2o.com.google.protobuf.MapFieldLite;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    private MapEntryLite(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        this.metadata = new Metadata<K, V>(keyType, defaultKey, valueType, defaultValue);
        this.key = defaultKey;
        this.value = defaultValue;
    }

    private MapEntryLite(Metadata<K, V> metadata, K key, V value) {
        this.metadata = metadata;
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        return new MapEntryLite<K, V>(keyType, defaultKey, valueType, defaultValue);
    }

    static <K, V> void writeTo(CodedOutputStream output, Metadata<K, V> metadata, K key, V value) throws IOException {
        FieldSet.writeElement(output, metadata.keyType, 1, key);
        FieldSet.writeElement(output, metadata.valueType, 2, value);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K key, V value) {
        return FieldSet.computeElementSize(metadata.keyType, 1, key) + FieldSet.computeElementSize(metadata.valueType, 2, value);
    }

    static <T> T parseField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MessageLite.Builder builder = ((MessageLite)value).toBuilder();
                input.readMessage(builder, extensionRegistry);
                return (T)builder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(input, type, true);
    }

    public void serializeTo(CodedOutputStream output, int fieldNumber, K key, V value) throws IOException {
        output.writeTag(fieldNumber, 2);
        output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, key, value));
        MapEntryLite.writeTo(output, this.metadata, key, value);
    }

    public int computeMessageSize(int fieldNumber, K key, V value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, key, value));
    }

    public Map.Entry<K, V> parseEntry(ByteString bytes, ExtensionRegistryLite extensionRegistry) throws IOException {
        return MapEntryLite.parseEntry(bytes.newCodedInput(), this.metadata, extensionRegistry);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream input, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2;
        Object k2 = metadata.defaultKey;
        Object v2 = metadata.defaultValue;
        while ((n2 = input.readTag()) != 0) {
            if (n2 == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                k2 = MapEntryLite.parseField(input, extensionRegistry, metadata.keyType, k2);
                continue;
            }
            if (n2 == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                v2 = MapEntryLite.parseField(input, extensionRegistry, metadata.valueType, v2);
                continue;
            }
            if (input.skipField(n2)) continue;
        }
        return new AbstractMap.SimpleImmutableEntry(k2, v2);
    }

    public void parseInto(MapFieldLite<K, V> map, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2;
        int n3 = input.readRawVarint32();
        int n4 = input.pushLimit(n3);
        Object k2 = this.metadata.defaultKey;
        Object v2 = this.metadata.defaultValue;
        while ((n2 = input.readTag()) != 0) {
            if (n2 == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                k2 = MapEntryLite.parseField(input, extensionRegistry, this.metadata.keyType, k2);
                continue;
            }
            if (n2 == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                v2 = MapEntryLite.parseField(input, extensionRegistry, this.metadata.valueType, v2);
                continue;
            }
            if (input.skipField(n2)) continue;
        }
        input.checkLastTagWas(0);
        input.popLimit(n4);
        map.put(k2, v2);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
            this.keyType = keyType;
            this.defaultKey = defaultKey;
            this.valueType = valueType;
            this.defaultValue = defaultValue;
        }
    }
}

