# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['scidatalib', 'scidatalib.io']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.20.2,<2.0.0', 'pytest-cov>=2.11.1,<3.0.0']

entry_points = \
{'console_scripts': ['scidatalib = scidatalib.cli:cli']}

setup_kwargs = {
    'name': 'scidatalib',
    'version': '0.2.6a1',
    'description': 'Python library for development of SciData JSON-LD files',
    'long_description': '# SciDataLib\n\n| Health | Releases |\n|--------|----------|\n| [![GitHub Actions](https://github.com/ChalkLab/SciDataLib/actions/workflows/actions.yml/badge.svg?branch=master)](https://github.com/ChalkLab/SciDataLib/actions/workflows/actions.yml) | [![PyPI version](https://badge.fury.io/py/scidatalib.svg)](https://badge.fury.io/py/SciDataLib) |\n| [![codecov](https://codecov.io/gh/ChalkLab/SciDataLib/branch/master/graph/badge.svg)](https://codecov.io/gh/ChalkLab/SciDataLib) | [![DOI](https://zenodo.org/badge/219040010.svg)](https://zenodo.org/badge/latestdoi/219040010) |\n\nA Python library writing [SciData](http://stuchalk.github.io/scidata/) [JSON-LD](https://json-ld.org/) files.\n\n# SciData and JSON-LD\n\nJSON-LD is a convenient (human-readable) encoding of Resource\nDesctiption Framework (RDF) triples.  However, unlike traditional\nrelational databases (e.g., MySQL), the graph has no schema. This\nis problematic as including data from different sources results\nin a system with no common way to search across the data.  The\nSciData framework is a structure for users to add data and its metadata\nthat are organized in the graph through the associated SciData ontology.\n\nThere are three main sections of the SciData framework:\n- the methodology section (describing how the research was done)\n- the system section (describing what the research studied and the conditions)\n- the dataset section (the experimental data, plus any derived or supplemental data)\n\nThe methodology and system sections are generic and users can add any data\nthey need to contextualize the dataset.  However, in addition they must\nprovide a JSON-LD context file to semantically describe the data elements\nincluded.  The dataset section has predefined data structures (dataseries,\ndatagroup, and datapoint) although other strudtures can be included\nif needed.\n\nTranslating the content in JSON-LD.  Referencing the JSON-LD below:\n- \'@context\': provides resources that define the context (meaning) of \n  data elements in the document (as a JSON array). It consists of three sections:\n    - a list of one or more \'context\' files\n    - a JSON object containing one or more definitions of namespaces\n    used in the document\n    - a JSON object with one entry \'@base\' that defines the base URL\n    to be prepended to all internal references (i.e. \'@id\' entries)\n- root level \'@id\': the \'name\' of the file and where ingested into a\ngraph database, the graph name\n- \'@graph\': the definition of content that will be represented as triples\nand identified by the graph name (this is therfore a \'quad\')\n- \'@id\' under \'@graph\': the identifier for the graph.  The scidatalib\ncode uses the \'@base\' to populate this, so they are consistent. As a result,\n  all node identifiers \'@id\'s in the document are globally unique because the\n  \'@base\' is unique.\n\n```json\n{\n  "@context": [\n    "https://stuchalk.github.io/scidata/contexts/scidata.jsonld",\n    {\n      "sci": "https://stuchalk.github.io/scidata/ontology/scidata.owl#"\n    },\n    {\n      "@base": "https://my.research.edu/<uniqueid>/"\n    }\n  ],\n  "@id": "file_identifier",\n  "generatedAt": "<automatically added",\n  "version": "1",\n  "@graph": {\n    "@id": "https://my.research.edu/<uniqueid>/",\n    "@type": "sdo:scidataFramework",\n    "uid": "<uniqueid>",\n    "scidata": {\n      "@type": "sdo:scientificData",\n      "methodology": {\n        "@id": "methodology/",\n        "@type": "sdo:methodology",\n        "aspects": []\n      },\n      "system": {\n        "@id": "system/",\n        "@type": "sdo:system",\n        "facets": []\n      },\n      "dataset": {\n        "@id": "dataset/",\n        "@type": "sdo:dataset",\n        "dataseries": [],\n        "datagroup": [],\n        "datapoint": []\n      }\n    }\n  }\n}\n```\n\n\n# Installation\n\n### Using pip\n```\npip install scidatalib\n```\n\n### Manual (from source)\nClone the repository either via:\n - HTTP:\n```\ngit clone https://github.com/ChalkLab/SciDataLib.git\n```\n - SSH:\n```\ngit clone git@github.com:ChalkLab/SciDataLib.git\n```\n\nCreate a virtual environment and activate to install the package in the isolated environment:\n```\npython -m venv <name of env>\nsource <env>/bin/activate\n```\n\nTo [install the package from the local source tree into the environment](\nhttps://packaging.python.org/tutorials/installing-packages/#installing-from-a-local-src-tree), run:\n```\npython -m pip install .\n```\n\nOr to do so in ["Development Mode"](https://setuptools.readthedocs.io/en/latest/setuptools.html#development-mode), \nyou can run:\n```\npython -m pip install -e .\n```\n\nTo deactivate the virtual environment\n```\ndeactivate\n```\n\nWhen finished, remove the virtual environment by deleting the directory:\n```\nrm -rf <name of env>\n```\n\n# Usage\n\nSciDataLib consists of both a command line interface (CLI)\nand a library for constructing and modifying SciData JSON-LD files\n\n### Command Line Interface\n\nThe CLI tool is `scidatalib`.\nYou can use it to create SciData JSON-LD files\nvia specifying an output JSON-LD filename\nand additional options to create the content of the file.\n\nExample to create "bare" SciData JSON-LD file:\n```\nscidatalib output.jsonld\n```\n\nYou can access the additional functionality via the `--help` option:\n```\nscidatalib --help\n```\n\n### SciDataLib library\nAfter installation, import the `SciData` class to start creating SciData JSON-LD:\n```python\nfrom scidatalib.scidata import SciData\n```\n\nExample:\n```python\nfrom scidatalib.scidata import SciData\nimport json\n\nuid = \'chalk:example:jsonld\'\nexample = SciData(uid)\n\n# context parameters\nbase = \'https://scidata.unf.edu/\' + uid + \'/\'\nexample.base(base)\n\n# print out the SciData JSON-LD for example\nprint(json.dumps(example.output, indent=2))\n```\n\n**Output**:\n```json\n{\n  "@context": [\n    "https://stuchalk.github.io/scidata/contexts/scidata.jsonld",\n    {\n      "sci": "https://stuchalk.github.io/scidata/ontology/scidata.owl#",\n      "sub": "https://stuchalk.github.io/scidata/ontology/substance.owl#",\n      "chm": "https://stuchalk.github.io/scidata/ontology/chemical.owl#",\n      "w3i": "https://w3id.org/skgo/modsci#",\n      "qudt": "http://qudt.org/vocab/unit/",\n      "obo": "http://purl.obolibrary.org/obo/",\n      "dc": "http://purl.org/dc/terms/",\n      "xsd": "http://www.w3.org/2001/XMLSchema#"\n    },\n    {\n      "@base": "https://scidata.unf.edu/chalk:example:jsonld/"\n    }\n  ],\n  "@id": "",\n  "generatedAt": "",\n  "version": "",\n  "@graph": {\n    "@id": "",\n    "@type": "sdo:scidataFramework",\n    "uid": "chalk:example:jsonld",\n    "scidata": {\n      "@type": "sdo:scientificData",\n      "discipline": "",\n      "subdiscipline": "",\n      "dataset": {\n        "@id": "dataset/",\n        "@type": "sdo:dataset"\n      }\n    }\n  }\n}\n```\n\n# Development\n\n### Install using poetry\nInstall via [poetry](https://python-poetry.org/) with dev dependencies:\n```\npoetry install\n```\n\nThen, run commands via poetry:\n```\npoetry run python -c "import scidatalib"\n```\n\n### CLI\n\nRun the CLI in using poetry via:\n```\npoetry install\npoetry run scidatalib --help\n```\n\n### Tests / Linting\n\n#### Flake8 linting\nRun linting over the package with [flake8](https://flake8.pycqa.org/en/latest/) via:\n```\npoetry run flake8 --count\n```\n\n#### Pytest testing\nRun tests using [pytest](https://docs.pytest.org/en/stable/):\n```\npoetry run pytest tests/\n```\n\n#### Code coverage\n\nGet code coverage reporting using the [pytest-cov](https://pytest-cov.readthedocs.io/en/latest/) plugin:\n```\npoetry run pytest --cov=scidatalib --cov-report=term-missing tests/\n```\n\n# Release\n\nFor developers, please see [Release Workflow](https://github.com/ChalkLab/SciDataLib/wiki/Release-Workflow).\n\n# Contributing\nPull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.\n\nPlease make sure to update tests as appropriate.\n\n# Links\n* SciData Research Paper: [https://doi.org/10.1186/s13321-016-0168-9](https://doi.org/10.1186/s13321-016-0168-9)\n* SciData Project Website: [http://stuchalk.github.io/scidata/](http://stuchalk.github.io/scidata/) \n* SciData Project GitHub Repository: [https://github.com/stuchalk/scidata](https://github.com/stuchalk/scidata)\n\n# Licensing\n[MIT](https://choosealicense.com/licenses/mit/)\n',
    'author': 'Stuart Chalk',
    'author_email': 'schalk@unf.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ChalkLab/SciDataLib',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
