# ---------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# ---------------------------------------------------------

InvalidCustomInterval = "The 'customInterval' field must be an integer > 0."
InvalidJsonFormat = "Invalid Json Format, input data is Empty."
# add this line
InvalidInputFormat = "Invalid Input Format, input data is Empty."

RequiredSeries = "The 'series' field is required in request."
RequiredGranularity = "The 'granularity' field is required in request."
InvalidGranularity = "The 'granularity' field can only be one of the following: {0}."
InvalidPeriod = "The 'period' field must be an integer >= 0."
InvalidImputeMode = "The 'imputeMode' field is required and should be one of the following: {0}."
InvalidImputeValue = "The 'imputeFixedValue' field must be a number."
InsufficientPoints = "The 'series' field must have more than 2 periods points"
InvalidAlpha = "The 'alpha' field must > 0."
InvalidAnomalyRatio = "The 'maxAnomalyRatio' field must be less than 50% of the series points (0 < " \
                      "maxAnomalyRatio < 0.5)."
InvalidSensitivity = "The 'sensitivity' field must be an integer between 0 and 99."
InvalidThreshold = "The 'threshold' field must be a float."
InvalidSeries = "The 'series' field cannot be empty."
InvalidSeriesValue = "The 'series' field cannot have none values."
InvalidSeriesType = "The 'series' field must be array/list type."
NotEnoughPoints = "The 'series' field must have at least {0} points."
TooManyPoints = "The 'series' field cannot have more than 8640 points."
NotEnoughPointsForSeasonalData = "Ratio of missing points should be less than 50% for seasonal timeseries. "\
    "There should be at least {0} points, but got {1} points."
InvalidSeriesFormat = "'timestamp' or 'value' is malformed in 'series' Field."
InvalidSeriesOrder = "The 'series' field must be sorted by timestamp in ascending order."
DuplicateSeriesTimestamp = "The 'series' field cannot have duplicated timestamp."
InvalidSeriesTimestamp = "The 'timestamp' at index {0} is invalid in {1} granularity with {2} gran as interval."
InvalidChangePointThreshold = "The 'threshold' field must be an float between 0.01 and 0.99."
InvalidStableTrendWindow = "The 'stableTrendWindow' field must be an integer >= 3 and < half of series' length."
RequiredSeriesValues = "The 'seriesValues' field is required in request."
InvalidSeriesValues = "The 'seriesValues' field must have at least 12 values and at most 8640 values."
InvalidTrendType = "The 'TrendType' field can only be one of the following: {0}."
InvalidPeriodThresh = "The 'periodThresh' field must be an float between 0.01 and 0.99."
InvalidMinVariance = "The 'minVariance' field must be an float between 0.01 and 0.99."
CustomSupportRequired = "The series data can not be processed due to unexpected exception, " \
    "please contact Anomaly Detector Team <anomalydetector@microsoft.com> for further support."
ValueOverflow = "The magnitude of data in 'value' in 'series' filed is too large."
InvalidBoundaryVersion = "The 'boundaryVersion' field can only be one of the following: {0}."
InvalidDetectorName = "The 'name' field is malformed in 'detector' in request."
MissingDetectorName = "The 'name' field is missing in 'detector' in request."
InvalidDetectorParameters = "The 'parameters' field is malformed in request."
MissingDetectorParameters = "The 'parameters' field is missing in 'detector' in request."
InvalidDetectorNameWithParameters = "Illegal detector name '{0}' and parameter combination."

RequiredPatternDetectType = "The 'detectType' field is required in pattern detect request."
RequiredPatternSeries = "The 'series' field is required in pattern detect request."
RequiredPatternGranularity = "The 'granularity' field is required in pattern detect request"
RequiredPatternCustomInterval = "The 'customInterval' field is required in pattern detect request"
RequiredPatternSeriesId = "The 'seriesId' field is required in pattern detect request"
RequiredPatternTimestamp = "The 'timestamp' field is required in pattern detect request"
RequiredPatternAnomalyRatio = "The 'anomalyRatio' field is required in pattern detect request"
RequiredPatternDeltaRatio = "The 'deltaRatio' field is required in pattern detect request"
RequiredPatternValueRange = "The 'valueRange' field is required in pattern detect request"
RequiredPatternOutOfExpected = "The 'outOfExpected' field is required in pattern detect request"
InvalidPatternDetectType = "The 'detectType' field must be a string from {0}"
InvalidPatternSeriesId = "The 'seriesId' field must be a string"
InvalidPatternSeries = "The 'series' field should have at least 2 data points and at most 8640 data points."
InvalidPatternTimestamp = "The 'timestamp' field must be a list of timestamps, with 1 element in last mode and more than 1 in entire mode, timestamp length: {0}, series length: {1}, detectType: {2}"
InvalidPatternAnomalyRatio = "The 'anomalyRatio' field must be a float between 0 and 1"
InvalidPatternDeltaRatio = "The 'deltaRatio' field must be a float >= 0"
InvalidPatternValueRange = "The 'valueRange' field must be a float >= 0"
InvalidPatternOutOfExpected = "The 'outOfExpected' field must be a list of bool, with 1 element in last mode and more than 1 in entire mode, outOfExpected length: {0}, series length: {1}, detectType: {2}"
InvalidPatternSeriesFormat = "'timestamp', 'value', 'ExpectedValue', 'SpectrumPeriod' or 'IsAnomaly' is missing or malformed in 'series' Field."
InvalidPatternGranularity = "The 'granularity' field is {0}, expected: {1}."
InvalidPatternCustomInterval = "The 'customInterval' field must be None or an int > 0."
NotfoundPatternTimestamp = "The pattern timestamp is not found in series"
