# LTtx数据中心

# LTtx简介
一、LTtx是一个分布式数据中心，基于Python语言开发，为分布式服务架构提供基础的通信服务。本项目代码完全开源，由于处于开源初期，相应的代码未完全整理，作者主要是用在股票量化的开发，实际运用中对于中国股市全市场Tick行情推送可以胜任推送。基于LTtx数据中心，可以实现许多程序的拆分，各个模块间相互独立，相互配合，也可以做成常用的服务端————客户端模型。在新版本中，新增文件传输功能，为实际开发提供更加全面的功能支持，此外本项目会根据实际生产环境需要，开发新的功能。

二、同时还是一个开发综合函数库，方便使用的各种基础函数（持续更新中），提高代码的开发效率，对于没有安装的Python库再第一次使用时会报错，需要留意，为了代码的轻量化，需要自行安装，一般来说，大部分库Python都会自带，比如再使用特定函数时才会需要依赖库。

# 应用场景
1、分布式量化交易系统   
2、聊天系统     
3、网络认证     
4、中间件       
5、个人云盘     
6、其他网络应用     
7、爬虫IP代理


# 部署方式
· 有两种部署方式

### 一、采用python部署
·该方法和正常的运行python程序一样

1、本项目是基于服务端———客户端的架构方式，在使用时需要先运行服务端程序。启动方式也特别简单，git clone在对应的服务器（可以是Windows,Linux,只要能运行Python文件即可）后通过Python启动，如果是在Linux服务器中请留意放开对应的端口。
- 需要配置Config.txt，也可以只使用默认的模式运行(可选)


- 启动命令

```

python LTtx_server.py

```

2、由于Python的GIL属性，服务端采用了大量的子线程进行功能实现，为保证性能发挥，建议部署在Linux服务器上，并且通过绑定核心运行的方法使用服务端性能达到最优。绑定核心启动命令示例：
```
taskset -c 2 python LTtx_server.py
```
- 本命令可将程序绑定在CPU2上。绑定核心后经本人测试发现在高并发时可以提高大约80%以上的性能。如果您的CPU是12代英特尔，请务必让他运行在性能（大核）核心上。

3、采用守护进程功能，通过使用如下命令启动服务端，这会在LTtx_server意外退出时能第一时间自动重启，如果要人工停止，可以通过连续的Ctrl+c停止。此种方法部署方式为：
```
./check
```
- 如果无法启动，请注意环境中python3的变量名为python，可以通过修改check.sh里的命令启动。

### 二、直接使用命令行部署
1、先通过pip安装LTtx库
```
pip install LTtx
```
·如果发现安装比较慢可以设置清华源进行安装，执行下方命令后重试即可。该命令会把pip源换为清华源，安装其他库也会非常快速。
```
pip config set global.index-url https://mirrors.tuna.tsinghua.edu.cn/pypi/web/simple
```

2、配置好config.txt，如果使用默认则跳过。

3、直接在cmd中运行（建议是在conda中运行）：
```
LTtx_server
```



# 函数说明
````
#需要提前执行start_tx()函数,此处的tx1为txl实例化以后的对象
tx1.put("a","b")                   #把云变量“a"赋值为“b",二者均为字符串，新版本中V3中将不再对b进行字符串数据类型进行限制。  

tx1.get("a")                       #获取云变量“a"的值。当put时传入的是一个Python对象，那么获得的值也是一个Python对象。  

tx1.put_df('a',dataframe)          #把云变量“a"赋值为传入的dataframe，此处的变量类型为dataframe，此处的云变量与上方的云变量独立存在

tx1.get_df('a')                    #获取云变量"a"对应的dataframe。

tx1.get_dict_value('a','b')        #获取云变量字典"a"中对应的"b"这个key的值，方便从一个大字典中只取需要的那部分数据，不用把整个字典都取出来，从而提升效率。

tx1.get_list_value('a',-1)         #获取云变量列表"a"对应下标为-1的值。方便从一个大列表中只取需要的那部分数据，提升效率。

tx1.dict_change(var,key,value)     #把云对象var字典对象进行key和value的更新，同本地字典操作方法一致。   

tx1.list_pop(var,data)             #把云对象var列表对象进行列表的pop操作，同本地列表操作方法一致。  

tx1.list_remove(var,data)          #把云对象var列表对象进行列表的remove操作，同本地列表操作方法一致。  

tx1.push("a","abc","test")         #向“test“信道发送消息

tx1.push_plus("a","abc","test")    #是push的升级版本，可以快速完成数据推送，使用前需要先start_plus()，该方法需要大于V4版本才能使用

````

# 简单使用示例
一、引用示例
```
from tx import *
tx1 = txl('192.168.1.65',2025,'LTtx')        #连接服务器 'LTtx'为认证的token,因服务端变化而变化。
tx1.start_tx()                               #开启put/get/push功能
tx1.start_txg("test")                        #开启接收信道"test"消息的功能，若不用可以不开启该功能，所有的数据通过tx1.Q.get()进行获取
tx1.push_plus("a","abc","test")    #是push的升级版本，可以快速完成数据推送，使用前需要先start_plus()，该方法需要大于V4版本才能使用

#关闭连接
tx1.close_tx()#关闭put功能。
tx1.close_txg()#关闭txg功能。

```

二、更多使用方法请参考example.py


# 特别说明
1、 客户端在使用时注意子线程的死循环，最好是加上0.1秒的延迟或者阻塞队列，不要让CPU空转导到客户端无法接收消息。
2、 为了方便在别的系统中使用，本代码不安装pandas，若要使用put_df功能，需要提前安装好pandas库，否则服务端会无法正常工作。


# 升级日志
#### 2024.9.7--------V7.0.4
1、新增save_json()和load_json()方法，用来保存json文件，注意传入的代码不要有numpy的数据格式，否则会报错，后续将会更新自适应方法。

2、新增proxy的静态方法，方便爬虫时更换IP地址进行访问。

3、更新了项目的架构并发布到pip中，现在已经可以通过pip直接安装使用。



#### 2024.4.16--------V7.0.0
1、新增tx.py的升级模式。    
2、更新代码开发辅助函数。   



#### 2024.4.10---------V6
1、put-get模式中增加保存dataframe的功能，对应put_df和get_df方法

2、调整LTtx服务端部署方式，新增Config.txt配置文件

3、引入Centos中守护进程功能，确保服务端高可用


#### 2023.11.6---------V5
1、新增python字典和列表操作方式，方便对云数据进行个性化处理，详情见上方函数说明


#### 2023.8.4---------V4
1、升级整体架构，原功能方法保持不变，提升高并发数据时数据的推送性能。

2、新增push_plus()方法，该方法是push()方法的升级版本，推送性能有2至3倍提升，更适合交易行情的推送。

3、新版本服务端将自动绑定CPU核心，默认会绑定最后一颗CPU核心以提升性能（有2倍左右的性能提升）

#### 2023.7.24---------V3
1、新增文件传输功能，支持文件上传和下载，云端文件保存目录在/file_data/路径中，文件传输为单次短连接，传输完成后会有MD5校验，但没有重传机制。

2、更新内部代码逻辑，在put时可以传入基础的Python对象（只要是Json库支持的即可，例如字典，列表等，但不支持dataframe，如果要保存dataframe请先将dataframe转为字典进行保存，然后再通过
字典转dataframe完成存储）。注意，当传入一个字典对象时，通过get得到的将是一个字典对象，不再是字符串。这也意味着不用每次云变量赋值时进行json.dumps()操作。

3、新增基础的云变量量字典对象操作，详请见方法说明dict_change(var,key,value)。

4、新增基础的列表操作方法list_pop()和list_remove(),原理和正常的操作一样。


#### 2023.7.13---------V2

1、升级服务端消息推送方式，防止因为单个客户端不能接受消息而造成其他客户端不能收到消息，这主要是在大通量数据推送时会发生。

#### 2023.6.1---------V1.1  
1、新增多信道订阅，在start_txg()时传入"hq_center@cb_hq_center"表示同时订阅hq_center信道和cb_hq_center信道。

2、优化代码逻辑，防止粘包。

# 待开发功能


1、开发配套同步程序，该程序会使各个LTtx数据中心的新增云变量保持一致，为分布式部署提供保障，防止因为单个服务端故障后影响其他程序正常运行。

2、新增信道取消功能。

3、其他。

4、升级服务端为异步版本，进一步提升性能。


# 联系作者
1、作者微信
- zlt19950214       

2、作者邮箱 
- 445646258@qq.com


# 作者其他项目
1、天行量化系统
- http://dm.zltnet.top  

- http://txquant.cn



