import json
import pathlib

import pandas as pd
from webviz_config.webviz_store import webvizstore
from webviz_config.common_cache import CACHE


@CACHE.memoize(timeout=CACHE.TIMEOUT)
@webvizstore
def read_parquet(parq_file: pathlib.Path) -> pd.DataFrame:
    return pd.read_parquet(parq_file)


@CACHE.memoize(timeout=CACHE.TIMEOUT)
@webvizstore
def read_csv(csv_file: pathlib.Path) -> pd.DataFrame:
    return pd.read_csv(csv_file)
