from ..exceptions import *

exceptions = {
    None: UnknownError,
    100: GeneralError,
    101: AccountBlocked,
    102: CardNotFound,
    103: NoCardSelected,
    104: CardAlreadyInAuction,
    105: NotEnoughCards,
    106: InconsistencyError,
    107: CardNotInAuction,
    108: MaxBidReached,
    109: CannotBidOwnCard,
    110: AlreadyHighestBidder,
    111: AuctionClosed,
    112: CardTypeQuery,
    113: CardTypeNotFound,
    114: CardTypeQueryDuplicate,
    115: NotOwnerError,
    116: AccessDenied,
    117: ServerMaintenance,
    118: NoCardsSpecified,
    119: NoOpponentSpecified,
    120: BattleNotAvailable,
    121: CannotAttackSelf,
    122: PlayerProtected,
    123: CaptchaRequired,
    124: PlayingOnAnotherDevice,
    125: OpponentNotFound,
    126: OpponentOutOfRange,
    127: OpponentDefenseEmpty,
    128: InvalidCaptcha,
    129: CardInUse,
    130: CardMarkedForSacrifice,
    131: MaxPowerReached,
    132: MaxEvolutionsExceeded,
    133: EvolveLimitExceeded,
    134: BuildingNotFound,
    135: MaxCardsAssigned,
    136: LiveBattleUnavailable,
    137: OpponentOffline,
    138: AlreadyInLiveBattle,
    139: OpponentBusy,
    140: CannotAttackTribeMate,
    141: BattleIdRequired,
    142: InconsistencyErrorUpdate,
    143: OperationTimeout,
    144: PlayerUnavailable,
    145: BattleNotFound,
    146: AttackerNotFound,
    147: DefenderNotFound,
    148: TribeNotFound,
    149: NotInTribe,
    150: TribeHelpLimit,
    151: MessageSizeExceeded,
    152: MessageNotFound,
    153: InvalidInvitationTicket,
    154: InvalidRestoreKey,
    155: AccountChangeLimit,
    156: IdentificationRequired,
    157: PlayerNotFound,
    158: InvitationCodeAlreadyRedeemed,
    159: InvalidEmail,
    160: EmailAlreadyExists,
    161: EmailAlreadyRegistered,
    162: RewardAlreadyReceived,
    163: AccountDeactivated,
    164: AccountResetFailed,
    165: InvalidActivationCode,
    166: CashRewardNotFound,
    167: AvatarNotAvailable,
    168: NotInLeague,
    169: DeviceVerificationError,
    170: StoreNotSupported,
    171: PackInconsistencyError,
    172: PaymentReceiptNotProvided,
    173: CardCannotEvolve,
    174: InternalError,
    175: InternalErrorWait,
    176: PlayerNotParticipated,
    177: CardCoolingDown,
    178: CardCoolEnough,
    179: DeviceInconsistency,
    180: NameTooLong,
    181: NameAlreadyTaken,
    182: CountryCodeNotSupported,
    183: NotEnoughGold,
    184: OnlineOnAnotherDevice,
    185: TribeNameTooLong,
    186: TopTribeEditLimit,
    187: CannotSellCard,
    188: StatusRequired,
    189: TribeNotFound,
    190: NameRequired,
    191: DescriptionRequired,
    192: DescriptionTooLong,
    193: TribeNameExists,
    194: InvalidChiefPlayers,
    195: AlreadyInTribe,
    196: NoTribeBuilding,
    197: MaxTribeChangeLimit,
    198: TribeNoMembers,
    199: UndecidedRequest,
    200: InvalidDecisionParameter,
    201: NotJoinRequest,
    202: InconsistentDataProvided,
    203: JoinRequestProcessed,
    204: TribeFull,
    205: TribeAccessDenied,
    206: PlayerAlreadyInTribe,
    207: NotAnInvitation,
    208: InvitationProcessed,
    209: NoTribesAvailable,
    210: PlayerNotInYourTribe,
    211: PlayerAlreadyPromoted,
    212: PlayerNotElder,
    213: SelfPoke,
    214: NotAMemberOfTribe,
    215: SelfKick,
    216: InsufficientPermission,
    217: MaxLevelCooldownBuilding,
    218: MaxLevelMainHallBuilding,
    219: MaxLevelDefenseBuilding,
    220: MaxLevelOffenseBuilding,
    221: MaxLevelGoldBuilding,
    222: MaxLevelBankBuilding,
    223: InvalidBuildingTypeForUpgrade,
    224: MinimumDonationAmount,
    225: PlayerNoTribeBuilding,
    226: UndecidedInvitation,
    227: NotEnoughTribeMoney,
    228: TribeScoreUpdateFailed,
    229: TribeNoIdentifier,
    230: InvalidBuildingTypeForCardCapacity,
    231: OperationFailed,
    232: GooglePlayVerificationFailed,
    233: InvalidPurchaseState,
    234: DataReadingError,
    235: SibcheVerificationFailed,
    236: MaxBoostsLimit,
    237: InvalidCountryCode,
    238: UserNotFound,
    239: UserRecentlyPoked,
    240: LeagueUpdateInProgress,
    241: FeatureNotImplemented,
    242: InvalidLeagueId,
    243: TribeHelpAlreadyInProgress,
    244: NameRequired,
    245: TutorialUpdateParameters,
    246: NoTribeAvailableToCoach,
    247: NotEnoughNectar,
    248: HeroItemNotPurchased,
    249: HeroItemAlreadyPurchased,
    250: AllHeroesPurchased,
    251: NotEnoughPotion,
    252: InvalidGiftCode,
    253: GiftCodeAlreadyRedeemed,
    254: GiftCodeExpired,
    255: HeroLevelRequirement,
    256: TribeEntryNotAllowed,
    257: LevelRequirement,
    258: PrizeAlreadyReceived,
    259: InvalidMobileNumber,
    260: InvalidVerificationCode,
    261: NotSubscribed,
    262: NotCharged,
    263: LevelRequirementAgain,
    264: MaxTribeBroadcastReached,
    265: BundlePurchaseError,
    429: TooManyRequests
}

errors = {
    100: "An unexpected error occurred, please try again. If problem persists, be sure to let us know.",
    101: "Your account is blocked.",
    102: "Card not found.",
    103: "You should choose at least one card!",
    104: "Card is already in auction.",
    105: "Not enough cards.",
    106: "An inconsistency error is occured about your action, please try again. If problem persists, be sure to let us know.",
    107: "Card not found in auctions.",
    108: "You cannot bid on this item, it's already reached the maximum price.",
    109: "You cannot bid on your own cards.",
    110: "You are already the highest bidder.",
    111: "Too late! Auction is closed.",
    112: "What kind of card should I look for?",
    113: "We cannot find the card type selected.",
    114: "What kind of card should I look for?",
    115: "You are not the owner. Cannot proceed.",
    116: "Access denied.",
    117: "Server is in maintenance. We will be available soon.",
    118: "You need to specify some cards for this operation.",
    119: "You need to specify an opponent for this operation.",
    120: "You cant start the battle right now, please try again. If problem persists, be sure to let us know.",
    121: "You cannot attack yourself.",
    122: "Player is protected by shield, wait a few hours before attacking them again.",
    123: "You have to enter captcha code to proceed.",
    124: "You are currently playing on another device, please close the game on other devices and try again in a few seconds.",
    125: "Opponent not found.",
    126: "Opponent not in your range.",
    127: "Opponent's defence deck is empty.",
    128: "Captcha is invalid.",
    129: "Card is used in one of your buildings and cannot be used here.",
    130: "Card is already marked for sacrifice.",
    131: "Card has reached its maximum power.",
    132: "Cannot evolve more than two cards.",
    133: "Only two cards of the same type can be evolved.",
    134: "We cannot find the selected building. Please update to the latest version and try again.",
    135: "You cannot assigned any more cards to this building.",
    136: "Live-battle is not available due to some inconsistencies. We will be available soon.",
    137: "Opponent is no longer online.",
    138: "Already in live-battle.",
    139: "Opponent is busy.",
    140: "You cannot attack your tribemate.",
    141: "Battle ID required.",
    142: "An inconsistency error is occured. Please update your game to the latest version and try again.",
    143: "The operation is timed out. Please try again.",
    144: "Player is not available right now. Please try again in a moment.",
    145: "Battle not found. Please try again.",
    146: "Attacker not found. Please try again.",
    147: "Defender not found. Please try again.",
    148: "Tribe not found. Please try again.",
    149: "You are not in a tribe.",
    150: "Your tribe cannot use help for not conforming to the tribe member limitation rule.",
    151: "Message size exceeded.",
    152: "Message not found.",
    153: "Invalid invitation ticket.",
    154: "You have entered an invalid restore key. Please contact customer care for more information.",
    155: "You cannot change your account more than once a day.",
    156: "We need your name or restore key for your identification.",
    157: "Player not found, please try again. If problem persists, be sure to let us know.",
    158: "You have already redeemed an invitation code.",
    159: "Please enter a valid e-Mail address.",
    160: "e-Mail already exists.",
    161: "You have already registered a valid e-Mail address.",
    162: "You have already received this reward.",
    163: "Your account is deactivated.",
    164: "Account reset failed.",
    165: "Your activation code is invalid. Please contact customer care for more information.",
    166: "The specified cash reward cannot be found.",
    167: "Avatar is not available. Please try another one.",
    168: "You are not in a league.",
    169: "We are having trouble to verify your device. Please contact customer care for more information.",
    170: "The selected store is not supported yet.",
    171: "An inconsistency occured about your selected pack. Please restart your game and try again.",
    172: "The receipt for your payment is not provided. If the problem persists, please contact customer care.",
    173: "You cannot evolve this card further.",
    174: "An internal error is occured. We are trying to fix it ASAP.",
    175: "An internal error is occured. Please wait for a moment and try again.",
    176: "Player did not participate in this battle.",
    177: "Card is cooling down and unavailable right now.",
    178: "Card is cool enough.",
    179: "There is an inconsistency about your device. Please contact customer care for more information.",
    180: "Name is too long. You can specify %s characters for your name.",
    181: "Name is already taken.",
    182: "Your selected country code is not supported yet.",
    183: "You need %s more gold.",
    184: "You are currently online on another device.",
    185: "Tribe name cannot exceed 30 characters.",
    186: "Top 25 tribes cannot edit their information.",
    187: "You cannot sell crystal or hero cards.",
    188: "You need to specify a status!",
    189: "Tribe not found.",
    190: "Name Required.",
    191: "Description Required.",
    192: "Description is Too Lang.",
    193: "A tribe with the same name already exists.",
    194: "Invalid chief players for tribe id %1",
    195: "You are already a member of this tribe.",
    196: "You do not have the tribe building yet.",
    197: "You have reached the maximum tribe change limitation.",
    198: "Inconsistency exception! Tribe has no members.",
    199: "You already have an undecided request.",
    200: "Invalid decision parameter. Please try again.",
    201: "This is not a join request. Please contact customer care for more information.",
    202: "Inconsistent Data Provided, please try again. If problem persists, be sure to let us know.",
    203: "Join request has already been processed.",
    204: "Tribe is full.",
    205: "Tribe access permission denied.",
    206: "Player is already a member of this tribe.",
    207: "This is not an invitation.",
    208: "Invitation has already been processed.",
    209: "You do not have any tribes.",
    210: "Player is not in your tribe.",
    211: "Player is already promoted.",
    212: "Player is not an elder.",
    213: "You can not poke yourself.",
    214: "You are not a member of this tribe.",
    215: "You can not kick yourself.",
    216: "You dont have enough permission to do this operation.",
    217: "Maximum level reached for Cooldown building.",
    218: "Maximum level reached for Main Hall building.",
    219: "Maximum level reached for Defense building.",
    220: "Maximum level reached for Offense building.",
    221: "Maximum level reached for Gold building.",
    222: "Maximum level reached for Bank building.",
    223: "Invalid building type for upgrade.",
    224: "Minimum donation amount is %s golds.",
    225: "Player does not have the tribe building yet.",
    226: "User have an undecided invitation already.",
    227: "Not enough tribe money.",
    228: "Failed to update tribe score, please try again. If problem persists, be sure to let us know.",
    229: "Tribe has no identifier, please try again. If problem persists, be sure to let us know.",
    230: "Invalid building type for card capacity.",
    231: "Operation faild, please try again. If problem persists, be sure to let us know.",
    232: "Google Play verification failed.",
    233: "purchaseState is invalid. (%s)",
    234: "Problem reading data from server",
    235: "Sibche verification failed.",
    236: "You cannot buy more boosts.",
    237: "Invalid country code.",
    238: "User Not Found",
    239: "User has been recently poked.",
    240: "Updating league is in progress. Please wait.",
    241: "This feature is not implemented yet :)",
    242: "Operation failed (invalid league ID). Please contact customer care for more information.",
    243: "You should be fast! Your tribe mates are already helping",
    244: "You should write a name",
    245: "Tutorial updating requires more parameters",
    246: "No tribe available to coach, Try later",
    247: "You need %s more nectar.",
    248: "You've not bought this hero item.",
    249: "You've already bought this hero item.",
    250: "You've bought all of the heroes!",
    251: "You have not enough potion.",
    252: "Wrong gift code entered.",
    253: "You've already redeemed this gift code",
    254: "Gift code is expired.",
    255: "You need at least one hero with level %s or above.",
    256: "You can't enter this tribe. Try another one.",
    257: "You should reach at least level %s !",
    258: "You have got enough prize! Wait a little",
    259: "You should enter a valid mobile number!",
    260: "Not a valid verification code! Try again",
    261: "You are not subscribed! First subscribe then try again",
    262: "You are not charged! First get charged then try again",
    263: "You should reach at least level %s !",
    264: "You reached max tribe broadcast! Wait a while and try again",
    265: "Error occured in purchasing bundle. Please contact customer care."
}

mobile_models = (
    "Samsung Galaxy S22 Ultra",
    "Samsung Galaxy S21 FE",
    "Samsung Galaxy A52",
    "Samsung Galaxy A72",
    "Google Pixel 6 Pro",
    "Google Pixel 6",
    "Google Pixel 5a",
    "OnePlus 9 Pro",
    "OnePlus 9",
    "OnePlus Nord 2",
    "Xiaomi Mi 11 Ultra",
    "Xiaomi Mi 11",
    "Xiaomi Redmi Note 11 Pro",
    "Xiaomi Poco F3",
    "Huawei P50 Pro",
    "Huawei Mate 40 Pro",
    "Huawei Nova 9",
    "Oppo Find X5 Pro",
    "Oppo Reno 7 Pro",
    "Motorola Edge 20 Pro",
    "Motorola Moto G Stylus 2022",
    "Sony Xperia 1 III",
    "Sony Xperia 5 III",
    "Nokia X20",
    "Nokia G50",
    "Realme GT 2 Pro",
    "Realme 8 Pro",
    "Vivo X70 Pro",
    "Vivo V21 5G",
    "Asus ROG Phone 5",
    "Asus Zenfone 8",
    "TCL 20 Pro 5G",
    "ZTE Axon 20 5G",
    "Honor 50 Pro",
    "Honor 50",
    "Infinix Zero 5G",
    "Lava Agni 5G",
    "Micromax IN Note 2"
)
