"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const __1 = require("../..");
const automation_document_1 = require("../../document/automation-document");
// eslint-disable-next-line
const yaml = require('js-yaml');
/**
 * This AutomationDocument supports declaring your document from an existing document (JSON/YAML String/File).
 * Importing an existing file allows for benefiting from the simulated execution.
 * The simulated execution will run locally in the same fashion that SSM Execution would run the document.
 * You can supply mocks to the simulator and validate the calls and the flow of the document without running via SSM execution.
 */
class StringDocument {
    /**
       * Create an AutomationDocument from an existing AutomationDocument yaml or json file.
       * Note: This function will deduce whether the file is written in yaml or json based on whether it has a .yaml or .yml extention.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromFile(stack, id, documentFilePath) {
        const contents = fs.readFileSync(documentFilePath, 'utf8');
        if (documentFilePath.endsWith('yaml') || documentFilePath.endsWith('yml')) {
            return StringDocument.fromYaml(stack, id, contents);
        }
        else {
            return StringDocument.fromJson(stack, id, contents);
        }
    }
    /**
       * Create an AutomationDocument from an existing yaml string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromYaml(stack, id, documentYaml) {
        return StringDocument.toAutomationDoc(stack, id, { ...yaml.load(documentYaml), documentFormat: __1.DocumentFormat.YAML });
    }
    /**
       * Create an AutomationDocument from an existing json string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromJson(stack, id, documentJson) {
        return StringDocument.toAutomationDoc(stack, id, { ...JSON.parse(documentJson), documentFormat: __1.DocumentFormat.JSON });
    }
    // This must be static because it is called prior to the super call in the constructor
    static toDocProps(id, params) {
        return {
            documentName: id,
            docInputs: this.toDocInputs(params.parameters),
            ...params,
        };
    }
    static toDocInputs(parameters) {
        return Object.entries(parameters).map(entry => this.toDocInput(entry[0], entry[1]));
    }
    static toDocInput(inputName, inputData) {
        const inputType = __1.DataType.fromDataType(inputData.type).dataTypeEnum;
        const inputProps = {
            name: inputName,
            inputType,
            defaultValue: inputData.default,
            ...inputData,
        };
        return __1.Input.ofSpecifiedType(inputType, inputName, inputProps);
    }
    static toAutomationDoc(stack, id, params) {
        const docProps = StringDocument.toDocProps(id, params);
        const doc = new automation_document_1.AutomationDocument(stack, id, docProps);
        const steps = params.mainSteps;
        steps.forEach(step => {
            doc.addStep(__1.StringStep.fromObject(stack, step));
        });
        return doc;
    }
}
exports.StringDocument = StringDocument;
_a = JSII_RTTI_SYMBOL_1;
StringDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.StringDocument", version: "0.0.22" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RyaW5nLWRvY3VtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3BhdHRlcm5zL2RvY3VtZW50L3N0cmluZy1kb2N1bWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlCQUF5QjtBQUV6Qiw2QkFBb0U7QUFDcEUsNEVBQWlHO0FBQ2pHLDJCQUEyQjtBQUMzQixNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUM7QUFFaEM7Ozs7O0dBS0c7QUFDSCxNQUFhLGNBQWM7SUFFekI7Ozs7U0FJSztJQUNFLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsZ0JBQXdCO1FBQzNFLE1BQU0sUUFBUSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDM0QsSUFBSSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQUksZ0JBQWdCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3pFLE9BQU8sY0FBYyxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ3JEO2FBQU07WUFDTCxPQUFPLGNBQWMsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUMsQ0FBQztTQUNyRDtJQUNILENBQUM7SUFFRDs7O1NBR0s7SUFDRSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFlBQW9CO1FBQ3ZFLE9BQU8sY0FBYyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLGNBQWMsRUFBRSxrQkFBYyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7SUFDeEgsQ0FBQztJQUVEOzs7U0FHSztJQUNFLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsWUFBb0I7UUFDdkUsT0FBTyxjQUFjLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEVBQUUsY0FBYyxFQUFFLGtCQUFjLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUN6SCxDQUFDO0lBRUQsc0ZBQXNGO0lBQzlFLE1BQU0sQ0FBQyxVQUFVLENBQUMsRUFBVSxFQUFFLE1BQTZCO1FBQ2pFLE9BQU87WUFDTCxZQUFZLEVBQUUsRUFBRTtZQUNoQixTQUFTLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDO1lBQzlDLEdBQUcsTUFBTTtTQUNWLENBQUM7SUFDSixDQUFDO0lBRU8sTUFBTSxDQUFDLFdBQVcsQ0FBQyxVQUFpQztRQUMxRCxPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0RixDQUFDO0lBRU8sTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFpQixFQUFFLFNBQWdDO1FBQzNFLE1BQU0sU0FBUyxHQUFHLFlBQVEsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLFlBQVksQ0FBQztRQUNyRSxNQUFNLFVBQVUsR0FBRztZQUNqQixJQUFJLEVBQUUsU0FBUztZQUNmLFNBQVM7WUFDVCxZQUFZLEVBQUUsU0FBUyxDQUFDLE9BQU87WUFDL0IsR0FBRyxTQUFTO1NBQ2IsQ0FBQztRQUNGLE9BQU8sU0FBSyxDQUFDLGVBQWUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBQ2pFLENBQUM7SUFFTyxNQUFNLENBQUMsZUFBZSxDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTZCO1FBQ3hGLE1BQU0sUUFBUSxHQUFHLGNBQWMsQ0FBQyxVQUFVLENBQUMsRUFBRSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZELE1BQU0sR0FBRyxHQUFHLElBQUksd0NBQWtCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUN4RCxNQUFNLEtBQUssR0FBNEIsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUN4RCxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQ25CLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBVSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNsRCxDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQzs7QUFoRUgsd0NBa0VDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZnMgZnJvbSAnZnMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEYXRhVHlwZSwgRG9jdW1lbnRGb3JtYXQsIElucHV0LCBTdHJpbmdTdGVwIH0gZnJvbSAnLi4vLi4nO1xuaW1wb3J0IHsgQXV0b21hdGlvbkRvY3VtZW50LCBBdXRvbWF0aW9uRG9jdW1lbnRQcm9wcyB9IGZyb20gJy4uLy4uL2RvY3VtZW50L2F1dG9tYXRpb24tZG9jdW1lbnQnO1xuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG5jb25zdCB5YW1sID0gcmVxdWlyZSgnanMteWFtbCcpO1xuXG4vKipcbiAqIFRoaXMgQXV0b21hdGlvbkRvY3VtZW50IHN1cHBvcnRzIGRlY2xhcmluZyB5b3VyIGRvY3VtZW50IGZyb20gYW4gZXhpc3RpbmcgZG9jdW1lbnQgKEpTT04vWUFNTCBTdHJpbmcvRmlsZSkuXG4gKiBJbXBvcnRpbmcgYW4gZXhpc3RpbmcgZmlsZSBhbGxvd3MgZm9yIGJlbmVmaXRpbmcgZnJvbSB0aGUgc2ltdWxhdGVkIGV4ZWN1dGlvbi5cbiAqIFRoZSBzaW11bGF0ZWQgZXhlY3V0aW9uIHdpbGwgcnVuIGxvY2FsbHkgaW4gdGhlIHNhbWUgZmFzaGlvbiB0aGF0IFNTTSBFeGVjdXRpb24gd291bGQgcnVuIHRoZSBkb2N1bWVudC5cbiAqIFlvdSBjYW4gc3VwcGx5IG1vY2tzIHRvIHRoZSBzaW11bGF0b3IgYW5kIHZhbGlkYXRlIHRoZSBjYWxscyBhbmQgdGhlIGZsb3cgb2YgdGhlIGRvY3VtZW50IHdpdGhvdXQgcnVubmluZyB2aWEgU1NNIGV4ZWN1dGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0cmluZ0RvY3VtZW50IHtcblxuICAvKipcbiAgICAgKiBDcmVhdGUgYW4gQXV0b21hdGlvbkRvY3VtZW50IGZyb20gYW4gZXhpc3RpbmcgQXV0b21hdGlvbkRvY3VtZW50IHlhbWwgb3IganNvbiBmaWxlLlxuICAgICAqIE5vdGU6IFRoaXMgZnVuY3Rpb24gd2lsbCBkZWR1Y2Ugd2hldGhlciB0aGUgZmlsZSBpcyB3cml0dGVuIGluIHlhbWwgb3IganNvbiBiYXNlZCBvbiB3aGV0aGVyIGl0IGhhcyBhIC55YW1sIG9yIC55bWwgZXh0ZW50aW9uLlxuICAgICAqIFlvdSBjYW4gdXNlIHRoZSByZXR1cm5lZCBBdXRvbWF0aW9uRG9jdW1lbnQgdG8gcnVuIHNpbXVsYXRpb25zIGFzIHlvdSB3b3VsZCBvdGhlciBkb2N1bWVudHMgY3JlYXRlZCB1c2luZyB0aGlzIGxpYnJhcnkuXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUZpbGUoc3RhY2s6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgZG9jdW1lbnRGaWxlUGF0aDogc3RyaW5nKSB7XG4gICAgY29uc3QgY29udGVudHMgPSBmcy5yZWFkRmlsZVN5bmMoZG9jdW1lbnRGaWxlUGF0aCwgJ3V0ZjgnKTtcbiAgICBpZiAoZG9jdW1lbnRGaWxlUGF0aC5lbmRzV2l0aCgneWFtbCcpIHx8IGRvY3VtZW50RmlsZVBhdGguZW5kc1dpdGgoJ3ltbCcpKSB7XG4gICAgICByZXR1cm4gU3RyaW5nRG9jdW1lbnQuZnJvbVlhbWwoc3RhY2ssIGlkLCBjb250ZW50cyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBTdHJpbmdEb2N1bWVudC5mcm9tSnNvbihzdGFjaywgaWQsIGNvbnRlbnRzKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICAgKiBDcmVhdGUgYW4gQXV0b21hdGlvbkRvY3VtZW50IGZyb20gYW4gZXhpc3RpbmcgeWFtbCBzdHJpbmcuXG4gICAgICogWW91IGNhbiB1c2UgdGhlIHJldHVybmVkIEF1dG9tYXRpb25Eb2N1bWVudCB0byBydW4gc2ltdWxhdGlvbnMgYXMgeW91IHdvdWxkIG90aGVyIGRvY3VtZW50cyBjcmVhdGVkIHVzaW5nIHRoaXMgbGlicmFyeS5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tWWFtbChzdGFjazogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBkb2N1bWVudFlhbWw6IHN0cmluZykge1xuICAgIHJldHVybiBTdHJpbmdEb2N1bWVudC50b0F1dG9tYXRpb25Eb2Moc3RhY2ssIGlkLCB7IC4uLnlhbWwubG9hZChkb2N1bWVudFlhbWwpLCBkb2N1bWVudEZvcm1hdDogRG9jdW1lbnRGb3JtYXQuWUFNTCB9KTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIENyZWF0ZSBhbiBBdXRvbWF0aW9uRG9jdW1lbnQgZnJvbSBhbiBleGlzdGluZyBqc29uIHN0cmluZy5cbiAgICAgKiBZb3UgY2FuIHVzZSB0aGUgcmV0dXJuZWQgQXV0b21hdGlvbkRvY3VtZW50IHRvIHJ1biBzaW11bGF0aW9ucyBhcyB5b3Ugd291bGQgb3RoZXIgZG9jdW1lbnRzIGNyZWF0ZWQgdXNpbmcgdGhpcyBsaWJyYXJ5LlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Kc29uKHN0YWNrOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGRvY3VtZW50SnNvbjogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFN0cmluZ0RvY3VtZW50LnRvQXV0b21hdGlvbkRvYyhzdGFjaywgaWQsIHsgLi4uSlNPTi5wYXJzZShkb2N1bWVudEpzb24pLCBkb2N1bWVudEZvcm1hdDogRG9jdW1lbnRGb3JtYXQuSlNPTiB9KTtcbiAgfVxuXG4gIC8vIFRoaXMgbXVzdCBiZSBzdGF0aWMgYmVjYXVzZSBpdCBpcyBjYWxsZWQgcHJpb3IgdG8gdGhlIHN1cGVyIGNhbGwgaW4gdGhlIGNvbnN0cnVjdG9yXG4gIHByaXZhdGUgc3RhdGljIHRvRG9jUHJvcHMoaWQ6IHN0cmluZywgcGFyYW1zOiB7W25hbWU6IHN0cmluZ106IGFueX0pOiBBdXRvbWF0aW9uRG9jdW1lbnRQcm9wcyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRvY3VtZW50TmFtZTogaWQsXG4gICAgICBkb2NJbnB1dHM6IHRoaXMudG9Eb2NJbnB1dHMocGFyYW1zLnBhcmFtZXRlcnMpLFxuICAgICAgLi4ucGFyYW1zLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyB0b0RvY0lucHV0cyhwYXJhbWV0ZXJzOiB7W25hbWU6IHN0cmluZ106IGFueX0pOiBJbnB1dFtdIHtcbiAgICByZXR1cm4gT2JqZWN0LmVudHJpZXMocGFyYW1ldGVycykubWFwKGVudHJ5ID0+IHRoaXMudG9Eb2NJbnB1dChlbnRyeVswXSwgZW50cnlbMV0pKTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHRvRG9jSW5wdXQoaW5wdXROYW1lOiBzdHJpbmcsIGlucHV0RGF0YToge1tuYW1lOiBzdHJpbmddOiBhbnl9KTogSW5wdXQge1xuICAgIGNvbnN0IGlucHV0VHlwZSA9IERhdGFUeXBlLmZyb21EYXRhVHlwZShpbnB1dERhdGEudHlwZSkuZGF0YVR5cGVFbnVtO1xuICAgIGNvbnN0IGlucHV0UHJvcHMgPSB7XG4gICAgICBuYW1lOiBpbnB1dE5hbWUsXG4gICAgICBpbnB1dFR5cGUsXG4gICAgICBkZWZhdWx0VmFsdWU6IGlucHV0RGF0YS5kZWZhdWx0LFxuICAgICAgLi4uaW5wdXREYXRhLFxuICAgIH07XG4gICAgcmV0dXJuIElucHV0Lm9mU3BlY2lmaWVkVHlwZShpbnB1dFR5cGUsIGlucHV0TmFtZSwgaW5wdXRQcm9wcyk7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyB0b0F1dG9tYXRpb25Eb2Moc3RhY2s6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcGFyYW1zOiB7W25hbWU6IHN0cmluZ106IGFueX0pIHtcbiAgICBjb25zdCBkb2NQcm9wcyA9IFN0cmluZ0RvY3VtZW50LnRvRG9jUHJvcHMoaWQsIHBhcmFtcyk7XG4gICAgY29uc3QgZG9jID0gbmV3IEF1dG9tYXRpb25Eb2N1bWVudChzdGFjaywgaWQsIGRvY1Byb3BzKTtcbiAgICBjb25zdCBzdGVwczoge1tuYW1lOiBzdHJpbmddOiBhbnl9W10gPSBwYXJhbXMubWFpblN0ZXBzO1xuICAgIHN0ZXBzLmZvckVhY2goc3RlcCA9PiB7XG4gICAgICBkb2MuYWRkU3RlcChTdHJpbmdTdGVwLmZyb21PYmplY3Qoc3RhY2ssIHN0ZXApKTtcbiAgICB9KTtcbiAgICByZXR1cm4gZG9jO1xuICB9XG5cbn1cbiJdfQ==