"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SoftwareInventoryStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:softwareInventory
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-softwareinventory
 */
class SoftwareInventoryStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:softwareInventory';
        this.applications = props.applications;
        this.awsComponents = props.awsComponents;
        this.files = props.files;
        this.networkConfig = props.networkConfig;
        this.windowsUpdates = props.windowsUpdates;
        this.instanceDetailedInformation = props.instanceDetailedInformation;
        this.services = props.services;
        this.windowsRegistry = props.windowsRegistry;
        this.windowsRoles = props.windowsRoles;
        this.customInventory = props.customInventory;
    }
    /**
       * All Inputs for this command are optional.
       */
    listInputs() {
        const inputs = [
            this.applications,
            this.awsComponents,
            this.files,
            this.networkConfig,
            this.windowsUpdates,
            this.instanceDetailedInformation,
            this.services,
            this.windowsRegistry,
            this.windowsRoles,
            this.customInventory,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {};
        if (this.applications != null) {
            inputs.applications = this.applications;
        }
        if (this.awsComponents != undefined) {
            inputs.awsComponents = this.awsComponents;
        }
        if (this.files != undefined) {
            inputs.files = this.files;
        }
        if (this.networkConfig != undefined) {
            inputs.networkConfig = this.networkConfig;
        }
        if (this.windowsUpdates != undefined) {
            inputs.windowsUpdates = this.windowsUpdates;
        }
        if (this.instanceDetailedInformation != undefined) {
            inputs.instanceDetailedInformation = this.instanceDetailedInformation;
        }
        if (this.services != undefined) {
            inputs.services = this.services;
        }
        if (this.windowsRegistry != undefined) {
            inputs.windowsRegistry = this.windowsRegistry;
        }
        if (this.windowsRoles != undefined) {
            inputs.windowsRoles = this.windowsRoles;
        }
        if (this.customInventory != undefined) {
            inputs.customInventory = this.customInventory;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.SoftwareInventoryStep = SoftwareInventoryStep;
_a = JSII_RTTI_SYMBOL_1;
SoftwareInventoryStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.SoftwareInventoryStep", version: "0.0.22" };
//# sourceMappingURL=data:application/json;base64,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