"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationsStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:applications
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-applications
 */
class ApplicationsStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:applications';
        this.installAction = props.action;
        this.parameters = props.parameters;
        this.source = props.source;
        this.sourceHash = props.sourceHash;
    }
    listInputs() {
        const inputs = [
            this.installAction,
            this.parameters,
            this.source,
            this.sourceHash,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {
            action: this.installAction,
            source: this.source,
        };
        if (this.parameters != undefined) {
            inputs.parameters = this.parameters;
        }
        if (this.sourceHash != undefined) {
            inputs.sourceHash = this.sourceHash;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.ApplicationsStep = ApplicationsStep;
_a = JSII_RTTI_SYMBOL_1;
ApplicationsStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ApplicationsStep", version: "0.0.22" };
//# sourceMappingURL=data:application/json;base64,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