"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunCommandStep = exports.DocumentHashTypeVariable = exports.HardCodedDocumentHashType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedDocumentHashType extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedDocumentHashType = HardCodedDocumentHashType;
_a = JSII_RTTI_SYMBOL_1;
HardCodedDocumentHashType[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedDocumentHashType", version: "0.0.22" };
HardCodedDocumentHashType.SHA256 = new HardCodedDocumentHashType('Sha256');
HardCodedDocumentHashType.SHA1 = new HardCodedDocumentHashType('Sha1');
class DocumentHashTypeVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['Sha256', 'Sha1'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.DocumentHashTypeVariable = DocumentHashTypeVariable;
_b = JSII_RTTI_SYMBOL_1;
DocumentHashTypeVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.DocumentHashTypeVariable", version: "0.0.22" };
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
class RunCommandStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:runCommand';
        this.documentName = props.documentName;
        this.targets = props.targets;
        this.parameters = props.parameters;
        this.cloudWatchOutputConfig = props.cloudWatchOutputConfig;
        this.comment = props.comment;
        this.documentHash = props.documentHash;
        this.documentHashType = props.documentHashType;
        this.notificationConfig = props.notificationConfig;
        this.outputS3BucketName = props.outputS3BucketName;
        this.outputS3KeyPrefix = props.outputS3KeyPrefix;
        this.serviceRoleArn = props.serviceRoleArn;
        this.commandTimeoutSeconds = props.commandTimeoutSeconds;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
    }
    listOutputs() {
        return [{
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.CommandId',
                name: 'CommandId',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Status',
                name: 'Status',
            }, {
                outputType: __1.DataTypeEnum.INTEGER,
                selector: '$.ResponseCode',
                name: 'ResponseCode',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Output',
                name: 'Output',
            }];
    }
    listInputs() {
        const inputs = [
            this.documentName,
            this.targets,
            this.parameters,
            this.cloudWatchOutputConfig,
            this.comment,
            this.documentHash,
            this.documentHashType,
            this.notificationConfig,
            this.outputS3BucketName,
            this.outputS3KeyPrefix,
            this.serviceRoleArn,
            this.commandTimeoutSeconds,
            this.maxConcurrency,
            this.maxErrors,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            DocumentName: this.documentName,
            Parameters: this.parameters,
            CloudWatchOutputConfig: this.cloudWatchOutputConfig,
            Comment: this.comment,
            DocumentHash: this.documentHash,
            DocumentHashType: this.documentHashType,
            NotificationConfig: this.notificationConfig,
            OutputS3BucketName: this.outputS3BucketName,
            OutputS3KeyPrefix: this.outputS3KeyPrefix,
            ServiceRoleArn: this.serviceRoleArn,
            TimeoutSeconds: this.commandTimeoutSeconds,
            MaxConcurrency: this.maxConcurrency,
            MaxErrors: this.maxErrors,
        };
        if (this.targets?.resolveToStringList) {
            entryMap.InstanceIds = this.targets;
        }
        else {
            entryMap.Targets = this.targets;
        }
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print()));
    }
}
exports.RunCommandStep = RunCommandStep;
_c = JSII_RTTI_SYMBOL_1;
RunCommandStep[_c] = { fqn: "@cdklabs/cdk-ssm-documents.RunCommandStep", version: "0.0.22" };
//# sourceMappingURL=data:application/json;base64,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