import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IBooleanVariable } from '../../interface/variables/boolean-variable';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for CopyImageStep
 */
export interface CopyImageStepProps extends AutomationStepProps {
    /**
       * The region where the source AMI exists.
       */
    readonly sourceRegion: IStringVariable;
    /**
       * The AMI ID to copy from the source Region.
       */
    readonly sourceImageId: IStringVariable;
    /**
       * The name for the image.
       */
    readonly imageName: IStringVariable;
    /**
       * (Optional) A description of the image.
       */
    readonly imageDescription?: IStringVariable;
    /**
       * (Optional) Encrypt the target AMI.
       */
    readonly encrypted?: IBooleanVariable;
    /**
       * (Optional) The full Amazon Resource Name (ARN) of the AWS KMS key to use when encrypting the snapshots of an image during a copy operation.
       */
    readonly kmsKeyId?: IStringVariable;
    /**
       * (Optional) A unique, case-sensitive identifier that you provide to ensure request idempotency.
       */
    readonly clientToken?: IStringVariable;
}
/**
 * AutomationStep implemenation for aws:copyImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-copyimage.html
 */
export declare class CopyImageStep extends AutomationStep {
    readonly action: string;
    readonly sourceRegion: IStringVariable;
    readonly sourceImageId: IStringVariable;
    readonly imageName: IStringVariable;
    readonly imageDescription?: IStringVariable;
    readonly encrypted?: IBooleanVariable;
    readonly kmsKeyId?: IStringVariable;
    readonly clientToken?: IStringVariable;
    constructor(scope: Construct, id: string, props: CopyImageStepProps);
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
