import { IGenericVariable, GenericVariable, HardCodedValueBase } from './variable';
/**
 * StringList type that can be null
 */
export declare type NullableStringList = string[];
/**
 * A string list variable
 */
export interface IStringListVariable extends IGenericVariable {
    /**
       * Given the execution inputs, return the resolved value of this variable.
       * @param inputs are the execution inputs.
       */
    resolveToStringList(inputs: Record<string, any>): NullableStringList;
}
/**
 * A hard-coded string list variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedStringList extends HardCodedValueBase<string[]> implements IStringListVariable {
    static of(val: string[]): HardCodedStringList;
    resolveToStringList(inputs: Record<string, any>): NullableStringList;
    protected assertType(value: any): void;
}
/**
 * A string list variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class StringListVariable extends GenericVariable implements IStringListVariable {
    static of(reference: string): StringListVariable;
    resolveToStringList(inputs: Record<string, any>): NullableStringList;
    protected assertType(value: any): void;
}
/**
 * Assert that the given value is a NullableStringList.
 * @param value value to assert
 */
export declare function assertStringList(value: any): asserts value is NullableStringList;
/**
 * Whether the given value is a NullableStringList.
 * @param value value to check
 * @returns true if the value is a NullableStringList, otherwise false
 */
export declare function isStringList(value: any): value is NullableStringList;
