<div align="center">
  <img src="./docs/logo.png" width="600"/>
</div>
<br />

[![docs](https://img.shields.io/badge/docs-latest-blue)](https://pytoydl.readthedocs.io/zh/latest/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pytoydl)](https://pypi.org/project/pytoydl/)
[![PyPI](https://img.shields.io/pypi/v/pytoydl)](https://pypi.org/project/pytoydl)
[![license](https://img.shields.io/github/license/CharlesPikachu/pytoydl.svg)](https://github.com/CharlesPikachu/pytoydl/blob/master/LICENSE)
[![PyPI - Downloads](https://pepy.tech/badge/pytoydl)](https://pypi.org/project/pytoydl/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/pytoydl?style=flat-square)](https://pypi.org/project/pytoydl/)
[![issue resolution](https://isitmaintained.com/badge/resolution/CharlesPikachu/pytoydl.svg)](https://github.com/CharlesPikachu/pytoydl/issues)
[![open issues](https://isitmaintained.com/badge/open/CharlesPikachu/pytoydl.svg)](https://github.com/CharlesPikachu/pytoydl/issues)

Documents: https://pytoydl.readthedocs.io/zh/latest/


# Pytoydl
```
A toy deep learning framework built upon numpy.
You can star this repository to keep track of the project if it's helpful for you, thank you for your support.
```


# Tutorial

- [从零开始实现一个深度学习框架 | 打好基础篇](https://mp.weixin.qq.com/s/ROgnJ1FlpYBvg6aFTTo_Qw)
- [从零开始实现一个深度学习框架 | 打造基础学习框架篇]() 
	- [本期实战案例相关代码](./examples/v0.0.1)


# Install

#### Pip install
```
run "pip install pytoydl"
```

#### Source code install
```sh
(1) Offline
Step1: git clone https://github.com/CharlesPikachu/pytoydl.git
Step2: cd pytoydl -> run "python setup.py install"
(2) Online
run "pip install git+https://github.com/CharlesPikachu/pytoydl.git@master"
```


# Projects in Charles_pikachu
- [Games](https://github.com/CharlesPikachu/Games): Create interesting games by pure python.
- [DecryptLogin](https://github.com/CharlesPikachu/DecryptLogin): APIs for loginning some websites by using requests.
- [Musicdl](https://github.com/CharlesPikachu/musicdl): A lightweight music downloader written by pure python.
- [Videodl](https://github.com/CharlesPikachu/videodl): A lightweight video downloader written by pure python.
- [Pytools](https://github.com/CharlesPikachu/pytools): Some useful tools written by pure python.
- [PikachuWeChat](https://github.com/CharlesPikachu/pikachuwechat): Play WeChat with itchat-uos.
- [Pydrawing](https://github.com/CharlesPikachu/pydrawing): Beautify your image or video.
- [ImageCompressor](https://github.com/CharlesPikachu/imagecompressor): Image compressors written by pure python.
- [FreeProxy](https://github.com/CharlesPikachu/freeproxy): Collecting free proxies from internet.
- [Paperdl](https://github.com/CharlesPikachu/paperdl): Search and download paper from specific websites.
- [Sciogovterminal](https://github.com/CharlesPikachu/sciogovterminal): Browse "The State Council Information Office of the People's Republic of China" in the terminal.
- [CodeFree](https://github.com/CharlesPikachu/codefree): Make no code a reality.
- [DeepLearningToys](https://github.com/CharlesPikachu/deeplearningtoys): Some deep learning toys implemented in pytorch.
- [DataAnalysis](https://github.com/CharlesPikachu/dataanalysis): Some data analysis projects in charles_pikachu.
- [Imagedl](https://github.com/CharlesPikachu/imagedl): Search and download images from specific websites.


# More

#### WeChat Official Accounts

*Charles_pikachu*  
![img](./docs/pikachu.jpg)