# tm4j-reporter
TM4J (Zephyr Scale) Reporter
> Help you to update Test Management For Jira (named TM4J or Zephyr Scale) tests status, 
> only need provide automation framework output file.
> It will use case ID generated by the framework as unique TM4J case name, 
> and will create a new one if there is no the same case name. 
> This method will help you to auto manage automation test case into Jira.

[![Org](https://img.shields.io/static/v1?label=org&message=Truth%20%26%20Insurance%20Office&color=597ed9)](https://office.baoxian-sz.com)
![Author](https://img.shields.io/static/v1?label=author&message=v.stone@163.com&color=blue)
![License](https://img.shields.io/github/license/seoktaehyeon/tm4j-reporter)
[![python](https://img.shields.io/static/v1?label=Python&message=3.7&color=3776AB)](https://www.python.org)
[![PyPI](https://img.shields.io/pypi/v/tm4jReporter.svg)](https://pypi.org/project/tm4jReporter/)
[![Ref](https://img.shields.io/badge/ref-Zephr%20Scale%20Api%20Docs-informational)](https://support.smartbear.com/zephyr-scale-server/api-docs/v1/)

#### Support automation framework
- robotframework

#### Example
- Upload results into Zephyr Scale
```python
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Author: v.stone@163.com


from tm4jReporter import Tm4jReporter


rb = Tm4jReporter(
    jira_url='https://jira.xxx.com',
    jira_user='will',
    jira_pass='password',
    jira_project='TM4J'
)
rb.robotframework('output.xml')
```

- Upload results into Zephyr Scale Cycle
```python
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Author: v.stone@163.com


from tm4jReporter import Tm4jReporter


rb = Tm4jReporter(
    jira_url='https://jira.xxx.com',
    jira_user='will',
    jira_pass='password',
    jira_project='TM4J'
)
rb.robotframework(
    output_xml_file='output.xml', 
    cycle_key='TM4J-C1'
)
```
