# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mutation_profile']

package_data = \
{'': ['*']}

install_requires = \
['biopython>=1.70,<2.0', 'pandas>=1.4.3,<2.0.0', 'textwrap3>=0.9.2,<0.10.0']

entry_points = \
{'console_scripts': ['mutation-profile = mutation_profile.__main__:main']}

setup_kwargs = {
    'name': 'mutation-profile',
    'version': '0.1.0',
    'description': 'A bioinformatics solution to determine SNP flanking sequences and mutation profile',
    'long_description': '# Mutation profile\n\nThis tool was developed during Monkeypox 2022 outbreak to explore the mutational profiles/signatures of this virus, but can be of broad application to other species. It can be used to rapidly obtain the sequence context (size defined by the user) flanking SNPs of interest and determine their mutational profile according to the user\'s specifications (e.g. APOBEC3-mediated viral genome editing GA>AA and TC>TT replacements)\n\n## Input/Output of _get_mutation_profile.py_\n\t\t\t\t\t\t\t\t\t\n**OPTION1**   \n_Inputs:_    \n1. TSV file with the columns POS REF ALT (i.e. 1-indexed reference position, reference allele and alternative allele)\n2. Fasta file including the reference genome\n\n_Output:_    \n1. TSV file with the mutation context and profile\n\n**OPTION 2**     \n_Inputs:_   \n1. TSV file with the columns ID POS REF ALT (i.e. sample ID, 1-indexed reference position, reference allele and alternative allele)\n2. Fasta file including the reference genome\n\n_Outputs:_    \n1. TSV file with the mutation context and profile for each sample present in the TSV input\n2. TSV file with a summary report for each position of interest including the different patterns observed and their respective frequency\n\n_NOTE: For options 1 and 2 the order of the columns in the input 1 is not important but their name is (ID, POS, REF, ALT)!!_\n\n**OPTION 3**  \n_Inputs:_    \n1. Single-column file with a list of 1-indexed reference positions of interest   \n2. Multiple Sequence Alignment (fasta) including the reference genome    \n\t\t\t\t\t\t\t\t\t\n_Outputs:_     \n1. TSV file with the mutation context and profile for each sample present in the alignment\n2. TSV file with a summary report for each position of interest including the different patterns observed and their respective frequency\n\n_TIP: If you do not know your positions of interest, you can run the script _alignment_processing.py_ of [ReporTree](https://github.com/insapathogenomics/ReporTree) and it will provide a list of positions of interest according to your specifications._\n\n\n## Dependencies and installation\nTo run the _get_mutation_profile.py_ you will need:\n- biopython\n- pandas\n\n\n```\n\n## Usage\n\n```bash\n  -h, --help            show this help message and exit\n\nMutation profile:\n  Provide input/output specifications\n\n  -f FASTA, --fasta FASTA\n                        [MANDATORY] Input sequence file (fasta)\n  -m MUTATION, --mutation_list MUTATION\n                        [MANDATORY] Input mutation list that can be: 1)\n                        single-column file with 1-based reference position\n                        information (in this case the fasta file must be a\n                        multiple sequence alignment of all the sequences of\n                        interest); OR 2) tsv file with the columns POS, REF,\n                        and ALT where POS = 1-based reference position. If you\n                        want to include information for more than one sample\n                        per position, add also the column \'ID\' (note that the\n                        order of the columns is not important but their name\n                        is!)\n  -r REF, --reference REF\n                        [MANDATORY] Reference sequence name\n  -b BEFORE, --before BEFORE\n                        [OPTIONAL] Number of nucleotides to report BEFORE the\n                        mutation (default = 5)\n  -a AFTER, --after AFTER\n                        [OPTIONAL] Number of nucleotides to report AFTER the\n                        mutation (default = 5)\n  -p PROFILES, --profiles PROFILES\n                        [OPTIONAL] Comma-separated list of mutational profiles\n                        of interest (upper-case!). Default = \'GA>AA,TC>TT\'\n  -o OUTPUT, --output OUTPUT\n                        [OPTIONAL] Tag for output file name. Default =\n                        Mutation_profile\n```\n\n## Examples using Monkeypox 2022 outbreak data available at [_examples/_](https://github.com/insapathogenomics/mutation_profile/tree/main/examples)\n\n### Option 1 (this option reflects part of the analysis performed in the publication)\nProviding a TSV file with the columns POS REF ALT (i.e. 1-indexed reference position, reference allele and alternative allele) and a fasta file including the reference genome (can be the same alignment or a normal fasta sequence).\n\n```bash\npython get_mutation_profile.py -f alignment_Figure1B.fasta -m positions_of_interest_POS_REF_ALT.txt -r \'MT903344.1_Monkeypox_virus_isolate_MPXVUK_P2_complete_genome\' -b 10 -a 10 -o OPTION1\n```\n\n_Output:_    \n1. TSV file with the mutation context and profile\n<p align="center">\n\t<img width="636" alt="Captura de ecrã 2022-06-17, às 15 17 41" src="https://user-images.githubusercontent.com/19263468/174316512-056bb280-a89e-4d81-9ba3-6065f6a9a0f1.png">\n</p>\n\n### Option 2\nProviding a TSV file with the columns ID POS REF ALT (i.e. samples id, 1-indexed reference position, reference allele and alternative allele) and a fasta file including the reference genome (can be the same alignment or a normal fasta sequence).\n\n```bash\npython get_mutation_profile.py -f alignment_Figure1B.fasta -m positions_of_interest_ID_POS_REF_ALT.txt -r \'MT903344.1_Monkeypox_virus_isolate_MPXVUK_P2_complete_genome\' -b 10 -a 10 -o OPTION2\n```\n\n_Outputs:_    \n1. TSV file with the mutation context and profile for each sample present in the TSV input\n<p align="center">\n\t<img width="849" alt="Captura de ecrã 2022-06-17, às 15 21 20" src="https://user-images.githubusercontent.com/19263468/174317025-e090f7f8-17a4-4001-863f-cd965dfff9a6.png">\n</p>\n\n2. TSV file with a summary report for each position of interest including the different patterns observed and their respective frequency\n<p align="center">\n\t<img width="1145" alt="Captura de ecrã 2022-06-17, às 15 23 07" src="https://user-images.githubusercontent.com/19263468/174317375-d17183e8-0f9c-46a6-ab83-9f1e212c4854.png">\n</p>\n\n### Option 3\nProviding a single-column file with a list of 1-indexed reference positions of interest and a fasta Multiple Sequence Alignment including the reference genome.\n\n```bash\npython get_mutation_profile.py -f alignment_Figure1B.fasta -m Monkeypox_positions_of_interest.tsv -r \'MT903344.1_Monkeypox_virus_isolate_MPXVUK_P2_complete_genome\' -b 10 -a 10 -o OPTION3\n```\n\n_Outputs:_     \n1. TSV file with the mutation context and profile for each sample present in the alignment\n<p align="center">\n\t<img width="1106" alt="Captura de ecrã 2022-06-17, às 15 31 56" src="https://user-images.githubusercontent.com/19263468/174319330-2702cf97-af7d-44e9-b7ca-2bf2f0f612ed.png">\n</p>\n\n2. TSV file with a summary report for each position of interest including the different patterns observed and their respective frequency\n<p align="center">\n<img width="1359" alt="Captura de ecrã 2022-06-17, às 15 33 18" src="https://user-images.githubusercontent.com/19263468/174319340-d95fd034-a740-48f1-8cd5-53ea77e785e8.png">\t\n</p>\n\n_TIP: If you do not know your positions of interest, you can run the script _alignment_processing.py_ of [ReporTree](https://github.com/insapathogenomics/ReporTree) and it will provide a list of positions of interest according to your specifications. Example:_\n\n```bash\npython ReporTree/scripts/alignment_processing.py -align alignment_Figure1B.fasta -o Monkeypox --use-reference-coords -r \'MT903344.1_Monkeypox_virus_isolate_MPXVUK_P2_complete_genome\' --keep-gaps --get-positions-interest\n```\n\n## Citation\n\nIf you use this tool please cite the article where it was first described:\n\nIsidro, J., Borges, V., Pinto, M. et al. (2022) Phylogenomic characterization and signs of microevolution in the 2022 multi-country outbreak of monkeypox virus. _Nature Medicine_. https://doi.org/10.1038/s41591-022-01907-y\n',
    'author': 'Veronica Mixao',
    'author_email': 'vmixao@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/insapathogenomics/mutation_profile',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
