"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelinePyProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
const python_1 = require("projen/lib/python");
/**
 * Synthesizes a Python Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-py
 */
class PDKPipelinePyProject extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        super({
            github: false,
            sample: false,
            pytest: false,
            ...options,
            appEntrypoint: options.appEntrypoint || `${options.moduleName}/pipeline.py`,
        });
        ["aws_prototyping_sdk", "cdk-nag", "pyhumps"].forEach((dep) => this.addDependency(dep));
        this.addDevDependency("pytest");
        new projen_1.SampleDir(this, this.moduleName, {
            sourceDir: path.join(__dirname, "..", "samples", "python", "infra"),
        });
        this.pytest = new python_1.Pytest(this, options.pytestOptions);
        new projen_1.SampleDir(this, this.testdir, {
            files: {
                "__init__.py": "",
                "test_pipeline.py": fs
                    .readFileSync(path.join(__dirname, "..", "samples", "python", "tests", "test_pipeline.py"))
                    .toString()
                    .replace("infra.", `${this.moduleName}.`),
            },
        });
    }
}
exports.PDKPipelinePyProject = PDKPipelinePyProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelinePyProject[_a] = { fqn: "@aws-prototyping-sdk/pipeline.PDKPipelinePyProject", version: "0.11.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGRrLXBpcGVsaW5lLXB5LXByb2plY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGRrLXBpcGVsaW5lLXB5LXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7Ozs7d0hBY3dIO0FBRXhILHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFDN0IsbUNBQW1DO0FBQ25DLDhDQUE0RTtBQUM1RSw4Q0FBMkM7QUFPM0M7Ozs7R0FJRztBQUNILE1BQWEsb0JBQXFCLFNBQVEsd0JBQWU7SUFDdkQsWUFBWSxPQUFvQztRQUM5QyxLQUFLLENBQUM7WUFDSixNQUFNLEVBQUUsS0FBSztZQUNiLE1BQU0sRUFBRSxLQUFLO1lBQ2IsTUFBTSxFQUFFLEtBQUs7WUFDYixHQUFHLE9BQU87WUFDVixhQUFhLEVBQ1gsT0FBTyxDQUFDLGFBQWEsSUFBSSxHQUFHLE9BQU8sQ0FBQyxVQUFVLGNBQWM7U0FDL0QsQ0FBQyxDQUFDO1FBRUgsQ0FBQyxxQkFBcUIsRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FDNUQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FDeEIsQ0FBQztRQUVGLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUVoQyxJQUFJLGtCQUFTLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDbkMsU0FBUyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQztTQUNwRSxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksZUFBTSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFdEQsSUFBSSxrQkFBUyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2hDLEtBQUssRUFBRTtnQkFDTCxhQUFhLEVBQUUsRUFBRTtnQkFDakIsa0JBQWtCLEVBQUUsRUFBRTtxQkFDbkIsWUFBWSxDQUNYLElBQUksQ0FBQyxJQUFJLENBQ1AsU0FBUyxFQUNULElBQUksRUFDSixTQUFTLEVBQ1QsUUFBUSxFQUNSLE9BQU8sRUFDUCxrQkFBa0IsQ0FDbkIsQ0FDRjtxQkFDQSxRQUFRLEVBQUU7cUJBQ1YsT0FBTyxDQUFDLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxVQUFVLEdBQUcsQ0FBQzthQUM1QztTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBekNILG9EQTBDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblxuIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuXG4gaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG5cbiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsIHNvZnR3YXJlXG4gZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9ucyBhbmRcbiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiAqL1xuXG5pbXBvcnQgKiBhcyBmcyBmcm9tIFwiZnNcIjtcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IFNhbXBsZURpciB9IGZyb20gXCJwcm9qZW5cIjtcbmltcG9ydCB7IEF3c0Nka1B5dGhvbkFwcCwgQXdzQ2RrUHl0aG9uQXBwT3B0aW9ucyB9IGZyb20gXCJwcm9qZW4vbGliL2F3c2Nka1wiO1xuaW1wb3J0IHsgUHl0ZXN0IH0gZnJvbSBcInByb2plbi9saWIvcHl0aG9uXCI7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBvcHRpb25zIGZvciB0aGUgUERLUGlwZWxpbmVQeVByb2plY3QuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUERLUGlwZWxpbmVQeVByb2plY3RPcHRpb25zIGV4dGVuZHMgQXdzQ2RrUHl0aG9uQXBwT3B0aW9ucyB7fVxuXG4vKipcbiAqIFN5bnRoZXNpemVzIGEgUHl0aG9uIFByb2plY3Qgd2l0aCBhIENJL0NEIHBpcGVsaW5lLlxuICpcbiAqIEBwamlkIHBkay1waXBlbGluZS1weVxuICovXG5leHBvcnQgY2xhc3MgUERLUGlwZWxpbmVQeVByb2plY3QgZXh0ZW5kcyBBd3NDZGtQeXRob25BcHAge1xuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBQREtQaXBlbGluZVB5UHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICBnaXRodWI6IGZhbHNlLFxuICAgICAgc2FtcGxlOiBmYWxzZSxcbiAgICAgIHB5dGVzdDogZmFsc2UsXG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgYXBwRW50cnlwb2ludDpcbiAgICAgICAgb3B0aW9ucy5hcHBFbnRyeXBvaW50IHx8IGAke29wdGlvbnMubW9kdWxlTmFtZX0vcGlwZWxpbmUucHlgLFxuICAgIH0pO1xuXG4gICAgW1wiYXdzX3Byb3RvdHlwaW5nX3Nka1wiLCBcImNkay1uYWdcIiwgXCJweWh1bXBzXCJdLmZvckVhY2goKGRlcCkgPT5cbiAgICAgIHRoaXMuYWRkRGVwZW5kZW5jeShkZXApXG4gICAgKTtcblxuICAgIHRoaXMuYWRkRGV2RGVwZW5kZW5jeShcInB5dGVzdFwiKTtcblxuICAgIG5ldyBTYW1wbGVEaXIodGhpcywgdGhpcy5tb2R1bGVOYW1lLCB7XG4gICAgICBzb3VyY2VEaXI6IHBhdGguam9pbihfX2Rpcm5hbWUsIFwiLi5cIiwgXCJzYW1wbGVzXCIsIFwicHl0aG9uXCIsIFwiaW5mcmFcIiksXG4gICAgfSk7XG5cbiAgICB0aGlzLnB5dGVzdCA9IG5ldyBQeXRlc3QodGhpcywgb3B0aW9ucy5weXRlc3RPcHRpb25zKTtcblxuICAgIG5ldyBTYW1wbGVEaXIodGhpcywgdGhpcy50ZXN0ZGlyLCB7XG4gICAgICBmaWxlczoge1xuICAgICAgICBcIl9faW5pdF9fLnB5XCI6IFwiXCIsXG4gICAgICAgIFwidGVzdF9waXBlbGluZS5weVwiOiBmc1xuICAgICAgICAgIC5yZWFkRmlsZVN5bmMoXG4gICAgICAgICAgICBwYXRoLmpvaW4oXG4gICAgICAgICAgICAgIF9fZGlybmFtZSxcbiAgICAgICAgICAgICAgXCIuLlwiLFxuICAgICAgICAgICAgICBcInNhbXBsZXNcIixcbiAgICAgICAgICAgICAgXCJweXRob25cIixcbiAgICAgICAgICAgICAgXCJ0ZXN0c1wiLFxuICAgICAgICAgICAgICBcInRlc3RfcGlwZWxpbmUucHlcIlxuICAgICAgICAgICAgKVxuICAgICAgICAgIClcbiAgICAgICAgICAudG9TdHJpbmcoKVxuICAgICAgICAgIC5yZXBsYWNlKFwiaW5mcmEuXCIsIGAke3RoaXMubW9kdWxlTmFtZX0uYCksXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=