"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class CloudFrontToS3 extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the CloudFrontToS3 class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToS3Props} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        [this.cloudFrontWebDistribution, this.cloudFrontFunction, this.cloudFrontLoggingBucket] =
            defaults.CloudFrontDistributionForS3(this, this.s3BucketInterface, props.cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.originPath, props.cloudFrontLoggingBucketProps, props.responseHeadersPolicyProps);
    }
}
exports.CloudFrontToS3 = CloudFrontToS3;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToS3[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-s3.CloudFrontToS3", version: "2.31.0" };
//# sourceMappingURL=data:application/json;base64,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