from typing import Any, Optional, TypeVar

from java.lang import Object, String
from java.util.function import Function, ToDoubleFunction, ToIntFunction, ToLongFunction

T = TypeVar("T")

class Comparator:
    def compare(self, o1: T, o2: T) -> int: ...
    @staticmethod
    def comparing(keyExtractor: Function, keyComparator: Comparator) -> Comparator: ...
    @staticmethod
    def comparingDouble(keyExtractor: ToDoubleFunction) -> Comparator: ...
    @staticmethod
    def comparingInt(keyExtractor: ToIntFunction) -> Comparator: ...
    @staticmethod
    def comparingLong(keyExtractor: ToLongFunction) -> Comparator: ...
    def equals(self, obj: Object) -> bool: ...
    @staticmethod
    def naturalOrder() -> Comparator: ...
    @staticmethod
    def nullsFirst(comparator: Comparator) -> Comparator: ...
    @staticmethod
    def nullsLast(comparator: Comparator) -> Comparator: ...
    def reversed(self) -> Comparator: ...
    @staticmethod
    def reverseOrder() -> Comparator: ...
    def thenComparing(self, *args: Any) -> Comparator: ...
    def thenComparingDouble(self, keyExtractor: ToDoubleFunction) -> Comparator: ...
    def thenComparingInt(self, keyExtractor: ToIntFunction) -> Comparator: ...
    def thenComparingLong(self, keyExtractor: ToLongFunction) -> Comparator: ...

class Date(Object):
    def __init__(self, date: Optional[long] = ...) -> None: ...
    def after(self, when: Date) -> bool: ...
    def before(self, when: Date) -> bool: ...
    def compareTo(self, anotherDate: Date) -> int: ...
    def getTime(self) -> long: ...
    def setTime(self, time: long) -> None: ...

class EventObject(Object):
    source: Object
    def __init__(self, source: Object) -> None: ...
    def getSource(self): ...

class Locale(Object):
    country: Optional[str]
    language: str
    variant: Optional[str]
    def __init__(
        self, language: str, country: Optional[str] = ..., variant: Optional[str] = ...
    ) -> None: ...
    def CANADA(self) -> Locale: ...
    def CANADA_FRENCH(self) -> Locale: ...
    def CHINA(self) -> Locale: ...
    def CHINESE(self) -> Locale: ...
    def ENGLISH(self) -> Locale: ...
    def FRANCE(self) -> Locale: ...
    def FRENCH(self) -> Locale: ...
    def GERMAN(self) -> Locale: ...
    def GERMANY(self) -> Locale: ...
    def ITALIAN(self) -> Locale: ...
    def ITALY(self) -> Locale: ...
    def JAPAN(self) -> Locale: ...
    def JAPANESE(self) -> Locale: ...
    def KOREA(self) -> Locale: ...
    def KOREAN(self) -> Locale: ...
    def PRC(self) -> Locale: ...
    def SIMPLIFIED_CHINESE(self) -> Locale: ...
    def TAIWAN(self) -> Locale: ...
    def TRADITIONAL_CHINESE(self) -> Locale: ...
    def UK(self) -> Locale: ...
    def US(self) -> Locale: ...

class UUID(Object):
    def __init__(self, mostSigBits: long, leastSigBits: long) -> None: ...
    def clockSequence(self) -> int: ...
    def compareTo(self, val: UUID) -> int: ...
    @staticmethod
    def fromString(name: String) -> UUID: ...
    def getLeastSignificantBits(self) -> long: ...
    def getMostSignificantBits(self) -> long: ...
    @staticmethod
    def nameUUIDFromBytes(name: bytearray) -> UUID: ...
    def node(self) -> long: ...
    @staticmethod
    def randomUUID() -> UUID: ...
    def timestamp(self) -> long: ...
    def variant(self) -> int: ...
    def version(self) -> int: ...
