from typing import Any, Iterator, List, TypeVar, Union

from java.lang import Class as Class
from java.lang import Enum as Enum
from java.lang import Object as Object
from java.lang import String as String

T = TypeVar("T")

class Watchable:
    def register(self, *args: Any) -> WatchKey: ...

class LinkOption(Enum):
    @staticmethod
    def values() -> List[LinkOption]: ...

class Path(Watchable):
    def compareTo(self, other: Path) -> int: ...
    def endsWith(self, other: Union[Object, Path, String]) -> bool: ...
    def equals(self, other: Object) -> bool: ...
    def getFileName(self) -> Path: ...
    def getName(self, index: int) -> Path: ...
    def getNameCount(self) -> int: ...
    def getParent(self) -> Path: ...
    def getRoot(self) -> Path: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def iterator(self) -> Iterator[Path]: ...
    def normalize(self) -> Path: ...
    @staticmethod
    def of(*args: Any) -> Path: ...
    def register(self, *args: Any) -> WatchKey: ...
    def relativize(self, other: Path) -> Path: ...
    def resolve(self, other: Union[Path, String]) -> Path: ...
    def resolveSibling(self, other: Path) -> Path: ...
    def startsWith(self, other: Path) -> bool: ...
    def subpath(self, beginIndex: int, endIndex: int) -> Path: ...
    def toAbsolutePath(self) -> Path: ...
    def toFile(self) -> Any: ...
    def toRealPath(self, *args: LinkOption) -> Path: ...
    def toString(self) -> String: ...
    def toUri(self) -> Any: ...

class WatchEvent:
    def context(self) -> T: ...
    def count(self) -> int: ...
    def kind(self) -> WatchEvent.Kind: ...

    class Kind:
        def name(self) -> String: ...
        def type(self) -> Class: ...

    class Modifier:
        def name(self) -> String: ...

class WatchKey:
    def cancel(self) -> None: ...
    def isValid(self) -> bool: ...
    def pollEvents(self) -> List[WatchEvent]: ...
    def reset(self) -> bool: ...
    def watchable(self) -> Watchable: ...
