from typing import Any, Dict, Optional, Union

from com.inductiveautomation.factorypmi.application import FPMIWindow
from java.awt import Component
from java.awt.image import BufferedImage
from java.lang import Object, String
from java.util import EventObject
from org.python.core import PyObject

class INavUtilities:
    def centerWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def getCurrentWindow(self) -> String: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: String, params: Dict[String, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: String, params: Dict[String, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class NavUtilities(INavUtilities):
    def centerWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def getCurrentWindow(self) -> String: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: String, params: Dict[String, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: String, params: Dict[String, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class PrintUtilities(Object):
    def __init__(self, app: Any) -> None: ...
    def createImage(self, c: Component) -> BufferedImage: ...
    def createPrintJob(self, c: Component) -> PrintUtilities.JythonPrintJob: ...
    def printToImage(self, c: Component, fileName: Optional[str] = ...) -> None: ...

    class JythonPrintJob(Object):
        def getBottomMargin(self) -> None: ...
        def getLeftMargin(self) -> None: ...
        def getOrientation(self) -> None: ...
        def getPageHeight(self) -> None: ...
        def getPageWidth(self) -> None: ...
        def getPrinterName(self) -> None: ...
        def getRightMargin(self) -> None: ...
        def getTopMargin(self) -> None: ...
        def getZoomFactor(self) -> None: ...
        def isFitToPage(self) -> None: ...
        def isShowPrintDialog(self) -> None: ...
        def setBottomMargin(self, bottomMargin) -> None: ...
        def setFitToPage(self, fitToPage) -> None: ...
        def setLeftMargin(self, leftMargin) -> None: ...
        def setMargins(self, m) -> None: ...
        def setOrientation(self, orientation) -> None: ...
        def setPageHeight(self, pageHeight) -> None: ...
        def setPageWidth(self, pageWidth) -> None: ...
        def setPrinterName(self, printerName) -> None: ...
        def setRightMargin(self, rightMargin) -> None: ...
        def setShowPrintDialog(self, showPrintDialog) -> None: ...
        def setZoomFactor(self, zoomFactor) -> None: ...

class WindowUtilities(Object):
    def confirm(self, *args) -> None: ...
    def errorBox(self, *args) -> None: ...
    def inputBox(self, *args) -> None: ...
    def messageBox(self, *args) -> None: ...
    def passwordBox(self, *args) -> None: ...
    def warningBox(self, *args) -> None: ...
